-- Author: Nerino1
-- Create Date : 12/28/2017
-- Version 7.3

local f=CreateFrame("frame");
f:RegisterEvent("PLAYER_LOGIN");
f:RegisterEvent("PLAYER_SPECIALIZATION_CHANGED");
f:RegisterEvent("QUEST_COMPLETE");
f:RegisterEvent("QUEST_FINISHED");

local level = UnitLevel("player")
local currentSpec = GetSpecialization()
local currentClass = select(2,UnitClass("player"))

table.insert(UISpecialFrames, "StatWindowFrame")
table.insert(UISpecialFrames, "StatWindowQuestFrame")

local function eventhandler(self,event)
	if event == "PLAYER_LOGIN" then
		if UnitLevel("player") <= 3 then
			statbtn:Hide()
			StatWindowFrame:Hide()
			StatWindowQuestFrame:Hide()
			do return end
		end
		--DEFAULT_CHAT_FRAME:AddMessage("Stat Priority Button Loaded.");
		StatWindowFrame:Hide()
		StatWindowQuestFrame:Hide()		
	end
	if event == "PLAYER_SPECIALIZATION_CHANGED" then
		currentSpec = GetSpecialization()
		GenerateStats()
	end
	if event == "QUEST_COMPLETE" then
		GenerateStats()
		StatWindowQuestFrame:Show()
	end
	if event == "QUEST_FINISHED" then
		StatWindowQuestFrame:Hide()
	end
end

f:SetScript("OnEvent",eventhandler);

local StatWindow = CreateFrame("frame","StatWindowFrame", PaperDollFrame)
StatWindow:SetBackdrop({
      bgFile="Interface\\DialogFrame\\UI-DialogBox-Background", 
      edgeFile="Interface\\DialogFrame\\UI-DialogBox-Border", 
      tile=1, tileSize=32, edgeSize=32, 
      insets={left=11, right=12, top=12, bottom=11}
})
StatWindow:SetWidth(215)
StatWindow:SetHeight(50)
StatWindow:SetPoint("BOTTOMRIGHT", 3, -40, PaperDollFrame)
StatWindow.text = StatWindow.text or
StatWindow:CreateFontString(nil,"OVERLAY","GameFontNormal")
StatWindow.text:SetAllPoints(true)
StatWindow.text:SetJustifyH("CENTER")
StatWindow.text:SetTextColor(1,1,1,1)
StatWindow.text:SetPoint("TOPLEFT",StatWindowFrame,"TOPLEFT",9,0)
StatWindow.text:SetPoint("BOTTOMRIGHT",StatWindowFrame,"BOTTOMRIGHT",-9,0)

local StatWindowQuest = CreateFrame("frame","StatWindowQuestFrame", QuestFrameRewardPanel)
StatWindowQuest:SetBackdrop({
	--bgFile="Interface\\DialogFrame\\UI-DialogBox-Background", 
	--edgeFile="Interface\\DialogFrame\\UI-DialogBox-Border", 
	tile=1, tileSize=18, edgeSize=10, 
	insets={left=11, right=12, top=12, bottom=11}
})
StatWindowQuest:SetWidth(215)
StatWindowQuest:SetHeight(50)
--StatWindowQuest:SetPoint("BOTTOMRIGHT", -45, -28, QuestFrameRewardPanel)
StatWindowQuest:SetPoint("TOPLEFT", 85, -18, QuestFrameRewardPanel)
StatWindowQuest.text = StatWindowQuest.text or
StatWindowQuest:CreateFontString(nil,"OVERLAY","GameFontNormal")
StatWindowQuest.text:SetAllPoints(true)
StatWindowQuest.text:SetJustifyH("CENTER")
StatWindowQuest.text:SetTextColor(1,1,1,1)


--StatWindow:EnableMouse(true)
--StatWindow:SetMovable(true)
--StatWindow:RegisterForDrag("LeftButton")
--StatWindow:SetScript("OnDragStart", function(self) self:StartMoving() end)
--StatWindow:SetScript("OnDragStop", function(self) self:StopMovingOrSizing() end)
--StatWindow:SetFrameStrata("FULLSCREEN_DIALOG")


local btn = CreateFrame("Button", "statbtn", PaperDollFrame, "OptionsButtonTemplate");
btn:SetPoint("BOTTOMRIGHT", -215, 10)
btn:SetText("Stat Priority")
btn:SetScript("OnClick", function() OpenStatWindow() end)

function OpenStatWindow()
	currentSpec = GetSpecialization()
	if StatWindowFrame:IsShown() then
		StatWindowFrame:Hide()
	else
		GenerateStats()
		StatWindowFrame:Show()
	end
end


function GenerateStats()
	if currentClass == "PALADIN" then
		if currentSpec == 1 then
			StatWindow.text:SetText(dataTable[1])
			StatWindowQuest.text:SetText(dataTable[1])
		elseif currentSpec == 2 then
			StatWindow.text:SetText(dataTable[2])
			StatWindowQuest.text:SetText(dataTable[2])
		elseif currentSpec == 3 then
			StatWindow.text:SetText(dataTable[3])
			StatWindowQuest.text:SetText(dataTable[3])
		end
	elseif	currentClass == "WARRIOR" then
		if currentSpec == 1 then
			StatWindow.text:SetText(dataTable[4])
			StatWindowQuest.text:SetText(dataTable[4])
		elseif currentSpec == 2 then
			StatWindow.text:SetText(dataTable[5])
			StatWindowQuest.text:SetText(dataTable[5])
		elseif currentSpec == 3 then
			StatWindow.text:SetText(dataTable[6])
			StatWindowQuest.text:SetText(dataTable[6])
		end
	elseif	currentClass == "HUNTER" then
		if currentSpec == 1 then
			StatWindow.text:SetText(dataTable[7])
			StatWindowQuest.text:SetText(dataTable[7])
		elseif currentSpec == 2 then
			StatWindow.text:SetText(dataTable[8])
			StatWindowQuest.text:SetText(dataTable[8])
		elseif currentSpec == 3 then
			StatWindow.text:SetText(dataTable[9])
			StatWindowQuest.text:SetText(dataTable[9])
		end
	elseif	currentClass == "ROGUE" then
		if currentSpec == 1 then
			StatWindow.text:SetText(dataTable[10])
			StatWindowQuest.text:SetText(dataTable[10])
		elseif currentSpec == 2 then
			StatWindow.text:SetText(dataTable[11])
			StatWindowQuest.text:SetText(dataTable[11])
		elseif currentSpec == 3 then
			StatWindow.text:SetText(dataTable[12])
			StatWindowQuest.text:SetText(dataTable[12])
		end
	elseif	currentClass == "PRIEST" then
		if currentSpec == 1 then
			StatWindow.text:SetText(dataTable[13])
			StatWindowQuest.text:SetText(dataTable[13])
		elseif currentSpec == 2 then
			StatWindow.text:SetText(dataTable[14])
			StatWindowQuest.text:SetText(dataTable[14])
		elseif currentSpec == 3 then
			StatWindow.text:SetText(dataTable[15])
			StatWindowQuest.text:SetText(dataTable[15])
		end
	elseif	currentClass == "DEATHKNIGHT" then
		if currentSpec == 1 then
			StatWindow.text:SetText(dataTable[16])
			StatWindowQuest.text:SetText(dataTable[16])
		elseif currentSpec == 2 then
			StatWindow.text:SetText(dataTable[17])
			StatWindowQuest.text:SetText(dataTable[17])
		elseif currentSpec == 3 then
			StatWindow.text:SetText(dataTable[18])
			StatWindowQuest.text:SetText(dataTable[18])
		end
	elseif	currentClass == "SHAMAN" then
		if currentSpec == 1 then
			StatWindow.text:SetText(dataTable[19])
			StatWindowQuest.text:SetText(dataTable[19])
		elseif currentSpec == 2 then
			StatWindow.text:SetText(dataTable[20])
			StatWindowQuest.text:SetText(dataTable[20])
		elseif currentSpec == 3 then
			StatWindow.text:SetText(dataTable[21])
			StatWindowQuest.text:SetText(dataTable[21])
		end
	elseif	currentClass == "MAGE" then
		if currentSpec == 1 then
			StatWindow.text:SetText(dataTable[22])
			StatWindowQuest.text:SetText(dataTable[22])
		elseif currentSpec == 2 then
			StatWindow.text:SetText(dataTable[23])
			StatWindowQuest.text:SetText(dataTable[23])
		elseif currentSpec == 3 then
			StatWindow.text:SetText(dataTable[24])
			StatWindowQuest.text:SetText(dataTable[24])
		end
	elseif	currentClass == "WARLOCK" then
		if currentSpec == 1 then
			StatWindow.text:SetText(dataTable[25])
			StatWindowQuest.text:SetText(dataTable[25])
		elseif currentSpec == 2 then
			StatWindow.text:SetText(dataTable[26])
			StatWindowQuest.text:SetText(dataTable[26])
		elseif currentSpec == 3 then
			StatWindow.text:SetText(dataTable[27])
			StatWindowQuest.text:SetText(dataTable[27])
		end
	elseif	currentClass == "MONK" then
		if currentSpec == 1 then
			StatWindow.text:SetText(dataTable[28])
			StatWindowQuest.text:SetText(dataTable[28])
		elseif currentSpec == 2 then
			StatWindow.text:SetText(dataTable[29])
			StatWindowQuest.text:SetText(dataTable[29])
		elseif currentSpec == 3 then
			StatWindow.text:SetText(dataTable[30])
			StatWindowQuest.text:SetText(dataTable[30])
		end
	elseif	currentClass == "DRUID" then
		if currentSpec == 1 then
			StatWindow.text:SetText(dataTable[31])
			StatWindowQuest.text:SetText(dataTable[31])
		elseif currentSpec == 2 then
			StatWindow.text:SetText(dataTable[32])
			StatWindowQuest.text:SetText(dataTable[32])
		elseif currentSpec == 3 then
			StatWindow.text:SetText(dataTable[33])
			StatWindowQuest.text:SetText(dataTable[33])
		elseif currentSpec == 4 then
			StatWindow.text:SetText(dataTable[34])
			StatWindowQuest.text:SetText(dataTable[34])
		end
	elseif	currentClass == "DEMONHUNTER" then
		if currentSpec == 1 then
			StatWindow.text:SetText(dataTable[35])
			StatWindowQuest.text:SetText(dataTable[35])
		elseif currentSpec == 2 then
			StatWindow.text:SetText(dataTable[36])
			StatWindowQuest.text:SetText(dataTable[36])
		end
	end	
end