local sat = CreateFrame("FRAME", "SpellAlertToggleFrame");

sat:RegisterEvent("ADDON_LOADED");
sat:RegisterEvent("ACTIVE_TALENT_GROUP_CHANGED");

local className, currentSpec, classColorString

local specIDs = {
	["DEATH_KNIGHT"] = {
		[1] = 250,
		[2] = 251,
		[3] = 252
	},
	["DEMON_HUNTER"] = {
		[1] = 577,
		[2] = 581
	},
	["DRUID"] = {
		[1] = 102,
		[2] = 103,
		[3] = 104,
		[4] = 105
	},
	["HUNTER"] = {
		[1] = 253,
		[2] = 254,
		[3] = 255
	},
	["MAGE"] = {
		[1] = 62,
		[2] = 63,
		[3] = 64
	},
	["MONK"] = {
		[1] = 268,
		[2] = 270,
		[3] = 269
	},
	["PALADIN"] = {
		[1] = 65,
		[2] = 66,
		[3] = 70
	},
	["PRIEST"] = {
		[1] = 256,
		[2] = 257,
		[3] = 258
	},
	["ROGUE"] = {
		[1] = 259,
		[2] = 260,
		[3] = 261
	},
	["SHAMAN"] = {
		[1] = 262,
		[2] = 263,
		[3] = 264
	},
	["WARLOCK"] = {
		[1] = 265,
		[2] = 266,
		[3] = 267
	},
	["WARRIOR"] = {
		[1] = 71,
		[2] = 72,
		[3] = 73
	}
}

local function updateSpellAlert()
	local spellAlertToggleSetting = SpellAlertToggleDatabase[className][currentSpec]
	if spellAlertToggleSetting then
		--print("Showing Spell Alerts");
		SetCVar("displaySpellActivationOverlays", 1);
	else
		--print("Hiding Spell Alerts");
		SetCVar("displaySpellActivationOverlays", 0);	
	end
end

local function configureCheckbox(checkbox, previous, direction, class, spec)
	if direction == "DOWN" then
		checkbox:SetPoint("TOPLEFT", previous, "BOTTOMLEFT", 0, -4)
	else
		checkbox:SetPoint("TOPLEFT", previous, "TOPRIGHT", 130, 0)
	end
	checkbox:SetWidth(24)
	checkbox:SetHeight(24)
	local specName = select(2,GetSpecializationInfoByID(specIDs[class][spec]))
	_G[checkbox:GetName().."Text"]:SetText(specName)
	local checkboxSetting = SpellAlertToggleDatabase[class][spec]
	checkbox:SetChecked(checkboxSetting)
	checkbox:SetScript("OnClick", function()
		if checkboxSetting == true then
			checkboxSetting = false
		else
			checkboxSetting = true
		end
		checkbox:SetChecked(checkboxSetting)
		SpellAlertToggleDatabase[class][spec] = checkboxSetting
	end)
end

sat:SetScript("OnEvent", function(self, event, arg1)
	if event == "ADDON_LOADED" and arg1 == "SpellAlertToggle" then
		className = select(2,UnitClass("player"))
		currentSpec = GetSpecialization()
		if SpellAlertToggleDatabase == nil then
			-- Defaults
			SpellAlertToggleDatabase = {
				["DEATH_KNIGHT"] = {
					[1] = true,
					[2] = false,
					[3] = false
				},
				["DEMON_HUNTER"] = {
					[1] = false,
					[2] = false
				},
				["DRUID"] = {
					[1] = false,
					[2] = false,
					[3] = false,
					[4] = false
				},
				["HUNTER"] = {
					[1] = false,
					[2] = false,
					[3] = false
				},
				["MAGE"] = {
					[1] = false,
					[2] = false,
					[3] = false
				},
				["MONK"] = {
					[1] = false,
					[2] = false,
					[3] = false
				},
				["PALADIN"] = {
					[1] = false,
					[2] = false,
					[3] = false
				},
				["PRIEST"] = {
					[1] = false,
					[2] = false,
					[3] = false
				},
				["ROGUE"] = {
					[1] = false,
					[2] = false,
					[3] = false
				},
				["SHAMAN"] = {
					[1] = false,
					[2] = false,
					[3] = false
				},
				["WARLOCK"] = {
					[1] = false,
					[2] = false,
					[3] = false
				},
				["WARRIOR"] = {
					[1] = false,
					[2] = false,
					[3] = false
				}
			}
		end
		SpellAlertToggleOptions()
		updateSpellAlert()
	elseif event == "ACTIVE_TALENT_GROUP_CHANGED" then
		currentSpec = GetSpecialization()
		updateSpellAlert()
	end
	maxSpecs = GetNumSpecializations(false, false)
end)

function SpellAlertToggleOptions()
	local satOptions = CreateFrame("FRAME", "SpellAlertToggleOptions")
	satOptions.name = "SpellAlertToggle"
	InterfaceOptions_AddCategory(satOptions)
	
	-- Title
	--local satOptionsTitle = satOptions:CreateFontString(nil, "ARTWORK", "GameFontNormalLarge")
	--satOptionsTitle:SetPoint("TOPLEFT", 16, -16)
	--satOptionsTitle:SetText("SpellAlertToggle")
	
	-- Spec checkboxes
	
	-- Death Knight
	local titleDeathKnight = satOptions:CreateFontString(nil, "ARTWORK", "GameFontNormal")
	titleDeathKnight:SetPoint("TOPLEFT", 16, -10)
	classColorString = "|c"..RAID_CLASS_COLORS["DEATHKNIGHT"].colorStr
	titleDeathKnight:SetText(classColorString.."Death Knight")
	
	local checkboxDeathKnightBlood = CreateFrame("CheckButton", "checkboxDeathKnightBlood", satOptions, "ChatConfigCheckButtonTemplate")
	configureCheckbox(checkboxDeathKnightBlood, titleDeathKnight, "DOWN", "DEATH_KNIGHT", 1)
	local checkboxDeathKnightFrost = CreateFrame("CheckButton", "checkboxDeathKnightFrost", satOptions, "ChatConfigCheckButtonTemplate")
	configureCheckbox(checkboxDeathKnightFrost, checkboxDeathKnightBlood, "RIGHT", "DEATH_KNIGHT", 2)
	local checkboxDeathKnightUnholy = CreateFrame("CheckButton", "checkboxDeathKnightUnholy", satOptions, "ChatConfigCheckButtonTemplate")
	configureCheckbox(checkboxDeathKnightUnholy, checkboxDeathKnightFrost, "RIGHT", "DEATH_KNIGHT", 3)
	
	-- Demon Hunter
	local titleDemonHunter = satOptions:CreateFontString(nil, "ARTWORK", "GameFontNormal")
	titleDemonHunter:SetPoint("TOPLEFT", titleDeathKnight, "BOTTOMLEFT", 0, -34)
	classColorString = "|c"..RAID_CLASS_COLORS["DEMONHUNTER"].colorStr
	titleDemonHunter:SetText(classColorString.."Demon Hunter")
	
	local checkboxDemonHunterHavoc = CreateFrame("CheckButton", "checkboxDemonHunterHavoc", satOptions, "ChatConfigCheckButtonTemplate")
	configureCheckbox(checkboxDemonHunterHavoc, titleDemonHunter, "DOWN", "DEMON_HUNTER", 1)
	local checkboxDemonHunterVengeance = CreateFrame("CheckButton", "checkboxDemonHunterVengeance", satOptions, "ChatConfigCheckButtonTemplate")
	configureCheckbox(checkboxDemonHunterVengeance, checkboxDemonHunterHavoc, "RIGHT", "DEMON_HUNTER", 2)
	
	-- Druid
	local titleDruid = satOptions:CreateFontString(nil, "ARTWORK", "GameFontNormal")
	titleDruid:SetPoint("TOPLEFT", titleDemonHunter, "BOTTOMLEFT", 0, -34)
	classColorString = "|c"..RAID_CLASS_COLORS["DRUID"].colorStr
	titleDruid:SetText(classColorString.."Druid")
	
	local checkboxDruidBalance = CreateFrame("CheckButton", "checkboxDruidBalance", satOptions, "ChatConfigCheckButtonTemplate")
	configureCheckbox(checkboxDruidBalance, titleDruid, "DOWN", "DRUID", 1)
	local checkboxDruidFeral = CreateFrame("CheckButton", "checkboxDruidFeral", satOptions, "ChatConfigCheckButtonTemplate")
	configureCheckbox(checkboxDruidFeral, checkboxDruidBalance, "RIGHT", "DRUID", 2)
	local checkboxDruidGuardian = CreateFrame("CheckButton", "checkboxDruidGuardian", satOptions, "ChatConfigCheckButtonTemplate")
	configureCheckbox(checkboxDruidGuardian, checkboxDruidFeral, "RIGHT", "DRUID", 3)
	local checkboxDruidRestoration = CreateFrame("CheckButton", "checkboxDruidRestoration", satOptions, "ChatConfigCheckButtonTemplate")
	configureCheckbox(checkboxDruidRestoration, checkboxDruidGuardian, "RIGHT", "DRUID", 4)
	
	-- Hunter
	local titleHunter = satOptions:CreateFontString(nil, "ARTWORK", "GameFontNormal")
	titleHunter:SetPoint("TOPLEFT", titleDruid, "BOTTOMLEFT", 0, -34)
	classColorString = "|c"..RAID_CLASS_COLORS["HUNTER"].colorStr
	titleHunter:SetText(classColorString.."Hunter")
	
	local checkboxHunterBeastMastery = CreateFrame("CheckButton", "checkboxHunterBeastMastery", satOptions, "ChatConfigCheckButtonTemplate")
	configureCheckbox(checkboxHunterBeastMastery, titleHunter, "DOWN", "HUNTER", 1)
	local checkboxHunterMarksmanship = CreateFrame("CheckButton", "checkboxHunterMarksmanship", satOptions, "ChatConfigCheckButtonTemplate")
	configureCheckbox(checkboxHunterMarksmanship, checkboxHunterBeastMastery, "RIGHT", "HUNTER", 2)
	local checkboxHunterSurvival = CreateFrame("CheckButton", "checkboxHunterSurvival", satOptions, "ChatConfigCheckButtonTemplate")
	configureCheckbox(checkboxHunterSurvival, checkboxHunterMarksmanship, "RIGHT", "HUNTER", 3)
	
	-- Mage
	local titleMage = satOptions:CreateFontString(nil, "ARTWORK", "GameFontNormal")
	titleMage:SetPoint("TOPLEFT", titleHunter, "BOTTOMLEFT", 0, -34)
	classColorString = "|c"..RAID_CLASS_COLORS["MAGE"].colorStr
	titleMage:SetText(classColorString.."Mage")
	
	local checkboxMageArcane = CreateFrame("CheckButton", "checkboxMageArcane", satOptions, "ChatConfigCheckButtonTemplate")
	configureCheckbox(checkboxMageArcane, titleMage, "DOWN", "MAGE", 1)
	local checkboxMageFire = CreateFrame("CheckButton", "checkboxMageFire", satOptions, "ChatConfigCheckButtonTemplate")
	configureCheckbox(checkboxMageFire, checkboxMageArcane, "RIGHT", "MAGE", 2)
	local checkboxMageFrost = CreateFrame("CheckButton", "checkboxMageFrost", satOptions, "ChatConfigCheckButtonTemplate")
	configureCheckbox(checkboxMageFrost, checkboxMageFire, "RIGHT", "MAGE", 3)
	
	-- Monk
	local titleMonk = satOptions:CreateFontString(nil, "ARTWORK", "GameFontNormal")
	titleMonk:SetPoint("TOPLEFT", titleMage, "BOTTOMLEFT", 0, -34)
	classColorString = "|c"..RAID_CLASS_COLORS["MONK"].colorStr
	titleMonk:SetText(classColorString.."Monk")
	
	local checkboxMonkBrewmaster = CreateFrame("CheckButton", "checkboxMonkBrewmaster", satOptions, "ChatConfigCheckButtonTemplate")
	configureCheckbox(checkboxMonkBrewmaster, titleMonk, "DOWN", "MONK", 1)
	local checkboxMonkMistweaver = CreateFrame("CheckButton", "checkboxMonkMistweaver", satOptions, "ChatConfigCheckButtonTemplate")
	configureCheckbox(checkboxMonkMistweaver, checkboxMonkBrewmaster, "RIGHT", "MONK", 2)
	local checkboxMonkWindwalker = CreateFrame("CheckButton", "checkboxMonkWindwalker", satOptions, "ChatConfigCheckButtonTemplate")
	configureCheckbox(checkboxMonkWindwalker, checkboxMonkMistweaver, "RIGHT", "MONK", 3)
	
	-- Paladin
	local titlePaladin = satOptions:CreateFontString(nil, "ARTWORK", "GameFontNormal")
	titlePaladin:SetPoint("TOPLEFT", titleMonk, "BOTTOMLEFT", 0, -34)
	classColorString = "|c"..RAID_CLASS_COLORS["PALADIN"].colorStr
	titlePaladin:SetText(classColorString.."Paladin")
	
	local checkboxPaladinHoly = CreateFrame("CheckButton", "checkboxPaladinHoly", satOptions, "ChatConfigCheckButtonTemplate")
	configureCheckbox(checkboxPaladinHoly, titlePaladin, "DOWN", "PALADIN", 1)
	local checkboxPaladinProtection = CreateFrame("CheckButton", "checkboxPaladinProtection", satOptions, "ChatConfigCheckButtonTemplate")
	configureCheckbox(checkboxPaladinProtection, checkboxPaladinHoly, "RIGHT", "PALADIN", 2)
	local checkboxPaladinRetribution = CreateFrame("CheckButton", "checkboxPaladinRetribution", satOptions, "ChatConfigCheckButtonTemplate")
	configureCheckbox(checkboxPaladinRetribution, checkboxPaladinProtection, "RIGHT", "PALADIN", 3)
	
	-- Priest
	local titlePriest = satOptions:CreateFontString(nil, "ARTWORK", "GameFontNormal")
	titlePriest:SetPoint("TOPLEFT", titlePaladin, "BOTTOMLEFT", 0, -34)
	classColorString = "|c"..RAID_CLASS_COLORS["PRIEST"].colorStr
	titlePriest:SetText(classColorString.."Priest")
	
	local checkboxPriestDiscipline = CreateFrame("CheckButton", "checkboxPriestDiscipline", satOptions, "ChatConfigCheckButtonTemplate")
	configureCheckbox(checkboxPriestDiscipline, titlePriest, "DOWN", "PRIEST", 1)
	local checkboxPriestHoly = CreateFrame("CheckButton", "checkboxPriestHoly", satOptions, "ChatConfigCheckButtonTemplate")
	configureCheckbox(checkboxPriestHoly, checkboxPriestDiscipline, "RIGHT", "PRIEST", 2)
	local checkboxPriestShadow = CreateFrame("CheckButton", "checkboxPriestShadow", satOptions, "ChatConfigCheckButtonTemplate")
	configureCheckbox(checkboxPriestShadow, checkboxPriestHoly, "RIGHT", "PRIEST", 3)
	
	-- Rogue
	local titleRogue = satOptions:CreateFontString(nil, "ARTWORK", "GameFontNormal")
	titleRogue:SetPoint("TOPLEFT", titlePriest, "BOTTOMLEFT", 0, -34)
	classColorString = "|c"..RAID_CLASS_COLORS["ROGUE"].colorStr
	titleRogue:SetText(classColorString.."Rogue")
	
	local checkboxRogueAssassination = CreateFrame("CheckButton", "checkboxRogueAssassination", satOptions, "ChatConfigCheckButtonTemplate")
	configureCheckbox(checkboxRogueAssassination, titleRogue, "DOWN", "ROGUE", 1)
	local checkboxRogueOutlaw = CreateFrame("CheckButton", "checkboxRogueOutlaw", satOptions, "ChatConfigCheckButtonTemplate")
	configureCheckbox(checkboxRogueOutlaw, checkboxRogueAssassination, "RIGHT", "ROGUE", 2)
	local checkboxRogueSubtlety = CreateFrame("CheckButton", "checkboxRogueSubtlety", satOptions, "ChatConfigCheckButtonTemplate")
	configureCheckbox(checkboxRogueSubtlety, checkboxRogueOutlaw, "RIGHT", "ROGUE", 3)
	
	-- Shaman
	local titleShaman = satOptions:CreateFontString(nil, "ARTWORK", "GameFontNormal")
	titleShaman:SetPoint("TOPLEFT", titleRogue, "BOTTOMLEFT", 0, -34)
	classColorString = "|c"..RAID_CLASS_COLORS["SHAMAN"].colorStr
	titleShaman:SetText(classColorString.."Shaman")
	
	local checkboxShamanElemental = CreateFrame("CheckButton", "checkboxShamanElemental", satOptions, "ChatConfigCheckButtonTemplate")
	configureCheckbox(checkboxShamanElemental, titleShaman, "DOWN", "SHAMAN", 1)
	local checkboxShamanEnhancement = CreateFrame("CheckButton", "checkboxShamanEnhancement", satOptions, "ChatConfigCheckButtonTemplate")
	configureCheckbox(checkboxShamanEnhancement, checkboxShamanElemental, "RIGHT", "SHAMAN", 2)
	local checkboxShamanRestoration = CreateFrame("CheckButton", "checkboxShamanRestoration", satOptions, "ChatConfigCheckButtonTemplate")
	configureCheckbox(checkboxShamanRestoration, checkboxShamanEnhancement, "RIGHT", "SHAMAN", 3)
	
	-- Warlock
	local titleWarlock = satOptions:CreateFontString(nil, "ARTWORK", "GameFontNormal")
	titleWarlock:SetPoint("TOPLEFT", titleShaman, "BOTTOMLEFT", 0, -34)
	classColorString = "|c"..RAID_CLASS_COLORS["WARLOCK"].colorStr
	titleWarlock:SetText(classColorString.."Warlock")
	
	local checkboxWarlockAffliction = CreateFrame("CheckButton", "checkboxWarlockAffliction", satOptions, "ChatConfigCheckButtonTemplate")
	configureCheckbox(checkboxWarlockAffliction, titleWarlock, "DOWN", "WARLOCK", 1)
	local checkboxWarlockDemonology = CreateFrame("CheckButton", "checkboxWarlockDemonology", satOptions, "ChatConfigCheckButtonTemplate")
	configureCheckbox(checkboxWarlockDemonology, checkboxWarlockAffliction, "RIGHT", "WARLOCK", 2)
	local checkboxWarlockDestruction = CreateFrame("CheckButton", "checkboxWarlockDestruction", satOptions, "ChatConfigCheckButtonTemplate")
	configureCheckbox(checkboxWarlockDestruction, checkboxWarlockDemonology, "RIGHT", "WARLOCK", 3)
	
	-- Warrior
	local titleWarrior = satOptions:CreateFontString(nil, "ARTWORK", "GameFontNormal")
	titleWarrior:SetPoint("TOPLEFT", titleWarlock, "BOTTOMLEFT", 0, -34)
	classColorString = "|c"..RAID_CLASS_COLORS["WARRIOR"].colorStr
	titleWarrior:SetText(classColorString.."Warrior")
	
	local checkboxWarriorArms = CreateFrame("CheckButton", "checkboxWarriorArms", satOptions, "ChatConfigCheckButtonTemplate")
	configureCheckbox(checkboxWarriorArms, titleWarrior, "DOWN", "WARRIOR", 1)
	local checkboxWarriorFury = CreateFrame("CheckButton", "checkboxWarriorFury", satOptions, "ChatConfigCheckButtonTemplate")
	configureCheckbox(checkboxWarriorFury, checkboxWarriorArms, "RIGHT", "WARRIOR", 2)
	local checkboxWarriorProtection = CreateFrame("CheckButton", "checkboxWarriorProtection", satOptions, "ChatConfigCheckButtonTemplate")
	configureCheckbox(checkboxWarriorProtection, checkboxWarriorFury, "RIGHT", "WARRIOR", 3)
end
