local name = "_sols_noxxic_stats"
local version = GetAddOnMetadata(name, "Version") or "UnKnown Version"
local title = GetAddOnMetadata(name, "Title") or "UnKnown Title"
local sversion = GetAddOnMetadata(name, "X-StatsVersion") or "UnKnown Title"

Sols_STATS = CreateFrame("Frame",Sols_STATS,UIParent)

function Sols_STATS:CreateWin()
    if PaperDollFrame:IsVisible() then
        if not Sols_STATSwin then
            Sols_STATSwin = CreateFrame("Frame",Sols_STATSwin,Sols_STATS)
            local f = Sols_STATS
            f:SetBackdrop({bgFile = "Interface/Tooltips/UI-Tooltip-Background", 
                    edgeFile = "Interface/Tooltips/UI-Tooltip-Border", 
                    tile = true, tileSize = 16, edgeSize = 16, 
                    insets = { left = 1, right = 1, top = 1, bottom = 1 }}) 
            f:SetBackdropColor(0,0,0,1)
            f:SetFrameStrata("TOOLTIP")
            f:SetWidth(PaperDollFrame:GetWidth()-50) 
            f:SetHeight(30)
            Sols_STATStxt = f:CreateFontString(nil,"OVERLAY","GameFontWhite")
            local ft = Sols_STATStxt 
            ft:ClearAllPoints()
            ft:SetAllPoints(Sols_STATS) 
            ft:SetJustifyH("CENTER")
            ft:SetJustifyV("CENTER")
            f:ClearAllPoints()
            f:SetPoint("BOTTOMRIGHT",PaperDollFrame,"TOPRIGHT",0,0)
            f:SetParent(PaperDollFrame)
            f:Show()            
        end
        return true
    end
    return false
end

function Sols_STATS:Update()
    if not GetSpecialization() then 
        return false
    end

    local myspec, _ = select(2,GetSpecializationInfo(GetSpecialization()))
    local myclass, _ = UnitClass("player")

    if not myspec or not myclass then
	return false
    end

    myspec = strlower(myclass .. "-" .. myspec)
    if Sols_STATS:CreateWin() then
        local s = Sols_StatTable[myspec]
        if s then
            s = gsub(s,"Strength","STR")
            s = gsub(s,"Agility","AGI")
            s = gsub(s,"Intellect","INT")
            s = gsub(s,"Stamina","STA")
            s = gsub(s,"Versatility","Vers")
            Sols_STATStxt:SetText(s)
        end
    end
end

local f = Sols_STATS
f:RegisterEvent("SPELLS_CHANGED") 
f:RegisterEvent("ADDON_LOADED") 
f:RegisterEvent("PLAYER_ENTERING_WORLD") 
f:SetScript("OnEvent", function(self, event, ...)
    if  ... == name then
       if event == "ADDON_LOADED" then
            print(title,version,"Loaded!")
            print(" - Noxxic.com Stats Version:",sversion)
            PaperDollFrame:HookScript("OnShow", function() Sols_STATS:Update() end)
        end
        if IsAddOnLoaded("_sols_noxxic_stats") then
            if event == "ADDON_LOADED" or
               event == "SPELLS_CHANGED" then
                Sols_STATS:Update()
            end
        end     
    end
end)



