﻿SmexySimInfo = LibStub("AceAddon-3.0"):NewAddon("SmexySimInfo", "AceEvent-3.0", "AceConsole-3.0");

local AceConfig = LibStub("AceConfigDialog-3.0");

local name = "SmexySimInfo";
local version = "v1.0.8";
local token = "|cFF00CCFF";
local lego = "|cFFFF8000";

function SmexySimInfo:OnInitialize()
	LibStub("AceConfig-3.0"):RegisterOptionsTable("SmexySimInfo", SmexySimInfo.options);
	AceConfig:AddToBlizOptions("SmexySimInfo", "SmexySimInfo(SSIN)");
	local name = UnitName("Player");
	if not SmexySimInfoDB then SmexySimInfoDB = {}; end;
	if not SmexySimInfoDB[name] then SmexySimInfoDB[name] = {}; end;
end;

SmexySimInfo.options = {
	name = "SmexySimOptions",
	type = 'group',
	args = {
		NeckEnchant = {
		type = "select",
		name = "Neck Enchant",
		width = "full",
		get = function(info) return SmexyMats.db.profile.NeckEnchant; end,
		set = function(info, v) SmexyMats.db.profile.NeckEnchant = v; end,
		order = 1
		},
	}
};

local OFFSET_ITEM_ID 	= 1;
local OFFSET_ENCHANT_ID = 2;
local OFFSET_GEM_ID_1 	= 3;
local OFFSET_GEM_ID_2 	= 4;
local OFFSET_GEM_ID_3 	= 5;
local OFFSET_GEM_ID_4 	= 6;
local OFFSET_GEM_BASE 	= 3;
local OFFSET_SUFFIX_ID 	= 7;
local OFFSET_FLAGS 		= 11;
local OFFSET_BONUS_ID 	= 13;
local OFFSET_UPGRADE_ID = 14;

local upgradeTable = {
	[0]   =  0,
	[1]   =  1, -- 1/1 -> 8
	[373] =  1, -- 1/2 -> 4
	[374] =  2, -- 2/2 -> 8
	[375] =  1, -- 1/3 -> 4
	[376] =  2, -- 2/3 -> 4
	[377] =  3, -- 3/3 -> 4
	[378] =  1, -- 1/1 -> 7
	[379] =  1, -- 1/2 -> 4
	[380] =  2, -- 2/2 -> 4
	[445] =  0, -- 0/2 -> 0
	[446] =  1, -- 1/2 -> 4
	[447] =  2, -- 2/2 -> 8
	[451] =  0, -- 0/1 -> 0
	[452] =  1, -- 1/1 -> 8
	[453] =  0, -- 0/2 -> 0
	[454] =  1, -- 1/2 -> 4
	[455] =  2, -- 2/2 -> 8
	[456] =  0, -- 0/1 -> 0
	[457] =  1, -- 1/1 -> 8
	[458] =  0, -- 0/4 -> 0
	[459] =  1, -- 1/4 -> 4
	[460] =  2, -- 2/4 -> 8
	[461] =  3, -- 3/4 -> 12
	[462] =  4, -- 4/4 -> 16
	[465] =  0, -- 0/2 -> 0
	[466] =  1, -- 1/2 -> 4
	[467] =  2, -- 2/2 -> 8
	[468] =  0, -- 0/4 -> 0
	[469] =  1, -- 1/4 -> 4
	[470] =  2, -- 2/4 -> 8
	[471] =  3, -- 3/4 -> 12
	[472] =  4, -- 4/4 -> 16
	[476] =  0, -- ? -> 0
	[479] =  0, -- ? -> 0
	[491] =  0, -- ? -> 0
	[492] =  1, -- ? -> 0
	[493] =  2, -- ? -> 0
	[494] =  0,
	[495] =  1,
	[496] =  2,
	[497] =  3,
	[498] =  4,
	[504] =  3,
	[505] =  4,
	[529] =  0, -- 0/2 -> 0
	[530] =  1, -- 1/2 -> 5
	[531] =  2, -- 2/2 -> 10
};

local ItemsSlots = {
	["INVTYPE_HEAD"] 			= "head",
	["INVTYPE_NECK"] 			= "neck",
	["INVTYPE_SHOULDER"]		= "shoulder",
	["INVTYPE_CLOAK"] 			= "back",
	["INVTYPE_CHEST"] 			= "chest",
	["INVTYPE_WRIST"] 			= "wrist",
	["INVTYPE_HAND"] 			= "hands",
	["INVTYPE_WAIST"] 			= "waist",
	["INVTYPE_LEGS"] 			= "legs",
	["INVTYPE_FEET"] 			= "feet",
	["INVTYPE_FINGER"] 			= "finger1",
	["INVTYPE_TRINKET"] 		= "trinket1",
	["INVTYPE_2HWEAPON"]		= "main_hand",
	["INVTYPE_WEAPONMAINHAND"]	= "main_hand",
	["INVTYPE_WEAPONOFFHAND"]	= "off_hand",
	["INVTYPE_SHIELD"]			= "off_hand",
	["INVTYPE_RANGEDRIGHT"]		= "main_hand",
	["INVTYPE_RANGED"]			= "main_hand",
};

DEFAULT_CHAT_FRAME:AddMessage(token .. "SmexySimInfo(SSIN)" .. lego .. version .. "|r Load Complete!");

local function GetIDFromLink(link)
	if link then
		local linktype, id = string.match(link, "|H([^:]+):(%d+)");
		if id then 
			return tonumber(id);
		else
			return 0;
		end;
	end;
end;

local function GetGemItemID(itemLink, index)
	local _, gemLink = GetItemGem(itemLink, index)
	if gemLink ~= nil then
		local itemIdStr = string.match(gemLink, "item:(%d+)");
		if itemIdStr ~= nil then
			return tonumber(itemIdStr);
		end;
	end;
	return 0;
end;

local function GetItemSplit(itemLink)
	local itemString = string.match(itemLink, "item:([%-?%d:]+)");
	local itemSplit = {};
	for _, v in ipairs({strsplit(":", itemString)}) do
		if v == "" then
			itemSplit[#itemSplit + 1] = 0;
		else
			itemSplit[#itemSplit + 1] = tonumber(v);
		end;
	end;
	return itemSplit;
end;

local function GetItemStringFromItemLink(itemLink)
	if not itemLink then return; end;
	if (GetIDFromLink(itemLink) == 0) then return; end;
	local A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q = GetItemInfo(itemLink);
	--DEFAULT_CHAT_FRAME:AddMessage(tostring(itemLink));
	--DEFAULT_CHAT_FRAME:AddMessage(I);
	
	local slotNum = nil;
	if G == "Artifact Relic" then
		slotNum = "relic";
	else
		slotNum = ItemsSlots[I];
	end;
	
	local itemSplit = GetItemSplit(itemLink);
	local simcItemOptions = {};
	local gems = {};
	local itemId = itemSplit[OFFSET_ITEM_ID];
	
	simcItemOptions[#simcItemOptions + 1] = ',id=' .. itemId;

	if itemSplit[OFFSET_ENCHANT_ID] > 0 then
		simcItemOptions[#simcItemOptions + 1] = 'enchant_id=' .. itemSplit[OFFSET_ENCHANT_ID];
	end;

	for gemOffset = OFFSET_GEM_ID_1, OFFSET_GEM_ID_4 do
		local gemIndex = (gemOffset - OFFSET_GEM_BASE) + 1;
		if itemSplit[gemOffset] > 0 then
			local gemId = GetGemItemID(itemLink, gemIndex);
			if gemId > 0 then
				gems[gemIndex] = gemId;
			end;
		else
			gems[gemIndex] = 0;
		end;
	end;

	while #gems > 0 and gems[#gems] == 0 do
		table.remove(gems, #gems);
	end;
	
	if #gems > 0 then
		simcItemOptions[#simcItemOptions + 1] = 'gem_id=' .. table.concat(gems, '/');
	end;
	
	if itemSplit[OFFSET_SUFFIX_ID] ~= 0 then
		simcItemOptions[#simcItemOptions + 1] = 'suffix=' .. itemSplit[OFFSET_SUFFIX_ID];
	end;
	
	local flags = itemSplit[OFFSET_FLAGS];
	local bonuses = {};
	
	for index=1, itemSplit[OFFSET_BONUS_ID] do
		bonuses[#bonuses + 1] = itemSplit[OFFSET_BONUS_ID + index];
	end;

	if #bonuses > 0 then
		simcItemOptions[#simcItemOptions + 1] = 'bonus_id=' .. table.concat(bonuses, '/');
	end;

	local linkOffset = OFFSET_BONUS_ID + #bonuses + 1;
	
	if bit.band(flags, 0x4) == 0x4 then
		local upgradeId = itemSplit[linkOffset]
		if upgradeTable and upgradeTable[upgradeId] ~= nil and upgradeTable[upgradeId] > 0 then
			simcItemOptions[#simcItemOptions + 1] = 'upgrade=' .. upgradeTable[upgradeId];
		end;
		linkOffset = linkOffset + 1;
	end;
	
	if bit.band(flags, 0x100) == 0x100 then
		linkOffset = linkOffset + 1; -- An unknown field

		if bit.band(flags, 0x1000000) == 0x1000000 then
			linkOffset = linkOffset + 1;
		end;

		local relicStrs = {};
		local relicIndex = 1;
		while linkOffset < #itemSplit do
			local nBonusIds = itemSplit[linkOffset];
			linkOffset = linkOffset + 1;
			if nBonusIds == 0 then
				relicStrs[relicIndex] = "0";
			else
				local relicBonusIds = {};
				for rbid = 1, nBonusIds do
					relicBonusIds[#relicBonusIds + 1] = itemSplit[linkOffset];
					linkOffset = linkOffset + 1;
				end;
				relicStrs[relicIndex] = table.concat(relicBonusIds, ':');
			end;
			relicIndex = relicIndex + 1;
		end;

		while #relicStrs > 0 and relicStrs[#relicStrs] == "0" do
			table.remove(relicStrs, #relicStrs);
		end;

		if #relicStrs > 0 then
			simcItemOptions[#simcItemOptions + 1] = 'relic_id=' .. table.concat(relicStrs, '/')
		end;
	end;

	if bit.band(flags, 0x200) == 0x200 then
		simcItemOptions[#simcItemOptions + 1] = 'drop_level=' .. itemSplit[linkOffset];
		linkOffset = linkOffset + 1;
	end;
	
	local itemStr = ''
	itemStr = itemStr .. slotNum .. "=" .. table.concat(simcItemOptions, ',')
	
	return itemStr, slotNum;
end;

local function Smexy_wait(delay, func, ...)
	if(type(delay)~="number" or type(func)~="function") then return false; end;
	local wF, wT = nil, {};
	wF = CreateFrame("Frame","wF", UIParent);
	wF:SetScript("onUpdate", function(self,elapse)
		local count, i = #wT, 1;
		while(i <= count) do
			local wR = tremove(wT,i);
			local d, ff, p = tremove(wR,1), tremove(wR,1), tremove(wR,1);
			if(d > elapse) then
				tinsert(wT,i,{d-elapse,ff,p});
				i = i + 1;
			else
				count = count - 1;
				ff(unpack(p));
			end;
		end;
	end);
	tinsert(wT,{delay,func,{...}});
	return true;
end;

function SmexySimInfo:SlashCommandHandler(arg)
	local Proceed = true;
	if not arg then Proceed = false; end;
	if (GetIDFromLink(arg) == 0) then Proceed = false; end;
	
	if not Proceed then
			InterfaceOptionsFrame_OpenToCategory("SmexySimInfo(SSIN)");
			InterfaceOptionsFrame_OpenToCategory("SmexySimInfo(SSIN)");
		return false;
	end;

	local ItemString, strSlot = GetItemStringFromItemLink(arg);
	return ItemString, strSlot;
end;

local function SCH(arg)
	SmexySimInfo:SlashCommandHandler(arg);
end;

SlashCmdList["SSIN"] = SCH;
SLASH_SSIN1 = "/ssin";