local SmexySimInfo = SmexySimInfo;

local function OverrideEnchant(strSimCode, newID)
	local tOne = {};
	local tTwo = {};
	local bldr = "";
	for k, v in ipairs({strsplit(",", strSimCode)}) do 
		tOne[k] = v;
	end;
	local i = 1;
	for k, v in ipairs(tOne) do 
		if (string.match(v, "enchant_id")) then 
			--Do nothing
		else
			tTwo[i] = v;
			i = i + 1;
		end;
	end;
	for k, v in ipairs(tTwo) do 
		bldr = bldr .. v .. ",";
	end;
	bldr = bldr .. "enchant_id=" .. newID;
	return bldr;
end;

local function OverrideGem(strSimCode, newID)
	local tOne = {};
	local tTwo = {};
	local rThree = {};
	local gemString = "";
	local bldr = "";
	
	for k, v in ipairs({strsplit(",", strSimCode)}) do 
		tOne[k] = v; 
	end;
	
	local i = 1;
	for k, v in ipairs(tOne) do 
		if (string.match(v, "gem_id")) then 
			gemString = v;
		else
			tTwo[i] = v;
		end;
		i = i + 1;
	end;
	
	for k, v in ipairs({strsplit(",", strSimCode)}) do 
		if(v ~= gemString) then
			bldr = bldr .. v .. ",";
		end;
	end;
	
	bldr = bldr .. "gem_id=" .. newID;
	
	if not string.match(gemString, "/") then
		return bldr;
	else
		local y = 1;
		for k, v in ipairs({strsplit("/", gemString)}) do 
			tThree[y] = v; 
			y = y + 1;
		end;
		if #tThree == 2 then
			bldr = bldr .. "/" .. newID;
		end;
		if #tThree == 3 then
			bldr = bldr .. "/" .. newID .. "/" .. newID;
		end;
	end;
	return bldr;
end;

SmexySimInfo.Enchants = {
	Neck = {
		[141910] = "Mark of the Ancient Preistess (Procs heal, 1 ally, 400% of spell power.)",
		[128551] = "Mark of the Claw (Procs Critical Strike & Haste by 1000 for 6 Sec.)",
		[128552] = "Mark of the Distant Army (Procs Rain of Arrows on your target.)",
		[141908] = "Mark of the Heavy Hide (Procs 3000 Armor for 10 Sec.)",
		[128553] = "Mark of the Hidden Satyr (Procs Satyr to go damage.)",
		[141909] = "Mark of the Trained Soldier (Procs Mastery by 600.)",
		[144307] = "Mark of the Deadly (Procs Critical Strike by 200.)",
		[144304] = "Mark of the Master (Procs Mastery by 200.",
		[144306] = "Mark of the Quick (Procs Haste by 200.",
		[144305] = "Mark of the Versatile (Procs Versatility by 200.",
	},
	Cloak = {
		[128549] = "Binding of Agility (+200)",
		[128550] = "Binding of Intellect (+200)",
		[128548] = "Binding of Strength (+200)",
		[128546] = "Word of Agility (+150)",
		[128547] = "Word of Intellect (+150)",
		[128545] = "Word of Strength (+150)",
	},
	Ring = {
		[128541] = "Binding of Critical Strike (+200)",
		[128543] = "Binding of Mastery (+200)",
		[128544] = "Binding of Versatility (+200)",
		[128542] = "Binding of Haste (+200)",
		[128537] = "Word of Critical Strike (+150)",
		[128539] = "Word of Mastery (+150)",
		[128540] = "Word of Versatility (+150)",
		[128538] = "Word of Haste (+150)", 
	},
	Gem = {
		[130219] = "Deadly Eye of Prophecy (+150 Critical Strike)",
		[130246] = "Saber's Eye of Strength (+200 Strength)",
		[130248] = "Saber's Eye of Intellect (+200 Intellect)",
		[151580] = "Deadly Deep Chemirine (+200 Critical Strike)",
		[151583] = "Quick Lightsphene (+200 Haste)",
		[151584] = "Masterful Argulite (+200 Mastery)",
		[151585] = "Versatile Labradorite (+200 Versatility)",
		[130247] = "Saber's Eye of Agility (+200 Agility)",
		[130220] = "Quick Dawnlight (+150 Haste)",
		[130221] = "Versatile Maelstrom Sapphire (+150 Versatility)",
		[130222] = "Masterful Shadowruby (+150 Mastery)",
		[130215] = "Deadly Deep Amber (+100 Critical Strike)",
		[130216] = "Quick Azsunite (+100 Haste)",
		[130217] = "Versatile Skystone (+100 Versatility)",
		[130218] = "Masterful Queen's Opal (+100 Mastery)",
	},
};

SmexySimInfo.options = {
	name = "SmexySimOptions",
	type = 'group',
	args = {
		Section1 = {
			type = "header",
			name = "Enchants",
			order = 1,
		},
		oNeck = {
			type = "toggle",
			name = "Override Neck Enchant?",
			width = "double",
			get = function(info) 
				local name = UnitName("Player");
				return SmexySimInfoDB[name].oNeck;
			end,
			set = function(info, v)
				local name = UnitName("Player");
				SmexySimInfoDB[name].oNeck = v;
			end,
			order = 2,
		},
		NeckEnchant = {
			type = "select",
			name = "Set Neck Enchant",
			width = "full",
			values = SmexySimInfo.Enchants.Neck,
			style = "dropdown",
			get = function(info)
				local name = UnitName("Player");
				return SmexySimInfoDB[name].NeckEnchantID;
			end,
			set = function(info, v)
				local name = UnitName("Player");
				SmexySimInfoDB[name].NeckEnchantID = v;
				SmexySimInfoDB[name].NeckEnchantName = SmexySimInfo.Enchants.Neck[v];
			end,
			order = 2,
		},
		oCloak = {
			type = "toggle",
			name = "Override Cloak Enchant?",
			width = "double",
			get = function(info) 
				local name = UnitName("Player");
				return SmexySimInfoDB[name].oCloak;
			end,
			set = function(info, v)
				local name = UnitName("Player");
				SmexySimInfoDB[name].oCloak = v;
			end,
			order = 3,
		},
		CloakEnchant = {
			type = "select",
			name = "Set Cloak Enchant",
			width = "full",
			values = SmexySimInfo.Enchants.Cloak,
			style = "dropdown",
			get = function(info)
				local name = UnitName("Player");
				return SmexySimInfoDB[name].CloakEnchantID;
			end,
			set = function(info, v)
				local name = UnitName("Player");
				SmexySimInfoDB[name].CloakEnchantID = v;
				SmexySimInfoDB[name].CloakEnchantName = SmexySimInfo.Enchants.Cloak[v];
			end,
			order = 3
		},
		oRing = {
			type = "toggle",
			name = "Override Ring Enchant?",
			width = "double",
			get = function(info) 
				local name = UnitName("Player");
				return SmexySimInfoDB[name].oRing;
			end,
			set = function(info, v)
				local name = UnitName("Player");
				SmexySimInfoDB[name].oRing = v;
			end,
			order = 4,
		},
		RingEnchant = {
			type = "select",
			name = "Set Ring Enchant",
			width = "full",
			values = SmexySimInfo.Enchants.Ring,
			style = "dropdown",
			get = function(info)
				local name = UnitName("Player");
				return SmexySimInfoDB[name].RingEnchantID;
			end,
			set = function(info, v)
				local name = UnitName("Player");
				SmexySimInfoDB[name].RingEnchantID = v;
				SmexySimInfoDB[name].RingEnchantName = SmexySimInfo.Enchants.Ring[v];
			end,
			order = 4
		},
		Section2 = {
			type = "header",
			name = "Add Gems to item.",
			order = 5,
		},
		AddGem = {
			type = "toggle",
			name = "Add gem to item.",
			desc = "Adds a gem to the item, even if the item does not have a socket.",
			width = "full",
			get = function(info) 
				local name = UnitName("Player");
				return SmexySimInfoDB[name].AddGem;
			end,
			set = function(info, v) 
				local name = UnitName("Player");
				SmexySimInfoDB[name].AddGem = v;
			end,
			order = 6,
		},
		oGem = {
			type = "toggle",
			name = "Override Gem.",
			desc = "Overrides the current gem(s) with the one selected in the dropdown.",
			width = "full",
			get = function(info) 
				local name = UnitName("Player");
				return SmexySimInfoDB[name].oGem;
			end,
			set = function(info, v) 
				local name = UnitName("Player");
				SmexySimInfoDB[name].oGem = v;
			end,
			order = 6,
		},
		GemCount = {
			type = "select",
			name = "# of Gems",
			width = "normal",
			values = {1,2,3},
			style = "dropdown",
			get = function(info)
				local name = UnitName("Player");
				return SmexySimInfoDB[name].GemCount;
			end,
			set = function(info, v)
				local name = UnitName("Player");
				SmexySimInfoDB[name].GemCount = v;
			end,
			order = 7,
		},
		GemSelect = {
			type = "select",
			name = "Selected Gem",
			values = SmexySimInfo.Enchants.Gem,
			style = "dropdown",
			width = "double",
			get = function(info)
				local name = UnitName("Player");
				return SmexySimInfoDB[name].GemID;
			end,
			set = function(info, v)
				local name = UnitName("Player");
				SmexySimInfoDB[name].GemID = v;
				SmexySimInfoDB[name].GemIDName = SmexySimInfo.Enchants.Gem[v];
			end,
			order = 8,
		},
		Section3 = {
			type = "header",
			name = "Link your item here.",
			order = 9,
		},
		LinkedItem = {
			type = "input",
			width = "full",
			multiline = false,
			name = "Link your item here",
			order = 10,
			get = function(info)
				local name = UnitName("Player");
				return "";
			end,
			set = function(info, v)
				local name = UnitName("Player");
				SmexySimInfoDB[name].LinkedItem = v;
				local tempString, tempSlot = SmexySimInfo:SlashCommandHandler(v);
				
				if not tempString then return; end;
				
				if (tempSlot == "neck") or (tempSlot == "back") or (tempSlot == "finger1") then
					if not (string.match(tempString, "enchant_id")) then
						if (tempSlot == "neck") then
							tempString = tempString .. ",enchant_id=" .. SmexySimInfoDB[name].NeckEnchantID;
						end;
						if (tempSlot == "back") then
							tempString = tempString .. ",enchant_id=" .. SmexySimInfoDB[name].CloakEnchantID;
						end;
						if (tempSlot == "finger1") then
							tempString = tempString .. ",enchant_id=" .. SmexySimInfoDB[name].RingEnchantID;
						end;
					end;
					if (string.match(tempString, "enchant_id")) then
						if (SmexySimInfoDB[name].oNeck) and (tempSlot == "neck") then
							tempString = OverrideEnchant(tempString, SmexySimInfoDB[name].NeckEnchantID);
						end;
						if (SmexySimInfoDB[name].oCloak) and (tempSlot == "back") then
							tempString = OverrideEnchant(tempString, SmexySimInfoDB[name].CloakEnchantID);
						end;
						if (SmexySimInfoDB[name].oRing) and (tempSlot == "finger1") then
							tempString = OverrideEnchant(tempString, SmexySimInfoDB[name].RingEnchantID);
						end;
					end;
				end;
				
				if SmexySimInfoDB[name].oGem then
					tempString = OverrideGem(tempString, SmexySimInfoDB[name].GemID);
				end;
				
				if SmexySimInfoDB[name].AddGem then
					for i = 1, SmexySimInfoDB[name].GemCount do
						if not (string.match(tempString, "gem_id")) then
							tempString = tempString .. ",gem_id=" .. SmexySimInfoDB[name].GemID;
						else
							tempString = tempString .. "/" .. SmexySimInfoDB[name].GemID;
						end;
					end;
				end;
				
				StaticPopupDialogs["SIMC_ITEM_STRING"] = {
					text = "Copy & Paste this into Simulation Craft.",
					hasEditBox = 1,
					maxLetters = 1000,
					editBoxWidth = 1000,
					OnShow = function(self)
						local editBox = self.editBox
						editBox:SetText(tempString)
						editBox:SetFocus()
					end,
					EditBoxOnEnterPressed = function(self) 
						self:GetParent():Hide()
					end,
					EditBoxOnEscapePressed = function(self) 
						self:GetParent():Hide()
					end,
					timeout = 0,
					whileDead = 1,
					hideOnEscape = 1,
					button1 = "OK",
				};
				StaticPopup_Show("SIMC_ITEM_STRING");
			end,
		},
		Section4 = {
			type = "header",
			name = "Author",
			order = 11,
		},	
		About = {
			type = "description",
			name = "|cFF00CCFFBattleTag: Lunixia#1530\r\n" ..
					"|rCheck out my other addons:\r\n" ..
					"|cFFFF8000SmexyScaleUI(SSUI)\r\n" .. 
					"|cFFFF8000SmexyGMO(SGMO)\r\n" .. 
					"|cFFFF8000SmexyMats(SM)",
			fontSize = "medium",
			order = 13,
		},
	},
};