-- SmartTooltip
-- Author: XH3L/BSU
-- Compatible with 7.3.5

local function addIcons(self, event, message, ...)
	local function Icon(link)
		local texture = GetItemIcon(link)
		return "\124T" .. texture .. ":" .. 12 .. "\124t" .. link
	end
	message = message:gsub("(\124c%x+\124Hitem:.-\124h\124r)", Icon)
	return false, message, ...
end

ChatFrame_AddMessageEventFilter("CHAT_MSG_YELL", addIcons)
ChatFrame_AddMessageEventFilter("CHAT_MSG_LOOT", addIcons)
ChatFrame_AddMessageEventFilter("CHAT_MSG_BN_WHISPER", addIcons)
ChatFrame_AddMessageEventFilter("CHAT_MSG_BN_WHISPER_INFORM", addIcons)
ChatFrame_AddMessageEventFilter("CHAT_MSG_CHANNEL", addIcons)
ChatFrame_AddMessageEventFilter("CHAT_MSG_GUILD", addIcons)
ChatFrame_AddMessageEventFilter("CHAT_MSG_INSTANCE_CHAT", addIcons)
ChatFrame_AddMessageEventFilter("CHAT_MSG_OFFICER", addIcons)
ChatFrame_AddMessageEventFilter("CHAT_MSG_PARTY", addIcons)
ChatFrame_AddMessageEventFilter("CHAT_MSG_PARTY_LEADER", addIcons)
ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID", addIcons)
ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID_LEADER", addIcons)
ChatFrame_AddMessageEventFilter("CHAT_MSG_SAY", addIcons)
ChatFrame_AddMessageEventFilter("CHAT_MSG_TRADESKILLS", addIcons)
ChatFrame_AddMessageEventFilter("CHAT_MSG_WHISPER", addIcons)
ChatFrame_AddMessageEventFilter("CHAT_MSG_WHISPER_INFORM", addIcons)


local types = {
    item        = "ItemID:",
	currency    = "CurrencyID:"
}

local function addLine(tooltip, id, type)
    local found = false

   
    for i = 1,15 do
        local frame = _G[tooltip:GetName() .. "TextLeft" .. i]
        local text
        if frame then text = frame:GetText() end
        if text and text == type then found = true break end
    end

    if not found then
        tooltip:AddDoubleLine(type, "|cffffffff" .. id)
        tooltip:Show()
    end
end

local function onSetHyperlink(self, link)
    local type, id = string.match(link,"^(%a+):(%d+)")
    if not type or not id then return end
    if type == "item" then
        addLine(self, id, types.item)
    elseif type == "currency" then
        addLine(self, id, types.currency)
    end
end

hooksecurefunc(ItemRefTooltip, "SetHyperlink", onSetHyperlink)
hooksecurefunc(GameTooltip, "SetHyperlink", onSetHyperlink)

local function attachItemTooltip(self)
  local link = select(2, self:GetItem())
  if link then
    local id = select(3, strfind(link, "^|%x+|Hitem:(%-?%d+):(%d+):(%d+):(%d+):(%d+):(%d+):(%-?%d+):(%-?%d+)"))
    if id == "0" and TradeSkillFrame ~= nil and TradeSkillFrame:IsVisible() then
      if (GetMouseFocus():GetName()) == "TradeSkillSkillIcon" then
        id = GetTradeSkillItemLink(TradeSkillFrame.selectedSkill):match("item:(%d+):") or nil
      else
        for i = 1, 8 do
          if (GetMouseFocus():GetName()) == "TradeSkillReagent"..i then
            id = GetTradeSkillReagentItemLink(TradeSkillFrame.selectedSkill, i):match("item:(%d+):") or nil
            break
          end
        end
      end
    end
    if id then
      addLine(self, id, types.item)
    end
  end
end

GameTooltip:HookScript("OnTooltipSetItem", attachItemTooltip)
ItemRefTooltip:HookScript("OnTooltipSetItem", attachItemTooltip)
ItemRefShoppingTooltip1:HookScript("OnTooltipSetItem", attachItemTooltip)
ItemRefShoppingTooltip2:HookScript("OnTooltipSetItem", attachItemTooltip)
ShoppingTooltip1:HookScript("OnTooltipSetItem", attachItemTooltip)
ShoppingTooltip2:HookScript("OnTooltipSetItem", attachItemTooltip)

hooksecurefunc(GameTooltip, "SetCurrencyToken", function(self, index)
	local id = tonumber(string.match(GetCurrencyListLink(index),"currency:(%d+)"))
	if id then addLine(self, id, types.currency) end
end)

hooksecurefunc(GameTooltip, "SetCurrencyByID", function(self, id)
   if id then addLine(self, id, types.currency) end
end)

hooksecurefunc(GameTooltip, "SetCurrencyTokenByID", function(self, id)
   if id then addLine(self, id, types.currency) end
end)