-- ==============================
-- CONFIGURAZIONE SALVATA
-- ==============================
SGI_Config = SGI_Config or {
    minLevel = 1,
    maxLevel = 255
}

-- ==============================
-- FUNZIONE DI CONTROLLO FILTRO
-- ==============================
local function IsTargetEligible()
    if not UnitExists("target") or not UnitIsPlayer("target") then
        print("|cffff0000[SGI]|r No players selected.")
        return false
    end
    
    local level = UnitLevel("target")
    if level < SGI_Config.minLevel or level > SGI_Config.maxLevel then
        print("|cffff0000[SGI]|r Invalid level (" .. level .. "). Required in " .. SGI_Config.minLevel .. " e " .. SGI_Config.maxLevel .. ".")
        return false
    end
    
    return true
end

-- ==============================
-- PULSANTE "INVITA TARGET"
-- ==============================
local inviteButton = CreateFrame("Button", "SGI_InviteButton", UIParent, "UIPanelButtonTemplate")
inviteButton:SetSize(120, 30)
inviteButton:SetText("Invite Target")
inviteButton:SetPoint("CENTER")
inviteButton:SetMovable(true)
inviteButton:EnableMouse(true)
inviteButton:RegisterForDrag("LeftButton")
inviteButton:SetScript("OnDragStart", inviteButton.StartMoving)
inviteButton:SetScript("OnDragStop", inviteButton.StopMovingOrSizing)

inviteButton:SetScript("OnClick", function()
    if IsTargetEligible() then
        GuildInvite(UnitName("target"))
        print("|cff00ff00[SGI]|r Invited to the guild: " .. UnitName("target"))
    end
end)

inviteButton:Hide()

-- ==============================
-- BOTTONE MINIMAPPA SPOSTABILE
-- ==============================
local miniBtn = CreateFrame("Button", "SGI_MinimapButton", Minimap)
miniBtn:SetSize(32, 32)
miniBtn:SetFrameStrata("MEDIUM")
miniBtn:SetFrameLevel(8)
miniBtn:SetHighlightTexture("Interface\\Minimap\\UI-Minimap-ZoomButton-Highlight")

-- Icona personalizzata se presente
local icon = miniBtn:CreateTexture(nil, "BACKGROUND")
icon:SetSize(20, 20)

local customIconPath = "Interface\\AddOns\\SmartGuildInviter\\minimap-icon.tga"

local function TextureExists(path)
    local tex = miniBtn:CreateTexture()
    tex:SetTexture(path)
    local success = tex:GetTexture() ~= nil
    tex:Hide()
    tex:SetTexture(nil)
    return success
end

if TextureExists(customIconPath) then
    icon:SetTexture(customIconPath)
else
    icon:SetTexture("Interface\\GuildFrame\\GuildLogo-NoLogoSm")
end

icon:SetPoint("CENTER")

miniBtn:SetNormalTexture(nil)

SGI_MinimapPos = SGI_MinimapPos or 45

local function UpdateMinimapButton()
    local angle = math.rad(SGI_MinimapPos)
    local x = math.cos(angle) * 80
    local y = math.sin(angle) * 80
    miniBtn:SetPoint("CENTER", Minimap, "CENTER", x, y)
end

miniBtn:SetScript("OnDragStart", function(self)
    self:SetScript("OnUpdate", function()
        local mx, my = Minimap:GetCenter()
        local px, py = GetCursorPosition()
        local scale = Minimap:GetEffectiveScale()
        px, py = px / scale, py / scale
        SGI_MinimapPos = math.deg(math.atan2(py - my, px - mx)) % 360
        UpdateMinimapButton()
    end)
end)

miniBtn:SetScript("OnDragStop", function(self)
    self:SetScript("OnUpdate", nil)
end)

miniBtn:RegisterForDrag("LeftButton")

miniBtn:SetScript("OnClick", function()
    if inviteButton:IsShown() then
        inviteButton:Hide()
    else
        inviteButton:Show()
    end
end)

miniBtn:SetScript("OnEnter", function(self)
    GameTooltip:SetOwner(self, "ANCHOR_LEFT")
    GameTooltip:AddLine("Smart Guild Inviter", 1, 1, 1)
    GameTooltip:AddLine("Click: Show/Hide Invite Target button", 0.8, 0.8, 0.8)
    GameTooltip:AddLine("Drag: Move icon on minimap", 0.8, 0.8, 0.8)
    GameTooltip:Show()
end)

miniBtn:SetScript("OnLeave", function()
    GameTooltip:Hide()
end)

SLASH_SMARTGUILDINVITER1 = "/sgi"
SlashCmdList["SMARTGUILDINVITER"] = function()
    if inviteButton:IsShown() then
        inviteButton:Hide()
    else
        inviteButton:Show()
    end
end

UpdateMinimapButton()

-- ==============================
-- PANNELLO OPZIONI
-- ==============================
local optionsPanel = CreateFrame("Frame", "SGI_OptionsPanel", InterfaceOptionsFramePanelContainer)
optionsPanel.name = "Smart Guild Inviter"

local title = optionsPanel:CreateFontString(nil, "OVERLAY", "GameFontNormalLarge")
title:SetPoint("TOPLEFT", 16, -16)
title:SetText("Smart Guild Inviter - Option")

-- Min Level
local minLabel = optionsPanel:CreateFontString(nil, "OVERLAY", "GameFontNormal")
minLabel:SetPoint("TOPLEFT", title, "BOTTOMLEFT", 0, -20)
minLabel:SetText("Min Level:")

local minInput = CreateFrame("EditBox", nil, optionsPanel, "InputBoxTemplate")
minInput:SetSize(50, 20)
minInput:SetPoint("LEFT", minLabel, "RIGHT", 10, 0)
minInput:SetAutoFocus(false)
minInput:SetNumeric(true)

-- Max Level
local maxLabel = optionsPanel:CreateFontString(nil, "OVERLAY", "GameFontNormal")
maxLabel:SetPoint("TOPLEFT", minLabel, "BOTTOMLEFT", 0, -20)
maxLabel:SetText("Max Level:")

local maxInput = CreateFrame("EditBox", nil, optionsPanel, "InputBoxTemplate")
maxInput:SetSize(50, 20)
maxInput:SetPoint("LEFT", maxLabel, "RIGHT", 10, 0)
maxInput:SetAutoFocus(false)
maxInput:SetNumeric(true)

-- Bottone Salva
local saveButton = CreateFrame("Button", nil, optionsPanel, "UIPanelButtonTemplate")
saveButton:SetSize(80, 22)
saveButton:SetPoint("TOPLEFT", maxLabel, "BOTTOMLEFT", 0, -20)
saveButton:SetText("Save")
saveButton:SetScript("OnClick", function()
    SGI_Config.minLevel = tonumber(minInput:GetText()) or 1
    SGI_Config.maxLevel = tonumber(maxInput:GetText()) or 255
    print("|cff00ff00[SGI]|r Level " .. SGI_Config.minLevel .. " - " .. SGI_Config.maxLevel)
end)

-- Bottone Reset
local resetButton = CreateFrame("Button", nil, optionsPanel, "UIPanelButtonTemplate")
resetButton:SetSize(80, 22)
resetButton:SetPoint("LEFT", saveButton, "RIGHT", 10, 0)
resetButton:SetText("Reset")
resetButton:SetScript("OnClick", function()
    SGI_Config.minLevel = 1
    SGI_Config.maxLevel = 255
    minInput:SetText(SGI_Config.minLevel)
    maxInput:SetText(SGI_Config.maxLevel)
    print("|cffffcc00[SGI]|r Level 1 - 255")
end)

-- Quando si apre il pannello
optionsPanel:SetScript("OnShow", function()
    minInput:SetText(SGI_Config.minLevel)
    maxInput:SetText(SGI_Config.maxLevel)
end)

InterfaceOptions_AddCategory(optionsPanel)
