-- Sleek Free Bag Slots 7.3.5.0
-- Original Author: sarf; Re-Write Author: Ulti/Ultinor/Ultimor; Co-Author: Zorched/inifiniterage; Cataclysm Update by: DonCorneo/personanongratis; Special thanks to the coders at WowAce for helping fix sfbs.
--(berSleeked version of Free Bag Slots)

local free

local total

local function spew(msg)
	DEFAULT_CHAT_FRAME:AddMessage(sfbs.NAME..": "..msg);
end

local function RegEvents(self)
	if sfbsOPT.disabled then self:UnregisterEvent("BAG_UPDATE")
	else self:RegisterEvent("BAG_UPDATE")
	end;
end

local function checkshown()
	if sfbsOPT.hidebag or sfbsOPT.disabled then for i = 0,4 do sfbs.bag[i]:Hide(); end
	else for i = 0,4 do sfbs.bag[i]:Show(); end
	end
	if not sfbsOPT.glo or sfbsOPT.disabled then sfbsTotal:Hide()
	else sfbsTotal:Show()
	end
end

local function IsSpecial(bag)
	local link = GetInventoryItemLink("player",GetInventorySlotInfo("bag"..bag-1 .."slot"))
	if (not link) then return true; end;
	local _,_,_,_,_,type,subtype = GetItemInfo(link);
	if type == sfbs.Container and subtype == sfbs.Bag then return nil; end
	return true
end

local function GetFree(bag,t)
	free = 0
	while (t > 0) do
		if not GetContainerItemInfo(bag,t) then free = free + 1; end
		t = t - 1
	end;
	return free
end

local function GetNumbers(bag)
	if bag == -1 then
		if sfbsOPT.hidefree then
			-- Update shortcircuits if both hidefree and hidetotal are on.
			return sfbs.tt
		else
			if sfbs.tt == 0 then sfbs.tt = 16; end
			if sfbsOPT.col then local p=sfbs.tf/sfbs.tt; sfbsTotal:SetTextColor(math.sqrt(1-p),math.sqrt(p),0.1); end
			if sfbsOPT.hidetotal then return sfbs.tf
			else return sfbs.tf.."/"..sfbs.tt
			end
		end
	end
	local glob = sfbsOPT.glo
	total = GetContainerNumSlots(bag)
	if total == 0 then return; end
	if bag > 0 and IsSpecial(bag) then
		if sfbsOPT.hideamm then sfbs.bag[bag]:Hide()
		else sfbs.bag[bag]:Show()
		end
		if sfbsOPT.skipamm then
			if sfbsOPT.hideamm then return
			else glob = nil
			end
		end
	end

	if sfbsOPT.hidefree then
		-- Update shortcircuits if both hidefree and hidetotal are on.
		if glob then sfbs.tt = sfbs.tt + total; end; return total
	else
		free = GetFree(bag,total)
		if glob then sfbs.tt = sfbs.tt + total; sfbs.tf = sfbs.tf + free; end
		if sfbsOPT.col then local p=free/total; sfbs.bag[bag]:SetTextColor(math.sqrt(1-p),math.sqrt(p),0.1); end
		if sfbsOPT.hidetotal then return free
		else return free.."/"..total
		end
	end
end

local function Update()
	if sfbsOPT.disabled or (not sfbsOPT.glo and sfbsOPT.hidebag) or (sfbsOPT.hidetotal and sfbsOPT.hidefree) then return; end
	sfbs.tf,sfbs.tt = 0,0
	for i = 0,4 do
		if sfbsOPT.hidebag then
			GetNumbers(i)
		else
			sfbs.bag[i]:SetText(GetNumbers(i))
		end
	end
	if sfbsOPT.glo then
		sfbsTotal:SetText(GetNumbers(-1))
	end
end

local function Toggle(option, msg, invert)
	sfbsOPT[option] = not sfbsOPT[option]
	if sfbsOPT[option] == not invert then
		spew(msg .. sfbs.ENABLED)
		return true
	else
		spew(msg .. sfbs.DISABLED)
		return nil
	end
end

local function Slasher(msg)
	if not msg then spew(sfbs.USAGE); return;
	end;
	if (strfind(msg,"toggle")) then
		Toggle("disabled", "", true)
		RegEvents()
	elseif (strfind(msg,"total")) then
		Toggle("hidetotal", sfbs.TOTAL, true)
	elseif (strfind(msg,"free")) then
		Toggle("hidefree", sfbs.FREE, true)
	elseif (strfind(msg,"showam")) then
		Toggle("hideamm", sfbs.AMM, true)
	elseif (strfind(msg,"colour")) then
		if not Toggle('col', sfbs.COL) then
			for i = 0,4 do sfbs.bag[i]:SetTextColor(1,1,1); end; sfbsTotal:SetTextColor(1,1,1,1)
		end;
	elseif (strfind(msg,"global")) then
		if Toggle('glo', sfbs.GLOBAL) then sfbsTotal:Hide()
		else sfbsTotal:Show()
		end
	elseif strfind(msg,"perbag") then
		Toggle("hidebag", sfbs.PERBAG, true)
	elseif strfind(msg,"count") then
		Toggle("skipamm", sfbs.COUNTAMM, true)
	else spew(sfbs.USAGE); return;
	end;
	if (sfbsT) then TitanPanelButton_UpdateButton("SFBS"); end;
	checkshown()
	Update();
end

function sfbs.OnEvent(self, event, ...)
	if not sfbsOPT then sfbsOPT={skipamm = true}; end
	sfbs.bag = {}
	for i = 0,4 do
		sfbs.bag[i] = _G[("sfbsBag"..i.."Text")]
	end

	checkshown()
	RegEvents(self)
	self:UnregisterEvent("VARIABLES_LOADED")
	sfbs.OnEvent = Update
end

SlashCmdList["SFBSSLASHMAIN"] = Slasher;
SLASH_SFBSSLASHMAIN1 = "/sleekfreebagslots";
SLASH_SFBSSLASHMAIN2 = "/sfbs";
spew(sfbs.VERSION.." loaded! "..sfbs.USAGE);
