local aName, aObj = ...
local _G = _G
-- This is a Library

aObj.libsToSkin["LibToast-1.0"] = function(self) -- v 7.0.3.2
	if self.initialized.LibToast then return end
	self.initialized.LibToast = true

	local lT = _G.LibStub("LibToast-1.0", true)
	if lT then
		-- add metatable to skin new frames
		_G.setmetatable(lT.active_toasts, {__newindex = function(t, k, v)
			_G.rawset(t, k, v)
			aObj:addSkinFrame{obj=v}
			v.SetBackdrop = _G.nop
		end})
		-- skin any existing frames
		for i = 1, #lT.active_toasts do
			self:addSkinFrame{obj=lT.active_toasts[i]}
			lT.active_toasts[i].SetBackdrop = _G.nop
		end
	end

end
