local LibSound = CogWheel:Set("LibSound", 1)
if (not LibSound) then	
	return
end

-- We require this library to properly handle startup events
local LibClientBuild = CogWheel("LibClientBuild")
assert(LibClientBuild, "LibSound requires LibClientBuild to be loaded.")

-- Lua API
local _G = _G
local pairs = pairs

-- Blizzard API
local PlaySoundFile = _G.PlaySoundFile
local PlaySoundKitID = LibClientBuild:IsBuild("7.3.0") and _G.PlaySound or _G.PlaySoundKitID
local StopSound = _G.StopSound

LibSound.embeds = LibSound.embeds or {}

-- This will hardly ever be needed, 
-- but I'm leaving it here for my own personal reference. 
-- Nice to have an overview of the various IDs.
if (not _G.SOUNDKIT) then 
	_G.SOUNDKIT = {
		ACHIEVEMENT_MENU_CLOSE = 13833,
		ACHIEVEMENT_MENU_OPEN = 13832,
		ALARM_CLOCK_WARNING_1 = 18871,
		ALARM_CLOCK_WARNING_2 = 12867,
		ALARM_CLOCK_WARNING_3 = 12889,
		AMB_50_GLUESCREEN_ALLIANCE = 32412,
		AMB_50_GLUESCREEN_HORDE = 32413,
		AMB_50_GLUESCREEN_PANDAREN_NEUTRAL = 32414,
		AMB_GLUESCREEN_BLOODELF = 9910,
		AMB_GLUESCREEN_DEATHKNIGHT = 37056,
		AMB_GLUESCREEN_DEMONHUNTER = 56352,
		AMB_GLUESCREEN_DRAENEI = 9911,
		AMB_GLUESCREEN_DWARF = 9907,
		AMB_GLUESCREEN_GNOME = 21137,
		AMB_GLUESCREEN_GOBLIN = 20170,
		AMB_GLUESCREEN_HUMAN = 9903,
		AMB_GLUESCREEN_LEGION = 71535,
		AMB_GLUESCREEN_NIGHTELF = 9908,
		AMB_GLUESCREEN_ORC = 9905,
		AMB_GLUESCREEN_PANDAREN = 25848,
		AMB_GLUESCREEN_TAUREN = 9906,
		AMB_GLUESCREEN_TROLL = 21136,
		AMB_GLUESCREEN_UNDEAD = 9909,
		AMB_GLUESCREEN_WARLORDS_OF_DRAENOR = 47544,
		AMB_GLUESCREEN_WORGEN = 20169,
		AUCTION_WINDOW_CLOSE = 5275,
		AUCTION_WINDOW_OPEN = 5274,
		BARBERSHOP_HAIRCUT = 13873,
		BARBERSHOP_SIT = 14148,
		FISHING_REEL_IN = 3407,
		GLUESCREEN_INTRO = 9902,
		GM_CHAT_WARNING = 15273,
		GS_CATACLYSM = 23640,
		GS_CHARACTER_CREATION_CANCEL = 819,
		GS_CHARACTER_CREATION_CLASS = 814,
		GS_CHARACTER_CREATION_CREATE_CHAR = 818,
		GS_CHARACTER_CREATION_LOOK = 817,
		GS_CHARACTER_SELECTION_ACCT_OPTIONS = 811,
		GS_CHARACTER_SELECTION_CREATE_NEW = 813,
		GS_CHARACTER_SELECTION_DEL_CHARACTER = 810,
		GS_CHARACTER_SELECTION_ENTER_WORLD = 809,
		GS_CHARACTER_SELECTION_EXIT = 812,
		GS_LICH_KING = 12765,
		GS_LOGIN = 800,
		GS_LOGIN_CHANGE_REALM_CANCEL = 807,
		GS_LOGIN_CHANGE_REALM_OK = 805,
		GS_LOGIN_NEW_ACCOUNT = 801,
		GS_TITLE_CREDITS = 790,
		GS_TITLE_OPTION_EXIT = 799,
		GS_TITLE_OPTION_OK = 798,
		GS_TITLE_OPTIONS = 778,
		GUILD_BANK_OPEN_BAG = 12206,
		GUILD_VAULT_CLOSE = 12189,
		GUILD_VAULT_OPEN = 12188,
		IG_ABILITY_CLOSE = 835,
		IG_ABILITY_ICON_DROP = 838,
		IG_ABILITY_OPEN = 834,
		IG_ABILITY_PAGE_TURN = 836,
		IG_BACKPACK_CLOSE = 863,
		IG_BACKPACK_COIN_CANCEL = 866,
		IG_BACKPACK_COIN_OK = 865,
		IG_BACKPACK_COIN_SELECT = 864,
		IG_BACKPACK_OPEN = 862,
		IG_CHARACTER_INFO_CLOSE = 840,
		IG_CHARACTER_INFO_OPEN = 839,
		IG_CHARACTER_INFO_TAB = 841,
		IG_CHARACTER_NPC_SELECT = 867,
		IG_CHAT_BOTTOM = 828,
		IG_CHAT_EMOTE_BUTTON = 825,
		IG_CHAT_SCROLL_DOWN = 827,
		IG_CHAT_SCROLL_UP = 826,
		IG_CREATURE_AGGRO_SELECT = 873,
		IG_CREATURE_NEUTRAL_SELECT = 871,
		IG_INVENTORY_ROTATE_CHARACTER = 861,
		IG_MAINMENU_CLOSE = 851,
		IG_MAINMENU_CONTINUE = 855,
		IG_MAINMENU_LOGOUT = 853,
		IG_MAINMENU_OPEN = 850,
		IG_MAINMENU_OPTION = 852,
		IG_MAINMENU_OPTION_CHECKBOX_OFF = 857,
		IG_MAINMENU_OPTION_CHECKBOX_ON = 856,
		IG_MAINMENU_OPTION_FAER_TAB = 858,
		IG_MAINMENU_QUIT = 854,
		IG_MINIMAP_CLOSE = 822,
		IG_MINIMAP_OPEN = 821,
		IG_MINIMAP_ZOOM_IN = 823,
		IG_MINIMAP_ZOOM_OUT = 824,
		IG_PLAYER_INVITE = 880,
		IG_PVP_UPDATE = 4574,
		IG_QUEST_CANCEL = 879,
		IG_QUEST_LIST_CLOSE = 876,
		IG_QUEST_LIST_COMPLETE = 878,
		IG_QUEST_LIST_OPEN = 875,
		IG_QUEST_LIST_SELECT = 877,
		IG_QUEST_LOG_ABANDON_QUEST = 846,
		IG_QUEST_LOG_CLOSE = 845,
		IG_QUEST_LOG_OPEN = 844,
		IG_SPELLBOOK_CLOSE = 830,
		IG_SPELLBOOK_OPEN = 829,
		INTERFACE_SOUND_LOST_TARGET_UNIT = 684,
		ITEM_REPAIR = 7994,
		JEWEL_CRAFTING_FINALIZE = 10590,
		KEY_RING_CLOSE = 8939,
		KEY_RING_OPEN = 8938,
		LFG_DENIED = 17341,
		LFG_REWARDS = 17316,
		LFG_ROLE_CHECK = 17317,
		LOOT_WINDOW_COIN_SOUND = 120,
		LOOT_WINDOW_OPEN_EMPTY = 1264,
		MAP_PING = 3175,
		MENU_CREDITS01 = 10763,
		MENU_CREDITS02 = 10804,
		MENU_CREDITS03 = 13822,
		MENU_CREDITS04 = 23812,
		MENU_CREDITS05 = 32015,
		MENU_CREDITS06 = 34020,
		MENU_CREDITS07 = 56354,
		MONEY_FRAME_CLOSE = 892,
		MONEY_FRAME_OPEN = 891,
		MUS_1_0_MAINTITLE_ORIGINAL = 47598,
		MUS_50_HEART_OF_PANDARIA_MAINTITLE = 28509,
		MUS_60_MAIN_TITLE = 40169,
		MUS_70_MAIN_TITLE = 56353,
		PICK_UP_GEMS = 1221,
		PUT_DOWN_GEMS = 1204,
		PUT_DOWN_SMALL_CHAIN = 1212,
		PVP_ENTER_QUEUE = 8458,
		PVP_THROUGH_QUEUE = 8459,
		RAID_BOSS_EMOTE_WARNING = 12197,
		RAID_WARNING = 8959,
		READY_CHECK = 8960,
		TELL_MESSAGE = 3081,
		TUTORIAL_POPUP = 7355,
		U_CHAT_SCROLL_BUTTON = 1115,
		UI_70_ARTIFACT_FORGE_APPEARANCE_APPEARANCE_CHANGE = 54132,
		UI_70_ARTIFACT_FORGE_APPEARANCE_APPEARANCE_UNLOCK = 54139,
		UI_70_ARTIFACT_FORGE_APPEARANCE_COLOR_SELECT = 54130,
		UI_70_ARTIFACT_FORGE_APPEARANCE_LOCKED = 54131,
		UI_70_ARTIFACT_FORGE_RELIC_PLACE = 54128,
		UI_70_ARTIFACT_FORGE_TOAST_TRAIT_AVAILABLE = 54133,
		UI_70_ARTIFACT_FORGE_TRAIT_FINALRANK = 54127,
		UI_70_ARTIFACT_FORGE_TRAIT_FIRST_TRAIT = 54126,
		UI_70_ARTIFACT_FORGE_TRAIT_GOLD_TRAIT = 54125,
		UI_70_ARTIFACT_FORGE_TRAIT_RANKUP = 54129,
		UI_70_BOOST_THANKSFORPLAYING = 72977,
		UI_70_BOOST_THANKSFORPLAYING_SMALLER = 72978,
		UI_70_CHALLENGE_MODE_COMPLETE_NO_UPGRADE = 74526,
		UI_70_CHALLENGE_MODE_KEYSTONE_UPGRADE = 74437,
		UI_70_CHALLENGE_MODE_NEW_RECORD = 74438,
		UI_70_CHALLENGE_MODE_SOCKET_PAGE_ACTIVATE_BUTTON = 74432,
		UI_70_CHALLENGE_MODE_SOCKET_PAGE_CLOSE = 74423,
		UI_70_CHALLENGE_MODE_SOCKET_PAGE_OPEN = 74421,
		UI_70_CHALLENGE_MODE_SOCKET_PAGE_REMOVE_KEYSTONE = 74525,
		UI_70_CHALLENGE_MODE_SOCKET_PAGE_SOCKET = 74431,
		UI_71_SOCIAL_QUEUEING_TOAST = 79739,
		UI_72_ARTIFACT_FORGE_ACTIVATE_FINAL_TIER = 83681,
		UI_72_ARTIFACT_FORGE_FINAL_TRAIT_REFUND_LOOP = 83685,
		UI_72_ARTIFACT_FORGE_FINAL_TRAIT_REFUND_START = 83684,
		UI_72_ARTIFACT_FORGE_FINAL_TRAIT_UNLOCKED = 83682,
		UI_72_BUILDING_CONTRIBUTION_TABLE_OPEN = 84368,
		UI_72_BUILDINGS_CONTRIBUTE_POWER_MENU_CLICK = 84240,
		UI_72_BUILDINGS_CONTRIBUTE_RESOURCES = 84378,
		UI_72_BUILDINGS_CONTRIBUTION_TABLE_CLOSE = 84369,
		UI_73_ARTIFACT_RELICS_TRAIT_REVEAL_ONLY = 90080,
		UI_73_ARTIFACT_RELICS_TRAIT_SELECT_AND_REVEAL = 89685,
		UI_73_ARTIFACT_RELICS_TRAIT_SELECT_ONLY = 89686,
		UI_AUTO_QUEST_COMPLETE = 23404,
		UI_BAG_SORTING_01 = 43937,
		UI_BATTLEGROUND_COUNTDOWN_FINISHED = 25478,
		UI_BATTLEGROUND_COUNTDOWN_TIMER = 25477,
		UI_BNET_TOAST = 18019,
		UI_BONUS_EVENT_SYSTEM_VIGNETTES = 45142,
		UI_BONUS_LOOT_ROLL_END = 31581,
		UI_BONUS_LOOT_ROLL_LOOP = 31580,
		UI_BONUS_LOOT_ROLL_START = 31579,
		UI_CHALLENGES_NEW_RECORD = 33338,
		UI_DIG_SITE_COMPLETION_TOAST = 38326,
		UI_EPICLOOT_TOAST = 31578,
		UI_ETHEREAL_WINDOW_CLOSE = 25717,
		UI_ETHEREAL_WINDOW_OPEN = 25716,
		UI_GARRISON_ARCHITECT_TABLE_BUILDING_PLACEMENT = 44308,
		UI_GARRISON_ARCHITECT_TABLE_BUILDING_PLACEMENT_ERROR = 47355,
		UI_GARRISON_ARCHITECT_TABLE_BUILDING_SELECT = 44307,
		UI_GARRISON_ARCHITECT_TABLE_CLOSE = 44301,
		UI_GARRISON_ARCHITECT_TABLE_OPEN = 44300,
		UI_GARRISON_ARCHITECT_TABLE_PLOT_SELECT = 44306,
		UI_GARRISON_ARCHITECT_TABLE_UPGRADE = 44302,
		UI_GARRISON_ARCHITECT_TABLE_UPGRADE_CANCEL = 44304,
		UI_GARRISON_ARCHITECT_TABLE_UPGRADE_START = 44305,
		UI_GARRISON_COMMAND_TABLE_100_SUCCESS = 44322,
		UI_GARRISON_COMMAND_TABLE_ASSIGN_FOLLOWER = 44319,
		UI_GARRISON_COMMAND_TABLE_CHEST_UNLOCK = 44331,
		UI_GARRISON_COMMAND_TABLE_CHEST_UNLOCK_GOLD_SUCCESS = 44332,
		UI_GARRISON_COMMAND_TABLE_CLOSE = 44312,
		UI_GARRISON_COMMAND_TABLE_FOLLOWER_ABILITY_CLOSE = 44318,
		UI_GARRISON_COMMAND_TABLE_FOLLOWER_ABILITY_OPEN = 44317,
		UI_GARRISON_COMMAND_TABLE_FOLLOWER_LEVEL_UP = 46893,
		UI_GARRISON_COMMAND_TABLE_INCREASED_SUCCESS_CHANCE = 51570,
		UI_GARRISON_COMMAND_TABLE_MISSION_CLOSE = 44313,
		UI_GARRISON_COMMAND_TABLE_MISSION_START = 44323,
		UI_GARRISON_COMMAND_TABLE_MISSION_SUCCESS_STINGER = 44330,
		UI_GARRISON_COMMAND_TABLE_NAV_NEXT = 44314,
		UI_GARRISON_COMMAND_TABLE_OPEN = 44311,
		UI_GARRISON_COMMAND_TABLE_REDUCED_SUCCESS_CHANCE = 44321,
		UI_GARRISON_COMMAND_TABLE_SELECT_FOLLOWER = 44316,
		UI_GARRISON_COMMAND_TABLE_SELECT_MISSION = 44315,
		UI_GARRISON_COMMAND_TABLE_SLOT_CHAMPION = 72546,
		UI_GARRISON_COMMAND_TABLE_SLOT_TROOP = 72547,
		UI_GARRISON_COMMAND_TABLE_UNASSIGN_FOLLOWER = 44320,
		UI_GARRISON_COMMAND_TABLE_VIEW_MISSION_REPORT = 44324,
		UI_GARRISON_FOLLOWER_LEARN_TRAIT = 51324,
		UI_GARRISON_GARRISON_REPORT_CLOSE = 44299,
		UI_GARRISON_GARRISON_REPORT_OPEN = 44298,
		UI_GARRISON_MISSION_100_PERCENT_CHANCE_REACHED_NOT_USED = 43507,
		UI_GARRISON_MISSION_COMPLETE_ENCOUNTER_CHANCE = 0,
		UI_GARRISON_MISSION_COMPLETE_ENCOUNTER_FAIL = 43501,
		UI_GARRISON_MISSION_COMPLETE_MISSION_FAIL_STINGER = 43503,
		UI_GARRISON_MISSION_COMPLETE_MISSION_SUCCESS = 43502,
		UI_GARRISON_MISSION_ENCOUNTER_ANIMATION_GENERIC = 47704,
		UI_GARRISON_MISSION_THREAT_COUNTERED = 43505,
		UI_GARRISON_MONUMENTS_CLOSE = 47373,
		UI_GARRISON_MONUMENTS_NAV = 48942,
		UI_GARRISON_MONUMENTS_OPEN = 44344,
		UI_GARRISON_NAV_TABS = 44297,
		UI_GARRISON_SHIPMENTS_WINDOW_CLOSE = 48192,
		UI_GARRISON_SHIPMENTS_WINDOW_OPEN = 48191,
		UI_GARRISON_SHIPYARD_DECOMISSION_SHIP = 51871,
		UI_GARRISON_SHIPYARD_PLACE_CARRIER = 51385,
		UI_GARRISON_SHIPYARD_PLACE_DREADNOUGHT = 51388,
		UI_GARRISON_SHIPYARD_PLACE_GALLEON = 51387,
		UI_GARRISON_SHIPYARD_PLACE_LANDING_CRAFT = 51390,
		UI_GARRISON_SHIPYARD_PLACE_SUBMARINE = 51389,
		UI_GARRISON_SHIPYARD_START_MISSION = 51401,
		UI_GARRISON_START_WORK_ORDER = 47972,
		UI_GARRISON_TOAST_BUILDING_COMPLETE = 44295,
		UI_GARRISON_TOAST_FOLLOWER_GAINED = 44296,
		UI_GARRISON_TOAST_INVASION_ALERT = 44292,
		UI_GARRISON_TOAST_MISSION_COMPLETE = 44294,
		UI_GROUP_FINDER_RECEIVE_APPLICATION = 47615,
		UI_IG_STORE_BUY_BUTTON = 39515,
		UI_IG_STORE_CANCEL_BUTTON = 39514,
		UI_IG_STORE_CONFIRM_PURCHASE_BUTTON = 39516,
		UI_IG_STORE_PAGE_NAV_BUTTON = 39511,
		UI_IG_STORE_PURCHASE_DELIVERED_TOAST_01 = 39517,
		UI_IG_STORE_WINDOW_CLOSE_BUTTON = 39513,
		UI_IG_STORE_WINDOW_OPEN_BUTTON = 39512,
		UI_LEGENDARY_LOOT_TOAST = 63971,
		UI_LOSS_OF_CONTROL_START = 34468,
		UI_MISSION_200_PERCENT = 72548,
		UI_MISSION_MAP_ZOOM = 72549,
		UI_MISSION_SUCCESS_CHEERS = 74702,
		UI_ORDERHALL_TALENT_NUKE_FROM_ORBIT = 73282,
		UI_ORDERHALL_TALENT_READY_CHECK = 73281,
		UI_ORDERHALL_TALENT_READY_TOAST = 73280,
		UI_ORDERHALL_TALENT_SELECT = 73279,
		UI_ORDERHALL_TALENT_WINDOW_CLOSE = 73915,
		UI_ORDERHALL_TALENT_WINDOW_OPEN = 73914,
		UI_PERSONAL_LOOT_BANNER = 50893,
		UI_PET_BATTLE_CAMERA_MOVE_IN = 32047,
		UI_PET_BATTLE_CAMERA_MOVE_OUT = 32052,
		UI_PET_BATTLE_START = 31584,
		UI_PET_BATTLES_PVP_THROUGH_QUEUE = 36609,
		UI_PET_BATTLES_TRAP_READY = 28814,
		UI_POWER_AURA_GENERIC = 23287,
		UI_PROFESSIONS_NEW_RECIPE_LEARNED_TOAST = 73919,
		UI_PROFESSIONS_WINDOW_CLOSE = 73918,
		UI_PROFESSIONS_WINDOW_OPEN = 73917,
		UI_PVP_HONOR_PRESTIGE_OPEN_WINDOW = 76995,
		UI_PVP_HONOR_PRESTIGE_RANK_UP = 77003,
		UI_PVP_HONOR_PRESTIGE_WINDOW_CLOSE = 77002,
		UI_QUEST_ROLLING_FORWARD_01 = 43936,
		UI_RAID_BOSS_DEFEATED = 50111,
		UI_RAID_BOSS_WHISPER_WARNING = 37666,
		UI_RAID_LOOT_TOAST_LESSER_ITEM_WON = 51402,
		UI_REFORGING_REFORGE = 23291,
		UI_SCENARIO_ENDING = 31754,
		UI_SCENARIO_STAGE_END = 31757,
		UI_STORE_UNWRAP = 64329,
		UI_TOYBOX_TABS = 43938,
		UI_TRANSMOG_APPLY = 62542,
		UI_TRANSMOG_CLOSE_WINDOW = 62543,
		UI_TRANSMOG_GEAR_SLOT_CLICK = 62540,
		UI_TRANSMOG_ITEM_CLICK = 62538,
		UI_TRANSMOG_OPEN_WINDOW = 62544,
		UI_TRANSMOG_PAGE_TURN = 62539,
		UI_TRANSMOG_REVERTING_GEAR_SLOT = 62541,
		UI_TRANSMOGRIFY_REDO = 25738,
		UI_TRANSMOGRIFY_UNDO = 25715,
		UI_VOID_STORAGE_BOTH = 25744,
		UI_VOID_STORAGE_DEPOSIT = 25712,
		UI_VOID_STORAGE_UNLOCK = 25711,
		UI_VOID_STORAGE_WITHDRAW = 25713,
		UI_WARFORGED_ITEM_LOOT_TOAST = 51561,
		UI_WORLDQUEST_COMPLETE = 73277,
		UI_WORLDQUEST_MAP_SELECT = 73276,
		UI_WORLDQUEST_START = 73275
	}
end 

-- @return willPlay, soundHandle
LibSound.PlaySoundKitID = function(self, soundKitID, channel, forceNoDuplicates, runFinishCallback)
	return PlaySoundKitID(soundKitID, channel, forceNoDuplicates, runFinishCallback)
end

-- @return willPlay, soundHandle
LibSound.PlaySoundFile = function(self, path, channel)
	return PlaySoundFile(path, channel)
end

LibSound.StopSound = function(self, soundHandle)
	return StopSound(soundHandle)
end 

local embedMethods = {
	PlaySoundKitID = true, 
	PlaySoundFile = true,
	StopSound = true
}

LibSound.Embed = function(self, target)
	for method in pairs(embedMethods) do
		target[method] = self[method]
	end
	self.embeds[target] = true
	return target
end

-- Upgrade existing embeds, if any
for target in pairs(LibSound.embeds) do
	LibSound:Embed(target)
end
