local L = LibStub("AceLocale-3.0"):GetLocale("SimpleILevel", true);
SIL_Avoid = LibStub("AceAddon-3.0"):NewAddon('SIL_Avoid', "AceEvent-3.0");

function SIL_Avoid:OnInitialize()
    SIL:Print("Avoidance Module Loaded", GetAddOnMetadata("SimpleILevel_Avoidance", "Version"));
    
    self.db = LibStub("AceDB-3.0"):New("SIL_AvoidSettings", SILAvoid_Defaults, true);
    SIL.aceConfig:RegisterOptionsTable("Avoidance", SILAvoid_Options, {"sila"});
    SIL.aceConfigDialog:AddToBlizOptions("Avoidance", AVOIDANCE, L.core.name);
    
    -- Hooks
    SIL:AddHook('tooltip', function(...) SIL_Avoid:Tooltip(...); end);
    SIL:AddHook('inspect', function(...) SIL_Avoid:Inspect(...); end);
 
    self:SetupSILMenu();
    SIL:AddHook('loadmodule', function(m) end);
end

function SIL_Avoid:SetupSILMenu()
    SIL:AddMenuItems('middle', {
        text = "Avoidance Options",
        isTitle = 1,
        notCheckable = 1,
    }, 1);
end

function SIL_Avoid:Inspect(guid, score, itemCount, age, itemTable)
	local totalAvoidance = 0;
	local aItems = 0;
	local total = 0;
	
	if itemTable and type(itemTable) == 'table' then
		for i,itemLink in pairs(itemTable) do
			local stats = GetItemStats(itemLink);

			if stats and stats['ITEM_MOD_CR_AVOIDANCE_SHORT'] then
				local raw = stats['ITEM_MOD_CR_AVOIDANCE_SHORT'];
				
				totalAvoidance = totalAvoidance + raw;
				aItems = aItems + 1;
			end
			
			total = total + 1;
		end
	end
	
	SIL_CacheGUID[guid].total_avoidance = totalAvoidance;
    SIL_CacheGUID[guid].avoidance_items = aItems;
end

function SIL_Avoid:Tooltip(guid)
    if guid then
        local totalAvoidance = SIL:Cache(guid, 'total_avoidance') or 0;

        if (totalAvoidance and totalAvoidance > 0) or self:GetTooltipZero() then
            local percent = self:AvoidanceToPercent(totalAvoidance);
            local colorMultiplier = 5;
            local multipliedPercent = percent * colorMultiplier;
            local finalPercent = 0;

            if multipliedPercent >= 100 then
                finalPercent = 99.9;
            else
                finalPercent = multipliedPercent;
            end

            local scaledPercent = (finalPercent / (100)) * (1000 - 630) + 630;
            local hexColor = SIL:ColorScore(scaledPercent, SIL.grayScore + 1);

            SIL:AddTooltipText('|cFF216bff'..STAT_AVOIDANCE..':|r', '|cFF'..hexColor..percent..'%|r');
        end
    end
end

function SIL_Avoid:AvoidanceToPercent(avoidance)
    local magicMultiplier = 0.0090918367346938775;
    local percent = tonumber(avoidance * magicMultiplier);
    local avoidancePercent = self:RoundPercent(percent);

    return avoidancePercent;
end

function SIL_Avoid:RoundPercent(percent)
    local numDecimalPlaces = 2;
    local mult = 10^(numDecimalPlaces or 0);

    return math.floor(percent * mult + 0.5) / mult;
end

-- /run for i=1,17 do print(i,SIL_Avoid:FormatScore(i,17,true)); end
function SIL_Avoid:ColorScore(percent)   
 --    -- There are some missing items so gray
	-- if items and items <= SIL.grayScore then
	-- 	return SIL:RGBtoHex(0.5,0.5,0.5), 0.5,0.5,0.5;
 --    end
    
 --    if not SIL:GetColorScore() then
 --        return SIL:RGBtoHex(1,1,1), 1,1,1;
 --    end
    
    return SIL:RGBtoHex(1 - percent, 1, 1 - percent), 1 - percent, 1, 1 - percent;
end


--[[
    Setters, Getters and Togglers
]]
function SIL_Avoid:GetTooltipZero() return self.db.global.tooltipZero; end
function SIL_Avoid:ToggleTooltipZero() self:SetTooltipZero(not self:GetTooltipZero()); end
function SIL_Avoid:SetTooltipZero(v) self.db.global.tooltipZero = v; end

SILAvoid_Options = {
	name = "Avoidance Options",
	type = "group",
	args = {       
        tooltipZero = {
            name = "Zero Tooltip",
            desc = "Shows information in the tooltip even if they have no avoidance gear.",
            type = "toggle",
            set = function(i,v) SIL_Avoid:SetTooltipZero(v); end,
            get = function(i) return SIL_Avoid:GetTooltipZero(); end,
            order = 11,
        },
    }
}

SILAvoid_Defaults = {
    global = {
        tooltip = 1;
        tooltipZero = false;
    },
};
