ShowQuestCountMixin = {}



local quests_label = QUESTS_LABEL .. " ("



local last_quest_count
local quests_counted
local quests_count_text



local cached_font_string = ObjectiveTrackerBlocksFrame.QuestHeader.Text



local GetNumQuestLogEntries = GetNumQuestLogEntries
local GetQuestLogTitle = GetQuestLogTitle

local function count_quests ()
	quests_counted = 0
	local _1, _2, _3, is_header, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, is_hidden
	for index = 1, GetNumQuestLogEntries () do
		_1, _2, _3, is_header, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, is_hidden = GetQuestLogTitle (index)
		if not is_hidden and not is_header then
			quests_counted = quests_counted + 1
		end
	end
end



local function update_quests_text ()
	quests_count_text = quests_label .. last_quest_count .. ")"
	cached_font_string:SetText (quests_count_text)
end



function ShowQuestCountMixin:OnEvent ()
	count_quests ()
	last_quest_count = quests_counted
	update_quests_text ()
end



function ShowQuestCountMixin:OnShow ()
	if ObjectiveTrackerBlocksFrame and ObjectiveTrackerBlocksFrame.QuestHeader then
		cached_font_string = ObjectiveTrackerBlocksFrame.QuestHeader.Text
	else
		cached_font_string = nil
	end

	if cached_font_string then
		count_quests ()
		last_quest_count = quests_counted
		update_quests_text ()
	else
		print ("ShowQuestCount failed to initialize.")
		self:UnregisterAllEvents ()
	end
end



function ShowQuestCountMixin:OnLoad ()
	self:RegisterEvent 'QUEST_ACCEPTED'
	self:RegisterEvent 'QUEST_AUTOCOMPLETE'
	self:RegisterEvent 'QUEST_LOG_CRITERIA_UPDATE'
	self:RegisterEvent 'QUEST_POI_UPDATE'
	self:RegisterEvent 'QUEST_REMOVED'
	self:RegisterEvent 'SUPER_TRACKED_QUEST_CHANGED'
	self:RegisterEvent 'QUEST_WATCH_LIST_CHANGED'
	self:RegisterUnitEvent ('UNIT_QUEST_LOG_CHANGED', 'player')
end
