local currentTab = "damage"

local damageTab, healTab

local function UpdateTabSelection()
    if currentTab == "damage" then
    damageTab:GetFontString():SetTextColor(1, 1, 0)  -- Gelb
    healTab:GetFontString():SetTextColor(1, 1, 1)    -- Weiß

    damageTab:SetSize(105, 25)
    healTab:SetSize(100, 22)
    else
        damageTab:GetFontString():SetTextColor(1, 1, 1)
        healTab:GetFontString():SetTextColor(1, 1, 0)

            damageTab:SetSize(100, 22)
            healTab:SetSize(105, 25)
    end
end


local function CreateHeaderLabel(parent, text, width, xOffset)
    local label = parent:CreateFontString(nil, "OVERLAY", "GameFontNormalSmall")
    label:SetPoint("LEFT", xOffset, 0)
    label:SetWidth(width)
    label:SetJustifyH("LEFT")
    label:SetText(text)
    return label
end


local function UpdateHeader(header)
    header.time:SetText(L["Time"])
    header.amount:SetText(currentTab == "heal" and L["Heal"] or L["Damage"])
    header.skill:SetText(L["Skill"])
    header.target:SetText(L["Target"])
    header.location:SetText(L["Location"])
end

local function InitHeader(header)
    header.time     = CreateHeaderLabel(header, L["Time"],                             60,  10)
    header.amount   = CreateHeaderLabel(header, currentTab == "heal" and L["Heal"] or L["Damage"], 60, 80)
    header.skill    = CreateHeaderLabel(header, L["Skill"],                           100, 150)
    header.target   = CreateHeaderLabel(header, L["Target"],                          120, 260)
    header.location = CreateHeaderLabel(header, L["Location"],                        120, 390)
end

local function RemoveAllChild(content)
  local children = { content:GetChildren() }
  for _, child in ipairs(children) do
      child:Hide()
      child:SetParent(nil)
  end
end

local function UpdateContent(content)

  RemoveAllChild(content)
  -- Datenquelle laden
      local playerName = UnitName("player") .. "-" .. GetRealmName()
      ShadowlessCritHighscore = ShadowlessCritHighscore or {}

        ShadowlessCritHighscore[playerName] = ShadowlessCritHighscore[playerName] or { damageLog = {}, healLog = {} }
        local dataRoot = ShadowlessCritHighscore[playerName]
        local data = (currentTab == "damage") and (dataRoot.damageLog or {}) or (dataRoot.healLog or {})

      local lineHeight = 20
      local numEntries = #data

      for i = 1, numEntries do
          local entryData = data[i]
          local entry = CreateFrame("Frame", nil, content)
          entry:SetSize(500, lineHeight)
          entry:SetPoint("TOPLEFT", 0, -((i - 1) * lineHeight))

          local time = entry:CreateFontString(nil, "OVERLAY", "GameFontHighlightSmall")
          time:SetPoint("LEFT", 10, 0)
          time:SetWidth(60)
          time:SetJustifyH("LEFT")
          time:SetText(entryData.time or "-")

          local amount = entry:CreateFontString(nil, "OVERLAY", "GameFontHighlightSmall")
          amount:SetPoint("LEFT", time, "RIGHT", 10, 0)
          amount:SetWidth(60)
          amount:SetJustifyH("LEFT")
          amount:SetText(tostring(entryData.amount or 0))

          local skill = entry:CreateFontString(nil, "OVERLAY", "GameFontHighlightSmall")
          skill:SetPoint("LEFT", amount, "RIGHT", 10, 0)
          skill:SetWidth(100)
          skill:SetJustifyH("LEFT")
          skill:SetText(tostring(entryData.skill or "?"))

          local target = entry:CreateFontString(nil, "OVERLAY", "GameFontHighlightSmall")
          target:SetPoint("LEFT", skill, "RIGHT", 10, 0)
          target:SetWidth(120)
          target:SetJustifyH("LEFT")
          target:SetText(entryData.target or "-")

          local location = entry:CreateFontString(nil, "OVERLAY", "GameFontHighlightSmall")
          location:SetPoint("LEFT", target, "RIGHT", 10, 0)
          location:SetWidth(120)
          location:SetJustifyH("LEFT")
          location:SetText(entryData.location or "-")
      end

      content:SetSize(500, numEntries * lineHeight)
  end
-- View Aufbau
function ShadowlessCrit_SetupCritLogPanel(panel)

    -- Titel
    local title = panel:CreateFontString(nil, "OVERLAY", "GameFontHighlightLarge")
    title:SetPoint("TOP", 0, -16)
    title:SetText(L["CritLogTitle"])

    -- Tabs mittig unter dem Titel
      local tabContainer = CreateFrame("Frame", nil, panel)
      tabContainer:SetSize(220, 22) -- Breite für beide Tabs + Abstand
      tabContainer:SetPoint("TOP", title, "BOTTOM", 0, -10)

    -- Tabs
    damageTab = CreateFrame("Button", nil, tabContainer , "UIPanelButtonTemplate")
    damageTab:SetSize(100, 22)
    damageTab:SetPoint("LEFT", 0, 0)
    damageTab:SetText(L["Damage"])
    damageTab:SetScript("OnClick", function()
        currentTab = "damage"
        UpdateHeader(header)
        UpdateContent(content)
        UpdateTabSelection()
    end)

    healTab = CreateFrame("Button", nil, tabContainer , "UIPanelButtonTemplate")
    healTab:SetSize(100, 22)
    healTab:SetPoint("LEFT", damageTab, "RIGHT", 20, 0)
    healTab:SetText(L["Heal"])
    healTab:SetScript("OnClick", function()
        currentTab = "heal"
        UpdateHeader(header)
        UpdateContent(content)
        UpdateTabSelection()
    end)

     -- Header-Zeile
      header = CreateFrame("Frame", nil, panel)
      header:SetSize(500, 20)
      header:SetPoint("TOPLEFT", panel, "TOPLEFT", 0, -75)
     -- Spaltenüberschriften
      InitHeader(header)

    -- ScrollFrame
      local scrollFrame = CreateFrame("ScrollFrame", "TestScrollFrame", panel, "UIPanelScrollFrameTemplate")
      scrollFrame:SetPoint("TOPLEFT", header, "TOPLEFT", 0, -15)
      scrollFrame:SetPoint("BOTTOMRIGHT", -40, 20)  -- Platz für Scrollbar

      -- Inhalt (ScrollChild)
      content = CreateFrame("Frame", nil, scrollFrame)
      content:SetSize(1, 1)  -- Muss gesetzt sein, damit Inhalte angezeigt werden
      scrollFrame:SetScrollChild(content)

      -- Einträge erstellen
      UpdateContent(content)
      UpdateTabSelection()
    -- Clear Button
    local clearButton = CreateFrame("Button", nil, panel, "UIPanelButtonTemplate")
        clearButton:SetSize(120, 22)
        clearButton:SetPoint("BOTTOMRIGHT", panel, "BOTTOMRIGHT", -20, 20)
        clearButton:SetText("Log löschen")
        clearButton:SetScript("OnClick", function()
           local playerName = UnitName("player") .. "-" .. GetRealmName()
            ShadowlessCritHighscore[playerName] = ShadowlessCritHighscore[playerName] or {
                damageLog = {},
                healLog = {},
            }

            if currentTab == "damage" then
                ShadowlessCritHighscore[playerName].damageLog = {}
            else
                ShadowlessCritHighscore[playerName].healLog = {}
            end

            --UpdateScrollContent(panel, panel.content, panel.scrollFrame)
        end)
      --return panel  -- <-- Jetzt ganz am Schluss!
      end  -- <-- Abschluss der Funktion ShadowlessCrit_SetupCritLogPanel