-- ShadowlessCritTrackerUI.lua

function ShadowlessCrit_InitCritUI(panel, anchorFrame,channelOptions,critLogPanel)
  -- Lokale Referenzen auf Einstellungen und Lokalisierung
  local channelOptions = channelOptions or {}  
  local critLogPanel = critLogPanel or {}
-- Trennlinie
  local separator = panel:CreateTexture(nil, "ARTWORK")
  separator:SetTexture(1, 1, 1, 0.5)
  separator:SetSize(200, 1)
  separator:SetPoint("TOPLEFT", anchorFrame, "BOTTOMLEFT", 0, -5)

      -- ChatLog-Titel
  local CritSaveTitle = panel:CreateFontString(nil, "ARTWORK", "GameFontNormal")
  CritSaveTitle:SetPoint("LEFT", separator, "RIGHT", 5, 0)
  CritSaveTitle:SetText("Save Crit Settings")

    local separator2 = panel:CreateTexture(nil, "ARTWORK")
  separator2:SetTexture(1, 1, 1, 0.5)
  separator2:SetSize(200, 1)
  separator2:SetPoint("LEFT", CritSaveTitle, "RIGHT", 5, 0)

  -- Crit-Save Haupt Toggle
  local saveCritToggle = CreateFrame("CheckButton", nil, panel, "InterfaceOptionsCheckButtonTemplate")
  saveCritToggle:SetPoint("TOPLEFT", separator, "BOTTOMLEFT", 0, -7)
  saveCritToggle.Text:SetText(L["SaveCritToggle"])
  saveCritToggle:SetChecked(ShadowlessCritSettings.saveCrits)
  saveCritToggle:SetScript("OnClick", function(self)
    local enabled = self:GetChecked()
    ShadowlessCritSettings.saveCrits = enabled
    updateCritSectionEnabled(enabled)
  end)

  -- Crit History öffnen Button
  local viewerButton = CreateFrame("Button", nil, panel, "UIPanelButtonTemplate")
  viewerButton:SetSize(160, 22)
  viewerButton:SetPoint("LEFT", saveCritToggle.Text, "RIGHT", 20, 0)
  viewerButton:SetText(L["OpenCritHistory"] or "Crit-Historie öffnen")
  viewerButton:SetScript("OnClick", function()
  InterfaceOptionsFrame_OpenToCategory(critLogPanel)
  end)

   -- Zwei Checkboxen nebeneinander: Schadens- und Heil-Crit speichern
  local saveDamageCheckbox = CreateFrame("CheckButton", nil, panel, "InterfaceOptionsCheckButtonTemplate")
  saveDamageCheckbox:SetPoint("TOPLEFT", saveCritToggle, "BOTTOMLEFT", 0, -7)
  saveDamageCheckbox.Text:SetText(L["SaveHighestCrit"])
  saveDamageCheckbox:SetChecked(ShadowlessCritSettings.saveHighestCrit)
  saveDamageCheckbox:SetScript("OnClick", function(self)
    ShadowlessCritSettings.saveHighestCrit = self:GetChecked()
  end)

  local saveHealCheckbox = CreateFrame("CheckButton", nil, panel, "InterfaceOptionsCheckButtonTemplate")
  saveHealCheckbox:SetPoint("LEFT", saveDamageCheckbox.Text, "RIGHT", 20, 0)
  saveHealCheckbox.Text:SetText(L["SaveHealCrits"])
  saveHealCheckbox:SetChecked(ShadowlessCritSettings.saveHighestHealCrit)
  saveHealCheckbox:SetScript("OnClick", function(self)
    ShadowlessCritSettings.saveHighestHealCrit = self:GetChecked()
  end)

    -- Prefix
    local prefixLabel = panel:CreateFontString(nil, "ARTWORK", "GameFontNormal")
  prefixLabel:SetPoint("TOPLEFT", saveDamageCheckbox, "BOTTOMLEFT", 0, -7)
  prefixLabel:SetText(L["PostPrefix"])

  local prefixBox = CreateFrame("EditBox", nil, panel, "InputBoxTemplate")
  prefixBox:SetSize(120, 20)
  prefixBox:SetPoint("LEFT", prefixLabel, "RIGHT", 10, 0)
  prefixBox:SetAutoFocus(false)
  prefixBox:SetText(ShadowlessCritSettings.postPrefix or "")
  prefixBox:SetCursorPosition(0)
  prefixBox:SetScript("OnEditFocusLost", function(self)
    ShadowlessCritSettings.postPrefix = self:GetText()
  end)


    local suffixLabel = panel:CreateFontString(nil, "ARTWORK", "GameFontNormal")
  suffixLabel:SetPoint("LEFT", prefixBox, "RIGHT", 30, 0)
  suffixLabel:SetText(L["PostSuffix"])

    -- Suffix
  local suffixBox = CreateFrame("EditBox", nil, panel, "InputBoxTemplate")
  suffixBox:SetSize(120, 20)
  suffixBox:SetPoint("LEFT", suffixLabel, "RIGHT", 10, 0)
  suffixBox:SetAutoFocus(false)
  suffixBox:SetText(ShadowlessCritSettings.postSuffix or "")
  suffixBox:SetCursorPosition(0)
  suffixBox:SetScript("OnEditFocusLost", function(self)
    ShadowlessCritSettings.postSuffix = self:GetText()
  end)
    -- Channel Title
  local channelTitle = panel:CreateFontString(nil, "ARTWORK", "GameFontNormal")
  channelTitle:SetPoint("TOPLEFT", prefixLabel, "BOTTOMLEFT", 0, -7)
  channelTitle:SetText(L["PostToChannels"])

  local channelCheckboxes = {}
  for i, opt in ipairs(channelOptions) do
    local col = (i - 1) % 3
    local row = math.floor((i - 1) / 3)
    local cb = CreateFrame("CheckButton", nil, panel, "InterfaceOptionsCheckButtonTemplate")
    cb:SetPoint("TOPLEFT", channelTitle, "BOTTOMLEFT", col * 150, -row * 25 - 7)
    cb.Text:SetText(opt.label)
    cb:SetChecked(ShadowlessCritSettings.postChannels and ShadowlessCritSettings.postChannels[opt.key])
    cb:SetScript("OnClick", function(self)
      ShadowlessCritSettings.postChannels = ShadowlessCritSettings.postChannels or {}
      ShadowlessCritSettings.postChannels[opt.key] = self:GetChecked()
    end)
    channelCheckboxes[#channelCheckboxes + 1] = cb
  end
    -- Enable/Disable-Funktion
  function updateCritSectionEnabled(enabled)
    saveDamageCheckbox:SetEnabled(enabled)
    saveHealCheckbox:SetEnabled(enabled)
    prefixBox:SetEnabled(enabled)
    suffixBox:SetEnabled(enabled)
    for _, cb in ipairs(channelCheckboxes) do
      cb:SetEnabled(enabled)
    end
    prefixLabel:SetTextColor(enabled and 1 or 0.5, enabled and 1 or 0.5, enabled and 1 or 0.5)
    suffixLabel:SetTextColor(enabled and 1 or 0.5, enabled and 1 or 0.5, enabled and 1 or 0.5)
    channelTitle:SetTextColor(enabled and 1 or 0.5, enabled and 1 or 0.5, enabled and 1 or 0.5)
  end

  updateCritSectionEnabled(ShadowlessCritSettings.saveCrits)
end
