-- ShadowlessCritSoundAddon.lua

-- Farbdefinitionen
local DebugColors = {
  white    = "|cFFFFFFFF",
  epicPurple = "|cFFA335EE",  -- Episch (WoW-Item Lila)
  epicOrange = "|cFFFF8000",  -- Legendary Orange (WoW-Item)
  red      = "|cFFFF3D3D",    -- Auffälliges Rot
  green    = "|cFF00FF00",    -- Giftgrün
  blue     = "|cFF00B4FF",    -- Klarblau
  yellow   = "|cFFFFFF00",    -- Helles Gelb
  cyan     = "|cFF00FFFF",    -- Türkisblau
  gray     = "|cFFAAAAAA",    -- Hellgrau
}

-- Farbnamen & Hexfarben (bereits oben definiert)
local colorOptions = {
  { key = "white",       hex = "FFFFFFFF" },
  { key = "epicPurple",  hex = "A335EE" },
  { key = "epicOrange",  hex = "FF8000" },
  { key = "red",         hex = "FF3D3D" },
  { key = "green",       hex = "00FF00" },
  { key = "blue",        hex = "00B4FF" },
  { key = "yellow",      hex = "FFFF00" },
  { key = "cyan",        hex = "00FFFF" },
  { key = "gray",        hex = "AAAAAA" },
  }

-- Funktion zum Farb-Formatieren von Debug-Text
local function GetDebugColorizedText(text)
  local prefix = "[BAM Debug]"
  local color = DebugColors[ShadowlessCritSettings.debugColor] or DebugColors.white
  return color .. prefix .. text .. "|r"
end

-- Funktion zum Farb-Formatieren von Debug-Text
local function GetColorizedText(text)
  local color = DebugColors[ShadowlessCritSettings.debugColor] or DebugColors.white
  return color .. text .. "|r"
end

function IsSettingAllowed(groupOrKey, maybeKey)
  local group, key
  if maybeKey == nil then
    group, key = nil, groupOrKey
  else
    group, key = groupOrKey, maybeKey
  end

  local val, active, result = false, false, false

  if group == "channel" then
    val = ShadowlessCritSettings.postChannels and ShadowlessCritSettings.postChannels[key]
    active = ShadowlessCritSettings.QuickToggle.postChannels and ShadowlessCritSettings.QuickToggle.postChannels[key]
  elseif group == "context" then
    val = ShadowlessCritSettings.context and ShadowlessCritSettings.context[key]
    active = ShadowlessCritSettings.QuickToggle.context and ShadowlessCritSettings.QuickToggle.context[key]
  else
    val = ShadowlessCritSettings[key]
    active = ShadowlessCritSettings.QuickToggle and ShadowlessCritSettings.QuickToggle[key]
  end

  -- Wenn QuickToggle aktiv ist, gilt: nur wenn val == true UND isOn == true
  if active then
    result = val and isOn
  else
    result = val -- QuickToggle nicht aktiv → normaler Zustand gilt
  end

 -- print(string.format("[IsSettingAllowed] %s.%s => val=%s, quickActive=%s, isOn=%s -> result=%s",
   -- tostring(group), tostring(key), tostring(val), tostring(active), tostring(isOn), tostring(result)

  return result
end


-- Lokaler Frame zum Event-Handling
local f = CreateFrame("Frame")
f:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")

-- Poste den Crit im Chat
local function PostCritMessage(msg)
  local ch = ShadowlessCritSettings.postChannels or {}
  local prefix = ShadowlessCritSettings.postPrefix or ""
  local suffix = ShadowlessCritSettings.postSuffix or ""
  msg = (prefix ~= "" and (prefix .. " ") or "") .. msg .. (suffix ~= "" and (" " .. suffix) or "")
  if IsSettingAllowed("channel","say")   then SendChatMessage(msg, "SAY") end
  if IsSettingAllowed("channel","guild") then SendChatMessage(msg, "GUILD") end
  if IsSettingAllowed("channel","raid")  then SendChatMessage(msg, "RAID") end
  if IsSettingAllowed("channel","party") then SendChatMessage(msg, "PARTY") end
  if IsSettingAllowed("channel","emote") then SendChatMessage(msg, "EMOTE") end
  -- onlyLocal = nur local anzeigen: dann print(msg)
  if IsSettingAllowed("channel","onlyLocal") then
  print(GetColorizedText(msg)) end
  --print(msg) end
end


-- Dein Soundfile (alternativ: ein Blizzard-Sound verwenden)
local soundFile = "Interface\\AddOns\\ShadowlessBamCrit\\sounds\\bam.ogg"
local PLAYER_GUID = UnitGUID("player")

  local function SimulateCrit(amount, spellName, destName, isHeal)
    if IsSettingAllowed("enabled") then
      PlaySoundFile(soundFile, ShadowlessCritSettings.soundChannel or "Master")
    end

    local fakeAmount = amount or 9999
    local fakeSpell = spellName or L["SimulatedBam"] or "Simuliertes Bam!"
    local fakeTarget = destName or UnitName("target") or "Ziel"

    -- Message zusammenbauen & posten
    local critMsg = string.format(L["CritMessage"], fakeSpell, fakeTarget, fakeAmount)
    PostCritMessage(critMsg)

    if ShadowlessCritSettings.debug then
      print(GetDebugColorizedText(L["SimulatedCrit"] or "Simulated Crit"))
    end
end-- gehört dem Event: SimulateCrit



-- Initialisiert das Einstellungs-UI im Interface-Optionsmenü
local function InitUI()
  local panel = CreateFrame("Frame", "ShadowlessCritSoundOptionsPanel", UIParent)
  ShadowlessCritSoundOptionsPanel = panel -- global!

  -- Hauptpanel erstellen
  panel.name = "Shadowless Bam! Crit Sound Addon"
  InterfaceOptions_AddCategory(panel)
  -- SubPanel CritLog erstellen
  critLogPanel = CreateFrame("Frame", "ShadowlessCrit_LogPanel", UIParent)
  critLogPanel.name = L["CritHistory"] or "Crit-Historie"  -- Name im Menü!
  critLogPanel.parent = panel.name -- Muss identisch zum Hauptpanel.name sein
  InterfaceOptions_AddCategory(critLogPanel)

  -- SubPanel QuickSettingsPanel erstellen
  quickSettingsPanel = CreateFrame("Frame", "ShadowlessCrit_QuickSettings", UIParent)
  quickSettingsPanel.name = L["QuickSettings"] or "Quick Settings"
  quickSettingsPanel.parent = panel.name 
  InterfaceOptions_AddCategory(quickSettingsPanel)

  -- Titel des Panels
    local title = panel:CreateFontString(nil, "ARTWORK", "GameFontNormalLarge")
    title:SetPoint("TOPLEFT", 16, -16)
    title:SetText(L["Panel Title"])

  -- Aktivieren-Checkbox
    local enableCheckbox = CreateFrame("CheckButton", nil, panel, "InterfaceOptionsCheckButtonTemplate")
    enableCheckbox:SetPoint("TOPLEFT", title, "BOTTOMLEFT", 0, -10)
    enableCheckbox.Text:SetText(L["Enable Sound"])
    enableCheckbox:SetChecked(ShadowlessCritSettings.enabled)
    enableCheckbox:SetScript("OnClick", function(self)
      ShadowlessCritSettings.enabled = self:GetChecked()
    end)

  -- Test-Sound Button
    local testButton = CreateFrame("Button", nil, panel, "UIPanelButtonTemplate")
    testButton:SetSize(120, 25)
    testButton:SetPoint("LEFT", enableCheckbox.Text, "RIGHT", 20, 0)
    testButton:SetText(L["Test Sound"])
    testButton:SetScript("OnClick", function()
      SimulateCrit(571, spellName, destName, false)
    end)

  -- Soundkanal Dropdown
    local channels = { "Master", "SFX", "Music", "Ambience" }
    local channelDropdown = CreateFrame("Frame", "ShadowlessCritChannelDropdown", panel, "UIDropDownMenuTemplate")
    channelDropdown:SetPoint("LEFT", testButton, "RIGHT", 20, 0)
    UIDropDownMenu_SetWidth(channelDropdown, 120)
    UIDropDownMenu_SetText(channelDropdown, ShadowlessCritSettings.soundChannel or "Master")
    UIDropDownMenu_Initialize(channelDropdown, function(self, level)
      for _, channel in ipairs(channels) do
        local info = UIDropDownMenu_CreateInfo()
        info.text = channel
        info.checked = (ShadowlessCritSettings.soundChannel == channel)
        info.func = function()
          ShadowlessCritSettings.soundChannel = channel
          UIDropDownMenu_SetText(channelDropdown, channel)
        end
        UIDropDownMenu_AddButton(info)
      end
    end)

  -- Mindestschaden aktivieren
    local minDamageCheckbox = CreateFrame("CheckButton", nil, panel, "InterfaceOptionsCheckButtonTemplate")
    minDamageCheckbox:SetPoint("TOPLEFT", enableCheckbox, "BOTTOMLEFT", 0, -7)
    minDamageCheckbox.Text:SetText(L["Min Damage Only"])
    minDamageCheckbox:SetChecked(ShadowlessCritSettings.minDamageEnabled)
    minDamageCheckbox:SetScript("OnClick", function(self)
      ShadowlessCritSettings.minDamageEnabled = self:GetChecked()
    end)

  -- Eingabefeld für Mindestschaden
    local minDamageEditBox = CreateFrame("EditBox", nil, panel, "InputBoxTemplate")
    minDamageEditBox:SetSize(120, 20)
    minDamageEditBox:SetPoint("LEFT", minDamageCheckbox.Text, "RIGHT", 10, 0)
    minDamageEditBox:SetAutoFocus(false)
    minDamageEditBox:SetNumeric(true)
    minDamageEditBox:SetText(tostring(ShadowlessCritSettings.minDamageThreshold))
    minDamageEditBox:SetCursorPosition(0)
    minDamageEditBox:SetScript("OnEditFocusLost", function(self)
      local value = tonumber(self:GetText())
      if value then
        ShadowlessCritSettings.minDamageThreshold = value
        if ShadowlessCritSettings.debug then
          print(L["DebugThresholdSaved"], value)
        end
      end
      self:ClearFocus()
    end)

  -- Heil-Crit Checkbox
    local healCheckbox = CreateFrame("CheckButton", nil, panel, "InterfaceOptionsCheckButtonTemplate")
    healCheckbox:SetPoint("TOPLEFT", minDamageCheckbox, "BOTTOMLEFT", 0, -7)
    healCheckbox.Text:SetText(L["Heal Crits"])
    healCheckbox:SetChecked(ShadowlessCritSettings.playOnHeals)
    healCheckbox:SetScript("OnClick", function(self)
      ShadowlessCritSettings.playOnHeals = self:GetChecked()
    end)

  -- Kontext-Titel und Hinweis
    local contextTitle = panel:CreateFontString(nil, "ARTWORK", "GameFontNormal")
    contextTitle:SetPoint("TOPLEFT", healCheckbox, "BOTTOMLEFT", 0, -7)
    contextTitle:SetText(L["Context Filter"])

    local contextHint = panel:CreateFontString(nil, "ARTWORK", "GameFontHighlightSmall")
    contextHint:SetPoint("TOPLEFT", contextTitle, "BOTTOMLEFT", 0, -2)
    contextHint:SetText("Crit-Sound nur in folgenden Szenarien aktiv:")

  -- Kontext-Checkboxen in zwei Spalten
    local contextCheckboxes = {}
    local column1, column2 = {}, {}
    for i, ctx in ipairs(contexts) do
      local cb = CreateFrame("CheckButton", nil, panel, "InterfaceOptionsCheckButtonTemplate")
      local col = (i % 2 == 1) and column1 or column2
      table.insert(col, cb)
      cb.Text:SetText(L[ctx.label] or ctx.label)
      cb:SetChecked(ShadowlessCritSettings.context[ctx.key])
      cb:SetScript("OnClick", function(self)
        ShadowlessCritSettings.context[ctx.key] = self:GetChecked()
      end)
      table.insert(contextCheckboxes, cb)
    end

  -- Kontext Checkboxen positionieren
    for i, cb in ipairs(column1) do
      cb:SetPoint("TOPLEFT", contextHint, "BOTTOMLEFT", 0, -5 - ((i - 1) * 25))
    end
    for i, cb in ipairs(column2) do
      cb:SetPoint("LEFT", column1[i], "RIGHT", 200, 0)
    end

  -- Alle / Keine Buttons
  local lastContextCB = (#column1 > #column2) and column1[#column1] or column2[#column2]

    local allBtn = CreateFrame("Button", nil, panel, "UIPanelButtonTemplate")
    allBtn:SetSize(80, 20)
    allBtn:SetPoint("TOPLEFT", lastContextCB, "BOTTOMLEFT", 0, -7)
    allBtn:SetText(L["All"])
    allBtn:SetScript("OnClick", function()
      for k in pairs(ShadowlessCritSettings.context) do
        ShadowlessCritSettings.context[k] = true
      end
      for _, cb in ipairs(contextCheckboxes) do
        cb:SetChecked(true)
      end
    end)

    local noneBtn = CreateFrame("Button", nil, panel, "UIPanelButtonTemplate")
    noneBtn:SetSize(120, 20)
    noneBtn:SetPoint("LEFT", allBtn, "RIGHT", 10, 0)
    noneBtn:SetText(L["None"])
    noneBtn:SetScript("OnClick", function()
      for k in pairs(ShadowlessCritSettings.context) do
        ShadowlessCritSettings.context[k] = false
      end
      for _, cb in ipairs(contextCheckboxes) do
        cb:SetChecked(false)
      end
    end)

  -- ChatLog-Titel
    local chatLogTitle = panel:CreateFontString(nil, "ARTWORK", "GameFontNormal")
    chatLogTitle:SetPoint("TOPLEFT", allBtn, "BOTTOMLEFT", 0, -10)
    chatLogTitle:SetText("ChatLog")

  -- Debug-Modus Checkbox
    local debugCheckbox = CreateFrame("CheckButton", nil, panel, "InterfaceOptionsCheckButtonTemplate")
    debugCheckbox:SetPoint("TOPLEFT", chatLogTitle, "BOTTOMLEFT", 0, -5)
    debugCheckbox.Text:SetText("Debug-Modus aktivieren")
    debugCheckbox:SetChecked(ShadowlessCritSettings.debug)
    debugCheckbox:SetScript("OnClick", function(self)
      ShadowlessCritSettings.debug = self:GetChecked()
      print(GetDebugColorizedText(ShadowlessCritSettings.debug and L["DebugModeOn"] or L["DebugModeOff"]))
    end)

  -- Farbauswahl-Dropdown
    local colorDropdown = CreateFrame("Frame", "ShadowlessCritColorDropdown", panel, "UIDropDownMenuTemplate")
    colorDropdown:SetPoint("LEFT", debugCheckbox.Text, "RIGHT", 20, 0)
    UIDropDownMenu_SetWidth(colorDropdown, 120)
    UIDropDownMenu_SetText(colorDropdown, L["DebugTextColor"] or "Debug-Color")
    UIDropDownMenu_Initialize(colorDropdown, function(self, level)
      for _, option in ipairs(colorOptions) do
        local info = UIDropDownMenu_CreateInfo()
        info.text = "|cFF" .. option.hex .. option.key .. "|r"
        info.value = option.key
        info.checked = (ShadowlessCritSettings.debugColor == option.key)
        info.func = function()
          ShadowlessCritSettings.debugColor = option.key
          UIDropDownMenu_SetSelectedValue(colorDropdown, option.key)
        end
        UIDropDownMenu_AddButton(info, level)
      end
    end)
    UIDropDownMenu_SetSelectedValue(colorDropdown, ShadowlessCritSettings.debugColor)

  -- Reset-Button
    local resetButton = CreateFrame("Button", nil, panel, "UIPanelButtonTemplate")
    resetButton:SetSize(120, 25)
    resetButton:SetPoint("TOPLEFT", debugCheckbox, "BOTTOMLEFT", 0, -7)
    resetButton:SetText(L["Reset"])
    resetButton:SetScript("OnClick", function()
      ShadowlessCritSettings = {
      enabled = true,
      minDamageEnabled = false,
      minDamageThreshold = 1000,
      playOnHeals = false,
      debug = false,
      soundChannel = "Master",
      debugColor = "white",
      context = {
        pvp = true,
        arena = true,
        raid = true,
        dungeon = true,
        openworld = true
      }
    }
    print("Einstellungen wurden zurückgesetzt.")
    end)
  _G.resetButton = resetButton -- global verfügbar machen
   
end --gehört zu InitUI



-- Frame um auf VARIABLES_LOADED zu warten
local varFrame = CreateFrame("Frame")
  varFrame:RegisterEvent("VARIABLES_LOADED")
  varFrame:SetScript("OnEvent", function()
      InitCritSettings()
      InitUI()


      ShadowlessCrit_SetupCritLogPanel(critLogPanel)
      --ShadowlessCrit_InitTestUI(ShadowlessCritSoundOptionsPanel, resetButton)
      ShadowlessCrit_InitCritUI(ShadowlessCritSoundOptionsPanel, resetButton, channelOptions,critLogPanel)

      ShadowlessCrit_InitMinimapIcon() -- <--- Minimap-Icon initialisierung
      ShadowlessCrit_QuickSettingsPanel(quickSettingsPanel)
  end)



  -- Kritischen Schaden (Schaden oder Heilung) nur speichern, wenn der Wert höher als der vorherige Highscore ist:

local function SaveCritIfHighest(isHeal, amount, destName,skill)
    -- Wähle den passenden Log
      local playerName = UnitName("player") .. "-" .. GetRealmName()

      ShadowlessCritHighscore = ShadowlessCritHighscore or {}
      ShadowlessCritHighscore[playerName] = ShadowlessCritHighscore[playerName] or {
          damageLog = {},
          healLog = {},
      }

      local log = isHeal and ShadowlessCritHighscore[playerName].healLog or ShadowlessCritHighscore[playerName].damageLog

    -- Finde das bisher höchste Crit-Amount
    local highscore = 0
    if #log > 0 and log[1] and tonumber(log[1].amount) then
        highscore = tonumber(log[1].amount)
    end
    -- Nur speichern, wenn höher!
    if amount > highscore then
        local entry = {
            time = date("%H:%M:%S"),
            amount = amount,
            skill = skill or "?",
            target = destName or "?",
            location = GetRealZoneText(),
            
        }
        table.insert(log, 1, entry)
        -- Optional: Log auf 200 begrenzen, aber meist reicht [1]
        if #log > 200 then table.remove(log) end
        -- [Optional: Wenn du willst, dass *nur* 1 Eintrag bleibt:]
        -- while #log > 1 do table.remove(log) end
    end
end



-- Event: Crit-Erkennung
f:SetScript("OnEvent", function(self, event, ...)

  local subevent = select(2, ...)
  local sourceGUID = select(4, ...)
  local amount, critical

  if sourceGUID ~= UnitGUID("player") then return end
    -- Instanztyp prüfen
    local _, instanceType = IsInInstance()
    local ctx = ShadowlessCritSettings.context
    if (instanceType == "pvp" and not ctx.pvp) or
       (instanceType == "arena" and not ctx.arena) or
       (instanceType == "raid" and not ctx.raid) or
       (instanceType == "party" and not ctx.dungeon) or
       (instanceType == "none" and not ctx.openworld) then
      return
    end

    -- Heilung
    if subevent == "SPELL_HEAL" or subevent == "SPELL_PERIODIC_HEAL" then
      amount = select(15, ...)
      critical = select(18, ...)

      if not amount then
      return
      end
      if not ShadowlessCritSettings.playOnHeals then      
      return 
      end

    -- Schaden
    elseif subevent == "SWING_DAMAGE" then
      amount = select(12, ...)
      critical = select(18, ...)
    elseif subevent == "SPELL_DAMAGE" or subevent == "RANGE_DAMAGE" or subevent == "SPELL_PERIODIC_DAMAGE" then
      amount = select(15, ...)
      critical = select(21, ...)
    else
      return
    end

    -- Mindestschadensgrenze
    if ShadowlessCritSettings.minDamageEnabled and amount < ShadowlessCritSettings.minDamageThreshold then
      return
    end

      -- Debug log für Critdd
    if ShadowlessCritSettings.debug then
      if critical then
       local message = string.format(L["DebugCritDetected"], amount or 0, subevent, instanceType)
        print(GetDebugColorizedText(message))
        end
    end

    -- Wenn Kritische Treffer gelandet
   if (critical == true or critical == 1) then
      -- Sound abspielen
        if IsSettingAllowed("enabled") then
          PlaySoundFile(soundFile, ShadowlessCritSettings.soundChannel or "Master")
        end

      local destName = select(9, ...)
      local spellName = select(13, ...) -- je nach Event evtl. anders!


          if (subevent == "SPELL_HEAL" or subevent == "SPELL_PERIODIC_HEAL") then
              if ShadowlessCritSettings.saveHighestHealCrit then
                  SaveCritIfHighest(true, amount or 0, destName or "?", spellName or "")

              end
          else
              if ShadowlessCritSettings.saveHighestCrit then
                  SaveCritIfHighest(false, amount or 0, destName or "?",spellName or "")
              end
          end

      local critMsg = string.format(L["CritMessage"], spellName or L["Crit"], destName or "?", amount or 0)
      PostCritMessage(critMsg)
        end -- end von (critical == true or critical == 1)

  end) -- gehört dem Event: Crit-Erkennung
