-- ShadowlessCritSettings.lua


-- macht den wert zu einem echten bool true / false
local function ensureBool(value, default)
  if value == nil then return default end
    -- Akzeptiere true, 1, "1" als wahr
  if (value == true or value == 1 or value == "1")then return true end
  return false
end


-- Kontext-Toggle-Checkboxen
  contexts = {
    { key = "pvp", label = "PvP" },
    { key = "arena", label = "Arena" },
    { key = "raid", label = "Raid" },
    { key = "dungeon", label = "Dungeon" },
    { key = "openworld", label = "Open World" },
    }
  channelOptions = {
    { key = "say", label = L["ChannelSay"] },
    { key = "guild", label = L["ChannelGuild"] },
    { key = "party", label = L["ChannelParty"] },
    { key = "raid", label = L["ChannelRaid"] },
    { key = "emote", label = L["ChannelEmote"] },
    { key = "onlyLocal", label = L["OnlyLocal"] },}

-- Optional extern nutzbar machen
ShadowlessCrit = ShadowlessCrit or {}

function InitCritSettings()
  ShadowlessCritSettings = ShadowlessCritSettings or {}

  -- Bools
  ShadowlessCritSettings.enabled              = ensureBool(ShadowlessCritSettings.enabled, true)
  ShadowlessCritSettings.minDamageEnabled     = ensureBool(ShadowlessCritSettings.minDamageEnabled, false)
  ShadowlessCritSettings.playOnHeals          = ensureBool(ShadowlessCritSettings.playOnHeals, false)
  ShadowlessCritSettings.debug                = ensureBool(ShadowlessCritSettings.debug, false)
  ShadowlessCritSettings.saveCrits            = ensureBool(ShadowlessCritSettings.saveCrits, true)
  ShadowlessCritSettings.saveHighestCrit      = ensureBool(ShadowlessCritSettings.saveHighestCrit, true)
  ShadowlessCritSettings.saveHighestHealCrit  = ensureBool(ShadowlessCritSettings.saveHighestHealCrit, true)

  -- Werte
  ShadowlessCritSettings.minDamageThreshold = tonumber(ShadowlessCritSettings.minDamageThreshold) or 1
  ShadowlessCritSettings.soundChannel       = ShadowlessCritSettings.soundChannel or "Master"
  ShadowlessCritSettings.debugColor         = ShadowlessCritSettings.debugColor or "white"
  ShadowlessCritSettings.postPrefix         = ShadowlessCritSettings.postPrefix or ""
  ShadowlessCritSettings.postSuffix         = ShadowlessCritSettings.postSuffix or ""

  -- Channels
  ShadowlessCritSettings.postChannels = ShadowlessCritSettings.postChannels or {}
  for _, ch in ipairs(channelOptions or {}) do
    ShadowlessCritSettings.postChannels[ch.key] = ensureBool(ShadowlessCritSettings.postChannels[ch.key], false)
  end

  -- Contexts
  ShadowlessCritSettings.context = ShadowlessCritSettings.context or {}
  for _, ctx in ipairs(contexts or {}) do
    ShadowlessCritSettings.context[ctx.key] = ensureBool(ShadowlessCritSettings.context[ctx.key], true)
  end

  -- QuickToggle
  ShadowlessCritSettings.QuickToggle = ShadowlessCritSettings.QuickToggle or {}
  local defaultQuick = {
    enabled = true,
    playOnHeals = false,
    saveCrits = false,
    saveHighestCrit = false,
    saveHighestHealCrit = false,
    minDamageEnabled = false,
    postChannels = {},
    context = {},
  }

  for _, ch in ipairs(channelOptions or {}) do
    defaultQuick.postChannels[ch.key] = false
  end
  for _, ctx in ipairs(contexts or {}) do
    defaultQuick.context[ctx.key] = false
  end

  for k, v in pairs(defaultQuick) do
    if type(v) == "table" then
      ShadowlessCritSettings.QuickToggle[k] = ShadowlessCritSettings.QuickToggle[k] or {}
      for subKey, subVal in pairs(v) do
        if ShadowlessCritSettings.QuickToggle[k][subKey] == nil then
          ShadowlessCritSettings.QuickToggle[k][subKey] = subVal
        end
      end
    else
      if ShadowlessCritSettings.QuickToggle[k] == nil then
        ShadowlessCritSettings.QuickToggle[k] = v
      end
    end
  end
end
