-- ShadowlessCritMinimap.lua

local LDB = LibStub("LibDataBroker-1.1")
local LDBIcon = LibStub("LibDBIcon-1.0")
local L = L or {}
function ShadowlessCrit_InitMinimapIcon()
    -- SavedVariables fr Minimap-Position/Sichtbarkeit:
    ShadowlessCritSettings.minimap = ShadowlessCritSettings.minimap or {}

    local critLauncher = LDB:NewDataObject("ShadowlessBamCrit", {
        type = "launcher",
        text = "ShadowlessBamCrit",
        icon = "Interface\\Icons\\Ability_CriticalStrike", -- <- DEIN ICON!
        OnClick = function(self, button)
          if button == "RightButton" then
            ShadowlessCrit_ToggleQuickSetting()
          else
              InterfaceOptionsFrame_OpenToCategory("Shadowless Bam! Crit Sound Addon")
              InterfaceOptionsFrame_OpenToCategory("Shadowless Bam! Crit Sound Addon")
          end
        end,
        OnTooltipShow = function(tooltip)
            tooltip:AddLine("Shadowless Bam! Crit")
            tooltip:AddLine(L["TooltipClick"] or "Left-click: Open settings")
            tooltip:AddLine(L["TooltipClickRightClick"] or "Right-click: Quick On/Off")
        end,
    })

    -- Button an der Minimap registrieren
    LDBIcon:Register("ShadowlessBamCrit", critLauncher, ShadowlessCritSettings.minimap)
end