-- ShadowlessCritMiniMapQuickSettingsUI.lua
isOn = isOn or true -- EINMAL am Anfang (besser in deiner Main-Datei)
-- View Aufbau
function ShadowlessCrit_QuickSettingsPanel(panel)

    -- Titel
      local title = panel:CreateFontString(nil, "ARTWORK", "GameFontNormalLarge")
      title:SetPoint("TOPLEFT", 16, -16)
      title:SetText(L["QuickSettingsTitle"] or "Quick Settings - Schnellumschalter")

      local desc = panel:CreateFontString(nil, "ARTWORK", "GameFontHighlightSmall")
      desc:SetPoint("TOPLEFT", title, "BOTTOMLEFT", 0, -8)
      desc:SetText(L["QuickSettingsDesc"] or "Welche Optionen sollen über das Minimap-Icon (Rechtsklick) schnell umgeschaltet werden können?")


     -- Checkboxen für die wichtigsten Optionen
      local quickToggles = {
        { key = "enabled",         label = L["Enable Sound"] },
        { key = "minDamageEnabled",label = L["Min Damage Only"] },
        { key = "playOnHeals",     label = L["Heal Crits"] },
        { key = "saveCrits",       label = L["SaveCritToggle"] },
        { key = "saveHighestCrit", label = L["SaveHighestCrit"] },
        { key = "saveHighestHealCrit", label = L["SaveHealCrits"] },
        -- Channels as QuickToggles (optional, für jeden einzelnen Channel)
        {group = "postChannels",  key = "say",     label = L["ChannelSay"] },
        {group = "postChannels",  key = "guild",   label = L["ChannelGuild"] },
        {group = "postChannels",  key = "party",   label = L["ChannelParty"] },
        {group = "postChannels",  key = "raid",    label = L["ChannelRaid"] },
        {group = "postChannels",  key = "emote",   label = L["ChannelEmote"] },
        {group = "postChannels",  key = "onlyLocal",label = L["OnlyLocal"] },
        -- Contexts (where crit sounds are active)
        {group = "context",  key = "pvp",     label = L["PvP"] },
        {group = "context",  key = "arena",   label = L["Arena"] },
        {group = "context",  key = "raid",    label = L["Raid"] },
        {group = "context",  key = "dungeon", label = L["Dungeon"] },
        {group = "context",  key = "openworld",label = L["Open World"] },
      }

      -- Anzahl Checkboxen pro Spalte (z.B. die Hälfte)
    local total = #quickToggles
    local colCount = math.ceil(total / 2)
    local panelWidth = panel:GetWidth()
    if panelWidth == 0 then panelWidth = 600 end -- Fallback falls beim ersten Aufruf noch keine Breite gesetzt ist
    local colSpacing = math.floor(panelWidth / 2)

    for i, toggle in ipairs(quickToggles) do
        local cb = CreateFrame("CheckButton", nil, panel, "InterfaceOptionsCheckButtonTemplate")
            cb.Text:SetFontObject("GameFontHighlightSmall")
        local col, row
        if i <= colCount then
            col, row = 0, i - 1 -- Linke Spalte
        else
            col, row = 1, i - colCount - 1 -- Rechte Spalte
        end
        cb:SetPoint("TOPLEFT", desc, "BOTTOMLEFT", col * colSpacing, -12 - (row * 30))
        cb.Text:SetText(toggle.label)
        cb:SetChecked(
          toggle.group and ShadowlessCritSettings.QuickToggle[toggle.group] and ShadowlessCritSettings.QuickToggle[toggle.group][toggle.key]
          or ShadowlessCritSettings.QuickToggle[toggle.key])
        cb:SetScript("OnClick", function(self)
          if toggle.group then
            ShadowlessCritSettings.QuickToggle[toggle.group][toggle.key] = self:GetChecked()
          else
            ShadowlessCritSettings.QuickToggle[toggle.key] = self:GetChecked()
          end
        end)
    end

      -- Tipp darunter:
      local tip = panel:CreateFontString(nil, "ARTWORK", "GameFontHighlightSmall")
      tip:SetPoint("BOTTOMLEFT", panel, "BOTTOMLEFT", 16, 16)
      tip:SetWidth(panelWidth) -- z. B. maximale Breite (nach Wunsch anpassen!)
      tip:SetJustifyH("LEFT")
      tip:SetJustifyV("TOP")
      tip:SetText(L["QuickSettingsTip"] or "Diese Einstellungen können im Spiel über das Minimap-Icon per Rechtsklick schnell (de-)aktiviert werden.")

    end  -- <-- Abschluss der Funktion ShadowlessCrit_SetupCritLogPanel

-- Sound bei Toggle
local function PlayToggleSound(state)
    local onSound = 568556 -- z.B. UI_PET_BATTLE_START
    local offSound = 568557 -- z.B. UI_PET_BATTLE_END
    PlaySound(state and onSound or offSound, "Master")
end

function ShadowlessCrit_ToggleQuickSetting()
    isOn = not isOn
    print("QuickToggle:", isOn and "ON" or "OFF")
    PlayToggleSound(isOn)
end


