# 💥 ShadowlessBamCrit – Turn Every Crit into a Moment

🎯 **Feel every critical hit. Hear the BAM.**  
**ShadowlessBamCrit** lets you *feel* your crits with an epic custom sound – fully configurable and lightweight.

---

## 💡 Why You'll Love It

- **🎵 Hear your power** – Custom sound on every crit (damage or healing)
- **📉 Control spam** – Set a minimum damage threshold to ignore weak hits
- **🩹 Supports healing specs** – Enable crit sounds on healing too
- **🌍 Context aware** – Enable/disable for PvP, Raids, Dungeons, or Open World
- **📊 Crit Log** – View your top damage and healing crits (separate tabs, sorted by value)
- **💬 Share the glory** – Auto-post your crits to chat (say, raid, party, emote, guild, or print)
- **🧭 Quick access** – Minimap button to toggle selected features in combat
- **🛠️ In-game config** – Full control without touching any Lua files

---

## 🧭 Installation

1. Download & unzip into your `Interface/AddOns` folder  
2. Folder must be named `ShadowlessBamCrit`  
3. Enable the addon in the in-game AddOns menu  
4. Configure via **Interface > AddOns > Shadowless Bam! Crit Sound Addon**  
   (Crit Log is in the submenu)  
5. Right-click the **minimap icon** to toggle selected features on/off during play  
6. Start BAMing!


---

## ⚙️ Features Overview

- 🎵 **Custom BAM Sound** on critical hits
- 🩹 **Healing Crits Support** for support and hybrid specs
- 📈 **Crit History Panel**: sorted, searchable, with tabs for heals & damage
- 💬 **Auto-Announce** your crits to chat channels
- 🎚️ **Minimum Damage Threshold** to reduce spam
- 🌀 **AoE Crit Detection** *(experimental)*
- 🧠 **Context Filters**: Enable per environment (PvP, Raid, Dungeon, etc.)
- 🧭 **Minimap Quick Settings**: Right-click toggles for selected features
- 🧰 **Full Config Panel**:
  - Enable/disable addon
  - Play test sound
  - Set crit threshold
  - Toggle per environment
  - Enable debug & colorized output
  - Choose chat channels
  - Select sound output channel (Master, SFX, etc.)
  - View/reset crit history

---

## 🗃️ Crit Log & Chat Announcements

- Crits and heals are saved in a scrollable, tabbed in-game log
- Chat announcements support SAY, RAID, PARTY, GUILD, EMOTE or just local print
- Customize your **prefix/suffix** (e.g. “BAM CRIT!: ... In Your FACE!”)

---

## 🌐 Languages Supported

- 🇬🇧 **English** (default)
- 🇩🇪 **German** (automatically detected)
- 🇫🇷 **French**
- 🇪🇸 **Spanish**

> Want to help translate? Get in touch!

---

### ⚡ Quick Settings – Minimap Toggle Explained

#### 📍 What Is It?

The **Quick Settings** feature gives you a fast way to **temporarily toggle certain functions on or off** – directly via the **minimap icon (right-click)**.  
No need to open the full config panel every time.

#### 🕹️ Example Use:

You’re in PvP and want to **mute crit sounds and stop auto-posting**?  
→ Right-click the minimap icon – it’s off.  
Done with PvP?  
→ Right-click again – all back on.

#### 🧩 How It Works

- In the config panel (*Interface → AddOns → Shadowless Bam! Crit → Quick Settings*), choose which features you want to control with the minimap toggle.
- These are stored in the **QuickToggle list**.
- When you right-click the minimap icon, the addon checks:
  - 🔍 Is the setting enabled in the **main config**?
  - ✅ Is it marked in **Quick Settings**?
  → If **both** are true, the feature is **temporarily disabled**.
- Another right-click re-enables all of them.

> ⚠️ Note: This does **not change your saved settings permanently** – it only overrides them **while QuickToggle is OFF**.

#### 🔎 Behavior Table

| Feature             | Main Setting | In Quick Settings | QuickToggle = OFF | Result          |
|---------------------|--------------|--------------------|-------------------|------------------|
| Play Crit Sound     | ✅            | ✅                  | ✅                 | ❌ Sound muted   |
| Auto-Post to "Say"  | ✅            | ❌                  | ✅                 | ✅ Still posts   |
| Auto-Post to "Emote"| ✅            | ✅                  | ✅                 | ❌ Won't post    |
| Healing Crits       | ❌            | ✅                  | ✅                 | 🚫 No effect     |

✔️ Only settings that are **both enabled and selected for quick toggling** will be affected.

#### 💡 Pro Tip

Use Quick Settings to suppress sounds or messages during:
- PvP/Arenas
- Mythic+ dungeons
- Raids
- Casual or quiet moments

→ **One click to mute, one click to restore.**


---

## 👤 About the Developer

Made with love by [Shadowless Studios](https://shadowless.studios.eu)  
📧 Contact: [shadowless.studios.eu@gmail.com](mailto:shadowless.studios.eu@gmail.com)  
☕ Like the addon? [Buy me a tea](https://paypal.me/ShadowlessGT)

---

## 💬 Support & Feedback

- Feature suggestions or bugs? Email or CurseForge!
- Help translate: reach out by email

---

## 💰 Donations

If you enjoy this addon and want to support future development:  
👉 [paypal.me/ShadowlessGT](https://paypal.me/ShadowlessGT)

---

## ⚖️ License

Personal use only. Redistribution or modification without permission is prohibited.
