--- Notification Provider
--
local Notification = {}
local AddOnName, nsVars = ...
local ss = nsVars.SS

local table, pairs = table, pairs
local CreateFrame, UIParent = CreateFrame, UIParent

local frame, frameConfirm

--- Creates the notification frame.
-- The created frame.
--
local function createFrame()
  -- Notification frame.
  local frm = CreateFrame("Frame", ss._f .. "Notification", UIParent)
  frm:SetWidth (400)
  frm:SetHeight(200)
  frm:SetPoint ("CENTER", 0, 0)
  
  -- Background.
  local frmBack = frm:CreateTexture(nil, "BACKGROUND")
  frmBack:SetColorTexture(1,1,1,1)
  frmBack:SetVertexColor(0.1, 0.1, 0.1, 1)
  frmBack:SetAllPoints()
  
  -- Backdrop.
  frm:SetBackdrop {
    edgeFile = "Interface\\DialogFrame\\UI-DialogBox-Border",
    tile     = true,
    tileSize = 16,
    edgeSize = 16,
    insets = {
      left   = 4,
      right  = 4,
      top    = 4,
      bottom = 4
    }
  }
  frm:SetBackdropColor(0.1, 0.1, 0.1, 1)
  
  -- Title background.
  frm.titleBackground = frm:CreateTexture(nil, "BACKGROUND")
  frm.titleBackground:SetColorTexture(1, 1, 1, 1)
  frm.titleBackground:SetVertexColor (0.15, 0.15, 0.15, 1)
  frm.titleBackground:SetPoint       ("TOP", 0, -5)
  frm.titleBackground:SetWidth       (395)
  frm.titleBackground:SetHeight      (25)
  
  -- Title.
  frm.title = frm:CreateFontString(ss._f .. "NotificationTitle")
  frm.title:SetFont     (ss.SharedMedia.fontChoices.exo2["SemiBold"], 14)
  frm.title:SetTextColor(0.5, 0.5, 0.5, 1)
  frm.title:SetPoint    ("TOP", 0, -5)
  frm.title:SetSize     (400, 25)
  
  -- Content.
  frm.content = frm:CreateFontString(ss._f .. "NotificationContent")
  frm.content:SetFont     (ss.SharedMedia.fontChoices.exo2["Medium"], 14)
  frm.content:SetTextColor(0.5, 0.5, 0.5, 1)
  frm.content:SetPoint    ("BOTTOM", 0, 50)
  frm.content:SetSize     (350, 110)
  frm.content:SetJustifyV ("TOP")
  frm.content:SetJustifyH ("LEFT")
  
  -- Close button.
  frm.close = CreateFrame("Button", ss._f .. "NotificationClose", frm, "GameMenuButtonTemplate")
  frm.close:SetSize  (75, 25)
  frm.close:SetPoint ("BOTTOMRIGHT", -10, 10)
  frm.close:SetText  (ss.T["btn_close"])
  frm.close:SetScript("OnClick", function()
    frm:Hide()
  end)
  
  return frm
end

--- Creates the confirmation frame.
-- The created frame.
--
local function createFrameConfirm()
  -- Notification frame.
  local frm = CreateFrame("Frame", ss._f .. "NotificationConfirm", UIParent)
  frm:SetWidth      (400)
  frm:SetHeight     (200)
  frm:SetPoint      ("CENTER", 0, 0)
  frm:SetFrameStrata("TOOLTIP")

  -- Background.
  local frmBack = frm:CreateTexture(nil, "BACKGROUND")
  frmBack:SetColorTexture(1,1,1,1)
  frmBack:SetVertexColor(0.1, 0.1, 0.1, 1)
  frmBack:SetAllPoints()

  -- Backdrop.
  frm:SetBackdrop {
    edgeFile = "Interface\\DialogFrame\\UI-DialogBox-Border",
    tile     = true,
    tileSize = 16,
    edgeSize = 16,
    insets = {
      left   = 4,
      right  = 4,
      top    = 4,
      bottom = 4
    }
  }
  frm:SetBackdropColor(0.1, 0.1, 0.1, 1)
  
  -- Title background.
  frm.titleBackground = frm:CreateTexture(nil, "BACKGROUND")
  frm.titleBackground:SetColorTexture(1, 1, 1, 1)
  frm.titleBackground:SetVertexColor (0.15, 0.15, 0.15, 1)
  frm.titleBackground:SetPoint       ("TOP", 0, -5)
  frm.titleBackground:SetWidth       (395)
  frm.titleBackground:SetHeight      (25)
  
  -- Title.
  frm.title = frm:CreateFontString(ss._f .. "ConfirmTitle")
  frm.title:SetFont (ss.SharedMedia.fontChoices.exo2["SemiBold"], 14)
  frm.title:SetTextColor(0.5, 0.5, 0.5, 1)
  frm.title:SetPoint("TOP", 0, -5)
  frm.title:SetSize (400, 25)
  frm.title:SetText (ss.T["lbl_confirmation"])
  
  -- Content.
  frm.content = frm:CreateFontString(ss._f .. "ConfirmContent")
  frm.content:SetFont    (ss.SharedMedia.fontChoices.exo2["Medium"], 14)
  frm.content:SetTextColor(0.5, 0.5, 0.5, 1)
  frm.content:SetPoint   ("BOTTOM", 0, 50)
  frm.content:SetSize    (350, 110)
  frm.content:SetJustifyV("TOP")
  frm.content:SetJustifyH("LEFT")
  frm.content:SetText    (ss.T["lbl_are_you_sure"])
  
  -- Yes button.
  frm.yes = CreateFrame("Button", ss._f .. "ConfirmYes", frm, "GameMenuButtonTemplate")
  frm.yes:SetSize  (75, 25)
  frm.yes:SetPoint ("BOTTOMRIGHT", -100, 10)
  frm.yes:SetText  (ss.T["btn_yes"])
  frm.yes:SetScript("OnClick", function()
    if frm.onYes then
      frm.onYes()
    end
    
    frm:Hide()
  end)
  
  -- No button.
  frm.no = CreateFrame("Button", ss._f .. "ConfirmNo", frm, "GameMenuButtonTemplate")
  frm.no:SetSize  (75, 25)
  frm.no:SetPoint ("BOTTOMRIGHT", -10, 10)
  frm.no:SetText  (ss.T["btn_no"])
  frm.no:SetScript("OnClick", function()
    if frm.onNo then
      frm.onNo()
    end
  
    frm:Hide()
  end)
  
  return frm
end

--- Posts a notification
-- @param title The title to display.
-- @param content The content to display.
--
local function postNotification(title, content)
  frame = frame or createFrame()
  frame.content:SetText(content or "")
  frame.title  :SetText(title or "")
  frame:Show()
end

--- Prompts the user for confirmation.
-- @param content The content to display.
-- @param onYes The "Yes" event handler.
-- @param onNo The "No" event handler.
--
local function postConfirm(content, onYes, onNo)
  frameConfirm = frameConfirm or createFrameConfirm()
  frameConfirm.content:SetText(content or ss.T["lbl_are_you_sure"])
  frameConfirm.onYes = onYes
  frameConfirm.onNo = onNo
  
  frameConfirm:Show()
end

--- Closes the confirmation dialog.
--
local function closeConfirm()
  if frameConfirm and frameConfirm:IsVisible() then
    frameConfirm.onYes = nil
    frameConfirm.onNo = nil
    frameConfirm:Hide()
  end
end

--- Creates a notification.
-- @param title The title to display.
-- @param content The content to display.
--
function Notification:Notify(title, content)
  if title and content then
    postNotification(title, content)
  elseif self.queue then
    local completed = {}
    
    for k, v in pairs(self.queue) do
      completed[k] = v
    end
    
    for k, v in pairs(completed) do
      table.remove(self.queue, k)
    end
  end
end

--- Creates a confirmation dialog.
-- @param onYes The "Yes" callback.
-- @param onNo The "No" callback.
-- @param content The content to display
--
function Notification:Confirm(onYes, onNo, content)
  postConfirm(content, onYes, onNo)
end

--- Closes the confirmation dialog.
--
function Notification:CloseConfirm()
  closeConfirm()
end

--- Adds a notification to the queue.
-- @param title The title to display.
-- @param content The content to display.
-- @param buttonText The button text.
--
function Notification:Queue(title, content, buttonText)
  self.queue = self.queue or {}
  table.insert(self.queue, title, content, buttonText)
end

ss.Utils.addModule("Notification", Notification)
