--- Map Marker Dragging Frame
--
local DraggingFrame = {}
local addon, ns = ...
local ss = ns.SS

local CreateFrame, Minimap = CreateFrame, Minimap

--- Creates a new dragging frame.
-- @param parent The parent container.
--
function DraggingFrame:New(parent)
  -- Add the dragingFrame
  local dragingFrame = CreateFrame("Button", ss._f.."MinimapButton_DraggingFrame", parent)
  
  dragingFrame:HookScript("OnUpdate", function(self)
    if self._doUpdate then
      self._doUpdate()
    end
  end)
  
  dragingFrame._update = function()
    ss.MapMarker.MapButton.angle = ss.Utils:AngleFromFrame(Minimap)
    ss.MapMarker.MapButton:Reposition()
  end
  
  return dragingFrame
end

ss.Utils.addModule("MapMarkerDraggingFrame", DraggingFrame)
