--- Localization Resources
--
local AddOnName, nsVars = ...
local ss = nsVars.SS

-- TODO: Add translations for spells and auras.

local translations = {
  enUS = {
    ["btn_class"] = "Class",
    ["btn_close"] = "Close",
    ["btn_create"] = "Create",
    ["btn_create_profile"] = "Create Profile",
    ["btn_delete_profile"] = "Delete Profile",
    ["btn_no"] = "No",
    ["btn_reset_profile"] = "Reset Profile",
    ["btn_save_changes"] = "Save Changes",
    ["btn_undo_changes"] = "Undo Changes",
    ["btn_yes"] = "Yes",
    ["chk_animate_preview"] = "Animate Preview",
    ["chk_hide_on_combat"] = "Hide When Starting Combat",
    ["chk_hide_spheres_during_pet_battles"] = "Hide Spheres During Pet Battles",
    ["chk_show_artwork"] = "Show Artwork",
    ["chk_show_blizzard_frames"] = "Show Blizzard Unit Frames",
    ["chk_show_map_marker"] = "Show Map Marker",
    ["chk_show_percentage"] = "Show Percentage",
    ["chk_show_resource_gradients"] = "Show Resource Gradients",
    ["chk_show_value"] = "Show Value",
    ["chk_stacking"] = "Stacking",
    ["chk_track_additional_resource"] = "Track Additional Resource",
    ["chk_track_combat"] = "Track Combat",
    ["chk_track_pet"] = "Track Pet",
    ["config_title_general"] = "Config",
    ["config_title_micro_spheres_group_1"] = "Micro Spheres Group 1",
    ["config_title_micro_spheres_group_2"] = "Micro Spheres Group 2",
    ["config_title_micro_spheres_secondary_group_1"] = "Secondary Micro Spheres Group 1",
    ["config_title_micro_spheres_secondary_group_2"] = "Secondary Micro Spheres Group 2",
    ["config_title_profile"] = "Profile Settings",
    ["error_load_texture"] = "failed to load texture: %s from group %s",
    ["lbl_are_you_sure"] = "Are you sure?",
    ["lbl_confirmation"] = "Confirmation",
    ["lbl_global_cooldown"] = "Global Cooldown",
    ["lbl_group_1"] = "Group 1",
    ["lbl_group_2"] = "Group 2",
    ["lbl_new_textures_available"] = "New Textures Available!",
    ["lbl_stagger"] = "Stagger",
    ["lbl_texture_pack_technology"] = "Install \"Seamore Spheres Technology Textures\" to try them out. (No configuration required)",
    ["lbl_version"] = "Version: %s",
    ["menu_item_add_resource_custom"] = "-- Custom --",
    ["menu_item_bear"] = "Bear",
    ["menu_item_bear_group_1"] = "Bear - Group 1",
    ["menu_item_bear_group_2"] = "Bear - Group 2",
    ["menu_item_cat"] = "Cat",
    ["menu_item_cat_group_1"] = "Cat - Group 1",
    ["menu_item_cat_group_2"] = "Cat - Group 2",
    ["menu_item_copy_profile_select"] = "Select Profile",
    ["menu_item_customize_animation"] = "Animation",
    ["menu_item_customize_animation_alpha"] = "Alpha",
    ["menu_item_customize_animation_scale"] = "Scale",
    ["menu_item_customize_animation_strata"] = "Strata (Z Pos)",
    ["menu_item_customize_color"] = "Color",
    ["menu_item_customize_color1"] = "Color1",
    ["menu_item_customize_color2"] = "Color2",
    ["menu_item_customize_color3"] = "Color3",
    ["menu_item_customize_configure"] = "Configure Sphere",
    ["menu_item_customize_copy"] = "Copy Values",
    ["menu_item_customize_filling"] = "Filling",
    ["menu_item_customize_font_1"] = "Font 1",
    ["menu_item_customize_font_2"] = "Font 2",
    ["menu_item_customize_general"] = "General",
    ["menu_item_customize_scale"] = "Scale",
    ["menu_item_customize_second_filling"] = "Second Filling",
    ["menu_item_customize_speed"] = "Speed",
    ["menu_item_customize_swirl"] = "Swirl",
    ["menu_item_customize_x_pos"] = "X Pos",
    ["menu_item_customize_y_pos"] = "Y Pos",
    ["menu_item_default"] = "Default",
    ["menu_item_default_group_1"] = "Default - Group 1",
    ["menu_item_default_group_2"] = "Default - Group 2",
    ["menu_item_group"] = "Group",
    ["menu_item_load_values"] = "Load Values",
    ["menu_item_moonkin"] = "Moonkin",
    ["menu_item_moonkin_group_1"] = "Moonkin - Group 1",
    ["menu_item_moonkin_group_2"] = "Moonkin - Group 2",
    ["menu_item_resource_type_buff"] = "Buff",
    ["menu_item_resource_type_debuff"] = "Debuff",
    ["menu_item_resource_type_select"] = "Select Resource Type",
    ["menu_item_resource_type_spell_charges"] = "Spell Charges",
    ["menu_item_select_group"] = "Select Group",
    ["menu_item_select_resource"] = "Select Resource",
    ["menu_item_select_sphere"] = "Select Sphere",
    ["menu_item_smooth_animations_fast"] = "fast",
    ["menu_item_smooth_animations_med"] = "med",
    ["menu_item_smooth_animations_off"] = "off",
    ["menu_item_smooth_animations_slow"] = "slow",
    ["menu_label_add_resource"] = "Add Resource",
    ["menu_label_animation"] = "Animation",
    ["menu_label_background"] = "Background",
    ["menu_label_copy_profile"] = "Copy Profile",
    ["menu_label_customize"] = "Customize",
    ["menu_label_delete_custom"] = "Delete Custom",
    ["menu_label_micro_sphere_settings"] = "Micro Sphere Settings",
    ["menu_label_mode"] = "Mode",
    ["menu_label_preview_sphere"] = "Preview Sphere",
    ["menu_label_profile_to_use"] = "Profile to Use",
    ["menu_label_remove_resource"] = "Remove Resource",
    ["menu_label_resource_type"] = "Resource Type",
    ["menu_label_secondary_settings"] = "Secondary Settings",
    ["menu_label_smooth_animations"] = "Smooth Animations",
    ["menu_label_swirl"] = "Swirl",
    ["menu_label_text_format"] = "Text Format",
    ["mode_name_bear"] = "Bear",
    ["mode_name_cat"] = "Cat",
    ["mode_name_combat"] = "Combat",
    ["mode_name_default"] = "Default",
    ["mode_name_moonkin"] = "Moonkin",
    ["move_sphere"] = "Hold shift and drag on any sphere to move it.",
    ["msg_hide_additional_resource"] = "Hide Additional Resource",
    ["msg_hide_artwork"] = "Hide Artwork",
    ["msg_hide_blizzard_frames"] = "Hide Blizzard Unit Frames",
    ["msg_hide_map_marker"] = "Hide Map Marker",
    ["msg_hide_pet_sphere"] = "Hide Pet Sphere",
    ["msg_hide_resource_gradients"] = "Hide Gradients",
    ["msg_show_additional_resource"] = "Show Additional Resource",
    ["msg_show_pet_sphere"] = "Show Pet Sphere",
    ["msg_show_resource_gradients"] = "Show Gradients",
    ["msg_task_completed"] = "%s: Completed task: %s",
    ["msg_task_failed"] = "%s: Could not complete task: %s",
    ["msg_will_be_called"] = "%s: %s will be called once combat has ended.",
    ["open_menu"] = "Left click to open the menu",
    ["resource_name_additionalResource"] = "Additional Resource",
    ["resource_name_health"] = "Health",
    ["resource_name_mainResource"] = "Main Resource",
    ["resource_name_pet"] = "Pet",
    ["resource_name_vehicle"] = "Vehicle",
    ["resource_name_vehicleResource"] = "Vehicle Resource",
    ["tab_label_general"] = "General",
    ["tab_label_micro_spheres"] = "Micro Spheres",
    ["tab_label_preview"] = "Preview",
    ["tab_label_profile"] = "Profile",
    ["text_format_comma"] = "Comma Separated Value",
    ["text_format_raw"] = "Raw Value",
    ["text_format_truncate"] = "Truncate Value",
    ["txt_label_name"] = "Name",
    ["txt_label_stack_limit"] = "Stack Limit"
  },
  frFR = {
    ["btn_class"] = "Classe",
    ["btn_close"] = "Fermer",
    ["btn_create"] = "Créer",
    ["btn_create_profile"] = "Créer un profil",
    ["btn_delete_profile"] = "Supprimer le profil",
    ["btn_no"] = "Non",
    ["btn_reset_profile"] = "Réinitialiser",
    ["btn_save_changes"] = "Sauvegarder",
    ["btn_undo_changes"] = "Annuler",
    ["btn_yes"] = "Oui",
    ["chk_animate_preview"] = "Animer Aperçu",
    ["chk_hide_on_combat"] = "Cacher au début du combat",
    ["chk_hide_spheres_during_pet_battles"] = "Masquer les sphères pendant les batailles d'animaux de compagnie",
    ["chk_show_artwork"] = "Montrer l'oeuvre",
    ["chk_show_blizzard_frames"] = "Montrer les unités de Blizzard",
    ["chk_show_map_marker"] = "Afficher le marqueur de carte",
    ["chk_show_percentage"] = "Montrer le pourcentage",
    ["chk_show_resource_gradients"] = "Afficher les dégradés de ressources",
    ["chk_show_value"] = "Afficher la valeur",
    ["chk_stacking"] = "Empilage",
    ["chk_track_additional_resource"] = "Suivre des ressources supplémentaires",
    ["chk_track_combat"] = "Track Combat",
    ["chk_track_pet"] = "Suivre les animal",
    ["config_title_general"] = "Configuration",
    ["config_title_micro_spheres_group_1"] = "Micro Sphères Groupe 1",
    ["config_title_micro_spheres_group_2"] = "Micro Sphères Groupe 2",
    ["config_title_micro_spheres_secondary_group_1"] = "Micro Sphères Secondaires Groupe 1",
    ["config_title_micro_spheres_secondary_group_2"] = "Micro Sphères Secondaires Groupe 2",
    ["config_title_profile"] = "Paramètres de profil",
    ["error_load_texture"] = "Échec du chargement de la texture: %s du groupe %s",
    ["lbl_are_you_sure"] = "Êtes-vous sûr?",
    ["lbl_confirmation"] = "Confirmation",
    ["lbl_global_cooldown"] = "Recharge Globale",
    ["lbl_group_1"] = "Groupe 1",
    ["lbl_group_2"] = "Groupe 2",
    ["lbl_new_textures_available"] = "Nouvelles textures disponibles!",
    ["lbl_stagger"] = "Échelonner",
    ["lbl_texture_pack_technology"] = "Installez \"Seamore Spheres Technology Textures\" pour les essayer. (Aucune configuration requise)",
    ["lbl_version"] = "Version: %s",
    ["menu_item_add_resource_custom"] = "Personnalisée",
    ["menu_item_bear"] = "Ours",
    ["menu_item_bear_group_1"] = "Ours - Groupe 1",
    ["menu_item_bear_group_2"] = "Ours - Groupe 2",
    ["menu_item_cat"] = "Chat",
    ["menu_item_cat_group_1"] = "Chat - Groupe 2",
    ["menu_item_cat_group_2"] = "Chat - Groupe 2",
    ["menu_item_copy_profile_select"] = "Sélectionner un profil",
    ["menu_item_customize_animation"] = "Animation",
    ["menu_item_customize_animation_alpha"] = "Alpha",
    ["menu_item_customize_animation_scale"] = "Barème",
    ["menu_item_customize_animation_strata"] = "Strate (Position Z)",
    ["menu_item_customize_color"] = "Couleur",
    ["menu_item_customize_color1"] = "Couleur1",
    ["menu_item_customize_color2"] = "Couleur2",
    ["menu_item_customize_color3"] = "Couleur3",
    ["menu_item_customize_configure"] = "Configurer la sphère",
    ["menu_item_customize_copy"] = "Copier les valeurs",
    ["menu_item_customize_filling"] = "Remplissage",
    ["menu_item_customize_font_1"] = "Police de caractère 1",
    ["menu_item_customize_font_2"] = "Police de caractère 2",
    ["menu_item_customize_general"] = "Général",
    ["menu_item_customize_scale"] = "Barème",
    ["menu_item_customize_second_filling"] = "Deuxième Remplissage",
    ["menu_item_customize_speed"] = "Vitesse",
    ["menu_item_customize_swirl"] = "Tourbillon",
    ["menu_item_customize_x_pos"] = "Position X",
    ["menu_item_customize_y_pos"] = "Position Y",
    ["menu_item_default"] = "Défaut",
    ["menu_item_default_group_1"] = "Défaut - Groupe 1",
    ["menu_item_default_group_2"] = "Défaut - Groupe 2",
    ["menu_item_group"] = "Groupe",
    ["menu_item_load_values"] = "Valeurs de charge",
    ["menu_item_moonkin"] = "Moonkin",
    ["menu_item_moonkin_group_1"] = "Moonkin - Groupe 1",
    ["menu_item_moonkin_group_2"] = "Moonkin - Groupe 2",
    ["menu_item_resource_type_buff"] = "Buff",
    ["menu_item_resource_type_debuff"] = "Debuff",
    ["menu_item_resource_type_select"] = "Sélectionnez le type de ressource",
    ["menu_item_resource_type_spell_charges"] = "Charges d'orthographe",
    ["menu_item_select_group"] = "Sélectionner un groupe",
    ["menu_item_select_resource"] = "Sélectionner une ressource",
    ["menu_item_select_sphere"] = "Sélectionnez la sphère",
    ["menu_item_smooth_animations_fast"] = "vite",
    ["menu_item_smooth_animations_med"] = "moyen",
    ["menu_item_smooth_animations_off"] = "absent",
    ["menu_item_smooth_animations_slow"] = "lent",
    ["menu_label_add_resource"] = "Ajouter une ressource",
    ["menu_label_animation"] = "Animation",
    ["menu_label_background"] = "Fond",
    ["menu_label_copy_profile"] = "Copier le profil",
    ["menu_label_customize"] = "Personnaliser",
    ["menu_label_delete_custom"] = "Supprimer la personnalisation",
    ["menu_label_micro_sphere_settings"] = "Paramètres Micro Sphere",
    ["menu_label_mode"] = "Mode",
    ["menu_label_preview_sphere"] = "Prévisualiser Sphere",
    ["menu_label_profile_to_use"] = "Profil à utiliser",
    ["menu_label_remove_resource"] = "Supprimer la ressource",
    ["menu_label_resource_type"] = "Type de ressource",
    ["menu_label_secondary_settings"] = "Paramètres secondaires",
    ["menu_label_smooth_animations"] = "Animations lisses",
    ["menu_label_swirl"] = "Tourbillon",
    ["menu_label_text_format"] = "Format texte",
    ["mode_name_bear"] = "Ours",
    ["mode_name_cat"] = "Chat",
    ["mode_name_combat"] = "Combat",
    ["mode_name_default"] = "Défaut",
    ["mode_name_moonkin"] = "Moonkin",
    ["move_sphere"] = "Maintenez la touche Maj enfoncée et faites glisser n'importe quelle sphère pour la déplacer.",
    ["msg_hide_additional_resource"] = "Cacher une ressource supplémentaire",
    ["msg_hide_artwork"] = "Masquer l'oeuvre",
    ["msg_hide_blizzard_frames"] = "Masquer les unités de Blizzard",
    ["msg_hide_map_marker"] = "Masquer le marqueur de carte",
    ["msg_hide_pet_sphere"] = "Cacher la sphère des animaux",
    ["msg_hide_resource_gradients"] = "Masquer les dégradés",
    ["msg_show_additional_resource"] = "Afficher des ressources supplémentaires",
    ["msg_show_pet_sphere"] = "Montrer la sphère des animaux",
    ["msg_show_resource_gradients"] = "Afficher les dégradés",
    ["msg_task_completed"] = "%s: Tâche terminée: %s",
    ["msg_task_failed"] = "%s: Impossible de terminer la tâche: %s",
    ["msg_will_be_called"] = "%s: %s sera appelée une fois le combat terminé.",
    ["open_menu"] = "Clic gauche pour ouvrir le menu",
    ["resource_name_additionalResource"] = "Ressource Additionnelle",
    ["resource_name_health"] = "Santé",
    ["resource_name_mainResource"] = "Ressource Principale",
    ["resource_name_pet"] = "Animaux",
    ["resource_name_vehicle"] = "Véhicule",
    ["resource_name_vehicleResource"] = "Ressource Véhicule",
    ["tab_label_general"] = "Général",
    ["tab_label_micro_spheres"] = "Micro Sphères",
    ["tab_label_preview"] = "Prévu",
    ["tab_label_profile"] = "Profil",
    ["text_format_comma"] = "Valeur séparée par une virgule",
    ["text_format_raw"] = "Valeur brute",
    ["text_format_truncate"] = "Tronquer la valeur",
    ["txt_label_name"] = "Nom",
    ["txt_label_stack_limit"] = "Limite de pile"
  },
}


-- (For devs DO NOT COMMIT VALUES!)
-- Use these tables for any changes to translations for easy importing to CurseForge.
local enUS = {}
local frFR = {}

local newTranslations = {
  -- (For devs DO NOT COMMIT VALUES!)
  enUS = enUS,
  frFR = frFR,
}

-- Add the new translations.
for k,v in pairs(newTranslations) do
  translations[k] = translations[k] or {}
  
  for ind,str in pairs(v) do
    translations[k][ind] = str
  end
end

ss.locale = GetLocale() or "enUS"

ss.locale = translations[ss.locale] and ss.locale or "enUS"

ss.Utils.addModule("T", translations[ss.locale])

--- Returns a formatted string translation.
-- @param index The translation index.
-- @param ... Replacement values.
-- @return The formatted string.
--
function ss.t(index, ...)
  return ss.Utils:stringf(ss.T[index], ...)
end
