--- Initialization Script
--
local AddOnName, nsVars = ...

--Cache global variables
local vehicleInUse
local CreateFrame = CreateFrame

-- Prepare Addon variables
local SS = CreateFrame("Frame", "SSpheres_frame_addon")
nsVars.SS = SS
SS.dVars            = {}
SS.dVars["spheres"] = {}
SS.dVars["global"]  = {}

SS.pVars            = {}
SS.pVars["spheres"] = {}

SS._f = "SS_frame_"

--- Global function for importing remote assets.
--
rawset(_G, "SeamoreSpheresRemoteAssets", {
  newAssetCollection = function(collectionName, collection)
    -- TODO: Add validation to ensure proper values.
    SS.FillTextures.remoteAssets[collectionName] = collection
  end,
  newSwirlAssets     = function(collectionName, collection)
    -- TODO: Add validation to ensure proper values.
    SS.FillTextures.textures.swirl[collectionName] = collection
  end,
})

-- Initialize event listeners
local eventFrame = CreateFrame("Frame", SS._f.."event_watcher")
eventFrame:RegisterEvent("ADDON_LOADED")

--- Registers an event with the event frame.
-- @param e The event to register.
--
function SS:AddEvent(e)
  eventFrame:RegisterEvent(e)
end

--- Unregisters an event from the event frame.
-- @param e The event to register.
--
function SS:RemoveEvent(e)
  eventFrame:UnregisterEvent(e)
end

--- The event handler used to process incoming client events.
-- @param self A reference to the event frame.
-- @param event The event that was called.
-- @param arg1 The first argument passed with the event.
-- @param ... Remaining values passed with the event.
-- @see Frame_OnEvent
--
local function listen(self, event, ...)
  if SS[event] then
    SS[event](SS, ...)
  end
end

eventFrame:SetScript("OnEvent", listen)
