# Scrolling Chat Text

A World of Warcraft addon that displays chat messages in a customizable scrolling frame on your screen. Compatible with all WoW versions including Classic Era, Burning Crusade Classic, Wrath of the Lich King Classic, Cataclysm Classic, Mists of Pandaria Classic, and Retail.

## Features

### Core Functionality
- **Scrolling Chat Display** - Shows chat messages in a customizable scrolling frame
- **Chat Type Filtering** - Choose which chat types to display (Guild, Party, Raid, Say, Yell, Whisper, Officer, Instance)
- **Message Filtering** - Filter messages by keywords with multiple match types (Contains, Begins with, Ends with, Exact match)
- **Case Sensitivity** - Toggle case sensitivity for message filters
- **Display My Messages** - Option to show/hide your own messages

### Visual Customization
- **Frame Appearance** - Customizable height, width, position, and transparency
- **Text Styling** - Font selection, text scale, and outline options
- **Animation Control** - Adjustable scrolling speed and growth direction
- **Text Alignment** - Left, center, or right alignment
- **Background Options** - Show/hide frame and line backgrounds

### User Interface
- **Draggable Frame** - Move the frame anywhere on screen
- **Lock/Unlock** - Prevent accidental movement with lock button
- **Test Mode** - Preview the addon with sample messages
- **Configuration Panel** - Easy-to-use options interface

### Emoji Support
- **TwitchEmotes Integration** - Display Twitch emotes in chat messages
- **Animated Emojis** - Full support for animated emotes
- **Static Emojis** - Support for static emotes and custom emojis
- **Toggle Support** - Enable/disable emoji processing

### Advanced Features
- **Class Color Coding** - Player names colored by their class
- **Chat Prefixes** - Optional display of chat type prefixes
- **Duplicate Prevention** - Prevents duplicate messages within a time threshold
- **Frame Management** - Multiple frame support with individual settings

## Commands

- `/sct config` or `/sct options` - Open the configuration panel
- `/sct test` - Start test mode to preview the addon
- `/sct stop` - Stop the current test mode

## Installation

1. Download the addon files
2. Extract to your WoW `Interface\AddOns` folder
3. Create a folder named `ScrollingChatText` in the AddOns directory
4. Place all addon files in the `ScrollingChatText` folder
5. Restart WoW or reload your UI

The addon automatically detects your WoW version and uses the appropriate settings.

### After Installation:
1. Restart WoW or reload your UI (`/reload`)
2. Type `/sct config` to open the configuration panel

## Configuration

### General Settings
- **Enabled** - Enable or disable the addon
- **Frame Height** - Height of the scrolling frame
- **Line Height** - Height of each message line
- **Animation Speed** - Speed of the scrolling animation
- **Growth Direction** - Direction messages grow from (Up/Down)
- **Text Alignment** - Alignment of text within the frame (Left/Center/Right)
- **Frame Alpha** - Transparency of the frame
- **Text Scale** - Scale of the text
- **Show Background** - Show/hide frame background
- **Lock Frames** - Lock all frames to prevent moving
- **Font** - Select the font for text display
- **Font Outline** - Add outline to text
- **Enable Emojis** - Enable/disable emoji support
- **Display My Messages** - Show/hide your own messages

### Chat Type Settings
- **Guild Chat** - Enable/disable guild messages
- **Party Chat** - Enable/disable party messages
- **Raid Chat** - Enable/disable raid messages
- **Instance Chat** - Enable/disable instance messages
- **Say** - Enable/disable say messages
- **Yell** - Enable/disable yell messages
- **Whisper** - Enable/disable whisper messages
- **Officer Chat** - Enable/disable officer messages
- **Show Chat Prefixes** - Show/hide chat type prefixes

### Message Filters
- **Add Filters** - Add keywords to filter out messages
- **Match Types** - Choose how to match keywords (Contains, Begins with, Ends with, Exact match)
- **Case Sensitivity** - Toggle case sensitivity for filters
- **Enable/Disable** - Toggle individual filters on/off
- **Delete Filters** - Remove unwanted filters
- **Default Filter** - Includes a default `[WorldBuffs]` filter

## Emoji Support

The addon integrates with TwitchEmotes to display emotes in chat messages:

- **Automatic Detection** - Automatically detects if TwitchEmotes is installed
- **Animated Support** - Full support for animated emotes with proper animation
- **Static Support** - Support for static emotes and custom emojis
- **Performance Optimized** - Efficient emoji processing and animation updates

## Requirements

- World of Warcraft (Classic Era, TBC Classic, WotLK Classic, Cata Classic, MoP Classic, or Retail)
- No additional addons required (TwitchEmotes optional for emoji support)

## Troubleshooting

### Common Issues
- **Frame not showing** - Check if any chat types are enabled in settings
- **Emojis not working** - Ensure TwitchEmotes is installed and enabled
- **Performance issues** - Reduce animation speed or disable emoji support
- **Settings not saving** - Check if the addon has proper permissions

### Reset to Defaults
Use the "Reset to Defaults" button in the configuration panel to restore all settings to their default values. This will reset:
- All general settings
- All chat type settings  
- All message filters (except the default `[WorldBuffs]` filter)

## Credits

A World of Warcraft addon for displaying chat messages in a scrolling frame with advanced filtering and emoji support. Compatible with all WoW versions. 