ScrapBook = {};
ScrapBook.version = GetAddOnMetadata("ScrapBook", "Version");
ScrapBookDB = {};
ScrapBookSettings = {};
local countdown = 300;
local nextaction = "warn15";

function ScrapBook.OnEvent(_, event, arg1)
	if (event == "ADDON_LOADED" and arg1 == "ScrapBook") then
		ScrapBook.LoadSettings();
		ScrapBook.LoadFrame();
		
		UIParent:HookScript("OnUpdate", ScrapBook.OnUpdate);
		
		SlashCmdList["ScrapBook"] = ScrapBook.SlashHandler;
		SLASH_ScrapBook1 = "/ScrapBook";
		SLASH_ScrapBook2 = "/sb";
	elseif ((event == "SCREENSHOT_SUCCEEDED" or event == "SCREENSHOT_FAILED") and ScrapBook.active == true) then
		ScrapBook.ShowUI();
		ScrapBook.active = false;
	elseif (event == "ACHIEVEMENT_EARNED") then
		if (ScrapBookSettings.ach == true) then
			nextaction = "achshot";
			countdown = 1;
		end
	end
end

function ScrapBook.OnUpdate(self, elapsed)
	countdown = countdown - elapsed;
	if (countdown < 0) then
		countdown = 999;
		ScrapBook.TimeIsUp();
	end
end

function ScrapBook.TimeIsUp()
	if (ScrapBookSettings.enabled == false) then
		-- ScrapBook turned off
		nextaction = "warn15";
		countdown = tonumber(ScrapBookSettings.interval)*60/2;
	else
		if (nextaction == "achshot") then
			Screenshot();
			nextaction = "warn15";
			countdown = tonumber(ScrapBookSettings.interval)*60-15;
		elseif (UnitIsAFK("player") == true or IsResting() == true or ScrapBookSettings.enabled == false) then
			-- AFK or resting
			nextaction = "warn15";
			countdown = tonumber(ScrapBookSettings.interval)*60/2;
		elseif (nextaction == "warn15") then
			if (ScrapBookSettings.warn == true) then
				PlaySoundFile("Sound\\Interface\\RaidWarning.ogg");
				RaidNotice_AddMessage(RaidWarningFrame, "Snapshot Soon", {r = 0, g = 1, b = 0});
				if (ScrapBookSettings.hideui == true) then
					ScrapBook.Print("Snapshot in 15 seconds");
				end
			end
			nextaction = "warn3";
			countdown = 11;
		elseif (nextaction == "warn3") then
			if (ScrapBookSettings.warn == true and ScrapBookSettings.hideui == true) then
				ScrapBook.Print("Snapshot in 3...");
			end
			nextaction = "warn2";
			countdown = 1;
		elseif (nextaction == "warn2") then
			if (ScrapBookSettings.warn == true and ScrapBookSettings.hideui == true) then
				ScrapBook.Print("Snapshot in 2...");
			end
			nextaction = "warn1";
			countdown = 1;
		elseif (nextaction == "warn1") then
			if (ScrapBookSettings.hideui == true) then
				if ScrapBookSettings.warn == true then
					ScrapBook.Print("Snapshot in 1...");
				end
			else
				local playername = UnitName("player");
				local level = UnitLevel("player")
				local percentxp = floor(UnitXP("player")/UnitXPMax("player")*100);
				local timestamp = date("%B %d, %Y %I:%M%p")
				if (percentxp == 0) then
					ScrapBook.Print("["..playername.."]: LVL: "..level.." | "..timestamp);
				else
					ScrapBook.Print("["..playername.."]: LVL: "..level.." | XP "..percentxp.."% | "..timestamp);
				end	
			end
			nextaction = "snapshot";
			countdown = 1;
		elseif (nextaction == "snapshot") then
			ScrapBook.Snapshot();
			nextaction = "warn15";
			countdown = tonumber(ScrapBookSettings.interval)*60-15;
		end
	end
end

function ScrapBook.SlashHandler(cmd)
	cmd = strlower(cmd);
	if (cmd == "go") then
		ScrapBook.Snapshot();
	elseif (cmd == "info") then
		ScrapBook.Print("Next action: |cFF00FF00"..nextaction.."|r in "..floor(countdown).." seconds.");
	elseif (cmd == "test") then
		countdown = 5;
		ScrapBook.Print("Next action: |cFF00FF00"..nextaction.."|r in "..floor(countdown).." seconds.");
	else
		InterfaceOptionsFrame_OpenToCategory(ScrapBook.panel);
		InterfaceOptionsFrame_OpenToCategory(ScrapBook.panel);
	end
end

function ScrapBook.HideUI()
	--UIParent:Hide();
	Minimap:Hide();
	UIParent:SetAlpha(0);
	ScrapBook.frame:Show();
	ScrapBook.active = true;
end

function ScrapBook:ShowUI()
	--UIParent:Show();
	UIParent:SetAlpha(1);
	Minimap:Show();
	ScrapBook.frame:Hide();
end

function ScrapBook.LoadSettings()	
	if (ScrapBookSettings.enabled == nil) then ScrapBookSettings.enabled = true; end
	if (ScrapBookSettings.ach == nil) then ScrapBookSettings.ach = true; end
	if (ScrapBookSettings.hideui == nil) then ScrapBookSettings.hideui = true; end
	if (ScrapBookSettings.warn == nil) then ScrapBookSettings.warn = true; end
	if (ScrapBookSettings.interval == nil) then ScrapBookSettings.interval = 10; end
	countdown = tonumber(ScrapBookSettings.interval)*60-15;
end

function ScrapBook.LoadFrame()
	local frame = ScrapBook.frame;
	frame:Hide(); --HIDE
	frame:SetPoint("TOPLEFT", UIParent, "TOPLEFT");
	frame:SetPoint("BOTTOMRIGHT", UIParent, "RIGHT");
	
	local name = frame:CreateFontString(nil, nil, "QuestTitleFont");
	name:SetPoint("TOPLEFT", frame, "TOPLEFT", 0, 0);
	name:SetTextColor(1, 0.82, 0, 1);
	name:SetText("");
	frame.name = name;
	
	local guild = frame:CreateFontString(nil, nil, "QuestFont");
	guild:SetPoint("TOPLEFT", name, "BOTTOMLEFT", 0, 0);
	guild:SetTextColor(1, 0.82, 0, 1);
	guild:SetText("");
	frame.guild = guild;
	
	local level = frame:CreateFontString(nil, nil, "QuestFont");
	level:SetPoint("TOPLEFT", guild, "BOTTOMLEFT", 0, 0);
	level:SetTextColor(1, 0.82, 0, 1);
	level:SetText("");
	frame.level = level;
	
	local zone = frame:CreateFontString(nil, nil, "QuestTitleFont");
	zone:SetPoint("TOPRIGHT", frame, "TOPRIGHT", 0, 0);
	zone:SetTextColor(1, 0.82, 0, 1);
	zone:SetText("");
	frame.zone = zone;
	
	local subzone = frame:CreateFontString(nil, nil, "QuestFont");
	subzone:SetPoint("TOPRIGHT", zone, "BOTTOMRIGHT", 0, 0);
	subzone:SetTextColor(1, 0.82, 0, 1);
	subzone:SetText("");
	frame.subzone = subzone;
	
	local timestamp = frame:CreateFontString(nil, nil, "QuestFont");
	timestamp:SetPoint("TOPRIGHT", subzone, "BOTTOMRIGHT", 0, 0);
	timestamp:SetTextColor(1, 0.82, 0, 1);
	timestamp:SetText("");
	frame.timestamp = timestamp;
	
	frame.loaded = true;
	ScrapBook.frame = frame;
	
	-- INTERFACE OPTIONS
	local panel = CreateFrame("Frame", "ScrapBookPanel", UIParent);
	panel.name = "ScrapBook";
	panel.okay = function (self) ScrapBook.Panel_Okay(); end;
	panel.default = function (self) ScrapBook.Panel_Default(); end;
	panel.refresh = function (self) ScrapBook.Panel_OnShow(); end;
	
	-- Title
	local fonttitle = panel:CreateFontString(nil, "OVERLAY", "GameFontNormalLarge");
	fonttitle:SetPoint("TOPLEFT", panel, "TOPLEFT", 15, -15);
	fonttitle:SetText("ScrapBook  v"..ScrapBook.version);
	
	local chkenabled = CreateFrame("CheckButton", nil, panel, "UICheckButtonTemplate");
	chkenabled:SetPoint("TOPLEFT", fonttitle, "TOPLEFT", 0, -25);
	chkenabled:SetWidth(24);
	chkenabled:SetHeight(24);
	local font = panel:CreateFontString(nil, "OVERLAY", "GameFontHighlight");
	font:SetPoint("LEFT", chkenabled, "RIGHT", 4, 0);
	font:SetText("Enable Snapshots");
	panel.chkenabled = chkenabled;
	
	local chkach = CreateFrame("CheckButton", nil, panel, "UICheckButtonTemplate");
	chkach:SetPoint("TOPLEFT", chkenabled, "TOPLEFT", 0, -25);
	chkach:SetWidth(24);
	chkach:SetHeight(24);
	local font = panel:CreateFontString(nil, "OVERLAY", "GameFontHighlight");
	font:SetPoint("LEFT", chkach, "RIGHT", 4, 0);
	font:SetText("Snapshot Achievements");
	panel.chkach = chkach;
	
	local chkhideui = CreateFrame("CheckButton", nil, panel, "UICheckButtonTemplate");
	chkhideui:SetPoint("TOPLEFT", chkach, "TOPLEFT", 0, -25);
	chkhideui:SetWidth(24);
	chkhideui:SetHeight(24);
	local font = panel:CreateFontString(nil, "OVERLAY", "GameFontHighlight");
	font:SetPoint("LEFT", chkhideui, "RIGHT", 4, 0);
	font:SetText("Hide UI on Snapshot (except for achievements)");
	panel.chkhideui = chkhideui;
	
	local chkwarn = CreateFrame("CheckButton", nil, panel, "UICheckButtonTemplate");
	chkwarn:SetPoint("TOPLEFT", chkhideui, "TOPLEFT", 0, -25);
	chkwarn:SetWidth(24);
	chkwarn:SetHeight(24);
	local font = panel:CreateFontString(nil, "OVERLAY", "GameFontHighlight");
	font:SetPoint("LEFT", chkwarn, "RIGHT", 4, 0);
	font:SetText("Show Warning 15 Seconds Before Snapshot");
	panel.chkwarn = chkwarn;
	
	local font = panel:CreateFontString(nil, "OVERLAY", "GameFontNormal");
	font:SetPoint("TOPLEFT", chkwarn, "TOPLEFT", 0, -25);
	font:SetText("Snapshot Interval:");
	local interval = CreateFrame("Slider", "ScrapBookInterval", panel, "OptionsSliderTemplate");
	interval:SetPoint("TOPLEFT", font, "BOTTOMLEFT", 0, 0);
	interval:SetWidth(380);
	interval:SetOrientation("HORIZONTAL");
	interval:SetMinMaxValues(1,60);
	interval:SetObeyStepOnDrag(true);
	interval:SetValueStep(1);
	_G[interval:GetName()..'Low']:SetText(1);
	_G[interval:GetName()..'High']:SetText(60);
	interval:SetScript("OnValueChanged", ScrapBook.Panel_UpdateSlider);
	panel.interval = interval;
	panel.interval = interval;
	
	-- Scripts
	--panel:SetScript("OnShow", ScrapBook.Panel_OnShow)
	panel.shown = false;
	
	InterfaceOptions_AddCategory(panel);
	ScrapBook.panel = panel;
end

function ScrapBook.Panel_OnShow()
	ScrapBook.panel.chkenabled:SetChecked(ScrapBookSettings.enabled);
	ScrapBook.panel.chkhideui:SetChecked(ScrapBookSettings.hideui);
	ScrapBook.panel.chkach:SetChecked(ScrapBookSettings.ach);
	ScrapBook.panel.chkwarn:SetChecked(ScrapBookSettings.warn);
	ScrapBook.panel.interval:SetValue(ScrapBookSettings.interval);
	ScrapBook.panel.shown = true;
end

function ScrapBook.Panel_Okay()
	if (ScrapBook.panel.shown == true) then
		ScrapBookSettings.enabled = ScrapBook.panel.chkenabled:GetChecked() or false;
		ScrapBookSettings.ach = ScrapBook.panel.chkach:GetChecked() or false;
		ScrapBookSettings.hideui = ScrapBook.panel.chkhideui:GetChecked() or false;
		ScrapBookSettings.warn = ScrapBook.panel.chkwarn:GetChecked() or false;
		ScrapBookSettings.interval = ScrapBook.panel.interval:GetValue();
		countdown = tonumber(ScrapBookSettings.interval)*60-15;
	end
end

function ScrapBook.Panel_Default()
	ScrapBookSettings = {};
	ScrapBook.LoadSettings();
	ScrapBook.Panel_OnShow();
end

function ScrapBook.Panel_UpdateSlider(self)
	_G[self:GetName().."Text"]:SetText(self:GetValue().." Minutes");
end

function ScrapBook.Print(msg)
	if (DEFAULT_CHAT_FRAME) then
		msg = "|cFF00FF00[ScrapBook]|r " .. msg;
		DEFAULT_CHAT_FRAME:AddMessage(msg, 1, 1, 1);
	end
end

function ScrapBook.Snapshot()
	ScrapBook.Watermark();
	Screenshot();
end

function ScrapBook.Watermark()
	local playername = UnitName("player");
	local realmname = GetRealmName();
	local guildname, rankname = GetGuildInfo("player");
	local level = UnitLevel("player")
	local percentxp = floor(UnitXP("player")/UnitXPMax("player")*100);
	local zone = GetRealZoneText();
	local _, _, diffId = GetInstanceInfo();
	local subzone = GetSubZoneText();
	local timestamp = date("%B %d, %Y %I:%M%p")
	if (ScrapBookSettings.hideui == true) then
		ScrapBook.HideUI()
		ScrapBook.frame.name:SetText(playername.." of "..realmname);
		if (guildname ~= nil) then
			ScrapBook.frame.guild:SetText(rankname.." of <"..guildname..">");
		else
			ScrapBook.frame.guild:SetText(" ");
		end
		if (percentxp == 0) then
			ScrapBook.frame.level:SetText("Level: "..level);
		else
			ScrapBook.frame.level:SetText("Level: "..level.." XP: "..percentxp.."%");
		end
		if (diffId > 0) then
			ScrapBook.frame.zone:SetText(zone.." ("..GetDifficultyInfo(diffId)..")");
		else
			ScrapBook.frame.zone:SetText(zone);
		end
		if (zone ~= subzone) then
			ScrapBook.frame.subzone:SetText(" "..subzone);
		else
			ScrapBook.frame.subzone:SetText(" ");	
		end
		ScrapBook.frame.timestamp:SetText(timestamp);
	end
end

ScrapBook.frame = CreateFrame("Frame", "ScrapBookFrame");
ScrapBook.frame:RegisterEvent("ADDON_LOADED");
ScrapBook.frame:RegisterEvent("SCREENSHOT_SUCCEEDED");
ScrapBook.frame:RegisterEvent("SCREENSHOT_FAILED");
ScrapBook.frame:RegisterEvent("ACHIEVEMENT_EARNED");
ScrapBook.frame:SetScript("OnEvent", ScrapBook.OnEvent);