-- my custom locale file - more streamlined than AceLocale and no lib dependency

-- To help with missing translations please go here:
local url = "http://www.wowace.com/addons/saved_instances/localization/"

local addonName, vars = ...
local Ld, La = {}, {}
local locale = GAME_LOCALE or GetLocale()
if locale == "enGB" then locale = "enUS" end

vars.L = setmetatable({},{
  __index = function(t, s)
    if locale ~= "enUS" and Ld[s] and
      not La[s] and url and not vars.locale_warning then
      vars.locale_warning = true
      print(string.format("*** %s needs help translating to your language! (%s)", addonName, locale))
      print("*** If you speak English, you can contribute by visiting:")
      print("*** "..url)
    end
    return La[s] or Ld[s] or rawget(t,s) or s
  end
})

Ld["|cffffff00Left-click|r to detach tooltip"] = "|cffffff00Left-click|r to detach tooltip"
Ld["|cffffff00Middle-click|r to show Blizzard's Raid Information"] = "|cffffff00Middle-click|r to show Blizzard's Raid Information"
Ld["|cffffff00Right-click|r to configure SavedInstances"] = "|cffffff00Right-click|r to configure SavedInstances"
Ld["Abbreviate keystones"] = "Abbreviate keystones"
Ld["Abbreviate Mythic keystone dungeon names"] = "Abbreviate Mythic keystone dungeon names"
Ld["Account"] = "Account"
Ld["Account Summary"] = "Account Summary"
Ld["Alternating columns are colored differently"] = "Alternating columns are colored differently"
Ld["Always show"] = "Always show"
Ld["Always show new instances"] = "Always show new instances"
Ld["Arc"] = "Arc"
Ld["Are you sure you want to remove %s from the SavedInstances character database?"] = "Are you sure you want to remove %s from the SavedInstances character database?"
Ld["Are you sure you want to reset the SavedInstances character database? Characters will be re-populated as you log into them."] = "Are you sure you want to reset the SavedInstances character database? Characters will be re-populated as you log into them."
Ld["Attempt to recover completed daily quests for this character. Note this may recover some additional, linked daily quests that were not actually completed today."] = "Attempt to recover completed daily quests for this character. Note this may recover some additional, linked daily quests that were not actually completed today."
Ld["Augment bonus loot frame"] = "Augment bonus loot frame"
Ld["Automatically shrink the tooltip to fit on the screen"] = "Automatically shrink the tooltip to fit on the screen"
Ld["Battleground Deserter"] = "Battleground Deserter"
Ld["Bind a key to toggle the SavedInstances tooltip"] = "Bind a key to toggle the SavedInstances tooltip"
Ld["Bonus loot frame"] = "Bonus loot frame"
Ld["Bonus rolls"] = "Bonus rolls"
Ld[ [=[Boss kill information is missing for this lockout.
This is a Blizzard bug affecting certain old raids.]=] ] = [=[Boss kill information is missing for this lockout.
This is a Blizzard bug affecting certain old raids.]=]
Ld["Boss kill information is missing for this lockout.\\nThis is a Blizzard bug affecting certain old raids."] = "Boss kill information is missing for this lockout.\\nThis is a Blizzard bug affecting certain old raids."
Ld["BRH"] = "BRH"
Ld["Categories"] = "Categories"
Ld["Character column style"] = "Character column style"
Ld["Characters"] = "Characters"
Ld["CoEN"] = "CoEN"
Ld["Color currency by cap"] = "Color currency by cap"
Ld["Columns are colored according to the characters class"] = "Columns are colored according to the characters class"
Ld["Columns are the same color as the whole tooltip"] = "Columns are the same color as the whole tooltip"
Ld["Combine LFR"] = "Combine LFR"
Ld["Combine World Bosses"] = "Combine World Bosses"
Ld["Connected Realms"] = "Connected Realms"
Ld["CoS"] = "CoS"
Ld["Crops growing"] = "Crops growing"
Ld["Crops harvested today"] = "Crops harvested today"
Ld["Crops planted today"] = "Crops planted today"
Ld["Crops ready"] = "Crops ready"
Ld["Currency settings"] = "Currency settings"
Ld["Daily Quests"] = "Daily Quests"
Ld["Day"] = "Day"
Ld["Debug Mode"] = "Debug Mode"
Ld["DHT"] = "DHT"
Ld["Disable mouseover"] = "Disable mouseover"
Ld["Disable tooltip display on icon mouseover"] = "Disable tooltip display on icon mouseover"
Ld["Display instances in order of recommended level from lowest to highest"] = "Display instances in order of recommended level from lowest to highest"
Ld["Display instances with space inserted between categories"] = "Display instances with space inserted between categories"
Ld["Dump quest debugging information"] = "Dump quest debugging information"
Ld["Dump time debugging information"] = "Dump time debugging information"
Ld["Emissary Missing"] = "Emissary Missing"
Ld["Emissary Quests"] = "Emissary Quests"
Ld["Emissary quests"] = "Emissary quests"
Ld["EoA"] = "EoA"
Ld["Expansion"] = "Expansion"
Ld["Expired Lockout - Can be extended"] = "Expired Lockout - Can be extended"
Ld["Extended Lockout - Not yet saved"] = "Extended Lockout - Not yet saved"
Ld["Facets of Research"] = "Facets of Research"
Ld["Farm crops"] = "Farm crops"
Ld["Farm Crops"] = "Farm Crops"
Ld["Fit to screen"] = "Fit to screen"
Ld["Flex"] = "Flex"
Ld["Format large numbers"] = "Format large numbers"
Ld["General settings"] = "General settings"
Ld["Group"] = "Group"
Ld["Hold Alt to show all data"] = "Hold Alt to show all data"
Ld["HoV"] = "HoV"
Ld["Hover mouse on indicator for details"] = "Hover mouse on indicator for details"
Ld["Ignore"] = "Ignore"
Ld["Indicators"] = "Indicators"
Ld["Instance limit in Broker"] = "Instance limit in Broker"
Ld["Instances"] = "Instances"
Ld["Interleave"] = "Interleave"
Ld["L Kara"] = "L Kara"
Ld["Last updated"] = "Last updated"
Ld["Last Week Reward Usable"] = "Last Week Reward Usable"
Ld["Legion Transmute"] = "Legion Transmute"
Ld["Level %d Characters"] = "Level %d Characters"
Ld["LFG cooldown"] = "LFG cooldown"
Ld["LFR"] = "LFR"
Ld["List categories from the current expansion pack first"] = "List categories from the current expansion pack first"
Ld["List raid categories before dungeon categories"] = "List raid categories before dungeon categories"
Ld["Lockouts"] = "Lockouts"
Ld["Manage"] = "Manage"
Ld["Miscellaneous Tracking"] = "Miscellaneous Tracking"
Ld["MoS"] = "MoS"
Ld["Most recent first"] = "Most recent first"
Ld["Move down"] = "Move down"
Ld["Move up"] = "Move up"
Ld["Mythic Best"] = "Mythic Best"
Ld["Mythic Key Best"] = "Mythic Key Best"
Ld["Mythic Keystone"] = "Mythic Keystone"
Ld["Nelt"] = "Nelt"
Ld["Never show"] = "Never show"
Ld["Opacity of the tooltip row highlighting"] = "Opacity of the tooltip row highlighting"
Ld["Open config"] = "Open config"
Ld["Order must be a number in [0 - 999]"] = "Order must be a number in [0 - 999]"
Ld["Plant"] = "Plant"
Ld["Raids before dungeons"] = "Raids before dungeons"
Ld["Recent Bonus Rolls"] = "Recent Bonus Rolls"
Ld["Recent Instances"] = "Recent Instances"
Ld["Recover Dailies"] = "Recover Dailies"
Ld["Remind about weekly charm quest"] = "Remind about weekly charm quest"
Ld["Reminder: You need to do quest %s"] = "Reminder: You need to do quest %s"
Ld["Report instance resets to group"] = "Report instance resets to group"
Ld["Reset Characters"] = "Reset Characters"
Ld["Reverse ordering"] = "Reverse ordering"
Ld["Roll Bonus"] = "Roll Bonus"
Ld["Row Highlight"] = "Row Highlight"
Ld["Seed"] = "Seed"
Ld["Seeds"] = "Seeds"
Ld["Set All"] = "Set All"
Ld["Show category names"] = "Show category names"
Ld["Show category names in the tooltip"] = "Show category names in the tooltip"
Ld["Show cooldown for characters to use battleground system"] = "Show cooldown for characters to use battleground system"
Ld["Show cooldown for characters to use LFG dungeon system"] = "Show cooldown for characters to use LFG dungeon system"
Ld["Show currency earned"] = "Show currency earned"
Ld["Show currency max"] = "Show currency max"
Ld["Show Expired"] = "Show Expired"
Ld["Show expired instance lockouts"] = "Show expired instance lockouts"
Ld["Show Holiday"] = "Show Holiday"
Ld["Show holiday boss rewards"] = "Show holiday boss rewards"
Ld["Show minimap button"] = "Show minimap button"
Ld["Show name for a category when all displayed instances belong only to that category"] = "Show name for a category when all displayed instances belong only to that category"
Ld["Show only current server"] = "Show only current server"
Ld["Show Random"] = "Show Random"
Ld["Show random dungeon bonus reward"] = "Show random dungeon bonus reward"
Ld["Show self always"] = "Show self always"
Ld["Show self first"] = "Show self first"
Ld["Show server name"] = "Show server name"
Ld["Show the SavedInstances minimap button"] = "Show the SavedInstances minimap button"
Ld["Show tooltip hints"] = "Show tooltip hints"
Ld["Show When"] = "Show When"
Ld["Show when not saved"] = "Show when not saved"
Ld["Show when saved"] = "Show when saved"
Ld["Show/Hide the SavedInstances tooltip"] = "Show/Hide the SavedInstances tooltip"
Ld["Similarly, the words KILLED and TOTAL will be substituted with the number of bosses killed and total in the lockout."] = "Similarly, the words KILLED and TOTAL will be substituted with the number of bosses killed and total in the lockout."
Ld["Single category name"] = "Single category name"
Ld["Sort by server"] = "Sort by server"
Ld["Sort categories by"] = "Sort categories by"
Ld["Sort Order"] = "Sort Order"
Ld["Sorting"] = "Sorting"
Ld["SotT"] = "SotT"
Ld["Space between categories"] = "Space between categories"
Ld["Text"] = "Text"
Ld["The Four Celestials"] = "The Four Celestials"
Ld["These are the instances that count towards the %i instances per hour account limit, and the time until they expire."] = "These are the instances that count towards the %i instances per hour account limit, and the time until they expire."
Ld["This should only be used for characters who have been renamed or deleted, as characters will be re-populated when you log into them."] = "This should only be used for characters who have been renamed or deleted, as characters will be re-populated when you log into them."
Ld["Throw"] = "Throw"
Ld["Time /played"] = "Time /played"
Ld["Time Left"] = "Time Left"
Ld["Tooltip Scale"] = "Tooltip Scale"
Ld["Track"] = "Track"
Ld["Track Mythic keystone acquisition"] = "Track Mythic keystone acquisition"
Ld["Track Mythic keystone best run"] = "Track Mythic keystone best run"
Ld["Trade Skill Cooldowns"] = "Trade Skill Cooldowns"
Ld["Trade skills"] = "Trade skills"
Ld["Transmute"] = "Transmute"
Ld["Type"] = "Type"
Ld["U Kara"] = "U Kara"
Ld["Use class color"] = "Use class color"
Ld["VotW"] = "VotW"
Ld["Warn about instance limit"] = "Warn about instance limit"
Ld["Warning: You've entered about %i instances recently and are approaching the %i instance per hour limit for your account. More instances should be available in %s."] = "Warning: You've entered about %i instances recently and are approaching the %i instance per hour limit for your account. More instances should be available in %s."
Ld["Weekly Quests"] = "Weekly Quests"
Ld["Wild Transmute"] = "Wild Transmute"
Ld["World Boss"] = "World Boss"
Ld["World Bosses"] = "World Bosses"
Ld["You can combine icons and text in a single indicator if you wish. Simply choose an icon, and insert the word ICON into the text field. Anywhere the word ICON is found, the icon you chose will be substituted in."] = "You can combine icons and text in a single indicator if you wish. Simply choose an icon, and insert the word ICON into the text field. Anywhere the word ICON is found, the icon you chose will be substituted in."


if locale == "frFR" then
La["|cffffff00Left-click|r to detach tooltip"] = "|cffffff00Clic-gauche|r pour détacher l'infobulle."
La["|cffffff00Middle-click|r to show Blizzard's Raid Information"] = "|cffffff00Clic-milieu|r pour afficher les Infos Raid de Blizzard."
La["|cffffff00Right-click|r to configure SavedInstances"] = "|cffffff00Clic-droit|r pour configurer SavedInstances."
La["Abbreviate keystones"] = "Noms de donjons abrégés"
La["Abbreviate Mythic keystone dungeon names"] = "Abréger les noms des donjons de clés mythiques"
La["Account"] = "Compte"
La["Account Summary"] = "Résumé du compte"
La["Alternating columns are colored differently"] = "Les colonnes alternées sont colorées différemment"
La["Always show"] = "Toujours afficher"
La["Always show new instances"] = "Toujours afficher les nouvelles instances"
La["Arc"] = "Arca"
La["Are you sure you want to remove %s from the SavedInstances character database?"] = "Êtes-vous sûr de vouloir supprimer le personnage %s de la base de données SavedInstances ?"
La["Are you sure you want to reset the SavedInstances character database? Characters will be re-populated as you log into them."] = "Êtes-vous sûr de vouloir remettre à zéro votre base de données de personnages pour SavedInstances ? Les données des personnages seront re-récupérées au moment où vous les connecterez."
La["Attempt to recover completed daily quests for this character. Note this may recover some additional, linked daily quests that were not actually completed today."] = "Tente de récupérer les quêtes journalières accomplies par ce personnage. Notez que cela peut récupérer certaines quêtes supplémentaires liées qui n'ont pas été accomplies aujourd'hui."
La["Augment bonus loot frame"] = "Augmenter la taille du cadre des butins bonus "
La["Automatically shrink the tooltip to fit on the screen"] = "Réduit automatiquement la taille de l'infobulle pour la faire tenir sur l'écran."
La["Battleground Deserter"] = "Déserteur"
La["Bind a key to toggle the SavedInstances tooltip"] = "Associez une touche à l'affichage de l'infobulle de SavedInstance."
La["Bonus loot frame"] = "Cadre de jet de butin bonus"
La["Bonus rolls"] = "Jets de dé bonus"
La[ [=[Boss kill information is missing for this lockout.
This is a Blizzard bug affecting certain old raids.]=] ] = "Les informations de mort des boss manquent pour ce verrouillage d'instance.\\\\nC'est un bogue de Blizzard qui touche certains vieux raids."
La["Boss kill information is missing for this lockout.\\nThis is a Blizzard bug affecting certain old raids."] = "Les informations de mort des boss manquent pour ce verrouillage d'instance.\\nC'est un bogue de Blizzard qui touche certains vieux raids."
La["BRH"] = "BdF"
La["Categories"] = "Catégories"
La["Character column style"] = "Style de la colonne de personnage"
La["Characters"] = "Personnages"
La["CoEN"] = "CdlNÉ"
La["Color currency by cap"] = "Colorer les monnaies par cap"
La["Columns are colored according to the characters class"] = "Les colonnes sont colorées en fonction de la classe des personnages"
La["Columns are the same color as the whole tooltip"] = "Les colonnes sont de la même couleur que l'infobulles"
La["Combine LFR"] = "Fusionner les RdR"
La["Combine World Bosses"] = "Fusionner les boss extérieurs"
La["Connected Realms"] = "Royaumes connectés"
La["CoS"] = "CdÉ"
La["Crops growing"] = "Cultures en croissance "
La["Crops harvested today"] = "Cultures récoltées aujourd'hui "
La["Crops planted today"] = "Cultures plantées aujourd'hui "
La["Crops ready"] = "Cultures prêtes "
La["Currency settings"] = "Monnaies"
La["Daily Quests"] = "Quêtes journalières"
La["Day"] = "Jour"
La["Debug Mode"] = "Mode débogage"
La["DHT"] = "FS"
La["Disable mouseover"] = "Désactiver le survol avec la souris"
La["Disable tooltip display on icon mouseover"] = "Désactive l'affichage de l'infobulle lors du survol de la souris."
La["Display instances in order of recommended level from lowest to highest"] = "Affiche les instances dans l'ordre du niveau recommandé le plus bas au plus élevé."
La["Display instances with space inserted between categories"] = "Affiche les instances avec un espace entre les catégories."
La["Dump quest debugging information"] = "lister les informations de débogage des quêtes"
La["Dump time debugging information"] = "lister les informations de débogage du temps"
La["Emissary Missing"] = "Émissaire manquant"
La["Emissary Quests"] = "Quêtes d'émissaire"
La["Emissary quests"] = "Quêtes d'émissaire"
La["EoA"] = "ŒdA"
La["Expansion"] = "Extension"
La["Expired Lockout - Can be extended"] = "Verrouillage expiré - Peut être étendu"
La["Extended Lockout - Not yet saved"] = "Verrouillage étendu - Pas encore sauvegardé"
La["Facets of Research"] = "Facettes de recherche"
La["Farm crops"] = "Récoltes de la ferme"
La["Farm Crops"] = "Cultures de la ferme"
La["Fit to screen"] = "Ajuster à la taille de l'écran"
La["Flex"] = "Dynamique"
La["Format large numbers"] = "Formater les grands nombres"
La["General settings"] = "Options générales"
La["Group"] = "Grouper "
La["Hold Alt to show all data"] = "Maintenez Alt pour afficher toutes les données."
La["HoV"] = "SdV"
La["Hover mouse on indicator for details"] = "Survolez les indicateurs avec la souris pour plus d'informations."
La["Ignore"] = "Ignorer "
La["Indicators"] = "Indicateurs"
La["Instance limit in Broker"] = "Limite d'instance dans la barre (libBroker)"
La["Instances"] = "Instances"
La["Interleave"] = "Entrelacer "
La["L Kara"] = "Kara B"
La["Last updated"] = "Dernière mise à jour :"
La["Last Week Reward Usable"] = "Cache hebdomadaire disponible"
La["Legion Transmute"] = "Transmutation Légion"
La["Level %d Characters"] = "Personnages de niveau %d"
La["LFG cooldown"] = "Recherche de groupe"
La["LFR"] = "RdR"
La["List categories from the current expansion pack first"] = "Liste les catégories de l'extension actuelle en premier."
La["List raid categories before dungeon categories"] = "Liste les catégories de raids avant celles des donjons."
La["Lockouts"] = "Verrouillages"
La["Manage"] = "Gérer "
La["Miscellaneous Tracking"] = "Suivis divers "
La["MoS"] = "GdÂ"
La["Most recent first"] = "Les plus récents en premier"
La["Move down"] = "Déplacer vers le bas"
La["Move up"] = "Déplacer vers le haut"
La["Mythic Best"] = "Meilleur temps mythique"
La["Mythic Key Best"] = "Meilleur niveau de clé de donjon mythique"
La["Mythic Keystone"] = "Clé Mythique"
La["Nelt"] = "Nelt"
La["Never show"] = "Ne jamais afficher"
La["Opacity of the tooltip row highlighting"] = "Opacité de la mise en évidence des rangées de l'infobulle."
La["Open config"] = "Ouvrir la configuration"
La["Order must be a number in [0 - 999]"] = "l'ordre doit être un nombre compris entre [0 - 999]"
La["Plant"] = "Plantes"
La["Raids before dungeons"] = "Raids avant les donjons"
La["Recent Bonus Rolls"] = "Jets de dé bonus récents"
La["Recent Instances"] = "instance(s) récente(s) "
La["Recover Dailies"] = "Récupérer les journalières"
La["Remind about weekly charm quest"] = "Rappel de la quête hebdo. de charmes"
La["Reminder: You need to do quest %s"] = "Rappel : vous devez faire la quête %s"
La["Report instance resets to group"] = "Indiquer les réinitialisations d'instances au groupe"
La["Reset Characters"] = "Remise à zéro des personnages"
La["Reverse ordering"] = "Ordre inversé"
La["Roll Bonus"] = "Jets de dé bonus"
La["Row Highlight"] = "Surbrillance des rangées"
La["Seed"] = "Graine"
La["Seeds"] = "Graines"
La["Set All"] = "Tout régler sur :"
La["Show category names"] = "Noms des catégories"
La["Show category names in the tooltip"] = "Affiche les noms des catégories dans l'infobulle."
La["Show cooldown for characters to use battleground system"] = "Affiche le temps restant avant que les personnages déserteurs ne puissent rejoindre un champs de bataille à nouveau."
La["Show cooldown for characters to use LFG dungeon system"] = "Affiche le temps restant avant que les personnages ne puissent utiliser l'outil Recherche de groupe à nouveau."
La["Show currency earned"] = "Voir les monnaies gagnées"
La["Show currency max"] = "Voir le total maximum de monnaie"
La["Show Expired"] = "Afficher les expirés"
La["Show expired instance lockouts"] = "Affiche les verrouillages d'instances expirés."
La["Show Holiday"] = "Evènements saisonniers"
La["Show holiday boss rewards"] = "Affiche les récompenses des boss d’événements saisonniers."
La["Show minimap button"] = "Bouton sur la mini-carte"
La["Show name for a category when all displayed instances belong only to that category"] = "Affiche le nom d'une catégorie quand toutes les instances affichées appartiennent uniquement à cette catégorie. "
La["Show only current server"] = "Serveur actuel uniquement"
La["Show Random"] = "Sacoches Recherche de groupe"
La["Show random dungeon bonus reward"] = "Affiche les récompenses bonus des donjons aléatoires."
La["Show self always"] = "Toujours afficher soi-même"
La["Show self first"] = "Afficher soi-même en premier"
La["Show server name"] = "Afficher le nom du serveur"
La["Show the SavedInstances minimap button"] = "Affiche le bouton de SavedInstances sur la mini-carte."
La["Show tooltip hints"] = "Astuces sur l'infobulle"
La["Show When"] = "Montrer quand"
La["Show when not saved"] = "Afficher quand non sauvegardé"
La["Show when saved"] = "Quand inscrit"
La["Show/Hide the SavedInstances tooltip"] = "Afficher/cacher l'infobulle de SavedInstances"
La["Similarly, the words KILLED and TOTAL will be substituted with the number of bosses killed and total in the lockout."] = "De la même manière, les mots KILLED et TOTAL seront remplacés par le nombre de boss tués et le nombre total de boss du raid pour ce verrouillage."
La["Single category name"] = "Nom de catégorie unique"
La["Sort by server"] = "Trier par serveur"
La["Sort categories by"] = "Trier les catégories par :"
La["Sort Order"] = "Ordre de tri "
La["Sorting"] = "Trier"
La["SotT"] = "SdT"
La["Space between categories"] = "Espacer les catégories"
La["Text"] = "Texte"
La["The Four Celestials"] = "Les Quatre Astres"
La["These are the instances that count towards the %i instances per hour account limit, and the time until they expire."] = "Ces instances comptent dans la limite de %i instances par heure pour le compte, et le temps avant qu'elles n'expirent."
La["This should only be used for characters who have been renamed or deleted, as characters will be re-populated when you log into them."] = "Ceci ne devrait être utilisé que pour les personnages qui ont été renommés ou supprimés car les personnages seront de toutes façons ré-affichés lorsque vous vous connecterez avec."
La["Throw"] = "Lancer"
La["Time /played"] = "Temps /joué"
La["Time Left"] = "Temps restant "
La["Tooltip Scale"] = "Taille de l'infobulle"
La["Track"] = "Suivre"
La["Track Mythic keystone acquisition"] = "Suivre l'acquisition de clé de donjon mythique"
La["Track Mythic keystone best run"] = "Suivre le meilleur temps pour la clé de donjon mythique"
La["Trade Skill Cooldowns"] = "Échéances des métiers"
La["Trade skills"] = "Échéances des métiers"
La["Transmute"] = "Transmutation"
La["Type"] = "Type"
La["U Kara"] = "Kara H"
La["Use class color"] = "Colorer par classe"
La["VotW"] = "CdG"
La["Warn about instance limit"] = "Alerte sur la limite d'instance"
La["Warning: You've entered about %i instances recently and are approaching the %i instance per hour limit for your account. More instances should be available in %s."] = "Attention : vous êtes entré dans %i instances récemment et approchez la limite de %i instances par heure pour ce compte. Plus d'instances seront disponibles dans environ %s."
La["Weekly Quests"] = "Quêtes hebdomadaires"
La["Wild Transmute"] = "Transmutation sauvage"
La["World Boss"] = "Boss extérieur"
La["World Bosses"] = "Boss extérieurs"
La["You can combine icons and text in a single indicator if you wish. Simply choose an icon, and insert the word ICON into the text field. Anywhere the word ICON is found, the icon you chose will be substituted in."] = "Si vous le souhaitez, vous pouvez combiner les icônes et le texte en un seul indicateur. Il vous suffit de choisir une icône et d'insérer le mot ICON dans la zone de texte. Partout où le mot ICON sera trouvé, l'icône que vous avez choisi sera mise à la place."

elseif locale == "deDE" then
La["|cffffff00Left-click|r to detach tooltip"] = "|cffffff00Linksklick|r, um den Tooltip zu lösen"
La["|cffffff00Middle-click|r to show Blizzard's Raid Information"] = "|cffffff00Mittelklick|r , um die Blizzard-Schlachtszugsinfo anzuzeigen"
La["|cffffff00Right-click|r to configure SavedInstances"] = "|cffffff00Rechtsklick|r, um SavedInstances zu konfigurieren"
La["Abbreviate keystones"] = "Schlüsselsteine abkürzen"
La["Abbreviate Mythic keystone dungeon names"] = "Namen mythischer Schlüsselsteindungeons abkürzen"
La["Account"] = "Account"
La["Account Summary"] = "Accountübersicht"
La["Alternating columns are colored differently"] = "Abwechselnde Spalten sind unterschiedlich gefärbt"
La["Always show"] = "Immer anzeigen"
La["Always show new instances"] = "Neue Instanzen immer anzeigen"
La["Arc"] = "Arc"
La["Are you sure you want to remove %s from the SavedInstances character database?"] = "Bist du sicher, dass du %s aus der SavedInstances-Charakterdatenbank löschen möchtest?"
La["Are you sure you want to reset the SavedInstances character database? Characters will be re-populated as you log into them."] = "Bist du sicher, dass du die SavedInstances-Charakterdatenbank zurücksetzen willst? Die Charaktere werden neu angelegt, wenn du sie einloggst."
La["Attempt to recover completed daily quests for this character. Note this may recover some additional, linked daily quests that were not actually completed today."] = "Versucht die täglichen Quests für diesen Charakter wiederherzustellen. Dies könnte einige weitere, verbundene tägliche Quests wiederherstellen, die nicht wirklich abgeschlossen wurden."
La["Augment bonus loot frame"] = "Bonuswurffenster erweitern"
La["Automatically shrink the tooltip to fit on the screen"] = "Den Tooltip automatisch verkleinern, damit dieser auf den Bildschirm passt"
La["Battleground Deserter"] = "Schlachtfelddeserteur-Abklingzeit"
La["Bind a key to toggle the SavedInstances tooltip"] = "Wähle Tastenkombination zum Umschalten des SavedInstances-Tooltip"
La["Bonus loot frame"] = "Bonusbeutefenster"
La["Bonus rolls"] = "Bonuswürfe"
La[ [=[Boss kill information is missing for this lockout.
This is a Blizzard bug affecting certain old raids.]=] ] = [=[Informationen über getötete Bosse fehlen für diese Instanzsperre.
Dies ist ein Fehler von Blizzard, der einige ältere Schlachtzüge betrifft.]=]
La["Boss kill information is missing for this lockout.\\nThis is a Blizzard bug affecting certain old raids."] = "Informationen über getötete Bosse fehlen für diese ID.\\nDies ist ein Fehler von Blizzard bei einigen alten Raids."
--Translation missing 
La["BRH"] = "BRH"
La["Categories"] = "Kategorien"
La["Character column style"] = "Stil der Charakterspalte"
La["Characters"] = "Charaktere"
--Translation missing 
La["CoEN"] = "CoEN"
La["Color currency by cap"] = "Währung nach Limit einfärben"
La["Columns are colored according to the characters class"] = "Spalten werden entsprechend der Klasse des Charakters gefärbt"
La["Columns are the same color as the whole tooltip"] = "Spalten haben die selbe Farbe wie der gesamte Tooltip"
La["Combine LFR"] = "LFR/Flex zusammenfassen"
La["Combine World Bosses"] = "Weltbosse zusammenfassen"
La["Connected Realms"] = "Verknüpfte Realms"
--Translation missing 
La["CoS"] = "CoS"
La["Crops growing"] = "Wachsende Ernte"
La["Crops harvested today"] = "Heutige Ernte "
La["Crops planted today"] = "Heute ausgebrachte Samen"
La["Crops ready"] = "Reife Ernte"
La["Currency settings"] = "Abzeicheneinstellungen"
La["Daily Quests"] = "Tägliche Quests"
La["Day"] = "Tag"
La["Debug Mode"] = "Debugmodus"
--Translation missing 
La["DHT"] = "DHT"
La["Disable mouseover"] = "Mouseover deaktivieren"
La["Disable tooltip display on icon mouseover"] = "Deaktiviert die Anzeige des Tooltips bei Zeigen auf Icons mit der Maus"
La["Display instances in order of recommended level from lowest to highest"] = "Instanzen nach vorgeschlagenem Level anzeigen, beginnend mit der niedrigsten zur höchsten Instanz"
La["Display instances with space inserted between categories"] = "Instanzen mit einem Freiraum zwischen den verschiedenen Kategorien anzeigen"
La["Dump quest debugging information"] = "Quest Debugging Information"
La["Dump time debugging information"] = "Zeit Debugging Informationen"
La["Emissary Missing"] = "Abgesandtenkiste fehlt"
La["Emissary Quests"] = "Abgesandtenquests"
La["Emissary quests"] = "Abgesandtenquests"
--Translation missing 
La["EoA"] = "EoA"
La["Expansion"] = "Erweiterung"
La["Expired Lockout - Can be extended"] = "Abgelaufene ID – Kann fortgesetzt werden"
La["Extended Lockout - Not yet saved"] = "Verlängerte IDs – noch nicht gesichert"
La["Facets of Research"] = "Forschungsfacetten"
La["Farm crops"] = "Verfolge Ackerbau Gesamternte"
La["Farm Crops"] = "Ackerbau Ernte"
La["Fit to screen"] = "An Bildschirm anpassen"
La["Flex"] = "Flex"
La["Format large numbers"] = "Große Zahlen formatieren"
La["General settings"] = "Allgemeine Einstellungen"
La["Group"] = "Gruppieren"
La["Hold Alt to show all data"] = "Halte Alt gedrückt, um alle Daten anzuzeigen"
--Translation missing 
La["HoV"] = "HoV"
La["Hover mouse on indicator for details"] = "Für Details den Mauszeiger über den Indikator setzen"
La["Ignore"] = "Ignorieren"
La["Indicators"] = "Indikatoren"
--Translation missing 
La["Instance limit in Broker"] = "Instance limit in Broker"
La["Instances"] = "Instanzen"
La["Interleave"] = "Verschachteln"
--Translation missing 
La["L Kara"] = "L Kara"
La["Last updated"] = "Zuletzt aktualisiert"
La["Last Week Reward Usable"] = "Vorwochen-Kiste abholbereit"
La["Legion Transmute"] = "Legion Transmutation"
La["Level %d Characters"] = "Stufe-%d-Charaktere"
La["LFG cooldown"] = "Dungeonbrowser-Abklingzeit"
La["LFR"] = "LFR"
La["List categories from the current expansion pack first"] = "Kategorien der aktuellen Erweiterung zuerst auflisten"
La["List raid categories before dungeon categories"] = "Schlachtzugskategorien vor Dungeonkategorien auflisten"
La["Lockouts"] = "Aussperrungen"
La["Manage"] = "Verwalten"
La["Miscellaneous Tracking"] = "Verschiedenes"
--Translation missing 
La["MoS"] = "MoS"
La["Most recent first"] = "Aktuellste zuerst"
La["Move down"] = "Nach unten bewegen"
La["Move up"] = "Nach oben bewegen"
--Translation missing 
La["Mythic Best"] = "Mythic Best"
La["Mythic Key Best"] = "Bester mythischer Schlüsselstein"
La["Mythic Keystone"] = "Mythischer Schlüsselstein"
--Translation missing 
La["Nelt"] = "Nelt"
La["Never show"] = "Nie anzeigen"
La["Opacity of the tooltip row highlighting"] = "Transparenz der Zeilenhervorhebung im Tooltip"
La["Open config"] = "Konfiguration öffnen"
--Translation missing 
La["Order must be a number in [0 - 999]"] = "Order must be a number in [0 - 999]"
La["Plant"] = "Pflanze"
La["Raids before dungeons"] = "Schlachtzüge vor Dungeons"
La["Recent Bonus Rolls"] = "Letzte Bonuswürfe"
La["Recent Instances"] = "Kürzliche Instanzen"
La["Recover Dailies"] = "Dailies wiederherstellen"
La["Remind about weekly charm quest"] = "An die wöchentliche Amulett-Quest erinnern"
La["Reminder: You need to do quest %s"] = "Erinnerung: Du hast noch die Quest %s zu erledigen."
La["Report instance resets to group"] = "Instanzzurücksetzungen an die Gruppe berichten"
La["Reset Characters"] = "Charaktere zurücksetzen"
La["Reverse ordering"] = "Umgekehrte Anordung"
La["Roll Bonus"] = "Bonuswürfe"
La["Row Highlight"] = "Zeilenhervorhebung"
La["Seed"] = "Samen"
La["Seeds"] = "Samen"
La["Set All"] = "Alle festlegen"
La["Show category names"] = "Kategorienamen anzeigen"
La["Show category names in the tooltip"] = "Kategorienamen im Tooltip anzeigen"
La["Show cooldown for characters to use battleground system"] = "Zeigt Abklingzeiten für Charaktere, um das Schlachtfeldsystem zu benutzen, an."
La["Show cooldown for characters to use LFG dungeon system"] = "Zeigt Abklingzeiten für Charaktere, um den Dungeonbrowser zu benutzen, an"
La["Show currency earned"] = "Erhaltene Abzeichen anzeigen"
La["Show currency max"] = "Maximale Abzeichen anzeigen"
La["Show Expired"] = "Abgelaufene anzeigen"
La["Show expired instance lockouts"] = "Abgelaufene Instanz-IDs anzeigen"
La["Show Holiday"] = "Festtagsinformationen anzeigen"
La["Show holiday boss rewards"] = "Belohnungen der Festtagsbosse anzeigen"
La["Show minimap button"] = "Minikartenbutton anzeigen"
La["Show name for a category when all displayed instances belong only to that category"] = "Zeige den Namen der Kategorie, wenn alle angezeigten Instanzen zu dieser Kategorie gehören"
La["Show only current server"] = "Nur diesen Server anzeigen"
La["Show Random"] = "Zufällige anzeigen"
La["Show random dungeon bonus reward"] = "Bonusbelohnung für Zufallsdungeon anzeigen"
La["Show self always"] = "Sich selbst immer anzeigen"
La["Show self first"] = "Sich selbst zuerst anzeigen"
La["Show server name"] = "Realmname anzeigen"
La["Show the SavedInstances minimap button"] = "Den SavedInstances-Minikartenbutton anzeigen"
La["Show tooltip hints"] = "Tooltip-Hinweise anzeigen"
La["Show When"] = "Zeigen, wenn"
La["Show when not saved"] = "Immer anzeigen"
La["Show when saved"] = "Anzeigen, wenn gespeichert"
La["Show/Hide the SavedInstances tooltip"] = "Zeige/Verstecke den SavedInstances-Tooltip"
La["Similarly, the words KILLED and TOTAL will be substituted with the number of bosses killed and total in the lockout."] = "Ebenso werden die Wörter GETÖTET und GESAMT durch die Anzahl der getöteten und gesamten Bosse der ID ersetzt."
La["Single category name"] = "Einzelner Kategoriename"
La["Sort by server"] = "Nach Server sortieren"
La["Sort categories by"] = "Kategorien sortieren nach"
La["Sort Order"] = "Sortierung"
La["Sorting"] = "Sortierung"
--Translation missing 
La["SotT"] = "SotT"
La["Space between categories"] = "Freiraum zwischen Kategorien"
La["Text"] = "Text"
La["The Four Celestials"] = "Die Vier Erhabenen"
La["These are the instances that count towards the %i instances per hour account limit, and the time until they expire."] = "Diese Instanzen zählen zum %i-Instanzen-pro-Stunde-pro-Account-Limit, gefolgt von der Zeit, bis sie ablaufen."
La["This should only be used for characters who have been renamed or deleted, as characters will be re-populated when you log into them."] = "Dies sollte nur für Charaktere, die umbenannt oder gelöscht wurden, verwendet werden, da Charaktere erneut in die Datenbank eingetragen werden, wenn du dich mit ihnen einloggst."
La["Throw"] = "Werfen"
La["Time /played"] = "Zeit /gespielt"
La["Time Left"] = "Verbleibende Zeit"
La["Tooltip Scale"] = "Tooltip-Skalierung"
La["Track"] = "Verfolge"
--Translation missing 
La["Track Mythic keystone acquisition"] = "Track Mythic keystone acquisition"
--Translation missing 
La["Track Mythic keystone best run"] = "Track Mythic keystone best run"
La["Trade Skill Cooldowns"] = "Abklingzeiten der Berufsfertigkeiten"
La["Trade skills"] = "Berufsfertigkeiten"
La["Transmute"] = "Transmutieren"
La["Type"] = "Wert"
--Translation missing 
La["U Kara"] = "U Kara"
La["Use class color"] = "Klassenfarbe verwenden"
--Translation missing 
La["VotW"] = "VotW"
La["Warn about instance limit"] = "Vor Instanzlimit warnen"
La["Warning: You've entered about %i instances recently and are approaching the %i instance per hour limit for your account. More instances should be available in %s."] = "Achtung: Du hast kürzlich %i Instanzen betreten und näherst Dich dem Limit von %i Instanzen pro Stunde für Deinen Account. Weitere Instanzen sollten in %s verfügbar sein."
La["Weekly Quests"] = "Wöchentliche Quests"
La["Wild Transmute"] = "Wilde Transmutation"
La["World Boss"] = "Weltboss"
La["World Bosses"] = "Weltbosse"
La["You can combine icons and text in a single indicator if you wish. Simply choose an icon, and insert the word ICON into the text field. Anywhere the word ICON is found, the icon you chose will be substituted in."] = "Nach Wunsch können Icons und Text in einem einzelnen Indikator kombiniert werden. Wähle ein Icon und gebe das Wort ICON in das Textfeld ein. Wo auch immer das Wort ICON gefunden wird, wird das gewählte Icon angefügt."

elseif locale == "koKR" then
La["|cffffff00Left-click|r to detach tooltip"] = "|cffffff00좌-클릭|r으로 툴팁 떼어내기"
La["|cffffff00Middle-click|r to show Blizzard's Raid Information"] = "|cffffff00가운데-클릭|r 블리자드 공격대 정보 보기"
La["|cffffff00Right-click|r to configure SavedInstances"] = "|cffffff00우-클릭|r으로 SavedInstances 설정"
La["Abbreviate keystones"] = "쐐기명 축약"
La["Abbreviate Mythic keystone dungeon names"] = "신화 쐐기돌 던전 이름을 짧게 표시하기"
La["Account"] = "계정"
La["Account Summary"] = "계정 요약"
La["Alternating columns are colored differently"] = "번갈아 나오는 열이 다른 색으로 표시됩니다."
La["Always show"] = "항상 표시"
La["Always show new instances"] = "항상 새로운 인스턴스를 표시합니다"
La["Arc"] = "비전로"
La["Are you sure you want to remove %s from the SavedInstances character database?"] = "SavedInstances 캐릭터 데이터베이스에서 %s를(을) 제거하시겠습니까?"
La["Are you sure you want to reset the SavedInstances character database? Characters will be re-populated as you log into them."] = "당신의 SavedInstances의 캐릭터 데이터베이스를 초기화 하시겠습니까? 재로그인시 캐릭터의 정보가 다시 채워집니다."
La["Attempt to recover completed daily quests for this character. Note this may recover some additional, linked daily quests that were not actually completed today."] = "이 캐릭터의 '완료된 일일퀘스트'의 복구를 시도합니다. 실제로 오늘 완료되지 않은 일부 추가/연속 일일 퀘스트를 복구 할 수 있습니다."
La["Augment bonus loot frame"] = "추가 전리품 프레임 보강"
La["Automatically shrink the tooltip to fit on the screen"] = "화면에 맞게 자동으로  툴팁을 축소합니다"
La["Battleground Deserter"] = "전장 탈영 대기시간 추적"
La["Bind a key to toggle the SavedInstances tooltip"] = "SavedInstances 툴팁을 보거나 숨기는 키 설정"
La["Bonus loot frame"] = "추가 전리품 창"
La["Bonus rolls"] = "추가 전리품 주사위 추적"
La[ [=[Boss kill information is missing for this lockout.
This is a Blizzard bug affecting certain old raids.]=] ] = "보스 처지 정보가 누락되어 잠겨 있습니다.\\n 이것은 특정 낭만 공격대에 영향을 미치는 블리자드 버그입니다."
La["Boss kill information is missing for this lockout.\\nThis is a Blizzard bug affecting certain old raids."] = "보스 처지 정보가 누락되어 잠겨 있습니다.\\n 이것은 특정 낭만 공격대에 영향을 미치는 블리자드 버그입니다."
La["BRH"] = "검떼"
La["Categories"] = "카테고리"
La["Character column style"] = "케릭터 줄 스타일"
La["Characters"] = "캐릭터"
La["CoEN"] = "대성당"
La["Color currency by cap"] = "화폐 한도에 채색"
La["Columns are colored according to the characters class"] = "줄은 케릭터의 직업에 맞는 색 사용"
La["Columns are the same color as the whole tooltip"] = "줄은 전체 툴팁과 같은 색 사용"
La["Combine LFR"] = "공찾/탄공 합침"
La["Combine World Bosses"] = "야외 보스 합침"
La["Connected Realms"] = "연동 서버"
La["CoS"] = "별궁"
La["Crops growing"] = "자라는 작물"
La["Crops harvested today"] = "오늘 수확한 작물"
La["Crops planted today"] = "오늘 심은 작물"
La["Crops ready"] = "준비된 작물"
La["Currency settings"] = "화폐 설정"
La["Daily Quests"] = "일일 퀘스트"
La["Day"] = "일"
La["Debug Mode"] = "디버그 모드"
La["DHT"] = "어숲"
La["Disable mouseover"] = "마우스오버 사용안함"
La["Disable tooltip display on icon mouseover"] = "아이콘 마우스 오버시 툴팁 표시 안함"
La["Display instances in order of recommended level from lowest to highest"] = "권장 레벨이 낮은 것부터 높은 순으로 인던을 표시합니다."
La["Display instances with space inserted between categories"] = "카테고리 사이에 공백을 삽입하여 인스턴스를 표시합니다."
La["Dump quest debugging information"] = "퀘스트 디버그 정보 덤프하기"
La["Dump time debugging information"] = "시간 디버깅 정보 덤프하기"
La["Emissary Missing"] = "사절 없음"
La["Emissary Quests"] = "사절 퀘스트"
La["Emissary quests"] = "사절 퀘스트"
La["EoA"] = "아즈"
La["Expansion"] = "확장"
La["Expired Lockout - Can be extended"] = "만료된 귀속 - 연장 가능"
La["Extended Lockout - Not yet saved"] = "연장된 귀속 - 아직 저장 안됨"
La["Facets of Research"] = "연구용 다면체"
La["Farm crops"] = "농작물"
La["Farm Crops"] = "농작물"
La["Fit to screen"] = "화면에 맞춤"
La["Flex"] = "탄력적 공격대"
La["Format large numbers"] = "천 단위 구분자(,) 사용 여부"
La["General settings"] = "일반 설정"
La["Group"] = "그룹"
La["Hold Alt to show all data"] = "알트키를 누르고 있으면 모든 정보 표시"
La["HoV"] = "용맹"
La["Hover mouse on indicator for details"] = "마우스를 올리면 세부 내용 표시"
La["Ignore"] = "무시"
La["Indicators"] = "표시기"
La["Instance limit in Broker"] = "Broker에 인스턴스 제한 표시"
La["Instances"] = "인스턴스"
La["Interleave"] = "끼워넣기"
La["L Kara"] = "하층"
La["Last updated"] = "마지막 갱신"
La["Last Week Reward Usable"] = "주간 보상"
La["Legion Transmute"] = "군단 변환식"
La["Level %d Characters"] = "레벨 %d 캐릭터"
La["LFG cooldown"] = "무작위 던전 대기시간 추적"
La["LFR"] = "공찾"
La["List categories from the current expansion pack first"] = "현재 확장팩을 첫번째로 목록에 나열"
La["List raid categories before dungeon categories"] = "던전 카테고리 앞에 공격대 카테고리 나열"
La["Lockouts"] = "귀속"
La["Manage"] = "관리"
La["Miscellaneous Tracking"] = "기타"
La["MoS"] = "아귀"
La["Most recent first"] = "최근 것을 첫번째로"
La["Move down"] = "아래로 이동"
La["Move up"] = "위로 이동"
La["Mythic Best"] = "쐐기 최고 기록"
La["Mythic Key Best"] = "주차 단수"
La["Mythic Keystone"] = "쐐기"
La["Nelt"] = "넬타"
La["Never show"] = "표시하지 않음"
La["Opacity of the tooltip row highlighting"] = "툴팁 열 강조에 대한 불투명도"
La["Open config"] = "설정 열기"
La["Order must be a number in [0 - 999]"] = "순서는 숫자 0에서 999사이의 값을 입력하셔야 합니다."
La["Plant"] = "작물"
La["Raids before dungeons"] = "던전 앞에 공격대"
La["Recent Bonus Rolls"] = "최근 추가 보상"
La["Recent Instances"] = "최근 인던"
La["Recover Dailies"] = "일일퀘스트 복구"
La["Remind about weekly charm quest"] = "주간 부적 퀘스트에 대한 알림"
La["Reminder: You need to do quest %s"] = "알림 : 당신은 %s 퀘스트를 해야합니다"
La["Report instance resets to group"] = "던전 초기화를 파티에 알림"
La["Reset Characters"] = "캐릭터 초기화"
La["Reverse ordering"] = "순서를 거꾸로"
La["Roll Bonus"] = "추가 보상"
La["Row Highlight"] = "열 강조"
La["Seed"] = "씨앗"
La["Seeds"] = "씨앗들"
La["Set All"] = "모든 설정"
La["Show category names"] = "카테고리 이름 표시"
La["Show category names in the tooltip"] = "툴팁에 카테고리 이름을 표시합니다"
La["Show cooldown for characters to use battleground system"] = "캐릭터가 전장 시스템을 사용하기 위해 남은 대기시간을 표시합니다."
La["Show cooldown for characters to use LFG dungeon system"] = "캐릭터가 무작위 던전 시스템을 사용하기 위해 남은 대기시간을 표시합니다."
La["Show currency earned"] = "화폐 수입 보이기"
La["Show currency max"] = "화폐 최대치 보이기"
La["Show Expired"] = "만료 표시"
La["Show expired instance lockouts"] = "만료된 인스턴스 귀속 표시"
La["Show Holiday"] = "축제일 보기"
La["Show holiday boss rewards"] = "축제일 보스 보상 보기"
La["Show minimap button"] = "미니맵 버튼 표시"
La["Show name for a category when all displayed instances belong only to that category"] = "표시된 모든 인던이 해당 카테고리에만 속하는 경우 인던 이름을 표시합니다."
La["Show only current server"] = "현재 서버만 표시"
La["Show Random"] = "무작위 던전 표시"
La["Show random dungeon bonus reward"] = "무작위 던전의 보너스 보상을 보여줍니다."
La["Show self always"] = "자신은 항상 표시"
La["Show self first"] = "자신을 첫 번째로 표시"
La["Show server name"] = "서버이름 보이기"
La["Show the SavedInstances minimap button"] = "SavedInstances 미니맵 버튼을 표시합니다"
La["Show tooltip hints"] = "툴팁 도움말 표시"
La["Show When"] = "표시 시기"
La["Show when not saved"] = "저장 되지 않았을 때 표시"
La["Show when saved"] = "저장할 때 표시"
La["Show/Hide the SavedInstances tooltip"] = "SavedInstances 툴팁 보기/숨김"
La["Similarly, the words KILLED and TOTAL will be substituted with the number of bosses killed and total in the lockout."] = "마찬가지로, KILLED와 TOTAL의 단어가 귀속된 공격대의 '처치한 보스 숫자'와 '전체 보스'로 대체됩니다."
La["Single category name"] = "단일 카테고리 이름"
La["Sort by server"] = "서버 별 정렬"
La["Sort categories by"] = "카테고리 정렬"
La["Sort Order"] = "정렬 순서"
La["Sorting"] = "정렬"
La["SotT"] = "삼두정"
La["Space between categories"] = "카테고리 사이에 공백"
La["Text"] = "글자"
La["The Four Celestials"] = "네 천신"
La["These are the instances that count towards the %i instances per hour account limit, and the time until they expire."] = "계정당 1시간 내에 입장이 제한된 %i 개의 인스턴스에 포함된 인스턴스와 만료 될 때까지 남은 시간입니다"
La["This should only be used for characters who have been renamed or deleted, as characters will be re-populated when you log into them."] = "이름이 변경되거나 삭제된 캐릭터만 사용해야 하며 재로그인시 캐릭터의 정보가 다시 채워집니다."
La["Throw"] = "뿌리기"
La["Time /played"] = "플레이 시간 표시"
La["Time Left"] = "남은 시간"
La["Tooltip Scale"] = "툴팁 크기"
La["Track"] = "추적:"
La["Track Mythic keystone acquisition"] = "쐐기돌 추적"
La["Track Mythic keystone best run"] = "쐐기 단수 기록"
La["Trade Skill Cooldowns"] = "전문 기술 재사용 대기시간"
La["Trade skills"] = "전문 기술"
La["Transmute"] = "변환"
La["Type"] = "유형"
La["U Kara"] = "상층"
La["Use class color"] = "직업 색상 사용"
La["VotW"] = "금고"
La["Warn about instance limit"] = "인스턴스 제한 경고"
La["Warning: You've entered about %i instances recently and are approaching the %i instance per hour limit for your account. More instances should be available in %s."] = "경고 : 최근 %i 개의 인스턴스에 입장하였고, 귀하의 계정에 대해 시간 당 제한된 %i 개의 인스턴스에 근접하고 있습니다. 더 많은 인스턴스는 %s 후에 이용가능합니다."
La["Weekly Quests"] = "주간 퀘스트"
La["Wild Transmute"] = "거친 변환"
La["World Boss"] = "월드보스"
La["World Bosses"] = "야외 우두머리"
La["You can combine icons and text in a single indicator if you wish. Simply choose an icon, and insert the word ICON into the text field. Anywhere the word ICON is found, the icon you chose will be substituted in."] = "원할 경우 단일 표시기에 아이콘과 문자를 조합하여 사용이 가능합니다. 단순히 아이콘을 선택하면 문자 영역에 문자열 아이콘을 삽입합니다. 어디에서든 문자열 아이콘을 찾을 수 있으며, 선택한 아이콘으로 대체됩니다."

elseif locale == "esMX" then
La["|cffffff00Left-click|r to detach tooltip"] = "|cffffff00Click-Izquierdo|r para separar la descripción"
La["|cffffff00Middle-click|r to show Blizzard's Raid Information"] = "|cffffff00Click-Medio|r para mostrar Información de banda de Blizzard"
La["|cffffff00Right-click|r to configure SavedInstances"] = "|cffffff00Click-Derecho|r para configurar SavedInstances"
--Translation missing 
La["Abbreviate keystones"] = "Abbreviate keystones"
--Translation missing 
La["Abbreviate Mythic keystone dungeon names"] = "Abbreviate Mythic keystone dungeon names"
La["Account"] = "Cuenta"
La["Account Summary"] = "Resumen de Cuenta"
La["Alternating columns are colored differently"] = "Columnas alternadas son de diferentes colores"
La["Always show"] = "Mostrar siempre"
La["Always show new instances"] = "Siempre mostrar nuevas instancias"
--Translation missing 
La["Arc"] = "Arc"
La["Are you sure you want to remove %s from the SavedInstances character database?"] = "¿Está seguro de que desea remover %s de la base de datos de SavedInstances del personaje? "
La["Are you sure you want to reset the SavedInstances character database? Characters will be re-populated as you log into them."] = "¿Seguro que quieres reiniciar la base de datos de personajes de SavedInstances? Los personajes se registraran de nuevo cuando los conectes en el juego."
La["Attempt to recover completed daily quests for this character. Note this may recover some additional, linked daily quests that were not actually completed today."] = "Tratar a recuperar las misiones diarias ya completados hoy por este personaje. Cuenta que esto podría recuperar algunas otras misiones relacionadas que no fueron realmente completaron hoy."
La["Augment bonus loot frame"] = "Agrandar marco de bonus de botín"
La["Automatically shrink the tooltip to fit on the screen"] = "Comprimir automáticamente la ventana para que quepa en la pantalla."
La["Battleground Deserter"] = "Sigue la duración del perjuicio Desertor"
La["Bind a key to toggle the SavedInstances tooltip"] = "Asignar una tecla para mostrar/ocultar la descripción SavedInstances"
--Translation missing 
La["Bonus loot frame"] = "Bonus loot frame"
La["Bonus rolls"] = "Tiradas extras"
--Translation missing 
La[ [=[Boss kill information is missing for this lockout.
This is a Blizzard bug affecting certain old raids.]=] ] = [=[Boss kill information is missing for this lockout.
This is a Blizzard bug affecting certain old raids.]=]
La["Boss kill information is missing for this lockout.\\nThis is a Blizzard bug affecting certain old raids."] = "Falta información de los jefes muertos para este registro.\\nEs un error de Blizzard que afecta algas bandas de edad."
--Translation missing 
La["BRH"] = "BRH"
La["Categories"] = "Categorías"
La["Character column style"] = "Estilo de columna de personaje"
La["Characters"] = "Personajes"
--Translation missing 
La["CoEN"] = "CoEN"
La["Color currency by cap"] = "Colorea moneda por límite"
La["Columns are colored according to the characters class"] = "Las columnas se colorean según las clases de los personajes"
La["Columns are the same color as the whole tooltip"] = "Color las columnas del mismo color como la descripción entera."
La["Combine LFR"] = "Combinar BDB"
La["Combine World Bosses"] = "Combinar Jefes del Mundo"
La["Connected Realms"] = "Reinos Conectados"
--Translation missing 
La["CoS"] = "CoS"
La["Crops growing"] = "Cultivos crecientes"
La["Crops harvested today"] = "Cultivos cosechados"
La["Crops planted today"] = "Cultivos plantados"
La["Crops ready"] = "Cultivos listos"
La["Currency settings"] = "Opciones de Monedas"
La["Daily Quests"] = "Misiones diarias"
--Translation missing 
La["Day"] = "Day"
--Translation missing 
La["Debug Mode"] = "Debug Mode"
--Translation missing 
La["DHT"] = "DHT"
La["Disable mouseover"] = "Deshabilitar tooltip"
La["Disable tooltip display on icon mouseover"] = "Deshabilita el marco al pasar el ratón sobre el ícono"
La["Display instances in order of recommended level from lowest to highest"] = "Mostrar instancias en orden de nivel recomendado de menor a mayor"
La["Display instances with space inserted between categories"] = "Mostrar instancias con espacio entre categorías"
La["Dump quest debugging information"] = "Deshacerse de la información de depuración de misiones"
La["Dump time debugging information"] = "Deshacerse de la información de depuración de tiempo"
--Translation missing 
La["Emissary Missing"] = "Emissary Missing"
--Translation missing 
La["Emissary Quests"] = "Emissary Quests"
--Translation missing 
La["Emissary quests"] = "Emissary quests"
--Translation missing 
La["EoA"] = "EoA"
La["Expansion"] = "Expansión"
La["Expired Lockout - Can be extended"] = "Registro expirado - puede extenderse"
La["Extended Lockout - Not yet saved"] = "Registro extendido - no se ha guardado"
La["Facets of Research"] = "Facetas de investigación"
La["Farm crops"] = "Seguir cultivos agrícolas"
La["Farm Crops"] = "Cultivos agrícolas"
La["Fit to screen"] = "Ajustar a Pantalla"
La["Flex"] = "Flexible"
La["Format large numbers"] = "Formatear números extensos"
La["General settings"] = "Opciones generales"
La["Group"] = "Grupo"
La["Hold Alt to show all data"] = "Pulse la tecla Alt para mostrar toda la información"
--Translation missing 
La["HoV"] = "HoV"
La["Hover mouse on indicator for details"] = "Coloca el cursor sobre el indicador para más detalles"
La["Ignore"] = "Ignorar"
La["Indicators"] = "Indicadores"
--Translation missing 
La["Instance limit in Broker"] = "Instance limit in Broker"
La["Instances"] = "Instancias"
La["Interleave"] = "Entrelazado"
--Translation missing 
La["L Kara"] = "L Kara"
La["Last updated"] = "Última Actualización"
--Translation missing 
La["Last Week Reward Usable"] = "Last Week Reward Usable"
La["Legion Transmute"] = "Transmutación de Legión"
La["Level %d Characters"] = "Leveleá %d Personajes"
La["LFG cooldown"] = "Seguir el cooldown de LFG"
La["LFR"] = "BdB"
La["List categories from the current expansion pack first"] = "Mostrar primero las categorías de la expansión actual"
La["List raid categories before dungeon categories"] = "Mostrar categorías de bandas antes que categorías de mazmorras"
La["Lockouts"] = "Bloqueos"
La["Manage"] = "gestionar"
La["Miscellaneous Tracking"] = "Seguimiento Misceláneo"
--Translation missing 
La["MoS"] = "MoS"
La["Most recent first"] = "Más reciente primero"
La["Move down"] = "Bajar"
La["Move up"] = "Subir"
--Translation missing 
La["Mythic Best"] = "Mythic Best"
--Translation missing 
La["Mythic Key Best"] = "Mythic Key Best"
--Translation missing 
La["Mythic Keystone"] = "Mythic Keystone"
--Translation missing 
La["Nelt"] = "Nelt"
La["Never show"] = "Nunca mostrar"
La["Opacity of the tooltip row highlighting"] = "Opacidad de la resalta de filas en la descripción"
La["Open config"] = "Abrir los opciones"
--Translation missing 
La["Order must be a number in [0 - 999]"] = "Order must be a number in [0 - 999]"
La["Plant"] = "Plantar"
La["Raids before dungeons"] = "Bandas antes que mazmorras"
La["Recent Bonus Rolls"] = "Tiradas Extra Recientes"
La["Recent Instances"] = "Instancias recientes"
La["Recover Dailies"] = "Recuperar diarias"
La["Remind about weekly charm quest"] = "Recordar misión semanal de talismanes"
La["Reminder: You need to do quest %s"] = "Recordatorio: Debes hacer la misión %s"
La["Report instance resets to group"] = "Informar de reinicializaciones de instancias al grupo"
La["Reset Characters"] = "Reinicializar personajes"
La["Reverse ordering"] = "Invertir orden"
La["Roll Bonus"] = "Bonos de tirada"
La["Row Highlight"] = "Resalta de fila"
La["Seed"] = "semilla"
La["Seeds"] = "semillas"
La["Set All"] = "Ajustar todos"
La["Show category names"] = "Mostrar nombres de categorías"
La["Show category names in the tooltip"] = "Mostrar los nombres de categorías en la descripción"
La["Show cooldown for characters to use battleground system"] = "Muestra el cooldown de personajes para entrar en un campo de batalla."
La["Show cooldown for characters to use LFG dungeon system"] = "Muestra el cooldown de personajes para utilizar el sistema BdG."
--Translation missing 
La["Show currency earned"] = "Show currency earned"
--Translation missing 
La["Show currency max"] = "Show currency max"
La["Show Expired"] = "Muestra expirados"
La["Show expired instance lockouts"] = "Registros expirados de instanias"
La["Show Holiday"] = "Mostrar fiestas"
La["Show holiday boss rewards"] = "Mostrar las recompensas de los jefes festivos"
La["Show minimap button"] = "Mostrar botón del minimapa"
La["Show name for a category when all displayed instances belong only to that category"] = "Muestra el nombre de la categoría cuando todas las instancias que se muestran son de la misma categoría"
La["Show only current server"] = "Mostrar sólo el reino actual"
La["Show Random"] = "Mostrar aleatoria"
La["Show random dungeon bonus reward"] = "Mostrar recompensa de mazmorra aleatoria"
La["Show self always"] = "Siempre mostrar sí mismo"
La["Show self first"] = "Mostrar sí mismo primero"
--Translation missing 
La["Show server name"] = "Show server name"
La["Show the SavedInstances minimap button"] = "Mostrar el botón del minimapa de SavedInstances"
La["Show tooltip hints"] = "Mostrar consejos en descripciones"
La["Show When"] = "Mostrar cuando"
La["Show when not saved"] = "Mostrar cuando no ha sido guardado"
La["Show when saved"] = "Mostrar cuando guardado"
La["Show/Hide the SavedInstances tooltip"] = "Mostrar/ocultar la descripción"
La["Similarly, the words KILLED and TOTAL will be substituted with the number of bosses killed and total in the lockout."] = "Las palabras \"KILLED\" y \"TOTAL\" se reemplazará por el número de jefes derrotados, y el número total de jefes de la instancia, respectivamente."
La["Single category name"] = "Nombre de la categoría individual"
La["Sort by server"] = "Ordenar por reino"
La["Sort categories by"] = "Ordenar categorías por"
La["Sort Order"] = "Establecer Orden"
--Translation missing 
La["Sorting"] = "Sorting"
--Translation missing 
La["SotT"] = "SotT"
La["Space between categories"] = "Espacio entre categorías"
La["Text"] = "Texto"
La["The Four Celestials"] = "Los Cuatro Celestiales"
La["These are the instances that count towards the %i instances per hour account limit, and the time until they expire."] = "Estas instancias cuentan para el límite de %i por hora por cuenta, y expirará a la hora indicada."
La["This should only be used for characters who have been renamed or deleted, as characters will be re-populated when you log into them."] = "Esto sólo debe ser usado para personajes que han sido renombrados o borrados, ya que los personajes serán cargados de nuevo cuando te conectes con ellos."
La["Throw"] = "Lanzar"
La["Time /played"] = "Tiempo /jugado"
La["Time Left"] = "Tiempo Restante"
La["Tooltip Scale"] = "Tamaño de Marco"
La["Track"] = "Sigue"
--Translation missing 
La["Track Mythic keystone acquisition"] = "Track Mythic keystone acquisition"
--Translation missing 
La["Track Mythic keystone best run"] = "Track Mythic keystone best run"
La["Trade Skill Cooldowns"] = "Cooldowns de profesiones"
La["Trade skills"] = "Seguir cooldowns de profesiones"
La["Transmute"] = "Transmutar"
La["Type"] = "Tipo"
--Translation missing 
La["U Kara"] = "U Kara"
La["Use class color"] = "Usar color de clase"
--Translation missing 
La["VotW"] = "VotW"
--Translation missing 
La["Warn about instance limit"] = "Warn about instance limit"
La["Warning: You've entered about %i instances recently and are approaching the %i instance per hour limit for your account. More instances should be available in %s."] = "Advertencia: Has entrado en %i instancias recientemente, y estás acercando al límite de %i instancias por hora para tu cuenta. Más instancias estarán disponibles después de %s."
La["Weekly Quests"] = "Misiones semanales"
La["Wild Transmute"] = "Transmutación Salvaje"
La["World Boss"] = "Jefe del mundo"
La["World Bosses"] = "Jefes de Mundo"
La["You can combine icons and text in a single indicator if you wish. Simply choose an icon, and insert the word ICON into the text field. Anywhere the word ICON is found, the icon you chose will be substituted in."] = "Puedes unirse a los iconos y texto en un solo indicador. Seleccione un icono y escribe \"ICON\" en el cuadro de texto para indicar dónde deseas que aparezca el icono."

elseif locale == "ruRU" then
La["|cffffff00Left-click|r to detach tooltip"] = "|cffffff00Left-click|r Информация в отдельном окне"
La["|cffffff00Middle-click|r to show Blizzard's Raid Information"] = "Средняя кнопка мыши, чтобы показать информацию о рейдах от Blizzard"
La["|cffffff00Right-click|r to configure SavedInstances"] = "|cffffff00Right-click|r Настройки SavedInstances"
La["Abbreviate keystones"] = "Сокращения названия ключей"
La["Abbreviate Mythic keystone dungeon names"] = "Сократить названия эпохальных подземелий"
La["Account"] = "Аккаунт"
La["Account Summary"] = "Общая сводка по аккаунту"
La["Alternating columns are colored differently"] = "Разный цвет колонок поочередно"
La["Always show"] = "Всегда отображать"
La["Always show new instances"] = "Всегда показывать новые подземелья"
La["Arc"] = "Дуга"
La["Are you sure you want to remove %s from the SavedInstances character database?"] = "Вы уверены, что хотите удалить %s из базы данных персонажей SavedInstances?"
La["Are you sure you want to reset the SavedInstances character database? Characters will be re-populated as you log into them."] = "Вы уверены, что хотите сбросить базу данных персонажей SavedInstances? Персонажи будут вновь запомнены, как только вы зайдёте ими в игру."
La["Attempt to recover completed daily quests for this character. Note this may recover some additional, linked daily quests that were not actually completed today."] = "Попытка восстановить завершённые ежедневные задания для этого персонажа. Обратите внимание, что это может восстановить некоторые дополнительные, связанные ежедневные задания, которые не были фактически сегодня завершены."
La["Augment bonus loot frame"] = "Улучшение панели бонусного броска"
La["Automatically shrink the tooltip to fit on the screen"] = "Автоматически уменьшать размер подсказки, чтобы вместить на экран"
La["Battleground Deserter"] = "Дезертир с Поля Боя"
La["Bind a key to toggle the SavedInstances tooltip"] = "Клавиша для вкл./выкл. подсказок SavedInstances"
La["Bonus loot frame"] = "Окно дополнительной добычи"
La["Bonus rolls"] = "Отслеживать бонусные броски"
La[ [=[Boss kill information is missing for this lockout.
This is a Blizzard bug affecting certain old raids.]=] ] = [=[Отсутствует информация об убийстве босса для этого сохранения рейда.
Это является ошибкой компании Blizzard, затрагивающей некоторые старые рейды.]=]
La["Boss kill information is missing for this lockout.\\nThis is a Blizzard bug affecting certain old raids."] = "Отсутствует информация об убийстве босса для этого сохранения рейда.\\n Это является ошибкой компании Blizzard, затрагивающей некоторые старые рейды."
La["BRH"] = "КЧЛ"
La["Categories"] = "Категории"
La["Character column style"] = "Стиль колонок персонажа"
La["Characters"] = "Персонажи"
La["CoEN"] = "СВН"
La["Color currency by cap"] = "Расцвечивать валюту в зависимости от достижения максимума"
La["Columns are colored according to the characters class"] = "Цвет колонок в соответствии с классом персонажа"
La["Columns are the same color as the whole tooltip"] = "Колонки имеют такой же цвет, как и подсказки"
La["Combine LFR"] = "Объединять СПР (LFR)"
La["Combine World Bosses"] = "Объединять мировых босcов"
La["Connected Realms"] = "Соединенные сервера"
La["CoS"] = "КЗ"
La["Crops growing"] = "Растущие растения"
La["Crops harvested today"] = "Собранные сегодня растения"
La["Crops planted today"] = "Посаженные сегодня растения"
La["Crops ready"] = "Готовые к сбору растения"
La["Currency settings"] = "Настройки валюты"
La["Daily Quests"] = "Ежедневные задания"
La["Day"] = "День"
La["Debug Mode"] = "Режим отладки"
La["DHT"] = "ЧТС"
La["Disable mouseover"] = "Откл. отобр. по наведению"
La["Disable tooltip display on icon mouseover"] = "Отключить отображение подсказки по наведению на иконку"
La["Display instances in order of recommended level from lowest to highest"] = "Отображать подземелья в порядке рекомендуемого уровня от самого низкого до самого высокого"
La["Display instances with space inserted between categories"] = "Показывать подземелья с промежутком между категориями"
La["Dump quest debugging information"] = "Сохранить отладочную информацию квеста в файле"
La["Dump time debugging information"] = "Вывести информацию о времени для отладки"
La["Emissary Missing"] = "Посланники отсутствуют"
La["Emissary Quests"] = "Задания Посланников"
La["Emissary quests"] = "Задания Посланников"
La["EoA"] = "ОА"
La["Expansion"] = "Сохранение подземелий"
La["Expired Lockout - Can be extended"] = "Сохранение с истекшим сроком - Можно продлить"
La["Extended Lockout - Not yet saved"] = "Продление сохранения - Ещё не сохранено"
La["Facets of Research"] = "Грань исследования (ювелирное дело)"
La["Farm crops"] = "Отображать посадки на ферме"
La["Farm Crops"] = "Растения на ферме"
La["Fit to screen"] = "Подогнать под размер экрана"
La["Flex"] = "Гибкий"
La["Format large numbers"] = "Формат больших чисел"
La["General settings"] = "Общие настройки"
La["Group"] = "Группировать"
La["Hold Alt to show all data"] = "Нажмите Alt для просмотра всей информации"
La["HoV"] = "ЧД"
La["Hover mouse on indicator for details"] = "Наведите мышкой на индикатор для детальной информации"
La["Ignore"] = "Игнорировать"
La["Indicators"] = "Индикатор"
--Translation missing 
La["Instance limit in Broker"] = "Instance limit in Broker"
La["Instances"] = "Подземелья"
La["Interleave"] = "Смешивать в пределах соединенного сервера"
--Translation missing 
La["L Kara"] = "L Kara"
La["Last updated"] = "Последнее обновление"
--Translation missing 
La["Last Week Reward Usable"] = "Last Week Reward Usable"
La["Legion Transmute"] = "Трансмутация Легиона"
La["Level %d Characters"] = "Персонажи уровня %d"
La["LFG cooldown"] = "Отслеживать время задержки Поиска группы для подземелий"
La["LFR"] = "СПР (LFR)"
La["List categories from the current expansion pack first"] = "Сортировать список категорий по сохраненным подземельям"
La["List raid categories before dungeon categories"] = "Список категорий рейда до категорий подземелий"
La["Lockouts"] = "Сохранения"
La["Manage"] = "Управление"
La["Miscellaneous Tracking"] = "Разнообразное отслеживание"
--Translation missing 
La["MoS"] = "MoS"
La["Most recent first"] = "Сначала новые"
La["Move down"] = "Переместить вниз"
La["Move up"] = "Переместить вверх"
--Translation missing 
La["Mythic Best"] = "Mythic Best"
--Translation missing 
La["Mythic Key Best"] = "Mythic Key Best"
--Translation missing 
La["Mythic Keystone"] = "Mythic Keystone"
--Translation missing 
La["Nelt"] = "Nelt"
La["Never show"] = "Никогда не отображать"
La["Opacity of the tooltip row highlighting"] = "Прозрачность подсказки подсвеченной строки"
La["Open config"] = "Открыть настройки"
--Translation missing 
La["Order must be a number in [0 - 999]"] = "Order must be a number in [0 - 999]"
La["Plant"] = "Посадить"
La["Raids before dungeons"] = "Рейды перед подземельями "
La["Recent Bonus Rolls"] = "Недавние бонусные броски"
La["Recent Instances"] = "Недавние подземелья "
La["Recover Dailies"] = "Восстановление Ежедневных Заданий"
La["Remind about weekly charm quest"] = "Напоминать об еженедельном получении амулетов"
La["Reminder: You need to do quest %s"] = "Напоминание: необходимо выполнить задание %s"
La["Report instance resets to group"] = "Сообщать группе об обновлении подземелья"
La["Reset Characters"] = "Сброс Персонажей"
La["Reverse ordering"] = "Обратный порядок"
La["Roll Bonus"] = "Бонусный бросок"
La["Row Highlight"] = "Подсветка строки"
La["Seed"] = "Семена"
La["Seeds"] = "Семена"
La["Set All"] = "Установить значение для всех"
La["Show category names"] = "Показывать названия категорий"
La["Show category names in the tooltip"] = "Отображать названия категорий в подсказках"
La["Show cooldown for characters to use battleground system"] = "Показывать время задержки системы Полей битв"
La["Show cooldown for characters to use LFG dungeon system"] = "Показывать время задержки системы Поиска группы для подземелий"
--Translation missing 
La["Show currency earned"] = "Show currency earned"
--Translation missing 
La["Show currency max"] = "Show currency max"
La["Show Expired"] = "Показывать истекшие"
La["Show expired instance lockouts"] = "Показывать истекшие сохранённые подземелья"
La["Show Holiday"] = "Показывать События"
La["Show holiday boss rewards"] = "Показывать награду с праздничных боссов"
La["Show minimap button"] = "Кнопка у миникарты"
La["Show name for a category when all displayed instances belong only to that category"] = "Показать имя для категории для всех отображаемых подземелий, принадлежащих только этой категории"
La["Show only current server"] = "Показывать только текущий серврер"
La["Show Random"] = "Показывать Случайный Выбор"
La["Show random dungeon bonus reward"] = "Показывать бонусную награду за случайное подземелье"
La["Show self always"] = "Показывать себя всегда"
La["Show self first"] = "Вначале показывать себя"
--Translation missing 
La["Show server name"] = "Show server name"
La["Show the SavedInstances minimap button"] = "Отображать кнопку SavedInstances у миникарты"
La["Show tooltip hints"] = "Показывать подсказки"
La["Show When"] = "Показывать если"
La["Show when not saved"] = "Показывать, когда не сохранено"
La["Show when saved"] = "Отображать при сохранении"
La["Show/Hide the SavedInstances tooltip"] = "Показать/Спрятать подсказку SavedInstances"
La["Similarly, the words KILLED and TOTAL will be substituted with the number of bosses killed and total in the lockout."] = "Аналогично, слова KILLED и TOTAL будут заменены числом убитых и всего боссов в сохранении."
La["Single category name"] = "Одиночное название категории"
La["Sort by server"] = "Сорт. по серверам"
La["Sort categories by"] = "Сорт. категории по"
La["Sort Order"] = "Порядок сортировки"
--Translation missing 
La["Sorting"] = "Sorting"
--Translation missing 
La["SotT"] = "SotT"
La["Space between categories"] = "Промежуток между категориями"
La["Text"] = "Текст"
La["The Four Celestials"] = "Четыре небожителя"
La["These are the instances that count towards the %i instances per hour account limit, and the time until they expire."] = "Это те подземелья, на которые существуют ограничения в %i подземелий в час."
La["This should only be used for characters who have been renamed or deleted, as characters will be re-populated when you log into them."] = "Используйте только для переименованных или удаленных персонажей, так как данные все равно будут заполнены заново при входе на персонажа."
La["Throw"] = "Выкинуть"
La["Time /played"] = "Общее время игры"
La["Time Left"] = "Обновится через"
La["Tooltip Scale"] = "Масштаб подсказки"
La["Track"] = "Отслеживать"
--Translation missing 
La["Track Mythic keystone acquisition"] = "Track Mythic keystone acquisition"
--Translation missing 
La["Track Mythic keystone best run"] = "Track Mythic keystone best run"
La["Trade Skill Cooldowns"] = "Восстановление способностей профессий."
La["Trade skills"] = "Отслеживать восстановление способностей профессий"
La["Transmute"] = "Трансмутация (алхимия)"
La["Type"] = "Тип"
--Translation missing 
La["U Kara"] = "U Kara"
La["Use class color"] = "Цвет класса"
--Translation missing 
La["VotW"] = "VotW"
--Translation missing 
La["Warn about instance limit"] = "Warn about instance limit"
La["Warning: You've entered about %i instances recently and are approaching the %i instance per hour limit for your account. More instances should be available in %s."] = "Внимание! За последнее время вы вошли в %i подземелий и приближаетесь к ограничению в \"%i подземелий в час\" для вашего аккаунта. Новые подземелья будут доступны через %s."
La["Weekly Quests"] = "Еженедельные задания"
La["Wild Transmute"] = "Дикая трансмутация"
La["World Boss"] = "Мировые Боссы"
La["World Bosses"] = "Мировые боcсы"
La["You can combine icons and text in a single indicator if you wish. Simply choose an icon, and insert the word ICON into the text field. Anywhere the word ICON is found, the icon you chose will be substituted in."] = "Если хотите, то вы можете комбинировать иконки и текст в одном индикаторе. Просто выберите иконку и вставьте слово ICON в текстовое поле. Везде где слово ICON будет найдено, вместо него будет ваш выбранный значок."

elseif locale == "zhCN" then
La["|cffffff00Left-click|r to detach tooltip"] = "|cffffff00左键点击|r 显示独立窗口"
La["|cffffff00Middle-click|r to show Blizzard's Raid Information"] = "|cffffff00中键点击|r 显示暴雪的团队信息"
La["|cffffff00Right-click|r to configure SavedInstances"] = "|cffffff00右键点击|r 设置 SavedInstances"
La["Abbreviate keystones"] = "史诗钥石简称"
La["Abbreviate Mythic keystone dungeon names"] = "简称史诗钥石地下城"
La["Account"] = "账号"
La["Account Summary"] = "账号总览"
La["Alternating columns are colored differently"] = "交替着色"
La["Always show"] = "总是显示"
La["Always show new instances"] = "总是显示新副本"
La["Arc"] = "回廊"
La["Are you sure you want to remove %s from the SavedInstances character database?"] = "你确实想要从人物数据库中移除 %s 吗？"
La["Are you sure you want to reset the SavedInstances character database? Characters will be re-populated as you log into them."] = "你确定要重置SavedInstances的角色数据库吗？再次登入被删除的角色以重新添加。"
La["Attempt to recover completed daily quests for this character. Note this may recover some additional, linked daily quests that were not actually completed today."] = "尝试提取当前角色已完成的日常任务。注意，这可能会提取到实际上并没有完成的日常任务。"
La["Augment bonus loot frame"] = "额外拾取界面添加代币使用信息"
La["Automatically shrink the tooltip to fit on the screen"] = "根据屏幕大小自动缩放界面"
La["Battleground Deserter"] = "追踪战场逃亡者冷却"
La["Bind a key to toggle the SavedInstances tooltip"] = "绑定一个按键来显示/隐藏SavedInstances界面"
La["Bonus loot frame"] = "额外拾取界面"
La["Bonus rolls"] = "追踪额外拾取代币使用情况"
La[ [=[Boss kill information is missing for this lockout.
This is a Blizzard bug affecting certain old raids.]=] ] = [=[首领击杀信息遗失
这是一个会影响特定旧副本的暴雪Bug]=]
La["Boss kill information is missing for this lockout.\\nThis is a Blizzard bug affecting certain old raids."] = "首领击杀信息遗失\\n这是一个会影响特定旧副本的暴雪Bug"
La["BRH"] = "黑鸦"
La["Categories"] = "分类"
La["Character column style"] = "角色列样式"
La["Characters"] = "角色"
La["CoEN"] = "大教堂"
La["Color currency by cap"] = "货币根据上限显示颜色"
La["Columns are colored according to the characters class"] = "使用职业颜色"
La["Columns are the same color as the whole tooltip"] = "使用相同颜色"
La["Combine LFR"] = "合并随机/弹性"
La["Combine World Bosses"] = "合并世界首领"
La["Connected Realms"] = "已合并服务器"
La["CoS"] = "群星"
La["Crops growing"] = "作物成长中"
La["Crops harvested today"] = "今天已收获作物"
La["Crops planted today"] = "今天已栽种作物"
La["Crops ready"] = "作物就绪"
La["Currency settings"] = "货币设置"
La["Daily Quests"] = "日常任务"
La["Day"] = "天"
La["Debug Mode"] = "调试模式"
La["DHT"] = "黑心"
La["Disable mouseover"] = "禁用鼠标提示"
La["Disable tooltip display on icon mouseover"] = "禁止当鼠标移动到插件图标上时显示提示信息"
La["Display instances in order of recommended level from lowest to highest"] = "依照建议的等级从低到高显示副本"
La["Display instances with space inserted between categories"] = "在分类之间显示间距"
La["Dump quest debugging information"] = "转存任务调试信息"
La["Dump time debugging information"] = "转存时间调试信息"
La["Emissary Missing"] = "大使任务缺失"
La["Emissary Quests"] = "大使任务"
La["Emissary quests"] = "大使任务"
La["EoA"] = "艾萨拉"
La["Expansion"] = "资料片"
La["Expired Lockout - Can be extended"] = "到期锁定 - 可以延长"
La["Extended Lockout - Not yet saved"] = "已延长锁定 - 还未被储存"
La["Facets of Research"] = "探索棱镜"
La["Farm crops"] = "追踪农场作物"
La["Farm Crops"] = "农场作物"
La["Fit to screen"] = "适应屏幕大小"
La["Flex"] = "弹性"
La["Format large numbers"] = "格式化大数字"
La["General settings"] = "综合"
La["Group"] = "组合"
La["Hold Alt to show all data"] = "按住Alt来显示所有信息"
La["HoV"] = "英灵殿"
La["Hover mouse on indicator for details"] = "鼠标悬停以显示细节"
La["Ignore"] = "忽略"
La["Indicators"] = "团队信息"
La["Instance limit in Broker"] = "在信息文字中显示副本进入限制"
La["Instances"] = "副本"
La["Interleave"] = "交错"
La["L Kara"] = "卡拉赞下"
La["Last updated"] = "最后更新"
La["Last Week Reward Usable"] = "伟大挑战者的宝藏"
La["Legion Transmute"] = "军团转化"
La["Level %d Characters"] = "等级 %d 人物"
La["LFG cooldown"] = "追踪随机地下城冷却"
La["LFR"] = "团队搜寻器"
La["List categories from the current expansion pack first"] = "从目前的资料片开始列出分类"
La["List raid categories before dungeon categories"] = "将团队副本置于地下城之前"
La["Lockouts"] = "副本锁定"
La["Manage"] = "管理"
La["Miscellaneous Tracking"] = "杂项"
La["MoS"] = "噬魂"
La["Most recent first"] = "目前的资料片优先"
La["Move down"] = "下移"
La["Move up"] = "上移"
La["Mythic Best"] = "史诗钥石每周最佳记录"
La["Mythic Key Best"] = "每周最佳纪录"
La["Mythic Keystone"] = "史诗钥石"
La["Nelt"] = "巢穴"
La["Never show"] = "从不显示"
La["Opacity of the tooltip row highlighting"] = "高亮提示行的透明度"
La["Open config"] = "开启设置"
La["Order must be a number in [0 - 999]"] = "必须为0-999的数字"
La["Plant"] = "栽种"
La["Raids before dungeons"] = "团队副本位于地下城之前"
La["Recent Bonus Rolls"] = "近期额外拾取代币使用情况"
La["Recent Instances"] = "近期副本情况"
La["Recover Dailies"] = "提取日常"
La["Remind about weekly charm quest"] = "对每周好运符任务状态的提醒"
La["Reminder: You need to do quest %s"] = "提醒: 你还没有完成任务 %s"
La["Report instance resets to group"] = "报告副本重置到团队"
La["Reset Characters"] = "重置角色"
La["Reverse ordering"] = "反转排序"
La["Roll Bonus"] = "额外拾取代币使用情况"
La["Row Highlight"] = "高亮行透明度"
La["Seed"] = "种子"
La["Seeds"] = "种子"
La["Set All"] = "设置所有"
La["Show category names"] = "显示分类名字"
La["Show category names in the tooltip"] = "在界面中显示分类名字"
La["Show cooldown for characters to use battleground system"] = "显示角色随机战场的冷却"
La["Show cooldown for characters to use LFG dungeon system"] = "显示角色随机地下城的冷却"
La["Show currency earned"] = "显示货币拥有数量"
La["Show currency max"] = "显示货币拥有上限"
La["Show Expired"] = "显示已过期的副本"
La["Show expired instance lockouts"] = "显示已过期的副本锁定"
La["Show Holiday"] = "显示节日副本"
La["Show holiday boss rewards"] = "显示节日副本奖励"
La["Show minimap button"] = "显示小地图按钮"
La["Show name for a category when all displayed instances belong only to that category"] = "总是显示所有已显示副本的分类名字"
La["Show only current server"] = "仅显示当前服务器"
La["Show Random"] = "显示随机地下城"
La["Show random dungeon bonus reward"] = "显示随机地下城额外奖励"
La["Show self always"] = "总是显示自己"
La["Show self first"] = "优先显示自己"
La["Show server name"] = "显示服务器名称"
La["Show the SavedInstances minimap button"] = "显示SavedInstances小地图按钮"
La["Show tooltip hints"] = "显示界面提示信息"
La["Show When"] = "显示"
La["Show when not saved"] = "当无进度时显示"
La["Show when saved"] = "保存后显示"
La["Show/Hide the SavedInstances tooltip"] = "显示/隐藏 团队进度提示"
La["Similarly, the words KILLED and TOTAL will be substituted with the number of bosses killed and total in the lockout."] = "同理，“KILLED”和“TOTAL”将被替换为首领的击杀数量和总数。"
La["Single category name"] = "总是显示分类名字"
La["Sort by server"] = "按服务器排序"
La["Sort categories by"] = "排序分类按"
La["Sort Order"] = "排序"
La["Sorting"] = "排序"
La["SotT"] = "执政团"
La["Space between categories"] = "显示分类间的间距"
La["Text"] = "文本"
La["The Four Celestials"] = "四大天神"
La["These are the instances that count towards the %i instances per hour account limit, and the time until they expire."] = "这些是角色每个小时进入 %i 次副本限制的计算，以及可再次进入的等待时间。"
La["This should only be used for characters who have been renamed or deleted, as characters will be re-populated when you log into them."] = "此项仅可在人物重命名或者删除后使用，当你重新登入时原人物会被转移到新人物"
La["Throw"] = "丢弃"
La["Time /played"] = "已游戏时间"
La["Time Left"] = "剩余时间"
La["Tooltip Scale"] = "提示框缩放"
La["Track"] = "追踪"
La["Track Mythic keystone acquisition"] = "追踪史诗钥石"
La["Track Mythic keystone best run"] = "追踪史诗钥石每周最佳记录"
La["Trade Skill Cooldowns"] = "商业技能冷却"
La["Trade skills"] = "商业技能"
La["Transmute"] = "转化"
La["Type"] = "类型"
La["U Kara"] = "卡拉赞上"
La["Use class color"] = "使用职业颜色"
La["VotW"] = "地窟"
La["Warn about instance limit"] = "副本进入限制警告"
La["Warning: You've entered about %i instances recently and are approaching the %i instance per hour limit for your account. More instances should be available in %s."] = "警告：你最近已经进入 %i 次副本，并且已经接近账号每小时 %i 次的进入限制，更多的副本可以在 %s 后允许进入。"
La["Weekly Quests"] = "周常任务"
La["Wild Transmute"] = "狂野转化"
La["World Boss"] = "世界首领"
La["World Bosses"] = "世界首领"
La["You can combine icons and text in a single indicator if you wish. Simply choose an icon, and insert the word ICON into the text field. Anywhere the word ICON is found, the icon you chose will be substituted in."] = "你可以在同一个团队信息上显示图标和文字。先选择一个图标，然后在文本中插入“ICON”到想要图标出现的位置。展示时将被替换为指定图标。"

elseif locale == "esES" then
La["|cffffff00Left-click|r to detach tooltip"] = "|cffffff00Clic|r para separar la ventana de descripción"
La["|cffffff00Middle-click|r to show Blizzard's Raid Information"] = "|cffffff00Clic medio|r para mostrar el Info de banda"
La["|cffffff00Right-click|r to configure SavedInstances"] = "|cffffff00Click-Derecho|r para configurar SavedInstances"
--Translation missing 
La["Abbreviate keystones"] = "Abbreviate keystones"
--Translation missing 
La["Abbreviate Mythic keystone dungeon names"] = "Abbreviate Mythic keystone dungeon names"
La["Account"] = "Cuenta"
La["Account Summary"] = "Resumen de la cuenta"
La["Alternating columns are colored differently"] = "Columnas alternas de diferente color"
La["Always show"] = "Mostrar siempre"
La["Always show new instances"] = "Mostrar siempre nuevas estancias"
--Translation missing 
La["Arc"] = "Arc"
La["Are you sure you want to remove %s from the SavedInstances character database?"] = "¿Estás seguro de que quieres borrar a %s de la base de datos de personajes de SavedInstances?"
La["Are you sure you want to reset the SavedInstances character database? Characters will be re-populated as you log into them."] = "¿Seguro que quieres reiniciar la base de datos de personajes de SavedInstances? Los personajes se añadirán de nuevo cuando entres con ellos."
La["Attempt to recover completed daily quests for this character. Note this may recover some additional, linked daily quests that were not actually completed today."] = "Tratar de recuperar las misiones diarias ya completadas hoy por este personaje. Esto podría recuperar algunas otras misiones relacionadas que no fueron completadas hoy."
La["Augment bonus loot frame"] = "Incrementar marco de bonus de botín"
La["Automatically shrink the tooltip to fit on the screen"] = "Encoger automáticamente la descripción para ajustarla a la pantalla"
La["Battleground Deserter"] = "Desertor del Campo de Batalla"
La["Bind a key to toggle the SavedInstances tooltip"] = "Asignar una tecla para mostrar/ocultar la ventana de información de SavedInstances"
--Translation missing 
La["Bonus loot frame"] = "Bonus loot frame"
La["Bonus rolls"] = "Tiradas extra"
--Translation missing 
La[ [=[Boss kill information is missing for this lockout.
This is a Blizzard bug affecting certain old raids.]=] ] = [=[Boss kill information is missing for this lockout.
This is a Blizzard bug affecting certain old raids.]=]
La["Boss kill information is missing for this lockout.\\nThis is a Blizzard bug affecting certain old raids."] = "Falta información de los jefes derrotados para este registro.\\nEs un error de Blizzard que afecta a algunas bandas antiguas."
--Translation missing 
La["BRH"] = "BRH"
La["Categories"] = "Categorías"
La["Character column style"] = "Estilo de columna de personaje"
La["Characters"] = "Personajes"
--Translation missing 
La["CoEN"] = "CoEN"
La["Color currency by cap"] = "---- \"Show currency max\" is \"Mostrar máximos de monedas\""
La["Columns are colored according to the characters class"] = "Las columnas se colorean según la clase de los personajes"
La["Columns are the same color as the whole tooltip"] = "Las columnas son del mismo color que la descripción."
La["Combine LFR"] = "Combinar BdG"
La["Combine World Bosses"] = "Combinar jefes del mundo"
La["Connected Realms"] = "Reinos conectados"
--Translation missing 
La["CoS"] = "CoS"
La["Crops growing"] = "Cultivos crecientes"
La["Crops harvested today"] = "Cultivos cosechados"
La["Crops planted today"] = "Cultivos plantados"
La["Crops ready"] = "Cultivos listos"
La["Currency settings"] = "Ajustes de moneda"
La["Daily Quests"] = "Misiones diarias"
--Translation missing 
La["Day"] = "Day"
--Translation missing 
La["Debug Mode"] = "Debug Mode"
--Translation missing 
La["DHT"] = "DHT"
La["Disable mouseover"] = "Deshabilitar tooltip"
La["Disable tooltip display on icon mouseover"] = "Deshabilita el tooltip al pasar el ratón por encima del icono"
La["Display instances in order of recommended level from lowest to highest"] = "Mostrar instancias en orden de nivel recomendado de menor a mayor"
La["Display instances with space inserted between categories"] = "Mostrar instancias con espacio entre categorías"
La["Dump quest debugging information"] = "Volcar información de depuración de misión"
La["Dump time debugging information"] = "Volcar información de depuración de tiempo"
--Translation missing 
La["Emissary Missing"] = "Emissary Missing"
--Translation missing 
La["Emissary Quests"] = "Emissary Quests"
--Translation missing 
La["Emissary quests"] = "Emissary quests"
--Translation missing 
La["EoA"] = "EoA"
La["Expansion"] = "Expansión"
La["Expired Lockout - Can be extended"] = "Registro expirado - puede extenderse"
La["Extended Lockout - Not yet saved"] = "Registro extendido - no se ha guardado"
La["Facets of Research"] = "Facetas de investigación"
La["Farm crops"] = "Seguir cultivos de granjas"
La["Farm Crops"] = "Cultivos agrícolas"
La["Fit to screen"] = "Ajustar a pantalla"
La["Flex"] = "Flexible"
La["Format large numbers"] = "Dar formato a números grandes (separar con puntos los millares)"
La["General settings"] = "Opciones generales"
La["Group"] = "Grupo"
La["Hold Alt to show all data"] = "Pulsa Alt para mostrar toda la información"
--Translation missing 
La["HoV"] = "HoV"
La["Hover mouse on indicator for details"] = "Coloca el cursor sobre el indicador para más detalles"
La["Ignore"] = "Ignorar"
La["Indicators"] = "Indicadores"
--Translation missing 
La["Instance limit in Broker"] = "Instance limit in Broker"
La["Instances"] = "Estancias"
La["Interleave"] = "Entrelazado"
--Translation missing 
La["L Kara"] = "L Kara"
La["Last updated"] = "Última actualización"
--Translation missing 
La["Last Week Reward Usable"] = "Last Week Reward Usable"
La["Legion Transmute"] = "Transmutación de Legión"
La["Level %d Characters"] = "Personajes de nivel %d"
La["LFG cooldown"] = "Tiempo de reutilización del Buscador de Grupo."
La["LFR"] = "BdB"
La["List categories from the current expansion pack first"] = "Mostrar primero las categorías de la expansión actual"
La["List raid categories before dungeon categories"] = "Mostrar categorías de bandas antes que de mazmorras"
La["Lockouts"] = "Bloqueos"
La["Manage"] = "Gestionar"
La["Miscellaneous Tracking"] = "Seguimiento misceláneo"
--Translation missing 
La["MoS"] = "MoS"
La["Most recent first"] = "Más reciente primero"
La["Move down"] = "Bajar"
La["Move up"] = "Subir"
--Translation missing 
La["Mythic Best"] = "Mythic Best"
--Translation missing 
La["Mythic Key Best"] = "Mythic Key Best"
--Translation missing 
La["Mythic Keystone"] = "Mythic Keystone"
--Translation missing 
La["Nelt"] = "Nelt"
La["Never show"] = "No mostrar nunca"
La["Opacity of the tooltip row highlighting"] = "Opacidad de los resaltados en las filas de la ventana de información"
La["Open config"] = "Abrir la configuración"
--Translation missing 
La["Order must be a number in [0 - 999]"] = "Order must be a number in [0 - 999]"
La["Plant"] = "Plantar"
La["Raids before dungeons"] = "Bandas antes que mazmorras"
La["Recent Bonus Rolls"] = "Tiradas extra recientes"
La["Recent Instances"] = "Instancias recientes"
La["Recover Dailies"] = "Recuperar diarias"
La["Remind about weekly charm quest"] = "Recordar misión semanal de talismanes"
La["Reminder: You need to do quest %s"] = "Recordatorio: Necesitas hacer la misión %s"
La["Report instance resets to group"] = "Informar de reinicios de estancia al grupo"
La["Reset Characters"] = "Reiniciar personajes"
La["Reverse ordering"] = "Invertir orden"
La["Roll Bonus"] = "Bonos de tirada"
La["Row Highlight"] = "Resalta de fila"
La["Seed"] = "semilla"
La["Seeds"] = "semillas"
La["Set All"] = "Establecer todos"
La["Show category names"] = "Mostrar nombres de categorías"
La["Show category names in the tooltip"] = "Mostrar los nombres de categorías en la descripción"
La["Show cooldown for characters to use battleground system"] = "Muestra el tiempo de reutilización de personajes para entrar en un campo de batalla."
La["Show cooldown for characters to use LFG dungeon system"] = "Muestra el tiempo de reutilización de personajes para utilizar el sistema BdG."
--Translation missing 
La["Show currency earned"] = "Show currency earned"
--Translation missing 
La["Show currency max"] = "Show currency max"
La["Show Expired"] = "Mostrar acabados"
La["Show expired instance lockouts"] = "Mostrar registros acabados de estancias"
La["Show Holiday"] = "Mostrar fiestas"
La["Show holiday boss rewards"] = "Mostrar recompensas de los Jefes festivos"
La["Show minimap button"] = "Mostrar botón del minimapa"
La["Show name for a category when all displayed instances belong only to that category"] = "Muestra el nombre de la categoría cuando todas las instancias que se muestran son de la misma categoría"
La["Show only current server"] = "Mostrar sólo el reino actual"
La["Show Random"] = "Muestra aleatoria"
La["Show random dungeon bonus reward"] = "Mostrar recompensa extra de mazmorra aleatoria"
La["Show self always"] = "Mostrar siempre a si mismo"
La["Show self first"] = "Mostrarse a uno mismo primero"
--Translation missing 
La["Show server name"] = "Show server name"
La["Show the SavedInstances minimap button"] = "Mostrar el botón del minimapa de SavedInstances"
La["Show tooltip hints"] = "Mostrar consejos en descripciones"
La["Show When"] = "Mostrar cuando"
La["Show when not saved"] = "Mostrar si no hay registro guardado"
La["Show when saved"] = "Mostrar si hay registro guardado"
La["Show/Hide the SavedInstances tooltip"] = "Mostrar/ocultar la ventana de información de SavedInstances"
La["Similarly, the words KILLED and TOTAL will be substituted with the number of bosses killed and total in the lockout."] = "Las palabras \"KILLED\" y \"TOTAL\" se reemplazarán por el número de jefes derrotados y el total del registro."
La["Single category name"] = "Nombre de la categoría individual"
La["Sort by server"] = "Ordenar por reino"
La["Sort categories by"] = "Ordenar categorías por"
La["Sort Order"] = "Establecer orden"
--Translation missing 
La["Sorting"] = "Sorting"
--Translation missing 
La["SotT"] = "SotT"
La["Space between categories"] = "Espacio entre categorías"
La["Text"] = "Texto"
La["The Four Celestials"] = "Los Cuatro Celestiales"
La["These are the instances that count towards the %i instances per hour account limit, and the time until they expire."] = "Estas instancias cuentan para el límite de %i por hora por cuenta, y expirará a la hora indicada."
La["This should only be used for characters who have been renamed or deleted, as characters will be re-populated when you log into them."] = "Esto sólo debe ser usado para personajes que han sido renombrados o borrados, ya que los personajes serán cargados de nuevo cuando te conectes con los mismos."
La["Throw"] = "Lanzar"
La["Time /played"] = "Tiempo jugado (/played)"
La["Time Left"] = "Tiempo restante"
La["Tooltip Scale"] = "Tamaño de la ventana de información"
La["Track"] = "Sigue"
--Translation missing 
La["Track Mythic keystone acquisition"] = "Track Mythic keystone acquisition"
--Translation missing 
La["Track Mythic keystone best run"] = "Track Mythic keystone best run"
La["Trade Skill Cooldowns"] = "Tiempos de reutilización de Profesiones"
La["Trade skills"] = "Profesiones"
La["Transmute"] = "Transmutar"
La["Type"] = "Tipo"
--Translation missing 
La["U Kara"] = "U Kara"
La["Use class color"] = "Usar color de clase"
--Translation missing 
La["VotW"] = "VotW"
--Translation missing 
La["Warn about instance limit"] = "Warn about instance limit"
La["Warning: You've entered about %i instances recently and are approaching the %i instance per hour limit for your account. More instances should be available in %s."] = "Advertencia: Has entrado en %i estancias recientemente, y te estás acercando al límite de %i estancias por hora para tu cuenta. Tendrás más disponibles después de %s."
La["Weekly Quests"] = "Misiones semanales"
La["Wild Transmute"] = "Transmutación Salvaje"
La["World Boss"] = "Jefe del mundo"
La["World Bosses"] = "Jefes del mundo"
La["You can combine icons and text in a single indicator if you wish. Simply choose an icon, and insert the word ICON into the text field. Anywhere the word ICON is found, the icon you chose will be substituted in."] = "Puedes combinar iconos y texto en un mismo indicador. Selecciona un icono y escribe \"ICON\" en el cuadro de texto para indicar dónde deseas que aparezca el icono."

elseif locale == "zhTW" then
La["|cffffff00Left-click|r to detach tooltip"] = "|cffffff00左鍵點擊|r分離提示"
La["|cffffff00Middle-click|r to show Blizzard's Raid Information"] = "|cffffff00中鍵點擊|r以顯示暴雪的團隊資訊"
La["|cffffff00Right-click|r to configure SavedInstances"] = "|cffffff00右鍵點擊|r設定SavedInstances"
La["Abbreviate keystones"] = "簡寫鑰石"
La["Abbreviate Mythic keystone dungeon names"] = "簡寫傳奇鑰石地城名稱"
La["Account"] = "帳號"
La["Account Summary"] = "帳號統計"
La["Alternating columns are colored differently"] = "欄位交替不同的顏色"
La["Always show"] = "永遠顯示"
La["Always show new instances"] = "總是顯示新副本"
La["Arc"] = "地道"
La["Are you sure you want to remove %s from the SavedInstances character database?"] = "你確定想要從SavedInstances角色資料庫中移除 %s 嗎？"
La["Are you sure you want to reset the SavedInstances character database? Characters will be re-populated as you log into them."] = "你確定要重置SavedInstances的角色資料庫？角色將被重新增加如同你第一次登入。"
La["Attempt to recover completed daily quests for this character. Note this may recover some additional, linked daily quests that were not actually completed today."] = "嘗試復原當前角色已完成的每日任務。注意，這可能會復原到實際上並沒有完成的每日任務。"
La["Augment bonus loot frame"] = "增強加成骰框架"
La["Automatically shrink the tooltip to fit on the screen"] = "自動收縮在螢幕上顯示的工具提示"
La["Battleground Deserter"] = "戰場逃亡者冷卻"
La["Bind a key to toggle the SavedInstances tooltip"] = "綁定一個按鍵以切換SavedInstances提示"
La["Bonus loot frame"] = "加成拾取框架"
La["Bonus rolls"] = "加成骰"
La[ [=[Boss kill information is missing for this lockout.
This is a Blizzard bug affecting certain old raids.]=] ] = [=[首領擊殺資訊遺失。
這是一個會影響特定舊副本的暴雪bug。]=]
La["Boss kill information is missing for this lockout.\\nThis is a Blizzard bug affecting certain old raids."] = "首領擊殺資訊遺失。\\n這是一個會影響特定舊副本的暴雪Bug。"
La["BRH"] = "玄鴉"
La["Categories"] = "分類"
La["Character column style"] = "角色欄位格式"
La["Characters"] = "角色"
La["CoEN"] = "永夜"
La["Color currency by cap"] = "根據上限著色貨幣"
La["Columns are colored according to the characters class"] = "依照職業變換欄位顏色"
La["Columns are the same color as the whole tooltip"] = "欄位與整個滑鼠游標提示顯示相同顏色"
La["Combine LFR"] = "合併隨機團隊"
La["Combine World Bosses"] = "合併世界首領"
La["Connected Realms"] = "已連結伺服器"
La["CoS"] = "眾星"
La["Crops growing"] = "作物成長中"
La["Crops harvested today"] = "今天已收穫作物"
La["Crops planted today"] = "今天已栽種作物"
La["Crops ready"] = "作物準備好了"
La["Currency settings"] = "兌換通貨設定"
La["Daily Quests"] = "每日任務"
La["Day"] = "日"
La["Debug Mode"] = "偵錯模式"
La["DHT"] = "暗心"
La["Disable mouseover"] = "停用滑鼠提示"
La["Disable tooltip display on icon mouseover"] = "停用滑鼠指向圖示時顯示滑鼠提示說明"
La["Display instances in order of recommended level from lowest to highest"] = "依照建議的等級從低到高顯示副本"
La["Display instances with space inserted between categories"] = "在副本與分類間插入一個空隙"
La["Dump quest debugging information"] = "傾印任務偵錯資訊"
La["Dump time debugging information"] = "傾印計時偵錯資訊"
La["Emissary Missing"] = "缺乏特使"
La["Emissary Quests"] = "特使任務"
La["Emissary quests"] = "特使任務"
La["EoA"] = "艾眼"
La["Expansion"] = "資料片"
La["Expired Lockout - Can be extended"] = "過期鎖定 - 可以延展"
La["Extended Lockout - Not yet saved"] = "延展鎖定 - 還未儲存"
La["Facets of Research"] = "研究切面"
La["Farm crops"] = "農場作物"
La["Farm Crops"] = "農場作物"
La["Fit to screen"] = "不超出螢幕"
La["Flex"] = "彈性"
La["Format large numbers"] = "大數字格式"
La["General settings"] = "一般設定"
La["Group"] = "群組"
La["Hold Alt to show all data"] = "按住Alt來顯示所有資訊"
La["HoV"] = "英靈"
La["Hover mouse on indicator for details"] = "滑鼠停留顯示細節"
La["Ignore"] = "忽略"
La["Indicators"] = "指標"
La["Instance limit in Broker"] = "Broker的副本限制"
La["Instances"] = "副本"
La["Interleave"] = "交錯"
La["L Kara"] = "卡拉下"
La["Last updated"] = "最後更新"
La["Last Week Reward Usable"] = "上週獎勵可用"
La["Legion Transmute"] = "軍臨天下塑形"
La["Level %d Characters"] = "等級 %d 角色"
La["LFG cooldown"] = "LFG地城冷卻"
La["LFR"] = "團隊搜尋器"
La["List categories from the current expansion pack first"] = "優先從目前的資料片列出分類"
La["List raid categories before dungeon categories"] = "將團隊分類列在地城分類之前"
La["Lockouts"] = "鎖定"
La["Manage"] = "管理"
La["Miscellaneous Tracking"] = "雜項"
La["MoS"] = "靈魂"
La["Most recent first"] = "最近的優先"
La["Move down"] = "下移"
La["Move up"] = "上移"
La["Mythic Best"] = "傳奇最佳"
La["Mythic Key Best"] = "最佳傳奇鑰石"
La["Mythic Keystone"] = "傳奇鑰石"
La["Nelt"] = "奈巢"
La["Never show"] = "從不顯示"
La["Opacity of the tooltip row highlighting"] = "高亮提示行的透明度"
La["Open config"] = "開啟設定"
La["Order must be a number in [0 - 999]"] = "順序必須是[0-999]中的數字"
La["Plant"] = "栽種"
La["Raids before dungeons"] = "團隊在地城之前"
La["Recent Bonus Rolls"] = "最近的加成骰"
La["Recent Instances"] = "最近的副本"
La["Recover Dailies"] = "復原每日"
La["Remind about weekly charm quest"] = "提醒每周護符的任務"
La["Reminder: You need to do quest %s"] = "提醒:你需要做的任務 %s"
La["Report instance resets to group"] = "報告副本重置到團隊"
La["Reset Characters"] = "重置角色"
La["Reverse ordering"] = "反轉排序"
La["Roll Bonus"] = "加成骰"
La["Row Highlight"] = "高亮行"
La["Seed"] = "種子"
La["Seeds"] = "種子"
La["Set All"] = "設定全部"
La["Show category names"] = "顯示分類名稱"
La["Show category names in the tooltip"] = "在提示顯示分類名稱"
La["Show cooldown for characters to use battleground system"] = "顯示角色使用戰場系統的冷卻"
La["Show cooldown for characters to use LFG dungeon system"] = "顯示角色使用LFG地城系統的冷卻"
La["Show currency earned"] = "顯示賺取的貨幣"
La["Show currency max"] = "最大顯示貨幣"
La["Show Expired"] = "顯示過期"
La["Show expired instance lockouts"] = "顯示已過期的副本鎖定"
La["Show Holiday"] = "顯示節日"
La["Show holiday boss rewards"] = "顯示節日地城獎勵"
La["Show minimap button"] = "顯示小地圖按鈕"
La["Show name for a category when all displayed instances belong only to that category"] = "當所有顯示的副本只屬於該類別時顯示類別名稱"
La["Show only current server"] = "僅顯示目前的伺服器"
La["Show Random"] = "顯示隨機"
La["Show random dungeon bonus reward"] = "顯示隨機地城額外獎勵"
La["Show self always"] = "總是顯示自身"
La["Show self first"] = "優先顯示自己"
La["Show server name"] = "顯示伺服器名稱"
La["Show the SavedInstances minimap button"] = "顯示SavedInstances小地圖按鈕"
La["Show tooltip hints"] = "顯示工具列提示"
La["Show When"] = "何時顯示"
La["Show when not saved"] = "當無進度時顯示"
La["Show when saved"] = "當儲存時顯示"
La["Show/Hide the SavedInstances tooltip"] = "顯示/隱藏SavedInstances提示"
La["Similarly, the words KILLED and TOTAL will be substituted with the number of bosses killed and total in the lockout."] = "同樣的，「KILLED」和「TOTAL」字樣也會被替換為首領已擊殺與總數的數字。"
La["Single category name"] = "單一分類名稱"
La["Sort by server"] = "根據伺服器排序"
La["Sort categories by"] = "排序分類按"
La["Sort Order"] = "排列順序"
La["Sorting"] = "排序"
La["SotT"] = "三傑"
La["Space between categories"] = "分類的間隔"
La["Text"] = "文字"
La["The Four Celestials"] = "四大天尊"
La["These are the instances that count towards the %i instances per hour account limit, and the time until they expire."] = "這些副本被算進帳號每小時進入 %i 次副本的限制，以及重置時間。"
La["This should only be used for characters who have been renamed or deleted, as characters will be re-populated when you log into them."] = "這應該只會用在已經更名或刪除的角色，當您登入這些角色時角色將會被重新構成。"
La["Throw"] = "丟掉"
La["Time /played"] = "時間/已玩"
La["Time Left"] = "剩餘時間"
La["Tooltip Scale"] = "提示框比例"
La["Track"] = "追蹤"
La["Track Mythic keystone acquisition"] = "追蹤獲得的傳奇鑰石"
La["Track Mythic keystone best run"] = "追蹤傳奇鑰石最佳紀錄"
La["Trade Skill Cooldowns"] = "專業技能冷卻"
La["Trade skills"] = "專業技能"
La["Transmute"] = "轉化"
La["Type"] = "類型"
La["U Kara"] = "卡拉上"
La["Use class color"] = "使用職業顏色"
La["VotW"] = "看守"
La["Warn about instance limit"] = "警告副本限制"
La["Warning: You've entered about %i instances recently and are approaching the %i instance per hour limit for your account. More instances should be available in %s."] = "警告：你最近已經進入副本 %i 次，並且已經接近每小時 %i 次的帳號進入限制。 %s 後允許進入更多副本。"
La["Weekly Quests"] = "每週任務"
La["Wild Transmute"] = "狂野塑形"
La["World Boss"] = "世界首領"
La["World Bosses"] = "世界首領"
La["You can combine icons and text in a single indicator if you wish. Simply choose an icon, and insert the word ICON into the text field. Anywhere the word ICON is found, the icon you chose will be substituted in."] = "如果想要的話，可以在同個指標上顯示圖示與文字。首先選擇一個圖示，並在文字框中插入「ICON」到想要出現圖示的位置，就會自動替換成你選擇的圖示。"

elseif locale == "ptBR" then
La["|cffffff00Left-click|r to detach tooltip"] = "|cffffff00Botão Esquerdo | Para destacar as Dicas"
La["|cffffff00Middle-click|r to show Blizzard's Raid Information"] = "|cffffff00Botão do Meio|r para mostrar informações da Raid dadas pela Blizzard"
La["|cffffff00Right-click|r to configure SavedInstances"] = "|cffffff00Botão Direito|r Para configurar o SavedInstances"
--Translation missing 
La["Abbreviate keystones"] = "Abbreviate keystones"
--Translation missing 
La["Abbreviate Mythic keystone dungeon names"] = "Abbreviate Mythic keystone dungeon names"
La["Account"] = "Conta"
La["Account Summary"] = "Sumário da conta"
La["Alternating columns are colored differently"] = "Colunas alternadas são coloridos de forma diferente"
La["Always show"] = "Mostrar sempre"
La["Always show new instances"] = "Sempre mostrar novas instâncias"
--Translation missing 
La["Arc"] = "Arc"
La["Are you sure you want to remove %s from the SavedInstances character database?"] = "Você tem certeza de que deseja remover %s do banco de dados do SavedInstances?"
La["Are you sure you want to reset the SavedInstances character database? Characters will be re-populated as you log into them."] = "Você tem certeza de que desejar reiniciar a base de dados de personagens do SavedInstances? Personagens serão contabilizados quando você se conectar com eles."
La["Attempt to recover completed daily quests for this character. Note this may recover some additional, linked daily quests that were not actually completed today."] = "Tentar buscar missões diárias completadas por este personagem. Isto pode buscar algumas missões adicionais relacionadas que na verdade não foram completadas hoje."
La["Augment bonus loot frame"] = "Aumentar janela de saque bônus"
La["Automatically shrink the tooltip to fit on the screen"] = "Encolher ajuda automaticamente para caber na tela"
La["Battleground Deserter"] = "Acompanhar tempo de espera de Desertor para campo de batalha"
La["Bind a key to toggle the SavedInstances tooltip"] = "Vincule uma tecla para as dicas do SavedInstances"
--Translation missing 
La["Bonus loot frame"] = "Bonus loot frame"
La["Bonus rolls"] = "Saque de bônus"
--Translation missing 
La[ [=[Boss kill information is missing for this lockout.
This is a Blizzard bug affecting certain old raids.]=] ] = [=[Boss kill information is missing for this lockout.
This is a Blizzard bug affecting certain old raids.]=]
La["Boss kill information is missing for this lockout.\\nThis is a Blizzard bug affecting certain old raids."] = "Informações sobre a derrota do chefe estão faltando para este Vínculo. \\n Esse é um bug da Blizzard que afeta certas raids antigas."
--Translation missing 
La["BRH"] = "BRH"
La["Categories"] = "Categorias"
La["Character column style"] = "Estilo de coluna do personagem"
La["Characters"] = "Personagens"
--Translation missing 
La["CoEN"] = "CoEN"
La["Color currency by cap"] = "Colorir moedas por limite"
La["Columns are colored according to the characters class"] = "As colunas são coloridas de acordo com a classe dos personagens"
La["Columns are the same color as the whole tooltip"] = "As colunas são da mesma cor"
La["Combine LFR"] = "Combinar LdR"
La["Combine World Bosses"] = "Agrupar chefes mundiais"
La["Connected Realms"] = "Reinos conectados"
--Translation missing 
La["CoS"] = "CoS"
La["Crops growing"] = "Plantas crescendo"
La["Crops harvested today"] = "Plantas colhidas hoje"
La["Crops planted today"] = "Mudas plantadas hoje"
La["Crops ready"] = "Plantas prontas para colher"
La["Currency settings"] = "Configuração de moedas"
La["Daily Quests"] = "Missões Diárias"
La["Day"] = "Dia"
La["Debug Mode"] = "Mode de Debug"
--Translation missing 
La["DHT"] = "DHT"
La["Disable mouseover"] = "Desativar mouseover"
La["Disable tooltip display on icon mouseover"] = "Desabilitar exibição de ajuda ao passar o mouse no ícone"
La["Display instances in order of recommended level from lowest to highest"] = "Exibir instâncias em ordem de nível recomendado menor para o maior"
La["Display instances with space inserted between categories"] = "Exibir instâncias com espaço inserido entre as categorias"
--Translation missing 
La["Dump quest debugging information"] = "Dump quest debugging information"
La["Dump time debugging information"] = "Gerar informações de tempo de depuração"
La["Emissary Missing"] = "Emissários Faltando"
--Translation missing 
La["Emissary Quests"] = "Emissary Quests"
--Translation missing 
La["Emissary quests"] = "Emissary quests"
--Translation missing 
La["EoA"] = "EoA"
La["Expansion"] = "Expansão"
La["Expired Lockout - Can be extended"] = "Bloqueio de expirado - Pode ser estendida"
La["Extended Lockout - Not yet saved"] = "Bloqueiar de Extensão - Ainda não salva"
La["Facets of Research"] = "Facetas da Pesquisa"
La["Farm crops"] = "Colher sementes"
La["Farm Crops"] = "Plantação"
La["Fit to screen"] = "Ajustar à tela"
La["Flex"] = "Flexível"
La["Format large numbers"] = "Formatar números grandes"
La["General settings"] = "Configurações Gerais"
La["Group"] = "Grupo"
La["Hold Alt to show all data"] = "Segure a tecla Alt para mostrar todos os dados"
--Translation missing 
La["HoV"] = "HoV"
La["Hover mouse on indicator for details"] = "Passe o mouse sobre o indicador para obter detalhes"
La["Ignore"] = "Ignorar"
La["Indicators"] = "Indicadores"
--Translation missing 
La["Instance limit in Broker"] = "Instance limit in Broker"
La["Instances"] = "Instância"
--Translation missing 
La["Interleave"] = "Interleave"
--Translation missing 
La["L Kara"] = "L Kara"
La["Last updated"] = "Ultima atualização"
--Translation missing 
La["Last Week Reward Usable"] = "Last Week Reward Usable"
La["Legion Transmute"] = "Transmutação de Legion"
La["Level %d Characters"] = "Personagens nível %d"
La["LFG cooldown"] = "Recarga do Localizador de Masmorras"
La["LFR"] = "LdR"
La["List categories from the current expansion pack first"] = "Listar primeiro o pacote de expansão atual"
La["List raid categories before dungeon categories"] = "Categorias de raide antes de categorias de masmorras"
La["Lockouts"] = "bloqueios"
La["Manage"] = "Gerenciar"
La["Miscellaneous Tracking"] = "Diversos"
--Translation missing 
La["MoS"] = "MoS"
La["Most recent first"] = "Mais recente primeiro"
La["Move down"] = "mover para baixo"
La["Move up"] = "mover para cima"
--Translation missing 
La["Mythic Best"] = "Mythic Best"
--Translation missing 
La["Mythic Key Best"] = "Mythic Key Best"
--Translation missing 
La["Mythic Keystone"] = "Mythic Keystone"
--Translation missing 
La["Nelt"] = "Nelt"
La["Never show"] = "Nunca mostrar"
La["Opacity of the tooltip row highlighting"] = "Opacidade do destaque da linha de ajuda"
La["Open config"] = "Abrir configuração"
--Translation missing 
La["Order must be a number in [0 - 999]"] = "Order must be a number in [0 - 999]"
La["Plant"] = "Planta"
La["Raids before dungeons"] = "Reide antes de masmorras"
La["Recent Bonus Rolls"] = "Saque de bônus recentes"
La["Recent Instances"] = "Instâncias recentes"
La["Recover Dailies"] = "Recuperar missões diárias"
La["Remind about weekly charm quest"] = "Lembrar sobre missão semanal de patuás"
La["Reminder: You need to do quest %s"] = "Lembrete: Você precisa fazer a missão %s"
La["Report instance resets to group"] = "Redefinir relatório da Instância para o grupo"
La["Reset Characters"] = "Reiniciar personagens"
La["Reverse ordering"] = "Ordem inversa"
La["Roll Bonus"] = "Rolar saque de bônus"
La["Row Highlight"] = "Realçar fileira"
La["Seed"] = "Semente"
La["Seeds"] = "Sementes"
La["Set All"] = "Ajustar todos"
La["Show category names"] = "Mostrar nome das categorias"
La["Show category names in the tooltip"] = "Mostrar nome das categorias nas Dicas"
La["Show cooldown for characters to use battleground system"] = "Mostrar tempo de espera para personagens poderem usar o sistema de campo de batalha"
La["Show cooldown for characters to use LFG dungeon system"] = "Mostrar tempo de espera do personagens para usr o Localizador Masmorra LFG"
--Translation missing 
La["Show currency earned"] = "Show currency earned"
--Translation missing 
La["Show currency max"] = "Show currency max"
La["Show Expired"] = "Mostrar expirados"
La["Show expired instance lockouts"] = "Mostrar bloqueios expirados de instância"
La["Show Holiday"] = "Mostrar Feriados"
La["Show holiday boss rewards"] = "Mostrar Chefes de Eventos"
La["Show minimap button"] = "Mostrar botão do minimapa"
La["Show name for a category when all displayed instances belong only to that category"] = "Mostrar o nome de uma categoria, quando todas as instâncias exibidas pertencerem a essa categoria"
La["Show only current server"] = "Mostrar apenas o servidor atual"
La["Show Random"] = "Mostrar Aleatório"
La["Show random dungeon bonus reward"] = "Mostrar recompensa bônus de masmorra aleatóra"
La["Show self always"] = "Sempre mostrar-se"
La["Show self first"] = "Mostrar-se primeiro"
--Translation missing 
La["Show server name"] = "Show server name"
La["Show the SavedInstances minimap button"] = "Mostrar o botão do SavedInstances no minimapa"
La["Show tooltip hints"] = "Mostrar Dicas"
La["Show When"] = "Mostrar quando"
La["Show when not saved"] = "Mostrar quando não salvo"
La["Show when saved"] = "Mostrar Quando salvo"
La["Show/Hide the SavedInstances tooltip"] = "Mostrar/Ocultar as dicas do SavedInstances"
La["Similarly, the words KILLED and TOTAL will be substituted with the number of bosses killed and total in the lockout."] = "Da mesma forma, as palavras mortas e TOTAL será substituído com o número de chefes mortos e total do bloqueio."
La["Single category name"] = "Nome da categoria única"
La["Sort by server"] = "Organizar por servidor"
La["Sort categories by"] = "Ordenar categorias por"
La["Sort Order"] = "Organizar por"
--Translation missing 
La["Sorting"] = "Sorting"
--Translation missing 
La["SotT"] = "SotT"
La["Space between categories"] = "Espaço entre as categorias"
La["Text"] = "Texto"
La["The Four Celestials"] = "Os Quatro Celestiais"
La["These are the instances that count towards the %i instances per hour account limit, and the time until they expire."] = "Estas são as instâncias que contam para %i instâncias por hora em cada conta, e o tempo até que expirem."
La["This should only be used for characters who have been renamed or deleted, as characters will be re-populated when you log into them."] = "Isto deve ser usado apenas para personagens que foram removidos ou deletados, ou para personagens que serão contabilizados quando você se conectar neles."
La["Throw"] = "Arremeçar"
La["Time /played"] = "Tempo /played"
La["Time Left"] = "Tempo restante"
La["Tooltip Scale"] = "Escala da janela"
La["Track"] = "Caminho"
--Translation missing 
La["Track Mythic keystone acquisition"] = "Track Mythic keystone acquisition"
--Translation missing 
La["Track Mythic keystone best run"] = "Track Mythic keystone best run"
La["Trade Skill Cooldowns"] = "Recarga de Habilidades"
La["Trade skills"] = "Habilidades de profissão"
La["Transmute"] = "Transmutação"
La["Type"] = "Tipo"
--Translation missing 
La["U Kara"] = "U Kara"
La["Use class color"] = "Usar cor das classes"
--Translation missing 
La["VotW"] = "VotW"
--Translation missing 
La["Warn about instance limit"] = "Warn about instance limit"
La["Warning: You've entered about %i instances recently and are approaching the %i instance per hour limit for your account. More instances should be available in %s."] = "Atenção: Você entrou em cerca de%i Instância e esta se aproximando de %i , limite por hora para a sua conta. Mais instâncias devem estar disponíveis em %s."
La["Weekly Quests"] = "Missões Semanais"
--Translation missing 
La["Wild Transmute"] = "Wild Transmute"
La["World Boss"] = "Chefes de Mundo"
La["World Bosses"] = "Chefes de Mundo"
La["You can combine icons and text in a single indicator if you wish. Simply choose an icon, and insert the word ICON into the text field. Anywhere the word ICON is found, the icon you chose will be substituted in."] = "Você pode combinar os ícones e texto em um único indicador, se desejar. Basta escolher um ícone, e inserir o ícone no campo de texto. Em qualquer lugar do ícone for encontrado, o ícone que você escolheu será substituída dentro"

elseif locale == "itIT" then
La["|cffffff00Left-click|r to detach tooltip"] = " |cffffff00Click sinistro|r per sganciare la finestra"
La["|cffffff00Middle-click|r to show Blizzard's Raid Information"] = "|cffffff00Click-centrale|r permostrare le informazioni Blizzard sul raid"
La["|cffffff00Right-click|r to configure SavedInstances"] = "|cffffff00Click destro|r per configurare SavedInstances"
--Translation missing 
La["Abbreviate keystones"] = "Abbreviate keystones"
--Translation missing 
La["Abbreviate Mythic keystone dungeon names"] = "Abbreviate Mythic keystone dungeon names"
La["Account"] = "Account"
La["Account Summary"] = "Riepilogo dell'account"
La["Alternating columns are colored differently"] = "Le colonne alternate sono colorate diversamente"
La["Always show"] = "Mostra sempre"
La["Always show new instances"] = "Mostra sempre nuove istanze"
--Translation missing 
La["Arc"] = "Arc"
La["Are you sure you want to remove %s from the SavedInstances character database?"] = "Sei sicuro di voler rimuovere %s dal database dei personaggi ?"
La["Are you sure you want to reset the SavedInstances character database? Characters will be re-populated as you log into them."] = "Sei sicuro di voler azzerae il database personaggi di SavedInstances? I personaggi saranno ricalcolati non appena ci entri"
La["Attempt to recover completed daily quests for this character. Note this may recover some additional, linked daily quests that were not actually completed today."] = "Cerca di ripristinare le missioni giornaliere completate per questo personaggio. Nota che questo puo' recuperare alcune missioni aggiuntive, collegate alle giornaliere, che non sono ancora state completate oggi"
La["Augment bonus loot frame"] = "Aumenta il riquadro del bottino bonus"
La["Automatically shrink the tooltip to fit on the screen"] = "Adatta automaticamente la finestra per adeguarsi allo schermo"
La["Battleground Deserter"] = "Disertore di campi di battaglia"
La["Bind a key to toggle the SavedInstances tooltip"] = "Abbina un tasto per mostrare la finestra di SavedInstances "
--Translation missing 
La["Bonus loot frame"] = "Bonus loot frame"
La["Bonus rolls"] = "Tiri bonus"
--Translation missing 
La[ [=[Boss kill information is missing for this lockout.
This is a Blizzard bug affecting certain old raids.]=] ] = [=[Boss kill information is missing for this lockout.
This is a Blizzard bug affecting certain old raids.]=]
La["Boss kill information is missing for this lockout.\\nThis is a Blizzard bug affecting certain old raids."] = "Mancano le informazioni sulle uccisioni dei boss di questo salvataggio.\\nQuesto e' un problema di Blizzard che riguarda alcune vecchie incursioni"
--Translation missing 
La["BRH"] = "BRH"
La["Categories"] = "Categorie"
La["Character column style"] = "Stile colonne dei personaggi"
La["Characters"] = "Personaggi"
--Translation missing 
La["CoEN"] = "CoEN"
La["Color currency by cap"] = "Colora valute in base al limite"
La["Columns are colored according to the characters class"] = "Le colonne sono colorate in base alla classe del personaggio"
La["Columns are the same color as the whole tooltip"] = "Le colonne sono dello stesso colore dell'intero testo"
La["Combine LFR"] = "Unisci le riceche spedizioni"
La["Combine World Bosses"] = "Unisci i boss mondiali"
La["Connected Realms"] = "Reami connessi"
--Translation missing 
La["CoS"] = "CoS"
La["Crops growing"] = "Terreni in crescita"
La["Crops harvested today"] = "Terreni raccolti oggi"
La["Crops planted today"] = "Terreni seminati oggi"
La["Crops ready"] = "Terreni pronti"
La["Currency settings"] = "Impostazioni delle valute"
La["Daily Quests"] = "Missioni giornaliere"
--Translation missing 
La["Day"] = "Day"
--Translation missing 
La["Debug Mode"] = "Debug Mode"
--Translation missing 
La["DHT"] = "DHT"
La["Disable mouseover"] = "Disabilita movimento del mouse"
La["Disable tooltip display on icon mouseover"] = "Disattiva i tooltip quando vai sull'icona"
La["Display instances in order of recommended level from lowest to highest"] = "Mostra istanze in ordine del livello raccomandato dal piu' basso al piu' alto"
La["Display instances with space inserted between categories"] = "Mostra le istanze con uno spazio tra le varie categorie"
--Translation missing 
La["Dump quest debugging information"] = "Dump quest debugging information"
La["Dump time debugging information"] = "Inserisci l'orario nelle informazioni di debug"
--Translation missing 
La["Emissary Missing"] = "Emissary Missing"
--Translation missing 
La["Emissary Quests"] = "Emissary Quests"
--Translation missing 
La["Emissary quests"] = "Emissary quests"
--Translation missing 
La["EoA"] = "EoA"
La["Expansion"] = "Espansione"
La["Expired Lockout - Can be extended"] = "Salvataggio scaduto - puo' essere esteso"
La["Extended Lockout - Not yet saved"] = "Salvataggio esteso - non ancora salvato"
La["Facets of Research"] = "Preziosi da Ricerca"
La["Farm crops"] = "Campi della fattoria"
La["Farm Crops"] = "Terreni della fattoria"
La["Fit to screen"] = "Adatta allo schermo"
La["Flex"] = "Flex"
La["Format large numbers"] = "Adatta i numeri grandi"
La["General settings"] = "Opzioni generali"
La["Group"] = "Gruppo"
La["Hold Alt to show all data"] = "Tieni premuto Alt per mostrare tutti i dati"
--Translation missing 
La["HoV"] = "HoV"
La["Hover mouse on indicator for details"] = "Muovi il mouse sugli indicatori per i dettagli"
La["Ignore"] = "Ignora"
La["Indicators"] = "Indicatori"
--Translation missing 
La["Instance limit in Broker"] = "Instance limit in Broker"
La["Instances"] = "Istanze"
La["Interleave"] = "Interlinea"
--Translation missing 
La["L Kara"] = "L Kara"
La["Last updated"] = "Ultimo aggiornamento"
--Translation missing 
La["Last Week Reward Usable"] = "Last Week Reward Usable"
La["Legion Transmute"] = "Trasmutazione di Legion"
La["Level %d Characters"] = "Personaggio di livello %d "
La["LFG cooldown"] = "Tempo rimanente ricerca delle spedizioni"
La["LFR"] = "Ricerca spedizioni"
La["List categories from the current expansion pack first"] = "Elenca categorie partendo dall'espansione attuale"
La["List raid categories before dungeon categories"] = "Elenca le incursioni prima delle spedizioni"
La["Lockouts"] = "Salvataggi"
La["Manage"] = "Gestisci"
La["Miscellaneous Tracking"] = "Tracciature varie"
--Translation missing 
La["MoS"] = "MoS"
La["Most recent first"] = "Prima i piu' recenti"
La["Move down"] = "Sposta giu"
La["Move up"] = "Sposta su"
--Translation missing 
La["Mythic Best"] = "Mythic Best"
--Translation missing 
La["Mythic Key Best"] = "Mythic Key Best"
--Translation missing 
La["Mythic Keystone"] = "Mythic Keystone"
--Translation missing 
La["Nelt"] = "Nelt"
La["Never show"] = "Non mostrare mai"
La["Opacity of the tooltip row highlighting"] = "Opacita' dell'evidenziazione delle riga"
La["Open config"] = "Apri opzioni"
--Translation missing 
La["Order must be a number in [0 - 999]"] = "Order must be a number in [0 - 999]"
La["Plant"] = "Pianta"
La["Raids before dungeons"] = "Incursioni prima delle spedizioni"
La["Recent Bonus Rolls"] = "Tiri bonus recenti"
La["Recent Instances"] = "Istanze recenti"
La["Recover Dailies"] = "Ripristina missioni giornaliere"
La["Remind about weekly charm quest"] = "Ricordami delle missioni settimanali"
La["Reminder: You need to do quest %s"] = "Promemoria: Devi completare la missione %s"
La["Report instance resets to group"] = "Informa il gruppo del ripristino dell'istanza"
La["Reset Characters"] = "Azzera personaggi"
La["Reverse ordering"] = "Ordinamento inverso"
La["Roll Bonus"] = "Tiro bonus"
La["Row Highlight"] = "Evidenzia riga"
La["Seed"] = "Seme"
La["Seeds"] = "Semi"
La["Set All"] = "Imposta tutto"
La["Show category names"] = "Mostra i nomi delle categorie"
La["Show category names in the tooltip"] = "Mostra il nome della categoria nel tooltip"
La["Show cooldown for characters to use battleground system"] = "Mostra il tempo rimanente prima che i personaggi possano usare il sistema di campi di battaglia"
La["Show cooldown for characters to use LFG dungeon system"] = "Mostra il tempo rimanente prima che i personagg possano usare la riceca delle spedizioni"
--Translation missing 
La["Show currency earned"] = "Show currency earned"
--Translation missing 
La["Show currency max"] = "Show currency max"
La["Show Expired"] = "Mostra scaduti"
La["Show expired instance lockouts"] = "Mostra scadenza salvataggi istanze"
La["Show Holiday"] = "Mostra le feste"
La["Show holiday boss rewards"] = "Mostra ricompense dei boss delle feste"
La["Show minimap button"] = "Mostra bottone minimappa"
La["Show name for a category when all displayed instances belong only to that category"] = "Mostra il nome per una categoria quando tutte le istanze mostrare appartengono solo a quella categoria"
La["Show only current server"] = "Mostra solo server attuale"
La["Show Random"] = "Mostra causale"
La["Show random dungeon bonus reward"] = "Mostra ricompensa bonus per spedizione casuale"
La["Show self always"] = "Mostra sempre questo pg"
La["Show self first"] = "Mostra questo pg per primo"
--Translation missing 
La["Show server name"] = "Show server name"
La["Show the SavedInstances minimap button"] = "Mostra il bottone di SavedInstances nella minimappa"
La["Show tooltip hints"] = "Mostra suggerimenti"
La["Show When"] = "Mostra quando"
La["Show when not saved"] = "Mostra quando non e' salvato"
La["Show when saved"] = "Mostra quando e' salvato"
La["Show/Hide the SavedInstances tooltip"] = "Mostra/nascondi la finestra di SavedInstances"
La["Similarly, the words KILLED and TOTAL will be substituted with the number of bosses killed and total in the lockout."] = "Analogamente, le parole UCCISI e TOTALE saranno sostituite dal numero di boss uccisi e totali nel salvataggio"
La["Single category name"] = "Nome categoria singolo"
La["Sort by server"] = "Ordina per server"
La["Sort categories by"] = "Ordina categorie per"
La["Sort Order"] = "Ordinamento"
--Translation missing 
La["Sorting"] = "Sorting"
--Translation missing 
La["SotT"] = "SotT"
La["Space between categories"] = "Spazio tra le categorie"
La["Text"] = "Testo"
La["The Four Celestials"] = "I quattro Celestiali"
La["These are the instances that count towards the %i instances per hour account limit, and the time until they expire."] = "Queste sono le istanze conteggiate per il limite orario per account di %i, e il tempo prima che scadano"
La["This should only be used for characters who have been renamed or deleted, as characters will be re-populated when you log into them."] = "Questo dovrebbe essere usato solo per personaggi che sono stati rinominati o cancellati, poiche' i personaggi saranno riesaminati quando ci accedi nuovamente"
La["Throw"] = "Gettare"
La["Time /played"] = "Tempo /giocato"
La["Time Left"] = "Tempo rimanente"
La["Tooltip Scale"] = "Zoom del tooltip"
La["Track"] = "Traccia"
--Translation missing 
La["Track Mythic keystone acquisition"] = "Track Mythic keystone acquisition"
--Translation missing 
La["Track Mythic keystone best run"] = "Track Mythic keystone best run"
La["Trade Skill Cooldowns"] = "Tempo di scadenza professioni"
La["Trade skills"] = "Professioni"
La["Transmute"] = "Trasmutazioni"
La["Type"] = "Tipo"
--Translation missing 
La["U Kara"] = "U Kara"
La["Use class color"] = "Usa colori delle classi"
--Translation missing 
La["VotW"] = "VotW"
--Translation missing 
La["Warn about instance limit"] = "Warn about instance limit"
La["Warning: You've entered about %i instances recently and are approaching the %i instance per hour limit for your account. More instances should be available in %s."] = "Attenzione: Sei entrato in circa %i istanze, recentemente e ti stai avvicinando al limite orario di %i istanze per account. Altre istanze saranno disponibili in %s."
La["Weekly Quests"] = "Missioni settimanali"
La["Wild Transmute"] = "Trasmutazione selvaggia"
La["World Boss"] = "Boss mondiale"
La["World Bosses"] = "Boss mondiali"
La["You can combine icons and text in a single indicator if you wish. Simply choose an icon, and insert the word ICON into the text field. Anywhere the word ICON is found, the icon you chose will be substituted in."] = "Puoi unire icone e testo in un unico indicatore se vuoi. Basta scegliere una icona, e inserire la parola ICON nel campo testo. Ovunque viene trovata la parola ICON, l'icona che hai scelto la sostituira'."

end
