local AddonName, a = ...
a.Localize = setmetatable({}, {__index = function(_, key) return key end})
local L = a.Localize

-- Example:
L["English text goes here."] = "Translated text goes here."

if GetLocale() == "ptBR" then -- Brazilian Portuguese
L["S.E.L.F.I.E. Camera"] = "Câmera de S.E.L.F.I.E."
L["S.E.L.F.I.E. Camera MkII"] = "Câmera de S.E.L.F.I.E. 2.0"
elseif GetLocale() == "frFR" then -- French
L["S.E.L.F.I.E. Camera"] = "Appareil photo P.R.O.F.I.L."
L["S.E.L.F.I.E. Camera MkII"] = "Appareil photo P.R.O.F.I.L. Mod.II"
elseif GetLocale() == "deDE" then -- German
L["S.E.L.F.I.E. Camera"] = "S.E.L.F.I.E.-Kamera"
L["S.E.L.F.I.E. Camera MkII"] = "S.E.L.F.I.E.-Kamera 2.0"
elseif GetLocale() == "itIT" then -- Italian
L["S.E.L.F.I.E. Camera"] = "Fotocamera S.E.L.F.I.E."
L["S.E.L.F.I.E. Camera MkII"] = "Fotocamera S.E.L.F.I.E. v2"
elseif GetLocale() == "koKR" then -- Korean
L["S.E.L.F.I.E. Camera"] = "\"셀카\" 사진기"
L["S.E.L.F.I.E. Camera MkII"] = "\"셀카\" 사진기 마크 II"
elseif GetLocale() == "esMX" then -- Latin American Spanish
L["S.E.L.F.I.E. Camera"] = "Cámara S.E.L.F.I."
L["S.E.L.F.I.E. Camera MkII"] = "Cámara S.E.L.F.I. Mk. II"
elseif GetLocale() == "ruRU" then -- Russian
L["S.E.L.F.I.E. Camera"] = "Камера С.Е.Л.Ф.И."
L["S.E.L.F.I.E. Camera MkII"] = "Камера С.Е.Л.Ф.И. 2.0"
elseif GetLocale() == "zhCN" then -- Simplified Chinese
L["S.E.L.F.I.E. Camera"] = "自拍神器"
L["S.E.L.F.I.E. Camera MkII"] = "MkII型自拍神器"
elseif GetLocale() == "esES" then -- Spanish
L["S.E.L.F.I.E. Camera"] = "Cámara S.E.L.F.I."
L["S.E.L.F.I.E. Camera MkII"] = "Cámara S.E.L.F.I. Mk. II"
elseif GetLocale() == "zhTW" then -- Traditional Chinese
--L["S.E.L.F.I.E. Camera"] = ""
--L["S.E.L.F.I.E. Camera MkII"] = ""
end