RicoMiniMap = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceConsole-2.0", "AceDB-2.0")
RicoMiniMap:RegisterDB("RicoMiniMapDB")
local dewdrop = AceLibrary("Dewdrop-2.0")
local RicoMiniMapHidden = false
local strataNames = {"BACKGROUND", "LOW", "MEDIUM", "HIGH", "DIALOG", "FULLSCREEN", "FULLSCREEN_DIALOG", "TOOLTIP"}
local L = AceLibrary("AceLocale-2.2"):new("RicoMM")
local PingingUnit;
local addonName = ...

local LDB = LibStub:GetLibrary("LibDataBroker-1.1")
RicoMiniMap_LDB = LDB:NewDataObject( "RicoMiniMapLDB", {type = "data source", text = "RicoMM", label = "RicoMiniMapLDB", icon = "Interface\\Addons\\RicoMiniMap\\icon.tga"} )

local RicoMiniMap_LDB_Frame = CreateFrame("Frame")

RicoMiniMap:RegisterDefaults('profile', {
  	ShowCoordinates = true,
  	ShowTenths = true,
  	ShowZoneText = false,
  	ZoneTextOffset = 30,
  	ShowZoomButtons = false,
  	ShowMapButton = false,
  	ShowTrackingButton = true,
  	ShowMailButton = true,
  	ShowTime = false,
  	Scale = 1.0,
  	Strata = 1,
  	Shape = 2,
  	CoordinatesPosition = 1,
  	Alpha = 1,
  	PingNotificationType = 1,
  	WatchFrameScale = 1,
  	WatchFrameHeight = 300,
  	ShowClock = false,
  	ShowQuestWatcher = true
	}
)

local DoNothing = function() end

local function GetPercent(value)
	value = tonumber(value) or 1
	return value <= 0.1 and 0.1 or value >= 2 and 2 or value
end

function RicoMiniMap:OnInitialize()
--	self:RegisterEvent("ZONE_CHANGED")
--	self:RegisterEvent("ZONE_CHANGED_INDOORS")
--	self:RegisterEvent("DISPLAY_SIZE_CHANGED")
--	self:RegisterEvent("MINIMAP_PING")

	self.slashOptions = {
		name = "RicoMiniMap",
		desc = L["A customizable MiniMap"],
		type = "group",
		args = {
			[L["config"]] = {
				name = L["config"],
				type = "execute",
				desc = L["Open the config menu."],
				func = function() dewdrop:Open(Minimap) end,
			},
			[L["reset"]] = {
				name = L["reset"],
				type = "execute",
				desc = L["Reset the minimap's position."],
				func = "ResetPositions",
			},				
			[L["menu"]] = {
				name = L["menu"],
				type = "execute",
				desc = L["Enable the menu on right-click."],
				func = function() self.db.profile.ShowMenu = true RicoMiniMap:UpdateMinimapMenu() end,
			},				
			[L["hide"]] = {
				name = L["hide"],
				type = "execute",
				desc = L["Hide the entire minimap."],
				func = function() RicoMiniMapHidden = true RicoMiniMap:UpdateShape() end,
			},				
			[L["show"]] = {
				name = L["show"],
				type = "execute",
				desc = L["Show the minimap."],
				func = function() RicoMiniMapHidden = false RicoMiniMap:UpdateShape() end,
			},				
			["savepos"] = {
				name = "save",
				type = "execute",
				desc = "Save the positions of the minimap frames.",
				func = "SavePositions",
			},				
			["restore"] = {
				name = "restore",
				type = "execute",
				desc = "Restore saved positions of the minimap frames.",
				func = "RestorePositions",
			},				
		}
	}

	if self.db.char.HasMoved == nil then
		RicoMiniMap:ResetPositions()
		self.db.char.HasMoved = true
	end
	
	MinimapCluster:SetScale(RicoMiniMap:GetMapScale())
	RicoMiniMap:SetMapStrata(RicoMiniMap:GetMapStrata())
	MinimapCluster:SetMovable(true)
	Minimap:RegisterForDrag("LeftButton")
	Minimap:SetScript("OnDragStart", function() self:MMFrameDrag(MinimapCluster,true) end)
	Minimap:SetScript("OnDragStop", function() self:MMFrameDrag(MinimapCluster,false) end)
	MinimapBorder:SetParent(Minimap)

	MinimapZoneTextButton:ClearAllPoints()
	MinimapZoneTextButton:SetPoint("TOPRIGHT", -20, self.db.profile.ZoneTextLocation)
	MinimapZoneTextButton:SetFrameStrata("LOW")

	MinimapBorderTop:Hide()
	
	ObjectiveTrackerFrame:ClearAllPoints()
	ObjectiveTrackerFrame:SetPoint("TOPRIGHT", 0, -25)
	ObjectiveTrackerFrame:SetScale(RicoMiniMap:GetWatchFrameScale())
	ObjectiveTrackerFrame:SetHeight(RicoMiniMap:GetWatchFrameHeight())
	ObjectiveTrackerFrame:SetClampedToScreen(false)

	self.OnMenuRequest = RicoMiniMap_OptionTable
	self.overrideMenu = true
	self:RegisterChatCommand({"/RicoMiniMap", "/rmm"}, self.slashOptions)

	RicoMiniMap:UpdateZoomButtons()
	RicoMiniMap:UpdateShape()
	RicoMiniMap:UpdateCoordinatesPosition()
	RicoMiniMap:UpdateMinimapMenu()
	RicoMiniMap:SetShowingClock()
	RicoMiniMap:SetShowingCoordinates()
	RicoMiniMap:SetShowingMapButton()
	RicoMiniMap:SetShowingTimeButton()
	RicoMiniMap:SetShowingQuestWatcher()
	RicoMiniMap:SetShowingMailButton()

	MiniMapMailFrame:ClearAllPoints()
	MiniMapMailFrame:SetPoint('TOPLEFT', Minimap, -2, 25)
	MiniMapMailFrame:SetHeight(10)
	MiniMapMailFrame:SetFrameStrata("LOW")
	
	MiniMapTracking:ClearAllPoints()
	MiniMapTracking:SetPoint('BOTTOM', Minimap, -80, 140)
	MiniMapTracking:SetHeight(10)
	MiniMapTracking:SetFrameStrata("LOW")

	MiniMapVoiceChatFrame:ClearAllPoints()
  MiniMapVoiceChatFrame:Hide()

	if RicoMiniMap:IsShowingZoneText() then
		MinimapZoneTextButton:Show()
	else
		MinimapZoneTextButton:Hide()
	end

	RicoMiniMap:UpdateAlpha()

	if not RicoMiniMap:IsLocked() then
		RicoMiniMap:ToggleLocked()
	end
	
	RicoMiniMap:RestorePositions()

end

function RicoMiniMap_OnLoad()
end

-----------------------------------------------------------
-- Movers  (code originally from wMmap, used by permisison)
local silhouette, movers = UIParent:CreateTexture(nil, 'BACKGROUND')
silhouette:SetTexture([[Interface\BUTTONS\WHITE8X8]])
silhouette:SetAlpha(0.45)
silhouette:Hide()

local function GetRelativePoint(frame)
	local L1, B1, W1, H1 = UIParent:GetRect()
	local L2, B2, W2, H2 = frame:GetRect()
	if L2 == nil then
		return nil, nil, nil
	else	
		local x, y, h, w, anchor = L2 - L1, B2 - B1, H1 - H2, W1 - W2
		if x < w * 0.5 then
			anchor = 'LEFT'
		else
			anchor, x = 'RIGHT', x - w
		end
		if y < h * 0.5 then
			anchor = 'BOTTOM' .. anchor
		else
			anchor, y = 'TOP' .. anchor, y - h
		end
		return anchor, x, y
	end
end

local function OnMouseDown(self, button)
	if button ~= 'LeftButton' then return end
	self.moving = true
	if not self[4]:IsVisible() or self[5] then
		silhouette:SetParent(self)
		silhouette:ClearAllPoints()
		silhouette:SetAllPoints(self[4])
		silhouette:Show()
	end
	self:StartMoving()
end

local function OnMouseUp(self, button)
	if button ~= 'LeftButton' or not self.moving then return end
	self.moving = nil
	silhouette:Hide()
	self:StopMovingOrSizing()
end

local function CreateMoverFrame(name, moveFrame, silhouette)
  if moveFrame ~= nil then
		local frame = CreateFrame('Frame', addonName .. name .. "Mover", UIParent)
		frame:EnableMouse(true)
		frame:SetMovable(true)
		frame:SetClampedToScreen(true)
		frame:SetScript('OnMouseDown', OnMouseDown)
		frame:SetScript('OnMouseUp', OnMouseUp)
		frame:Hide()

		if name ~= "Minimap" then
			local texture = frame:CreateTexture(nil, 'BORDER')
			texture:SetTexture([[Interface\Buttons\UI-Panel-Button-Up]])
			texture:SetAllPoints()
			texture:SetTexCoord(0, 1, 0, 1)
		end
		
		local string = frame:CreateFontString(nil, 'ARTWORK', 'GameFontNormal')
		string:SetPoint('CENTER', 1, 0)
		string:SetText(name)

		if name == "Minimap" then
			frame:SetHeight(Minimap:GetHeight())
			frame:SetWidth(Minimap:GetWidth())
		else
			frame:SetHeight(string:GetStringHeight() + 16)
			frame:SetWidth(string:GetStringWidth() + 32)
		end

		frame:SetPoint('TOP', moveFrame)
		local anchor, x, y = GetRelativePoint(frame)
		if anchor ~= nil then
			frame:ClearAllPoints()
			frame:SetPoint(anchor, x, y)

			moveFrame:ClearAllPoints()
			moveFrame:SetPoint('CENTER', frame)
			moveFrame.ClearAllPoints = DoNothing
			moveFrame.SetAllPoints = DoNothing
			moveFrame.SetPoint = DoNothing

			frame[1], frame[2], frame[3], frame[4], frame[5], frame[6] = anchor, x, y, silhouette or moveFrame, silhouette == false or nil
		else
			return nil
		end
		return frame
	else
	 return nil
	end
end

movers = {
	CreateMoverFrame("Minimap", MinimapCluster, false),
	CreateMoverFrame("Quest", ObjectiveTrackerFrame, false)
}
-- end code from wMmap


function RicoMiniMap_OnClick(frame, button)
	if button == "RightButton" and RicoMiniMap:IsShowingMenu() then
		RicoMiniMap:UpdateMinimapMenu()
	else
		Minimap_OnClick(frame, button)
	end
end

function RicoMiniMap:OnEnable()
end

function RicoMiniMap:MMFrameDrag(frameName, moving)
	if moving and RicoMiniMap:IsLocked() == false then
		frameName.isMoving = true
		frameName:StartMoving()
	elseif frameName.isMoving then
		frameName.isMoving = false
		frameName:StopMovingOrSizing()
	end
end

function RicoMiniMap:ResetPositions()
	movers[1]:ClearAllPoints() 
	movers[1]:SetPoint("CENTER", UIParent, "CENTER")
	if movers[2] ~= nil then
		movers[2]:ClearAllPoints() 
		movers[2]:SetPoint("CENTER", UIParent, "CENTER", 200, 0)
	end

	if RicoMiniMap:IsLocked() then
		RicoMiniMap:ToggleLocked()
	end

	DEFAULT_CHAT_FRAME:AddMessage("RMM reset")
end

function RicoMiniMap:SetMapLocationBC()
	movers[1]:ClearAllPoints()
	movers[1]:SetPoint("BOTTOM", UIParent, "BOTTOM")
end

function RicoMiniMap:SetMapLocationBL()
	movers[1]:ClearAllPoints()
	movers[1]:SetPoint("BOTTOMLEFT", UIParent, "BOTTOMLEFT")
end

function RicoMiniMap:SetMapLocationBR()
	movers[1]:ClearAllPoints()
	movers[1]:SetPoint("BOTTOMRIGHT", UIParent, "BOTTOMRIGHT")
end

function RicoMiniMap:SetMapLocationTC()
	movers[1]:ClearAllPoints()
	movers[1]:SetPoint("TOP", UIParent, "TOP")
end

function RicoMiniMap:SetMapLocationTL()
	movers[1]:ClearAllPoints()
	movers[1]:SetPoint("TOPLEFT", UIParent, "TOPLEFT")
end

function RicoMiniMap:SetMapLocationTR()
	movers[1]:ClearAllPoints()
	movers[1]:SetPoint("TOPRIGHT", UIParent, "TOPRIGHT")
end

function RicoMiniMap:SetMapLocationLC()
	movers[1]:ClearAllPoints()
	movers[1]:SetPoint("LEFT", UIParent, "LEFT")
end

function RicoMiniMap:SetMapLocationRC()
	movers[1]:ClearAllPoints()
	movers[1]:SetPoint("RIGHT", UIParent, "RIGHT")
end

function RicoMiniMap:SavePositions()
	self.db.profile.minimapX = movers[1]:GetLeft();
	self.db.profile.minimapY = movers[1]:GetBottom();
	if movers[2] ~= nil then
		self.db.profile.questX = movers[2]:GetLeft();
		self.db.profile.questY = movers[2]:GetBottom();
	end

	dewdrop:Close();
	DEFAULT_CHAT_FRAME:AddMessage("RMM positions saved.");
end

function RicoMiniMap:RestorePositions()
  if self.db.profile.minimapX == nil then
  	RicoMiniMap:ResetPositions();
		DEFAULT_CHAT_FRAME:AddMessage("RMM positions not found.")
  else
  	movers[1]:ClearAllPoints();
		movers[1]:SetPoint("BOTTOMLEFT", UIParent, "BOTTOMLEFT", self.db.profile.minimapX, self.db.profile.minimapY);
		if movers[2] ~= nil then
			movers[2]:ClearAllPoints() 
			movers[2]:SetPoint("BOTTOMLEFT", UIParent, "BOTTOMLEFT", self.db.profile.questX, self.db.profile.questY)
		end

		DEFAULT_CHAT_FRAME:AddMessage("RMM positions restored.")
	end

	dewdrop:Close();
end

function RicoMiniMap_LDB.OnClick()
	if RicoMiniMap:IsShowingMenu() then
		dewdrop:Open(Minimap)
	end
end

function RicoMiniMap:IsLocked()
	if self.db.profile.Locked == nil then
		self.db.profile.Locked = false
	end
	return self.db.profile.Locked
end

function RicoMiniMap:ToggleLocked()
	if self.db.profile.Locked == true then
		self.db.profile.Locked = false
		for index = 1, #movers do
			movers[index]:Show()
		end
 	else
		self.db.profile.Locked = true
		for index = 1, #movers do
			movers[index]:Hide()
		end		
	end
	return self.db.profile.Locked
end

function RicoMiniMap:IsShowingCoordinates()
	if self.db.profile.ShowCoordinates == nil then
		self.db.profile.ShowCoordinates = true
	end
	return self.db.profile.ShowCoordinates
end

function RicoMiniMap:SetShowingCoordinates(state)
	if state == "toggle" then
		self.db.profile.ShowCoordinates = not self.db.profile.ShowCoordinates
	end
	
	if state == "default" then
		self.db.profile.ShowCoordinates = true
	end	
	
	return self.db.profile.ShowCoordinates
end

function RicoMiniMap:IsShowingQuestWatcher()
	if self.db.profile.ShowQuestWatcher == nil then
		self.db.profile.ShowQuestWatcher = true
	end
	return self.db.profile.ShowQuestWatcher
end

function RicoMiniMap:SetShowingQuestWatcher(state)
	if state == "toggle" then
		self.db.profile.ShowQuestWatcher = not self.db.profile.ShowQuestWatcher
	end
	
	if state == "default" then
		self.db.profile.ShowQuestWatcher = true
	end	
	
	if RicoMiniMap:IsShowingQuestWatcher() then
		ObjectiveTrackerFrame:Show()
	else
		ObjectiveTrackerFrame:Hide()
	end
end

function RicoMiniMap:IsShowingCoordinateTenths()
	if self.db.profile.ShowTenths == nil then
		self.db.profile.ShowTenths = true
	end
	return self.db.profile.ShowTenths
end

function RicoMiniMap:ToggleShowingCoordinateTenths()
	self.db.profile.ShowTenths = not self.db.profile.ShowTenths
	return self.db.profile.ShowTenths
end

function RicoMiniMap:IsShowingZoomButtons()
	if self.db.profile.ShowZoomButtons == nil then
		self.db.profile.ShowZoomButtons = false
	end
	return self.db.profile.ShowZoomButtons
end

function RicoMiniMap:ToggleShowingZoomButtons()
	self.db.profile.ShowZoomButtons = not self.db.profile.ShowZoomButtons
	RicoMiniMap:UpdateZoomButtons()
	return self.db.profile.ShowZoomButtons
end

function RicoMiniMap:UpdateZoomButtons()
	if RicoMiniMap:IsShowingZoomButtons() then
		MinimapZoomIn:Show()
  	MinimapZoomOut:Show()	
	else
		MinimapZoomIn:Hide()
  	MinimapZoomOut:Hide()	
	end
end

function RicoMiniMap:IsShowingMapButton()
	if self.db.profile.ShowMapButton == nil then
		self.db.profile.ShowMapButton = false
	end
	return self.db.profile.ShowMapButton
end

function RicoMiniMap:SetShowingMapButton(state)
	if state == "toggle" then
		self.db.profile.ShowMapButton = not self.db.profile.ShowMapButton
	end
	
	if state == "default" then
		self.db.profile.ShowMapButton = false
	end 
	
	if RicoMiniMap:IsShowingMapButton() then
		MiniMapWorldMapButton:Show()
	else
		MiniMapWorldMapButton:Hide()
	end
	return self.db.profile.ShowMapButton
end

function RicoMiniMap:IsShowingTimeButton()
	if self.db.profile.ShowTimeButton == nil then
		self.db.profile.ShowTimeButton = false
	end
	return self.db.profile.ShowTimeButton
end

function RicoMiniMap:SetShowingTimeButton(state)
	if state == "toggle" then
		self.db.profile.ShowTimeButton = not self.db.profile.ShowTimeButton
	end
	
	if state == "default" then
		self.db.profile.ShowTimeButton = false
	end
	
	if self.db.profile.ShowTimeButton then
		GameTimeFrame:Show()
	else
		GameTimeFrame:Hide()
	end
	
	return self.db.profile.ShowTimeButton
end

function RicoMiniMap:IsShowingClock()
	if self.db.profile.ShowClock == nil then
		self.db.profile.ShowClock = false
	end
	return self.db.profile.ShowClock
end

function RicoMiniMap:SetShowingClock(state)
	if state == "toggle" then
		self.db.profile.ShowClock = not self.db.profile.ShowClock
	end
	
	if state == "default" then
		self.db.profile.ShowClock = false
	end
	
	if RicoMiniMap:IsShowingClock() then
		if TimeManagerClockButton then TimeManagerClockButton:Show() end
	else
		if TimeManagerClockButton then TimeManagerClockButton:Hide() end
	end
	return self.db.profile.ShowClock
end

function RicoMiniMap:IsShowingTrackingButton()
	if self.db.profile.ShowTrackingButton == nil then
		self.db.profile.ShowTrackingButton = true
	end
	return self.db.profile.ShowTrackingButton
end

function RicoMiniMap:ToggleShowingTrackingButton()
	self.db.profile.ShowTrackingButton = not self.db.profile.ShowTrackingButton
	if RicoMiniMap:IsShowingTrackingButton() then
		MiniMapTracking:Show()
	else
		MiniMapTracking:Hide()
	end
	return self.db.profile.ShowTrackingButton
end

function RicoMiniMap:IsShowingMailButton()
	if self.db.profile.ShowMailButton == nil then
		self.db.profile.ShowMailButton = false
	end
	return self.db.profile.ShowMailButton
end

function RicoMiniMap:SetShowingMailButton(state)
	if state == "toggle" then
		self.db.profile.ShowMailButton = not self.db.profile.ShowMailButton
	end
	
	if state == "default" then
		self.db.profile.ShowMailButton = true
	end
	
	if RicoMiniMap:IsShowingMailButton() then
		MiniMapMailFrame:Show()
	else
		MiniMapMailFrame:Hide()
	end
	return self.db.profile.ShowMailButton
end

function RicoMiniMap:IsShowingZoneText()
	if self.db.profile.ShowZoneText == nil then
		self.db.profile.ShowZoneText = false
	end
	return self.db.profile.ShowZoneText
end

function RicoMiniMap:ToggleShowingZoneText()
	self.db.profile.ShowZoneText = not self.db.profile.ShowZoneText
	if RicoMiniMap:IsShowingZoneText() then
		MinimapZoneTextButton:Show()
	else
		MinimapZoneTextButton:Hide()
	end
	return self.db.profile.ShowZoneText
end

function RicoMiniMap:GetMapScale()
	if self.db.profile.Scale == nil then
		self.db.profile.Scale = 1.25
	end
	return self.db.profile.Scale
end

function RicoMiniMap:SetMapScale(value)
	MinimapCluster:SetScale(value)
	self.db.profile.Scale = value
end

function RicoMiniMap:GetWatchFrameScale()
	if self.db.profile.WatchFrameScale == nil then
		self.db.profile.WatchFrameScale = 1
	end
	return self.db.profile.WatchFrameScale
end

function RicoMiniMap:SetWatchFrameScale(value)
	ObjectiveTrackerFrame:SetScale(value)
	self.db.profile.WatchFrameScale = value
end

function RicoMiniMap:GetWatchFrameHeight()
	if self.db.profile.WatchFrameHeight == nil then
		self.db.profile.WatchFrameHeight = 500
	end
	return self.db.profile.WatchFrameHeight
end

function RicoMiniMap:SetWatchFrameHeight(value)
	ObjectiveTrackerFrame:SetHeight(value)
	self.db.profile.WatchFrameHeight = value
end

function RicoMiniMap:GetMapStrata()
	if self.db.profile.Strata == nil then
		self.db.profile.Strata = 1
	end
	return self.db.profile.Strata
end

function RicoMiniMap:SetMapStrata(value)
	MinimapCluster:SetFrameStrata(strataNames[value])
	self.db.profile.Strata = value
end

function RicoMiniMap:GetAlpha()
	if self.db.profile.Alpha == nil then
		self.db.profile.Alpha = 1
	end
	return self.db.profile.Alpha
end

function RicoMiniMap:SetAlpha(value)
	self.db.profile.Alpha = value
	RicoMiniMap:UpdateAlpha()
end

function RicoMiniMap:UpdateAlpha()
	Minimap:SetAlpha(RicoMiniMap:GetAlpha())
end

function RicoMiniMap:GetZoneTextLocation()
	if self.db.profile.ZoneTextLocation == nil then
		self.db.profile.ZoneTextLocation = -20
	end
	return self.db.profile.ZoneTextLocation
end

function RicoMiniMap:SetZoneTextLocation(value)
	MinimapZoneTextButton:ClearAllPoints()
	MinimapZoneTextButton:SetPoint("TOPRIGHT", -20, value)
	self.db.profile.ZoneTextLocation = value
end

function RicoMiniMap:GetShape()
	if self.db.profile.Shape == nil then
		self.db.profile.Shape = 1
	end
	return self.db.profile.Shape
end

function RicoMiniMap:SetShape(value)
	self.db.profile.Shape = value
end

function RicoMiniMap:UpdateShape()
	if RicoMiniMapHidden then
		MinimapCluster:Hide()
	else
		MinimapCluster:Show()
		local value = self.db.profile.Shape
		
		if value == 1 then
			texture = "Interface\\AddOns\\RicoMiniMap\\Shapes\\BottomLeftRound"
			mask = "Interface\\AddOns\\RicoMiniMap\\Shapes\\BottomLeftRoundMask"
			MinimapBorder:SetTexCoord(0, 1, 0, 1)
			MinimapBorder:SetPoint('TOPLEFT', -3, 3)
			MinimapBorder:SetPoint('BOTTOMRIGHT', 3, -3)
		end
		
		if value == 2 then
			texture = "Interface\\AddOns\\RicoMiniMap\\Shapes\\SquareBlizzard"
			mask = "Interface\\AddOns\\RicoMiniMap\\Shapes\\SquareMask"
			MinimapBorder:SetTexCoord(0, 1, 0, 1)
			MinimapBorder:SetPoint('TOPLEFT', -3, 3)
			MinimapBorder:SetPoint('BOTTOMRIGHT', 3, -3)
		end

		if value == 3 then
			texture = "Interface\\AddOns\\RicoMiniMap\\Shapes\\RoundBlizzard"
			mask = "Interface\\AddOns\\RicoMiniMap\\Shapes\\RoundMask"
			MinimapBorder:SetTexCoord(0, 1, 0, 1)
			MinimapBorder:SetPoint('TOPLEFT', 0, 0)
			MinimapBorder:SetPoint('BOTTOMRIGHT', 0, 0)
		end
		
		if value == 4 then
			texture = "Interface\\AddOns\\RicoMiniMap\\Shapes\\SquareGold"
			mask = "Interface\\AddOns\\RicoMiniMap\\Shapes\\SquareMask"
			MinimapBorder:SetTexCoord(0, 1, 0, 1)
			MinimapBorder:SetPoint('TOPLEFT', -3, 3)
			MinimapBorder:SetPoint('BOTTOMRIGHT', 3, -3)
		end

		if value == 5 then
			texture = "Interface\\AddOns\\RicoMiniMap\\Shapes\\RoundGold"
			mask = "Interface\\AddOns\\RicoMiniMap\\Shapes\\RoundMask"
			MinimapBorder:SetTexCoord(0, 1, 0, 1)
			MinimapBorder:SetPoint('TOPLEFT', 0, 0)
			MinimapBorder:SetPoint('BOTTOMRIGHT', 0, 0)
		end
		
		if RicoMiniMap:IsShowingBorder() then
			MinimapBorder:Show()
			MinimapBorder:SetTexture(texture)
			MinimapBorder:SetDrawLayer("ARTWORK")
		else
			MinimapBorder:Hide()
		end
		Minimap:SetMaskTexture(mask)
		RicoMiniMap:UpdateCoordinatesPosition()
	end
end

function RicoMiniMap:GetCoordinatesPosition()
	if self.db.profile.CoordinatesPosition == nil then
		self.db.profile.CoordinatesPosition = 1
	end
	return self.db.profile.CoordinatesPosition
end

function RicoMiniMap:SetCoordinatesPosition(value)
	self.db.profile.CoordinatesPosition = value
end

function RicoMiniMap:UpdateCoordinatesPosition()
	local value = self.db.profile.CoordinatesPosition
	RicoMinimap_CoordinatesFrame:ClearAllPoints()
	if value == 1 then
		if self.db.profile.Shape == 1 then
			RicoMinimap_CoordinatesFrame:SetPoint("BOTTOM", "Minimap", "BOTTOM", 30, 0)
		else
			RicoMinimap_CoordinatesFrame:SetPoint("BOTTOM", "Minimap", "BOTTOM", 0, 0)
		end
		RicoMinimap_CoordinatesFrame:SetBackdropColor(0, 0, 0, 0)
		RicoMinimap_CoordinatesFrame:SetBackdropBorderColor(0, 0, 0, 0)
	end
	if value == 2 then
		if self.db.profile.Shape == 1 then
			RicoMinimap_CoordinatesFrame:SetPoint("TOP", "Minimap", "BOTTOM", 30, 0)
		else
			RicoMinimap_CoordinatesFrame:SetPoint("TOP", "Minimap", "BOTTOM", 0, 0)
		end
		RicoMinimap_CoordinatesFrame:SetBackdropColor(0, 0, 0, 1)
		RicoMinimap_CoordinatesFrame:SetBackdropBorderColor(0, 0, 0, 1)
	end
	if value == 3 then
		if self.db.profile.Shape == 1 then
			RicoMinimap_CoordinatesFrame:SetPoint("TOP", "Minimap", "TOP", 30, 0)
		else
			RicoMinimap_CoordinatesFrame:SetPoint("TOP", "Minimap", "TOP", 0, 0)
		end
		RicoMinimap_CoordinatesFrame:SetBackdropColor(0, 0, 0, 0)
		RicoMinimap_CoordinatesFrame:SetBackdropBorderColor(0, 0, 0, 0)
	end
	if value == 4 then
		if self.db.profile.Shape == 1 then
			RicoMinimap_CoordinatesFrame:SetPoint("BOTTOM", "Minimap", "TOP", 30, 0)
		else
			RicoMinimap_CoordinatesFrame:SetPoint("BOTTOM", "Minimap", "TOP", 0, 0)
		end
		RicoMinimap_CoordinatesFrame:SetBackdropColor(0, 0, 0, 1)
		RicoMinimap_CoordinatesFrame:SetBackdropBorderColor(0, 0, 0, 1)
	end
end

function RicoMiniMap:IsShowingBorder()
	if self.db.profile.ShowBorder == nil then
		self.db.profile.ShowBorder = true
	end
	return self.db.profile.ShowBorder
end

function RicoMiniMap:ToggleShowingBorder()
	self.db.profile.ShowBorder = not self.db.profile.ShowBorder
	RicoMiniMap:UpdateShape()
	return self.db.profile.ShowBorder
end

function RicoMiniMap:IsShowingMenu()
	if self.db.profile.ShowMenu == nil then
		self.db.profile.ShowMenu = true
	end
	return self.db.profile.ShowMenu
end

function RicoMiniMap:ToggleShowingMenu()
	self.db.profile.ShowMenu = not self.db.profile.ShowMenu
	RicoMiniMap:UpdateMinimapMenu()
	return self.db.profile.ShowMenu
end

function RicoMiniMap:UpdateMinimapMenu()
	if RicoMiniMap:IsShowingMenu() then
		dewdrop:Register(Minimap,
			'children', function()
				dewdrop:FeedAceOptionsTable(RicoMiniMap_OptionTable)
			end
		)
	else
		dewdrop:Unregister(Minimap)
	end
end

function RicoMiniMap:GetPingNotificationType()
	if self.db.profile.PingNotificationType == nil then
		self.db.profile.PingNotificationType = 1
	end
	return self.db.profile.PingNotificationType
end

function RicoMiniMap:SetPingNotificationType(value)
	self.db.profile.PingNotificationType = value
end

-----------------
-- Button movers
--function RicoMiniMap:ButtonDrag(moving)
--	local function getPos()
--		local mapShape = RicoMiniMap:GetShape()
--		local cx, cy = GetCursorPosition(UIParent)
--		local mx, my = Minimap:GetLeft(), Minimap:GetBottom()
--		local z = Minimap:GetEffectiveScale()
--		local vector = (math.deg(math.atan2(cy / z - my - 70, mx - cx / z + 70)))
--		if mapShape == 3 then
--			x = 52 - 81 * cos(vector)
--			y = 81 * sin(vector) - 54
--		else
--			--DEFAULT_CHAT_FRAME:AddMessage(mapShape.."/"..vector)
--			x = 52 - math.max(-81, math.min(110 * cos(vector), 81))
--			y = math.max(-81, math.min(110 * sin(vector), 81)) - 54
--			if mapShape == 1 and vector > -90 and vector < 0 then
--				x = 52 - 81 * cos(vector)
--				y = 81 * sin(vector) - 54
--			end
--		end
--		return x, y
--	end
--	if moving and RicoMiniMap:IsLocked() == false then
--		this.isMoving = true
--		this:SetScript("OnUpdate", function()
--			local x, y = getPos()
--      		this:ClearAllPoints()
--			this:SetPoint("TOPLEFT", Minimap, "TOPLEFT", x, y)
--		end)
--		this:StartMoving()
--	elseif this.isMoving then
--		this.isMoving = false
--		this:StopMovingOrSizing()
--		this:SetScript("OnUpdate", nil)
--	end
--end

--function RicoMiniMap:GetButtonPos(vector)
--	return 52 - 81 * cos(vector), 81 * sin(vector) - 54
--end

--	self.buttons = {
--		b1 = MiniMapBattlefieldFrame,
--		b2 = MiniMapMeetingStoneFrame,
--		b3 = MiniMapWorldMapButton,
--		b4 = MiniMapMailFrame,
--		b6 = MiniMapTrackingFrame,
--		b7 = MinimapZoomIn,
--		b8 = MinimapZoomOut
--	}
--	for _, button in pairs(self.buttons) do
--		button:SetMovable(true)
--		button:RegisterForDrag("LeftButton")
--		button:SetScript("OnDragStart", function() self:ButtonDrag(true) end)
--		button:SetScript("OnDragStop", function() self:ButtonDrag(false) end)
--	end


------------------
-- Coordinates text
function RicoMiniMap_updateLocText()
	RicoMiniMap:SetShowingClock()
	if RicoMiniMap:IsShowingCoordinates() then
		RicoMinimap_CoordinatesFrame:Show()
		local x, y = GetPlayerMapPosition('player')
		if x == 0 and y == 0 then 
			RicoMinimap_CoordinatesText:SetText('')
		else
			if RicoMiniMap:IsShowingCoordinateTenths() then
				RicoMinimap_CoordinatesText:SetText(string.format('%.1f, %.1f', x*100, y*100))
			else
				RicoMinimap_CoordinatesText:SetText(string.format('%.0f, %.0f', x*100, y*100))
			end
		end
		RicoMinimap_CoordinatesFrame:SetWidth(RicoMinimap_CoordinatesText:GetWidth() + 20)
		RicoMinimap_CoordinatesFrame:SetHeight(RicoMinimap_CoordinatesText:GetHeight() + 12)
	else
		RicoMinimap_CoordinatesFrame:Hide()
	end
end

-------------------------------
-- Zooming with the mouse wheel
--Minimap:SetScript(
--"OnMouseWheel", function(self, direction)
--	local zoom, maxZoom = self:GetZoom() + direction, self:GetZoomLevels()
--	self:SetZoom(zoom >= maxZoom and maxZoom or zoom <= 0 and 0 or zoom)
--end
--)
--Minimap:EnableMouseWheel(true)
--Minimap:UnregisterEvent("MINIMAP_UPDATE_ZOOM")

-----------------
-- Event handlers
function RicoMiniMap:MINIMAP_ZONE_CHANGED()
	RicoMiniMap:UpdateShape()
end

function RicoMiniMap:DISPLAY_SIZE_CHANGED()
	RicoMiniMap:UpdateShape()
end

function RicoMiniMap:MINIMAP_PING()
	local NotificationType = RicoMiniMap:GetPingNotificationType()
	if NotificationType > 0 then
		if UnitIsVisible(arg1) == 1 then
			print(UnitName(arg1) .. " pinged the mini-map.")
		end	
	end
end

-- Fubar and Cartographer compatibility
function GetMinimapShape()
  local myShape = RicoMiniMap:GetShape()
	local shape = "CORNER-BOTTOMLEFT"
	if myShape == 2 or 4 then shape = "SQUARE" end
	if myShape == 3 or 5 then shape = "ROUND" end
	return shape
end
