local L = AceLibrary("AceLocale-2.2"):new("RicoMM")

RicoMiniMap_OptionTable = {
	type    = "group",
	handler = RicoMiniMap,
	args = {
		RicoMiniMap_DragLock = {
			type = "toggle",
			order = 1,
			name = L["Locked"],
			desc = L["Prevent dragging the map or buttons"],
			get  = function() return RicoMiniMap:IsLocked() end,
			set  = function() RicoMiniMap:ToggleLocked() end,
		},
		RicoMiniMap_CoordPos={
			type ="group",
			name =L["Coordinates Position"], 
			desc =L["Choose the location of the coordinates"],
			args ={
				CoordPos3 = {
					type = "toggle", 
					name = L["Inside Top"], 
					desc = L["Inside Top"],
					get  = function() return(RicoMiniMap:GetCoordinatesPosition() == 3) end,
					set  = function() RicoMiniMap:SetCoordinatesPosition(3) RicoMiniMap:UpdateCoordinatesPosition() end
				},
				CoordPos4 = {
					type = "toggle", 
					name = L["Outside Top"], 
					desc = L["Outside Top"],
					get  = function() return(RicoMiniMap:GetCoordinatesPosition() == 4) end,
					set  = function() RicoMiniMap:SetCoordinatesPosition(4) RicoMiniMap:UpdateCoordinatesPosition() end
				},
				CoordPos1 = {
					type = "toggle", 
					name = L["Inside Bottom"], 
					desc = L["Inside Bottom"],
					get  = function() return(RicoMiniMap:GetCoordinatesPosition() == 1) end,
					set  = function() RicoMiniMap:SetCoordinatesPosition(1) RicoMiniMap:UpdateCoordinatesPosition() end
				},
				CoordPos2 = {
					type = "toggle", 
					name = L["Outside Bottom"], 
					desc = L["Outside Bottom"],
					get  = function() return(RicoMiniMap:GetCoordinatesPosition() == 2) end,
					set  = function() RicoMiniMap:SetCoordinatesPosition(2) RicoMiniMap:UpdateCoordinatesPosition() end
				},
			},
		},
		RicoMiniMap_Positions = {
			type  = "group",
			order = 2,
			name  = "Position Storage",
			desc  = "Save or Restore positions.",
			args  = {
				Save = {
					type = "execute",
					order = 1,
					name = "Save",
					desc = "Save the positions of the minimap frames.",
					func = "SavePositions",
				},
				Restore = {
					type = "execute",
					order = 2,
					name = "Restore",
					desc = "Restore to saved positions of the minimap frames.",
					func = "RestorePositions",
				},
			},
		},
		RicoMiniMap_Locations = {
			type = "group",
			order = 2.5,
			name = "Location Presets",
			desc = "Move the minimap to preset locations.",
			args = {
				BottomLeft = {
					type = "execute",
					order = 1,
					name = "Bottom Left",
					desc = "Move the minimap to the bottom left corner of the screen.",
					func = "SetMapLocationBL",
				},
				BottomCenter = {
					type = "execute",
					order = 2,
					name = "Bottom Center",
					desc = "Move the minimap to the bottom center of the screen.",
					func = "SetMapLocationBC",
				},
				BottomRight = {
					type = "execute",
					order = 3,
					name = "Bottom Right",
					desc = "Move the minimap to the bottom right corner of the screen.",
					func = "SetMapLocationBR",
				},
				Left = {
					type = "execute",
					order = 4,
					name = "Left",
					desc = "Move the minimap to the left center of the screen.",
					func = "SetMapLocationLC",
				},
				Right = {
					type = "execute",
					order = 5,
					name = "Right",
					desc = "Move the minimap to the right center corner of the screen.",
					func = "SetMapLocationRC",
				},
				TopLeft = {
					type = "execute",
					order = 6,
					name = "Top Left",
					desc = "Move the minimap to the top left corner of the screen.",
					func = "SetMapLocationTL",
				},
				TopCenter = {
					type = "execute",
					order = 7,
					name = "Top Center",
					desc = "Move the minimap to the top center of the screen.",
					func = "SetMapLocationTC",
				},
				TopRight = {
					type = "execute",
					order = 8,
					name = "Top Right",
					desc = "Move the minimap to the top right corner of the screen.",
					func = "SetMapLocationTR",
				}
			},
		},
		RicoMiniMap_Toggles = {
			type = "group",
			order = 3,
			name = "Toggles",
			desc = "Toggles",
			handler = RicoMiniMap,
			args = {
				RicoMiniMap_ZoomButtons = {
					type = "toggle",
					name = L["Show Zoom Buttons"],
					desc = L["Show the zoom in and zoom out buttons"],
					get  = function() return RicoMiniMap:IsShowingZoomButtons() end,
					set  = function() RicoMiniMap:ToggleShowingZoomButtons() end,
				},
				RicoMiniMap_Coordinates = {
					type = "toggle",
					name = L["Show Coordinates"],
					desc = L["Show your location coordiates"],
					get  = function() return RicoMiniMap:IsShowingCoordinates() end,
					set  = function() RicoMiniMap:SetShowingCoordinates("toggle") end,
				},
				RicoMiniMap_CoordinateTenths = {
					type = "toggle",
					name = L["Show Coordinate Tenths"],
					desc = L["Show your location with tenths"],
					get  = function() return RicoMiniMap:IsShowingCoordinateTenths() end,
					set  = function() RicoMiniMap:ToggleShowingCoordinateTenths() end,
				},
				RicoMiniMap_MapButton = {
					type = "toggle",
					name = L["Show Map Button"],
					desc = L["Show the world map button"],
					get  = function() return RicoMiniMap:IsShowingMapButton() end,
					set  = function() RicoMiniMap:SetShowingMapButton("toggle") end,
				},
				RicoMiniMap_TimeButton = {
					type = "toggle",
					name = L["Show Time Button"],
					desc = L["Show the time button"],
					get  = function() return RicoMiniMap:IsShowingTimeButton() end,
					set  = function() RicoMiniMap:SetShowingTimeButton("toggle") end,
				},
				RicoMiniMap_ClockButton = {
					type = "toggle",
					name = L["ShowClock"],
					desc = L["ShowClock"],
					get  = function() return RicoMiniMap:IsShowingClock() end,
					set  = function() RicoMiniMap:SetShowingClock("toggle") end,
				},
				RicoMiniMap_TrackingButton = {
					type = "toggle",
					name = L["Show Tracking Button"],
					desc = L["Show the tracking button"],
					get  = function() return RicoMiniMap:IsShowingTrackingButton() end,
					set  = function() RicoMiniMap:ToggleShowingTrackingButton() end,
				},
				RicoMiniMap_MailButton = {
					type = "toggle",
					name = L["Show Mail Button"],
					desc = L["Show the mail button"],
					get  = function() return RicoMiniMap:IsShowingMailButton() end,
					set  = function() RicoMiniMap:SetShowingMailButton("toggle") end,
				},
				RicoMiniMap_ZoneLabel = {
					type = "toggle",
					name = L["Show Zone Text"],
					desc = L["Show the default zone text"],
					get  = function() return RicoMiniMap:IsShowingZoneText() end,
					set  = function() RicoMiniMap:ToggleShowingZoneText() end,
				},
				RicoMiniMap_Border = {
					type = "toggle",
					name = L["Show Minimap Border"],
					desc = L["Toggle the minimap border"],
					get  = function() return RicoMiniMap:IsShowingBorder() end,
					set  = function() RicoMiniMap:ToggleShowingBorder() end,
				},
				RicoMiniMap_RCMenu = {
					type = "toggle",
					name = L["Show Menu"],
					desc = L["Toggle showing the menu on right-click.  '/rmm menu' to re-enable"],
					get  = function() return RicoMiniMap:IsShowingMenu() end,
					set  = function() RicoMiniMap:ToggleShowingMenu() end,
				},
				RicoMiniMap_WatchFrameToggle = {
					type = "toggle", 
					name = "Show Quest Watcher", 
					desc = "Turn off the Quest Watcher frame.",
					get  = function() return RicoMiniMap:IsShowingQuestWatcher() end,
					set  = function() RicoMiniMap:SetShowingQuestWatcher("toggle") end
				},
			},
		},
		RicoMiniMap_ZoneTextLocation = {
			type = "range",
			name = L["Zone Text Location"],
			desc = L["Set the location of the zone text"],
			max = 0,
			min = -30,
			step = 1,
			get = "GetZoneTextLocation",
			set = "SetZoneTextLocation",
		},
		
		RicoMiniMap_Shape={
			type ="group",
			name =L["Shape"], 
			desc =L["Choose the shape of the minimap"],
			args ={
				Shape1 = {
					type = "toggle", 
					name = L["Bottom Left"], 
					desc = L["Bottom Left corner is rounded"],
					get  = function() return(RicoMiniMap:GetShape() == 1) end,
					set  = function() RicoMiniMap:SetShape(1) RicoMiniMap:UpdateShape() end
				},
				Shape2 = {
					type = "toggle", 
					name = L["Square"], 
					desc = L["All four corners square"],
					get  = function() return(RicoMiniMap:GetShape() == 2) end,
					set  = function() RicoMiniMap:SetShape(2) RicoMiniMap:UpdateShape() end
				},
				Shape4 = {
					type = "toggle", 
					name = "Square Gold", 
					desc = "Square with gold frame",
					get  = function() return(RicoMiniMap:GetShape() == 4) end,
					set  = function() RicoMiniMap:SetShape(4) RicoMiniMap:UpdateShape() end
				},
				Shape3 = {
					type = "toggle", 
					name = L["Round"], 
					desc = L["All four corners round"],
					get  = function() return(RicoMiniMap:GetShape() == 3) end,
					set  = function() RicoMiniMap:SetShape(3) RicoMiniMap:UpdateShape() end
				},
				Shape5 = {
					type = "toggle", 
					name = "Round Gold", 
					desc = "Round gold border",
					get  = function() return(RicoMiniMap:GetShape() == 5) end,
					set  = function() RicoMiniMap:SetShape(5) RicoMiniMap:UpdateShape() end
				},
			},
		},
		RicoMiniMap_Strata = {
			type = "range",
			name = L["Strata"],
			desc = L["Change the minimap strata"],
			max = 8, 
			min = 1,
			step = 1,
			get = "GetMapStrata",
			set = "SetMapStrata",
		},
		RicoMiniMap_Scale = {
			type = "range",
			name = L["Scale"],
			desc = L["Scale the minimap from 50% to 250% in 1% increments"],
			max = 2.5, 
			min = 0.5,
			step = 0.01,
			isPercent = true,
			get = "GetMapScale",
			set = "SetMapScale",
		},
		RicoMiniMap_Alpha = {
			type = "range",
			name = L["Transparency"],
			desc = L["Set the transparency of the MiniMap"],
			max = 1,
			min = 0.1,
			step = 0.05,
			get = "GetAlpha",
			set = "SetAlpha",
		},
		RicoMiniMap_PingNotificationType={
			type ="group",
			name =L["PingNotificationType"], 
			desc =L["Choose the ping notification type"],
			args ={
				Shape1 = {
					type = "toggle", 
					order= 1, 
					name = L["None"], 
					desc = L["Don't display who pinged."],
					get  = function() return(RicoMiniMap:GetPingNotificationType() == 0) end,
					set  = function() RicoMiniMap:SetPingNotificationType(0) end
				},
				Shape2 = {
					type = "toggle", 
					order= 2, 
					name = L["Default Chat"], 
					desc = L["Identify who pinged in default chat."],
					get  = function() return(RicoMiniMap:GetPingNotificationType() == 1) end,
					set  = function() RicoMiniMap:SetPingNotificationType(1) end
				},
			},
		},
		RicoMiniMap_WatchFrameScale = {
			type = "range",
			name = L["WatchFrameScale"],
			desc = L["Scale the WatchFrame from 50% to 150% in 1% increments"],
			max = 1.5, 
			min = 0.5,
			step = 0.01,
			isPercent = true,
			get = "GetWatchFrameScale",
			set = "SetWatchFrameScale",
		},
		RicoMiniMap_WatchFrameHeight = {
			type = "range",
			name = L["WatchFrameHeight"],
			desc = L["Set the WatchFrame height to show more quests"],
			max = 1000, 
			min = 200,
			step = 5,
			isPercent = false,
			get = "GetWatchFrameHeight",
			set = "SetWatchFrameHeight",
		},
	},
}
