local dropDown = CreateFrame("Frame", "ReportsDropDown", UIParent, "UIDropDownMenuTemplate")

UIDropDownMenu_Initialize(dropDown, function(self, level, menuList)
	local info = UIDropDownMenu_CreateInfo()
		info.notCheckable = true

		info.text = "Missions"
		info.func = function()
			if (GarrisonLandingPage and GarrisonLandingPage:IsShown()) then
				HideUIPanel(GarrisonLandingPage)
			end
			ShowGarrisonLandingPage(LE_GARRISON_TYPE_8_0)
		end
		UIDropDownMenu_AddButton(info)

		info.text = "Class Hall Report"
		info.func = function()
			if (GarrisonLandingPage and GarrisonLandingPage:IsShown()) then
				HideUIPanel(GarrisonLandingPage)
			end
			ShowGarrisonLandingPage(LE_GARRISON_TYPE_7_0)
		end
		UIDropDownMenu_AddButton(info)

		info.text = "Garrison Report"
		info.func = function()
			if (GarrisonLandingPage and GarrisonLandingPage:IsShown()) then
				HideUIPanel(GarrisonLandingPage)
			end
			ShowGarrisonLandingPage(LE_GARRISON_TYPE_6_0)
		end
		UIDropDownMenu_AddButton(info)
end, "MENU")

GarrisonLandingPageMinimapButton:SetScript("OnClick", function(self, button, down)
	if button == "RightButton" then
		ToggleDropDownMenu(1, nil, dropDown, "Minimap", 0, -20)
	else
		CloseDropDownMenus()
		GarrisonLandingPage_Toggle()
	end
end)

GarrisonLandingPageMinimapButton:HookScript("OnEnter", function()
	if MouseIsOver(GarrisonLandingPageMinimapButton) then
		GameTooltip:AddLine("Right click for list of reports")
		GameTooltip:Show()
	end
end)
GarrisonLandingPageMinimapButton:RegisterForClicks("LeftButtonUp", "RightButtonUp")