function RepChanged_OnEvent(self, event, ...)
	-- First parse the faction and the rep gained.
	local x = {...};
	local message = x[1];
	start, finish, factionName, reputationGained = string.find(message, "Reputation with (.+) increased by (.+).");
	--print("Faction: " .. factionName .. " Reputation:" .. reputationGained);
	
	-- Now find the faction in the faction collection.
	local factionIndex = 1
	local lastFactionName
	repeat
		local name, description, standingId, bottomValue, topValue, earnedValue, atWarWith,
		canToggleAtWar, isHeader, isCollapsed, hasRep, isWatched, isChild = GetFactionInfo(factionIndex)
		if name == lastFactionName then break end
		lastFactionName  = name
		-- if we have found the correct faction then we need to do math.
		if lastFactionName == factionName then
			--print(lastFactionName);
			local reputationTillNextLevel = topValue - earnedValue;
			--print(reputationTillNextLevel);
			--at this point I should take into consideration the player's bonus rep.
			
			
			-- if human then take into consideration the rep bonus
			local guid = UnitGUID("player")
			local locClass, engClass, locRace, engRace, gender = GetPlayerInfoByGUID(guid)
			if engRace == "Human" then
				local baseRep = (reputationGained * 0.9)	
				baseRep = tonumber(string.format("%.0f",baseRep))
				--print ("Base Reputation: " .. baseRep);
				
				local humanKillsTillNextLevel = reputationTillNextLevel / (baseRep*1.1);	
				print (lastFactionName .. ": ".. string.format("%.0f",humanKillsTillNextLevel) .. " more remaining.");	
			else
				local killsTillNextLevel = reputationTillNextLevel / reputationGained;
				print (lastFactionName .. ": ".. string.format("%.0f",killsTillNextLevel) .. " more remaining.");
			end
			
			
			break;
		end
		factionIndex = factionIndex + 1
	until factionIndex > 200
end