--List of changes to remind myself when updating Curseforge
--
-- [X] 1. Top 3 added to title tooltip 
-- [X] 2. Mode Icons added to titles
-- [X] 2.1 Scalable 14-20
-- [X] 3. Darken window when selecting mode
-- [X] 4. Titlebar Button Hiding/Fading
-- upload 701002_2
-- [ ] 5. Selectable icon sets
-- [ ] 6. Editable Mode names
-- [ ] 7. Seperate Font for titles

_G["RecountSkin"] = {}
local me=RecountSkin
--ACE comes with recount, no need to stress cus we are dependant :-)
--to get localized string for the MainWindowDataModes
  local AceLocale = LibStub("AceLocale-3.0")
  local L = AceLocale:GetLocale("Recount")
--Also installed with Recount
  local SM = LibStub:GetLibrary("LibSharedMedia-3.0")
  
function me:FixCheckButton(control, text)
  control:SetSize(22,22)
  control:SetNormalTexture("Interface\\AddOns\\RecountSkinByNth\\textures\\check_normal")
  control:SetCheckedTexture("Interface\\AddOns\\RecountSkinByNth\\textures\\check_checked")
  control:SetDisabledCheckedTexture("Interface\\AddOns\\RecountSkinByNth\\textures\\check_checked_disabled")
  control:SetDisabledTexture("Interface\\AddOns\\RecountSkinByNth\\textures\\check_disabled")
  control:SetHighlightTexture("Interface\\AddOns\\RecountSkinByNth\\textures\\check_highlight")
--Removes (hides) All Textures from a frame
	local Rgns = { control:GetRegions() };
	for _, rgn in ipairs(Rgns) do
	  if rgn:GetObjectType()=="Texture" and rgn:GetDrawLayer()~="HIGHLIGHT" then rgn:SetBlendMode("BLEND") end
	end--do  
  if control.Text then
    control.Text:SetTextColor(1,1,1)
	if text then
      control.Text:SetText(text)
	end
  end
end--function

function me:FixFilterInfoButton(filterInfoButton, index)
local scale=0.7
  filterInfoButton:SetSize(20*scale,55*scale)
  filterInfoButton.texture:SetTexture("Interface\\AddOns\\RecountSkinByNth\\textures\\filtertext")
  filterInfoButton.texture:SetSize(20*scale,55*scale)
  filterInfoButton.texture:ClearAllPoints()
  filterInfoButton.texture:SetPoint("BOTTOM")
  filterInfoButton.texture:SetAlpha(0.3)
  filterInfoButton.texture:SetTexCoord(((index-1)*20)/128, (index*20)/128, (128-55)/128, 1)
  filterInfoButton.highlight=filterInfoButton:CreateTexture(nil,"HIGHLIGHT")
  filterInfoButton.highlight:SetSize(20*scale,55*scale)
  filterInfoButton.highlight:SetTexture("Interface\\AddOns\\RecountSkinByNth\\textures\\filtertext")
  filterInfoButton.highlight:SetPoint("BOTTOM")
  filterInfoButton.highlight:SetAlpha(0.3)
  filterInfoButton.highlight:SetTexCoord(((index-1)*20)/128, (index*20)/128, (128-55)/128, 1)
  filterInfoButton.highlight:SetBlendMode("ADD")
end--function

function me:FixFilterButton(filterButton)
  --filterButton.Background=filterButton:CreateTexture(nil,"BACKGROUND")
  --filterButton.Background:SetAllPoints()
  --filterButton.Background:SetColorTexture(1,1,1,1)
  me:FixCheckButton(filterButton.ShowData)		--show in main window
  me:FixCheckButton(filterButton.RecordData)	--record data
  me:FixCheckButton(filterButton.RecordTime)	--record time data
  me:FixCheckButton(filterButton.TrackDeaths)	--record death
  me:FixCheckButton(filterButton.TrackBuffs)	--record buffs
  
  filterButton.ShowData:ClearAllPoints()
  filterButton.RecordData:ClearAllPoints()
  filterButton.RecordTime:ClearAllPoints()
  filterButton.TrackDeaths:ClearAllPoints()
  filterButton.TrackBuffs:ClearAllPoints()
  filterButton.Label:ClearAllPoints()
  
  filterButton.ShowData:SetPoint("RIGHT",-72-10,0)
  filterButton.RecordData:SetPoint("RIGHT",-54-10,0)
  filterButton.RecordTime:SetPoint("RIGHT",-36-10,0)
  filterButton.TrackDeaths:SetPoint("RIGHT",-18-10,0)
  filterButton.TrackBuffs:SetPoint("RIGHT",0-10,0)
  filterButton.Label:SetPoint("RIGHT",-96-10,0)
  
  filterButton.Label:SetTextColor(1,1,1,0.3)
end--funtion

function me:disableFilterChecks(filterButton,enable)
  if enable then
    filterButton.RecordTime:Enable()
    filterButton.TrackDeaths:Enable()
    filterButton.TrackBuffs:Enable()
  else
    filterButton.RecordTime:Disable()
    filterButton.TrackDeaths:Disable()
    filterButton.TrackBuffs:Disable() 
  end
end--function

function me:FixButton(button,width,height)
    if width then button:SetWidth(width) end
	if height then button:SetHeight(height) end
  --Removes (hides) All Textures from a frame
	local Rgns = { button:GetRegions() };
	for _, rgn in ipairs(Rgns) do if rgn:IsObjectType("texture") and rgn:GetDrawLayer()~="HIGHLIGHT" then rgn:SetTexture(""); rgn:Hide() end end--do
    button.Left:SetTexture("");button.Middle:SetTexture("");button.Right:SetTexture("")
    button:SetBackdrop({bgFile = "Interface\\AddOns\\RecountSkinByNth\\textures\\menu_button_background", edgeFile = "Interface\\AddOns\\RecountSkinByNth\\textures\\menu_button_border", tile = true, tileSize = 8, edgeSize = 8, insets = { left = 8, right = 8, top = 8, bottom = 8 }});
	button:SetBackdropColor(0.2,0.2,0.2,1);
	button:SetBackdropBorderColor(0.2,0.2,0.2,1);
	button:SetHighlightTexture("Interface\\AddOns\\RecountSkinByNth\\textures\\menu_button_highlight")
end--function

function me:RemoveAllTexturesFromFrame(frm)
  --Removes (hides) All Textures from a frame
	local Rgns = { frm:GetRegions() };
	for _, rgn in ipairs(Rgns) do
	  if rgn:IsObjectType("texture") and rgn:GetDrawLayer()~="HIGHLIGHT" then rgn:SetTexture(""); rgn:Hide() end
	end--do
end--function

function me:FixFrameBackdrop(frm,col)
    frm:SetBackdrop({bgFile = "Interface\\AddOns\\RecountSkinByNth\\textures\\background", edgeFile = "Interface\\AddOns\\RecountSkinByNth\\textures\\border", tile = true, tileSize = 16, edgeSize = 16, insets = { left = 16, right = 16, top = 16, bottom = 16 }});
	frm:SetBackdropColor(col or 0.1, col or 0.1, col or 0.1, 1);
	frm:SetBackdropBorderColor(col or 0.1, col or 0.1, col or 0.1, 1);
end--function


function me:FixButtonTextures(button,r,g,b,width,height)
  if button.Left then button.Left:Hide() end
  if button.Middle then button.Middle:Hide() end
  if button.Right then button.Right:Hide() end
  if width then button:SetWidth(width) end
  if height then button:SetHeight(height) end
  
    button.Background=CreateFrame("Frame",nil,button)
	button.Background:SetPoint("TOPLEFT",-5,5)
	button.Background:SetPoint("BOTTOMRIGHT",5,-5)
	button.Background:SetFrameLevel(button:GetFrameLevel()-1)
	me:FixFrameBackdrop(button.Background)
    button.Background:SetBackdropBorderColor(r or 1,g or 1,b or 1)
	button.Background:SetBackdropColor(r or 1,g or 1,b or 1)
	button.Background.Fade=button.Background:CreateTexture(nil,"ARTWORK")
	button.Background.Fade:SetPoint("TOPLEFT",button.Background,"LEFT",9,1)
	button.Background.Fade:SetPoint("BOTTOMRIGHT",-9,7)
	button.Background.Fade:SetColorTexture(1,1,1)
	button.Background.Fade:SetGradientAlpha("VERTICAL",0,0,0,0,0,0,0,0.2)
end--function

function me:FixColorSwatch(swatch)
  swatch:SetSize(33,22)
  
  swatch.Key:SetSize(22,11)
  swatch.Key:SetDrawLayer("BACKGROUND")
  swatch.Key:ClearAllPoints()
  swatch.Key:SetPoint("LEFT",5,0)
  
  swatch.border=swatch:CreateTexture(nil,"OVERLAY")
  swatch.border:SetSize(44,22)
  swatch.border:SetPoint("TOPLEFT")
  swatch.border:SetTexture("Interface\\AddOns\\RecountSkinByNth\\textures\\swatch")
  swatch.Text:ClearAllPoints()
  swatch.Text:SetPoint("LEFT",35,0)
  swatch.Text:SetTextColor(1,1,1)
  
  swatch.Highlight=swatch:CreateTexture(nil,"HIGHLIGHT")
  swatch.Highlight:SetSize(44,22)
  swatch.Highlight:SetPoint("TOPLEFT")
  swatch.Highlight:SetBlendMode("ADD")
  swatch.Highlight:SetTexture("Interface\\AddOns\\RecountSkinByNth\\textures\\swatch_highlight")
  swatch.Background:SetColorTexture(0,0,0,0)
end--function

function me:FixSlider(slider,sliderName,width)
  slider:SetSize(180,22)
  if width then slider:SetWidth(width) end
  slider:SetBackdropColor(1,1,1,0)
  slider:SetBackdropBorderColor(1,1,1,0)
  slider:SetThumbTexture("Interface\\AddOns\\RecountSkinByNth\\textures\\slider_thumb")
  slider.Background=slider:CreateTexture(nil,"BACKGROUND")
  slider.Background:SetAllPoints()
  slider.Background:SetTexture("Interface\\AddOns\\RecountSkinByNth\\textures\\slider_background")
  
  _G[sliderName.."Text"]:ClearAllPoints()
  _G[sliderName.."Text"]:SetPoint("BOTTOMLEFT",slider,"TOPLEFT",0,0)
  _G[sliderName.."Text"]:SetTextColor(1,1,1,1)
  
  _G[sliderName.."Low"]:ClearAllPoints()
  _G[sliderName.."Low"]:SetPoint("LEFT",7,0)
  _G[sliderName.."Low"]:SetTextColor(0,0,0,1)
  _G[sliderName.."Low"]:SetShadowColor(0,0,0,0)
  _G[sliderName.."High"]:ClearAllPoints()
  _G[sliderName.."High"]:SetPoint("RIGHT",-7,0)
  _G[sliderName.."High"]:SetTextColor(0,0,0,1)
  _G[sliderName.."High"]:SetShadowColor(0,0,0,0)
end--function

function me:FixVerticalScrollBar(scrollbar, noBg, height)
      if not noBg then
	  scrollbar:SetBackdrop({bgFile = "Interface\\AddOns\\RecountSkinByNth\\textures\\menu_button_background", edgeFile = "", tile = true, tileSize = 8, edgeSize = 8, insets = { left = 0, right = 0, top = 0, bottom = 0 }});
	  scrollbar:SetBackdropColor(0,0,0,0.25);
	  end--if
	  
	  _G[scrollbar:GetName().."ThumbTexture"]:SetTexture("Interface\\AddOns\\RecountSkinByNth\\textures\\scroll_thumb_normal")
	  _G[scrollbar:GetName().."ThumbTexture"]:SetVertexColor(1,1,1,1)
	  _G[scrollbar:GetName().."ScrollUpButton"]:SetHeight(height or 16)
	  _G[scrollbar:GetName().."ScrollUpButton"]:SetNormalTexture("Interface\\AddOns\\RecountSkinByNth\\textures\\scroll_up_normal")
	  _G[scrollbar:GetName().."ScrollUpButton"]:SetDisabledTexture("Interface\\AddOns\\RecountSkinByNth\\textures\\scroll_up_disabled")
	  _G[scrollbar:GetName().."ScrollUpButton"]:SetPushedTexture("Interface\\AddOns\\RecountSkinByNth\\textures\\scroll_up_pushed")
	  _G[scrollbar:GetName().."ScrollUpButton"]:SetHighlightTexture("Interface\\AddOns\\RecountSkinByNth\\textures\\scroll_button_highlight")
	  
	  _G[scrollbar:GetName().."ScrollDownButton"]:SetHeight(height or 16)
	  _G[scrollbar:GetName().."ScrollDownButton"]:SetNormalTexture("Interface\\AddOns\\RecountSkinByNth\\textures\\scroll_down_normal")
	  _G[scrollbar:GetName().."ScrollDownButton"]:SetDisabledTexture("Interface\\AddOns\\RecountSkinByNth\\textures\\scroll_down_disabled")
	  _G[scrollbar:GetName().."ScrollDownButton"]:SetPushedTexture("Interface\\AddOns\\RecountSkinByNth\\textures\\scroll_down_pushed")
	  _G[scrollbar:GetName().."ScrollDownButton"]:SetHighlightTexture("Interface\\AddOns\\RecountSkinByNth\\textures\\scroll_button_highlight")
	  
	  local Rgns = { _G[scrollbar:GetName().."ScrollDownButton"]:GetRegions() };
	  for _, rgn in ipairs(Rgns) do if rgn:IsObjectType("texture") then rgn:SetVertexColor(1,1,1,1) end end--do
	  local Rgns = { _G[scrollbar:GetName().."ScrollUpButton"]:GetRegions() };
	  for _, rgn in ipairs(Rgns) do if rgn:IsObjectType("texture") then rgn:SetVertexColor(1,1,1,1) end end--do
end--function


local createBars=17
local maxBars = createBars
local createFonts=17
local maxFonts = createFonts

function me:SortSharedMediaFonts()
    local frame=Recount.ConfigWindow.Appearance
    local margin=200
	--local offset
    local sectionList = SM:List("font")
	local maxNumber = table.getn(sectionList)
    if maxNumber<createFonts then createFonts=maxNumber end
	frame.font={}
  --Make a new Label
    if not(Recount.ConfigWindow.Appearance.FontLabel) then
      Recount.ConfigWindow.Appearance.FontLabel = Recount.ConfigWindow.Appearance:CreateFontString(nil,"ARTWORK","GameFontNormal")
	  Recount.ConfigWindow.Appearance.FontLabel:SetText(L["Font Selection"])
	  Recount.ConfigWindow.Appearance.FontLabel:SetTextColor(1,1,1,0.3)
	  Recount.ConfigWindow.Appearance.FontLabel:SetPoint("TOPLEFT",margin + 8, -4)
	end
  --Make all the selection stuff
    for i = 1, createFonts do
	  if not frame.font[i] then
	    frame.font[i] = CreateFrame("Frame",nil,frame)
	    frame.font[i].Text = frame.font[i]:CreateFontString(nil,"ARTWORK","GameFontNormal")
	    frame.font[i].Text:SetPoint("LEFT",4,0)
	    frame.font[i].Text:SetPoint("RIGHT",-4,0)
	    frame.font[i].Text:SetJustifyH("LEFT")
	    frame.font[i].Text:SetWordWrap(false)
	    frame.font[i].Texture = frame.font[i]:CreateTexture(nil,"BACKGROUND")
	    frame.font[i].Texture:SetAllPoints()
	    frame.font[i].Texture:SetColorTexture(0,0.75,1,0.1)
	    frame.font[i].Highlight = frame.font[i]:CreateTexture(nil,"HIGHLIGHT")
	    frame.font[i].Highlight:SetPoint("TOPLEFT",-10,4)
	    frame.font[i].Highlight:SetPoint("BOTTOMRIGHT",10,-4)
	    frame.font[i].Highlight:SetAlpha(0.3)
	    frame.font[i].Highlight:SetBlendMode("ADD")
	    frame.font[i].Highlight:SetTexture("Interface\\AddOns\\RecountSkinByNth\\textures\\swatch_highlight")
	    frame.font[i].Highlight:SetTexCoord(0,48/64,0,1)
	    frame.font[i]:EnableMouse(true)
	    frame.font[i]:SetSize(184,13)
	    frame.font[i]:SetPoint("TOPLEFT", margin+8,-20-((i-1)*14))
	    frame.font[i]:SetScript("OnMouseDown", function(this) Recount:SetFont(this.SetTo); me:UpdateFontList() end)--SetScript
	    frame.font[i]:SetScript("OnEnter", function(this) if this.Text:IsTruncated() then GameTooltip:SetOwner(this,"ANCHOR_TOPLEFT");GameTooltip:AddLine(this.Text:GetText()); GameTooltip:SetScale(0.7); GameTooltip:Show() end end)--SetScript
	    frame.font[i]:SetScript("OnLeave", function(this) GameTooltip:SetScale(1); GameTooltip:Hide() end)--SetScript
	  end
	end
  --Make a ScrollBar if there are not room for all Fonts  
	if not frame.FontScrollBar then
	  frame.FontScrollBar = CreateFrame("SCROLLFRAME", "SkinByNth_FontScrollBar", frame, "FauxScrollFrameTemplate")
	  frame.FontScrollBar:SetScript("OnVerticalScroll", function(self, offset) FauxScrollFrame_OnVerticalScroll(self, offset, 12, me.RefreshFontList) end)
	  frame.FontScrollBar:SetSize(1,createFonts*14)
	  frame.FontScrollBar:SetPoint("TOPLEFT",frame,"TOPLEFT",margin + 174, -20)
      me:FixVerticalScrollBar(SkinByNth_FontScrollBarScrollBar)
	  frame.FontScrollBar:Hide()
	end
	if maxNumber > maxFonts then
	  for i=1,createFonts do frame.font[i]:SetWidth(170) end
	  frame.FontScrollBar:Show()
	end
	me.RefreshFontList()
end--function

function me.RefreshFontList()
	local sectionList = SM:List("font")
	local maxNumber = table.getn(sectionList)
	FauxScrollFrame_Update(SkinByNth_FontScrollBar, maxNumber, createFonts, 12)
	local offset = FauxScrollFrame_GetOffset(SkinByNth_FontScrollBar)
	for i = 1, createFonts do
	  local name =  sectionList[i+offset]
	  if name=="" or not(strfind(name,"[%a|%d]")) then name="Unknown Name" end
	  Recount.ConfigWindow.Appearance.font[i].Text:SetFont(SM:Fetch("font", sectionList[i+offset]), 12)
	  Recount.ConfigWindow.Appearance.font[i].SetTo = sectionList[i+offset]
      Recount.ConfigWindow.Appearance.font[i].Text:SetText(name)  
	end
	me:UpdateFontList()
end--function

function me:UpdateFontList()
  for _, font in pairs(Recount.ConfigWindow.Appearance.font) do
    if font.SetTo == Recount.db.profile.Font then
      font.Text:SetTextColor(1, 1, 1,1)
      font.Texture:Show()
    else
	  font.Text:SetTextColor(1,1,1,0.4)
	  font.Texture:Hide()
	end
  end
end--function





function me:SortSharedMediaBars(frame)
        local frame=Recount.ConfigWindow.Appearance
    local margin=400
	--local offset
    local sectionList = SM:List("statusbar")
	local maxNumber = table.getn(sectionList)
	if maxNumber<createBars then createBars=maxNumber end
	frame.bar={}
  --Make a new Label
    if not Recount.ConfigWindow.Appearance.BarLabel then
      Recount.ConfigWindow.Appearance.BarLabel = Recount.ConfigWindow.Appearance:CreateFontString(nil,"ARTWORK","GameFontNormal")
	  Recount.ConfigWindow.Appearance.BarLabel:SetText(L["Bar Selection"])
	  Recount.ConfigWindow.Appearance.BarLabel:SetTextColor(1,1,1,0.3)
	  Recount.ConfigWindow.Appearance.BarLabel:SetPoint("TOPLEFT",margin + 8, -4)
	end
  --Make all the selection stuff
    for i = 1, createBars do
	  if not frame.bar[i] then
	    frame.bar[i] = CreateFrame("Frame",nil,frame)
	    frame.bar[i].Text = frame.bar[i]:CreateFontString(nil,"ARTWORK","GameFontNormal")
	    frame.bar[i].Text:SetPoint("LEFT",4,0)
	    frame.bar[i].Text:SetPoint("RIGHT",-4,0)
	    frame.bar[i].Text:SetJustifyH("LEFT")
	    frame.bar[i].Text:SetWordWrap(false)
	    frame.bar[i].Texture = frame.bar[i]:CreateTexture(nil,"BACKGROUND")
	    frame.bar[i].Texture:SetAllPoints()
	    frame.bar[i].Texture:SetColorTexture(0,0.75,1,0.1)
	    frame.bar[i].Highlight = frame.bar[i]:CreateTexture(nil,"HIGHLIGHT")
	    frame.bar[i].Highlight:SetPoint("TOPLEFT",-10,4)
	    frame.bar[i].Highlight:SetPoint("BOTTOMRIGHT",10,-4)
	    frame.bar[i].Highlight:SetAlpha(0.3)
	    frame.bar[i].Highlight:SetBlendMode("ADD")
	    frame.bar[i].Highlight:SetTexture("Interface\\AddOns\\RecountSkinByNth\\textures\\swatch_highlight")
	    frame.bar[i].Highlight:SetTexCoord(0,48/64,0,1)
	    frame.bar[i]:EnableMouse(true)
	    frame.bar[i]:SetSize(184,13)
	    frame.bar[i]:SetPoint("TOPLEFT", margin+8,-20-((i-1)*14))
	    frame.bar[i]:SetScript("OnMouseDown", function(this) Recount:SetBarTextures(this.SetTo); me:UpdateBarList() end)--SetScript
	    frame.bar[i]:SetScript("OnEnter", function(this) if this.Text:IsTruncated() then GameTooltip:SetOwner(this,"ANCHOR_TOPLEFT");GameTooltip:AddLine(this.Text:GetText()); GameTooltip:SetScale(0.7); GameTooltip:Show() end end)--SetScript
	    frame.bar[i]:SetScript("OnLeave", function(this) GameTooltip:SetScale(1); GameTooltip:Hide() end)--SetScript
	  end
	end
  --Make a ScrollBar if there are not room for all Fonts  
	if not frame.BarScrollBar then
	  frame.BarScrollBar = CreateFrame("SCROLLFRAME", "SkinByNth_BarScrollBar", frame, "FauxScrollFrameTemplate")
	  frame.BarScrollBar:SetScript("OnVerticalScroll", function(self, offset) FauxScrollFrame_OnVerticalScroll(self, offset, 12, me.RefreshBarList) end)
	  frame.BarScrollBar:SetSize(1,createBars*14)
	  frame.BarScrollBar:SetPoint("TOPLEFT",frame,"TOPLEFT",margin + 174, -20)
      me:FixVerticalScrollBar(SkinByNth_BarScrollBarScrollBar)
	  frame.BarScrollBar:Hide()
	end
	if maxNumber>maxBars then
	  for i=1,createBars do frame.bar[i]:SetWidth(170) end
	  frame.BarScrollBar:Show()
	end
	me.RefreshBarList()
end--function

function me.RefreshBarList()
	local sectionList = SM:List("statusbar")
	local maxNumber = table.getn(sectionList)
	FauxScrollFrame_Update(SkinByNth_BarScrollBar, maxNumber, createBars, 12)
	local offset = FauxScrollFrame_GetOffset(SkinByNth_BarScrollBar)
	for i = 1, createBars do
	  local name =  sectionList[i+offset]
	  if name=="" or not(strfind(name,"[%a|%d]")) then name="Unknown Name" end
	  Recount.ConfigWindow.Appearance.bar[i].Texture:SetTexture(SM:Fetch("statusbar", sectionList[i+offset]), 12)
	  Recount.ConfigWindow.Appearance.bar[i].SetTo = sectionList[i+offset]
      Recount.ConfigWindow.Appearance.bar[i].Text:SetText(name)  
	end
	me:UpdateBarList()
end--function

function me:UpdateBarList()
  for _, bar in pairs(Recount.ConfigWindow.Appearance.bar) do
    if bar.SetTo == Recount.db.profile.BarTexture then
      bar.Text:SetTextColor(1, 1, 1,1)
      bar.Texture:SetVertexColor(0,0.3,0.4,1)
    else
	  bar.Text:SetTextColor(1,1,1,0.5)
	  local _,Class =UnitClass("player")
	  local color = Recount.db.profile.Colors.Class[Class] or Recount.Colors:GetColor("Class", Class)
	  bar.Texture:SetVertexColor(color.r, color.g, color.b,1)
	end
  end
end--function


