-- variables --
local RG_AltGold = 0
local RG_MyGold = 0 -- this is needed because GetMoney can't be called when leaving world
local ver = GetAddOnMetadata("Realm_Gold","Version") or '1.0'
	DEFAULT_CHAT_FRAME:AddMessage(string.format("|cff00ccff%s|r [v|cff00ccff%s|r] Loaded", "Realm_Gold", ver or "1.0"))
---------------

-- create main frame --
local RGFrame = CreateFrame("Frame", "RGFrame", UIParent)
RGFrame:SetWidth(130)
RGFrame:SetHeight(20)
-----------------------

-- create and position money frame --
local RGMoney = CreateFrame("Frame", "RGMoney", RGFrame, "SmallMoneyFrameTemplate")
-- RGMoney:SetPoint("CENTER", "RGFrame", "CENTER", 0, 0)
RGMoney:SetFrameStrata("LOW") -- needed to be able to drag by money frame as well as main
MoneyFrame_SetType(RGMoney, "STATIC") -- seems to be necessary so that the total isn't wiped out when opening a mail box
-------------------------------------
	
local function RG_Init()

	if (Docked == nil) then
		Docked = false
	end

	_G["DockedCheck"]:SetChecked(Docked)

	if (Docked) then -- Docked to Bag 0
		RGFrame:SetParent(ContainerFrame1)

		-- set frame offset
		if ( (XDockOffset) and (YDockOffset) ) then
			RGFrame:SetPoint("BOTTOMRIGHT", ContainerFrame1, "BOTTOMRIGHT", XDockOffset, YDockOffset)
		else
			RGFrame:SetPoint("BOTTOMRIGHT", ContainerFrame1, "BOTTOMRIGHT", -30, -20)
		end
	else -- not docked
		-- set frame offset
		if ( (XOffset) and (YOffset) ) then
			RGFrame:SetPoint("CENTER", UIParent, "CENTER", XOffset, YOffset)
		else
			RGFrame:SetPoint("CENTER", UIParent, "CENTER", 0, 0)
		end
	end

	RGMoney:SetPoint("CENTER", "RGFrame", "CENTER", 0, 0)

	if (not RG_Scale) then
		RG_Scale = 1
	end

	RGMoney:SetScale(RG_Scale)
	ScaleSlider:SetValue(RG_Scale)
	_G[ScaleSlider:GetName() .. "Text"]:SetText(format("%.2f", RG_Scale))

	local realm = GetRealmName()
	local character = UnitName("player")
	local faction = UnitFactionGroup("player")

	if (not Realm_Gold_Table) then -- intitialize table
		Realm_Gold_Table = {}
	end

	if (not Realm_Gold_Table[realm]) then -- intitialize realm
		Realm_Gold_Table[realm] = {}
	end

	if (not Realm_Gold_Table[realm][character]) then -- initialize character
		Realm_Gold_Table[realm][character] = {}
		Realm_Gold_Table[realm][character]["gold"] = 0
		Realm_Gold_Table[realm][character]["faction"] = faction
	end

	for key, value in pairs(Realm_Gold_Table[realm]) do -- sum the gold from all of the alts in the realm within the same faction
		if ( (key ~= character) and (faction == value["faction"]) ) then
			RG_AltGold = RG_AltGold + value["gold"]
		end
	end
end

-- event handler
local function RealmGold_OnEvent(self, event, arg1, ...)

	if ( (event == "PLAYER_MONEY") or (event == "PLAYER_ENTERING_WORLD") ) then
		RG_MyGold = GetMoney()
		MoneyFrame_Update("RGMoney", RG_AltGold + RG_MyGold)

	elseif (event == "ADDON_LOADED") then
		if (arg1 == "Realm_Gold") then
			RG_Init()
		end

	elseif (event == "PLAYER_LEAVING_WORLD") then
		Realm_Gold_Table[GetRealmName()][UnitName("player")]["gold"] = RG_MyGold
		if (Docked) then
			_, _, _, XDockOffset, YDockOffset = RGFrame:GetPoint()
		else
			_, _, _, XOffset, YOffset = RGFrame:GetPoint()
		end
	end
end

-- hook events
RGFrame:RegisterEvent("ADDON_LOADED")
RGFrame:RegisterEvent("PLAYER_ENTERING_WORLD")
RGFrame:RegisterEvent("PLAYER_MONEY")
RGFrame:RegisterEvent("PLAYER_LEAVING_WORLD")
RGFrame:SetScript("OnEvent", RealmGold_OnEvent)

-- make main frame movable
RGFrame:SetMovable(true)
RGFrame:EnableMouse(true)
RGFrame:SetScript("OnMouseDown", RGFrame.StartMoving)
RGFrame:SetScript("OnMouseUp", RGFrame.StopMovingOrSizing)
