local new_scale = 1

SlashCmdList["REALMGOLD"] = function() InterfaceOptionsFrame_OpenToCategory("Realm Gold") end
SLASH_REALMGOLD1 = "/rgold"

local RG_Options = CreateFrame("Frame", "RG_Options", InterfaceOptionsFramePanelContainer)
RG_Options:Hide()
RG_Options.name = "Realm Gold"
InterfaceOptions_AddCategory(RG_Options)

RG_Options.cancel = 
	function(self)
		ScaleSlider:SetValue(RG_Scale)
		RGMoney:SetScale(RG_Scale)

		_G["DockedCheck"]:SetChecked(Docked)
	end

RG_Options.okay =
	function(self)
		RG_Scale = new_scale

		if (DockedCheck:GetChecked()) then
			Docked = true
			RGFrame:SetParent(ContainerFrame1)
		else
			Docked = false
			RGFrame:SetParent(UIParent)
		end
	end

RG_Options.default = 
	function(self)
		-- set scale to 1
		ScaleSlider:SetValue(1)
		_G[ScaleSlider:GetName() .. "Text"]:SetText(format("%.2f", 1))
		RG_Scale = 1
		RGMoney:SetScale(1)
		-- center money frame
		XOffset = 0
		YOffset = 0
		RGFrame:ClearAllPoints()
		RGFrame:SetPoint("CENTER", UIParent, "CENTER", 0, 0)
		-- disable docked to backback option
		Docked = false
		RGFrame:SetParent(UIParent)
		DockedCheck:SetChecked(false)
		-- zero out gold totals
		local realm = GetRealmName()
		local character = UnitName("player")
		local faction = UnitFactionGroup("player")
		RG_MyGold = GetMoney()
		Realm_Gold_Table = {}
		Realm_Gold_Table[realm] = {}
		Realm_Gold_Table[realm][character] = {}
		Realm_Gold_Table[realm][character]["gold"] = RG_MyGold
		Realm_Gold_Table[realm][character]["faction"] = faction
		RG_AltGold = 0
		MoneyFrame_Update("RGMoney", RG_MyGold)
	end

local RG_Opt_Title = RG_Options:CreateFontString("RG_OptionsConfigTitle", "ARTWORK", "GameFontNormalLarge")
RG_Opt_Title:SetPoint("TOPLEFT", 16, -16)
RG_Opt_Title:SetText("Realm Gold Options")

local RG_Scale_Title = RG_Options:CreateFontString(nil, "ARTWORK", "GameFontNormal")
RG_Scale_Title:SetPoint("TOPLEFT", RG_Options, "TOPLEFT", 16, -60)
RG_Scale_Title:SetText("Scale")

local ScaleSlider = CreateFrame("Slider", "ScaleSlider", RG_Options, "OptionsSliderTemplate")
ScaleSlider:SetWidth(300)
ScaleSlider:SetPoint("TOPLEFT", RG_Options, "TOPLEFT", 76, -60)
ScaleSlider:SetMinMaxValues(0.5,2.5)
ScaleSlider:SetOrientation('HORIZONTAL')
ScaleSlider:SetValueStep(0.01)
_G[ScaleSlider:GetName() .. "Low"]:SetText("0.50")
_G[ScaleSlider:GetName() .. "High"]:SetText("2.50")

ScaleSlider:SetScript("OnValueChanged", function(_, value)
	new_scale = floor(value * 1000 + 0.5) / 1000 -- needed to round to 2 decimal points because setstep doesn't work like it should
	_G[ScaleSlider:GetName() .. "Text"]:SetText(format("%.2f", new_scale))
	RGMoney:SetScale(value)
end)

local DockedCheck = CreateFrame("CheckButton", "DockedCheck", RG_Options, "OptionsCheckButtonTemplate")
_G[DockedCheck:GetName() .. "Text" ]:SetText("  Docked to Backpack")
DockedCheck:SetPoint("TOPLEFT", RG_Options, "TOPLEFT", 12, -100)

