RandomCompanionOptions = {};

local function debugmsg(msg, debuglevel)
	if debuglevel == nil then
		debuglevel = 1;
	end
	if tonumber(debuglevel) then
		local debuglevel = tonumber(debuglevel);
	else	
		local debuglevel = 1;
	end
	if RandomCompanion_settings.DEBUG and (debuglevel >= tonumber(RandomCompanion_settings.DEBUGLevel)) then
		DEFAULT_CHAT_FRAME:AddMessage("RandomCompanion Debug[" .. debuglevel .. "]: " .. msg);
	end
end

function RandomCompanionOptions.Initialize()
	if RandomCompanionOptions.Initialized ~= true then
		debugmsg("Initializing RandomCompanionOptions", 10);
		
		--Set up the weight slider interface
		RandomCompanionOptions.WeightSlider = CreateFrame("Slider", nil, CollectionsJournal, "OptionsSliderTemplate");
		RandomCompanionOptions.WeightSlider:SetWidth(100);
		RandomCompanionOptions.WeightSlider:SetHeight(20);
		RandomCompanionOptions.WeightSlider:SetOrientation("HORIZONTAL");
		RandomCompanionOptions.WeightSlider:SetPoint("BOTTOM", CollectionsJournal, "BOTTOM", 0, 8);
		RandomCompanionOptions.WeightSlider:SetMinMaxValues(0, 50);
		RandomCompanionOptions.WeightSlider.tooltipText = "RandomCompanion Weight\n\n|cFFFFFFFFSet the value higher to make RandomCompanion use this companion more often.";
		RandomCompanionOptions.WeightSlider:SetValueStep(1);
		RandomCompanionOptions.WeightSlider:SetObeyStepOnDrag(true);
		RandomCompanionOptions.WeightSlider:EnableMouseWheel(true);
		RandomCompanionOptions.WeightSlider:Show();
		
		local text = RandomCompanionOptions.WeightSlider:CreateFontString(nil, "BACKGROUND");
		text:SetFontObject("GameFontHighlightSmall");
		text:SetPoint("LEFT", RandomCompanionOptions.WeightSlider, "RIGHT", 10, 0);
		RandomCompanionOptions.WeightSlider.valText = text;
		
		RandomCompanionOptions.WeightSlider:SetScript("OnMouseWheel", function (self, arg1)
			local step = self:GetValueStep() * arg1
			local value = self:GetValue()
			local minVal, maxVal = self:GetMinMaxValues()
		
			if step > 0 then
				self:SetValue(min(value+step, maxVal))
			else
				self:SetValue(max(value+step, minVal))
			end
		end);
		
		RandomCompanionOptions.WeightSlider:SetScript("OnValueChanged", function(self, value)
			local companionID = RandomCompanionOptions.GetSelectedCompanionID();
			
			if (companionID ~= nil) then
				value = RandomCompanionOptions.WeightSlider:GetValue();
				if (value == 0) then
					RandomCompanionOptions.WeightSlider.valText:SetText("Weight: Disabled");
				else
					RandomCompanionOptions.WeightSlider.valText:SetText("Weight: " .. value);
				end
				RandomCompanion.SetWeight(companionID, value);
			end
			
			if not RC_REQUIRE_RELOAD then
				debugmsg("Weight changed; RandomCompanion will reload when next companion is summoned.", 2);
				RC_REQUIRE_RELOAD = true;
			end
		end);
		
		--Set up the Interface Options screen
		local RandomCompanionOptionsFrame = CreateFrame("FRAME", "RandomCompanionOptions");
		RandomCompanionOptionsFrame.name = GetAddOnMetadata("RandomCompanion", "Title");
		RandomCompanionOptionsFrame.default = function (self) RandomCompanionOptions_ResetConfig() end;
		RandomCompanionOptionsFrame.refresh = function (self) RandomCompanionOptions_RefreshConfig() end;
		InterfaceOptions_AddCategory(RandomCompanionOptionsFrame);
		
		local RandomCompanionOptionsHeader = RandomCompanionOptionsFrame:CreateFontString(nil, "ARTWORK");
		RandomCompanionOptionsHeader:SetFontObject(GameFontNormalLarge);
		RandomCompanionOptionsHeader:SetPoint("TOPLEFT", 16, -16);
		RandomCompanionOptionsHeader:SetText(GetAddOnMetadata("RandomCompanion", "Title") .. " " .. GetAddOnMetadata("RandomCompanion", "Version"));
		
		RandomCompanionOptionsCB_AccountWideWeights = CreateFrame("CheckButton", "RandomCompanionOptionsCB_AccountWideWeights", RandomCompanionOptionsFrame, "OptionsCheckButtonTemplate");
		RandomCompanionOptionsCB_AccountWideWeights:SetPoint("TOPLEFT", RandomCompanionOptionsHeader, "BOTTOMLEFT", 2, 0);
		RandomCompanionOptionsCB_AccountWideWeights:SetScript("OnClick", function(self)
			RandomCompanion_settings.AccountWideWeights = (not RandomCompanion_settings.AccountWideWeights);
			RC_REQUIRE_RELOAD = true;
			end);
		RandomCompanionOptionsCB_AccountWideWeightsText:SetText("Account-Wide mount and pet weights");
		RandomCompanionOptionsCB_AccountWideWeights:SetChecked(RandomCompanion_settings.AccountWideWeights);
		
		RandomCompanionOptionsCB_AutoRecall = CreateFrame("CheckButton", "RandomCompanionOptionsCB_AutoRecall", RandomCompanionOptionsFrame, "OptionsCheckButtonTemplate");
		RandomCompanionOptionsCB_AutoRecall:SetPoint("TOPLEFT", RandomCompanionOptionsCB_AccountWideWeights, "BOTTOMLEFT", 0, -2);
		RandomCompanionOptionsCB_AutoRecall:SetScript("OnClick", function(self)
			RandomCompanion_settings.AutoRecall = (not RandomCompanion_settings.AutoRecall);
			RandomCompanion_settings.RandomRecall = false;
			RandomCompanionOptionsCB_RandomRecall:SetChecked(false);
			RC_REQUIRE_RELOAD = true;
			end);
		RandomCompanionOptionsCB_AutoRecallText:SetText("Auto-recall vanity pets");
		RandomCompanionOptionsCB_AutoRecall:SetChecked(RandomCompanion_settings.AutoRecall);
		
		RandomCompanionOptionsCB_RandomRecall = CreateFrame("CheckButton", "RandomCompanionOptionsCB_RandomRecall", RandomCompanionOptionsFrame, "OptionsCheckButtonTemplate");
		RandomCompanionOptionsCB_RandomRecall:SetPoint("TOPLEFT", RandomCompanionOptionsCB_AutoRecall, "BOTTOMLEFT", 0, -2);
		RandomCompanionOptionsCB_RandomRecall:SetScript("OnClick", function(self)
			RandomCompanion_settings.RandomRecall = (not RandomCompanion_settings.RandomRecall);
			RandomCompanion_settings.AutoRecall = false;
			RandomCompanionOptionsCB_AutoRecall:SetChecked(false);
			RC_REQUIRE_RELOAD = true;
			end);
		RandomCompanionOptionsCB_RandomRecallText:SetText("Auto-recall a random vanity pet");
		RandomCompanionOptionsCB_RandomRecall:SetChecked(RandomCompanion_settings.RandomRecall);
		
		RandomCompanionOptionsCB_AutoDismiss = CreateFrame("CheckButton", "RandomCompanionOptionsCB_AutoDismiss", RandomCompanionOptionsFrame, "OptionsCheckButtonTemplate");
		RandomCompanionOptionsCB_AutoDismiss:SetPoint("TOPLEFT", RandomCompanionOptionsCB_RandomRecall, "BOTTOMLEFT", 0, -2);
		RandomCompanionOptionsCB_AutoDismiss:SetScript("OnClick", function(self)
			RandomCompanion_settings.AutoDismiss = (not RandomCompanion_settings.AutoDismiss);
			RC_REQUIRE_RELOAD = true;
			end);
		RandomCompanionOptionsCB_AutoDismissText:SetText("Auto-dismiss vanity pets when hiding during PVP");
		RandomCompanionOptionsCB_AutoDismiss:SetChecked(RandomCompanion_settings.AutoDismiss);
		
		RandomCompanionOptionsCB_RaidDismiss = CreateFrame("CheckButton", "RandomCompanionOptionsCB_RaidDismiss", RandomCompanionOptionsFrame, "OptionsCheckButtonTemplate");
		RandomCompanionOptionsCB_RaidDismiss:SetPoint("TOPLEFT", RandomCompanionOptionsCB_AutoDismiss, "BOTTOMLEFT", 0, -2);
		RandomCompanionOptionsCB_RaidDismiss:SetScript("OnClick", function(self)
			RandomCompanion_settings.RaidDismiss = (not RandomCompanion_settings.RaidDismiss);
			RC_REQUIRE_RELOAD = true;
			end);
		RandomCompanionOptionsCB_RaidDismissText:SetText("Auto-dismiss vanity pets when in a raid");
		RandomCompanionOptionsCB_RaidDismiss:SetChecked(RandomCompanion_settings.RaidDismiss);
		
		RandomCompanionOptionsCB_FlyingOnGround = CreateFrame("CheckButton", "RandomCompanionOptionsCB_FlyingOnGround", RandomCompanionOptionsFrame, "OptionsCheckButtonTemplate");
		RandomCompanionOptionsCB_FlyingOnGround:SetPoint("TOPLEFT", RandomCompanionOptionsCB_RaidDismiss, "BOTTOMLEFT", 0, -2);
		RandomCompanionOptionsCB_FlyingOnGround:SetScript("OnClick", function(self)
			RandomCompanion_settings.FlyingOnGround = (not RandomCompanion_settings.FlyingOnGround);
			RC_REQUIRE_RELOAD = true;
			end);
		RandomCompanionOptionsCB_FlyingOnGroundText:SetText("Use flying mounts in ground areas");
		RandomCompanionOptionsCB_FlyingOnGround:SetChecked(RandomCompanion_settings.FlyingOnGround);
		
		RandomCompanionOptionsCB_RandomChange = CreateFrame("CheckButton", "RandomCompanionOptionsCB_RandomChange", RandomCompanionOptionsFrame, "OptionsCheckButtonTemplate");
		RandomCompanionOptionsCB_RandomChange:SetPoint("TOPLEFT", RandomCompanionOptionsCB_FlyingOnGround, "BOTTOMLEFT", 0, -2);
		RandomCompanionOptionsCB_RandomChange:SetScript("OnClick", function(self)
			RandomCompanion_settings.RandomChange = (not RandomCompanion_settings.RandomChange);
			RC_REQUIRE_RELOAD = true;
			if RandomCompanion_settings.RandomChange then
				RandomCompanionOptions.RandomChangeSlider:SetAlpha(1);
			else
				RandomCompanionOptions.RandomChangeSlider:SetAlpha(0.3);
			end
			end);
		RandomCompanionOptionsCB_RandomChangeText:SetText("Randomly change vanity pets");
		RandomCompanionOptionsCB_RandomChange:SetChecked(RandomCompanion_settings.RandomChange);
		
		RandomCompanionOptions.RandomChangeSlider = CreateFrame("Slider", "RandomCompanionOptionsSlider_RandomChange", RandomCompanionOptionsFrame, "OptionsSliderTemplate");
		RandomCompanionOptions.RandomChangeSlider:SetWidth(100);
		RandomCompanionOptions.RandomChangeSlider:SetHeight(20);
		RandomCompanionOptions.RandomChangeSlider:SetOrientation("HORIZONTAL");
		RandomCompanionOptions.RandomChangeSlider:SetPoint("TOPLEFT", RandomCompanionOptionsCB_RandomChange, "BOTTOMLEFT", 27, -7);
		RandomCompanionOptions.RandomChangeSlider:SetMinMaxValues(1, 60);
		RandomCompanionOptions.RandomChangeSlider:SetValueStep(1);
		RandomCompanionOptions.RandomChangeSlider:SetObeyStepOnDrag(true);
		RandomCompanionOptions.RandomChangeSlider:EnableMouseWheel(true);
		RandomCompanionOptions.RandomChangeSlider:Show();
		
		RandomCompanionOptionsCB_Cloning = CreateFrame("CheckButton", "RandomCompanionOptionsCB_Cloning", RandomCompanionOptionsFrame, "OptionsCheckButtonTemplate");
		RandomCompanionOptionsCB_Cloning:SetPoint("TOPLEFT", RandomCompanionOptions.RandomChangeSlider, "BOTTOMLEFT", -27, -7);
		RandomCompanionOptionsCB_Cloning:SetScript("OnClick", function(self)
			RandomCompanion_settings.Cloning = (not RandomCompanion_settings.Cloning);
			RC_REQUIRE_RELOAD = true;
			end);
		RandomCompanionOptionsCB_CloningText:SetText("Clone pets and mounts");
		RandomCompanionOptionsCB_Cloning:SetChecked(RandomCompanion_settings.Cloning);
		
		RandomCompanionOptionsCB_Traincrusher = CreateFrame("CheckButton", "RandomCompanionOptionsCB_Traincrusher", RandomCompanionOptionsFrame, "OptionsCheckButtonTemplate");
		RandomCompanionOptionsCB_Traincrusher:SetPoint("TOPLEFT", RandomCompanionOptionsCB_Cloning, "BOTTOMLEFT", 0, -2);
		RandomCompanionOptionsCB_Traincrusher:SetScript("OnClick", function(self)
			RandomCompanion_settings.Traincrusher = (not RandomCompanion_settings.Traincrusher);
			RC_REQUIRE_RELOAD = true;
			end);
		RandomCompanionOptionsCB_TraincrusherText:SetText("Traincrusher!");
		RandomCompanionOptionsCB_Traincrusher:SetChecked(RandomCompanion_settings.Traincrusher);
		
		local text = RandomCompanionOptions.RandomChangeSlider:CreateFontString(nil, "BACKGROUND");
		text:SetFontObject("GameFontNormal");
		text:SetPoint("LEFT", RandomCompanionOptions.RandomChangeSlider, "TOPLEFT", 0, 3);
		RandomCompanionOptions.RandomChangeSlider.valText = text;
		
		if RandomCompanion_settings.RandomChange then
			RandomCompanionOptions.RandomChangeSlider:SetAlpha(1);
		else
			RandomCompanionOptions.RandomChangeSlider:SetAlpha(0.3);
		end
		
		RandomCompanionOptions.RandomChangeSlider:SetScript("OnMouseWheel", function (self, arg1)
			local step = self:GetValueStep() * arg1
			local value = self:GetValue()
			local minVal, maxVal = self:GetMinMaxValues()
		
			if step > 0 then
				self:SetValue(min(value+step, maxVal))
			else
				self:SetValue(max(value+step, minVal))
			end
		end);
		
		RandomCompanionOptions.RandomChangeSlider:SetScript("OnValueChanged", function(self, value)
			value = RandomCompanionOptions.RandomChangeSlider:GetValue();
			if (value == 1) then
				RandomCompanionOptions.RandomChangeSlider.valText:SetText("Change vanity pet every " .. value .. " minute");
			else
				RandomCompanionOptions.RandomChangeSlider.valText:SetText("Change vanity pet every " .. value .. " minutes");
			end
			RandomCompanion_settings.RandomChangeTime = value;
		end);
		
		if (RandomCompanion_settings.RandomChangeTime == 1) then
			RandomCompanionOptions.RandomChangeSlider.valText:SetText("Change vanity pet every " .. RandomCompanion_settings.RandomChangeTime .. " minute");
		else
			RandomCompanionOptions.RandomChangeSlider.valText:SetText("Change vanity pet every " .. RandomCompanion_settings.RandomChangeTime .. " minutes");
		end
		RandomCompanionOptions.RandomChangeSlider:SetValue(RandomCompanion_settings.RandomChangeTime);
		
		RandomCompanionOptions.Initialized = true;
	end
end

function RandomCompanionOptions.GetSelectedCompanionID()
    local companionID;
    local panel = PanelTemplates_GetSelectedTab(CollectionsJournal); --1 for mounts, 2 for pets
    if panel == 1 then
		if ( MountJournal.selectedMountID ) then
			local creatureName, spellID, icon, active, isUsable, sourceType, isFavorite, _, _, hideOnChar, isCollected, mountID = C_MountJournal.GetMountInfoByID(MountJournal.selectedMountID);
			companionID = 'mount.' .. creatureName .. '.' .. spellID;
		end
    else
        local petID = PetJournalPetCard.petID;
        if petID ~= nil then
            local speciesID, customName, level, xp, maxXp, displayID, discard, name, icon, petType, creatureID, sourceText, description, isWild, canBattle, tradable, unique = C_PetJournal.GetPetInfoByPetID(petID);
            companionID = 'pet.' .. name .. '.' .. tostring(petID, 10);
        end
    end
    
    return companionID;
end

function RandomCompanionOptions.UpdateSliders(...)
    local companionID = RandomCompanionOptions.GetSelectedCompanionID();

    if companionID then
        RandomCompanionOptions.WeightSlider:Show();
    else
        RandomCompanionOptions.WeightSlider:Hide();
    end
    
	if companionID ~= nil and companionID ~= RandomCompanionOptions.LastSelected then
        debugmsg("companionID: " .. companionID, 5);
		debugmsg("Updating Weight slider", 1);
		RandomCompanionOptions.LastSelected = companionID;
		RandomCompanionOptions.WeightSlider:SetValue(RandomCompanion.GetWeight(companionID));
		RandomCompanionOptions.EventFrame:SetScript("OnUpdate", nil);
	end
	Model_OnUpdate(...);
end

function RandomCompanionOptions.Event(self, event, ...)
	if event == "PLAYER_LOGIN" then
		if ( not CollectionsJournal ) then
			UIParentLoadAddOn("Blizzard_Collections");
		end
		PetJournal:SetScript("OnUpdate", RandomCompanionOptions.UpdateSliders);
		MountJournal:SetScript("OnUpdate", RandomCompanionOptions.UpdateSliders);
	end
	if event == "PLAYER_ENTERING_WORLD" then
		RandomCompanionOptions.Initialize();
	end
end

RandomCompanionOptions.EventFrame = CreateFrame("Frame", "RandomCompanionOptionsFrame");
RandomCompanionOptions.EventFrame:SetScript("OnEvent", RandomCompanionOptions.Event);
RandomCompanionOptions.EventFrame:RegisterEvent("PLAYER_LOGIN");
RandomCompanionOptions.EventFrame:RegisterEvent("PLAYER_ENTERING_WORLD");