--[[

RandomCompanion
Picks a random vanity pet or mount and automatically chooses the best type of mount for the job.

Usage:
Bind a key from the keybinding menu or...
"/rc mount" to choose a random mount
"/rc mount ground" to choose a random ground mount in a flyable zone
"/rc mount passenger" or "/rc mount passengerground" to choose a mount that can carry passengers
"/rc pet" to choose a random vanity pet
"/rc autorecall" to toggle automatically recalling your vanity pet after resurrecting, changing zones, or taking flight paths
"/rc randomrecall" to toggle recalling a random vanity pet after resurrecting, changing zones, or taking flight paths
"/rc dismiss" to dismiss your current vanity pet
"/rc autodismiss" to toggle automatically dismissing your vanity pet when you are stealthed and flagged for PVP
"/rc raiddismiss" to toggle automatically dismissing your vanity pet when you are in a raid
"/rc randomchange [number of minutes]" to toggle randomly changing your vanity pet occasionally. Default is every 15 minutes
"/rc quiet" to toggle showing the full "RandomCompanion loaded" message when logging in or reloading.

TODO:
Button that shows your current pet/mount or a ? if you don't have one out
Add support for Running Wild, Ghost Wolf, etc.
Conflict with Notes UNeed http://wow.curse.com/downloads/wow-addons/details/notes-uneed.aspx
Add an option for restricting ground mounts to ground-only mounts.
Figure out this issue: http://www.curse.com/addons/wow/randomcompanion#c198
Add weight reset command line
Add an option for restricting vanity pet summons to "favorites"
Turtles seem to be usable by low-level characters?
Traincrusher isn't working again? - RandomCompanion\RandomCompanion-3.1.lua:311: bad argument #1 to "random" (interval is empty)
Get list of pets that break stealth and do something about it: Lost of Lordaeron

Doesn't auto-dismiss:
  Pierre

Changes:
4.0.10
Added Workaround for IsFlyableArea bug introduced in 7.3.5 by the removal of Cold Weather Flying and Flight Master's License - Thanks luminator
Removed Sky Golem from list of passenger mounts - Thanks Zensunim
Added flying related members and checks in init for performance reasons

4.0.9
Updated Interface version to remove out of date errors - Thanks Himekaidou  

4.0.8
Fixed an LUA error being reported at login due to a bug in Blizzard's scripts - Thanks Cipri

4.0.7
Updated for WoW 7.0.3

4.0.6
Updated for WoW 6.2.2
Added detection for Draenor Pathfinder achievement to allow flying in Draenor.
Removed option to treat Draenor as a flyable area since it's no longer necessary.

4.0.5
Updated for WoW 6.1 - Thanks Zensunim

4.0.4
Added an option to treat Draenor as a flyable area, disabled by default

4.0.3
Low level characters will now use the Riding Turtle or Sea Turtle if you have one.
Fixed a few bugs dealing with mount priorities.
Fixed a traincrusher bug.
Fixed a bug with guild page/herald not being disabled by default.
Fixed a bug with recalling your pet from pre-6.0 WoW.

4.0.2
Fixed vanity pet weights to allow different versions of the same pet to be weighted different.
Fixed numbers with lots of decimals when dragging the weight slider.

4.0.1
Added an option to allow using flying mounts in ground-only areas

4.0
Big update for WoW 6.0.
Updated to new MountJournal functions for 6.0.
New flying and scaling mounts should be auto-detected when Blizzard adds them instead of needing to manually add them each time. Key word: "should"
Removed checking for professions since Blizzard handles this better.
Allow flying mounts in non-flying areas.
Cloud serpents no longer require the Cloud Serpent Riding skill.
Switched to a different method of checking if the loaded mount list is up to date.
Had to switch back to the internal IsFlyableArea() since flying mounts are now usable in non-flying areas. This has caused problems detecting the correct mount in the past.
Fixed Abyssal Seahorse not getting used in Vash'jir.

3.1.4
Updated for WoW 5.4.
Added new mounts from WoW 5.4.

3.1.3
Updated for WoW 5.3.
Added new mounts from WoW 5.3.
Fixed a bug involving account-wide weights not being loaded correctly.

3.1.2
Updated for WoW 5.2.
Added new mounts from WoW 5.2.
Fixed a few bugs with dismissing pets.
Added Account-Wide weights option to Options panel.

3.1.1
Fixed a bug with the weight sliders.
Made a change to allow pre-5.1 pet weights to work again. Any pet weights set with RandomCompanion 3.1 will be lost.
Added Cloud Serpent Riding detection.

3.1
Updated for WoW 5.1.
Added new mounts from WoW 5.1.
Made changes to when reloads are handled if the pet list changes to help eliminate slowdowns.
Added some missing mounts to the flying and scaling lists.
Fixed the mount IDs for the jewelcrafting panthers.
Changed the event that initializes RandomCompanion from PLAYER_LOGIN to PLAYER_ENTERING _WORLD.
Totally re-wrote how mounts are loaded. This should allow for better control over what gets summoned under different conditions.
Fast swimmer (currently only Subdued Seahorse) support has been added, but is untested.

3.0.4
Added the ability to clone renamed pets.
Fixed a bug with manually dismissing pets.

3.0.3
Fixed several bugs with dismissing pets or re-summoning the same pet that you already have out.
Fixed an issue where RandomCompanion gets REALLY confused when the mount list gets out of order.
Fixed cloning vanity pets.
Fixed a LUA error when pet/mount names are not cached yet.

3.0.2
Shortest time between versions ever.
Fixed a taint issue in the glyph window.

3.0.1
Fixed a bug with Traincrusher pets.
Fixed a bug with mounts that require professions.
Fixed importing mount weights from pre-WoW-5.0 versions of RandomCompanion.
Removed more code that is no longer necessary.

3.0
Major update for WoW 5.0...Expect lots of bugs related to vanity pets.
Removed several sections of code that are no longer necessary such as zone detection and snowball detection.
Removed pet cooldown detection because it's sorta broken at the moment.

2.5.1
Added "/rc quiet" to toggle showing the full "RandomCompanion loaded" message when logging in or reloading.
Added support for the Feldrake mount.
Made the Corrupted Hippogryph work correctly in non-flying areas.

2.5
Added the following 4.3 flying mounts: Experiment 12-B, Corrupted Hippogryph, Heart of the Aspects, Life-Binder's Handmaiden, Twilight Harbinger, Tyrael's Charger, Spectral Gryphon, Spectral Wind Rider, Blazing Drake, Ruthless Gladiator's Twilight Drake
Fixed the Traincrusher option.
Fixed a problem with recalling your vanity pet on first login after clearing WoW's cache.
Added "/rc raiddismiss" to toggle automatically dismissing your vanity pet when you are in a raid

2.4.1
Fixed a bug with barber shop detection.
Added the Traincrusher option.
Fixed a bug with dismissing on camouflage.
Added Feign Death to the list of conditions that will auto-dismiss and stop auto-recall.
Added support for a few new mounts from patch 4.2.
Added Wind Riders, Gryphons, and Hippogryphs to the scaling list because they can be used in ground-only areas now.
Fixed a bug with the Black and Ultramarine Qiraji Battle Tanks.

2.4
Added mount cloning. Target a player before summoning your mount to make RandomCompanion summon the mount they are using. If you do not have their mount, a random mount will be chosen.
Added pet cloning. Target a vanity pet before summoning your pet to make RandomCompanion summon the same pet. If you do not have the pet, a random pet will be chosen.
Added the Barber Shop, Bones of Transformation, Wisp Amulet, and Blessing of the Old God to the list of conditions that will temporarily prevent vanity pets from being auto-recalled.
Fixed a problem with the rotation buttons in the pet and mount screens.
Added "/rc mount passenger" and "/rc mount passengerground" to choose a mount that can carry passengers.

2.3.2
Added "Trapped in Amber" to the list of conditions that will temporarily prevent vanity pets from being auto-recalled.

2.3.1
Oh, Gnowknayme, you so crazy...Lions can't fly unless they have wings! (Moved Golden King from the flying list to the ground list.)
Added support for the Subdued Seahorse and Winged Guardian.
Removed the X-53 Touring Rocket from the flying list because it's a scaling mount.

2.3
Completely re-worked how various mount capabilities are detected. This should work with all of Blizzard's IsFlyableArea() bugs now and in the future without the need for workarounds.
Flying mounts will now be used while on the surface of the water.
Added a check to see if a pet is on cooldown (such as guild page/guild herald) before trying to summon or recall.
Added a check to see if you have snowballs before trying to recall winter pets that require snowballs.
Corrected the mount ID for the Dark Phoenix mount.
Fixed Wintergrasp battle detection after Blizzard removed GetWintergraspWaitTime().
Added support for the new 4.1 flying mounts that are listed on Wowhead at this time.
Guild Page and Guild Herald are set to disabled when learned or loading RandomCompanion for the first time.
Fixed a problem with the Ultramarine Qiraji Tank in AQ40.

2.2
Added a temporary hack for working around IsFlyableArea() bugs in Nespirah, Deadmines, and Dalaran.
Moved the Tailoring and Engineering flying mounts to the scaling list.
Added camouflage to the list of conditions that will temporarily prevent vanity pets from being auto-recalled.
Added camouflage and invisibility to the list of conditions which will cause vanity pets to be auto-dismissed.
Added waiting for a spell target (disenchant, distract, blizzard, etc) to the list of conditions will prevent vanity pets from being autorecalled.
Changed how autorecall waits after determining that you're busy. This should prevent your GCD from getting locked by autorecall as often.
Added "/rc randomchange [number of minutes]" to automatically change your vanity pet every once in a while. Defaults to every 15 minutes.
/rc will not show the instructions if a macro conditional is detected.

2.1.1
Fixed using a ground mount in 4.0.3a Azeroth if you don't have a flight license.

2.1
Fixed a bug with the Celestial Steed on characters that are in a flyable area of Outland, but have not yet learned how to fly.
Changed how Cold Weather Flying and Flight Master's License are detected to a way that no longer needs localization. As a result, RandomCompanion should work better in more languages.
Added falling and death to the list of conditions that will temporarily prevent vanity pets from being auto-recalled.
Added a temporary hack for working around the Wintergrasp IsFlyableArea() bug.
Added a hack to check if bug mounts are usable in AQ40 due to a bug in WoW 4.0.1. Bug mounts will be skipped in AQ40 until the bug is fixed, and then they should automatically start working again.
Changed autorecall to wait 2 seconds before recalling your pet. This should prevent your GCD from getting locked by autorecall as often.
Fixed a bug with detecting snowballs in inventory.
Fixed a minor bug with DismissCompanion() and autorecall.
Tracked down a very annoying problem that was occasionally causing tons of errors while in combat...For reals this time.

2.0
Updated for version 4.0.1.
Added an options screen to the Interface Addons panel. Hello 2008!
Moved special mounts to use spellids instead of names for quicker and more effective localization.
All flying mounts are now in a single list since 4.0 allows all flying mounts to move at the same speed.
All ground mounts are now in a single list since 4.0 allows all ground mounts to move at the same speed.
Added Blazing Hippogryph support.
Added Abyssal Seahorse support.
Profession-based mount requirements should now be correctly detected if the profession is dropped and re-learned.
Non-ground mounts are now hardcoded since Blizzard saw fit to remove text that let RandomCompanion auto-detect new flying mounts. Unfortunately, this means that new non-ground mounts will require a new version of RandomCompanion.
Improved detection for current continent, which removes the need for zone name localization.
Changed the way Snowballs are found in inventory.
Added invisibility to the list of buffs which will stop AutoRecall for reals this time.
Added Graccu's Mince Meat Fruitcake to the list of buffs which will stop AutoRecall.
Tracked down a very annoying problem that was occasionally causing tons of errors while in combat.

1.7.4
Changed how the COMPANION_UPDATE event is handled to not happen so often.
Added flight form and swift flight form to the list of buffs which will stop AutoRecall.
Added support for the Big Love Rocket and Invincible. (untested, they should work as extreme flyers, so please let me know if these work properly)
Added support for the Celestial Steed and the upcoming X-53 Touring Rocket. (untested)
Fixed a small bug with scaling mounts.
Made a change to how the weight slider works so it should no longer cause problems when you move the slider and then quickly choose another mount/pet.

1.7.3
Lowered the amount of time between moving the weight slider and saving the weight.
Updated for version 3.3.

1.7.2
When you are in a vehicle, you will exit the vehicle when you trying to mount.
Added macro conditional parsing to /rc. Example: "/rc [button:1] mount; [button:2] pet" will summon your mount when you left-click the macro, or your pet when you right-click.

1.7.1
Fixed a problem with initialization that was introduced in 1.7.
Fixed a problem where randomly summoning the same vanity pet that you already have out will instead dismiss your current pet.
Added invisibility to the list of buffs which will stop AutoRecall.

1.7
Consolidated all /commands under /rc or /randomcompanion. Old /commands will remain in place for now for backward compatibility. Type "/rc" for a full list of available commands.
Added "/rc autodismiss" to toggle automatically dismissing your vanity pet when you are stealthed and flagged for PVP.
Added "/rc randomrecall" to toggle recalling a random vanity pet after resurrecting, changing zones, or taking flight paths.
Fixed some oddities with AutoRecall.
AutoRecall (and RandomRecall) now recalls your vanity pet when you log in.
Added support for the Onyxian Drake.

1.6.2
Added localization for Krasus' Landing and Underbelly for the German client. Thanks, Herekren.
Added localization for Krasus' Landing for the French and Russian clients. Still need Underbelly translations for these clients.
Added support for the Rusted and Ironbound Proto-Drakes.
Updated name of Headless Horseman's Mount because it changed slightly in 3.2.
Removed Dalaran as special flyable zone because IsFlyableArea() finally works as expected there.
Wintergrasp is now flyable when a battle is not in progress.

1.6.1
Fixed a bug with the weight UI that happened after changing zones

1.6
UI to disable mounts/pets that you don't like or choose your favorite mounts/pets more often has finally been added! Just open your Mount/Pet window and adjust the slider.
Black Qiraji Battle Tank should now work properly both inside and outside of Ahn'Qiraj.

1.5.1
Fixed a bug that detects other mounts as swimmers if you have a sea turtle.

1.5
RandomCompanion will now choose a swimming mount (the new sea turtle) or a ground mount if you are swimming.
Added "/rpet dismiss" and "/pdismiss" to dismiss your current vanity pet.
Vanity pets are automatically re-summoned after losing them for any reason. "/rpet autorecall" to toggle this feature.

1.4
Added Russian localization for Dragonblight.
Fixed a bug with flyable detection in the sewer pipe section of Dalaran.
Fixed a bug with flyable detection in part of Krasus' Landing in Dalaran.
Added flyable detection to some areas on the outskirts of Dalaran. It's not perfect, but it's better than it used to be.
Added /rcreload in case you ever want to re-initialize for some reason.
Added macro conditional parsing such as [modifier:alt] or [combat] to /rmount.
Added checks to make sure you have engineering for the engineering mounts and tailoring for the tailoring mounts. Does not check skill level, so if you re-learn your old tradeskill, your not-yet-usable mounts may be chosen.
Vanity pets are automatically re-summoned after resurrecting, changing zones, or taking flight paths. "/rpet autorecall" to toggle this feature.
LOTS of new debug messages (/rcdebug to enable), so if you're having any sort of problems, turn on debug mode and report them to http://wow.curse.com/downloads/wow-addons/details/randomcompanion.aspx
Added a check for snowballs before summoning winter pets (Winter Reindeer, etc.)

1.3
Fixed bug mount prioritization in AQ40 - May not work properly in non-English clients yet.
Changed the German localization to support an oddity with the Turbogetriebene Flugmaschine.
Added /rcstatus to get RandomCompanion status and /rcdebug to toggle debug mode.
Fixed a bug with scaling flying mounts not getting added to the slow flyers list.
Uncached mounts and pets should be handled a lot better.
Fixed a bug with flyable detection inside Dalaran.

]]--

local VERSION = GetAddOnMetadata("RandomCompanion", "Version");

RandomCompanion = {
    mounts = {
        unweighted = {
            ground = {};
            flying = {};
            cloudserpents = {};
            fastswimmers = {};
            swimmers = {};
            vashjir = {};
            bugs = {};
            scaling = {};
            skimmers = {};
            passengerground = {};
            passengerflying = {};
        };
        weighted = {
            ground = {};
            flying = {};
            cloudserpents = {};
            fastswimmers = {};
            swimmers = {};
            vashjir = {};
            bugs = {};
            scaling = {};
            skimmers = {};
            passengerground = {};
            passengerflying = {};
        };
        byname = {};
        byindex = {};
        bycounter = {};
    };
    critters = {
        weighted = {};
        unweighted = {};
        winter = {};
        byname = {};
        traincrusher = {};
        favorites = {};
    };
    Initialized = false;
	FlyingTrained = false;
	DraenorPathfinderCompleted = false;
	BrokenIslesPathfinderCompleted = false;
};

local function debugmsg(msg, debuglevel)
    if debuglevel == nil then
        debuglevel = 1;
    end
    if tonumber(debuglevel) then
        local debuglevel = tonumber(debuglevel);
    else    
        local debuglevel = 1;
    end
    if RandomCompanion_settings.DEBUG and (debuglevel >= tonumber(RandomCompanion_settings.DEBUGLevel)) then
        DEFAULT_CHAT_FRAME:AddMessage("RandomCompanion Debug[" .. debuglevel .. "]: " .. msg);
    end
end

function RandomCompanion.Event(self, event, ...)
    if event == "PLAYER_ENTERING_WORLD" then
        if RandomCompanion_settings.Quiet and not RandomCompanion.Initialized then
            RandomCompanion.Initialize(false);
        elseif not RandomCompanion.Initialized then
            RandomCompanion.Initialize(true);
        end
    elseif event == "COMPANION_LEARNED" or event == "PET_JOURNAL_LIST_UPDATE" or event == "PET_JOURNAL_PET_DELETED" then
        debugmsg("Reload required due to event: " .. event, 3);
        RC_REQUIRE_RELOAD = true;
    elseif event == "COMPANION_UPDATE" then
        if ... == "CRITTER" then
            RandomCompanion.SetActiveCompanions();
        end
    elseif event == "COMBAT_LOG_EVENT_UNFILTERED" and RandomCompanion_settings.Traincrusher then
        if #RandomCompanion.critters.traincrusher > 0 then
            local timestamp, eventtype, hideCaster, srcGUID, srcName, srcFlags, srcFlags2, dstGUID, dstName, dstFlags, dstFlags2, spellid = select(1, ...);
            if eventtype == "SPELL_CREATE" and spellid == 61031 then
                if not RandomCompanion_settings.Quiet then
                    DEFAULT_CHAT_FRAME:AddMessage("RandomCompanion: Toy Train Set detected! Created by " .. srcName);
                end
                debugmsg("Toy Train Set detected! Created by " .. srcName, 5);
                if not RandomCompanion.Busy() then
                    local petindex = random(#RandomCompanion.critters.traincrusher);
                    debugmsg("Crushing train with " .. RandomCompanion.critters.traincrusher[petindex].name .. " . petID is " .. RandomCompanion.critters.traincrusher[petindex].petID, 10);
                    --RandomCompanion.DismissCompanion("CRITTER");
                    RandomCompanion.origC_PetJournal_SummonPetByGUID(RandomCompanion.critters.traincrusher[petindex].petID);
                end
            end
        end
    else
        debugmsg("Unknown event triggered.", 10);
    end
end

function RandomCompanion.Help()
    --For backwards compatibility with old slash commands
    RandomCompanion.Slash("help");
end

function RandomCompanion.Initialize(showstatus)
    RC_REQUIRE_RELOAD = false;
    
    if not RandomCompanion_settings then
        RandomCompanion_settings = {};
    end
    
    if not RandomCompanion_settings[GetRealmName()] then
        RandomCompanion_settings[GetRealmName()] = {};
    end
    
    if not RandomCompanion_settings[GetRealmName()][UnitName("player")] then
        RandomCompanion_settings[GetRealmName()][UnitName("player")] = {};
    end
    
    if not RandomCompanion_settings.DEBUG then
        RandomCompanion_settings.DEBUG = false;
    end
    
    if RandomCompanion_settings.DEBUGLevel == nil then
        RandomCompanion_settings.DEBUGLevel = 1;
    end
    
    if RandomCompanion_settings.AccountWideWeights == nil then
        RandomCompanion.AccountWideWeights = false;
    end
    
    if RandomCompanion_settings.AutoRecall == nil then
        RandomCompanion_settings.AutoRecall = true;
        if (RandomCompanion_settings.AutoRecall or RandomCompanion_settings.RandomRecall or RandomCompanion_settings.AutoDismiss or RandomCompanion_settings.RandomChange or RandomCOmpanion_settings.RaidDismiss) and RandomCompanion_settings[GetRealmName()][UnitName("player")].ActiveCritter then
            RandomCompanion.OnUpdateTime = GetTime() + 2;
            RandomCompanion.EventFrame:SetScript("OnUpdate", RandomCompanion.OnUpdate);
        else
            RandomCompanion.EventFrame:SetScript("OnUpdate", nil);
        end
    end
    
    if RandomCompanion_settings.AutoDismiss == nil then
        RandomCompanion_settings.AutoDismiss = true;
        if (RandomCompanion_settings.AutoRecall or RandomCompanion_settings.RandomRecall or RandomCompanion_settings.AutoDismiss or RandomCompanion_settings.RandomChange or RandomCompanion_settings.RaidDismiss) and RandomCompanion_settings[GetRealmName()][UnitName("player")].ActiveCritter then
            RandomCompanion.OnUpdateTime = GetTime() + 2;
            RandomCompanion.EventFrame:SetScript("OnUpdate", RandomCompanion.OnUpdate);
        else
            RandomCompanion.EventFrame:SetScript("OnUpdate", nil);
        end
    end
    
    if RandomCompanion_settings.FlyingOnGround == nil then
        RandomCompanion_settings.FlyingOnGround = true;
    end
    
    if RandomCompanion_settings.FlyingInDraenor == nil then
        RandomCompanion_settings.FlyingInDraenor = false;
    end
    
    if RandomCompanion_settings.RaidDismiss == nil then
        RandomCompanion_settings.RaidDismiss = false;
    end
    
    if RandomCompanion_settings.RandomRecall == nil then
        RandomCompanion_settings.RandomRecall = false;
    end
    
    if RandomCompanion_settings.RandomChange == nil then
        RandomCompanion_settings.RandomChange = false;
    end
    
    if RandomCompanion_settings.RandomChangeTime == nil then
        RandomCompanion_settings.RandomChangeTime = 15;
    end
    
    if RandomCompanion_settings.Cloning == nil then
        RandomCompanion_settings.Cloning = true;
    end
    
    if RandomCompanion_settings.Traincrusher == nil then
        RandomCompanion_settings.Traincrusher = false;
    end
    
    if not RandomCompanion_settings.accountwide then
        RandomCompanion_settings.accountwide = {};
    end
    
    if not RandomCompanion_settings.accountwide.weights then
        RandomCompanion_settings.accountwide.weights = {};
    end
    
    if not RandomCompanion_settings[GetRealmName()] then
        RandomCompanion_settings[GetRealmName()] = {};
    end
    
    if not RandomCompanion_settings[GetRealmName()][UnitName("player")] then
        RandomCompanion_settings[GetRealmName()][UnitName("player")] = {};
    end
    
    if not RandomCompanion_settings[GetRealmName()][UnitName("player")].weights then
        RandomCompanion_settings[GetRealmName()][UnitName("player")].weights = {};
    end
    
    if RandomCompanion_settings.Quiet == nil then
        RandomCompanion_settings.Quiet = false;
    end
    
    RandomCompanion.mounts = {
        unweighted = {
            ground = {};
            flying = {};
            cloudserpents = {};
            fastswimmers = {};
            swimmers = {};
            vashjir = {};
            bugs = {};
            scaling = {};
            skimmers = {};
            passengerground = {};
            passengerflying = {};
            lowlevel = {};
        };
        weighted = {
            ground = {};
            flying = {};
            cloudserpents = {};
            fastswimmers = {};
            swimmers = {};
            vashjir = {};
            bugs = {};
            scaling = {};
            skimmers = {};
            passengerground = {};
            passengerflying = {};
            lowlevel = {};
        };
        byname = {};
        byindex = {};
        bycounter = {};
    };
    RandomCompanion.critters = {
        weighted = {};
        unweighted = {};
        winter = {};
        byname = {};
        traincrusher = {};
        favorites = {};
    };
    
    if not RandomCompanion_settings[GetRealmName()][UnitName("player")].ActiveCritter then
        RandomCompanion_settings[GetRealmName()][UnitName("player")].ActiveCritter = nil;
        RandomCompanion.SetActiveCompanions();
    end
    
    CreateFrame("GameTooltip", "RandomCompanionScanningTooltip", UIParent, "GameTooltipTemplate");
    RandomCompanionScanningTooltip:AddFontStrings(
        RandomCompanionScanningTooltip:CreateFontString( "$parentTextLeft1", nil, "GameTooltipText" ),
        RandomCompanionScanningTooltip:CreateFontString( "$parentTextRight1", nil, "GameTooltipText" )
    );

    for index,mountID in pairs(C_MountJournal.GetMountIDs()) do
        local name, spellid, icon, active, isUsable, sourceType, isFavorite, _, _, hideOnChar, isCollected, mountID = C_MountJournal.GetMountInfoByID(mountID);
        
        if name and isUsable and isCollected then
            GameTooltip_SetDefaultAnchor(RandomCompanionScanningTooltip, UIParent);
            RandomCompanionScanningTooltip:SetHyperlink("spell:"..spellid);
            
            local tooltipText = "";
            for i = 1, RandomCompanionScanningTooltip:NumLines() do
                tooltipText = tooltipText .. _G["RandomCompanionScanningTooltipTextLeft"..i]:GetText();
            end
            
            local companionID = "mount." .. name .. "." .. spellid;
            
            if RandomCompanion_settings[GetRealmName()][UnitName("player")].weights[name] ~= nil then --Import from pre-5.0 version of RandomCompanion
                RandomCompanion.SetWeight(companionID, RandomCompanion_settings[GetRealmName()][UnitName("player")].weights[name]);
                RandomCompanion_settings[GetRealmName()][UnitName("player")].weights[name] = nil;
            end
            
            local weight = RandomCompanion.GetWeight(companionID);
            
            RandomCompanion.mounts.byname[name] = {
                creatureid = creatureid;
                name = name;
                index = index;
                spellid = spellid;
                icon = icon;
                active = active;
				mountID = mountID;
            }
            
            RandomCompanion.mounts.byindex[index] = {
                creatureid = creatureid;
                name = name;
                index = index;
                spellid = spellid;
                icon = icon;
                active = active;
				mountID = mountID;
            }
            
            local mountdata = {
                creatureid = creatureid;
                name = name;
                index = index;
                spellid = spellid;
                icon = icon;
                active = active;
				mountID = mountID;
            }
            
            table.insert(RandomCompanion.mounts.bycounter, mountdata);
            
            if tContains(RC_MOUNT_IDS.passengerground, spellid) then
                table.insert(RandomCompanion.mounts.unweighted.passengerground, mountdata);
            elseif tContains(RC_MOUNT_IDS.passengerflying, spellid) then
                table.insert(RandomCompanion.mounts.unweighted.passengerflying, mountdata);
            elseif tContains(RC_MOUNT_IDS.cloudserpents, spellid) then
                table.insert(RandomCompanion.mounts.unweighted.cloudserpents, mountdata);
            elseif tContains(RC_MOUNT_IDS.fastswimmers, spellid) then
                table.insert(RandomCompanion.mounts.unweighted.fastswimmers, mountdata);
            elseif tContains(RC_MOUNT_IDS.swimmers, spellid) then
                table.insert(RandomCompanion.mounts.unweighted.swimmers, mountdata);
            elseif tContains(RC_MOUNT_IDS.skimmers, spellid) then
                table.insert(RandomCompanion.mounts.unweighted.skimmers, mountdata);
            elseif tContains(RC_MOUNT_IDS.vashjir, spellid) then
                table.insert(RandomCompanion.mounts.unweighted.vashjir, mountdata);
            elseif tContains(RC_MOUNT_IDS.bugs, spellid) then
                table.insert(RandomCompanion.mounts.unweighted.bugs, mountdata);
            elseif tContains(RC_MOUNT_IDS.scaling, spellid) then
                table.insert(RandomCompanion.mounts.unweighted.scaling, mountdata);
            elseif tContains(RC_MOUNT_IDS.flying, spellid) then
                table.insert(RandomCompanion.mounts.unweighted.flying, mountdata);
            elseif string.find(tooltipText, RC_STRING_SCALING_MOUNT) then
                table.insert(RandomCompanion.mounts.unweighted.scaling, mountdata);
            elseif string.find(tooltipText, RC_STRING_FLYING_MOUNT) then
                table.insert(RandomCompanion.mounts.unweighted.flying, mountdata);
            else
                table.insert(RandomCompanion.mounts.unweighted.ground, mountdata);
            end
            
            if tContains(RC_MOUNT_IDS.lowlevel, spellid) then
                table.insert(RandomCompanion.mounts.unweighted.lowlevel, mountdata);
            end
            
            if weight ~= 1 then
                debugmsg("Mount " .. name .. " has non-default weight: " .. weight, 1);
            end
            
            if weight > 0 then
                for counter = 1, weight do
                    if tContains(RC_MOUNT_IDS.passengerground, spellid) then
                        table.insert(RandomCompanion.mounts.weighted.passengerground, mountdata);
                    elseif tContains(RC_MOUNT_IDS.passengerflying, spellid) then
                        table.insert(RandomCompanion.mounts.weighted.passengerflying, mountdata);
                    elseif tContains(RC_MOUNT_IDS.cloudserpents, spellid) then
                        table.insert(RandomCompanion.mounts.weighted.cloudserpents, mountdata);
                    elseif tContains(RC_MOUNT_IDS.fastswimmers, spellid) then
                        table.insert(RandomCompanion.mounts.weighted.fastswimmers, mountdata);
                    elseif tContains(RC_MOUNT_IDS.swimmers, spellid) then
                        table.insert(RandomCompanion.mounts.weighted.swimmers, mountdata);
                    elseif tContains(RC_MOUNT_IDS.skimmers, spellid) then
                        table.insert(RandomCompanion.mounts.weighted.skimmers, mountdata);
                    elseif tContains(RC_MOUNT_IDS.vashjir, spellid) then
                        table.insert(RandomCompanion.mounts.weighted.vashjir, mountdata);
                    elseif tContains(RC_MOUNT_IDS.bugs, spellid) then
                        table.insert(RandomCompanion.mounts.weighted.bugs, mountdata);
                    elseif tContains(RC_MOUNT_IDS.scaling, spellid) then
                        table.insert(RandomCompanion.mounts.weighted.scaling, mountdata);
                    elseif tContains(RC_MOUNT_IDS.flying, spellid) then
                        table.insert(RandomCompanion.mounts.weighted.flying, mountdata);
                    elseif string.find(tooltipText, RC_STRING_SCALING_MOUNT) then
                        table.insert(RandomCompanion.mounts.weighted.scaling, mountdata);
                    elseif string.find(tooltipText, RC_STRING_FLYING_MOUNT) then
                        table.insert(RandomCompanion.mounts.weighted.flying, mountdata);
                    else
                        table.insert(RandomCompanion.mounts.weighted.ground, mountdata);
                    end
                    
                    if tContains(RC_MOUNT_IDS.lowlevel, spellid) then
                        table.insert(RandomCompanion.mounts.weighted.lowlevel, mountdata);
                    end
                end
            end
        end
    end
    
    RandomCompanionScanningTooltip:Hide()
    
    local scrollFrame = PetJournal.listScroll;
    local offset = HybridScrollFrame_GetOffset(scrollFrame);
    local petButtons = scrollFrame.buttons;
    local isWild = PetJournal.isWild;
    local numPets, numOwned = C_PetJournal.GetNumPets(isWild);
    local summonedPetID = RandomCompanion.GetActiveCompanion("CRITTER");
    
    for i = 1, C_PetJournal.GetNumPets(PetJournal.isWild) do
        index = offset + i;
        if index <= numPets then
            local petID, speciesID, isOwned, customName, level, favorite, isRevoked, name, icon, petType, creatureID, sourceText, description, isWildPet, canBattle = C_PetJournal.GetPetInfoByIndex(index, isWild);
            local companionID = "pet." .. name .. "." .. tostring(petID, 10);
            
            if not name then
                --This seems to happen when the companion is not in the cache
                RC_REQUIRE_RELOAD = true;
                debugmsg(petID .. " petID critter has no name?", 1);
            elseif isOwned then
                if RandomCompanion_settings[GetRealmName()][UnitName("player")].weights[name] ~= nil then --Import from pre-5.0 version of RandomCompanion
                    RandomCompanion_settings[GetRealmName()][UnitName("player")].weights[companionID] = RandomCompanion_settings[GetRealmName()][UnitName("player")].weights[name];
                    RandomCompanion_settings[GetRealmName()][UnitName("player")].weights[name] = nil;
                end
                
                if not RandomCompanion_settings[GetRealmName()][UnitName("player")].weights[companionID] then --Check to import early v6.0 weight
                    local vSixOhID = "pet." .. name .. "." .. "nil";
                    if RandomCompanion_settings[GetRealmName()][UnitName("player")].weights[vSixOhID] then
                        RandomCompanion_settings[GetRealmName()][UnitName("player")].weights[companionID] = RandomCompanion_settings[GetRealmName()][UnitName("player")].weights[vSixOhID];
                        RandomCompanion_settings[GetRealmName()][UnitName("player")].weights[vSixOhID] = nil;
                    end
                end
                
                if not RandomCompanion_settings.accountwide.weights[companionID] then --Check to import early v6.0 weight
                    local vSixOhID = "pet." .. name .. "." .. "nil";
                    if RandomCompanion_settings.accountwide.weights[vSixOhID] then
                        RandomCompanion_settings.accountwide.weights[companionID] = RandomCompanion_settings.accountwide.weights[vSixOhID];
                        RandomCompanion_settings.accountwide.weights[vSixOhID] = nil;
                    end
                end
                
                if not RandomCompanion_settings[GetRealmName()][UnitName("player")].weights[companionID] then --Set default weight
                    if creatureID == 49590 or creatureID == 49588 or creatureID == 49587 or creatureID == 49586 then
                        --Guild page/herald should be disabled by default
                        RandomCompanion_settings[GetRealmName()][UnitName("player")].weights[companionID] = 0;
                    end
                end
                
                if not RandomCompanion_settings.accountwide.weights[companionID] then --Set accountwide default weight
                    if creatureID == 49590 or creatureID == 49588 or creatureID == 49587 or creatureID == 49586 then
                        --Guild page/herald should be disabled by default
                        RandomCompanion_settings.accountwide.weights[companionID] = 0;
                    end
                end
                
                local weight = RandomCompanion.GetWeight(companionID);
                
                RandomCompanion.critters.byname[name] = {
                    creatureid = creatureID;
                    name = name;
                    index = index;
                    icon = icon;
                    active = active;
                    petID = petID;
                    customName = customName;
                    favorite = favorite;
                    level = level;
                    speciesID = speciesID;
                }
                
                local nextindex = #RandomCompanion.critters.unweighted + 1;
                RandomCompanion.critters.unweighted[nextindex] = {
                    creatureid = creatureID;
                    name = name;
                    index = index;
                    icon = icon;
                    active = active;
                    petID = petID;
                    customName = customName;
                    favorite = favorite;
                    level = level;
                    speciesID = speciesID;
                }
                
                if favorite then
                    local nextindex = #RandomCompanion.critters.favorites + 1;
                    RandomCompanion.critters.favorites[nextindex] = {
                        creatureid = creatureID;
                        name = name;
                        index = index;
                        icon = icon;
                        active = active;
                        petID = petID;
                        customName = customName;
                        favorite = favorite;
                        level = level;
                        speciesID = speciesID;
                    }
                end
                
                if creatureID == 24968 or creatureID == 50468 or creatureID == 50384 then
                    local nextindex = #RandomCompanion.critters.traincrusher + 1;
                    RandomCompanion.critters.traincrusher[nextindex] = {
                        creatureid = creatureID;
                        name = name;
                        index = index;
                        spellid = spellid;
                        icon = icon;
                        active = active;
                        petID = petID;
                        customName = customName;
                        favorite = favorite;
                        level = level;
                        speciesID = speciesID;
                    }
                end

                if weight ~= 1 then
                    debugmsg("Critter " .. name .. " has non-default weight: " .. weight, 1);
                end
                
                if weight > 0 then
                    for counter = 1, weight do
                        local nextindex = #RandomCompanion.critters.weighted + 1;
                        RandomCompanion.critters.weighted[nextindex] = {
                            creatureid = creatureid;
                            name = name;
                            index = index;
                            spellid = spellid;
                            icon = icon;
                            active = active;
                            petID = petID;
                            customName = customName;
                            favorite = favorite;
                            level = level;
                            speciesID = speciesID;
                        }
                    end
                end
            end
        end
    end
	
	RandomCompanion.FlyingTrained = IsSpellKnown(RC_SPELLID_EXPERT_RIDING) or IsSpellKnown(RC_SPELLID_ARTISAN_RIDING) or IsSpellKnown(RC_SPELLID_MASTER_RIDING);
	
	local IDNumber, name, points, completed, month, day, year, description, flags, image, rewardText, isGuildAch = GetAchievementInfo(10018);
	RandomCompanion.DraenorPathfinderCompleted = completed;
	
	local IDNumber, name, points, completed, month, day, year, description, flags, image, rewardText, isGuildAch = GetAchievementInfo(11446);
	RandomCompanion.BrokenIslesPathfinderCompleted = completed;
    
    if RandomCompanion_settings.Traincrusher and #RandomCompanion.critters.traincrusher then
        RandomCompanion.EventFrame:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED");
    else
        RandomCompanion.EventFrame:UnregisterEvent("COMBAT_LOG_EVENT_UNFILTERED");
    end
    
    RandomCompanion.SetActiveCompanions();
    RandomCompanion.Initialized = true;
    
    if showstatus then
        RandomCompanion.Status();
    end
end

function RandomCompanion.Debug()
    --For backwards compatibility with old slash commands
    RandomCompanion.Slash("debug");
end

function RandomCompanion.Status()
    local loadmessage = "";
    
    if #RandomCompanion.mounts.unweighted.flying > 0 then
        if loadmessage ~= "" then
            loadmessage = loadmessage .. ", ";
        end
        loadmessage = loadmessage .. #RandomCompanion.mounts.unweighted.flying .. " flyers";
    end
    if #RandomCompanion.mounts.unweighted.ground > 0 then
        if loadmessage ~= "" then
            loadmessage = loadmessage .. ", ";
        end
        loadmessage = loadmessage .. #RandomCompanion.mounts.unweighted.ground .. " grounders";
    end
    if #RandomCompanion.mounts.unweighted.bugs > 0 then
        if loadmessage ~= "" then
            loadmessage = loadmessage .. ", ";
        end
        loadmessage = loadmessage .. #RandomCompanion.mounts.unweighted.bugs .. " bugs";
    end
    if #RandomCompanion.mounts.unweighted.swimmers > 0 then
        if loadmessage ~= "" then
            loadmessage = loadmessage .. ", ";
        end
        loadmessage = loadmessage .. #RandomCompanion.mounts.unweighted.swimmers .. " swimmers";
    end
    if #RandomCompanion.mounts.unweighted.vashjir > 0 then
        if loadmessage ~= "" then
            loadmessage = loadmessage .. ", ";
        end
        loadmessage = loadmessage .. #RandomCompanion.mounts.unweighted.vashjir .. " Vashj'ir mounts";
    end
    if #RandomCompanion.critters.unweighted > 0 then
        if loadmessage ~= "" then
            loadmessage = loadmessage .. ", ";
        end
        loadmessage = loadmessage .. #RandomCompanion.critters.unweighted .. " critters";
    end
    
    if loadmessage ~= "" then
        loadmessage = " with " .. loadmessage .. ".";
    end
    
    if RandomCompanion_settings.RandomRecall then
        loadmessage = loadmessage .. " Vanity pets will be automatically randomly re-summoned when possible.";
    elseif RandomCompanion_settings.AutoRecall then
        loadmessage = loadmessage .. " Vanity pets will be automatically re-summoned when possible.";
    end
    
    if RandomCompanion_settings.RandomChange then
        loadmessage = loadmessage .. " Vanity pets will be randomly changed every " .. RandomCompanion_settings.RandomChangeTime .. " minutes.";
        if RandomCompanion.LastCritterChange == nil then
            RandomCompanion.LastCritterChange = GetTime();
        end
        local nextchange = RandomCompanion.LastCritterChange - (GetTime() - (RandomCompanion_settings.RandomChangeTime * 60));
        if nextchange < 0 then
            loadmessage = loadmessage .. " Next change will occur as soon as you are not busy.";
        else
            loadmessage = loadmessage .. " Next change will occur in " .. floor(nextchange / 60) .. ":" .. (floor(nextchange % 60)) .. ".";
        end
    end
    
    if RandomCompanion_settings.Cloning then
        loadmessage = loadmessage .. " Pets and mounts will be cloned when possible.";
    end
    
    if RandomCompanion_settings.Traincrusher and #RandomCompanion.critters.traincrusher > 0 then
        loadmessage = loadmessage .. " Trains will be crushed!";
    end
    
    if (RandomCompanion_settings.AutoRecall or RandomCompanion_settings.RandomRecall or RandomCompanion_settings.AutoDismiss or RandomCompanion_settings.RaidDismiss) and RandomCompanion_settings[GetRealmName()][UnitName("player")].ActiveCritter then
        RandomCompanion.OnUpdateTime = GetTime() + 2;
        RandomCompanion.EventFrame:SetScript("OnUpdate", RandomCompanion.OnUpdate);
    else
        RandomCompanion.EventFrame:SetScript("OnUpdate", nil);
    end
    
    if RandomCompanion_settings.AutoDismiss then
        loadmessage = loadmessage .. " Vanity pets will be automatically dismissed when entering stealth while flagged for PVP.";
        if (RandomCompanion_settings.AutoRecall or RandomCompanion_settings.RandomRecall or RandomCompanion_settings.AutoDismiss or RandomCompanion_settings.RaidDismiss) and RandomCompanion_settings[GetRealmName()][UnitName("player")].ActiveCritter then
            RandomCompanion.OnUpdateTime = GetTime() + 2;
            RandomCompanion.EventFrame:SetScript("OnUpdate", RandomCompanion.OnUpdate);
        else
            RandomCompanion.EventFrame:SetScript("OnUpdate", nil);
        end
    end
    
    if RandomCompanion_settings.RaidDismiss then
        loadmessage = loadmessage .. " Vanity pets will be automatically dismissed in raids.";
        if (RandomCompanion_settings.AutoRecall or RandomCompanion_settings.RandomRecall or RandomCompanion_settings.AutoDismiss or RandomCompanion_settings.RaidDismiss) and RandomCompanion_settings[GetRealmName()][UnitName("player")].ActiveCritter then
            RandomCompanion.OnUpdateTime = GetTime() + 2;
            RandomCompanion.EventFrame:SetScript("OnUpdate", RandomCompanion.OnUpdate);
        else
            RandomCompanion.EventFrame:SetScript("OnUpdate", nil);
        end
    end
    
    if RC_REQUIRE_RELOAD then
        loadmessage = loadmessage .. " RandomCompanion will reload when next companion is summoned.";
    end
    
    DEFAULT_CHAT_FRAME:AddMessage("RandomCompanion " .. VERSION .. " loaded" .. loadmessage);
end

function RandomCompanion.MergeTables(...)
    local merged = {};
    local tablelist = {...};

    for tk, tv in pairs(tablelist) do
        if (type(tv) == "table") then
            for k, v in pairs(tv) do
                table.insert(merged, v);
            end
        end
    end
    
    return merged;
end

function RandomCompanion.Mount(cmd)
    local flyable;
    local mountlist = {};
    
    if (cmd) then
        --Parse any macro conditionals such as [modifier:ctrl] or [combat]
        cmd = SecureCmdOptionParse(cmd);
    end
    
    if (#RandomCompanion.mounts.bycounter == 0) then
        debugmsg("Loaded mount list does not appear to match the current mount list (empty)", 5);
        RC_REQUIRE_RELOAD = true;
    else
        local usableCounter = 0;
        for index,mountID in pairs(C_MountJournal.GetMountIDs()) do
			local name, spellid, icon, active, isUsable, sourceType, isFavorite, _, _, hideOnChar, isCollected, mountID = C_MountJournal.GetMountInfoByID(mountID);
            
            if name and isUsable and isCollected then
                usableCounter = usableCounter + 1;
            end
        end
        
        if usableCounter ~= #RandomCompanion.mounts.bycounter then
            debugmsg("Loaded mount list does not appear to match the current mount list (mismatch)", 5);
            RC_REQUIRE_RELOAD = true;
        end
    end
    
    if RC_REQUIRE_RELOAD then
        --Re-initialize if one of the pet or mount names was not available in the initial load
        debugmsg("Re-initializing RandomCompanion", 1);
        RandomCompanion.Initialize();
    end
    
    local targetsmount = RandomCompanion.GetTargetsMount();
    
    if IsMounted() then
        Dismount();
    elseif CanExitVehicle() then
        VehicleExit();
    elseif targetsmount ~= nil and RandomCompanion_settings.Cloning then
        debugmsg("Cloning target's mount " .. RandomCompanion.mounts.byname[targetsmount].name .. ". Index is " .. RandomCompanion.mounts.byname[targetsmount].index, 10);
        C_MountJournal.SummonByID(RandomCompanion.mounts.byname[targetsmount].mountID);
    else
        if RandomCompanion.IsFlyableArea() and cmd == "passenger" then
            debugmsg("Currently in a flyable area - Mount preference: passengerflying, passengerground, flying, ground", 3);
            if #RandomCompanion.mounts.weighted.passengerflying > 0 then
                mountlist = RandomCompanion.MergeTables(RandomCompanion.mounts.weighted.passengerflying);
            elseif #RandomCompanion.mounts.weighted.passengerground > 0 then
                mountlist = RandomCompanion.MergeTables(RandomCompanion.mounts.weighted.passengerground);
            elseif #RandomCompanion.mounts.weighted.flying > 0 or #RandomCompanion.mounts.weighted.scaling > 0 or #RandomCompanion.mounts.weighted.passengerflying > 0 then
                mountlist = RandomCompanion.MergeTables(RandomCompanion.mounts.weighted.flying, RandomCompanion.mounts.weighted.scaling, RandomCompanion.mounts.weighted.passengerflying, RandomCompanion.mounts.weighted.cloudserpents);
            elseif #RandomCompanion.mounts.weighted.ground > 0 or #RandomCompanion.mounts.weighted.scaling > 0 or #RandomCompanion.mounts.weighted.passengerground > 0 or #RandomCompanion.mounts.weighted.skimmers > 0 then
                mountlist = RandomCompanion.MergeTables(RandomCompanion.mounts.weighted.ground, RandomCompanion.mounts.weighted.scaling, RandomCompanion.mounts.weighted.passengerground, RandomCompanion.mounts.weighted.skimmers);
            else
                mountlist = {};
            end
        elseif cmd == "passenger" or cmd == "passengerground" then
            debugmsg("Mount preference: passengerground, ground", 3);
            if #RandomCompanion.mounts.weighted.passengerground > 0 or #RandomCompanion.mounts.weighted.passengerflying > 0 then
                mountlist = RandomCompanion.MergeTables(RandomCompanion.mounts.weighted.passengerground, RandomCompanion.mounts.weighted.passengerflying);
            elseif #RandomCompanion.mounts.weighted.ground > 0 or #RandomCompanion.mounts.weighted.scaling > 0 or #RandomCompanion.mounts.weighted.passengerground > 0 or #RandomCompanion.mounts.weighted.skimmers > 0 or #RandomCompanion.mounts.weighted.flying > 0 or #RandomCompanion.mounts.weighted.scaling > 0 or #RandomCompanion.mounts.weighted.passengerflying > 0 or #RandomCompanion.mounts.weighted.cloudserpents > 0 then
                mountlist = RandomCompanion.MergeTables(RandomCompanion.mounts.weighted.ground, RandomCompanion.mounts.weighted.scaling, RandomCompanion.mounts.weighted.passengerground, RandomCompanion.mounts.weighted.skimmers, RandomCompanion.mounts.weighted.flying, RandomCompanion.mounts.weighted.passengerflying, RandomCompanion.mounts.weighted.cloudserpents);
            else
                mountlist = {};
            end
        elseif (IsSwimming() or IsSubmerged()) and IsUsableSpell(75207) and (GetRealZoneText() == RC_STRING_VASHJ_IR or GetRealZoneText() == RC_STRING_ABYSSAL_DEPTHS or GetRealZoneText() == RC_STRING_KELP_THAR_FOREST or GetRealZoneText() == RC_STRING_SHIMMERING_EXPANSE) then --Swimming in an area where the seahorse is usable
            debugmsg("Currently swimming in Vash'jir - Mount preference: vashjir, swimmers, ground", 3);
            if #RandomCompanion.mounts.weighted.vashjir > 0 or #RandomCompanion.mounts.weighted.fastswimmers > 0 then
                mountlist = RandomCompanion.MergeTables(RandomCompanion.mounts.weighted.vashjir, RandomCompanion.mounts.weighted.fastswimmers);
            elseif #RandomCompanion.mounts.weighted.swimmers > 0 then
                mountlist = RandomCompanion.MergeTables(RandomCompanion.mounts.weighted.swimmers);
            elseif #RandomCompanion.mounts.weighted.ground > 0 or #RandomCompanion.mounts.weighted.scaling > 0 or #RandomCompanion.mounts.weighted.passengerground > 0 or #RandomCompanion.mounts.weighted.skimmers > 0 then
                mountlist = RandomCompanion.MergeTables(RandomCompanion.mounts.weighted.ground, RandomCompanion.mounts.weighted.scaling, RandomCompanion.mounts.weighted.passengerground, RandomCompanion.mounts.weighted.skimmers);
            else
                mountlist = {};
            end
        elseif RandomCompanion.IsFlyableArea() and cmd ~= "ground" then
            debugmsg("Currently in a flyable area - Mount preference: flying, ground", 3);
            if #RandomCompanion.mounts.weighted.flying > 0 then
                mountlist = RandomCompanion.MergeTables(RandomCompanion.mounts.weighted.flying, RandomCompanion.mounts.weighted.scaling, RandomCompanion.mounts.weighted.passengerflying, RandomCompanion.mounts.weighted.cloudserpents);
            elseif #RandomCompanion.mounts.weighted.ground > 0 or #RandomCompanion.mounts.weighted.scaling > 0 or #RandomCompanion.mounts.weighted.passengerground > 0 or #RandomCompanion.mounts.weighted.skimmers > 0 then
                mountlist = RandomCompanion.MergeTables(RandomCompanion.mounts.weighted.ground, RandomCompanion.mounts.weighted.scaling, RandomCompanion.mounts.weighted.passengerground, RandomCompanion.mounts.weighted.skimmers);
            else
                mountlist = {};
            end
        elseif IsSwimming() or IsSubmerged() then
            debugmsg("Currently swimming - Mount preference: swimming, ground", 3);
            if #RandomCompanion.mounts.weighted.fastswimmers > 0 then
                mountlist = RandomCompanion.MergeTables(RandomCompanion.mounts.weighted.fastswimmers);
            elseif #RandomCompanion.mounts.weighted.swimmers > 0 then
                mountlist = RandomCompanion.MergeTables(RandomCompanion.mounts.weighted.swimmers);
            elseif #RandomCompanion.mounts.weighted.ground > 0 or #RandomCompanion.mounts.weighted.scaling > 0 or #RandomCompanion.mounts.weighted.passengerground > 0 or #RandomCompanion.mounts.weighted.skimmers > 0 then
                mountlist = RandomCompanion.MergeTables(RandomCompanion.mounts.weighted.ground, RandomCompanion.mounts.weighted.scaling, RandomCompanion.mounts.weighted.passengerground, RandomCompanion.mounts.weighted.skimmers);
            else
                mountlist = {};
            end
        elseif IsUsableSpell(26054) then --Bug mounts are usable
            debugmsg("Currently in Temple of Ahn'Qiraj - Mount preference: bugs, ground", 3);
            if #RandomCompanion.mounts.weighted.bugs > 0 then
                mountlist = RandomCompanion.MergeTables(RandomCompanion.mounts.weighted.bugs, RandomCompanion.mounts.weighted.ground, RandomCompanion.mounts.weighted.scaling, RandomCompanion.mounts.weighted.passengerground, RandomCompanion.mounts.weighted.skimmers);
            elseif #RandomCompanion.mounts.weighted.ground > 0 or #RandomCompanion.mounts.weighted.scaling > 0 or #RandomCompanion.mounts.weighted.passengerground > 0 or #RandomCompanion.mounts.weighted.skimmers > 0 then
                mountlist = RandomCompanion.MergeTables(RandomCompanion.mounts.weighted.ground, RandomCompanion.mounts.weighted.scaling, RandomCompanion.mounts.weighted.passengerground, RandomCompanion.mounts.weighted.skimmers);
            else
                mountlist = {};
            end
        else
            debugmsg("Mount preference: ground only", 3);
            if (cmd == "ground" or not RandomCompanion_settings.FlyingOnGround) and (#RandomCompanion.mounts.weighted.ground > 0 or #RandomCompanion.mounts.weighted.passengerground > 0 or #RandomCompanion.mounts.weighted.skimmers > 0) then
                mountlist = RandomCompanion.MergeTables(RandomCompanion.mounts.weighted.ground, RandomCompanion.mounts.weighted.passengerground, RandomCompanion.mounts.weighted.skimmers);
            elseif #RandomCompanion.mounts.weighted.ground > 0 or #RandomCompanion.mounts.weighted.scaling > 0 or #RandomCompanion.mounts.weighted.passengerground > 0 or #RandomCompanion.mounts.weighted.skimmers > 0 or #RandomCompanion.mounts.weighted.flying > 0 or #RandomCompanion.mounts.weighted.scaling > 0 or #RandomCompanion.mounts.weighted.passengerflying > 0 or #RandomCompanion.mounts.weighted.cloudserpents > 0 then
                mountlist = RandomCompanion.MergeTables(RandomCompanion.mounts.weighted.ground, RandomCompanion.mounts.weighted.scaling, RandomCompanion.mounts.weighted.passengerground, RandomCompanion.mounts.weighted.skimmers, RandomCompanion.mounts.weighted.flying, RandomCompanion.mounts.weighted.passengerflying, RandomCompanion.mounts.weighted.cloudserpents);
            elseif #RandomCompanion.mounts.weighted.lowlevel > 0 then
                mountlist = RandomCompanion.MergeTables(RandomCompanion.mounts.weighted.lowlevel);
            else
                mountlist = {};
            end
        end
        
        if #mountlist > 0 then
            local mountindex = random(#mountlist);
            debugmsg("Mounting " .. mountlist[mountindex].name .. " from list. Index is " .. mountlist[mountindex].index, 10);
            C_MountJournal.SummonByID(mountlist[mountindex].mountID);
        else
            if C_MountJournal.GetNumMounts() > 0 then
                --We have mounts, but they aren't in the mount list. The most likely issue is that no mounts were in the cache when RandomCompanion.Initialize() ran, so let's run it again.
                --This can also happen if you really just don't have any usable mounts
                if not RC_REINITIALIZED then
                    debugmsg("Re-initializing because mount names weren't cached yet.", 10);
                    RC_REINITIALIZED = true; --We don't want an infinite loop, do we?
                    RandomCompanion.Initialize();
                    RandomCompanion.Mount(cmd);
                else
                    UIErrorsFrame:AddMessage("You have no usable mounts", 1.0, 0.0, 0.0, 53, 5);
                    RC_REINITIALIZED = nil;
                end
            else
                UIErrorsFrame:AddMessage("You have no usable mounts", 1.0, 0.0, 0.0, 53, 5);
            end
        end
    end
end

function RandomCompanion.IsFlyableArea()
    if GetRealZoneText() == RC_STRING_WINTERGRASP then
        for areaid = 1, GetNumWorldPVPAreas() do
            local pvpID, localizedName, isActive, canQueue, startTime, canEnter = GetWorldPVPAreaInfo(areaid);
            if localizedName == RC_STRING_WINTERGRASP then
                if isActive then
                    wg_inprogress = 1;
                else
                    wg_inprogress = 0;
                end
                break;
            end
        end
        
        debugmsg("Currently in Wintergrasp. In progress: " .. tonumber(wg_inprogress), 2);
        
        if IsFlyableArea() and wg_inprogress == 0 then
            return true;
        else
            return false;
        end
    elseif IsFlyableArea() then
        if not WorldMapFrame:IsShown() then
            SetMapToCurrentZone()
        end
        
        if GetCurrentMapContinent() == 7 then --We're in Draenor, so we need to check for the Draenor Pathfinder achievement
            if RandomCompanion.DraenorPathfinderCompleted then
                debugmsg("This appears to be a flyable area.", 1);
                return true;
            else
                debugmsg("This does not appear to be a flyable area.", 1);
                return false;
            end
		elseif GetCurrentMapContinent() == 8 then --We're in The Broken Isles, so we need to check for the Broken Isles Pathfinder, Part Two achievement
            if RandomCompanion.BrokenIslesPathfinderCompleted then
                debugmsg("This appears to be a flyable area.", 1);
                return true;
            else
                debugmsg("This does not appear to be a flyable area.", 1);
                return false;
            end
        else
            debugmsg("This appears to be a flyable area.", 1);
            return true;
        end
	--7.3.5 Removed Cold Weather Flying and Flight Master's License, but didn't update IsFlyableArea, resulting in a false negative for characters that
	--trained flying after the patch. This attempts to work around that until Blizzard fixes the API.
	elseif IsOutdoors() and RandomCompanion.FlyingTrained then
		if not WorldMapFrame:IsShown() then
            SetMapToCurrentZone()
        end
        
        if GetCurrentMapContinent() == 9 then --We're on Argus, cannot fly outside here
			return false;
		else
			debugmsg("API reports non-flyable, but outdoors and flight trained", 1);
			return true;
		end
    else
        debugmsg("This does not appear to be a flyable area.", 1);
        return false;
    end
end

function RandomCompanion.Pet(cmd)
    local clonetarget;
    
    if cmd and string.lower(cmd) == "autorecall" then
        --For backwards compatibility with old slash commands
        RandomCompanion.Slash(cmd);
    else
        -- Uncomment the next few lines to force clearing the PetJournal filters before summoning pets. This will cause RandomCompanion to reload, and may cause a brief pause while this happens.
        C_PetJournal.SetFilterChecked(LE_PET_JOURNAL_FILTER_COLLECTED, true);
        C_PetJournal.SetFilterChecked(LE_PET_JOURNAL_FILTER_NOT_COLLECTED, false);
        C_PetJournal.SetAllPetTypesChecked(true);
        C_PetJournal.SetAllPetSourcesChecked(true);
        C_PetJournal.ClearSearchFilter();
        
        if RC_REQUIRE_RELOAD then
            --Re-initialize if one of the pet or mount names was not available in the initial load
            debugmsg("Re-initializing RandomCompanion in RandomCompanion.Pet()", 2);
            RandomCompanion.Initialize();
        end
        
        local target = UnitName("target");
        debugmsg("Target is " .. (target or "<nil>"), 2);
        
        if target and RandomCompanion_settings.Cloning then
            if not RandomCompanionScanningTooltip then
                CreateFrame("GameTooltip", "RandomCompanionScanningTooltip", UIParent, "GameTooltipTemplate");
            end
            RandomCompanionScanningTooltip:AddFontStrings(
                RandomCompanionScanningTooltip:CreateFontString( "$parentTextLeft1", nil, "GameTooltipText" ),
                RandomCompanionScanningTooltip:CreateFontString( "$parentTextRight1", nil, "GameTooltipText" )
            );
            GameTooltip_SetDefaultAnchor(RandomCompanionScanningTooltip, UIParent);
            RandomCompanionScanningTooltip:SetUnit("target");
            RandomCompanionScanningTooltip:Show();
            local targetname = UnitName("target");
            local targettitle = RandomCompanionScanningTooltipTextLeft2:GetText();
            RandomCompanionScanningTooltip:Hide();
            
            if RandomCompanion.critters.byname[targettitle] then
                --Title should be used first because it's possible that someone could rename their pet to have the same name as another pet
                debugmsg("Found cloneable pet by title " .. targettitle, 5);
                clonetarget = RandomCompanion.critters.byname[targettitle].petID;
            elseif RandomCompanion.critters.byname[targetname] then
                clonetarget = RandomCompanion.critters.byname[targetname].petID;
                debugmsg("Found cloneable pet by name " .. targetname .. ". petID is " .. clonetarget, 5);
            end
        end
        
        --Check if your target is a pet that you have, and clone it
        if clonetarget ~= nil and RandomCompanion_settings.Cloning then
            --Only dismiss if there is an active critter and it's the same as the one that's about to be summoned, otherwise there are problems with RandomCompanion_settings[GetRealmName()][UnitName("player")].ActiveCritter getting removed when you can't actually re-summon your pet, ie when dead
            if RandomCompanion.GetActiveCompanion("CRITTER") and RandomCompanion.GetActiveCompanion("CRITTER") == clonetarget then
                debugmsg("Dismissing because critter is already active", 2);
                RandomCompanion.DismissCompanion("CRITTER");
            end
            debugmsg("Cloning pet: " .. clonetarget .. ".", 10);
            RandomCompanion.origC_PetJournal_SummonPetByGUID(clonetarget);
        elseif #RandomCompanion.critters.weighted > 0 then
            local petindex = nil;
            
            --Loop through 5 times trying to find a usable pet
            for counter = 1, 5 do 
                petindex = random(#RandomCompanion.critters.weighted);
                local companionID = RandomCompanion.critters.weighted[petindex].petID;
                local speciesID, customName, level, xp, maxXp, displayID, discard, petName, petIcon, petType, creatureID = C_PetJournal.GetPetInfoByPetID(companionID, isWild);
                -- local startTime, duration, isEnabled = GetSpellCooldown(petName);
                -- local cooldownRemaining;
                
                -- if startTime > 0 then
                    -- cooldownRemaining = duration - (GetTime() - startTime);
                -- else
                    -- cooldownRemaining = 0;
                -- end
                
                -- if cooldownRemaining < 0.5 then
                    break;
                -- else
                    -- debugmsg("Skipping petID " .. RandomCompanion.critters.weighted[petindex].petID .. " (" .. RandomCompanion.critters.weighted[petindex].name .. ") because it is not currently usable.", 3);
                    -- petindex = nil;
                -- end
            end
            
            if petindex ~= nil then
                --Only dismiss if there is an active critter and it's the same as the one that's about to be summoned, otherwise there are problems with RandomCompanion_settings[GetRealmName()][UnitName("player")].ActiveCritter getting removed when you can't actually re-summon your pet, ie when dead
                if RandomCompanion.GetActiveCompanion("CRITTER") and RandomCompanion.GetActiveCompanion("CRITTER") == RandomCompanion.critters.weighted[petindex].petID then
                    debugmsg("Dismissing because critter is already active", 2);
                    RandomCompanion.DismissCompanion("CRITTER");
                end
                
                debugmsg("Summoning " .. RandomCompanion.critters.weighted[petindex].name .. ". petID is " .. RandomCompanion.critters.weighted[petindex].petID, 10);
                RandomCompanion.origC_PetJournal_SummonPetByGUID(RandomCompanion.critters.weighted[petindex].petID);
            end
        elseif GetNumCompanions("CRITTER") > 0 then
            --We have pets, but they aren't in the pet list. The most likely issue is that no pets were in the cache when RandomCompanion.Initialize() ran, so let's run it again.
            if not RC_REINITIALIZED then
                debugmsg("Re-initializing because pet names weren't cached yet.");
                RC_REINITIALIZED = true; --We don't want an infinite loop, do we?
                RandomCompanion.Initialize();
                RandomCompanion.Pet();
            else
                RC_REINITIALIZED = nil;
            end
        else
            UIErrorsFrame:AddMessage("You have no vanity pets", 1.0, 0.0, 0.0, 53, 5);
        end
    end
end

function RandomCompanion.SetWeight(companion, value)
    if not RandomCompanion_settings then
        RandomCompanion_settings = {};
    end
    
    if not RandomCompanion_settings[GetRealmName()] then
        RandomCompanion_settings[GetRealmName()] = {};
    end
    
    if not RandomCompanion_settings[GetRealmName()][UnitName("player")] then
        RandomCompanion_settings[GetRealmName()][UnitName("player")] = {};
    end
    
    if not RandomCompanion_settings[GetRealmName()][UnitName("player")].weights then
        RandomCompanion_settings[GetRealmName()][UnitName("player")].weights = {};
    end
    
    if not RandomCompanion_settings.accountwide then
        RandomCompanion_settings.accountwide = {};
    end
    
    if not RandomCompanion_settings.accountwide.weights then
        RandomCompanion_settings.accountwide.weights = {};
    end
    
    if RandomCompanion_settings.AccountWideWeights then
        RandomCompanion_settings.accountwide.weights[companion] = value;
        debugmsg("RandomCompanion_settings.accountwide.weights["..companion.."] = "..RandomCompanion_settings.accountwide.weights[companion], 1);
    else
        RandomCompanion_settings[GetRealmName()][UnitName("player")].weights[companion] = value;
        debugmsg("RandomCompanion_settings["..GetRealmName().."]["..UnitName("player").."].weights["..companion.."] = "..RandomCompanion_settings[GetRealmName()][UnitName("player")].weights[companion], 1);
    end
end

function RandomCompanion.GetWeight(companion)
    if RandomCompanion_settings.AccountWideWeights then
        if RandomCompanion_settings.accountwide.weights[companion] then
            return RandomCompanion_settings.accountwide.weights[companion];
        else
            return 1;
        end
    else
        if RandomCompanion_settings[GetRealmName()][UnitName("player")].weights[companion] then
            return RandomCompanion_settings[GetRealmName()][UnitName("player")].weights[companion];
        else
            return 1;
        end
    end
end

function RandomCompanion.GetActiveCompanion(type)
    if type == "CRITTER" then
        activecompanion = C_PetJournal.GetSummonedPetGUID();
    else
        local activecompanion = nil;
        for index,mountID in pairs(C_MountJournal.GetMountIDs()) do
			local name, spellid, icon, active, isUsable, sourceType, isFavorite, _, _, hideOnChar, isCollected, mountID = C_MountJournal.GetMountInfoByID(mountID);
            if active then
                debugmsg("Active " .. string.lower(type) .. " is index " .. index, 5);
                activecompanion = index;
            end
        end
    end
    return activecompanion;
end

function RandomCompanion.SetActiveCompanions()
    local activecritter = RandomCompanion.GetActiveCompanion("CRITTER");
    if activecritter and activecritter ~= RandomCompanion_settings[GetRealmName()][UnitName("player")].ActiveCritter then
        RandomCompanion_settings[GetRealmName()][UnitName("player")].ActiveCritter = activecritter;
        debugmsg("Setting active critter to petID " .. activecritter, 5);
        RandomCompanion.LastCritterChange = GetTime();
    end
    if (RandomCompanion_settings.AutoRecall or RandomCompanion_settings.RandomRecall or RandomCompanion_settings.AutoDismiss or RandomCompanion_settings.RaidDismiss or RandomCompanion_settings.RandomChange) and RandomCompanion_settings[GetRealmName()][UnitName("player")].ActiveCritter then
        RandomCompanion.OnUpdateTime = GetTime() + 2;
        RandomCompanion.EventFrame:SetScript("OnUpdate", RandomCompanion.OnUpdate);
    else
        RandomCompanion.EventFrame:SetScript("OnUpdate", nil);
    end
end

function RandomCompanion.RecallCritter()
    local petID = RandomCompanion_settings[GetRealmName()][UnitName("player")].ActiveCritter;
    if RandomCompanion_settings[GetRealmName()][UnitName("player")].ActiveCritter and RandomCompanion_settings.AutoRecall and petID then
        local speciesID, customName, level, xp, maxXp, displayID, discard, petName, petIcon, petType, creatureID = C_PetJournal.GetPetInfoByPetID(petID);
        if petName then
            -- local startTime, duration, isEnabled = GetSpellCooldown(petName);
            -- local cooldownRemaining;
            if RandomCompanion.GetActiveCompanion("CRITTER") == petID then
                local active = 1;
            else
                local active = 0;
            end
            
            -- if startTime > 0 then
                -- cooldownRemaining = duration - (GetTime() - startTime);
            -- else
                -- cooldownRemaining = 0;
            -- end
            
            -- if not active and cooldownRemaining < 0.5 then
            if not active then
                if (RandomCompanion_settings.AutoRecall or RandomCompanion_settings.RandomRecall or RandomCompanion_settings.AutoDismiss or RandomCompanion_settings.RaidDismiss or RandomCompanion_settings.RandomChange) and petID then
                    RandomCompanion.OnUpdateTime = GetTime() + 2;
                    RandomCompanion.EventFrame:SetScript("OnUpdate", RandomCompanion.OnUpdate);
                else
                    RandomCompanion.EventFrame:SetScript("OnUpdate", nil);
                end
                debugmsg("Automatically recalling critter from petID " .. petID .. " in 2 seconds", 4);
            end
        end
    end
end

function RandomCompanion.Busy()
    local discard, eating, drinking, graccu, stealth, prowl, shadowmeld, invisibility, flightform, swiftflightform, camouflage, amber, oldgod, wispform, transformation, combat, vehicle, casting, channeling, looting, dead, falling, mounted, barbershop, feign, inInstance, instanceType, inraid, petbattle;
    --Check to see if you're doing something that will break when recalling a critter
    eating = UnitBuff("player", RC_STRING_EATING);
    drinking = UnitBuff("player", RC_STRING_DRINKING);
    graccu = UnitBuff("player", RC_STRING_GRACCU);
    stealth = UnitBuff("player", RC_STRING_STEALTH);
    prowl = UnitBuff("player", RC_STRING_PROWL);
    shadowmeld = UnitBuff("player", RC_STRING_SHADOWMELD);
    invisibility = UnitBuff("player", RC_STRING_INVISIBILITY);
    flightform = UnitBuff("player", RC_STRING_FLIGHT_FORM);
    swiftflightform = UnitBuff("player", RC_STRING_SWIFT_FLIGHT_FORM);
    camouflage = UnitBuff("player", RC_STRING_CAMOUFLAGE);
    amber = UnitBuff("player", RC_STRING_TRAPPED_IN_AMBER);
    oldgod = UnitBuff("player", RC_STRING_BLESSING_OF_THE_OLD_GOD);
    wispform = UnitBuff("player", RC_STRING_WISP_FORM);
    transformation = UnitBuff("player", RC_STRING_ENDURE_TRANSFORMATION);
    feign = UnitBuff("player", RC_STRING_FEIGN_DEATH);
    combat = UnitAffectingCombat("player");
    vehicle = UnitInVehicle("player");
    casting, discard, discard, discard, discard, discard = UnitCastingInfo("player");
    channeling, discard, discard, discard, discard, discard = UnitChannelInfo("player");
    looting = GetNumLootItems();
    dead = UnitIsDeadOrGhost("player");
    falling = IsFalling();
    mounted = IsMounted();
    targeting = SpellIsTargeting();
    inInstance, instanceType = IsInInstance();
    petbattle = C_PetBattles.IsInBattle();
    
    if inInstance and instanceType == "raid" and RandomCompanion_settings.RaidDismiss then
        inraid = true;
    end
    
    if BarberShopFrame == nil then
        barbershop = nil;
    else
        barbershop = BarberShopFrame:IsVisible();
    end
    
    if barbershop then
        debugmsg("WTF barber", 1);
    end
    
    if dead or falling or looting ~= 0 or eating or drinking or graccu or combat or casting or channeling or mounted or vehicle or stealth or prowl or shadowmeld or invisibility or flightform or swiftflightform or targeting or camouflage or amber or barbershop or oldgod or wispform or transformation or feign or inraid or petbattle then
        return true;
    else
        return false;
    end
end

function RandomCompanion.OnUpdate()
    if RandomCompanion.OnUpdateTime == nil or GetTime() > RandomCompanion.OnUpdateTime then
        if (RandomCompanion_settings.AutoRecall or RandomCompanion_settings.RandomRecall or RandomCompanion_settings.AutoDismiss or RandomCompanion_settings.RaidDismiss or RandomCompanion_settings.RandomChange) and RandomCompanion_settings[GetRealmName()][UnitName("player")].ActiveCritter then
            RandomCompanion.OnUpdateTime = GetTime() + 2;
            RandomCompanion.EventFrame:SetScript("OnUpdate", RandomCompanion.OnUpdate);
        else
            RandomCompanion.EventFrame:SetScript("OnUpdate", nil);
        end
        
        if (RandomCompanion.RecallTime == nil or GetTime() > RandomCompanion.RecallTime) and (RandomCompanion_settings.AutoRecall or RandomCompanion_settings.RandomRecall or RandomCompanion_settings.RandomChange) and RandomCompanion_settings[GetRealmName()][UnitName("player")].ActiveCritter then
            debugmsg("Checking to recall pets", 1);
            local active = RandomCompanion.GetActiveCompanion("CRITTER");
            
            if RandomCompanion.LastCritterChange == nil then
                RandomCompanion.LastCritterChange = GetTime();
            end
            
            if not active then
                if not RandomCompanion.Busy() then
                    if RandomCompanion.NotBusyTime == nil then
                        --Start the timer to recall
                        debugmsg("Recalling critter in 5.5 seconds", 2);
                        RandomCompanion.NotBusyTime = GetTime();
                        RandomCompanion.RecallTime = GetTime() + .1;
                    end
                    if GetTime() > (RandomCompanion.NotBusyTime + 5.5) then 
                        --You haven't been busy for 5.5 seconds, so it should be safe to recall your critter
                        RandomCompanion.NotBusyTime = nil;
                        RandomCompanion.RecallTime = GetTime() + 2;
                        debugmsg("Recalling critter now", 4);
                        if RandomCompanion_settings.RandomRecall or (RandomCompanion_settings.RandomChange and RandomCompanion.LastCritterChange < (GetTime() - (RandomCompanion_settings.RandomChangeTime * 60))) then
                            RandomCompanion.Pet();
                        else
                            -- Choose a new pet if the current one is a pre-6.0 pet GUID
                            if (string.sub(RandomCompanion_settings[GetRealmName()][UnitName("player")].ActiveCritter, 0, 2) == "0x" or RandomCompanion_settings[GetRealmName()][UnitName("player")].ActiveCritter == tonumber(RandomCompanion_settings[GetRealmName()][UnitName("player")].ActiveCritter)) then
                                debugmsg("Pre-6.0 pet GUID found for active critter. Summoning a new critter instead.", 10);
                                RandomCompanion.Pet();
                            else
                                RandomCompanion.origC_PetJournal_SummonPetByGUID(RandomCompanion_settings[GetRealmName()][UnitName("player")].ActiveCritter);
                            end
                            RandomCompanion.LastChangeTime = GetTime();
                        end
                    else
                        --Need to wait longer
                        RandomCompanion.OnUpdateTime = GetTime() + .2;
                    end
                else
                    RandomCompanion.NotBusyTime = nil;
                    RandomCompanion.RecallTime = GetTime() + 2;
                    debugmsg("Not recalling critter because you are busy.", 2);
                end
            elseif RandomCompanion_settings.RandomChange and RandomCompanion.LastCritterChange < (GetTime() - (RandomCompanion_settings.RandomChangeTime * 60)) then
                if not RandomCompanion.Busy() then
                    if RandomCompanion.NotBusyTime == nil then
                        --Start the timer to recall
                        debugmsg("Changing critter in 5.5 seconds", 2);
                        RandomCompanion.NotBusyTime = GetTime();
                        RandomCompanion.RecallTime = GetTime() + .1;
                    end
                    if GetTime() > (RandomCompanion.NotBusyTime + 5.5) then 
                        --You haven't been busy for 5.5 seconds, so it should be safe to recall your critter
                        RandomCompanion.NotBusyTime = nil;
                        RandomCompanion.RecallTime = GetTime() + 2;
                        debugmsg("Changing critter now", 4);
                        RandomCompanion.Pet();
                    else
                        --Need to wait longer
                        RandomCompanion.OnUpdateTime = GetTime() + .2;
                    end
                else
                    RandomCompanion.NotBusyTime = nil;
                    RandomCompanion.RecallTime = GetTime() + 2;
                    debugmsg("Not changing critter because you are busy.", 1);
                end
            end
        end
        
        if RandomCompanion_settings.AutoDismiss and RandomCompanion_settings[GetRealmName()][UnitName("player")].ActiveCritter then
            debugmsg("Checking to dismiss pets while hiding", 1);
            local stealth, prowl, shadowmeld, invisibility, camouflage, feign;
            local active = RandomCompanion.GetActiveCompanion("CRITTER");
            if active then
                --Check to see if you're stealthed, prowling, or shadowmelded
                stealth = UnitBuff("player", RC_STRING_STEALTH);
                prowl = UnitBuff("player", RC_STRING_PROWL);
                shadowmeld = UnitBuff("player", RC_STRING_SHADOWMELD);
                invisibility = UnitBuff("player", RC_STRING_INVISIBILITY);
                camouflage = UnitBuff("player", RC_STRING_CAMOUFLAGE);
                feign = UnitBuff("player", RC_STRING_FEIGN_DEATH);
                
                if (stealth or prowl or shadowmeld or invisibility or camouflage or feign) and UnitIsPVP("player") then
                    debugmsg("Auto-dismissing critter now because you are hiding", 2);
                    local activecritter = RandomCompanion_settings[GetRealmName()][UnitName("player")].ActiveCritter;
                    RandomCompanion.DismissCompanion("CRITTER");
                end
            end
        end
        
        if RandomCompanion_settings.RaidDismiss and RandomCompanion_settings[GetRealmName()][UnitName("player")].ActiveCritter then
            debugmsg("Checking to dismiss pets in raid", 1);
            local inInstance, instanceType;
            inInstance, instanceType = IsInInstance();
            local active = RandomCompanion.GetActiveCompanion("CRITTER");
            if active and inInstance and instanceType == "raid" then
                debugmsg("Auto-dismissing critter now because you are in a raid", 2);
                local activecritter = RandomCompanion_settings[GetRealmName()][UnitName("player")].ActiveCritter;
                RandomCompanion.DismissCompanion("CRITTER");
            end
        end
    end
end

function RandomCompanion.GetTargetsMount()
    if UnitIsPlayer("target") then
        for buffindex = 1, 40 do
            if RandomCompanion.mounts.byname[UnitBuff("target", buffindex)] ~= nil then
                debugmsg("Target has mount " .. RandomCompanion.mounts.byname[UnitBuff("target", buffindex)].name ..". Index is " .. RandomCompanion.mounts.byname[UnitBuff("target", buffindex)].index, 5);
                return UnitBuff("target", buffindex);
            end
        end
    end
end

function RandomCompanion.PetDismiss()
    DismissCompanion("CRITTER");
end

--Hook into DismissCompanion() so that we don't auto-recall critters that were dismissed on purpose
RandomCompanion.origDismissCompanion = DismissCompanion;
DismissCompanion = function(...)
    RandomCompanion_settings[GetRealmName()][UnitName("player")].ActiveCritter = nil;
    RandomCompanion.EventFrame:SetScript("OnUpdate", nil);
    debugmsg("Critter manually dismissed. Will not auto-recall.", 4);
    RandomCompanion.DismissCompanion(...);
end

RandomCompanion.DismissCompanion = function(...)
    local companiontype = ...;
    
    if (string.lower(companiontype) == "critter") then
        if RandomCompanion.GetActiveCompanion("CRITTER") then
            local isWild = C_PetJournal.isWild;
            local petID, speciesID, isOwned, customName, level, favorite, isRevoked, name, icon, petType, creatureID, sourceText, description, isWildPet, canBattle, tradeable, unique = C_PetJournal.GetPetInfoByPetID(RandomCompanion.GetActiveCompanion("CRITTER"), isWild);
            
            if not isWildPet then
                debugmsg("Dismissing the good ol' way.", 1);
                --Non-Battle-Pets can be dismissed without incurring a GCD
                RandomCompanion.origDismissCompanion("CRITTER");
            else
                debugmsg("Dismissing by id: " .. RandomCompanion.GetActiveCompanion("CRITTER"), 1);
                --Battle pets have to be dismissed by re-summoning them
                RandomCompanion.origC_PetJournal_SummonPetByGUID(RandomCompanion.GetActiveCompanion("CRITTER"));
                --Trick RandomCompanion into thinking we're already "not busy" so auto-recall can re-summon as soon as the Dismiss GCD is over
                --Unfortunately, this only works if AutoRecall is turned on.
                RandomCompanion.NotBusyTime = GetTime() - 6;
            end
        end
    end
    return RandomCompanion.origDismissCompanion(...);
end

--Hook into the PetJournal summon/dismiss function so that we don't auto-recall critters that were dismissed on purpose
RandomCompanion.origC_PetJournal_SummonPetByGUID = C_PetJournal.SummonPetByGUID;
C_PetJournal.SummonPetByGUID = function(...)
    local petID = ...;
    
    if petID == RandomCompanion.GetActiveCompanion("CRITTER") then
        RandomCompanion_settings[GetRealmName()][UnitName("player")].ActiveCritter = nil;
        RandomCompanion.EventFrame:SetScript("OnUpdate", nil);
        debugmsg("Critter manually dismissed. Will not auto-recall.", 4);
    end
    return RandomCompanion.origC_PetJournal_SummonPetByGUID(...);
end

function RandomCompanion.Slash(...)
    local parsedcmd = ...;
    local cmd = "";
    local options = "";
    
    debugmsg("cmd: " .. parsedcmd, 1);
    
    if (...) then
        --Parse any macro conditionals such as [modifier:ctrl] or [combat]
        parsedcmd = SecureCmdOptionParse(...);
    end
    
    if parsedcmd == nil then
        parsedcmd = "";
    end
    
    debugmsg("parsed cmd: " .. parsedcmd, 1);
    
    if string.find(parsedcmd, " ") ~= nil then
        cmd = string.sub(parsedcmd, 0, string.find(parsedcmd, " ") - 1);
        options = string.sub(parsedcmd, string.find(parsedcmd, " ") + 1);
    elseif parsedcmd ~= nil then
        cmd = parsedcmd;
    end
    
    if string.lower(cmd) == "autorecall" then
        if (RandomCompanion_settings.AutoRecall or options == "off") and string.lower(options) ~= "on" then
            RandomCompanion_settings.AutoRecall = false;
            RandomCompanion_settings.RandomRecall = false;
            DEFAULT_CHAT_FRAME:AddMessage("RandomCompanion vanity pet recall disabled");
            if (RandomCompanion_settings.AutoRecall or RandomCompanion_settings.RandomRecall or RandomCompanion_settings.AutoDismiss or RandomCompanion_settings.RaidDismiss or RandomCompanion_settings.RandomChange) and RandomCompanion_settings[GetRealmName()][UnitName("player")].ActiveCritter then
                RandomCompanion.OnUpdateTime = GetTime() + 2;
                RandomCompanion.EventFrame:SetScript("OnUpdate", RandomCompanion.OnUpdate);
            else
                RandomCompanion.EventFrame:SetScript("OnUpdate", nil);
            end
        else
            RandomCompanion_settings.AutoRecall = true;
            RandomCompanion_settings.RandomRecall = false;
            DEFAULT_CHAT_FRAME:AddMessage("RandomCompanion vanity pet recall enabled");
            if (RandomCompanion_settings.AutoRecall or RandomCompanion_settings.RandomRecall or RandomCompanion_settings.AutoDismiss or RandomCompanion_settings.RandomChange) and RandomCompanion_settings[GetRealmName()][UnitName("player")].ActiveCritter then
                RandomCompanion.OnUpdateTime = GetTime() + 2;
                RandomCompanion.EventFrame:SetScript("OnUpdate", RandomCompanion.OnUpdate);
            else
                RandomCompanion.EventFrame:SetScript("OnUpdate", nil);
            end
        end
    elseif string.lower(cmd) == "autodismiss" then
        if (RandomCompanion_settings.AutoDismiss or options == "off") and string.lower(options) ~= "on" then
            RandomCompanion_settings.AutoDismiss = false;
            DEFAULT_CHAT_FRAME:AddMessage("RandomCompanion vanity pet auto-dismiss disabled");
            if (RandomCompanion_settings.AutoRecall or RandomCompanion_settings.RandomRecall or RandomCompanion_settings.AutoDismiss or RandomCompanion_settings.RandomChange) and RandomCompanion_settings[GetRealmName()][UnitName("player")].ActiveCritter then
                RandomCompanion.OnUpdateTime = GetTime() + 2;
                RandomCompanion.EventFrame:SetScript("OnUpdate", RandomCompanion.OnUpdate);
            else
                RandomCompanion.EventFrame:SetScript("OnUpdate", nil);
            end
        else
            RandomCompanion_settings.AutoDismiss = true;
            DEFAULT_CHAT_FRAME:AddMessage("RandomCompanion vanity pet auto-dismiss enabled");
            if (RandomCompanion_settings.AutoRecall or RandomCompanion_settings.RandomRecall or RandomCompanion_settings.AutoDismiss or RandomCompanion_settings.RandomChange) and RandomCompanion_settings[GetRealmName()][UnitName("player")].ActiveCritter then
                RandomCompanion.OnUpdateTime = GetTime() + 2;
                RandomCompanion.EventFrame:SetScript("OnUpdate", RandomCompanion.OnUpdate);
            else
                RandomCompanion.EventFrame:SetScript("OnUpdate", nil);
            end
        end
    elseif string.lower(cmd) == "raiddismiss" then
        if (RandomCompanion_settings.RaidDismiss or options == "off") and string.lower(options) ~= "on" then
            RandomCompanion_settings.RaidDismiss = false;
            DEFAULT_CHAT_FRAME:AddMessage("RandomCompanion vanity pet auto-dismiss disabled");
            if (RandomCompanion_settings.AutoRecall or RandomCompanion_settings.RandomRecall or RandomCompanion_settings.AutoDismiss or RandomCompanion_settings.RaidDismiss or RandomCompanion_settings.RandomChange) and RandomCompanion_settings[GetRealmName()][UnitName("player")].ActiveCritter then
                RandomCompanion.OnUpdateTime = GetTime() + 2;
                RandomCompanion.EventFrame:SetScript("OnUpdate", RandomCompanion.OnUpdate);
            else
                RandomCompanion.EventFrame:SetScript("OnUpdate", nil);
            end
        else
            RandomCompanion_settings.RaidDismiss = true;
            DEFAULT_CHAT_FRAME:AddMessage("RandomCompanion vanity pet auto-dismiss enabled");
            if (RandomCompanion_settings.AutoRecall or RandomCompanion_settings.RandomRecall or RandomCompanion_settings.AutoDismiss or RandomCompanion_settings.RaidDismiss or RandomCompanion_settings.RandomChange) and RandomCompanion_settings[GetRealmName()][UnitName("player")].ActiveCritter then
                RandomCompanion.OnUpdateTime = GetTime() + 2;
                RandomCompanion.EventFrame:SetScript("OnUpdate", RandomCompanion.OnUpdate);
            else
                RandomCompanion.EventFrame:SetScript("OnUpdate", nil);
            end
        end
    elseif string.lower(cmd) == "debug" then    
        if (options ~= "" and tonumber(options) == 0) or (RandomCompanion_settings.DEBUG and (tonumber(options) == nil or options == "")) then
            if (tonumber(options) ~= nil) then
                RandomCompanion_settings.DEBUGLevel = options;
            end
            RandomCompanion_settings.DEBUG = false;
            DEFAULT_CHAT_FRAME:AddMessage("RandomCompanion debug disabled");
        else
            if (tonumber(options) ~= nil) then
                RandomCompanion_settings.DEBUGLevel = options;
            end
            if tonumber(RandomCompanion_settings.DEBUGLevel) < 1 or tonumber(RandomCompanion_settings.DEBUGLevel) == nil then
                RandomCompanion_settings.DEBUGLevel = 1;
            end
            RandomCompanion_settings.DEBUG = true;
            DEFAULT_CHAT_FRAME:AddMessage("RandomCompanion debug enabled - Level " .. RandomCompanion_settings.DEBUGLevel);
        end
    elseif string.lower(cmd) == "randomchange" then    
        if (options ~= "" and tonumber(options) == 0) or (RandomCompanion_settings.RandomChange and (tonumber(options) == nil or options == "")) then
            RandomCompanion_settings.RandomChange = false;
            DEFAULT_CHAT_FRAME:AddMessage("RandomCompanion random vanity pet change disabled");
        else
            if (tonumber(options) ~= nil) then
                RandomCompanion_settings.RandomChangeTime = options;
            end
            if tonumber(RandomCompanion_settings.RandomChangeTime) < 1 or tonumber(RandomCompanion_settings.RandomChangeTime) == nil then
                RandomCompanion_settings.RandomChangeTime = 5;
            end
            RandomCompanion_settings.RandomChange = true;
            DEFAULT_CHAT_FRAME:AddMessage("RandomCompanion random vanity pet change every " .. RandomCompanion_settings.RandomChangeTime .. " minutes");
        end
    elseif string.lower(cmd) == "mount" then
        RandomCompanion.Mount(options);
    elseif string.lower(cmd) == "pet" then
        RandomCompanion.Pet(options);
    elseif string.lower(cmd) == "petdismiss" or string.lower(cmd) == "dismiss" then
        RandomCompanion.PetDismiss(options);
    elseif string.lower(cmd) == "randomrecall" then
        if (RandomCompanion_settings.RandomRecall or options == "off") and string.lower(options) ~= "on" then
            RandomCompanion_settings.AutoRecall = false;
            RandomCompanion_settings.RandomRecall = false;
            DEFAULT_CHAT_FRAME:AddMessage("RandomCompanion random vanity pet recall disabled");
        else
            RandomCompanion_settings.AutoRecall = false;
            RandomCompanion_settings.RandomRecall = true;
            DEFAULT_CHAT_FRAME:AddMessage("RandomCompanion random vanity pet recall enabled");
        end
    elseif string.lower(cmd) == "cloning" then
        if (RandomCompanion_settings.Cloning or options == "off") and string.lower(options) ~= "on" then
            RandomCompanion_settings.Cloning = false;
            DEFAULT_CHAT_FRAME:AddMessage("RandomCompanion pet and mount cloning disabled");
        else
            RandomCompanion_settings.Cloning = true;
            DEFAULT_CHAT_FRAME:AddMessage("RandomCompanion pet and mount cloning enabled");
        end
    elseif string.lower(cmd) == "traincrusher" then
        if (RandomCompanion_settings.Traincrusher or options == "off") and string.lower(options) ~= "on" then
            RandomCompanion_settings.Traincrusher = false;
            RandomCompanion.EventFrame:UnregisterEvent("COMBAT_LOG_EVENT_UNFILTERED");
            DEFAULT_CHAT_FRAME:AddMessage("RandomCompanion traincrusher disabled :(");
        else
            if #RandomCompanion.critters.traincrusher then
                RandomCompanion_settings.Traincrusher = true;
                debugmsg("Parsing combat log events for traincrusher feature", 2);
                RandomCompanion.EventFrame:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED");
                DEFAULT_CHAT_FRAME:AddMessage("RandomCompanion traincrusher enabled!");
            else
                RandomCompanion.EventFrame:UnregisterEvent("COMBAT_LOG_EVENT_UNFILTERED");
                DEFAULT_CHAT_FRAME:AddMessage("No traincrushing pets available. :(");
            end
        end
    elseif string.lower(cmd) == "reload" then
        RandomCompanion.Initialize(true);
    elseif string.lower(cmd) == "status" then
        RandomCompanion.Status();
    elseif string.lower(cmd) == "quiet" then
        if (RandomCompanion_settings.Quiet or options == "off") and string.lower(options) ~= "on" then
            RandomCompanion_settings.Quiet = false;
            DEFAULT_CHAT_FRAME:AddMessage("RandomCompanion quiet mode disabled");
        else
            RandomCompanion_settings.Quiet = true;
            DEFAULT_CHAT_FRAME:AddMessage("RandomCompanion quiet mode enabled");
        end
    elseif parsedcmd == ... then --Show help
    
        DEFAULT_CHAT_FRAME:AddMessage("|cFFFFFF00 RandomCompanion version " .. VERSION);
        DEFAULT_CHAT_FRAME:AddMessage("|cFFFFFF00 Bind a key from the keybinding menu or...");
        DEFAULT_CHAT_FRAME:AddMessage("|cFFFFFF00 \"/rc mount\" to choose a random mount");
        DEFAULT_CHAT_FRAME:AddMessage("|cFFFFFF00 \"/rc mount ground\" to choose a random ground mount in a flyable zone");
        DEFAULT_CHAT_FRAME:AddMessage("|cFFFFFF00 \"/rc mount passenger\" or \"/rc mount passengerground\" to choose a mount that can carry passengers");
        DEFAULT_CHAT_FRAME:AddMessage("|cFFFFFF00 \"/rc pet\" to choose a random vanity pet");
        DEFAULT_CHAT_FRAME:AddMessage("|cFFFFFF00 \"/rc autorecall\" to toggle automatically recalling your vanity pet after resurrecting, changing zones, or taking flight paths");
        DEFAULT_CHAT_FRAME:AddMessage("|cFFFFFF00 \"/rc randomrecall\" to toggle recalling a random vanity pet after resurrecting, changing zones, or taking flight paths");
        DEFAULT_CHAT_FRAME:AddMessage("|cFFFFFF00 \"/rc randomchange [number of minutes]\" to toggle randomly changing your vanity pet occasionally. Default is every 15 minutes");
        DEFAULT_CHAT_FRAME:AddMessage("|cFFFFFF00 \"/rc dismiss\" to dismiss your current vanity pet");
        DEFAULT_CHAT_FRAME:AddMessage("|cFFFFFF00 \"/rc autodismiss\" to toggle automatically dismissing your vanity pet when you are stealthed and flagged for PVP");
        DEFAULT_CHAT_FRAME:AddMessage("|cFFFFFF00 \"/rc raidautodismiss\" to toggle automatically dismissing your vanity pet when you are in a raid");
        DEFAULT_CHAT_FRAME:AddMessage("|cFFFFFF00 \"/rc cloning\" to toggle pet and mount cloning");
        DEFAULT_CHAT_FRAME:AddMessage("|cFFFFFF00 \"/rc traincrusher\" to toggle Traincrusher!");
    end
    
    if (RandomCompanionOptionsCB_AutoRecall) then
        RandomCompanionOptionsCB_AutoRecall:SetChecked(RandomCompanion_settings.AutoRecall);
    end
    if (RandomCompanionOptionsCB_AutoDismiss) then
        RandomCompanionOptionsCB_AutoDismiss:SetChecked(RandomCompanion_settings.AutoDismiss);
    end
    if (RandomCompanionOptionsCB_RaidDismiss) then
        RandomCompanionOptionsCB_RaidDismiss:SetChecked(RandomCompanion_settings.RaidDismiss);
    end
    if (RandomCompanionOptionsCB_RandomRecall) then
        RandomCompanionOptionsCB_RandomRecall:SetChecked(RandomCompanion_settings.RandomRecall);
    end
    if (RandomCompanionOptionsCB_Cloning) then
        RandomCompanionOptionsCB_Cloning:SetChecked(RandomCompanion_settings.Cloning);
    end
    --if (RandomCompanionOptionsCB_RandomChange) then
    --    RandomCompanionOptionsCB_RandomChange:SetChecked(RandomCompanion_settings.RandomChange);
    --end
end

if not RandomCompanion_settings then
    RandomCompanion_settings = {};
end

SlashCmdList["RANDOMMOUNT"] = RandomCompanion.Mount;
SLASH_RANDOMMOUNT1 = "/randommount";
SLASH_RANDOMMOUNT2 = "/rmount";
SLASH_RANDOMMOUNT3 = "/rmt";

SlashCmdList["RANDOMPET"] = RandomCompanion.Pet;
SLASH_RANDOMPET1 = "/randompet";
SLASH_RANDOMPET2 = "/rpet";
SLASH_RANDOMPET3 = "/rpt";

SlashCmdList["PETDISMISS"] = RandomCompanion.PetDismiss;
SLASH_PETDISMISS1 = "/petdismiss";
SLASH_PETDISMISS2 = "/pdismiss";

SlashCmdList["RCSTATUS"] = RandomCompanion.Status;
SLASH_RCSTATUS1 = "/rcstatus";

SlashCmdList["RCDEBUG"] = RandomCompanion.Debug;
SLASH_RCDEBUG1 = "/rcdebug";

SlashCmdList["RCRELOAD"] = RandomCompanion.Initialize;
SLASH_RCRELOAD1 = "/rcreload";

SlashCmdList["RC"] = RandomCompanion.Slash;
SLASH_RC1 = "/rc";
SLASH_RC2 = "/randomcompanion";

RandomCompanion.EventFrame = CreateFrame("Frame", "RandomCompanionFrame");
RandomCompanion.EventFrame:SetScript("OnEvent", RandomCompanion.Event);
RandomCompanion.EventFrame:RegisterEvent("COMPANION_LEARNED");
RandomCompanion.EventFrame:RegisterEvent("COMPANION_UPDATE");
RandomCompanion.EventFrame:RegisterEvent("PLAYER_ENTERING_WORLD");
RandomCompanion.EventFrame:RegisterEvent("PET_JOURNAL_LIST_UPDATE");
RandomCompanion.EventFrame:RegisterEvent("PET_JOURNAL_PET_DELETED");