-- CREATION DATE: 2018-06-01 --
-- Rancher --
------------------------------------------------------------------------------------------------------
local _G = getfenv(0);

-- Addon
local modName = ...;
local sr = CreateFrame("FRAME", modName, UIParent);


RanchPrefix = "NeedAction: ";
local oldSpawnId;
local newSpawnId;
local oldNPCId;
local newNPCId;

-- Keep Config Disabled till after load
local cfg = { 
	enabled = false,
};

-- Action Required Items
--local warnItems = {};

--[[
local ButtonList = {
    "60153", -- Stubborn Weed
    "60185", -- Encroaching Weed
    "60172", -- Occupied Soil
         
    "65913", -- Alluring Enigma Seed
    "65918", -- Infested Enigma Seed
    "65919", -- Parched Enigma Seed
    "65920", -- Runty Enigma Seed
    "65921", -- Smothered Enigma Seed
    "65922", -- Tangled Enigma Seed
    "65924", -- Wiggling Enigma Seed
    "65925", -- Wild Enigma Seed

    "60070", -- Alluring Green Cabbage
    "60026", -- Infested Green Cabbage
    "58565", -- Parched Green Cabbage
    "60218", -- Runty Green Cabbage
    "60181", -- Smothered Green Cabbage
    "60270", -- Tangled Green Cabbage
    "60029", -- Wiggling Green Cabbage
    "60207", -- Wild Green Cabbage

    "66107", -- Alluring Jade Squash
    "66110", -- Infested Jade Squash
    "66111", -- Parched Jade Squash
    "66114", -- Runty Jade Squash
    "66115", -- Smothered Jade Squash
    "66116", -- Tangled Jade Squash
    "66117", -- Wiggling Jade Squash
    "66118", -- Wild Jade Squash

    "63147", -- Alluring Juicycrunch Carrot
    "63145", -- Infested Juicycrunch Carrot
    "63144", -- Parched Juicycrunch Carrot
    "63150", -- Runty Juicycrunch Carrot
    "63148", -- Smothered Juicycrunch Carrot
    "63151", -- Tangled Juicycrunch Carrot
    "63146", -- Wiggling Juicycrunch Carrot
    "63149", -- Wild Juicycrunch Carrot

    "65985", -- Alluring Magebulb
    "65987", -- Infested Magebulb
    "65988", -- Parched Magebulb
    "65990", -- Runty Magebulb
    "65991", -- Smothered Magebulb
    "65992", -- Tangled Magebulb
    "65993", -- Wiggling Magebulb
    "65994", -- Wild Magebulb

    "63178", -- Alluring Mogu Pumpkin
    "63182", -- Infested Mogu Pumpkin
    "63183", -- Parched Mogu Pumpkin
    "63186", -- Runty Mogu Pumpkin
    "63187", -- Smothered Mogu Pumpkin
    "63188", -- Tangled Mogu Pumpkin
    "63189", -- Wiggling Mogu Pumpkin
    "63190", -- Wild Mogu Pumpkin

    "63243", -- Alluring Pink Turnip
    "63247", -- Infested Pink Turnip
    "63248", -- Parched Pink Turnip
    "63251", -- Runty Pink Turnip
    "63252", -- Smothered Pink Turnip
    "63253", -- Tangled Pink Turnip
    "63254", -- Wiggling Pink Turnip
    "63255", -- Wild Pink Turnip

    "66012", -- Alluring Raptorleaf
    "66014", -- Infested Raptorleaf
    "66015", -- Parched Raptorleaf
    "66017", -- Runty Raptorleaf
    "66018", -- Smothered Raptorleaf
    "66019", -- Tangled Raptorleaf
    "66020", -- Wiggling Raptorleaf
    "66021", -- Wild Raptorleaf

    "63222", -- Alluring Red Blossom Leek
    "63226", -- Infested Red Blossom Leek
    "63227", -- Parched Red Blossom Leek
    "63230", -- Runty Red Blossom Leek
    "63231", -- Smothered Red Blossom Leek
    "63232", -- Tangled Red Blossom Leek
    "63233", -- Wiggling Red Blossom Leek
    "63234", -- Wild Red Blossom Leek

    "63159", -- Alluring Scallions
    "63162", -- Infested Scallions
    "63163", -- Parched Scallions
    "63166", -- Runty Scallions
    "63167", -- Smothered Scallions
    "63168", -- Tangled Scallions
    "63169", -- Wiggling Scallions
    "63170", -- Wild Scallions

    "65964", -- Alluring Snakeroot
    "65966", -- Infested Snakeroot
    "65967", -- Parched Snakeroot
    "65968", -- Runty Snakeroot
    "65969", -- Smothered Snakeroot
    "65970", -- Tangled Snakeroot
    "65971", -- Wiggling Snakeroot
    "65972", -- Wild Snakeroot

    "66039", -- Alluring Songbell
    "66041", -- Infested Songbell
    "66042", -- Parched Songbell
    "66044", -- Runty Songbell
    "66045", -- Smothered Songbell
    "66046", -- Tangled Songbell
    "66047", -- Wiggling Songbell
    "66048", -- Wild Songbell

    "66122", -- Alluring Striped Melon
    "66125", -- Infested Striped Melon
    "66127", -- Parched Striped Melon
    "66130", -- Runty Striped Melon
    "66131", -- Smothered Striped Melon
    "66132", -- Tangled Striped Melon
    "66133", -- Wiggling Striped Melon
    "66134", -- Wild Striped Melon

    "63259", -- Alluring White Turnip
    "63262", -- Infested White Turnip
    "63263", -- Parched White Turnip
    "63267", -- Runty White Turnip
    "63268", -- Smothered White Turnip
    "63269", -- Tangled White Turnip
    "63270", -- Wiggling White Turnip
    "63271", -- Wild White Turnip

    "66002", -- Alluring Windshear Cactus
    "66004", -- Infested Windshear Cactus
    "66005", -- Parched Windshear Cactus
    "66007", -- Runty Windshear Cactus
    "66008", -- Smothered Windshear Cactus
    "66009", -- Tangled Windshear Cactus
    "66010", -- Wiggling Windshear Cactus
    "66011", -- Wild Windshear Cactus

    "66079", -- Alluring Witchberries
    "66082", -- Infested Witchberries
    "66083", -- Parched Witchberries
    "66086", -- Runty Witchberries
    "66087", -- Smothered Witchberries
    "66088", -- Tangled Witchberries
    "66089", -- Wiggling Witchberries
    "66090", -- Wild Witchberries
};
]]--

local defwarnItems = {
    ["60153"]=0, -- Stubborn Weed
    ["60185"]=1, -- Encroaching Weed
    ["60172"]=1, -- Occupied Soil
          
    ["65913"]=0, -- Alluring Enigma Seed
    ["65918"]=1, -- Infested Enigma Seed
    ["65919"]=1, -- Parched Enigma Seed
    ["65920"]=0, -- Runty Enigma Seed
    ["65921"]=0, -- Smothered Enigma Seed
    ["65922"]=0, -- Tangled Enigma Seed
    ["65924"]=1, -- Wiggling Enigma Seed
    ["65925"]=0, -- Wild Enigma Seed

    ["60070"]=0, -- Alluring Green Cabbage
    ["60026"]=1, -- Infested Green Cabbage
    ["58565"]=1, -- Parched Green Cabbage
    ["60218"]=0, -- Runty Green Cabbage
    ["60181"]=0, -- Smothered Green Cabbage
    ["60270"]=0, -- Tangled Green Cabbage
    ["60029"]=1, -- Wiggling Green Cabbage
    ["60207"]=0, -- Wild Green Cabbage

    ["66107"]=0, -- Alluring Jade Squash
    ["66110"]=1, -- Infested Jade Squash
    ["66111"]=1, -- Parched Jade Squash
    ["66114"]=0, -- Runty Jade Squash
    ["66115"]=0, -- Smothered Jade Squash
    ["66116"]=0, -- Tangled Jade Squash
    ["66117"]=1, -- Wiggling Jade Squash
    ["66118"]=0, -- Wild Jade Squash

    ["63147"]=0, -- Alluring Juicycrunch Carrot
    ["63145"]=1, -- Infested Juicycrunch Carrot
    ["63144"]=1, -- Parched Juicycrunch Carrot
    ["63150"]=0, -- Runty Juicycrunch Carrot
    ["63148"]=0, -- Smothered Juicycrunch Carrot
    ["63151"]=0, -- Tangled Juicycrunch Carrot
    ["63146"]=1, -- Wiggling Juicycrunch Carrot
    ["63149"]=0, -- Wild Juicycrunch Carrot

    ["65985"]=0, -- Alluring Magebulb
    ["65987"]=1, -- Infested Magebulb
    ["65988"]=1, -- Parched Magebulb
    ["65990"]=0, -- Runty Magebulb
    ["65991"]=0, -- Smothered Magebulb
    ["65992"]=0, -- Tangled Magebulb
    ["65993"]=1, -- Wiggling Magebulb
    ["65994"]=0, -- Wild Magebulb

    ["63178"]=0, -- Alluring Mogu Pumpkin
    ["63182"]=1, -- Infested Mogu Pumpkin
    ["63183"]=1, -- Parched Mogu Pumpkin
    ["63186"]=0, -- Runty Mogu Pumpkin
    ["63187"]=0, -- Smothered Mogu Pumpkin
    ["63188"]=0, -- Tangled Mogu Pumpkin
    ["63189"]=1, -- Wiggling Mogu Pumpkin
    ["63190"]=0, -- Wild Mogu Pumpkin

    ["63243"]=0, -- Alluring Pink Turnip
    ["63247"]=1, -- Infested Pink Turnip
    ["63248"]=1, -- Parched Pink Turnip
    ["63251"]=0, -- Runty Pink Turnip
    ["63252"]=0, -- Smothered Pink Turnip
    ["63253"]=0, -- Tangled Pink Turnip
    ["63254"]=1, -- Wiggling Pink Turnip
    ["63255"]=0, -- Wild Pink Turnip

    ["66012"]=0, -- Alluring Raptorleaf
    ["66014"]=1, -- Infested Raptorleaf
    ["66015"]=1, -- Parched Raptorleaf
    ["66017"]=0, -- Runty Raptorleaf
    ["66018"]=0, -- Smothered Raptorleaf
    ["66019"]=0, -- Tangled Raptorleaf
    ["66020"]=1, -- Wiggling Raptorleaf
    ["66021"]=0, -- Wild Raptorleaf

    ["63222"]=0, -- Alluring Red Blossom Leek
    ["63226"]=1, -- Infested Red Blossom Leek
    ["63227"]=1, -- Parched Red Blossom Leek
    ["63230"]=0, -- Runty Red Blossom Leek
    ["63231"]=0, -- Smothered Red Blossom Leek
    ["63232"]=0, -- Tangled Red Blossom Leek
    ["63233"]=1, -- Wiggling Red Blossom Leek
    ["63234"]=0, -- Wild Red Blossom Leek

    ["63159"]=0, -- Alluring Scallions
    ["63162"]=1, -- Infested Scallions
    ["63163"]=1, -- Parched Scallions
    ["63166"]=0, -- Runty Scallions
    ["63167"]=0, -- Smothered Scallions
    ["63168"]=0, -- Tangled Scallions
    ["63169"]=1, -- Wiggling Scallions
    ["63170"]=0, -- Wild Scallions

    ["65964"]=0, -- Alluring Snakeroot
    ["65966"]=1, -- Infested Snakeroot
    ["65967"]=1, -- Parched Snakeroot
    ["65968"]=0, -- Runty Snakeroot
    ["65969"]=0, -- Smothered Snakeroot
    ["65970"]=0, -- Tangled Snakeroot
    ["65971"]=1, -- Wiggling Snakeroot
    ["65972"]=0, -- Wild Snakeroot

    ["66039"]=0, -- Alluring Songbell
    ["66041"]=1, -- Infested Songbell
    ["66042"]=1, -- Parched Songbell
    ["66044"]=0, -- Runty Songbell
    ["66045"]=0, -- Smothered Songbell
    ["66046"]=0, -- Tangled Songbell
    ["66047"]=1, -- Wiggling Songbell
    ["66048"]=0, -- Wild Songbell

    ["66122"]=0, -- Alluring Striped Melon
    ["66125"]=1, -- Infested Striped Melon
    ["66127"]=1, -- Parched Striped Melon
    ["66130"]=0, -- Runty Striped Melon
    ["66131"]=0, -- Smothered Striped Melon
    ["66132"]=0, -- Tangled Striped Melon
    ["66133"]=1, -- Wiggling Striped Melon
    ["66134"]=0, -- Wild Striped Melon

    ["63259"]=0, -- Alluring White Turnip
    ["63262"]=1, -- Infested White Turnip
    ["63263"]=1, -- Parched White Turnip
    ["63267"]=0, -- Runty White Turnip
    ["63268"]=0, -- Smothered White Turnip
    ["63269"]=0, -- Tangled White Turnip
    ["63270"]=1, -- Wiggling White Turnip
    ["63271"]=0, -- Wild White Turnip

    ["66002"]=0, -- Alluring Windshear Cactus
    ["66004"]=1, -- Infested Windshear Cactus
    ["66005"]=1, -- Parched Windshear Cactus
    ["66007"]=0, -- Runty Windshear Cactus
    ["66008"]=0, -- Smothered Windshear Cactus
    ["66009"]=0, -- Tangled Windshear Cactus
    ["66010"]=1, -- Wiggling Windshear Cactus
    ["66011"]=0, -- Wild Windshear Cactus

    ["66079"]=0, -- Alluring Witchberries
    ["66082"]=1, -- Infested Witchberries
    ["66083"]=1, -- Parched Witchberries
    ["66086"]=0, -- Runty Witchberries
    ["66087"]=0, -- Smothered Witchberries
    ["66088"]=0, -- Tangled Witchberries
    ["66089"]=1, -- Wiggling Witchberries
    ["66090"]=0, -- Wild Witchberries
};

-- No Action Required
local okItems = {
-- Unoccupied plots
    ["58562"]=1, -- Untilled Soil
-- Growing crops
    ["65916"]=1, -- Growing Enigma Seed
    ["58566"]=1, -- Growing Green Cabbage
    ["66109"]=1, -- Growing Jade Squash
    ["63153"]=1, -- Growing Juicycrunch Carrot
    ["65986"]=1, -- Growing Magebulb
    ["63181"]=1, -- Growing Mogu Pumpkin
    ["63246"]=1, -- Growing Pink Turnip
    ["66013"]=1, -- Growing Raptorleaf
    ["63224"]=1, -- Growing Red Blossom Leek
    ["63161"]=1, -- Growing Scallions
    ["65965"]=1, -- Growing Snakeroot
    ["66040"]=1, -- Growing Songbell
    ["66124"]=1, -- Growing Striped Melon
    ["63261"]=1, -- Growing White Turnip
    ["66003"]=1, -- Growing Windshear Cactus
    ["66081"]=1, -- Growing Witchberries
    ["67482"]=1, -- Portal Shard
};


------------------------------------------------------------------------------------------------------
-- Global Chat Message Function

function AzMsg(msg) 
	DEFAULT_CHAT_FRAME:AddMessage(tostring(msg):gsub("|1","|cffffff80"):gsub("|2","|cffffffff"),0.5,0.75,1.0); 
end


------------------------------------------------------------------------------------------------------

function UpdateOptions()
	AzMsg( "|1Rancher:|2 Closing Update Options." );
end


function RancherShowOptions()
	RancherOptions:Show();
end


function RancherHideOptions()
	RancherOptions:Hide();

end


function RancherToggleOptions()
	if ( not RancherOptions:IsShown() ) then
		RancherOptions:Show();
	else
		RancherOptions:Hide();
	end
end

function initCheckButtons()
    for id, warn in pairs(warnItems) do
		if warn == 1 then
			_G["b"..id]:SetChecked(true);
		else
			_G["b"..id]:SetChecked(false);
		end	
	end
end


-- OnTooltipSetUnit
local function RancherOnTooltipSetUnit(uTip, ...)
	local sName, iUnit = uTip:GetUnit()
    if cfg.enabled then
        if iUnit then
            if ( GetSubZoneText() == "Sunsong Ranch" ) then
                local guid, name = UnitGUID(iUnit), UnitName(iUnit)
                local type, zero, server_id, instance_id, zone_uid, npc_id, spawn_uid = strsplit("-",guid);
                newSpawnId = spawn_uid;
                newNPCId = npc_id;
--                print("NPC: ",npc_id," - ",UnitGUID(iUnit));
                for id, warn in pairs(warnItems) do
--                    print("id: ", id," - ",warn);
                    if ( id == npc_id ) then
                        if (newSpawnId ~= oldSpawnId) or (newNPCId ~= oldNPCId) then
--                            uTip:AddLine(RanchPrefix .. id);
--                            uTip:Show();
                            if ( warn == 1 ) then
								PlaySoundFile( "Interface\\AddOns\\Rancher\\Sounds\\uh-oh.mp3", "SFX" )
                            end
							break
                        end
                    end
                end
                for id, warn in pairs(okItems) do
                    if ( id == npc_id ) then
                        if (newSpawnId ~= oldSpawnId) or (newNPCId ~= oldNPCId) then
							if ( warn == 1 ) then
							    PlaySoundFile( "Interface\\AddOns\\Rancher\\Sounds\\ting.mp3", "SFX" )
                            end
							break
                        end
                    end
                end
                if (newSpawnId ~= oldSpawnId) then 
                    oldSpawnId = newSpawnId
                end
                if (newNPCId ~= oldNPCId) then 
                    oldNPCId = newNPCId
                end
            end
        end
    end
end


function sr:RequestUpdate()
	self:SetScript("OnUpdate",OnUpdate);
end


------------------------------------------------------------------------------------------------------
-- Initialise

sr:SetScript("OnEvent",function(self,event,...) if (self[event]) then self[event](self,event,...); else self:RequestUpdate(); end end);

sr:RegisterEvent("ADDON_LOADED"); -- Fired when saved variables are loaded
--sr:RegisterEvent("PLAYER_LOGOUT"); -- Fired when about to log out

GameTooltip:HookScript("OnTooltipSetUnit", RancherOnTooltipSetUnit)

-- Wait for load of Saved Variables
function sr:ADDON_LOADED(event,addon)
	if (addon ~= modName) then
		return;
	end
	AzMsg("|2"..modName.."|r Initializing...");
-- Check if Variables loaded, else set defaults
	if warnItems == nil then
		AzMsg("|2"..modName.."|r Variables defaulted.");
		warnItems = defwarnItems;
	end
    initCheckButtons();
-- Enable Config
    cfg.enabled = true;
end


------------------------------------------------------------------------------------------------------

--------------------------------------------------------------------------------------------------------
--                                            Command Line                                            --
--------------------------------------------------------------------------------------------------------
_G["SLASH_"..modName.."1"] = "/rancher";
_G["SLASH_"..modName.."2"] = "/sr";
SlashCmdList[modName] = function(cmd)
	-- Extract Parameters
	local param1, param2 = cmd:match("^([^%s]+)%s*(.*)$");
	param1 = (param1 and param1:lower() or cmd:lower());
	-- Enabled
	if (param1 == "toggle") or (param1 == "on") or (param1 == "off") then
		if (InCombatLockdown()) then
			AzMsg("|2"..modName.."|r Cannot toggle in combat");
		elseif (param1 == "toggle") then
		    cfg.enabled = not cfg.enabled;
		elseif (param1 == "on") then
		    cfg.enabled = true;
		elseif (param1 == "off") then
		    cfg.enabled = false;
		end
		AzMsg("|2"..modName.."|r has now been |1"..(cfg.enabled and "enabled" or "disabled").."|r.");
	elseif (param1 == "reset") then
		warnItems = nil;
		warnItems = defwarnItems;
		RancherShowOptions();
		initCheckButtons();
		AzMsg("|2"..modName.."|r values have now been reset.");
	else
		UpdateAddOnMemoryUsage();
		AzMsg(format("----- |2%s|r |1%s|r ----- |1%.2f |2kb|r -----",modName,GetAddOnMetadata(modName,"Version"),GetAddOnMemoryUsage(modName)));
		AzMsg("The following |2parameters|r are valid for this addon:");
		AzMsg(" |2toggle|r = Toggles the mod status on or off");
		AzMsg(" |2reset |r = Resets the default values.");
		AzMsg(" |2on    |r = Sets the mod on");
		AzMsg(" |2off   |r = Sets the mod off");
		RancherToggleOptions();
	end
end

