-- my custom locale file - more streamlined than AceLocale and no lib dependency

-- To help with missing translations please go here:
local url = "http://www.wowace.com/addons/raidbuffstatus/localization/"

local addonName, vars = ...
local Ld, La = {}, {}
local locale = GAME_LOCALE or GetLocale()
if locale == "enGB" then locale = "enUS" end
if locale == "esMX" then locale = "esES" end

vars.L = setmetatable({},{
    __index = function(t, s) 
      if locale ~= "enUS" and Ld[s] and
         not La[s] and url and not vars.locale_warning then
        vars.locale_warning = true
        print(string.format("*** %s needs help translating to your language! (%s)", addonName, locale))
	print("*** If you speak English, you can contribute by visiting:")
	print("*** "..url)
      end
      return La[s] or Ld[s] or rawget(t,s) or s 
    end
})

Ld["Announce even when you don't have assist or lead"] = "Announce even when you don't have assist or lead"
Ld["Announce expiration"] = "Announce expiration"
Ld["Announcement options for raid utilities like Feasts"] = "Announcement options for raid utilities like Feasts"
Ld["Announce to raid warning when a %s is prepared"] = "Announce to raid warning when a %s is prepared"
Ld["Announce to raid warning when a utility is expiring"] = "Announce to raid warning when a utility is expiring"
Ld["Announce without lead"] = "Announce without lead"
Ld["Augment Banquet Tooltips"] = "Augment Banquet Tooltips"
Ld["Augment Banquet Tooltips with stat bonus information"] = "Augment Banquet Tooltips with stat bonus information"
Ld["Augment Rune"] = "Augment Rune"
Ld["Blingtron"] = "Blingtron"
Ld["Blingtron about to expire!"] = "Blingtron about to expire!"
Ld["Bonus"] = "Bonus"
Ld["Broken Link"] = "Broken Link"
Ld["casts %s"] = "casts %s"
Ld["Eating"] = "Eating"
Ld["Expiration announcements"] = "Expiration announcements"
Ld[" has set us up a Blingtron"] = " has set us up a Blingtron"
Ld["has set us up a %s"] = "has set us up a %s"
Ld["Mailbox"] = "Mailbox"
Ld["Noodle Cart"] = "Noodle Cart"
Ld["Portal"] = "Portal"
Ld["Prefer Static Buff"] = "Prefer Static Buff"
Ld["Report missing static buffs even when an equivalent passive aura is already present."] = "Report missing static buffs even when an equivalent passive aura is already present."
Ld["Required flask quality"] = "Required flask quality"
Ld["Right-click to target"] = "Right-click to target"
Ld["Select which level of flask quality you require"] = "Select which level of flask quality you require"
Ld["sets up a %s"] = "sets up a %s"
Ld["Show configuration options"] = "Show configuration options"
Ld["Soulwell"] = "Soulwell"
Ld["Tooltip name coloring"] = "Tooltip name coloring"
Ld["Tooltip role icons"] = "Tooltip role icons"
Ld["Treat eating as Well Fed"] = "Treat eating as Well Fed"
Ld["Treat players who are currently eating as Well Fed. This assumes they are eating acceptable food."] = "Treat players who are currently eating as Well Fed. This assumes they are eating acceptable food."
Ld["Utility announcements"] = "Utility announcements"
Ld["Warrior Stance"] = "Warrior Stance"
Ld.BuffOptionsWindow = {
	["Buff Options"] = "Buff Options",
	["Is a buff"] = "Is a buff",
	["Is a warning"] = "Is a warning",
	["Report on Boss"] = "Report on Boss",
	["Report on Trash"] = "Report on Trash",
	["Show on dashboard"] = "Show on dashboard",
	["Show/Report in combat"] = "Show/Report in combat",
}
Ld.CrowdControlWarnings = {
	["Melee Swing"] = "Melee Swing",
	["Non-tank %s broke %s on %s%s%s"] = "Non-tank %s broke %s on %s%s%s",
	["Non-tank %s broke %s on %s%s%s with %s"] = "Non-tank %s broke %s on %s%s%s with %s",
	["%s broke %s on %s%s%s"] = "%s broke %s on %s%s%s",
	["%s broke %s on %s%s%s with %s"] = "%s broke %s on %s%s%s with %s",
}
Ld.Messages = {
	AFK = "AFK",
	Agil = "Agil",
	alpha = "alpha",
	["Alt-Click on a party buff will cast on someone missing that buff."] = "Alt-Click on a party buff will cast on someone missing that buff.",
	["Alt-Click on a self buff will renew that buff."] = "Alt-Click on a self buff will renew that buff.",
	["Aspect Cheetah/Pack On"] = "Aspect Cheetah/Pack On",
	["Aspect of the Cheetah or Pack is on"] = "Aspect of the Cheetah or Pack is on",
	["Battle Elixir"] = "Battle Elixir",
	beta = "beta",
	["Blessing of Kings is not needed because you are grouped with a Druid."] = "Blessing of Kings is not needed because you are grouped with a Druid.",
	["Blessing of Kings, with this raid configuration, is better provided by Drums of the Forgotten Kings thus allowing Blessing of Might to be used."] = "Blessing of Kings, with this raid configuration, is better provided by Drums of the Forgotten Kings thus allowing Blessing of Might to be used.",
	Boss = "Boss",
	["Buffers: "] = "Buffers: ",
	["Buffing Kings:"] = "Buffing Kings:",
	["Buffing Might:"] = "Buffing Might:",
	["Cast by:"] = "Cast by:",
	["Click buffs to disable and enable."] = "Click buffs to disable and enable.",
	["Click to toggle the RBS dashboard"] = "Click to toggle the RBS dashboard",
	["Ctrl-Click Boss or Trash to whisper all those who need to buff."] = "Ctrl-Click Boss or Trash to whisper all those who need to buff.",
	["Ctrl-Click buffs to whisper those who need to buff."] = "Ctrl-Click buffs to whisper those who need to buff.",
	Dead = "Dead",
	["Death Knight Presence"] = "Death Knight Presence",
	["Different Zone"] = "Different Zone",
	["Flasked or Elixired but slacking"] = "Flasked or Elixired but slacking",
	["Flask or two Elixirs"] = "Flask or two Elixirs",
	["Guardian Elixir"] = "Guardian Elixir",
	["Has buff: "] = "Has buff: ",
	[" has set us up a Refreshment Table"] = " has set us up a Refreshment Table",
	[" has set us up a Repair Bot"] = " has set us up a Repair Bot",
	[" has set us up a Soul Well"] = " has set us up a Soul Well",
	["Healer %s has died!"] = "Healer %s has died!",
	["Health less than 80%"] = "Health less than 80%",
	["Hide outgoing whispers"] = "Hide outgoing whispers",
	["Hunter Aspect"] = "Hunter Aspect",
	["Hunter has no aspect at all"] = "Hunter has no aspect at all",
	["[IMMUNE]"] = "[IMMUNE]",
	Int = "Int",
	[" in their bags"] = " in their bags",
	["Invite auto-accepted from battle.net friend %s."] = "Invite auto-accepted from battle.net friend %s.",
	["Invite auto-accepted from friend %s."] = "Invite auto-accepted from friend %s.",
	["Invite auto-accepted from guild member %s."] = "Invite auto-accepted from guild member %s.",
	["Item count: "] = "Item count: ",
	["Low durability"] = "Low durability",
	["Low durability (35% or less)"] = "Low durability (35% or less)",
	["Mage is missing a Mage Armor"] = "Mage is missing a Mage Armor",
	["Mana less than 80%"] = "Mana less than 80%",
	["MANY!"] = "MANY!",
	["Melee DPS %s has died!"] = "Melee DPS %s has died!",
	["Missing "] = "Missing ",
	["Missing a scroll"] = "Missing a scroll",
	["Missing buff: "] = "Missing buff: ",
	["Missing buffs (Boss): "] = "Missing buffs (Boss): ",
	["Missing buffs (Trash): "] = "Missing buffs (Trash): ",
	["Missing or not working oRA or RBS: "] = "Missing or not working oRA or RBS: ",
	No = "No",
	["No buffs needed! (Boss)"] = "No buffs needed! (Boss)",
	["No buffs needed! (Trash)"] = "No buffs needed! (Trash)",
	["No Soulstone detected"] = "No Soulstone detected",
	["Not Well Fed"] = "Not Well Fed",
	Offline = "Offline",
	["Out of range"] = "Out of range",
	["Paladin blessing"] = "Paladin blessing",
	["Paladin missing Seal"] = "Paladin missing Seal",
	["Player has a wrong Paladin blessing"] = "Player has a wrong Paladin blessing",
	["Player has health less than 80%"] = "Player has health less than 80%",
	["Player has mana less than 80%"] = "Player has mana less than 80%",
	["Player is AFK"] = "Player is AFK",
	["Player is Dead"] = "Player is Dead",
	["Player is in a different zone"] = "Player is in a different zone",
	["Player is missing at least one Paladin blessing"] = "Player is missing at least one Paladin blessing",
	["Player is Offline"] = "Player is Offline",
	["Please relog or reload UI to update the item cache."] = "Please relog or reload UI to update the item cache.",
	["prepares a %s!"] = "prepares a %s!",
	["Press Escape -> Interface -> AddOns -> RaidBuffStatus for more options."] = "Press Escape -> Interface -> AddOns -> RaidBuffStatus for more options.",
	Prot = "Prot",
	["Protection Paladin with no Righteous Fury"] = "Protection Paladin with no Righteous Fury",
	["PVP is On"] = "PVP is On",
	["PVP On"] = "PVP On",
	["Ranged DPS %s has died!"] = "Ranged DPS %s has died!",
	["RBS Dashboard Help"] = "RBS Dashboard Help",
	["RBS Tank List"] = "RBS Tank List",
	["Refreshment Table about to expire!"] = "Refreshment Table about to expire!",
	["Remind me later"] = "Remind me later",
	["(Remove buff)"] = "(Remove buff)",
	["Remove this button from this dashboard in the buff options window."] = "Remove this button from this dashboard in the buff options window.",
	["Repair Bot about to expire!"] = "Repair Bot about to expire!",
	["[RESIST]"] = "[RESIST]",
	["Right-click to open the addons options menu"] = "Right-click to open the addons options menu",
	["%s about to expire!"] = "%s about to expire!",
	Scan = "Scan",
	["%s cast %s on %s"] = "%s cast %s on %s",
	Scroll = "Scroll",
	Seal = "Seal",
	["Sent %d whispers to %d players"] = "Sent %d whispers to %d players",
	["%s has a newer (%s) version of RBS (%s) than you (%s)"] = "%s has a newer (%s) version of RBS (%s) than you (%s)",
	["Shift-Click buffs to report on only that buff."] = "Shift-Click buffs to report on only that buff.",
	["%s is running RBS %s"] = "%s is running RBS %s",
	["Slackers: "] = "Slackers: ",
	["Slacking Paladins"] = "Slacking Paladins",
	["Sorry, I am queued for"] = "Sorry, I am queued for",
	["Sorry, I am queued for a battlefield."] = "Sorry, I am queued for a battlefield.",
	["Sorry, the group is now full."] = "Sorry, the group is now full.",
	["Soul Well about to expire!"] = "Soul Well about to expire!",
	Spi = "Spi",
	Sta = "Sta",
	Str = "Str",
	["Tank missing Earth Shield"] = "Tank missing Earth Shield",
	["Tank missing Thorns"] = "Tank missing Thorns",
	["Tank %s has died!"] = "Tank %s has died!",
	["Tank with "] = "Tank with ",
	["The above default button actions can be reconfigured."] = "The above default button actions can be reconfigured.",
	["This is the first time RaidBuffStatus has been activated since installation or settings were reset. Would you like to visit the Buff Wizard to help you get RBS buffs configured? If you are a raid leader then you can click No as the defaults are already set up for you."] = "This is the first time RaidBuffStatus has been activated since installation or settings were reset. Would you like to visit the Buff Wizard to help you get RBS buffs configured? If you are a raid leader then you can click No as the defaults are already set up for you.",
	["Tol Barad"] = "Tol Barad",
	Trash = "Trash",
	["Warning: "] = "Warning: ",
	["Warnings: "] = "Warnings: ",
	["Weapon buff"] = "Weapon buff",
	["Well Fed but slacking"] = "Well Fed but slacking",
	Wintergrasp = "Wintergrasp",
	["Wrong flask for this zone"] = "Wrong flask for this zone",
	["Wrong Paladin blessing"] = "Wrong Paladin blessing",
	["You need to be leader or assistant to do this"] = "You need to be leader or assistant to do this",
	["You need to whisper the leader instead: "] = "You need to whisper the leader instead: ",
}
Ld.Options = {
	Alive = "Alive",
	["Allow raiders to use flasks and elixirs from last expansion"] = "Allow raiders to use flasks and elixirs from last expansion",
	["Alt-left click"] = "Alt-left click",
	["Alt-right click"] = "Alt-right click",
	["Always hide the Boss R Trash buttons"] = "Always hide the Boss R Trash buttons",
	["Announce to raid warning when a Feast is prepared"] = "Announce to raid warning when a Feast is prepared",
	["Anti spam"] = "Anti spam",
	Appearance = "Appearance",
	["Auto-accept invites"] = "Auto-accept invites",
	["Auto-invite whispers"] = "Auto-invite whispers",
	["Automatically accept invites from friends and guild members so you can go for a bio-break whilst waiting for a raid invite"] = "Automatically accept invites from friends and guild members so you can go for a bio-break whilst waiting for a raid invite",
	["Automatically accept invites from these"] = "Automatically accept invites from these",
	["Automatically configures the dashboard buffs and configuration defaults for your class or raid leading role"] = "Automatically configures the dashboard buffs and configuration defaults for your class or raid leading role",
	["Automatically invite friends and guild members who whisper to you the word 'invite'"] = "Automatically invite friends and guild members who whisper to you the word 'invite'",
	["Automatically invite these"] = "Automatically invite these",
	["Automatically show the dashboard when you join a battleground"] = "Automatically show the dashboard when you join a battleground",
	["Automatically show the dashboard when you join a party"] = "Automatically show the dashboard when you join a party",
	["Automatically show the dashboard when you join a raid"] = "Automatically show the dashboard when you join a raid",
	["Automatically whisper anyone missing a Healthstone when your Soul Well expire warnings appear"] = "Automatically whisper anyone missing a Healthstone when your Soul Well expire warnings appear",
	["Automatically whisper anyone missing flasks or elixirs when your Cauldron expire warnings appear"] = "Automatically whisper anyone missing flasks or elixirs when your Cauldron expire warnings appear",
	["Automatically whisper anyone missing Well Fed when your Feast expire warnings appear"] = "Automatically whisper anyone missing Well Fed when your Feast expire warnings appear",
	Automation = "Automation",
	["Background colour"] = "Background colour",
	["Bar positioning"] = "Bar positioning",
	["Battle.net friends"] = "Battle.net friends",
	["Border colour"] = "Border colour",
	["Bosses only"] = "Bosses only",
	Bottom = "Bottom",
	["Buff button sorting"] = "Buff button sorting",
	["Buff Options scale"] = "Buff Options scale",
	["Buff those missing buff"] = "Buff those missing buff",
	["Buff Wizard"] = "Buff Wizard",
	Cauldron = "Cauldron",
	["Cauldron auto whisper"] = "Cauldron auto whisper",
	["CC-break warnings"] = "CC-break warnings",
	["Choose either one big collection of buff checks or traditional style with Warnings, Trash and Boss buff checks"] = "Choose either one big collection of buff checks or traditional style with Warnings, Trash and Boss buff checks",
	["Choose where on the dashboard the bars appear"] = "Choose where on the dashboard the bars appear",
	["Class-specific buffs"] = "Class-specific buffs",
	Combat = "Combat",
	["Combat options"] = "Combat options",
	["Configure how the buff buttons and status bars on the dashboard are sorted and displayed"] = "Configure how the buff buttons and status bars on the dashboard are sorted and displayed",
	["Consumable options"] = "Consumable options",
	Consumables = "Consumables",
	["Core raid buffs"] = "Core raid buffs",
	["Ctrl-left click"] = "Ctrl-left click",
	["Ctrl-right click"] = "Ctrl-right click",
	["Danielbarron broke Sheep on The Lich King with Hand of Reckoning"] = "Danielbarron broke Sheep on The Lich King with Hand of Reckoning",
	["Darinia ninjaed my target (The Lich King) with Taunt"] = "Darinia ninjaed my target (The Lich King) with Taunt",
	["Darinia taunted my mob (The Lich King) with Taunt"] = "Darinia taunted my mob (The Lich King) with Taunt",
	["Darinia taunted my target (The Lich King) with Taunt"] = "Darinia taunted my target (The Lich King) with Taunt",
	["Dashboard columns"] = "Dashboard columns",
	["Dashboard mouse button actions options"] = "Dashboard mouse button actions options",
	["Dashboard scale"] = "Dashboard scale",
	["Death warnings"] = "Death warnings",
	["Default order"] = "Default order",
	["Disable scan in combat"] = "Disable scan in combat",
	["DPS mana"] = "DPS mana",
	["Enable/disable buff check"] = "Enable/disable buff check",
	["Enable tank warnings including taunts, failed taunts and mob stealing"] = "Enable tank warnings including taunts, failed taunts and mob stealing",
	["Enable tank warnings including taunts, failed taunts and mob stealing only on bosses"] = "Enable tank warnings including taunts, failed taunts and mob stealing only on bosses",
	["Enable warning messages when players die"] = "Enable warning messages when players die",
	["Enable warnings when Crowd Control is broken by tanks and non-tanks"] = "Enable warnings when Crowd Control is broken by tanks and non-tanks",
	["Enable warnings when Misdirection or Tricks of the Trade is cast"] = "Enable warnings when Misdirection or Tricks of the Trade is cast",
	["Feast auto whisper"] = "Feast auto whisper",
	Feasts = "Feasts",
	["Food announce"] = "Food announce",
	Friends = "Friends",
	["Grouping style"] = "Grouping style",
	["Guild members"] = "Guild members",
	["Healer death"] = "Healer death",
	["Healer drinking"] = "Healer drinking",
	["Healer drinking sound"] = "Healer drinking sound",
	["Healer mana"] = "Healer mana",
	["Healers alive"] = "Healers alive",
	["Healer Stormsnow has died!"] = "Healer Stormsnow has died!",
	["Hide and show the buff report dashboard."] = "Hide and show the buff report dashboard.",
	["Hide Boss R Trash"] = "Hide Boss R Trash",
	["Hide dashboard during combat"] = "Hide dashboard during combat",
	["Hide in combat"] = "Hide in combat",
	["Hide the buff report dashboard."] = "Hide the buff report dashboard.",
	["Highlight my buffs"] = "Highlight my buffs",
	["Hightlight currently missing buffs on the dashboard for which you are responsible including self buffs and buffs which you are missing that are provided by someone else. I.e. show buffs for which you must take action"] = "Hightlight currently missing buffs on the dashboard for which you are responsible including self buffs and buffs which you are missing that are provided by someone else. I.e. show buffs for which you must take action",
	["How MANY?"] = "How MANY?",
	["Ignore groups 6 to 8"] = "Ignore groups 6 to 8",
	["Ignore groups 6 to 8 when reporting as these are for subs"] = "Ignore groups 6 to 8 when reporting as these are for subs",
	["[IMMUNE] Danielbarron FAILED TO TAUNT their target (The Lich King) with Hand of Reckoning"] = "[IMMUNE] Danielbarron FAILED TO TAUNT their target (The Lich King) with Hand of Reckoning",
	["In range"] = "In range",
	invite = "invite",
	["Just my buffs"] = "Just my buffs",
	["Left click"] = "Left click",
	["Melee DPS Danielbarron has died!"] = "Melee DPS Danielbarron has died!",
	["Melee DPS death"] = "Melee DPS death",
	["Minimap icon"] = "Minimap icon",
	["Minimum remaining buff duration in minutes. Buffs with less than this will be considered as missing.  This option only takes affect when the corresponding 'buff' button is enabled on the dashboard."] = "Minimum remaining buff duration in minutes. Buffs with less than this will be considered as missing.  This option only takes affect when the corresponding 'buff' button is enabled on the dashboard.",
	["Min remaining buff duration"] = "Min remaining buff duration",
	["Misdirection warnings"] = "Misdirection warnings",
	["Mouse buttons"] = "Mouse buttons",
	["Move with Alt-click"] = "Move with Alt-click",
	["My buffs"] = "My buffs",
	["Ninja taunts"] = "Ninja taunts",
	["No healer close"] = "No healer close",
	None = "None",
	["Non-tank breaks CC"] = "Non-tank breaks CC",
	["Non-tank Glamor broke Hex on The Lich King with Moonfire"] = "Non-tank Glamor broke Hex on The Lich King with Moonfire",
	["NON-TANK Tanagra taunted my target (The Lich King) with Growl"] = "NON-TANK Tanagra taunted my target (The Lich King) with Growl",
	["Non-tank taunts my target"] = "Non-tank taunts my target",
	["Number of columns to display on the dashboard"] = "Number of columns to display on the dashboard",
	["Old flasks and elixirs"] = "Old flasks and elixirs",
	["One big group"] = "One big group",
	["One group down"] = "One group down",
	["Only if all have it"] = "Only if all have it",
	["Only me"] = "Only me",
	["Only show the buffs for which your class is responsible for.  This configuration can be used like a buff-bot where one simply right clicks on the buffs to cast them"] = "Only show the buffs for which your class is responsible for.  This configuration can be used like a buff-bot where one simply right clicks on the buffs to cast them",
	["Only show the core class raid buffs"] = "Only show the core class raid buffs",
	["Only show when you and only you break Crowd Control so you can say 'Now I don't believe you wanted to do that did you, ehee?'"] = "Only show when you and only you break Crowd Control so you can say 'Now I don't believe you wanted to do that did you, ehee?'",
	["Only use tank list"] = "Only use tank list",
	["Only use the tank list and ignore spec when there is a tank list for determining if someone is a tank or not"] = "Only use the tank list and ignore spec when there is a tank list for determining if someone is a tank or not",
	["Options for automatically opening the dashboard and moving it"] = "Options for automatically opening the dashboard and moving it",
	["Options for setting the quality requirements of consumables"] = "Options for setting the quality requirements of consumables",
	["Options to do with configuring the tank list"] = "Options to do with configuring the tank list",
	Other = "Other",
	["Other taunt fails"] = "Other taunt fails",
	["Play a sound"] = "Play a sound",
	["Play a sound when a healer dies"] = "Play a sound when a healer dies",
	["Play a sound when a healer drinks and is not full on mana"] = "Play a sound when a healer drinks and is not full on mana",
	["Play a sound when a melee DPS dies"] = "Play a sound when a melee DPS dies",
	["Play a sound when a non-tank breaks Crowd Control"] = "Play a sound when a non-tank breaks Crowd Control",
	["Play a sound when a ranged DPS dies"] = "Play a sound when a ranged DPS dies",
	["Play a sound when a tank breaks Crowd Control"] = "Play a sound when a tank breaks Crowd Control",
	["Play a sound when a tank dies"] = "Play a sound when a tank dies",
	["Play a sound when Misdirection or Tricks of the Trade is cast"] = "Play a sound when Misdirection or Tricks of the Trade is cast",
	["Play a sound when one of your taunts fails due to resist"] = "Play a sound when one of your taunts fails due to resist",
	["Play a sound when one of your taunts fails due to the target being immune"] = "Play a sound when one of your taunts fails due to the target being immune",
	["Play a sound when other people's taunts to your target fail"] = "Play a sound when other people's taunts to your target fail",
	["Play a sound when someone else targets a mob and taunts that mob which is targeting you"] = "Play a sound when someone else targets a mob and taunts that mob which is targeting you",
	["Play a sound when someone else taunts your target"] = "Play a sound when someone else taunts your target",
	["Play a sound when someone else taunts your target which is targeting you"] = "Play a sound when someone else taunts your target which is targeting you",
	["Play a sound when someone else who is not a tank taunts your target"] = "Play a sound when someone else who is not a tank taunts your target",
	["Prepend RBS::"] = "Prepend RBS::",
	["Prepend RBS:: to all lines of report chat. Disable to only prepend on the first line of a report"] = "Prepend RBS:: to all lines of report chat. Disable to only prepend on the first line of a report",
	["Raid health"] = "Raid health",
	["Raid leader"] = "Raid leader",
	["Raid mana"] = "Raid mana",
	["Raid Status Bars"] = "Raid Status Bars",
	["Raid-wide buffs"] = "Raid-wide buffs",
	["Ranged DPS death"] = "Ranged DPS death",
	["Ranged DPS Garmann has died!"] = "Ranged DPS Garmann has died!",
	["Refreshment Table"] = "Refreshment Table",
	["Repair Bot"] = "Repair Bot",
	Reporting = "Reporting",
	["Reporting options"] = "Reporting options",
	["Report missing to raid"] = "Report missing to raid",
	["Report to officer channel"] = "Report to officer channel",
	["Report to officers"] = "Report to officers",
	["Report to /raid or /party who is not buffed to the max."] = "Report to /raid or /party who is not buffed to the max.",
	["Report to raid/party"] = "Report to raid/party",
	["Report to raid/party - requires raid assistant"] = "Report to raid/party - requires raid assistant",
	["Report to self"] = "Report to self",
	["Required food quality"] = "Required food quality",
	["Require the Alt buton to be held down to move the dashboard window"] = "Require the Alt buton to be held down to move the dashboard window",
	["[RESIST] Danielbarron FAILED TO TAUNT their target (The Lich King) with Hand of Reckoning"] = "[RESIST] Danielbarron FAILED TO TAUNT their target (The Lich King) with Hand of Reckoning",
	["[RESIST] Darinia FAILED TO TAUNT my target (The Lich King) with Taunt"] = "[RESIST] Darinia FAILED TO TAUNT my target (The Lich King) with Taunt",
	["Right click"] = "Right click",
	["Scale the Buff Options window"] = "Scale the Buff Options window",
	["Scale the dashboard window"] = "Scale the dashboard window",
	["Seconds between updates"] = "Seconds between updates",
	["Select which action to take when you click with the left mouse button over a dashboard buff check"] = "Select which action to take when you click with the left mouse button over a dashboard buff check",
	["Select which action to take when you click with the left mouse button with Alt held down over a dashboard buff check"] = "Select which action to take when you click with the left mouse button with Alt held down over a dashboard buff check",
	["Select which action to take when you click with the left mouse button with Ctrl held down over a dashboard buff check"] = "Select which action to take when you click with the left mouse button with Ctrl held down over a dashboard buff check",
	["Select which action to take when you click with the left mouse button with Shift held down over a dashboard buff check"] = "Select which action to take when you click with the left mouse button with Shift held down over a dashboard buff check",
	["Select which action to take when you click with the right mouse button over a dashboard buff check"] = "Select which action to take when you click with the right mouse button over a dashboard buff check",
	["Select which action to take when you click with the right mouse button with Alt held down over a dashboard buff check"] = "Select which action to take when you click with the right mouse button with Alt held down over a dashboard buff check",
	["Select which action to take when you click with the right mouse button with Ctrl held down over a dashboard buff check"] = "Select which action to take when you click with the right mouse button with Ctrl held down over a dashboard buff check",
	["Select which action to take when you click with the right mouse button with Shift held down over a dashboard buff check"] = "Select which action to take when you click with the right mouse button with Shift held down over a dashboard buff check",
	["Select which level of food quality you require for the raiders to be considered 'Well Fed'"] = "Select which level of food quality you require for the raiders to be considered 'Well Fed'",
	["Self buffs"] = "Self buffs",
	["Set how many seconds between dashboard raid scan updates"] = "Set how many seconds between dashboard raid scan updates",
	["Set N - the number of people missing a buff considered to be \"MANY\""] = "Set N - the number of people missing a buff considered to be \"MANY\"",
	["Shift-left click"] = "Shift-left click",
	["Shift-right click"] = "Shift-right click",
	["Shorten names"] = "Shorten names",
	["Shorten names in the report to reduce channel spam"] = "Shorten names in the report to reduce channel spam",
	["Show group number"] = "Show group number",
	["Show in battleground"] = "Show in battleground",
	["Show in party"] = "Show in party",
	["Show in raid"] = "Show in raid",
	["Show the buff report dashboard."] = "Show the buff report dashboard.",
	["Show the group number of the person missing a party/raid buff"] = "Show the group number of the person missing a party/raid buff",
	["Single target buffs"] = "Single target buffs",
	["Skin and minimap options"] = "Skin and minimap options",
	["Skin and scaling"] = "Skin and scaling",
	["Skip buff checking during combat. You can manually initiate a scan by pressing Scan on the dashboard"] = "Skip buff checking during combat. You can manually initiate a scan by pressing Scan on the dashboard",
	["%s minutes"] = "%s minutes",
	["Sort buff buttons by"] = "Sort buff buttons by",
	["Soul Well"] = "Soul Well",
	["Status bars to show raid, dps, tank health, mana, etc"] = "Status bars to show raid, dps, tank health, mana, etc",
	["Tank breaks CC"] = "Tank breaks CC",
	["Tank Danielbarron has died!"] = "Tank Danielbarron has died!",
	["Tank death"] = "Tank death",
	["Tank health"] = "Tank health",
	["Tank list"] = "Tank list",
	["Tanks alive"] = "Tanks alive",
	["Tank warnings"] = "Tank warnings",
	["Tank warnings about taunts, failed taunts and mob stealing including accidental taunts from non-tanks"] = "Tank warnings about taunts, failed taunts and mob stealing including accidental taunts from non-tanks",
	["Taunts to my mobs"] = "Taunts to my mobs",
	["Taunts to my target"] = "Taunts to my target",
	["Tells you when someone in your party, raid or guild has a newer version of RBS installed"] = "Tells you when someone in your party, raid or guild has a newer version of RBS installed",
	["Tells you when someone in your party, raid or guild has RBS installed"] = "Tells you when someone in your party, raid or guild has RBS installed",
	Test = "Test",
	["Test what the warning is like"] = "Test what the warning is like",
	["The average DPS mana percent"] = "The average DPS mana percent",
	["The average healer mana percent"] = "The average healer mana percent",
	["The average party/raid health percent"] = "The average party/raid health percent",
	["The average party/raid mana percent"] = "The average party/raid mana percent",
	["The average tank health percent"] = "The average tank health percent",
	["The Buff Wizard automatically configures the dashboard buffs and configuration defaults for your class or raid leading role."] = "The Buff Wizard automatically configures the dashboard buffs and configuration defaults for your class or raid leading role.",
	["Then sort buff buttons by"] = "Then sort buff buttons by",
	["The percentage of healers alive in the raid"] = "The percentage of healers alive in the raid",
	["The percentage of people alive in the raid"] = "The percentage of people alive in the raid",
	["The percentage of people dead in the raid"] = "The percentage of people dead in the raid",
	["The percentage of people within 40 yards range"] = "The percentage of people within 40 yards range",
	["The percentage of tanks alive in the raid"] = "The percentage of tanks alive in the raid",
	["This is the default configuration in which RBS ships out-of-the-box.  It gives you pretty much anything a raid leader would need to see on the dashboard"] = "This is the default configuration in which RBS ships out-of-the-box.  It gives you pretty much anything a raid leader would need to see on the dashboard",
	["Toggle to display a minimap icon"] = "Toggle to display a minimap icon",
	Top = "Top",
	["To set this option go to the addon configuration.  This button is automatically enabled when the Boss button is pressed and automatically disabled when the Trash button is pressed.  To permanently disable, choose 0 seconds as the min remaining buff duration."] = "To set this option go to the addon configuration.  This button is automatically enabled when the Boss button is pressed and automatically disabled when the Trash button is pressed.  To permanently disable, choose 0 seconds as the min remaining buff duration.",
	["Two groups down"] = "Two groups down",
	["User announce"] = "User announce",
	["Version announce"] = "Version announce",
	["Wait before announcing to see if others have announced first in order to reduce spam"] = "Wait before announcing to see if others have announced first in order to reduce spam",
	["Warning messages when players die"] = "Warning messages when players die",
	["Warnings when Crowd Control is broken by tanks and non-tanks"] = "Warnings when Crowd Control is broken by tanks and non-tanks",
	["Warnings when Misdirection or Tricks of the Trade is cast"] = "Warnings when Misdirection or Tricks of the Trade is cast",
	["Warnings when someone else targets a mob and taunts that mob which is targeting you"] = "Warnings when someone else targets a mob and taunts that mob which is targeting you",
	["Warnings when someone else taunts your target"] = "Warnings when someone else taunts your target",
	["Warnings when someone else taunts your target who is not a tank"] = "Warnings when someone else taunts your target who is not a tank",
	["Warning, Trash, Boss groups"] = "Warning, Trash, Boss groups",
	["Warns when a non-tank breaks Crowd Control"] = "Warns when a non-tank breaks Crowd Control",
	["Warns when a tank breaks Crowd Control"] = "Warns when a tank breaks Crowd Control",
	["Warns when other people's taunts to your target fail"] = "Warns when other people's taunts to your target fail",
	["Warns when someone else taunts your target which is targeting you"] = "Warns when someone else taunts your target which is targeting you",
	["Warns when your taunts fail due to resist"] = "Warns when your taunts fail due to resist",
	["Warns when your taunts fail due to the target being immune"] = "Warns when your taunts fail due to the target being immune",
	["Warn to party"] = "Warn to party",
	["Warn to party when a healer dies"] = "Warn to party when a healer dies",
	["Warn to party when a melee DPS dies"] = "Warn to party when a melee DPS dies",
	["Warn to party when a non-tank breaks Crowd Control"] = "Warn to party when a non-tank breaks Crowd Control",
	["Warn to party when a ranged DPS dies"] = "Warn to party when a ranged DPS dies",
	["Warn to party when a tank breaks Crowd Control"] = "Warn to party when a tank breaks Crowd Control",
	["Warn to party when a tank dies"] = "Warn to party when a tank dies",
	["Warn to party when one of your taunts fails due to resist"] = "Warn to party when one of your taunts fails due to resist",
	["Warn to party when one of your taunts fails due to the target being immune"] = "Warn to party when one of your taunts fails due to the target being immune",
	["Warn to party when other people's taunts to your target fail"] = "Warn to party when other people's taunts to your target fail",
	["Warn to party when someone else targets a mob and taunts that mob which is targeting you"] = "Warn to party when someone else targets a mob and taunts that mob which is targeting you",
	["Warn to party when someone else taunts your target"] = "Warn to party when someone else taunts your target",
	["Warn to party when someone else taunts your target which is targeting you"] = "Warn to party when someone else taunts your target which is targeting you",
	["Warn to party when someone else who is not a tank taunts your target"] = "Warn to party when someone else who is not a tank taunts your target",
	["Warn to raid chat"] = "Warn to raid chat",
	["Warn to raid chat when a healer dies"] = "Warn to raid chat when a healer dies",
	["Warn to raid chat when a melee DPS dies"] = "Warn to raid chat when a melee DPS dies",
	["Warn to raid chat when a non-tank breaks Crowd Control"] = "Warn to raid chat when a non-tank breaks Crowd Control",
	["Warn to raid chat when a ranged DPS dies"] = "Warn to raid chat when a ranged DPS dies",
	["Warn to raid chat when a tank breaks Crowd Control"] = "Warn to raid chat when a tank breaks Crowd Control",
	["Warn to raid chat when a tank dies"] = "Warn to raid chat when a tank dies",
	["Warn to raid chat when one of your taunts fails due to resist"] = "Warn to raid chat when one of your taunts fails due to resist",
	["Warn to raid chat when one of your taunts fails due to the target being immune"] = "Warn to raid chat when one of your taunts fails due to the target being immune",
	["Warn to raid chat when other people's taunts to your target fail"] = "Warn to raid chat when other people's taunts to your target fail",
	["Warn to raid chat when someone else targets a mob and taunts that mob which is targeting you"] = "Warn to raid chat when someone else targets a mob and taunts that mob which is targeting you",
	["Warn to raid chat when someone else taunts your target"] = "Warn to raid chat when someone else taunts your target",
	["Warn to raid chat when someone else taunts your target which is targeting you"] = "Warn to raid chat when someone else taunts your target which is targeting you",
	["Warn to raid chat when someone else who is not a tank taunts your target"] = "Warn to raid chat when someone else who is not a tank taunts your target",
	["Warn to raid warning"] = "Warn to raid warning",
	["Warn to self"] = "Warn to self",
	["Warn to self when a healer dies"] = "Warn to self when a healer dies",
	["Warn to self when a melee DPS dies"] = "Warn to self when a melee DPS dies",
	["Warn to self when a non-tank breaks Crowd Control"] = "Warn to self when a non-tank breaks Crowd Control",
	["Warn to self when a ranged DPS dies"] = "Warn to self when a ranged DPS dies",
	["Warn to self when a tank breaks Crowd Control"] = "Warn to self when a tank breaks Crowd Control",
	["Warn to self when a tank dies"] = "Warn to self when a tank dies",
	["Warn to self when Misdirection or Tricks of the Trade is cast"] = "Warn to self when Misdirection or Tricks of the Trade is cast",
	["Warn to self when one of your taunts fails due to resist"] = "Warn to self when one of your taunts fails due to resist",
	["Warn to self when one of your taunts fails due to the target being immune"] = "Warn to self when one of your taunts fails due to the target being immune",
	["Warn to self when other people's taunts to your target fail"] = "Warn to self when other people's taunts to your target fail",
	["Warn to self when someone else targets a mob and taunts that mob which is targeting you"] = "Warn to self when someone else targets a mob and taunts that mob which is targeting you",
	["Warn to self when someone else taunts your target"] = "Warn to self when someone else taunts your target",
	["Warn to self when someone else taunts your target which is targeting you"] = "Warn to self when someone else taunts your target which is targeting you",
	["Warn to self when someone else who is not a tank taunts your target"] = "Warn to self when someone else who is not a tank taunts your target",
	["Warn using raid warning when a healer dies"] = "Warn using raid warning when a healer dies",
	["Warn using raid warning when a melee DPS dies"] = "Warn using raid warning when a melee DPS dies",
	["Warn using raid warning when a non-tank breaks Crowd Control"] = "Warn using raid warning when a non-tank breaks Crowd Control",
	["Warn using raid warning when a ranged DPS dies"] = "Warn using raid warning when a ranged DPS dies",
	["Warn using raid warning when a tank breaks Crowd Control"] = "Warn using raid warning when a tank breaks Crowd Control",
	["Warn using raid warning when a tank dies"] = "Warn using raid warning when a tank dies",
	["Warn using raid warning when one of your taunts fails due to resist"] = "Warn using raid warning when one of your taunts fails due to resist",
	["Warn using raid warning when one of your taunts fails due to the target being immune"] = "Warn using raid warning when one of your taunts fails due to the target being immune",
	["Warn using raid warning when other people's taunts to your target fail"] = "Warn using raid warning when other people's taunts to your target fail",
	["Warn using raid warning when someone else targets a mob and taunts that mob which is targeting you"] = "Warn using raid warning when someone else targets a mob and taunts that mob which is targeting you",
	["Warn using raid warning when someone else taunts your target"] = "Warn using raid warning when someone else taunts your target",
	["Warn using raid warning when someone else taunts your target which is targeting you"] = "Warn using raid warning when someone else taunts your target which is targeting you",
	["Warn using raid warning when someone else who is not a tank taunts your target"] = "Warn using raid warning when someone else who is not a tank taunts your target",
	["Warn when a healer dies"] = "Warn when a healer dies",
	["Warn when a melee DPS dies"] = "Warn when a melee DPS dies",
	["Warn when a ranged DPS dies"] = "Warn when a ranged DPS dies",
	["Warn when a tank dies"] = "Warn when a tank dies",
	["Well auto whisper"] = "Well auto whisper",
	["When at least N people are missing a raid buff say MANY instead of spamming a list"] = "When at least N people are missing a raid buff say MANY instead of spamming a list",
	["When many say so"] = "When many say so",
	["When there are multiple people who can provide a missing buff such as Fortitude then only whisper one of them at random who is in range rather than all of them"] = "When there are multiple people who can provide a missing buff such as Fortitude then only whisper one of them at random who is in range rather than all of them",
	["When whispering and at least N people are missing a raid buff say MANY instead of spamming a list"] = "When whispering and at least N people are missing a raid buff say MANY instead of spamming a list",
	["Whisper buffers"] = "Whisper buffers",
	["Whisper many"] = "Whisper many",
	["Whisper only one"] = "Whisper only one",
	["Your taunt immune-fails"] = "Your taunt immune-fails",
	["Your taunt resist-fails"] = "Your taunt resist-fails",
}
Ld.RaidStatusBars = {
	["Dead healers"] = "Dead healers",
	["Dead tanks"] = "Dead tanks",
	["I see dead people"] = "I see dead people",
	["n/a"] = "n/a",
	P = "P",
	["Pull Timer"] = "Pull Timer",
	R = "R",
	["Ready Check"] = "Ready Check",
}
Ld.TalentsWindow = {
	Class = "Class",
	Healer = "Healer",
	["Melee DPS"] = "Melee DPS",
	Name = "Name",
	["Ranged DPS"] = "Ranged DPS",
	Refresh = "Refresh",
	Role = "Role",
	Spec = "Spec",
	Specialisations = "Specialisations",
	["Talent Specialisations"] = "Talent Specialisations",
	Tank = "Tank",
}
Ld.TankTauntWarnings = {
	["NON-TANK %s taunted my boss target (%s%s%s) with %s"] = "NON-TANK %s taunted my boss target (%s%s%s) with %s",
	["NON-TANK %s taunted my target (%s%s%s) with %s"] = "NON-TANK %s taunted my target (%s%s%s) with %s",
	["%s FAILED TO NINJA my boss target (%s%s%s) with %s"] = "%s FAILED TO NINJA my boss target (%s%s%s) with %s",
	["%s FAILED TO NINJA my target (%s%s%s) with %s"] = "%s FAILED TO NINJA my target (%s%s%s) with %s",
	["%s FAILED TO TAUNT my boss target (%s%s%s) with %s"] = "%s FAILED TO TAUNT my boss target (%s%s%s) with %s",
	["%s FAILED TO TAUNT my target (%s%s%s) with %s"] = "%s FAILED TO TAUNT my target (%s%s%s) with %s",
	["%s FAILED TO TAUNT their boss target (%s%s%s) with %s"] = "%s FAILED TO TAUNT their boss target (%s%s%s) with %s",
	["%s FAILED TO TAUNT their target (%s%s%s) with %s"] = "%s FAILED TO TAUNT their target (%s%s%s) with %s",
	["%s ninjaed my boss target (%s%s%s) with %s"] = "%s ninjaed my boss target (%s%s%s) with %s",
	["%s ninjaed my target (%s%s%s) with %s"] = "%s ninjaed my target (%s%s%s) with %s",
	["%s taunted my boss mob (%s%s%s) with %s"] = "%s taunted my boss mob (%s%s%s) with %s",
	["%s taunted my boss target (%s%s%s) with %s"] = "%s taunted my boss target (%s%s%s) with %s",
	["%s taunted my mob (%s%s%s) with %s"] = "%s taunted my mob (%s%s%s) with %s",
	["%s taunted my target (%s%s%s) with %s"] = "%s taunted my target (%s%s%s) with %s",
}


if locale == "frFR" then do end
La["Announce even when you don't have assist or lead"] = "Annonce même si vous n'êtes pas assist ou lead"
La["Announce expiration"] = "Annonce d'expiration" -- Needs review
La["Announcement options for raid utilities like Feasts"] = "Option des annonces des utilitaires de raids comme les festins"
La["Announce to raid warning when a %s is prepared"] = "Annoncer en alerte de raid quand un %s est préparé"
-- La["Announce to raid warning when a utility is expiring"] = ""
La["Announce without lead"] = "Annonce sans lead"
La["Augment Banquet Tooltips"] = "Enrichir les info-bulles des Banquets"
La["Augment Banquet Tooltips with stat bonus information"] = "Enrichir les info-bulles des Banquets avec les bonus de caractéristiques"
La["Augment Rune"] = "Rune d’amélioration" -- Needs review
La["Blingtron"] = "Bling-o-tron"
La["Blingtron about to expire!"] = "Bling-o-tron va bientôt disparaître!"
La["Bonus"] = "Bonus"
La["Broken Link"] = "Lien brisé" -- Needs review
La["casts %s"] = "lance %s" -- Needs review
La["Eating"] = "En train de manger" -- Needs review
La["Expiration announcements"] = "Annonces d'expiration" -- Needs review
La[" has set us up a Blingtron"] = " nous a délicatement dégainé un Bling-o-tron."
La["has set us up a %s"] = "a sorti un %s"
La["Mailbox"] = "Boite aux lettres"
La["Noodle Cart"] = "Stand de nouilles"
La["Portal"] = "Portail"
La["Prefer Static Buff"] = "Préférer les buffs statiques"
La["Report missing static buffs even when an equivalent passive aura is already present."] = "Rapporter les buffs statiques manquants quand une aura/buff passif est déjà présent"
-- La["Required flask quality"] = ""
La["Right-click to target"] = "Click-droit pour cibler"
-- La["Select which level of flask quality you require"] = ""
La["sets up a %s"] = "mets en place un %s" -- Needs review
La["Show configuration options"] = "Montrer les options de configuration"
La["Soulwell"] = "Puits des âmes"
La["Tooltip name coloring"] = "Couleur du nom dans l'info-bulle"
La["Tooltip role icons"] = "Icône de rôle dans l'info-bulle"
La["Treat eating as Well Fed"] = "Considérer \"En train de manger\" comme \"Bien nourri\"" -- Needs review
La["Treat players who are currently eating as Well Fed. This assumes they are eating acceptable food."] = "Considérer les joueurs en train de manger comme étant \"Bien nourri\". Cela suppose qu'il mange de la nourriture adaptée." -- Needs review
La["Utility announcements"] = "Annonces utilitaires"
La["Warrior Stance"] = "Posture du Guerrier" -- Needs review
La.BuffOptionsWindow = {
	["Buff Options"] = "Options des buffs.",
	["Is a buff"] = "Est un buff",
	["Is a warning"] = "Est un avertissement",
	["Report on Boss"] = "Rapport sur les boss",
	["Report on Trash"] = "Rapport sur les trash",
	["Show on dashboard"] = "Montrer sur le tableau de bord",
	["Show/Report in combat"] = "Montrer/Rapporter en combat",
}
La.CrowdControlWarnings = {
	["Melee Swing"] = "Sorts de mêlée",
	["Non-tank %s broke %s on %s%s%s"] = "Le non tank %s a cassé %s sur %s%s%s",
	["Non-tank %s broke %s on %s%s%s with %s"] = "Le non tank %s a cassé %s sur %s%s%s avec %s",
	["%s broke %s on %s%s%s"] = "%s a cassé %s sur %s%s%s",
	["%s broke %s on %s%s%s with %s"] = "%s a cassé %s sur %s%s%s avec %s",
}
La.Messages = {
	AFK = "ABS",
	Agil = "Agi",
	alpha = "alpha",
	["Alt-Click on a party buff will cast on someone missing that buff."] = "Alt-Clic sur un buff pour la lancer sur un joueur auquel il manque ce buff. (Ne fonctionne qu'avec vos buffs)",
	["Alt-Click on a self buff will renew that buff."] = "Alt-Clic sur un buff personnel pour le rafraichir.",
	["Aspect Cheetah/Pack On"] = "Aspect du Guépard/Meute actif",
	["Aspect of the Cheetah or Pack is on"] = "Aspect du guépard ou meute est actif",
	["Battle Elixir"] = "Élixir de bataille",
	beta = "beta",
	["Blessing of Kings is not needed because you are grouped with a Druid."] = "La bénédiction des rois n'est pas nécessaire car vous avez un druide dans le groupe.",
	["Blessing of Kings, with this raid configuration, is better provided by Drums of the Forgotten Kings thus allowing Blessing of Might to be used."] = "Bénédiction des rois, avec cette configuration de raid, est plus approprié avec Tambour des Rois Oubliés ce qui permettrai d'utiliser d'autres bénédictions.",
	Boss = "Boss",
	["Buffers: "] = "Buffers: ",
	["Buffing Kings:"] = "Buff Rois",
	["Buffing Might:"] = "Bénédiction de Puissance:",
	["Cast by:"] = "Incanté par:",
	["Click buffs to disable and enable."] = "Cliquez sur un buff dans le panneau de contrôle pour l'activer/désactiver.",
	["Click to toggle the RBS dashboard"] = "Cliquez pour faire apparaitre/disparaitre le tableau de bord de RBS.",
	["Ctrl-Click Boss or Trash to whisper all those who need to buff."] = "Ctrl-Clic sur Boss ou Trash pour envoyer un message à ceux qui ont besoin d'être buffés.",
	["Ctrl-Click buffs to whisper those who need to buff."] = "Ctrl-Clic sur les buffs pour envoyer un message à ceux qui doivent buffer.",
	Dead = "Mort",
	["Death Knight Presence"] = "Présence du chevalier de la mort",
	["Different Zone"] = "Zone Différente",
	["Flasked or Elixired but slacking"] = "Un joueur utilise un vieux flacon ou élixir de BC.",
	["Flask or two Elixirs"] = "Flacon ou deux élixirs",
	["Guardian Elixir"] = "Élixir du gardien",
	["Has buff: "] = "Est buffé:",
	[" has set us up a Refreshment Table"] = " nous a cordialement préparé une table de rafraichissements.",
	[" has set us up a Repair Bot"] = " vient de nous sortir un Robot réparateur.",
	[" has set us up a Soul Well"] = " nous a gracieusement fait apparaitre un puits des âmes",
	["Healer %s has died!"] = "Le soigneur %s est mort.",
	["Health less than 80%"] = "Vie sous les 80%",
	-- ["Hide outgoing whispers"] = "",
	["Hunter Aspect"] = "Aspect chasseur",
	["Hunter has no aspect at all"] = "Chasseur sans Aspect Actif",
	["[IMMUNE]"] = "[INSENSIBLE]",
	Int = "Inté",
	[" in their bags"] = "dans leurs sacs",
	["Invite auto-accepted from battle.net friend %s."] = "Acceptation automatique de l'invitation de l'ami battlle.net %s.",
	["Invite auto-accepted from friend %s."] = "Acceptation automatique de l'invitation de l'ami %s.",
	["Invite auto-accepted from guild member %s."] = "Acceptation automatique de l'invitation du membre de guilde %s.",
	["Item count: "] = "Pile d'objet:",
	["Low durability"] = "Durabilité basse",
	["Low durability (35% or less)"] = "Durabilité basse (35% voir moins)",
	["Mage is missing a Mage Armor"] = "Mage sans Armure du mage",
	["Mana less than 80%"] = "Mana sous les 80%",
	["MANY!"] = "TROP!",
	["Melee DPS %s has died!"] = "Le DPS mêlée %s vient de mourir!",
	["Missing "] = "Manque ",
	["Missing a scroll"] = "Parchemin manquant",
	["Missing buff: "] = "Buff manquant: ",
	["Missing buffs (Boss): "] = "Buffs manquants (Boss): ",
	["Missing buffs (Trash): "] = "Buffs manquants (Trashs): ",
	["Missing or not working oRA or RBS: "] = "oRA ou RBS manquant ou ne fonctionnant pas:",
	No = "Non",
	["No buffs needed! (Boss)"] = "Plus besoin de buffs! (Boss)",
	["No buffs needed! (Trash)"] = "Plus besoin de buffs! (Trash)",
	["No Soulstone detected"] = "Pas de Pierre d'âme détectée",
	["Not Well Fed"] = "Pas bien nourri",
	Offline = "Hors Ligne",
	["Out of range"] = "Hors de portée",
	["Paladin blessing"] = "Bénédiction de paladin",
	["Paladin missing Seal"] = "Paladin à qui il manque un sceau",
	["Player has a wrong Paladin blessing"] = "Joueur ayant une mauvaise béné de paladin",
	["Player has health less than 80%"] = "Perso avec vie sous les 80%",
	["Player has mana less than 80%"] = "Perso avec Mana sous les 80%",
	["Player is AFK"] = "Qui est ABS",
	["Player is Dead"] = "Perso est mort",
	["Player is in a different zone"] = "Perso dans une Zone Différente",
	["Player is missing at least one Paladin blessing"] = "Joueur à qui il manque au moins une bénédiction de paladin",
	["Player is Offline"] = "Qui est Hors Ligne",
	["Please relog or reload UI to update the item cache."] = "Faites un /rl (Reload UI) ou une déco/reco pour mettre à jour le cache s'il vous plait.",
	["prepares a %s!"] = "a préparé un %s !",
	["Press Escape -> Interface -> AddOns -> RaidBuffStatus for more options."] = "Cliquer sur Echap / Interface / AddOns / RaidBuffStatus pour plus d'options.",
	Prot = "Prot",
	["Protection Paladin with no Righteous Fury"] = "Paladin Protect sans Fureur vertueuse active",
	["PVP is On"] = "Qui a le PVP actif",
	["PVP On"] = "PVP actif",
	["Ranged DPS %s has died!"] = "Le DPS distant %s vient de mourir!",
	["RBS Dashboard Help"] = "Aide sur le tableau de bord de RBS",
	["RBS Tank List"] = "Liste de tank de RBS",
	["Refreshment Table about to expire!"] = "La table de rafraichissement va bientôt disparaitre!",
	["Remind me later"] = "Me le rappeler plus tard",
	["(Remove buff)"] = "(Retirer le buff)",
	["Remove this button from this dashboard in the buff options window."] = "Retirer ce bouton du tableau de bord via la fenêtre options des buffs.",
	["Repair Bot about to expire!"] = "Le Robot réparateur va bientôt disparaitre !",
	["[RESIST]"] = "[RESISTE]",
	["Right-click to open the addons options menu"] = "Clic droit pour ouvrir le menu des options.",
	["%s about to expire!"] = "%s est sur le point de disparaitre !",
	Scan = "Scan",
	["%s cast %s on %s"] = "%s incante %s sur %s",
	Scroll = "Parchemin",
	Seal = "Sceau",
	-- ["Sent %d whispers to %d players"] = "",
	["%s has a newer (%s) version of RBS (%s) than you (%s)"] = "%s a une version (%s) plus récente de RBS (%s) que vous (%s)",
	["Shift-Click buffs to report on only that buff."] = "MAJ-Clic pour rapporter seulement ce buff.",
	["%s is running RBS %s"] = "%s utilise RBS %s",
	["Slackers: "] = "Tire-au-flanc :",
	["Slacking Paladins"] = "Paladins qui slackent",
	["Sorry, I am queued for"] = "Désolé mais je suis en file d'attente pour ",
	["Sorry, I am queued for a battlefield."] = "Désolé mais je suis en file d'attente pour un champ de bataille",
	["Sorry, the group is now full."] = "Désolé mais le groupe est plein.",
	["Soul Well about to expire!"] = "Le puits des âmes va bientôt disparaitre!",
	Spi = "Esp",
	Sta = "Endu",
	Str = "For",
	["Tank missing Earth Shield"] = "Tank sans Bouclier de Terre",
	["Tank missing Thorns"] = "Tank sans Épines",
	["Tank %s has died!"] = "Le tank %s est mort.",
	["Tank with "] = "Tank avec ",
	["The above default button actions can be reconfigured."] = "Les commandes ci-dessus peuvent être reconfigurées.",
	["This is the first time RaidBuffStatus has been activated since installation or settings were reset. Would you like to visit the Buff Wizard to help you get RBS buffs configured? If you are a raid leader then you can click No as the defaults are already set up for you."] = "C'est la première fois que RaidBuffStatus est activé depuis son installation ou sa réinitialisation. Souhaitez vous utiliser l'assistant pour vous aider à configurer RBS ? Si vous êtes un raid leader, vous pouvez cliquer sur \"Non\" vu que RBS est configuré par défaut pour vous.",
	["Tol Barad"] = "Tol Barad",
	Trash = "Trash",
	["Warning: "] = "Avertissement: ",
	["Warnings: "] = "Attention: ",
	["Weapon buff"] = "Buff d'arme",
	["Well Fed but slacking"] = "Buff nourriture mais ancien",
	Wintergrasp = "Joug-d'hiver",
	["Wrong flask for this zone"] = "Mauvais flacon pour cette zone.",
	["Wrong Paladin blessing"] = "Mauvaise bénédiction de paladin",
	["You need to be leader or assistant to do this"] = "Vous devez être leader ou assistant pour faire ceci.",
	["You need to whisper the leader instead: "] = "Vous devriez plutôt chuchoter au leader : ",
}
La.Options = {
	Alive = "Vivant",
	["Allow raiders to use flasks and elixirs from last expansion"] = "Permettre aux raideurs d'utiliser des flacons / élixirs d'ancienne extension",
	["Alt-left click"] = "Alt-Clic gauche",
	["Alt-right click"] = "Alt-Clic droit",
	["Always hide the Boss R Trash buttons"] = "Toujours cacher les boutons Boss, R et Trashs",
	["Announce to raid warning when a Feast is prepared"] = "Avertissement raid quand un Festin est préparé",
	["Anti spam"] = "Anti Spam",
	Appearance = "Apparence",
	["Auto-accept invites"] = "Accepter automatiquement les invitations",
	["Auto-invite whispers"] = "Whisp d'auto-invitation",
	["Automatically accept invites from friends and guild members so you can go for a bio-break whilst waiting for a raid invite"] = "Accepter automatiquement les invitations de la part d'amis ou membres de la guilde afin de pouvoir faire votre afk-bio en attendant une invitation pour le raid",
	["Automatically accept invites from these"] = "Accepter automatique les invitations pour ceux-ci",
	["Automatically configures the dashboard buffs and configuration defaults for your class or raid leading role"] = "Configure automatiquement le tableau de bord pour votre classe ou rôle de lead",
	["Automatically invite friends and guild members who whisper to you the word 'invite'"] = "Invite automatiquement les amis et membres de guilde qui vous chuchotent le mot 'invite'",
	["Automatically invite these"] = "Invitez automatiquement ceux-ci",
	["Automatically show the dashboard when you join a battleground"] = "Montrer automatiquement le tableau de bord lorsque vous entrez dans un BG.",
	["Automatically show the dashboard when you join a party"] = "Montrer automatiquement le tableau de bord lorsque vous rejoignez un groupe.",
	["Automatically show the dashboard when you join a raid"] = "Montrer automatiquement le tableau de bord lorsque vous rejoignez un raid.",
	["Automatically whisper anyone missing a Healthstone when your Soul Well expire warnings appear"] = "Prévenir automatiquement les personnes qui n'ont pas de Pierre de soins alors que le Puits des âmes va disparaitre.",
	["Automatically whisper anyone missing flasks or elixirs when your Cauldron expire warnings appear"] = "Chuchoter automatiquement à ceux dont les flacons ou élixirs expirent quand le chaudron va disparaître",
	["Automatically whisper anyone missing Well Fed when your Feast expire warnings appear"] = "Prévenir automatiquement les personnes qui ne sont pas bien nourris alors que le Festin va disparaître.",
	Automation = "Automatisation",
	["Background colour"] = "Couleur du fond",
	["Bar positioning"] = "Positionnement de barre.",
	["Battle.net friends"] = "Amis Battle.net",
	["Border colour"] = "Couleur des bordures",
	["Bosses only"] = "Seulement les boss",
	Bottom = "Bas",
	["Buff button sorting"] = "Classement des boutons de buffs",
	["Buff Options scale"] = "Échelle d'options de Buff",
	["Buff those missing buff"] = "Appliquer le buff manquant",
	["Buff Wizard"] = "Buff mage",
	Cauldron = "Chaudron",
	["Cauldron auto whisper"] = "Chuchoter automatiquement pour le chaudron",
	["CC-break warnings"] = "Avertissement pour CC cassé.",
	["Choose either one big collection of buff checks or traditional style with Warnings, Trash and Boss buff checks"] = "Choisir entre un check global des buffs et des vérifications avec Avertissements, Trashs et Boss",
	["Choose where on the dashboard the bars appear"] = "Choisir l'endroit oû les barres sont affichées sur l'interface",
	["Class-specific buffs"] = "Buffs spécifiques à une classe",
	Combat = "Combat",
	["Combat options"] = "Options en combat",
	["Configure how the buff buttons and status bars on the dashboard are sorted and displayed"] = "Configure la manière dont les boutons et statuts des buffs sont classés et affichés sur l'interface",
	["Consumable options"] = "Options des consommables",
	Consumables = "Consomables",
	["Core raid buffs"] = "Buffs de raid principaux",
	["Ctrl-left click"] = "Ctrl-Clic gauche",
	["Ctrl-right click"] = "Ctrl-Clic droit",
	["Danielbarron broke Sheep on The Lich King with Hand of Reckoning"] = "Bargaroth vient de casser Métamorphose sur le Roi Liche avec Fracasser armure.",
	["Darinia ninjaed my target (The Lich King) with Taunt"] = "Darinia vient de ninja ma cible (Le Roi Liche) avec Provocation.",
	["Darinia taunted my mob (The Lich King) with Taunt"] = "Darinia vient de provoquer mon mob (Le Roi Liche) avec Provocation.",
	["Darinia taunted my target (The Lich King) with Taunt"] = "Darinia vient de provoquer ma cible (Le Roi Liche) avec Provocation.",
	["Dashboard columns"] = "Colonnes du tableau de bord",
	["Dashboard mouse button actions options"] = "Options des actions des boutons de la souris sur le tableau de bord.",
	["Dashboard scale"] = "Échelle du tableau de bord",
	["Death warnings"] = "Avertissements des morts.",
	["Default order"] = "Ordre par défaut",
	["Disable scan in combat"] = "Désactiver le scan pendant le combat",
	["DPS mana"] = "Mana des DPS",
	["Enable/disable buff check"] = "Activer/désactiver la vérification des buffs",
	["Enable tank warnings including taunts, failed taunts and mob stealing"] = "Activer les avertissements tank incluant les provocations, les provocations ratées et le vol de mob.",
	["Enable tank warnings including taunts, failed taunts and mob stealing only on bosses"] = "Activer les avertissements tank incluant les provocations, les provocations ratées et le vol de mob seulement sur les boss.",
	["Enable warning messages when players die"] = "Activer les messages d'avertissement lorsqu'un joueur meurt.",
	["Enable warnings when Crowd Control is broken by tanks and non-tanks"] = "Activer les avertissements quand un contrôle est cassé par un tank ou par un non-tank.",
	["Enable warnings when Misdirection or Tricks of the Trade is cast"] = "Activer les avertissements lorsque \"Ficelles du Métier\" ou \"Détournement\" sont lancés",
	["Feast auto whisper"] = "Whisp auto pour le Festin.",
	Feasts = "Festins",
	["Food announce"] = "Annonce sur la nourriture",
	Friends = "Amis",
	["Grouping style"] = "Style de regroupement",
	["Guild members"] = "Membres de la guilde",
	["Healer death"] = "Mort des soigneurs.",
	["Healer drinking"] = "Soigneur en train de boire",
	["Healer drinking sound"] = "Soigneur en train de boire",
	["Healer mana"] = "Mana des soigneurs",
	["Healers alive"] = "Soigneurs vivants",
	["Healer Stormsnow has died!"] = "Le soigneur Migosha vient de mourir!",
	["Hide and show the buff report dashboard."] = "Cacher et Montrer la fenêtre de rapports sur l'état des buffs",
	["Hide Boss R Trash"] = "Cache les boutons Boss, R et Trash",
	["Hide dashboard during combat"] = "Cacher le tableau de bord pendant le combat",
	["Hide in combat"] = "Caché pendant le combat",
	["Hide the buff report dashboard."] = "Cacher la fenêtre de rapports sur l'état des buffs.",
	["Highlight my buffs"] = "Mettre en évidence mes buffs",
	["Hightlight currently missing buffs on the dashboard for which you are responsible including self buffs and buffs which you are missing that are provided by someone else. I.e. show buffs for which you must take action"] = "Mettre en évidence les améliorations manquantes sur le tableau de bord, les vôtres mais aussi celles données par les autres joueurs.",
	["How MANY?"] = "Combien ?",
	["Ignore groups 6 to 8"] = "Ignorer les groupes 6 à 8",
	["Ignore groups 6 to 8 when reporting as these are for subs"] = "Ignorer les groupes 6 à 8 lors du rapport.",
	["[IMMUNE] Danielbarron FAILED TO TAUNT their target (The Lich King) with Hand of Reckoning"] = "[IMMUNISE] Bargaroth A RATE LA PROVOCATION de sa cible (Le Roi Liche) avec Main de Rétribution.",
	["In range"] = "A porté",
	invite = "invite",
	["Just my buffs"] = "Juste mes améliorations",
	["Left click"] = "Clic gauche",
	["Melee DPS Danielbarron has died!"] = "Le DPS mêlée Astralina vient de mourir!",
	["Melee DPS death"] = "Mort des DPS mêlée",
	["Minimap icon"] = "Icône de la mini-carte",
	["Minimum remaining buff duration in minutes. Buffs with less than this will be considered as missing.  This option only takes affect when the corresponding 'buff' button is enabled on the dashboard."] = "Durée minimum d'un buff pour rappel en minutes. Les buffs sous cette limite seront considérés comme manquant. Cette option ne prendra effet que lorsque le bouton du buff correspondant sera activé dans le panneau de contrôle.",
	["Min remaining buff duration"] = "Durée minimum d'un buff avant rappel",
	["Misdirection warnings"] = "Avertissements détournement",
	["Mouse buttons"] = "Boutons de la souris",
	["Move with Alt-click"] = "Déplacer avec un Alt-Clic",
	["My buffs"] = "Mes buffs",
	["Ninja taunts"] = "Provocation Ninja !",
	["No healer close"] = "Aucun soigneur proche ",
	None = "Rien",
	["Non-tank breaks CC"] = "Contrôle cassé par un non-tank",
	["Non-tank Glamor broke Hex on The Lich King with Moonfire"] = "Le non tank lastdans vient de casser Maléfice avec Feu Stellaire.",
	["NON-TANK Tanagra taunted my target (The Lich King) with Growl"] = "Le NON-TANK Drakkar a provoquer ma cible (Le Roi Liche) avec Grondement.",
	["Non-tank taunts my target"] = "Non-tank provoquant ma cible.",
	["Number of columns to display on the dashboard"] = "Nombre de colonnes a afficher sur le tableau de bord",
	["Old flasks and elixirs"] = "Anciens flacons et élixirs",
	["One big group"] = "Un seul groupe",
	["One group down"] = "Un groupe vers le bas",
	["Only if all have it"] = "Seulement si tout le monde l'a",
	["Only me"] = "Seulement moi",
	["Only show the buffs for which your class is responsible for.  This configuration can be used like a buff-bot where one simply right clicks on the buffs to cast them"] = "Montre uniquement les buffs dont votre classe est responsable. Cette configuration permet d'utiliser RBS pour buffer rapidement; un simple clique droit sur vos buffs permet de les appliquer.",
	["Only show the core class raid buffs"] = "Montre uniquement les buffs de classes principaux",
	["Only show when you and only you break Crowd Control so you can say 'Now I don't believe you wanted to do that did you, ehee?'"] = "Montre seulement lorsque vous et seulement vous cassez un contrôle et vous pourrez dire:\"Now I don't believe you wanted to do that did you, ehee?\"",
	["Only use tank list"] = "Utiliser seulement la liste de tanks.",
	["Only use the tank list and ignore spec when there is a tank list for determining if someone is a tank or not"] = "Utiliser la liste des tanks et ignorer les spé lorsqu'il y a une liste de tanks servant à déterminer ceux-ci.",
	["Options for automatically opening the dashboard and moving it"] = "Options pour automatiquement ouvrir et déplacer l'interface",
	["Options for setting the quality requirements of consumables"] = "Options sur les exigences des consommables.",
	["Options to do with configuring the tank list"] = "Options de configuration de la liste de tanks.",
	Other = "Autres",
	["Other taunt fails"] = "Autres provocations ratées",
	["Play a sound"] = "Jouer un son",
	["Play a sound when a healer dies"] = "Jouer un son lorsqu'un soigneur meurt.",
	["Play a sound when a healer drinks and is not full on mana"] = "Jouer un son lorsqu'un soigneur n'est pas full mana et qu'il boit",
	["Play a sound when a melee DPS dies"] = "Jouer un son lorsqu'un DPS mêlée meurt.",
	["Play a sound when a non-tank breaks Crowd Control"] = "Jouer un son quand un non-tank casse un contrôle (CC).",
	["Play a sound when a ranged DPS dies"] = "Jouer un son lorsqu'un DPS distant meurt.",
	["Play a sound when a tank breaks Crowd Control"] = "Jouer un son quand un tank casse un contrôle (CC).",
	["Play a sound when a tank dies"] = "Jouer un son lorsqu'un tank meurt.",
	["Play a sound when Misdirection or Tricks of the Trade is cast"] = "Jouer un son lorsque \"Ficelles du Métier\" ou \"Détournement\" sont lancés",
	["Play a sound when one of your taunts fails due to resist"] = "Jouer un son lorsqu'une de vos provocation rate à cause d'un résiste",
	["Play a sound when one of your taunts fails due to the target being immune"] = "Jouer un son lorsqu'une de vos provocations rate à cause d'une immunité de la cible.",
	["Play a sound when other people's taunts to your target fail"] = "Jouer un son lorsque la provocation d'autres joueurs rate sur votre cible.",
	["Play a sound when someone else targets a mob and taunts that mob which is targeting you"] = "Jouer un son quand un joueur ciblant une autre cible provoque le mob qui vous cible.",
	["Play a sound when someone else taunts your target"] = "Jouer un son quand quelqu'un d'autre provoque votre cible",
	["Play a sound when someone else taunts your target which is targeting you"] = "Jouer un son lorsqu'un joueur provoque votre cible. Cible qui vous cible.",
	["Play a sound when someone else who is not a tank taunts your target"] = "Jouer un son lorsqu'un non-tank prends l'aggro sur votre cible.",
	["Prepend RBS::"] = "Précédé de RBS::",
	["Prepend RBS:: to all lines of report chat. Disable to only prepend on the first line of a report"] = "Précédé de RBS:: à toutes les lignes du rapport. Désactivé pour précédé uniquement la première ligne du rapport.",
	["Raid health"] = "Santé du raid",
	["Raid leader"] = "Chef de raid",
	["Raid mana"] = "Mana du raid",
	["Raid Status Bars"] = "Barres de status du raid",
	["Raid-wide buffs"] = "Buff pour l'ensemble du raid",
	["Ranged DPS death"] = "Mort d'un DPS distant",
	["Ranged DPS Garmann has died!"] = "Le DPS distance Elrénia vient de mourir!",
	["Refreshment Table"] = "Table de rafraichissements",
	["Repair Bot"] = "Robot réparateur",
	Reporting = "Rapport",
	["Reporting options"] = "Options des rapports",
	["Report missing to raid"] = "Rapport au raid",
	["Report to officer channel"] = "Rapport sur le canal officier",
	["Report to officers"] = "Rapport aux officiers",
	["Report to /raid or /party who is not buffed to the max."] = "Faire un rapport au canal Raid ou Groupe pour ceux qui ne sont pas Max Full Buffs.",
	["Report to raid/party"] = "Rapport au raid/groupe",
	["Report to raid/party - requires raid assistant"] = "Rapport au raid/groupe - requiert d'être assistant dans le raid.",
	["Report to self"] = "Rapport à soi-même",
	["Required food quality"] = "Qualité de la nourriture requis",
	["Require the Alt buton to be held down to move the dashboard window"] = "Exigez qu'ALT soit maintenu pour déplacer la fenêtre du tableau de bord.",
	["[RESIST] Danielbarron FAILED TO TAUNT their target (The Lich King) with Hand of Reckoning"] = "[RESISTE] Bargaroth A RATE LA PROVOCATION de sa cible (Le Roi Liche) avec Main de Rétribution.",
	["[RESIST] Darinia FAILED TO TAUNT my target (The Lich King) with Taunt"] = "[RESISTE]Darinia A RATE LA PROVOCATION de ma cible (Le Roi Liche) avec Provocation.",
	["Right click"] = "Clic droit",
	["Scale the Buff Options window"] = "Échelle de la fenêtre d'options de Buff",
	["Scale the dashboard window"] = "Échelle de la fenêtre du tableau de bord",
	["Seconds between updates"] = "Secondes entre les mises à jour",
	["Select which action to take when you click with the left mouse button over a dashboard buff check"] = "Choisir quelle action sera effectuée via le tableau de bord avec un clic gauche.",
	["Select which action to take when you click with the left mouse button with Alt held down over a dashboard buff check"] = "Choisir quelle action sera effectuée via le tableau de bord avec un Alt clic gauche.",
	["Select which action to take when you click with the left mouse button with Ctrl held down over a dashboard buff check"] = "Choisir quelle action sera effectuée via le tableau de bord avec un Ctrl-clic gauche.",
	["Select which action to take when you click with the left mouse button with Shift held down over a dashboard buff check"] = "Choisir quelle action sera effectuée via le tableau de bord avec un MAJ-clic gauche.",
	["Select which action to take when you click with the right mouse button over a dashboard buff check"] = "Choisir quelle action sera effectuée via le tableau de bord avec un clic droit.",
	["Select which action to take when you click with the right mouse button with Alt held down over a dashboard buff check"] = "Choisir quelle action sera effectuée via le tableau de bord avec un Alt-clic droit.",
	["Select which action to take when you click with the right mouse button with Ctrl held down over a dashboard buff check"] = "Choisir quelle action sera effectuée via le tableau de bord avec un Ctrl-clic droit.",
	["Select which action to take when you click with the right mouse button with Shift held down over a dashboard buff check"] = "Choisir quelle action sera effectuée via le tableau de bord avec un MAJ-clic droit.",
	["Select which level of food quality you require for the raiders to be considered 'Well Fed'"] = "Choisissez quel niveau de qualité vous désirez pour la nourriture pour être considéré comme \"Bien nourri\"",
	["Self buffs"] = "Mes propres buffs",
	["Set how many seconds between dashboard raid scan updates"] = "Régler le nombre de secondes entre chaque mise à jour du tableau de bord.",
	["Set N - the number of people missing a buff considered to be \"MANY\""] = "Régler N. N étant la limite de personne sans buff à atteindre afin de noter \"TROP\". Ceci affecte aussi les buffs avec compo.",
	["Shift-left click"] = "MAJ-clic gauche",
	["Shift-right click"] = "MAJ-clic droit",
	["Shorten names"] = "Noms courts",
	["Shorten names in the report to reduce channel spam"] = "Noms courts dans le rapport pour éviter le spam du canal",
	["Show group number"] = "Montrer le numéro du groupe",
	["Show in battleground"] = "Montrer dans les champs de bataille",
	["Show in party"] = "Voir en groupe",
	["Show in raid"] = "Voir en raid",
	["Show the buff report dashboard."] = "Montrer la fenêtre de rapports sur l'état des buffs.",
	["Show the group number of the person missing a party/raid buff"] = "Montrer le groupe de la personne à qui il manque un buff du groupe/raid.",
	["Single target buffs"] = "Buffs monocibles",
	["Skin and minimap options"] = "Options du skin et de la mini-carte.",
	["Skin and scaling"] = "Texture et échelle",
	["Skip buff checking during combat. You can manually initiate a scan by pressing Scan on the dashboard"] = "Ignorer la vérification des buffs pendant le combat. Vous pouvez lancer manuellement un scan en appuyant sur Scan sur le tableau de bord",
	["%s minutes"] = "%s minutes",
	["Sort buff buttons by"] = "Classer les boutons de buffs par",
	["Soul Well"] = "Puits des âmes",
	["Status bars to show raid, dps, tank health, mana, etc"] = "Barres à afficher genre DPS, vie du tank, mana etc.",
	["Tank breaks CC"] = "Contrôle cassé par un tank",
	["Tank Danielbarron has died!"] = "Le tank Bargaroth vient de mourir!",
	["Tank death"] = "Mort des tanks",
	["Tank health"] = "Vie du tank",
	["Tank list"] = "Liste de tanks",
	["Tanks alive"] = "Tanks vivants",
	["Tank warnings"] = "Avertissements Tank",
	["Tank warnings about taunts, failed taunts and mob stealing including accidental taunts from non-tanks"] = "Avertissements tank sur les provocations, les provocations ratées, le vol de mob incluant également les provocations des non tanks.",
	["Taunts to my mobs"] = "Provocations sur mon mob.",
	["Taunts to my target"] = "Provocations sur ma cible.",
	["Tells you when someone in your party, raid or guild has a newer version of RBS installed"] = "Vous indique lorsque un membre du groupe, raid ou guilde a une nouvelle version installée de RBS",
	["Tells you when someone in your party, raid or guild has RBS installed"] = "Vous indique si quelqu'un dans le groupe, raid ou guilde a RBS d'installé",
	Test = "Test",
	["Test what the warning is like"] = "Test pour voir à quoi ressemble l'avertissement.",
	["The average DPS mana percent"] = "Moyenne du mana des DPS en %",
	["The average healer mana percent"] = "Moyenne du mana des soigneurs en %",
	["The average party/raid health percent"] = "Moyenne de la santé du raid/groupe en %",
	["The average party/raid mana percent"] = "Moyenne du mana du groupe/raid en %",
	["The average tank health percent"] = "Moyenne de la santé des tanks en %",
	["The Buff Wizard automatically configures the dashboard buffs and configuration defaults for your class or raid leading role."] = "L'assistant configure automatiquement le tableau de bord pour votre classe ou rôle de lead",
	["Then sort buff buttons by"] = "Ensuite classer les boutons de buffs par",
	["The percentage of healers alive in the raid"] = "% de soigneurs vivants dans le raid.",
	["The percentage of people alive in the raid"] = "% de joueurs vivants dans le raid.",
	["The percentage of people dead in the raid"] = "Le pourcentage de personne morte dans le raid",
	["The percentage of people within 40 yards range"] = "Le pourcentage de personne dans les 40 metres",
	["The percentage of tanks alive in the raid"] = "% de tanks vivants dans le raid.",
	["This is the default configuration in which RBS ships out-of-the-box.  It gives you pretty much anything a raid leader would need to see on the dashboard"] = "C'est la configuration par défaut de RBS. Elle vous donne a peu près tout ce qu'un raid leader a besoin de voir sur le tableau de bord.",
	["Toggle to display a minimap icon"] = "Cocher pour afficher une icône sur la mini-carte.",
	Top = "Haut",
	["To set this option go to the addon configuration.  This button is automatically enabled when the Boss button is pressed and automatically disabled when the Trash button is pressed.  To permanently disable, choose 0 seconds as the min remaining buff duration."] = "Afin de régler cette option, allez dans la configuration de l'addon. Ce bouton sera automatiquement activé lorsque le bouton Boss sera pressé et sera automatiquement désactivé lorsque le bouton Trash sera pressé. Pour la désactiver totalement, choisir un durée minimum de buff de 0 seconde.",
	["Two groups down"] = "Deux groupes vers le bas",
	["User announce"] = "Annonce utilisateur",
	["Version announce"] = "Annonce de la version",
	["Wait before announcing to see if others have announced first in order to reduce spam"] = "Retarder l'affichage des annonces afin de voir si qq'un les affiche avant vous dans le but de réduire le spam.",
	["Warning messages when players die"] = "Message d'avertissement lorsqu'un joueur meurt.",
	["Warnings when Crowd Control is broken by tanks and non-tanks"] = "Avertissements lorsqu'un contrôle est cassé par les tanks et les non tanks.",
	["Warnings when Misdirection or Tricks of the Trade is cast"] = "Avertissements quand \"Ficelles du Métier\" ou \"Détournement\" sont lancés",
	["Warnings when someone else targets a mob and taunts that mob which is targeting you"] = "Avertissement lorsqu'un joueur cible et prends l'aggro sur votre mob.",
	["Warnings when someone else taunts your target"] = "Avertissements lorsque qq'un provoque votre cible.",
	["Warnings when someone else taunts your target who is not a tank"] = "Avertissement lorsqu'un joueur non tank provoque votre cible.",
	["Warning, Trash, Boss groups"] = "Groupes Avertissements, Trashs, Boss",
	["Warns when a non-tank breaks Crowd Control"] = "Avertissement lorsqu'un non tank casse un contrôle (CC)",
	["Warns when a tank breaks Crowd Control"] = "Avertissement lorsqu'un tank casse un contrôle (CC)",
	["Warns when other people's taunts to your target fail"] = "Avertissement lorsque la provocation d'autres joueurs rate sur votre cible.",
	["Warns when someone else taunts your target which is targeting you"] = "Avertissement lorsqu'un joueur prends l'aggro sur votre cible. Cible qui vous cible.",
	["Warns when your taunts fail due to resist"] = "Avertir lorsqu'une de vos provocation rate à cause d'un résiste",
	["Warns when your taunts fail due to the target being immune"] = "Avertir lorsque votre provocation rate à cause d'une immunité de la cible.",
	["Warn to party"] = "Avertissement au groupe",
	["Warn to party when a healer dies"] = "Avertissement au groupe lorsqu'un soigneur meurt.",
	["Warn to party when a melee DPS dies"] = "Avertissement au groupe lorsqu'un DPS mêlée meurt.",
	["Warn to party when a non-tank breaks Crowd Control"] = "Avertissement au groupe lorsqu'un non tank casse un contrôle (CC)",
	["Warn to party when a ranged DPS dies"] = "Avertissement au groupe lorsqu'un DPS distant meurt.",
	["Warn to party when a tank breaks Crowd Control"] = "Avertissement au groupe lorsqu'un tank casse un contrôle (CC)",
	["Warn to party when a tank dies"] = "Avertissement au groupe lorsqu'un tank meurt.",
	["Warn to party when one of your taunts fails due to resist"] = "Avertir le groupe lorsqu'une de vos provocation rate à cause d'un résiste",
	["Warn to party when one of your taunts fails due to the target being immune"] = "Avertir le groupe lorsqu'une de vos provocations rate à cause d'une immunité de la cible.",
	["Warn to party when other people's taunts to your target fail"] = "Avertissement au groupe lorsque que la provocation d'un autre joueur sur votre cible rate.",
	["Warn to party when someone else targets a mob and taunts that mob which is targeting you"] = "Avertissement au groupe lorsqu'un joueur cible le mob qui vous vise et reprends l'aggro dessus.",
	["Warn to party when someone else taunts your target"] = "Avertissement au groupe lorsque qq'un d'autre provoque votre cible.",
	["Warn to party when someone else taunts your target which is targeting you"] = "Avertissement au groupe lorsqu'un joueur prends l'aggro sur votre cible. Cible qui vous cible.",
	["Warn to party when someone else who is not a tank taunts your target"] = "Avertissement au groupe lorsqu'un joueur non tank provoque votre cible.",
	["Warn to raid chat"] = "Avertissement sur le canal raid",
	["Warn to raid chat when a healer dies"] = "Avertissement sur le canal raid lorsqu'un soigneur meurt.",
	["Warn to raid chat when a melee DPS dies"] = "Avertissement sur le canal raid lorsqu'un DPS mêlée meurt.",
	["Warn to raid chat when a non-tank breaks Crowd Control"] = "Avertissement sur le canal raid lorsqu'un non tank casse un contrôle (CC)",
	["Warn to raid chat when a ranged DPS dies"] = "Avertissement sur le canal raid lorsqu'un DPS distant meurt.",
	["Warn to raid chat when a tank breaks Crowd Control"] = "Avertissement dans le canal raid qu'un tank casse un contrôle (CC).",
	["Warn to raid chat when a tank dies"] = "Avertissement sur le canal raid quand un tank meurt.",
	["Warn to raid chat when one of your taunts fails due to resist"] = "Avertir le canal raid lorsqu'une de vos provocation rate à cause d'un résiste",
	["Warn to raid chat when one of your taunts fails due to the target being immune"] = "Avertir le canal raid lorsqu'une de vos provocation rate à cause d'une immunité de la cible.",
	["Warn to raid chat when other people's taunts to your target fail"] = "Avertissement sur le canal raid que le taunt d'un autre sur votre cible rate.",
	["Warn to raid chat when someone else targets a mob and taunts that mob which is targeting you"] = "Avertissement sur le canal raid lorsqu'un joueur cible le mob qui vous vise et reprends l'aggro dessus.",
	["Warn to raid chat when someone else taunts your target"] = "Avertissement sur le canal raid lorsque qq'un d'autre provoque votre cible.",
	["Warn to raid chat when someone else taunts your target which is targeting you"] = "Avertissement sur le canal raid lorsqu'un joueur prends l'aggro sur votre cible. Cible qui vous cible.",
	["Warn to raid chat when someone else who is not a tank taunts your target"] = "Avertissement sur le canal raid lorsqu'un joueur non tank provoque votre cible.",
	["Warn to raid warning"] = "Avertissement via l'avertissement raid.",
	["Warn to self"] = "Avertissement à soi-même.",
	["Warn to self when a healer dies"] = "Avertissement à soi-même lorsqu'un soigneur meurt.",
	["Warn to self when a melee DPS dies"] = "Avertissement à soi-même lorsqu'un DPS mêlée meurt.",
	["Warn to self when a non-tank breaks Crowd Control"] = "Avertissement à vous-même lorsqu'un non tank casse un contrôle (CC)",
	["Warn to self when a ranged DPS dies"] = "Avertissement à soi-même lorsqu'un DPS distant meurt.",
	["Warn to self when a tank breaks Crowd Control"] = "Avertissement à vous-même lorsqu'un tank casse un contrôle (CC)",
	["Warn to self when a tank dies"] = "Avertissement à soi-même lorsqu'un tank meurt.",
	["Warn to self when Misdirection or Tricks of the Trade is cast"] = "Avertissement à soi-même lorsque \"Ficelles du Métier\" ou \"Détournement\" sont lancés",
	["Warn to self when one of your taunts fails due to resist"] = "Vous avertir vous-même lorsqu'une de vos provocation rate à cause d'un résiste",
	["Warn to self when one of your taunts fails due to the target being immune"] = "Vous avertir vous-même lorsqu'une de vos provocations rate à cause d'une immunité de la cible.",
	["Warn to self when other people's taunts to your target fail"] = "Avertissement à vous-même lorsque la provocation d'un autre joueur rate sur votre cible",
	["Warn to self when someone else targets a mob and taunts that mob which is targeting you"] = "Avertissement à vous-même lorsqu'un joueur cible le mob qui vous vise et reprends l'aggro dessus.",
	["Warn to self when someone else taunts your target"] = "Vous avertir quand quelqu'un provoque votre cible",
	["Warn to self when someone else taunts your target which is targeting you"] = "Avertissement à vous-même lorsqu'un joueur prends l'aggro sur votre cible. Cible qui vous cible.",
	["Warn to self when someone else who is not a tank taunts your target"] = "Avertissement à vous-même lorsqu'un joueur non tank provoque votre cible.",
	["Warn using raid warning when a healer dies"] = "Avertissement via l'avertissement raid lorsqu'un soigneur meurt.",
	["Warn using raid warning when a melee DPS dies"] = "Avertissement via l'avertissement raid lorsqu'un DPS mêlée meurt.",
	["Warn using raid warning when a non-tank breaks Crowd Control"] = "Avertissement via l'avertissement raid lorsqu'un non tank casse un contrôle (CC)",
	["Warn using raid warning when a ranged DPS dies"] = "Avertissement via l'avertissement de raid lorsqu'un DPS distant meurt.",
	["Warn using raid warning when a tank breaks Crowd Control"] = "Avertissement via l'avertissement raid lorsqu'un tank casse un contrôle (CC)",
	["Warn using raid warning when a tank dies"] = "Avertissement via l'avertissement raid lorsqu'un tank meurt.",
	["Warn using raid warning when one of your taunts fails due to resist"] = "Avertir via l'avertissement raid lorsqu'une de vos provocation rate à cause d'un résiste",
	["Warn using raid warning when one of your taunts fails due to the target being immune"] = "Avertir via l'avertissement raid lorsqu'une de vos provocations rate à cause d'une immunité de la cible.",
	["Warn using raid warning when other people's taunts to your target fail"] = "Avertissement via l'avertissement raid lorsque la provocation d'un autre sur votre cible rate.",
	["Warn using raid warning when someone else targets a mob and taunts that mob which is targeting you"] = "Avertissement via l'avertissement raid lorsqu'un joueur cible et prends l'aggro sur votre mob.",
	["Warn using raid warning when someone else taunts your target"] = "Avertissement via l'avertissement raid lorsque qq'un d'autre provoque votre cible.",
	["Warn using raid warning when someone else taunts your target which is targeting you"] = "Avertissement via l'avertissement raid lorsqu'un joueur prends l'aggro sur votre cible. Cible qui vous cible.",
	["Warn using raid warning when someone else who is not a tank taunts your target"] = "Avertissement via l'avertissement raid lorsqu'un joueur non tank provoque votre cible.",
	["Warn when a healer dies"] = "Avertissement lorsqu'un soigneur meurt.",
	["Warn when a melee DPS dies"] = "Avertissement lorsqu'un DPS mêlée meurt.",
	["Warn when a ranged DPS dies"] = "Avertissement quand un DPS distant meurt.",
	["Warn when a tank dies"] = "Avertissement lorsqu'un tank meurt.",
	["Well auto whisper"] = "Whisp auto pour la PDS",
	["When at least N people are missing a raid buff say MANY instead of spamming a list"] = "Lorsque N joueurs n'ont pas un buff de raid, noter TROP à la place d'un spam de noms.",
	["When many say so"] = "Quand trop noter alors",
	["When there are multiple people who can provide a missing buff such as Fortitude then only whisper one of them at random who is in range rather than all of them"] = "Lorsque plusieurs joueurs peuvent fournir un buff manquant comme Endurance, chuchotez à un seul d'entre eux à portée et au hasard au lieu de chuchoter à tous.",
	["When whispering and at least N people are missing a raid buff say MANY instead of spamming a list"] = "Choisir de dire \"TROP\" si N personnes ne sont pas buffées lorsque vous chuchotez afin d'éviter le spam.",
	["Whisper buffers"] = "Whisp les buffers",
	["Whisper many"] = "Chuchotement de masse",
	["Whisper only one"] = "Chuchotez à un seul",
	["Your taunt immune-fails"] = "Votre provocation a raté (Immunisé)",
	["Your taunt resist-fails"] = "Votre provocation a raté (Résiste)",
}
La.RaidStatusBars = {
	["Dead healers"] = "Soigneurs morts",
	["Dead tanks"] = "Tanks morts",
	["I see dead people"] = "Je vois des gens qui sont mort.",
	["n/a"] = "n/a",
	P = "P", -- Needs review
	-- ["Pull Timer"] = "",
	R = "P", -- Needs review
	-- ["Ready Check"] = "",
}
La.TalentsWindow = {
	Class = "Classe",
	Healer = "Soigneur",
	["Melee DPS"] = [=[DPS mêlée

Rôle d'un joueur]=],
	Name = "Nom",
	["Ranged DPS"] = "DPS distance",
	Refresh = "Rafraichir",
	Role = "Rôle",
	Spec = "Spé",
	Specialisations = "Spécialisation",
	["Talent Specialisations"] = "Spécialisation des Talents",
	Tank = "Tank",
}
La.TankTauntWarnings = {
	["NON-TANK %s taunted my boss target (%s%s%s) with %s"] = "NON-TANK %s a provoqué ma cible (%s%s%s) avec %s",
	["NON-TANK %s taunted my target (%s%s%s) with %s"] = "Le NON-TANK %s a provoqué ma cible (%s%s%s) avec %s",
	["%s FAILED TO NINJA my boss target (%s%s%s) with %s"] = "%s N'A PAS REUSSI A VOLER ma cible (%s%s%s) avec %s",
	["%s FAILED TO NINJA my target (%s%s%s) with %s"] = "%s A ÉCHOUÉ A NINJA ma cible (%s%s%s) avec %s",
	["%s FAILED TO TAUNT my boss target (%s%s%s) with %s"] = "%s N'A PAS REUSSI A VOLER ma cible (%s%s%s) avec %s",
	["%s FAILED TO TAUNT my target (%s%s%s) with %s"] = "%s a ÉCHOUÉ A PROVOQUER ma cible (%s%s%s) avec %s",
	["%s FAILED TO TAUNT their boss target (%s%s%s) with %s"] = "%s RATE SA PROVOCATION sur son boss (%s%s%s) avec %s",
	["%s FAILED TO TAUNT their target (%s%s%s) with %s"] = "%s A ÉCHOUÉ A PROVOQUER sa cible (%s%s%s) avec %s",
	["%s ninjaed my boss target (%s%s%s) with %s"] = "%s a volé ma cible (%s%s%s) avec %s",
	["%s ninjaed my target (%s%s%s) with %s"] = "%s a ninja ma cible (%s%s%s) avec %s",
	["%s taunted my boss mob (%s%s%s) with %s"] = "%s a provoqué ma cible (%s%s%s) avec %s",
	["%s taunted my boss target (%s%s%s) with %s"] = "%s a provoqué ma cible (%s%s%s) avec %s",
	["%s taunted my mob (%s%s%s) with %s"] = "%s a provoqué mon mob (%s%s%s) avec %s",
	["%s taunted my target (%s%s%s) with %s"] = "%s a provoqué ma cible (%s%s%s) avec %s",
}

elseif locale == "deDE" then do end
La["Announce even when you don't have assist or lead"] = "Ankündigungen ausgeben, sogar wenn man kein Leiter oder Assistent ist"
La["Announce expiration"] = "Verschwinden ankündigen"
La["Announcement options for raid utilities like Feasts"] = "Ankündigungsoptionen für Raid-Hilfsmittel wie Festmähler"
La["Announce to raid warning when a %s is prepared"] = "Schlachtzugswarnung ausgeben, wenn jemand einen %s aufstellt"
La["Announce to raid warning when a utility is expiring"] = "Schlachtzugswarnung ausgeben, wenn ein Hilfsmittel bald verschwindet"
La["Announce without lead"] = "Ohne Leitung ausgeben"
La["Augment Banquet Tooltips"] = "Erweitere Bankett-Tooltips"
La["Augment Banquet Tooltips with stat bonus information"] = "Erweitere Bankett-Tooltips mit Informationen zum Bonuswert"
La["Augment Rune"] = "Verstärkungsrune"
La["Blingtron"] = "Blingtron"
La["Blingtron about to expire!"] = "Blingtron verschwindet bald!"
La["Bonus"] = "Bonus"
La["Broken Link"] = "Verbindung unterbrochen"
La["casts %s"] = "wirkt %s"
La["Eating"] = "Isst"
La["Expiration announcements"] = "Ablaufankündigungen"
La[" has set us up a Blingtron"] = " hat einen Blingtron aufgestellt!"
La["has set us up a %s"] = "hat aufgestellt: %s"
La["Mailbox"] = "Briefkasten"
La["Noodle Cart"] = "Nudelwagen"
La["Portal"] = "Portal"
La["Prefer Static Buff"] = "Statische Buffs bevorzugen"
La["Report missing static buffs even when an equivalent passive aura is already present."] = "Fehlende statische Buffs melden, auch wenn eine passive Aura vorhanden ist."
La["Required flask quality"] = "Benötigte Fläschchen-Qualität"
La["Right-click to target"] = "Rechtsklick zum Ziel setzen"
La["Select which level of flask quality you require"] = "Wähle, welche Qualität das Fläschchen haben muss."
La["sets up a %s"] = "hat aufgestellt: %s"
La["Show configuration options"] = "Optionsmenü öffnen"
La["Soulwell"] = "Seelenbrunnen"
La["Tooltip name coloring"] = "Namenseinfärbung im Tooltip"
La["Tooltip role icons"] = "Rollenicons im Tooltip"
La["Treat eating as Well Fed"] = "Behandle 'Isst' wie 'Satt'"
La["Treat players who are currently eating as Well Fed. This assumes they are eating acceptable food."] = "Behandle Spieler, die gerade essen, als ob sie satt wären. Diese Option nimmt an, dass sie akzeptables Buffood essen."
La["Utility announcements"] = "Hilfsmittel-Ankündigungen"
La["Warrior Stance"] = "Krieger Haltung"
La.BuffOptionsWindow = {
	["Buff Options"] = "Buff Optionen",
	["Is a buff"] = "Ist ein Buff",
	["Is a warning"] = "Ist eine Warnung",
	["Report on Boss"] = "Berichte bei Bossen",
	["Report on Trash"] = "Berichte bei Trashmobs",
	["Show on dashboard"] = "Zeige auf der Übersicht",
	["Show/Report in combat"] = "Zeige/Berichte im Kampf",
}
La.CrowdControlWarnings = {
	["Melee Swing"] = "Nahkampftreffer",
	["Non-tank %s broke %s on %s%s%s"] = "Nicht-Tank %s hat %s auf %s%s%s gebrochen!",
	["Non-tank %s broke %s on %s%s%s with %s"] = "Nicht-Tank %s hat %s auf %s%s%s mit %s gebrochen!",
	["%s broke %s on %s%s%s"] = "%s hat %s auf %s%s%s gebrochen!",
	["%s broke %s on %s%s%s with %s"] = "%s hat %s auf %s%s%s mit %s gebrochen!",
}
La.Messages = {
	AFK = "AFK",
	Agil = "Bew",
	alpha = "Alpha",
	["Alt-Click on a party buff will cast on someone missing that buff."] = "Alt-Klick auf einen Gruppenbuff, um diesen zu erneuern.",
	["Alt-Click on a self buff will renew that buff."] = "Alt-Klick auf einen eigenen Buff, um diesen zu erneuern.",
	["Aspect Cheetah/Pack On"] = "Aspekt Gepard/Rudel aktiv",
	["Aspect of the Cheetah or Pack is on"] = "Aspekt des Geparden oder Rudels ist aktiv",
	["Battle Elixir"] = "Kampfelixier",
	beta = "Beta",
	["Blessing of Kings is not needed because you are grouped with a Druid."] = "Segen der Könige ist nicht nötig, weil du mit einem Druiden in der Gruppe bist.",
	["Blessing of Kings, with this raid configuration, is better provided by Drums of the Forgotten Kings thus allowing Blessing of Might to be used."] = "Mit dieser Raidzusammenstellung ist es besser, Trommeln der Vergessenen Könige zu benutzen, damit Segen der Macht genutzt werden kann.",
	Boss = "Boss",
	["Buffers: "] = "Buffer: ",
	["Buffing Kings:"] = "Bufft Könige:",
	["Buffing Might:"] = "Bufft Macht:",
	["Cast by:"] = "Gewirkt von:",
	["Click buffs to disable and enable."] = "Buff anklicken zum aktivieren/deaktivieren.",
	["Click to toggle the RBS dashboard"] = "Klicken für Zusammenfassungsfenster",
	["Ctrl-Click Boss or Trash to whisper all those who need to buff."] = "Strg-Klick auf Boss oder Trash, um diejenigen anzuflüstern die buffen müssen.",
	["Ctrl-Click buffs to whisper those who need to buff."] = "Strg-Klick Buff, um diejenigen anzuflüstern die buffen müssen.",
	Dead = "Tot",
	["Death Knight Presence"] = "Todesritter Präsenz",
	["Different Zone"] = "Andere Zone",
	["Flasked or Elixired but slacking"] = "Ungenügendes Elixier oder Fläschchen",
	["Flask or two Elixirs"] = "Fläschchen",
	["Guardian Elixir"] = "Wächterelixier",
	["Has buff: "] = "Hat Buff: ",
	[" has set us up a Refreshment Table"] = " hat einen Erfrischungstisch aufgestellt!",
	[" has set us up a Repair Bot"] = " hat einen Reparaturbot aufgestellt!",
	[" has set us up a Soul Well"] = " hat einen Seelenbrunnen aufgestellt!",
	["Healer %s has died!"] = "Heiler %s ist gestorben!",
	["Health less than 80%"] = "Gesundheit unter 80%",
	["Hide outgoing whispers"] = "Ausgehende Flüsternachrichten verstecken",
	["Hunter Aspect"] = "Jäger-Aspekt",
	["Hunter has no aspect at all"] = "Jäger ohne aktiven Aspekt",
	["[IMMUNE]"] = "[IMMUN]",
	Int = "Int",
	[" in their bags"] = " in der Tasche",
	["Invite auto-accepted from battle.net friend %s."] = "Einladung von Battle.net-Freund %s automatisch akzeptiert",
	["Invite auto-accepted from friend %s."] = "Einladung von Freund %s automatisch akzeptiert",
	["Invite auto-accepted from guild member %s."] = "Einladung von Gildenmitglied %s automatisch akzeptiert",
	["Item count: "] = "Anzahl:",
	["Low durability"] = "Niedrige Haltbarkeit",
	["Low durability (35% or less)"] = "Niedrige Haltbarkeit (35% oder weniger)",
	["Mage is missing a Mage Armor"] = "Magier hat keine Glühende Rüstung aktiv",
	["Mana less than 80%"] = "Mana unter 80%",
	["MANY!"] = "VIELE!",
	["Melee DPS %s has died!"] = "Nahkampf DD %s ist gestorben!",
	["Missing "] = "Kein ",
	["Missing a scroll"] = "Ohne Schriftrolle",
	["Missing buff: "] = "Fehlender Buff: ",
	["Missing buffs (Boss): "] = "Fehlende Buffs (Boss): ",
	["Missing buffs (Trash): "] = "Fehlende Buffs (Trash): ",
	["Missing or not working oRA or RBS: "] = "Fehlendes oder nicht funktionierendes oRA oder RBS:",
	No = "Nein",
	["No buffs needed! (Boss)"] = "Keine Buffs benötigt! (Boss)",
	["No buffs needed! (Trash)"] = "Keine Buffs benötigt! (Trash)",
	["No Soulstone detected"] = "Kein Seelenstein entdeckt",
	["Not Well Fed"] = "Nicht satt",
	Offline = "Offline",
	["Out of range"] = "Außer Reichweite",
	["Paladin blessing"] = "Paladin-Segen fehlt",
	["Paladin missing Seal"] = "Paladin ohne Siegel",
	["Player has a wrong Paladin blessing"] = "Spieler hat einen falschen Paladin-Segen",
	["Player has health less than 80%"] = "Spieler mit Gesundheit unter 80%",
	["Player has mana less than 80%"] = "Spieler mit Mana unter 80%",
	["Player is AFK"] = "Spieler ist AFK",
	["Player is Dead"] = "Spieler ist tot",
	["Player is in a different zone"] = "Spieler ist in einer anderen Zone",
	["Player is missing at least one Paladin blessing"] = "Spieler fehlt mindestens ein Paladin-Segen",
	["Player is Offline"] = "Spieler ist offline",
	["Please relog or reload UI to update the item cache."] = "Bitte reloggen oder das UI neu laden um den Item Cache zu aktualisieren.",
	["prepares a %s!"] = "bereitet ein %s zu!",
	["Press Escape -> Interface -> AddOns -> RaidBuffStatus for more options."] = "Drücke Escape -> Interface -> AddOns -> RaidBuffStatus für weitere Optionen.",
	Prot = "Schutz",
	["Protection Paladin with no Righteous Fury"] = "Schutzpaladin ohne Zorn der Gerechtigkeit",
	["PVP is On"] = "PVP ist aktiv",
	["PVP On"] = "PVP aktiv",
	["Ranged DPS %s has died!"] = "Fernkampf DD %s ist gestorben!",
	["RBS Dashboard Help"] = "RBS-Hilfe für Zusammenfassungsfenster",
	["RBS Tank List"] = "RBS-Tank-Liste",
	["Refreshment Table about to expire!"] = "Erfrischungstisch verschwindet bald!",
	["Remind me later"] = "Später erinnern",
	["(Remove buff)"] = "(Buff entfernen)",
	["Remove this button from this dashboard in the buff options window."] = "Rufe die RBS-Optionen auf, um diesen Button vom Zusammenfassungsfenster zu verstecken",
	["Repair Bot about to expire!"] = "Reparaturbot verschwindet bald!",
	["[RESIST]"] = "[WIDERSTANDEN]",
	["Right-click to open the addons options menu"] = "Rechtsklick für Interface-Optionen-Menü",
	["%s about to expire!"] = "%s verschwindet bald!",
	Scan = "Scan",
	["%s cast %s on %s"] = "%s wirkt %s auf %s",
	Scroll = "Schriftrolle",
	Seal = "Siegel",
	["Sent %d whispers to %d players"] = "%d Flüsternachrichten an %d Spieler gesendet",
	["%s has a newer (%s) version of RBS (%s) than you (%s)"] = "%s hat eine neuere (%s) Version von RBS (%s) als du (%s)",
	["Shift-Click buffs to report on only that buff."] = "Shift-Klick Buff, um nur diesen zu berichten.",
	["%s is running RBS %s"] = "%s benutzt RBS %s",
	["Slackers: "] = "Pfuscher: ",
	["Slacking Paladins"] = "Pfuschende Paladine",
	["Sorry, I am queued for"] = "Sorry, ich bin in der Warteschlange für",
	["Sorry, I am queued for a battlefield."] = "Sorry, ich bin in der Warteschlange für ein Schlachtfeld.",
	["Sorry, the group is now full."] = "Sorry, die Gruppe ist jetzt voll.",
	["Soul Well about to expire!"] = "Seelenbrunnen verschwindet bald!",
	Spi = "Will",
	Sta = "Aus",
	Str = "Stä",
	["Tank missing Earth Shield"] = "Tank hat kein Erdschild",
	["Tank missing Thorns"] = "Tank hat keine Dornen",
	["Tank %s has died!"] = "Tank %s ist gestorben!",
	["Tank with "] = "Tank mit ",
	["The above default button actions can be reconfigured."] = "Diese Standard-Tastenkombinationen können geändert werden",
	["This is the first time RaidBuffStatus has been activated since installation or settings were reset. Would you like to visit the Buff Wizard to help you get RBS buffs configured? If you are a raid leader then you can click No as the defaults are already set up for you."] = "Das ist das erste Mal, dass RaidBuffStatus aktiviert wurde (oder die Einstellungen wurden zurückgesetzt). Willst du den Buff-Assistenten benutzen, um RBS zu konfigurieren? Wenn du ein Raidleiter bist, kannst du Nein klicken, dann sind die Standardeinstellungen bereits für dich eingerichtet.",
	["Tol Barad"] = "Tol Barad",
	Trash = "Trash",
	["Warning: "] = "Warnung: ",
	["Warnings: "] = "Warnungen: ",
	["Weapon buff"] = "Waffenbuff",
	["Well Fed but slacking"] = "Satt, aber ungenügend",
	Wintergrasp = "Tausendwintersee",
	["Wrong flask for this zone"] = "Falsches Fläschchen für diese Zone",
	["Wrong Paladin blessing"] = "Falscher Paladin-Segen",
	["You need to be leader or assistant to do this"] = "Hierfür musst du Schlachtzugsleiter oder -assistent sein",
	["You need to whisper the leader instead: "] = "Du musst den Gruppenleiter anflüstern: ",
}
La.Options = {
	Alive = "Lebendig",
	["Allow raiders to use flasks and elixirs from last expansion"] = "Schlachtzugteilnehmern den Gebrauch von Fläschchen und Elixieren aus früheren Erweiterungen gestatten",
	["Alt-left click"] = "Alt-Linksklick",
	["Alt-right click"] = "Alt-Rechtsklick",
	["Always hide the Boss R Trash buttons"] = "Die Boss B Trash Buttons immer verstecken",
	["Announce to raid warning when a Feast is prepared"] = "Schlachtzugswarnung ausgeben, wenn jemand ein Festmahl aufstellt",
	["Anti spam"] = "Anti-Spam",
	Appearance = "Aussehen",
	["Auto-accept invites"] = "Einladungen automatisch akzeptieren",
	["Auto-invite whispers"] = "Auto-invite Flüstern",
	["Automatically accept invites from friends and guild members so you can go for a bio-break whilst waiting for a raid invite"] = "Einladungen von Freunden und Gildenmitgliedern automatisch akzeptieren, damit du während der Raideinladung AFK sein kannst",
	["Automatically accept invites from these"] = "Automatisch Einladungen von diesen annehmen",
	["Automatically configures the dashboard buffs and configuration defaults for your class or raid leading role"] = "Konfiguriert automatisch das Zusammenfassungsfenster und die Konfigurationseinstellungen für deine Klasse oder Raidleiter-Rolle",
	["Automatically invite friends and guild members who whisper to you the word 'invite'"] = "Freunde und Gildenmitglieder automatisch einladen, die dir das Wort 'invite' flüstern.",
	["Automatically invite these"] = "Diese automatisch einladen",
	["Automatically show the dashboard when you join a battleground"] = "Zusammenfassungsfenster automatisch im Schlachtfeld einblenden",
	["Automatically show the dashboard when you join a party"] = "Zusammenfassungsfenster automatisch anzeigen, wenn Du dich einer Gruppe anschließt",
	["Automatically show the dashboard when you join a raid"] = "Zusammenfassungsfenster automatisch anzeigen, wenn Du dich einem Schlachtzug anschließt",
	["Automatically whisper anyone missing a Healthstone when your Soul Well expire warnings appear"] = "Automatisch jeden anflüstern, dem ein Gesundheitsstein fehlt, wenn ein Seelenbrunnen bald verschwindet.",
	["Automatically whisper anyone missing flasks or elixirs when your Cauldron expire warnings appear"] = "Automatisch jeden anflüstern, dem Fläschchen oder Elixiere fehlen, wenn ein Kessel bald verschwindet",
	["Automatically whisper anyone missing Well Fed when your Feast expire warnings appear"] = "Automatisch jeden anflüstern, dem Satt fehlt, wenn ein Festmahl bald verschwindet",
	Automation = "Automatisierung",
	["Background colour"] = "Hintergrundfarbe",
	["Bar positioning"] = "Leistenpositionierung",
	["Battle.net friends"] = "Battle.net-Freunde",
	["Border colour"] = "Randfarbe",
	["Bosses only"] = "Nur bei Bossen",
	Bottom = "Unten",
	["Buff button sorting"] = "Buff-Button Sortierung",
	["Buff Options scale"] = "Buff Optionen Skalierung",
	["Buff those missing buff"] = "Spieler ohne Buff nachbuffen",
	["Buff Wizard"] = "Buff-Assistent",
	Cauldron = "Kessel",
	["Cauldron auto whisper"] = "Kessel Flüstern",
	["CC-break warnings"] = "CC-Brecher Warnungen",
	["Choose either one big collection of buff checks or traditional style with Warnings, Trash and Boss buff checks"] = "Wähle entweder eine große Zusammenfassung aller Buff-Checks oder die traditionellen Warnungen, Trash und Boss Buff-Checks",
	["Choose where on the dashboard the bars appear"] = "Wähle, wo die Leisten auf dem Zusammenfassungsfenster erscheinen",
	["Class-specific buffs"] = "Klassenspezifische Buffs",
	Combat = "Kampf",
	["Combat options"] = "Optionen für Kampf",
	["Configure how the buff buttons and status bars on the dashboard are sorted and displayed"] = "Wähle, wie die Buff-Buttons und Statusleisten auf dem Zusammenfassungsfenster sortiert und angezeigt werden",
	["Consumable options"] = "Optionen für Verbrauchbares",
	Consumables = "Verbrauchbares",
	["Core raid buffs"] = "Kern Raidbuffs",
	["Ctrl-left click"] = "Strg-Linksklick",
	["Ctrl-right click"] = "Strg-Rechtsklick",
	["Danielbarron broke Sheep on The Lich King with Hand of Reckoning"] = "Danielbarron hat Verwandlung auf Lich König mit Hand der Abrechnung gebrochen!",
	["Darinia ninjaed my target (The Lich King) with Taunt"] = "Darinia hat mein Ziel (Der Lichkönig) mit Spott gestohlen",
	["Darinia taunted my mob (The Lich King) with Taunt"] = "Darinia hat meinen Mob (Der Lichkönig) mit Spott gespottet",
	["Darinia taunted my target (The Lich King) with Taunt"] = "Darinia hat mein Ziel (Der Lichkönig) mit Spott gespottet",
	["Dashboard columns"] = "Spalten",
	["Dashboard mouse button actions options"] = "Einstellungen für Zusammenfassungfenster-Maustastenbefehle",
	["Dashboard scale"] = "Skalierung",
	["Death warnings"] = "Todeswarnungen",
	["Default order"] = "Standardsortierung",
	["Disable scan in combat"] = "Scan im Kampf deaktivieren",
	["DPS mana"] = "DD-Mana",
	["Enable/disable buff check"] = "Buff-Prüfung (de)aktivieren",
	["Enable tank warnings including taunts, failed taunts and mob stealing"] = "Aktiviere Tankwarnungen (Spott, fehlgeschlagener Spott und gestohlene Gegner)",
	["Enable tank warnings including taunts, failed taunts and mob stealing only on bosses"] = "Aktiviere Tankwarnungen (Spott, fehlgeschlagener Spott und gestohlene Gegner) nur bei Bossen",
	["Enable warning messages when players die"] = "Aktiviere Warnungen, wenn Spieler sterben",
	["Enable warnings when Crowd Control is broken by tanks and non-tanks"] = "Aktiviert Warnungen, wenn Kontrollzauber gebrochen werden",
	["Enable warnings when Misdirection or Tricks of the Trade is cast"] = "Aktiviere Warnungen, wenn Irreführung oder Schurkenhandel gewirkt wird",
	["Feast auto whisper"] = "Festmahl Flüstern",
	Feasts = "Festmahl",
	["Food announce"] = "Tisch- und Mahlankündigungen",
	Friends = "Freunde",
	["Grouping style"] = "Gruppierung",
	["Guild members"] = "Gildenmitglieder",
	["Healer death"] = "Heiler gestorben",
	["Healer drinking"] = "Heiler trinken",
	["Healer drinking sound"] = "Heiler-Trinken Ton",
	["Healer mana"] = "Heiler-Mana",
	["Healers alive"] = "Lebende Heiler",
	["Healer Stormsnow has died!"] = "Heiler Stormsnow ist gestorben!",
	["Hide and show the buff report dashboard."] = "Zusammenfassungsfenster aus-/einblenden.",
	["Hide Boss R Trash"] = "Verstecke Boss B Trash",
	["Hide dashboard during combat"] = "Versteckt das Zusammenfassungsfenster im Kampf",
	["Hide in combat"] = "Im Kampf verstecken",
	["Hide the buff report dashboard."] = "Zusammenfassungsfenster ausblenden.",
	["Highlight my buffs"] = "Meine Buffs hervorgeben",
	["Hightlight currently missing buffs on the dashboard for which you are responsible including self buffs and buffs which you are missing that are provided by someone else. I.e. show buffs for which you must take action"] = "Hebt die Buffs hervor, für die du verantwortlich bist - inklusive Selbstbuffs.",
	["How MANY?"] = "Wie VIELE?",
	["Ignore groups 6 to 8"] = "Gruppe 6-8 ignorieren",
	["Ignore groups 6 to 8 when reporting as these are for subs"] = "Gruppe 6 bis 8 beim Berichten ignorieren, da diese für Ersatz ist",
	["[IMMUNE] Danielbarron FAILED TO TAUNT their target (The Lich King) with Hand of Reckoning"] = "[IMMUN] SPOTT von Danielbarron auf das Ziel (Der Lichkönig) mit Hand der Abrechnung FEHLGESCHLAGEN",
	["In range"] = "In Reichweite",
	invite = "invite",
	["Just my buffs"] = "Nur meine Buffs",
	["Left click"] = "Linksklick",
	["Melee DPS Danielbarron has died!"] = "Nahkampf DD Danielbarron ist gestorben!",
	["Melee DPS death"] = "Nahkampf DD gestorben",
	["Minimap icon"] = "Minikartensymbol",
	["Minimum remaining buff duration in minutes. Buffs with less than this will be considered as missing.  This option only takes affect when the corresponding 'buff' button is enabled on the dashboard."] = "Minimal verbleibende Buff-Zeit in Minuten. Buffs, die weniger lang laufen, gelten als fehlend. Diese Option wirkt nur, wenn der entsprechende 'Buff' Button am Zusammenfassungsfenster aktiviert ist.",
	["Min remaining buff duration"] = "Min. verbleibende Buff-Zeit",
	["Misdirection warnings"] = "Irreführung Warnungen",
	["Mouse buttons"] = "Maustasten",
	["Move with Alt-click"] = "Mit Alt-Klick bewegen",
	["My buffs"] = "Meine Buffs",
	["Ninja taunts"] = "Gestohlenes Ziel",
	["No healer close"] = "Kein Heiler nahe",
	None = "Kein/e",
	["Non-tank breaks CC"] = "Nicht-Tank bricht CC",
	["Non-tank Glamor broke Hex on The Lich King with Moonfire"] = "Nicht-Tank Glamor hat Verhexen auf Lich König mit Mondfeuer gebrochen!",
	["NON-TANK Tanagra taunted my target (The Lich King) with Growl"] = "NICHT-TANK Tanagra hat mein Ziel (Der Lichkönig) mit Knurren gespottet",
	["Non-tank taunts my target"] = "Nicht-Tank-Spott auf mein Ziel",
	["Number of columns to display on the dashboard"] = "Anzahl der Spalten im Zusammenfassungsfenster",
	["Old flasks and elixirs"] = "Alte Fläschchen und Elixiere",
	["One big group"] = "Eine große Gruppe",
	["One group down"] = "Eine Gruppe unten",
	["Only if all have it"] = "Nur, wenn alle Paladine Pally Power benutzen",
	["Only me"] = "Nur mich",
	["Only show the buffs for which your class is responsible for.  This configuration can be used like a buff-bot where one simply right clicks on the buffs to cast them"] = "Nur Buffs anzeigen, für die deine Klasse verantwortlich ist. Diese Konfiguration kann wie ein Buff-Bot verwendet werden, wo man einfach per Rechtsklick die Buffs wirkt",
	["Only show the core class raid buffs"] = "Nur die wichtigsten Raidbuffs anzeigen",
	["Only show when you and only you break Crowd Control so you can say 'Now I don't believe you wanted to do that did you, ehee?'"] = "Nur zeigen, wenn du und nur du einen Kontrollzauber gebrochen hast, damit du sagen kannst: 'Now I don't believe you wanted to do that did you, ehee?'",
	["Only use tank list"] = "Nur Tank-Liste benutzen",
	["Only use the tank list and ignore spec when there is a tank list for determining if someone is a tank or not"] = "Nur die Tank-Liste zur Bestimmung der Tanks benutzen, nicht die Talentspezialisierung",
	["Options for automatically opening the dashboard and moving it"] = "Optionen für automatisches Öffnen und Verschieben des Zusammenfassungsfensters",
	["Options for setting the quality requirements of consumables"] = "Einstellungen der Qualitätsbedingungen von Verbrauchbarem",
	["Options to do with configuring the tank list"] = "Optionen zur Konfiguration der Tank-Liste",
	Other = "Anderes",
	["Other taunt fails"] = "Verfehlter Spott von anderen",
	["Play a sound"] = "Ton abspielen",
	["Play a sound when a healer dies"] = "Ton abspielen, wenn ein Heiler gestorben ist",
	["Play a sound when a healer drinks and is not full on mana"] = "Einen Ton abspielen, wenn ein Heiler trinkt und nicht volles Mana hat",
	["Play a sound when a melee DPS dies"] = "Ton abspielen, wenn ein Nahkampf DD gestorben ist",
	["Play a sound when a non-tank breaks Crowd Control"] = "Einen Ton abspielen, wenn ein Nicht-Tank einen Kontrollzauber gebrochen hat",
	["Play a sound when a ranged DPS dies"] = "Ton abspielen, wenn ein Fernkampf DD gestorben ist",
	["Play a sound when a tank breaks Crowd Control"] = "Einen Ton abspielen, wenn ein Tank einen Kontrollzauber gebrochen hat",
	["Play a sound when a tank dies"] = "Ton abspielen, wenn ein Tank gestorben ist",
	["Play a sound when Misdirection or Tricks of the Trade is cast"] = "Ton abspielen, wenn Irreführung oder Schurkenhandel gewirkt wird",
	["Play a sound when one of your taunts fails due to resist"] = "Ton abspielen, wenn dein Spott fehlgeschlagen ist, weil das Ziel widerstanden hat",
	["Play a sound when one of your taunts fails due to the target being immune"] = "Ton abspielen, wenn dein Spott fehlgeschlagen ist, weil das Ziel immun war",
	["Play a sound when other people's taunts to your target fail"] = "Ton abspielen, wenn Spott anderer Spieler dein Ziel verfehlt",
	["Play a sound when someone else targets a mob and taunts that mob which is targeting you"] = "Ton abspielen, wenn jemand einen Gegner spottet, der mich schon angreift",
	["Play a sound when someone else taunts your target"] = "Ton abspielen, wenn jemand anderes dein Ziel spottet",
	["Play a sound when someone else taunts your target which is targeting you"] = "Ton abspielen, wenn jemand anderes dein Ziel spottet, obwohl dieses dich angreift",
	["Play a sound when someone else who is not a tank taunts your target"] = "Ton abspielen, wenn ein Nicht-Tank mein Ziel spottet",
	["Prepend RBS::"] = "RBS:: hinzufügen",
	["Prepend RBS:: to all lines of report chat. Disable to only prepend on the first line of a report"] = "'RBS::' an jeden Zeilenanfang eines Berichts hinzufügen. Deaktivieren, um nur einmal am Anfang eines Berichts 'RBS::' hinzuzufügen.",
	["Raid health"] = "Schlachtzug-Gesundheit",
	["Raid leader"] = "Raidleiter",
	["Raid mana"] = "Schlachtzug-Mana",
	["Raid Status Bars"] = "Schlachtzug-Statusbalken",
	["Raid-wide buffs"] = "Raidweite Buffs",
	["Ranged DPS death"] = "Fernkampf DD gestorben",
	["Ranged DPS Garmann has died!"] = "Fernkampf DD Garmann ist gestorben!",
	["Refreshment Table"] = "Erfrischungstisch",
	["Repair Bot"] = "Reparaturbot",
	Reporting = "Berichten",
	["Reporting options"] = "Optionen für Berichten",
	["Report missing to raid"] = "Fehlende an Schlachtzug melden",
	["Report to officer channel"] = "An Offiziers Channel berichten",
	["Report to officers"] = "An Offiziere berichten",
	["Report to /raid or /party who is not buffed to the max."] = "An /schlachtzug oder /gruppe berichten, wer nicht maximal gebufft ist.",
	["Report to raid/party"] = "An Schlachtzug/Gruppe berichten",
	["Report to raid/party - requires raid assistant"] = "An Schlachtzug/Gruppe berichten - benötigt Schlachtzugassistent",
	["Report to self"] = "An sich selbst berichten",
	["Required food quality"] = "Benötigte Essensqualität",
	["Require the Alt buton to be held down to move the dashboard window"] = "Das Zusammenfassungsfenster nur mit gedrückter Alt-Taste und Mausklick bewegen lassen",
	["[RESIST] Danielbarron FAILED TO TAUNT their target (The Lich King) with Hand of Reckoning"] = "[WIDERSTANDEN] SPOTT von Danielbarron auf das Ziel (Der Lichkönig) mit Hand der Abrechnung FEHLGESCHLAGEN",
	["[RESIST] Darinia FAILED TO TAUNT my target (The Lich King) with Taunt"] = "[WIDERSTANDEN] SPOTT von Darinia auf mein Ziel (Der Lichkönig) mit Spott FEHLGESCHLAGEN",
	["Right click"] = "Rechtsklick",
	["Scale the Buff Options window"] = "Skaliere das Buff-Optionen Fenster",
	["Scale the dashboard window"] = "Skaliere das Zusammenfassungsfenster",
	["Seconds between updates"] = "Sekunden zwischen Aktualisierung",
	["Select which action to take when you click with the left mouse button over a dashboard buff check"] = "Auswählen, welche Funktion ein Linksklick über einem Buff im Zusammenfassungsfenster aufruft",
	["Select which action to take when you click with the left mouse button with Alt held down over a dashboard buff check"] = "Auswählen, welche Funktion ein Alt-Linksklick über einem Buff im Zusammenfassungsfenster aufruft",
	["Select which action to take when you click with the left mouse button with Ctrl held down over a dashboard buff check"] = "Auswählen, welche Funktion ein Strg-Linksklick über einem Buff im Zusammenfassungsfenster aufruft",
	["Select which action to take when you click with the left mouse button with Shift held down over a dashboard buff check"] = "Auswählen, welche Funktion ein Umschalt-Linksklick über einem Buff im Zusammenfassungsfenster aufruft",
	["Select which action to take when you click with the right mouse button over a dashboard buff check"] = "Auswählen, welche Funktion ein Rechtsklick über einem Buff im Zusammenfassungsfenster aufruft",
	["Select which action to take when you click with the right mouse button with Alt held down over a dashboard buff check"] = "Auswählen, welche Funktion ein Alt-Rechtsklick über einem Buff im Zusammenfassungsfenster aufruft",
	["Select which action to take when you click with the right mouse button with Ctrl held down over a dashboard buff check"] = "Auswählen, welche Funktion ein Strg-Rechtsklick über einem Buff im Zusammenfassungsfenster aufruft",
	["Select which action to take when you click with the right mouse button with Shift held down over a dashboard buff check"] = "Auswählen, welche Funktion ein Umschalt-Rechtsklick über einem Buff im Zusammenfassungsfenster aufruft",
	["Select which level of food quality you require for the raiders to be considered 'Well Fed'"] = "Wähle, welche Qualität das Essen haben muss, damit es als 'Satt' gilt.",
	["Self buffs"] = "Selbstbuffs",
	["Set how many seconds between dashboard raid scan updates"] = "Die Anzahl Sekunden zwischen einzelnen Buffchecks der (Schlacht-)Gruppe einstellen",
	["Set N - the number of people missing a buff considered to be \"MANY\""] = "Setze die Spieleranzahl, ab denen ein fehlender Buff bei VIELEN gemeldet wird.",
	["Shift-left click"] = "Umschalt-Linksklick",
	["Shift-right click"] = "Umschalt-Rechtsklick",
	["Shorten names"] = "Namen abkürzen",
	["Shorten names in the report to reduce channel spam"] = "Namen beim Berichten abkürzen um Chatspam zu reduzieren",
	["Show group number"] = "Zeige Gruppennummer",
	["Show in battleground"] = "Auf Schlachtfeld zeigen",
	["Show in party"] = "Zeige in Gruppe",
	["Show in raid"] = "Zeige in Schlachtzug",
	["Show the buff report dashboard."] = "Zusammenfassungsfenster einblenden.",
	["Show the group number of the person missing a party/raid buff"] = "Zeigt die Gruppennummer des Spielers, dem ein Buff fehlt",
	["Single target buffs"] = "Einzelbuffs",
	["Skin and minimap options"] = "Optionen für Skin und Minikarte",
	["Skin and scaling"] = "Skin und Skalierung",
	["Skip buff checking during combat. You can manually initiate a scan by pressing Scan on the dashboard"] = "Deaktiviert Buffchecks im Kampf. Scans können manuell über den Scan-Button gestartet werden.",
	["%s minutes"] = "%s Minuten",
	["Sort buff buttons by"] = "Sortiere Buff-Buttons nach",
	["Soul Well"] = "Seelenbrunnen",
	["Status bars to show raid, dps, tank health, mana, etc"] = "Statusbalken für u. a. Gesundheit und Mana von Schlachtzug, DDs, Tanks und Heilern anzeigen",
	["Tank breaks CC"] = "Tank bricht CC",
	["Tank Danielbarron has died!"] = "Tank Danielbarron ist gestorben!",
	["Tank death"] = "Tank gestorben",
	["Tank health"] = "Tank-Gesundheit",
	["Tank list"] = "Tank-Liste",
	["Tanks alive"] = "Lebende Tanks",
	["Tank warnings"] = "Tankwarnungen",
	["Tank warnings about taunts, failed taunts and mob stealing including accidental taunts from non-tanks"] = "Tankwarnungen über Spott, fehlgeschlagenem Spott und gestohlene Gegner, inklusive versehentlichem Spott von Nicht-Tanks",
	["Taunts to my mobs"] = "Spott auf Gegner, die mich angreifen",
	["Taunts to my target"] = "Spott auf mein Ziel",
	["Tells you when someone in your party, raid or guild has a newer version of RBS installed"] = "Sagt dir, wenn jemand in der Gruppe, dem Raid oder deiner Gilde eine neuere Version von RBS als du installiert hat",
	["Tells you when someone in your party, raid or guild has RBS installed"] = "Sagt dir, wenn jemand in deinem Schlachtzug, deiner Gruppe oder Gilde RBS installiert hat",
	Test = "Test",
	["Test what the warning is like"] = "Teste die Warnung",
	["The average DPS mana percent"] = "Durchschnittliches Mana der DDs in Prozent",
	["The average healer mana percent"] = "Durchschnittliches Heilermana in Prozent",
	["The average party/raid health percent"] = "Durchschnitt der Lebenspunkte von Gruppe/Schlachtzug",
	["The average party/raid mana percent"] = "Durchschnittliches Schlachtzugmana in Prozent",
	["The average tank health percent"] = "Durchschnitt der Gesundheit des/der Tank/s",
	["The Buff Wizard automatically configures the dashboard buffs and configuration defaults for your class or raid leading role."] = "Der Buff-Assistent konfiguriert automatisch das Zusammenfassungsfenster und die Konfigurationseinstellungen für deine Klasse und Raidleiter-Rolle.",
	["Then sort buff buttons by"] = "Danach Buff-Buttons sortieren nach",
	["The percentage of healers alive in the raid"] = "Prozentsatz der noch lebenden Heiler im Schlachtzug",
	["The percentage of people alive in the raid"] = "Prozentsatz der noch lebenden Schlachtzugsmitglieder",
	["The percentage of people dead in the raid"] = "Prozentsatz der toten Spieler",
	["The percentage of people within 40 yards range"] = "Prozentsatz der Spieler innerhalb von 40 Meter",
	["The percentage of tanks alive in the raid"] = "Prozentsatz der noch lebenden Tanks im Schlachtzug",
	["This is the default configuration in which RBS ships out-of-the-box.  It gives you pretty much anything a raid leader would need to see on the dashboard"] = "Dies ist die Standardkonfiguration, mit der RBS ausgeliefert wird. Sie zeigt praktisch alles, was ein Raidleiter sehen muss, in dem Zusammenfassungsfenster",
	["Toggle to display a minimap icon"] = "Minikartensymbol ein-/ausblenden",
	Top = "Oben",
	["To set this option go to the addon configuration.  This button is automatically enabled when the Boss button is pressed and automatically disabled when the Trash button is pressed.  To permanently disable, choose 0 seconds as the min remaining buff duration."] = "Gehe in die Addon-Konfiguration um diese Option zu setzen. Dieser Button wird automatisch aktiviert, wenn der Boss Button gedrückt wird und wird automatisch deaktiviert, wenn der Trash Button gedrückt wird. Wähle 0 Sekunden als Min. verbleibende Buff-Zeit, um ihn dauerhaft zu deaktivieren.",
	["Two groups down"] = "Zwei Gruppen unten",
	["User announce"] = "Benutzer Ankündigung",
	["Version announce"] = "Versionsankündigung",
	["Wait before announcing to see if others have announced first in order to reduce spam"] = "Warten, bevor etwas angekündigt wird (um Spam zu verhindern)",
	["Warning messages when players die"] = "Warnmeldungen, wenn Spieler sterben",
	["Warnings when Crowd Control is broken by tanks and non-tanks"] = "Warnungen, wenn Kontrollzauber gebrochen werden",
	["Warnings when Misdirection or Tricks of the Trade is cast"] = "Warnungen, wenn Irreführung oder Schurkenhandel gewirkt wird",
	["Warnings when someone else targets a mob and taunts that mob which is targeting you"] = "Warnungen, wenn jemand einen Gegner spottet, der mich schon angreift",
	["Warnings when someone else taunts your target"] = "Warnungen, wenn jemand anderes dein Ziel spottet",
	["Warnings when someone else taunts your target who is not a tank"] = "Warnungen, wenn ein Nicht-Tank mein Ziel spottet",
	["Warning, Trash, Boss groups"] = "Warnungen, Trash und Boss Gruppen",
	["Warns when a non-tank breaks Crowd Control"] = "Warnungen, wenn ein Nicht-Tank einen Kontrollzauber bricht",
	["Warns when a tank breaks Crowd Control"] = "Warnungen, wenn ein Tank einen Kontrollzauber bricht",
	["Warns when other people's taunts to your target fail"] = "Warnung wiedergeben, wenn Spott anderer Spieler dein Ziel verfehlt",
	["Warns when someone else taunts your target which is targeting you"] = "Warnungen, wenn jemand anderes dein Ziel spottet, obwohl dieses dich angreift",
	["Warns when your taunts fail due to resist"] = "Warnungen, wenn dein Spott fehlschlägt, weil das Ziel widerstanden hat",
	["Warns when your taunts fail due to the target being immune"] = "Warnungen, wenn dein Spott fehlschlägt, weil das Ziel immun ist",
	["Warn to party"] = "Gruppe warnen",
	["Warn to party when a healer dies"] = "Deine Gruppe warnen, wenn ein Heiler gestorben ist",
	["Warn to party when a melee DPS dies"] = "Deine Gruppe warnen, wenn ein Nahkampf DD gestorben ist",
	["Warn to party when a non-tank breaks Crowd Control"] = "Deine Gruppe warnen, wenn ein Nicht-Tank einen Kontrollzauber bricht",
	["Warn to party when a ranged DPS dies"] = "Deine Gruppe warnen, wenn ein Fernkampf DD gestorben ist",
	["Warn to party when a tank breaks Crowd Control"] = "Deine Gruppe warnen, wenn ein Tank einen Kontrollzauber bricht",
	["Warn to party when a tank dies"] = "Deine Gruppe warnen, wenn ein Tank gestorben ist",
	["Warn to party when one of your taunts fails due to resist"] = "Deine Gruppe warnen, wenn dein Spott fehlgeschlagen ist, weil das Ziel widerstanden hat",
	["Warn to party when one of your taunts fails due to the target being immune"] = "Deine Gruppe warnen, wenn dein Spott fehlgeschlagen ist, weil das Ziel immun war",
	["Warn to party when other people's taunts to your target fail"] = "Deine Gruppe warnen, wenn Spott anderer Spieler dein Ziel verfehlt",
	["Warn to party when someone else targets a mob and taunts that mob which is targeting you"] = "Deine Gruppe warnen, wenn jemand einen Gegner spottet, der mich schon angreift",
	["Warn to party when someone else taunts your target"] = "Deine Gruppe warnen, wenn jemand anderes dein Ziel spottet",
	["Warn to party when someone else taunts your target which is targeting you"] = "Deine Gruppe warnen, wenn jemand anderes dein Ziel spottet, obwohl dieses dich angreift",
	["Warn to party when someone else who is not a tank taunts your target"] = "Deine Gruppe warnen, wenn ein Nicht-Tank mein Ziel spottet",
	["Warn to raid chat"] = "Warnung im Schlachtzugschat",
	["Warn to raid chat when a healer dies"] = "Warnung an Schlachtzugschat, wenn ein Heiler gestorben ist",
	["Warn to raid chat when a melee DPS dies"] = "Warnung an Schlachtzugschat, wenn ein Nahkampf DD gestorben ist",
	["Warn to raid chat when a non-tank breaks Crowd Control"] = "Warnung an Schlachtzugschat, wenn ein Nicht-Tank einen Kontrollzauber bricht",
	["Warn to raid chat when a ranged DPS dies"] = "Warnung an Schlachtzugschat, wenn ein Fernkampf DD gestorben ist",
	["Warn to raid chat when a tank breaks Crowd Control"] = "Warnung an Schlachtzugschat, wenn ein Tank einen Kontrollzauber bricht",
	["Warn to raid chat when a tank dies"] = "Warnung an Schlachtzugschat, wenn ein Tank gestorben ist",
	["Warn to raid chat when one of your taunts fails due to resist"] = "Warnung an Schlachtzugschat, wenn dein Spott fehlgeschlagen ist, weil das Ziel widerstanden hat",
	["Warn to raid chat when one of your taunts fails due to the target being immune"] = "Warnung an Schlachtzugschat, wenn dein Spott fehlgeschlagen ist, weil das Ziel immun war",
	["Warn to raid chat when other people's taunts to your target fail"] = "Warnung an Schlachtzugschat, wenn Spott anderer Spieler verfehlt",
	["Warn to raid chat when someone else targets a mob and taunts that mob which is targeting you"] = "Warnung an Schlachtzugschat, wenn jemand einen Gegner spottet, der mich schon angreift",
	["Warn to raid chat when someone else taunts your target"] = "Warnung an Schlachtzugschat, wenn jemand anderes dein Ziel spottet",
	["Warn to raid chat when someone else taunts your target which is targeting you"] = "Warnung an Schlachtzugschat, wenn jemand anderes dein Ziel spottet, obwohl es dich angreift",
	["Warn to raid chat when someone else who is not a tank taunts your target"] = "Warnung an Schlachtzugschat, wenn ein Nicht-Tank dein Ziel spottet",
	["Warn to raid warning"] = "Schlachtzugswarnung ausgeben",
	["Warn to self"] = "Warnung an dich",
	["Warn to self when a healer dies"] = "Warnung an dich selbst, wenn ein Heiler gestorben ist",
	["Warn to self when a melee DPS dies"] = "Warnung an dich selbst, wenn ein Nahkampf DD gestorben ist",
	["Warn to self when a non-tank breaks Crowd Control"] = "Warnung an dich selbst, wenn ein Nicht-Tank einen Kontrollzauber bricht",
	["Warn to self when a ranged DPS dies"] = "Warnung an dich selbst, wenn ein Fernkampf DD gestorben ist",
	["Warn to self when a tank breaks Crowd Control"] = "Warnung an dich selbst, wenn ein Tank einen Kontrollzauber bricht",
	["Warn to self when a tank dies"] = "Warnung an dich selbst, wenn ein Tank gestorben ist",
	["Warn to self when Misdirection or Tricks of the Trade is cast"] = "Warnung an dich selbst, wenn Irreführung oder Schurkenhandel gewirkt wird",
	["Warn to self when one of your taunts fails due to resist"] = "Warnung an dich selbst, wenn dein Spott fehlgeschlagen ist, weil das Ziel widerstanden hat",
	["Warn to self when one of your taunts fails due to the target being immune"] = "Warnung an dich selbst, wenn dein Spott fehlgeschlagen ist, weil das Ziel immun war",
	["Warn to self when other people's taunts to your target fail"] = "Warnung an dich selbst, wenn Spott anderer Spieler dein Ziel verfehlt",
	["Warn to self when someone else targets a mob and taunts that mob which is targeting you"] = "Warnung an mich selbst, wenn jemand einen Gegner spottet, der mich schon angreift",
	["Warn to self when someone else taunts your target"] = "Warnung an dich selbst, wenn jemand anderes dein Ziel spottet",
	["Warn to self when someone else taunts your target which is targeting you"] = "Warnung an dich selbst, wenn jemand anderes dein Ziel spottet, obwohl dieses dich angreift",
	["Warn to self when someone else who is not a tank taunts your target"] = "Warnung an dich selbst, wenn ein Nicht-Tank mein Ziel spottet",
	["Warn using raid warning when a healer dies"] = "Schlachtzugswarnung ausgeben, wenn ein Heiler gestorben ist",
	["Warn using raid warning when a melee DPS dies"] = "Schlachtzugswarnung ausgeben, wenn ein Nahkampf DD gestorben ist",
	["Warn using raid warning when a non-tank breaks Crowd Control"] = "Schlachtzugswarnung ausgeben, wenn ein Nicht-Tank einen Kontrollzauber bricht",
	["Warn using raid warning when a ranged DPS dies"] = "Schlachtzugswarnung ausgeben, wenn ein Fernkampf DD gestorben ist",
	["Warn using raid warning when a tank breaks Crowd Control"] = "Schlachtzugswarnung ausgeben, wenn ein Tank einen Kontrollzauber bricht",
	["Warn using raid warning when a tank dies"] = "Schlachtzugswarnung ausgeben, wenn ein Tank gestorben ist",
	["Warn using raid warning when one of your taunts fails due to resist"] = "Schlachtzugswarnung ausgeben, wenn dein Spott fehlgeschlagen ist, weil das Ziel widerstanden hat",
	["Warn using raid warning when one of your taunts fails due to the target being immune"] = "Schlachtzugswarnung ausgeben, wenn dein Spott fehlgeschlagen ist, weil das Ziel immun war",
	["Warn using raid warning when other people's taunts to your target fail"] = "Schlachtzugswarnung ausgeben, wenn Spott anderer Spieler dein Ziel verfehlt",
	["Warn using raid warning when someone else targets a mob and taunts that mob which is targeting you"] = "Schlachtzugswarnung ausgeben, wenn jemand einen Gegner spottet, der mich schon angreift",
	["Warn using raid warning when someone else taunts your target"] = "Schlachtzugswarnung ausgeben, wenn jemand anderes dein Ziel spottet",
	["Warn using raid warning when someone else taunts your target which is targeting you"] = "Schlachtzugwarnung ausgeben, wenn jemand anderes dein Ziel spottet, obwohl dieses dich angreift",
	["Warn using raid warning when someone else who is not a tank taunts your target"] = "Schlachtzugswarnung ausgeben, wenn ein Nicht-Tank mein Ziel spottet",
	["Warn when a healer dies"] = "Warnen, wenn ein Heiler gestorben ist",
	["Warn when a melee DPS dies"] = "Warnen, wenn ein Nahkampf DD gestorben ist",
	["Warn when a ranged DPS dies"] = "Warnen, wenn ein Fernkampf DD gestorben ist",
	["Warn when a tank dies"] = "Warnen, wenn ein Tank gestorben ist",
	["Well auto whisper"] = "Seelenbrunnen Flüstern",
	["When at least N people are missing a raid buff say MANY instead of spamming a list"] = "Wenn beim Melden mindestens N Spielern ein Buff fehlt, wird VIELE ausgegeben, statt eine komplette Liste",
	["When many say so"] = "VIELE melden",
	["When there are multiple people who can provide a missing buff such as Fortitude then only whisper one of them at random who is in range rather than all of them"] = "Wenn mehrere Personen den fehlenden Buff bereitstellen können (z.B. Ausdauer), wird nur ein zufälliger Spieler in Reichweite angeflüstert (statt alle).",
	["When whispering and at least N people are missing a raid buff say MANY instead of spamming a list"] = "Wenn beim Flüstern mindestens N Spielern ein Buff fehlt, wird VIELE ausgegeben, statt eine komplette Liste",
	["Whisper buffers"] = "Buffer anflüstern",
	["Whisper many"] = "VIELE flüstern",
	["Whisper only one"] = "Nur einen Anflüstern",
	["Your taunt immune-fails"] = "Deine Spott-Immun-Fehlschläge",
	["Your taunt resist-fails"] = "Deine Spott-Widerstanden-Fehlschläge",
}
La.RaidStatusBars = {
	["Dead healers"] = "Tote Heiler",
	["Dead tanks"] = "Tote Tanks",
	["I see dead people"] = "Ich sehe tote Leute",
	["n/a"] = "n/v",
	P = "P",
	["Pull Timer"] = "Pull-Timer",
	R = "B",
	["Ready Check"] = "Bereitschaftscheck",
}
La.TalentsWindow = {
	Class = "Klasse",
	Healer = "Heiler",
	["Melee DPS"] = "Nahkampf Schaden",
	Name = "Name",
	["Ranged DPS"] = "Fernkampf Schaden",
	Refresh = "Aktualisieren",
	Role = "Rolle",
	Spec = "Skillung",
	Specialisations = "Spezialisierung",
	["Talent Specialisations"] = "Talent Spezialisierung",
	Tank = "Tank",
}
La.TankTauntWarnings = {
	["NON-TANK %s taunted my boss target (%s%s%s) with %s"] = "NICHT-TANK %s hat den Boss (%s%s%s) mit %s gespottet",
	["NON-TANK %s taunted my target (%s%s%s) with %s"] = "NICHT-TANK %s hat mein Ziel (%s%s%s) mit %s gespottet",
	["%s FAILED TO NINJA my boss target (%s%s%s) with %s"] = "SPOTT-NINJA von %s auf den Boss (%s%s%s) mit %s FEHLGESCHLAGEN",
	["%s FAILED TO NINJA my target (%s%s%s) with %s"] = "SPOTT-NINJA von %s auf mein Ziel (%s%s%s) mit %s FEHLGESCHLAGEN",
	["%s FAILED TO TAUNT my boss target (%s%s%s) with %s"] = "SPOTT von %s auf den Boss (%s%s%s) mit %s FEHLGESCHLAGEN",
	["%s FAILED TO TAUNT my target (%s%s%s) with %s"] = "SPOTT von %s auf mein Ziel (%s%s%s) mit %s FEHLGESCHLAGEN",
	["%s FAILED TO TAUNT their boss target (%s%s%s) with %s"] = "SPOTT von %s auf den Boss (%s%s%s) mit %s FEHLGESCHLAGEN",
	["%s FAILED TO TAUNT their target (%s%s%s) with %s"] = "SPOTT von %s auf das Ziel (%s%s%s) mit %s FEHLGESCHLAGEN",
	["%s ninjaed my boss target (%s%s%s) with %s"] = "%s hat den Boss (%s%s%s) mit %s gestohlen",
	["%s ninjaed my target (%s%s%s) with %s"] = "%s hat mein Ziel (%s%s%s) mit %s gestohlen",
	["%s taunted my boss mob (%s%s%s) with %s"] = "%s hat den Boss (%s%s%s) mit %s gespottet",
	["%s taunted my boss target (%s%s%s) with %s"] = "%s hat den Boss (%s%s%s) mit %s gespottet",
	["%s taunted my mob (%s%s%s) with %s"] = "%s hat meinen Mob (%s%s%s) mit %s gespottet",
	["%s taunted my target (%s%s%s) with %s"] = "%s hat mein Ziel (%s%s%s) mit %s gespottet",
}

elseif locale == "koKR" then do end
-- La["Announce even when you don't have assist or lead"] = ""
-- La["Announce expiration"] = ""
-- La["Announcement options for raid utilities like Feasts"] = ""
La["Announce to raid warning when a %s is prepared"] = "%s님이 준비될때 레이드 경고로 발표" -- Needs review
-- La["Announce to raid warning when a utility is expiring"] = ""
-- La["Announce without lead"] = ""
-- La["Augment Banquet Tooltips"] = ""
La["Augment Banquet Tooltips with stat bonus information"] = "스탯 보너스 정보와 함께 툴팁 증가 표시" -- Needs review
-- La["Augment Rune"] = ""
La["Blingtron"] = "블링트론" -- Needs review
La["Blingtron about to expire!"] = "블링트론에 대한 만료!" -- Needs review
La["Bonus"] = "보너스" -- Needs review
-- La["Broken Link"] = ""
-- La["casts %s"] = ""
-- La["Eating"] = ""
-- La["Expiration announcements"] = ""
-- La[" has set us up a Blingtron"] = ""
-- La["has set us up a %s"] = ""
-- La["Mailbox"] = ""
-- La["Noodle Cart"] = ""
-- La["Portal"] = ""
-- La["Prefer Static Buff"] = ""
-- La["Report missing static buffs even when an equivalent passive aura is already present."] = ""
-- La["Required flask quality"] = ""
-- La["Right-click to target"] = ""
-- La["Select which level of flask quality you require"] = ""
-- La["sets up a %s"] = ""
La["Show configuration options"] = "옵션 구성 표시" -- Needs review
-- La["Soulwell"] = ""
-- La["Tooltip name coloring"] = ""
-- La["Tooltip role icons"] = ""
-- La["Treat eating as Well Fed"] = ""
-- La["Treat players who are currently eating as Well Fed. This assumes they are eating acceptable food."] = ""
-- La["Utility announcements"] = ""
-- La["Warrior Stance"] = ""
La.BuffOptionsWindow = {
	["Buff Options"] = "버프 설정",
	["Is a buff"] = "버프 그룹으로",
	["Is a warning"] = "경보 그룹으로",
	["Report on Boss"] = "보스전 보고",
	["Report on Trash"] = "휴지통 보고",
	["Show on dashboard"] = "알림판에 보이기",
	["Show/Report in combat"] = "전투중에 보이기/보고하기",
}
La.CrowdControlWarnings = {
	["Melee Swing"] = "일반 공격",
	["Non-tank %s broke %s on %s%s%s"] = "비탱커 %s님이 %s(을)를 %s%s%s에게서 해제했습니다",
	["Non-tank %s broke %s on %s%s%s with %s"] = "비탱커 %s님이 %s(을)를 %s%s%s에게서 %s를 사용해 해제했습니다.",
	["%s broke %s on %s%s%s"] = "%님이 %s(을)를 %s%s%s에게서 해제했습니다.",
	["%s broke %s on %s%s%s with %s"] = "%님이 %s(을)를 %s%s%s에게서 %s(을)를 사용해 해제했습니다.",
}
La.Messages = {
	AFK = "자리 비움",
	Agil = "민첩성",
	alpha = "투명도",
	["Alt-Click on a party buff will cast on someone missing that buff."] = "파티버프를 Alt+클릭하면 해당 버프를 버프가 없는사람에게 시전합니다.",
	["Alt-Click on a self buff will renew that buff."] = "개인버프를 Alt+클릭하면 해당 버프를 갱신합니다.",
	["Aspect Cheetah/Pack On"] = "치타의 상이나 치타 무리의 상이 켜져 있습니다.",
	["Aspect of the Cheetah or Pack is on"] = "치타의 상이나 치타 무리의 상이 켜져 있습니다.",
	["Battle Elixir"] = "전투 비약",
	beta = "베타",
	["Blessing of Kings is not needed because you are grouped with a Druid."] = "그룹내에 드루이드가 있어 왕의 축복이 필요하지 않습니다.",
	["Blessing of Kings, with this raid configuration, is better provided by Drums of the Forgotten Kings thus allowing Blessing of Might to be used."] = "현재 레이드 구성상, 잊혀진 왕의 북이 왕의 축복보다 부분적으로 좋은 성능을 제공합니다. 따라서, 다른 축복을 사용하세요.",
	Boss = "보스",
	["Buffers: "] = "버프 가능자:",
	["Buffing Kings:"] = "왕의 축복:",
	["Buffing Might:"] = "힘의 축복:",
	["Cast by:"] = "시전자:",
	["Click buffs to disable and enable."] = "버프를 클릭하면 해당 버프 기능을 활성화하거나 비활성화 합니다.",
	["Click to toggle the RBS dashboard"] = "클릭 : 버프 알림판 표시/숨김",
	["Ctrl-Click Boss or Trash to whisper all those who need to buff."] = "버프가 필요한 모든 사람에게 귓속말을 하려면 보스나 휴지통을 Ctrl-클릭하세요.",
	["Ctrl-Click buffs to whisper those who need to buff."] = "버프를 Ctrl+클릭하면 그 버프가 필요한 사람에게 귓속말을 합니다.",
	Dead = "죽음",
	["Death Knight Presence"] = "죽음의 기사 형상",
	["Different Zone"] = "다른 지역",
	["Flasked or Elixired but slacking"] = "영약 또는 비약 (저레벨)",
	["Flask or two Elixirs"] = "영약 또는 비약 2종",
	["Guardian Elixir"] = "강화 비약",
	["Has buff: "] = "가지고 있는 버프 : ",
	[" has set us up a Refreshment Table"] = "님이 원기 회복의 식탁을 만들었습니다",
	[" has set us up a Repair Bot"] = "님이 수리 로봇을 소환했습니다.",
	[" has set us up a Soul Well"] = "님이 영혼의 샘을 만들었습니다.",
	["Healer %s has died!"] = "힐러 %s 가 죽었습니다!",
	["Health less than 80%"] = "체력이 80% 이하",
	-- ["Hide outgoing whispers"] = "",
	["Hunter Aspect"] = "사냥꾼 상",
	["Hunter has no aspect at all"] = "사냥꾼이 어떤 상도 켜지 않았습니다.",
	["[IMMUNE]"] = "[면역]",
	Int = "지능",
	[" in their bags"] = " 가방 안",
	["Invite auto-accepted from battle.net friend %s."] = "자동수락을 허용한 실명친구 %s를 초대합니다.",
	["Invite auto-accepted from friend %s."] = "자동수락을 허용한 친구 %s를 초대합니다.",
	["Invite auto-accepted from guild member %s."] = "자동수락을 허용한 길드원 %s를 초대합니다.",
	["Item count: "] = "아이템 수:",
	["Low durability"] = "내구도 낮음",
	["Low durability (35% or less)"] = "내구도 낮음 (35% 이하)",
	["Mage is missing a Mage Armor"] = "마법사 갑옷이 없습니다.",
	["Mana less than 80%"] = "마나가 80% 이하",
	["MANY!"] = "다수!",
	["Melee DPS %s has died!"] = "근접 딜러 %s 가 죽었습니다!",
	["Missing "] = "없음 :",
	["Missing a scroll"] = "두루마리 부족",
	["Missing buff: "] = "부족한 버프 : ",
	["Missing buffs (Boss): "] = "부족한 버프 (보스) : ",
	["Missing buffs (Trash): "] = "부족한 버프(휴지통): ",
	["Missing or not working oRA or RBS: "] = "oRA or RBS가 없거나 동작하지 않음",
	No = "아니오",
	["No buffs needed! (Boss)"] = "버프 완료! (보스)",
	["No buffs needed! (Trash)"] = "버프 완료! (휴지통)",
	["No Soulstone detected"] = "영혼석이 발견되지 않았습니다.",
	["Not Well Fed"] = "포만감 버프 부족",
	Offline = "오프라인",
	["Out of range"] = "사거리 밖",
	["Paladin blessing"] = "성기사 축복",
	["Paladin missing Seal"] = "문장을 켜지 않은 성기사",
	["Player has a wrong Paladin blessing"] = "플레이어가 잘못된 성기사 축복을 받았습니다.",
	["Player has health less than 80%"] = "플레이어의 체력이 80% 이하입니다.",
	["Player has mana less than 80%"] = "플레이어의 마나가 80% 이하입니다.",
	["Player is AFK"] = "플레이어가 자리비움 상태입니다.",
	["Player is Dead"] = "플레이어가 죽었습니다.",
	["Player is in a different zone"] = "플레이어가 다른 지역에 있습니다.",
	["Player is missing at least one Paladin blessing"] = "플레이어가 적어도 하나 이상의 성기사 축복이 부족합니다.",
	["Player is Offline"] = "플레이어가 오프라인입니다.",
	["Please relog or reload UI to update the item cache."] = "아이템 캐쉬를 갱신하려면 로그를 다시 작성하거나 UI를 재시작하세요.",
	["prepares a %s!"] = "%s 준비됨!",
	["Press Escape -> Interface -> AddOns -> RaidBuffStatus for more options."] = "ESC -> 인터페이스 설정 -> 애드온 -> RaidBuffStatus에서 추가설정을 하세요.",
	Prot = "보호의 두루마리",
	["Protection Paladin with no Righteous Fury"] = "정의의 격노를 켜지 않은 보호기사",
	["PVP is On"] = "PVP전투 상태가 활성화되었습니다.",
	["PVP On"] = "PVP 전투 상태",
	["Ranged DPS %s has died!"] = "원거리 딜러 %s 가 죽었습니다!",
	["RBS Dashboard Help"] = "RBS 대쉬보드 도움말",
	["RBS Tank List"] = "RBS 탱커 목록",
	["Refreshment Table about to expire!"] = "원기 회복의 식탁이 사라지려고 합니다!",
	["Remind me later"] = "추후에 알려주세요",
	["(Remove buff)"] = "(버프를 제거합니다)",
	["Remove this button from this dashboard in the buff options window."] = "알림판의 버프 옵션창에서 이 버튼을 삭제할 수 있습니다.",
	["Repair Bot about to expire!"] = "수리 로봇이 곧 사라집니다!",
	["[RESIST]"] = "[저항]",
	["Right-click to open the addons options menu"] = "우클릭 : 설정창 열기",
	["%s about to expire!"] = "%s 사라짐!",
	Scan = "검사",
	["%s cast %s on %s"] = "%s님이 %s를 %s님에게 시전합니다.",
	Scroll = "두루마리",
	Seal = "문장",
	-- ["Sent %d whispers to %d players"] = "",
	["%s has a newer (%s) version of RBS (%s) than you (%s)"] = "%s의 RBS(%s)버전(%s)이 당신의 (%s)보다 최신버전입니다.",
	["Shift-Click buffs to report on only that buff."] = "버프를 Shift+클릭하면 해당 버프에 대해서만 보고합니다.",
	["%s is running RBS %s"] = "%s님이 RBS %s를 실행중입니다.",
	["Slackers: "] = "게으름뱅이: ",
	["Slacking Paladins"] = "노는 성기사",
	["Sorry, I am queued for"] = "죄송합니다, 대기중입니다",
	["Sorry, I am queued for a battlefield."] = "죄송합니다, 전장 대기중입니다.",
	["Sorry, the group is now full."] = "죄송합니다, 파티가 풀입니다.",
	["Soul Well about to expire!"] = "영혼의 샘이 곧 사라집니다!",
	Spi = "정신력",
	Sta = "체력",
	Str = "힘",
	["Tank missing Earth Shield"] = "대지의 보호막이 없는 탱커",
	["Tank missing Thorns"] = "가시가 없는 탱커",
	["Tank %s has died!"] = "탱커 %s 가 죽었습니다!",
	-- ["Tank with "] = "",
	["The above default button actions can be reconfigured."] = "위의 마우스 버튼 기능은 재설정할 수 있습니다.",
	["This is the first time RaidBuffStatus has been activated since installation or settings were reset. Would you like to visit the Buff Wizard to help you get RBS buffs configured? If you are a raid leader then you can click No as the defaults are already set up for you."] = "RaidBuffStatus의 최초 사용입니다. RBS의 버프 설정을 돕기 위해서 버프 마법사를 실행하시겠습니까? 만일 공격대장이라면 당신에게 맞는 기본 옵션을 사용하기 위해서 No를 클릭하세요.",
	["Tol Barad"] = "톨 바라드",
	Trash = "휴지통",
	["Warning: "] = "경고:",
	["Warnings: "] = "경고:",
	["Weapon buff"] = "무기 버프",
	["Well Fed but slacking"] = "포만감 (저레벨)",
	Wintergrasp = "겨울손아귀",
	["Wrong flask for this zone"] = "현재 지역에 맞지 않는 영약",
	["Wrong Paladin blessing"] = "잘못된 성기사 축복",
	["You need to be leader or assistant to do this"] = "실행하려면 공대장이거나 승급이 되어야 합니다.",
	["You need to whisper the leader instead: "] = "공격대장에게 귓말해보세요: ",
}
La.Options = {
	Alive = "생존자",
	["Allow raiders to use flasks and elixirs from last expansion"] = "80레벨 불타는 성전 비약 및 영약 허용",
	["Alt-left click"] = "Alt-클릭",
	["Alt-right click"] = "Alt-우클릭",
	["Always hide the Boss R Trash buttons"] = "보스 준 휴지통 버튼을 항상 숨깁니다",
	["Announce to raid warning when a Feast is prepared"] = "생선 통구이가 준비 되었을 때 공격대 경보로 알려주기",
	["Anti spam"] = "스팸 방지",
	Appearance = "외형",
	["Auto-accept invites"] = "초대 자동 수락",
	["Auto-invite whispers"] = "귓속말 자동 초대",
	["Automatically accept invites from friends and guild members so you can go for a bio-break whilst waiting for a raid invite"] = "공격대 초대를 기다리며 쉬는 동안 친구나 길드원의 초대가 오면 자동으로 수락합니다.",
	["Automatically accept invites from these"] = "이곳에서 보내는 초대를 자동으로 수락",
	["Automatically configures the dashboard buffs and configuration defaults for your class or raid leading role"] = "자신의 직업 또는 공격대장 역할에 따라 알림판의 버프와 설정값을 자동으로 구성합니다.",
	["Automatically invite friends and guild members who whisper to you the word 'invite'"] = "귓속말로 '초대'라고 보낸 친구 또는 길드원을 자동으로 초대합니다.",
	["Automatically invite these"] = "자동으로 초대",
	["Automatically show the dashboard when you join a battleground"] = "전장 참여시 자동으로 알림판 보기",
	["Automatically show the dashboard when you join a party"] = "파티 참여 시 자동으로 알림판 보기",
	["Automatically show the dashboard when you join a raid"] = "공격대 참여 시 자동으로 알림판 보기",
	["Automatically whisper anyone missing a Healthstone when your Soul Well expire warnings appear"] = "영혼의 샘이 사라진다는 경고를 할 때, 생명석이 없는 사람에게 자동으로 귓속말을 보냅니다.",
	["Automatically whisper anyone missing flasks or elixirs when your Cauldron expire warnings appear"] = "가마솥이 사라진다는 경고를 할 때, 비약이나 영약이 없는 사람에게 자동으로 귓속말을 보냅니다.",
	["Automatically whisper anyone missing Well Fed when your Feast expire warnings appear"] = "생선 통구이가 사라진다는 경고를 할 때, 포만감 버프가 없는 사람에게 자동으로 귓속말을 보냅니다",
	Automation = "자동",
	["Background colour"] = "배경색",
	["Bar positioning"] = "바 위치",
	["Battle.net friends"] = "실명 친구",
	["Border colour"] = "외곽선 색",
	["Bosses only"] = "보스만 ",
	Bottom = "하단",
	["Buff button sorting"] = "버프 버튼 정렬",
	["Buff Options scale"] = "버프 설정창 크기",
	["Buff those missing buff"] = "누락된 버프 시전",
	["Buff Wizard"] = "버프 마법사",
	Cauldron = "가마솥",
	["Cauldron auto whisper"] = "가마솥 자동 귓속말",
	["CC-break warnings"] = "군중제어 해제 경고",
	["Choose either one big collection of buff checks or traditional style with Warnings, Trash and Boss buff checks"] = "버프 아이콘 통합 또는 경보,휴지통,보스 버프 체크 형식 중 선택하세요.",
	["Choose where on the dashboard the bars appear"] = "상태바를 알림판 어디에 표시할지 선택합니다",
	["Class-specific buffs"] = "직업별 버프",
	Combat = "전투",
	["Combat options"] = "전투 설정",
	["Configure how the buff buttons and status bars on the dashboard are sorted and displayed"] = "알림판의 버프버튼과 상태바의 정렬/표시 방법을 설정합니다.",
	["Consumable options"] = "소비용품 설정",
	Consumables = "소비용품",
	["Core raid buffs"] = "핵심 공격대 버프",
	["Ctrl-left click"] = "Ctrl-클릭",
	["Ctrl-right click"] = "Ctrl-우클릭",
	["Danielbarron broke Sheep on The Lich King with Hand of Reckoning"] = "Danielbarron님(이)가 변이(을)를 리치왕에게서 심판의 손길(을)를 사용해 해제했습니다.",
	["Darinia ninjaed my target (The Lich King) with Taunt"] = "Darinia님이 내 대상(리치왕)을 도발(으)로 가져갔습니다.",
	["Darinia taunted my mob (The Lich King) with Taunt"] = "Darinia님이 자신의 몹(리치왕)을 도발(으)로 도발했습니다.",
	["Darinia taunted my target (The Lich King) with Taunt"] = "Darinia님이 자신의 대상(리치왕)을 도발(으)로 도발했습니다.",
	["Dashboard columns"] = "알림판 칸 수",
	["Dashboard mouse button actions options"] = "알림판 마우스 버튼 설정",
	["Dashboard scale"] = "알림판 크기",
	["Death warnings"] = "죽음 경고",
	["Default order"] = "기본 정렬",
	["Disable scan in combat"] = "전투중 조사 중지",
	["DPS mana"] = "딜러 마나",
	["Enable/disable buff check"] = "버프 체크 사용/미사용",
	["Enable tank warnings including taunts, failed taunts and mob stealing"] = "탱커 경보를 활성화합니다(도발, 도발 실패, 몹 뺏김)",
	["Enable tank warnings including taunts, failed taunts and mob stealing only on bosses"] = "보스만 탱커 경보를 활성화합니다(도발, 도발 실패, 몹 뺏김)",
	["Enable warning messages when players die"] = "플레이어가 죽었을때 경고 메세지를 사용합니다.",
	["Enable warnings when Crowd Control is broken by tanks and non-tanks"] = "탱커나 비탱커에 의해서 군중제어가 해제됐을때 경보를 사용합니다.",
	["Enable warnings when Misdirection or Tricks of the Trade is cast"] = "눈속임이나 속임수 거래가 시전되었을 때 경보를 사용합니다.",
	["Feast auto whisper"] = "생선 통구이 자동 귓속말",
	Feasts = "생선 통구이",
	["Food announce"] = "음식 알림",
	Friends = "친구",
	["Grouping style"] = "분류 방식",
	["Guild members"] = "길드원",
	["Healer death"] = "힐러 사망",
	["Healer drinking"] = "힐러 음료섭취",
	["Healer drinking sound"] = "힐러 음료 섭취 소리",
	["Healer mana"] = "힐러 마나",
	["Healers alive"] = "생존한 힐러",
	["Healer Stormsnow has died!"] = "힐러 Stormsnow가 죽었습니다!",
	["Hide and show the buff report dashboard."] = "알림판을 표시 또는 숨깁니다",
	["Hide Boss R Trash"] = "보스 준 휴지통 숨기기",
	["Hide dashboard during combat"] = "전투동안에 알림판을 숨깁니다",
	["Hide in combat"] = "전투중 숨기기",
	["Hide the buff report dashboard."] = "알림판을 숨깁니다.",
	["Highlight my buffs"] = "내 버프 강조",
	["Hightlight currently missing buffs on the dashboard for which you are responsible including self buffs and buffs which you are missing that are provided by someone else. I.e. show buffs for which you must take action"] = "개인 버프 또는 자신이 담당하는 버프가 사라지거나 다른사람에게 받은 버프가 사라지려고 하면 해당 버프를 알림판에 강조합니다. 즉 버프가 표시되면 조취를 취해야 합니다.",
	["How MANY?"] = "'다수'란?",
	["Ignore groups 6 to 8"] = "파티 6 - 8 무시",
	["Ignore groups 6 to 8 when reporting as these are for subs"] = "6 - 8 파티의 상황은 보고하지 않습니다.",
	["[IMMUNE] Danielbarron FAILED TO TAUNT their target (The Lich King) with Hand of Reckoning"] = "[면역] Danielbarron님이 대상(리치킹)을 심판의 손길(으)로 도발했으나 실패했습니다.",
	["In range"] = "사거리 안",
	invite = "초대",
	["Just my buffs"] = "내 버프만 설정",
	["Left click"] = "클릭",
	["Melee DPS Danielbarron has died!"] = "근접 딜러 Danielbarron이 죽었습니다!",
	["Melee DPS death"] = "밀리 딜러 사망",
	["Minimap icon"] = "미니맵 아이콘",
	["Minimum remaining buff duration in minutes. Buffs with less than this will be considered as missing.  This option only takes affect when the corresponding 'buff' button is enabled on the dashboard."] = "잔여버프지속시간 최소값 이하인 경우 해당 버프가 없는것으로 간주합니다. 이 옵션은 해당 버프 버튼이 알림판에 활성화되어 있을 때 적용됩니다.",
	["Min remaining buff duration"] = "잔여버프지속시간 최소값",
	["Misdirection warnings"] = "눈속임 경고",
	["Mouse buttons"] = "마우스 버튼",
	["Move with Alt-click"] = "알트 클릭으로 이동",
	["My buffs"] = "내 버프",
	["Ninja taunts"] = "닌자 도발",
	["No healer close"] = "",
	None = "없음",
	["Non-tank breaks CC"] = "비탱커가 군중제어를 해제했습니다.",
	["Non-tank Glamor broke Hex on The Lich King with Moonfire"] = "비탱커 Glamor님(이)가 주술(을)를 리치킹에게서 달빛 섬광(을)를 사용해 해제했습니다.",
	["NON-TANK Tanagra taunted my target (The Lich King) with Growl"] = "비탱커 Tanagra님이 내 대상(리치왕)을 포효(으)로 도발했습니다.",
	["Non-tank taunts my target"] = "비탱커가 자신의 대상 도발",
	["Number of columns to display on the dashboard"] = "대쉬보드에 표시할 열의 수",
	["Old flasks and elixirs"] = "불타는 성전 영약 및 비약",
	["One big group"] = "아이콘 통합",
	["One group down"] = "첫번째 그룹 아래",
	["Only if all have it"] = "모두 가지고 있을 경우만",
	["Only me"] = "나에게만",
	["Only show the buffs for which your class is responsible for.  This configuration can be used like a buff-bot where one simply right clicks on the buffs to cast them"] = "자신의 직업이 버프의 담당자일 경우만 표시합니다. 이 설정은 우클릭으로 버프를 시전하는 경우에도 사용됩니다.",
	["Only show the core class raid buffs"] = "핵심 직업의 공격대 버프만 표시",
	["Only show when you and only you break Crowd Control so you can say 'Now I don't believe you wanted to do that did you, ehee?'"] = "",
	["Only use tank list"] = "탱커 목록만 사용",
	["Only use the tank list and ignore spec when there is a tank list for determining if someone is a tank or not"] = "탱커리스트가 있을 경우 특성에 상관없이 탱커 목록에 있는 사람만 탱커로 결정합니다.",
	["Options for automatically opening the dashboard and moving it"] = "자동으로 알림판을 열거나 이동하기 위한 옵션",
	["Options for setting the quality requirements of consumables"] = "필수 소비용품의 품질을 설정하기 위한 옵션",
	["Options to do with configuring the tank list"] = "탱커목록을 편집하기 위한 옵션",
	Other = "기타",
	["Other taunt fails"] = "타인의 도발 실패",
	["Play a sound"] = "소리를 재생합니다.",
	["Play a sound when a healer dies"] = "힐러가 죽었을 때 소리를 재생합니다",
	["Play a sound when a healer drinks and is not full on mana"] = "힐러가 음료를 마시고 있거나 최대 마나가 아니면 소리를 재생합니다",
	["Play a sound when a melee DPS dies"] = "근접 딜러가 죽었을 때 소리를 재생합니다",
	["Play a sound when a non-tank breaks Crowd Control"] = "비탱커가 군중제어를 해제하면 소리를 재생합니다",
	["Play a sound when a ranged DPS dies"] = "원거리 딜가 죽었을 때 소리를 재생합니다.",
	["Play a sound when a tank breaks Crowd Control"] = "탱커가 군중 제어를 해제했을 때 소리를 재생합니다",
	["Play a sound when a tank dies"] = "탱커가 죽었을 때 소리를 재생합니다",
	["Play a sound when Misdirection or Tricks of the Trade is cast"] = "눈속임이나 속임수 거래가 시전되면 소리를 재생합니다.",
	["Play a sound when one of your taunts fails due to resist"] = "저항으로 도발이 실패하면 소리를 재생합니다",
	["Play a sound when one of your taunts fails due to the target being immune"] = "면역으로 도발이 실패하면 소리를 재생합니다.",
	["Play a sound when other people's taunts to your target fail"] = "누군가가 자신의 대상도발을 실패하면 소리를 재생합니다",
	["Play a sound when someone else targets a mob and taunts that mob which is targeting you"] = "누군가 자신을 선택중인 몹을 선택하고 도발하면 소리를 재생합니다",
	["Play a sound when someone else taunts your target"] = "누군가가 자신의 대상을 도발하면 소리를 재생합니다.",
	["Play a sound when someone else taunts your target which is targeting you"] = "자신을 선택중인 대상을 누군가가 도발하면 소리를 재생합니다",
	["Play a sound when someone else who is not a tank taunts your target"] = "비탱커가 자신의 대상을 도발하면 소리를 재생합니다",
	["Prepend RBS::"] = "접두사 RBS::",
	["Prepend RBS:: to all lines of report chat. Disable to only prepend on the first line of a report"] = "대화창으로 보고하는 모든 줄에 RBS::를 접두사로 붙입니다.  비활성화시 첫줄만 표시됩니다.",
	["Raid health"] = "공격대 체력",
	["Raid leader"] = "공격대장",
	["Raid mana"] = "공격대 마나",
	["Raid Status Bars"] = "레이드 상태 바",
	["Raid-wide buffs"] = "",
	["Ranged DPS death"] = "원거리 딜러 사망",
	["Ranged DPS Garmann has died!"] = "원거리 딜러 Garmann이 죽었습니다!",
	["Refreshment Table"] = "원기 회복의 식탁",
	["Repair Bot"] = "수리 로봇",
	Reporting = "보고",
	["Reporting options"] = "보고 설정",
	["Report missing to raid"] = "공격대에 누락 보고",
	["Report to officer channel"] = "관리자 채널에 보고",
	["Report to officers"] = "관리자에게 보고",
	["Report to /raid or /party who is not buffed to the max."] = "버프가 부족한 사람을 /공격대 또는 /파티 로 알립니다",
	["Report to raid/party"] = "공격대/파티에 보고",
	["Report to raid/party - requires raid assistant"] = "공격대/파티에 보고 - 공격대장이나 승급이 필요합니다.",
	["Report to self"] = "자신에게 보고",
	["Required food quality"] = "요구 음식 등급",
	["Require the Alt buton to be held down to move the dashboard window"] = "알림판을 옮기려면 Alt키를 누르고 있어야 합니다.",
	["[RESIST] Danielbarron FAILED TO TAUNT their target (The Lich King) with Hand of Reckoning"] = "[저항] Danielbarro님이 대상(리치킹)을  심판의 손길(으)로 도발했으나 실패했습니다.",
	["[RESIST] Darinia FAILED TO TAUNT my target (The Lich King) with Taunt"] = "[저항] Darinia님이 내 대상(리치킹)을 도발(으)로 도발했으나  실패했습니다.",
	["Right click"] = "우클릭",
	["Scale the Buff Options window"] = "버프 설정창의 크기",
	["Scale the dashboard window"] = "알림판 창의 크기",
	["Seconds between updates"] = "업데이트 간격",
	["Select which action to take when you click with the left mouse button over a dashboard buff check"] = "알림판의 버프확인 아이콘을 좌클릭 시 사용할 작업을 선택합니다.",
	["Select which action to take when you click with the left mouse button with Alt held down over a dashboard buff check"] = "알림판의 버프확인 아이콘을 Alt + 좌클릭 시 사용할 작업을 선택합니다.",
	["Select which action to take when you click with the left mouse button with Ctrl held down over a dashboard buff check"] = "알림판의 버프확인 아이콘을 Ctrl + 좌클릭 시 사용할 작업을 선택합니다.",
	["Select which action to take when you click with the left mouse button with Shift held down over a dashboard buff check"] = "알림판의 버프확인 아이콘을 Shift + 좌클릭 시 사용할 작업을 선택합니다.",
	["Select which action to take when you click with the right mouse button over a dashboard buff check"] = "알림판의 버프확인 아이콘을 우클릭 시 사용할 작업을 선택합니다.",
	["Select which action to take when you click with the right mouse button with Alt held down over a dashboard buff check"] = "알림판의 버프확인 아이콘을 Alt + 우클릭 시 사용할 작업을 선택합니다.",
	["Select which action to take when you click with the right mouse button with Ctrl held down over a dashboard buff check"] = "알림판의 버프확인 아이콘을 Ctrl + 우클릭 시 사용할 작업을 선택합니다.",
	["Select which action to take when you click with the right mouse button with Shift held down over a dashboard buff check"] = "알림판의 버프확인 아이콘을 Shift + 우클릭 시 사용할 작업을 선택합니다.",
	["Select which level of food quality you require for the raiders to be considered 'Well Fed'"] = "공격대원의 '포만감'을 체크할 음식의 등급을 선택합니다.",
	["Self buffs"] = "자신의 버프",
	["Set how many seconds between dashboard raid scan updates"] = "알림판의 업데이트 주기를 설정합니다",
	["Set N - the number of people missing a buff considered to be \"MANY\""] = "N 값 설정 - '다수'로 간주할 버프 누락자의 수",
	["Shift-left click"] = "Shift 클릭",
	["Shift-right click"] = "Shift 우클릭",
	["Shorten names"] = "짧게 표시한 이름",
	["Shorten names in the report to reduce channel spam"] = "채널에 스팸을 줄이기 위해서 보고시 이름을 짧게 합니다",
	["Show group number"] = "파티 이름표 보이기",
	["Show in battleground"] = "전장에서 보이기",
	["Show in party"] = "파티에 보이기",
	["Show in raid"] = "공격대에 보이기",
	["Show the buff report dashboard."] = "알림판을 표시합니다.",
	["Show the group number of the person missing a party/raid buff"] = "파티/레이드 버프가 부족한 플레이어의 파티 이름표 보이기",
	["Single target buffs"] = "단일 대상 버프",
	["Skin and minimap options"] = "외형과 미니맵 옵션",
	["Skin and scaling"] = "외형과 크기",
	["Skip buff checking during combat. You can manually initiate a scan by pressing Scan on the dashboard"] = "전투동안에 버프 체크를 하지 않습니다. 당신은 이것을 알림판의 검사 버튼을 누름으로써, 체크를 초기화할 수 있습니다.",
	["%s minutes"] = "%s 분",
	["Sort buff buttons by"] = "버프버튼 정렬순서",
	["Soul Well"] = "영혼의 샘",
	["Status bars to show raid, dps, tank health, mana, etc"] = "공격대, DPS, 탱커 체력, 마나 등을 보이는 상태 바",
	["Tank breaks CC"] = "탱커가 군중제어를 해제했습니다.",
	["Tank Danielbarron has died!"] = "탱커 Danielbarron이 죽었습니다!",
	["Tank death"] = "탱커 사망",
	["Tank health"] = "탱커 체력",
	["Tank list"] = "탱커 목록",
	["Tanks alive"] = "생존한 탱커",
	["Tank warnings"] = "탱커 경고",
	["Tank warnings about taunts, failed taunts and mob stealing including accidental taunts from non-tanks"] = "탱커 경고는 도발, 도발 실패, 갑작스런 비탱커의 도발을 포함한 몹 스틸에 대해 알려줍니다.",
	["Taunts to my mobs"] = "자신의 몹을 도발",
	["Taunts to my target"] = "자신의 대상을 도발",
	["Tells you when someone in your party, raid or guild has a newer version of RBS installed"] = "파티나 공격대 혹은 길드원에게 새 버전의 RBS가 있으면 알려줍니다",
	["Tells you when someone in your party, raid or guild has RBS installed"] = "파티나 공격대 혹은 길드원 중에 RBS를 설치한 사람이 있으면 알려줍니다.",
	Test = "테스트",
	["Test what the warning is like"] = "경보가 어떻게 나타나는지 테스트합니다.",
	["The average DPS mana percent"] = "평균 딜러 마나 비율",
	["The average healer mana percent"] = "평균 힐러 마나 비율",
	["The average party/raid health percent"] = "평균 파티/공격대 생명력 비율",
	["The average party/raid mana percent"] = "평균 파티/공격대 마나 비율",
	["The average tank health percent"] = "평균 탱커 생명력 비율",
	["The Buff Wizard automatically configures the dashboard buffs and configuration defaults for your class or raid leading role."] = "버프 마법사는 자신의 직업 또는 공격대장 역할에 맞는 기본 설정값으로 알림판을 자동 구성합니다.(주의: 확인창 없이 기본설정으로 돌아갑니다)",
	["Then sort buff buttons by"] = "그 다음 버프버튼 정렬 순서",
	["The percentage of healers alive in the raid"] = "공격대에서 생존한 힐러의 비율",
	["The percentage of people alive in the raid"] = "공격대에서 생존한 플레이어의 비율",
	["The percentage of people dead in the raid"] = "공격대에서 죽은 공격대원의 비율",
	["The percentage of people within 40 yards range"] = "40미터 이내인 공격대원의 비율",
	["The percentage of tanks alive in the raid"] = "공격대에서 생존한 탱커의 비율",
	["This is the default configuration in which RBS ships out-of-the-box.  It gives you pretty much anything a raid leader would need to see on the dashboard"] = "이것은 RBS에 포함된 꽤 쓸만한 기본 설정입니다. 공격대장으로 확인해야할 많은 것들을 알림판에서 볼 수 있습니다.",
	["Toggle to display a minimap icon"] = "미니맵 아이콘 보이기를 토글합니다.",
	Top = "상단",
	["To set this option go to the addon configuration.  This button is automatically enabled when the Boss button is pressed and automatically disabled when the Trash button is pressed.  To permanently disable, choose 0 seconds as the min remaining buff duration."] = "이 값은 설정창에서 변경할 수 있습니다. 이 버튼은 보스 버튼을 누르면 자동으로 활성화되고 휴지통 버튼을 누르면 자동으로 비활성화됩니다. 계속 비활성화 하려면, 잔여버프지속시간 최소값을 0으로 변경합니다.",
	["Two groups down"] = "두번째 그룹 아래",
	["User announce"] = "사용자 알림",
	["Version announce"] = "버전 알림",
	["Wait before announcing to see if others have announced first in order to reduce spam"] = "스팸을 줄이기 위해 알림 기능을 사용한 다른 사람을 우선 확인합니다.",
	["Warning messages when players die"] = "플레이어가 죽었을 때 경보 메세지",
	["Warnings when Crowd Control is broken by tanks and non-tanks"] = "군중제어 효과가 탱커나 비탱커에 의해 해제되면 경고",
	["Warnings when Misdirection or Tricks of the Trade is cast"] = "눈속임이나 속임수 거래가 시전되면 경고",
	["Warnings when someone else targets a mob and taunts that mob which is targeting you"] = "자신을 선택 중인 몹을 누군가가 선택하고 도발하면 경고",
	["Warnings when someone else taunts your target"] = "다른 사람이 당신의 대상을 도발했을 때 경고",
	["Warnings when someone else taunts your target who is not a tank"] = "비탱커가 자신이 대상을 도발시 경고",
	["Warning, Trash, Boss groups"] = "경보, 휴지통, 보스 그룹",
	["Warns when a non-tank breaks Crowd Control"] = "비 탱커가 군중제어를 해제하면 경고",
	["Warns when a tank breaks Crowd Control"] = "탱커가 군중제어를 해제했을 때 경고",
	["Warns when other people's taunts to your target fail"] = "다른 사람이 자신의 대상을 도발 실패시 경고",
	["Warns when someone else taunts your target which is targeting you"] = "자신을 선택 중인 대상을 다른 사람이 도발했을 때 경고",
	["Warns when your taunts fail due to resist"] = "저항으로 도발 실패시 경고",
	["Warns when your taunts fail due to the target being immune"] = "면역으로 도발 실패시 경고",
	["Warn to party"] = "파티에 알림",
	["Warn to party when a healer dies"] = "힐러가 죽었을 때 파티에 알림",
	["Warn to party when a melee DPS dies"] = "밀리 딜러가 죽었을 때 파티에 알림",
	["Warn to party when a non-tank breaks Crowd Control"] = "비 탱커가 군중 제어를 해제했을때 파티에 경고",
	["Warn to party when a ranged DPS dies"] = "원거리 딜러 죽음시 파티에 알림",
	["Warn to party when a tank breaks Crowd Control"] = "탱커가 군중제어를 해제했을때 파티에 경고",
	["Warn to party when a tank dies"] = "탱커가 죽었을 때 파티에 알림",
	["Warn to party when one of your taunts fails due to resist"] = "저항으로 도발 실패시 파티에 알림",
	["Warn to party when one of your taunts fails due to the target being immune"] = "면역으로 도발 실패시 파티에 알림",
	["Warn to party when other people's taunts to your target fail"] = "다른 사람이 자신의 대상을 도발 실패시 파티에 알림",
	["Warn to party when someone else targets a mob and taunts that mob which is targeting you"] = "자신을 선택 중인 몹을 누군가가 선택하고 도발하면 파티에 알림",
	["Warn to party when someone else taunts your target"] = "누군가가 자신의 대상을 도발하면 파티에 알림",
	["Warn to party when someone else taunts your target which is targeting you"] = "자신을 선택 중인 대상을 다른 사람이 도발했을 때 파티에 알림",
	["Warn to party when someone else who is not a tank taunts your target"] = "비탱커가 자신이 대상을 도발시 파티에 알림",
	["Warn to raid chat"] = "공격대 대화로 알림",
	["Warn to raid chat when a healer dies"] = "힐러가 죽으면 공격대 대화으로 알림",
	["Warn to raid chat when a melee DPS dies"] = "밀리 딜러가 죽으면 공격대 대화으로 알림",
	["Warn to raid chat when a non-tank breaks Crowd Control"] = "비탱커가 군중제어를 해제했을 때, 공격대 대화로 알림",
	["Warn to raid chat when a ranged DPS dies"] = "원거리 딜러 죽음 시 공격대 대화로 알림",
	["Warn to raid chat when a tank breaks Crowd Control"] = "탱커가 군중 제어 효과 해제 시 공격대 대화로 알림",
	["Warn to raid chat when a tank dies"] = "탱커가 죽으면 공격대 대화로 알림",
	["Warn to raid chat when one of your taunts fails due to resist"] = "저항으로 도발 실패시 공격대 대화로 알림",
	["Warn to raid chat when one of your taunts fails due to the target being immune"] = "면역으로 도발 실패시 공격대 대화로 알림",
	["Warn to raid chat when other people's taunts to your target fail"] = "다른 사람이 자신의 대상을 도발 실패시 공격대 대화로 알림",
	["Warn to raid chat when someone else targets a mob and taunts that mob which is targeting you"] = "자신을 선택 중인 몹을 누군가가 선택하고 도발하면 공격대 대화로 알림",
	["Warn to raid chat when someone else taunts your target"] = "누군가가 자신의 대상을 도발하면 공격대 대화로 알림",
	["Warn to raid chat when someone else taunts your target which is targeting you"] = "자신을 선택 중인 대상을 다른 사람이 도발했을 때 공격대 대화로 알림",
	["Warn to raid chat when someone else who is not a tank taunts your target"] = "비탱커가 자신의 대상을 도발하면 공격대에 알림",
	["Warn to raid warning"] = "공격대 경보로 알림",
	["Warn to self"] = "자신에게 알림",
	["Warn to self when a healer dies"] = "힐러가 죽었을 때 자신알림",
	["Warn to self when a melee DPS dies"] = "근접 딜러가 죽으면 자신에게 알림",
	["Warn to self when a non-tank breaks Crowd Control"] = "비탱커가 군중 제어 효과 해제 시 자신에게 알림",
	["Warn to self when a ranged DPS dies"] = "원거리 딜러가 죽었을 때 자신에게 알림",
	["Warn to self when a tank breaks Crowd Control"] = "탱커가 군중제어에서 벗어났을 때 자신에게 알림",
	["Warn to self when a tank dies"] = "탱커가 죽었을 때 자신에게 알림",
	["Warn to self when Misdirection or Tricks of the Trade is cast"] = "눈속임이나 속임수 거래가 시전되면 경고합니다.",
	["Warn to self when one of your taunts fails due to resist"] = "저항으로 도발 실패시 자신에게 알림",
	["Warn to self when one of your taunts fails due to the target being immune"] = "면역으로 도발 실패시 자신에게 알림",
	["Warn to self when other people's taunts to your target fail"] = "다른 사람이 자신의 대상을 도발 실패시 자신에게 알림",
	["Warn to self when someone else targets a mob and taunts that mob which is targeting you"] = "자신을 선택 중인 몹을 누군가가 선택하고 도발하면 자신에게 알림",
	["Warn to self when someone else taunts your target"] = "다른 사람이 당신의 대상을 도발했을 때 자신에게 알림",
	["Warn to self when someone else taunts your target which is targeting you"] = "자신을 선택 중인 대상을 다른 사람이 도발했을 때 자신에게 알림",
	["Warn to self when someone else who is not a tank taunts your target"] = "비탱커가 자신의 대상을 도발하면 자신에게 알림",
	["Warn using raid warning when a healer dies"] = "힐러가 죽었을 때 공격대 경보를 이용하여 알림",
	["Warn using raid warning when a melee DPS dies"] = "근접 딜러가 죽으면 공격대 경보로 경고",
	["Warn using raid warning when a non-tank breaks Crowd Control"] = "탱커가 아닌 사람이 군중제어를 해제했을 때 공격대 경보로 경고",
	["Warn using raid warning when a ranged DPS dies"] = "원거리 딜러가 죽었을 때 공격대 경보로 알림",
	["Warn using raid warning when a tank breaks Crowd Control"] = "탱커가 군중제어에서 벗어났을 때 공격대 경보로 알림",
	["Warn using raid warning when a tank dies"] = "탱커가 죽었을 때 공격대 경보를 사용하여 알림",
	["Warn using raid warning when one of your taunts fails due to resist"] = "저항으로 도발 실패시 공격대 경보로 알림",
	["Warn using raid warning when one of your taunts fails due to the target being immune"] = "면역으로 도발 실패시 공격대 경보로 알림",
	["Warn using raid warning when other people's taunts to your target fail"] = "다른 사람이 자신의 대상을 도발 실패시 공격대 경보로 알림",
	["Warn using raid warning when someone else targets a mob and taunts that mob which is targeting you"] = "자신을 선택 중인 몹을 누군가가 선택하고 도발하면 공격대 경보로 알림",
	["Warn using raid warning when someone else taunts your target"] = "다른 사람이 당신의 대상을 도발했을 때 공격대 경보로 알림",
	["Warn using raid warning when someone else taunts your target which is targeting you"] = "자신을 선택 중인 대상을 다른 사람이 도발했을 때 공격대 경보로 알림",
	["Warn using raid warning when someone else who is not a tank taunts your target"] = "자신의 대상을 탱커가 아닌 사람이 도발하면 공격대 경보로 알림",
	["Warn when a healer dies"] = "힐러가 죽었을 때 알림",
	["Warn when a melee DPS dies"] = "밀리 딜러가 죽었을 때 알림",
	["Warn when a ranged DPS dies"] = "원거리 딜러가 죽었을 때 알림",
	["Warn when a tank dies"] = "탱커가 죽었을 때 알림",
	["Well auto whisper"] = "영혼의 샘 자동 귓속말",
	["When at least N people are missing a raid buff say MANY instead of spamming a list"] = "공격대 버프가 없는 사람이 적어도 N 명일때 스팸 목록 대신 '다수'라고 알림",
	["When many say so"] = "다수",
	["When there are multiple people who can provide a missing buff such as Fortitude then only whisper one of them at random who is in range rather than all of them"] = "인내처럼 누락된 버프를 시전할 수 있는 사람이 많은 경우, 사거리 안의 무작위 한명에게 귓속말을 보냅니다.",
	["When whispering and at least N people are missing a raid buff say MANY instead of spamming a list"] = "",
	["Whisper buffers"] = "버프 시전자에게 귓속말",
	["Whisper many"] = "여러명에게 귓속말",
	["Whisper only one"] = "한명에게 귓속말",
	["Your taunt immune-fails"] = "자신의 도발 면역-실패",
	["Your taunt resist-fails"] = "자신의 도발 저항-실패",
}
La.RaidStatusBars = {
	["Dead healers"] = "죽은 힐러",
	["Dead tanks"] = "죽은 탱커",
	["I see dead people"] = "죽은 공대원",
	["n/a"] = "n/a",
	-- P = "",
	-- ["Pull Timer"] = "",
	R = "준", -- Needs review
	-- ["Ready Check"] = "",
}
La.TalentsWindow = {
	Class = "직업",
	Healer = "힐러",
	["Melee DPS"] = "근접 딜러",
	Name = "이름",
	["Ranged DPS"] = "원거리 딜러",
	Refresh = "새로고침",
	Role = "역할",
	Spec = "전문화",
	Specialisations = "특성과 문양",
	["Talent Specialisations"] = "특성 전문화",
	Tank = "탱커",
}
La.TankTauntWarnings = {
	["NON-TANK %s taunted my boss target (%s%s%s) with %s"] = "비탱커 %s님이 내 보스 대상(%s%s%s)을 %s(으)로 도발했습니다.",
	["NON-TANK %s taunted my target (%s%s%s) with %s"] = "비탱커 %s님이 내 대상(%s%s%s)을 %s(으)로 도발했습니다.",
	["%s FAILED TO NINJA my boss target (%s%s%s) with %s"] = "%s님이 내 보스 대상(%s%s%s)을 %s(으)로 가져가려 했으나 실패했습니다.",
	["%s FAILED TO NINJA my target (%s%s%s) with %s"] = "%s님이 내 대상(%s%s%s)을 %s(으)로 가져가려 했으나 실패했습니다.",
	["%s FAILED TO TAUNT my boss target (%s%s%s) with %s"] = "%s님이 내 보스 대상(%s%s%s)을 %s(으)로 도발했느나 실패했습니다.",
	["%s FAILED TO TAUNT my target (%s%s%s) with %s"] = "%s님이 내 대상(%s%s%s)을 %s(으)로 도발했으나 실패했습니다.",
	["%s FAILED TO TAUNT their boss target (%s%s%s) with %s"] = "%s님이 보스 대상(%s%s%s)을 %s(으)로 도발했으나 실패했습니다.",
	["%s FAILED TO TAUNT their target (%s%s%s) with %s"] = "%s님이 대상(%s%s%s)을 %s(으)로 도발했으나 실패했습니다.",
	["%s ninjaed my boss target (%s%s%s) with %s"] = "%s님이 내 보스 대상(%s%s%s)을 %s(으)로 도발로 가져갔습니다.",
	["%s ninjaed my target (%s%s%s) with %s"] = "%s님이 내 대상(%s%s%s)을 %s(으)로 도발로 가져갔습니다.",
	["%s taunted my boss mob (%s%s%s) with %s"] = "%s님이 내 보스 몹(%s%s%s)을 %s(으)로 도발했습니다.",
	["%s taunted my boss target (%s%s%s) with %s"] = "%s님이 내 보스 대상(%s%s%s)을 %s(으)로 도발했습니다.",
	["%s taunted my mob (%s%s%s) with %s"] = "%s님이 내 몹(%s%s%s)을 %s(으)로 도발했습니다.",
	["%s taunted my target (%s%s%s) with %s"] = "%s님이 내 대상(%s%s%s)을 %s(으)로 도발했습니다.",
}

elseif locale == "esMX" then do end
-- La["Announce even when you don't have assist or lead"] = ""
-- La["Announce expiration"] = ""
-- La["Announcement options for raid utilities like Feasts"] = ""
-- La["Announce to raid warning when a %s is prepared"] = ""
-- La["Announce to raid warning when a utility is expiring"] = ""
-- La["Announce without lead"] = ""
-- La["Augment Banquet Tooltips"] = ""
-- La["Augment Banquet Tooltips with stat bonus information"] = ""
-- La["Augment Rune"] = ""
-- La["Blingtron"] = ""
-- La["Blingtron about to expire!"] = ""
-- La["Bonus"] = ""
-- La["Broken Link"] = ""
-- La["casts %s"] = ""
-- La["Eating"] = ""
-- La["Expiration announcements"] = ""
-- La[" has set us up a Blingtron"] = ""
-- La["has set us up a %s"] = ""
-- La["Mailbox"] = ""
-- La["Noodle Cart"] = ""
-- La["Portal"] = ""
-- La["Prefer Static Buff"] = ""
-- La["Report missing static buffs even when an equivalent passive aura is already present."] = ""
-- La["Required flask quality"] = ""
-- La["Right-click to target"] = ""
-- La["Select which level of flask quality you require"] = ""
-- La["sets up a %s"] = ""
-- La["Show configuration options"] = ""
-- La["Soulwell"] = ""
-- La["Tooltip name coloring"] = ""
-- La["Tooltip role icons"] = ""
-- La["Treat eating as Well Fed"] = ""
-- La["Treat players who are currently eating as Well Fed. This assumes they are eating acceptable food."] = ""
-- La["Utility announcements"] = ""
-- La["Warrior Stance"] = ""
La.BuffOptionsWindow = {
	-- ["Buff Options"] = "",
	-- ["Is a buff"] = "",
	-- ["Is a warning"] = "",
	-- ["Report on Boss"] = "",
	-- ["Report on Trash"] = "",
	-- ["Show on dashboard"] = "",
	-- ["Show/Report in combat"] = "",
}
La.CrowdControlWarnings = {
	-- ["Melee Swing"] = "",
	-- ["Non-tank %s broke %s on %s%s%s"] = "",
	-- ["Non-tank %s broke %s on %s%s%s with %s"] = "",
	-- ["%s broke %s on %s%s%s"] = "",
	-- ["%s broke %s on %s%s%s with %s"] = "",
}
La.Messages = {
	-- AFK = "",
	-- Agil = "",
	-- alpha = "",
	-- ["Alt-Click on a party buff will cast on someone missing that buff."] = "",
	-- ["Alt-Click on a self buff will renew that buff."] = "",
	-- ["Aspect Cheetah/Pack On"] = "",
	-- ["Aspect of the Cheetah or Pack is on"] = "",
	-- ["Battle Elixir"] = "",
	-- beta = "",
	-- ["Blessing of Kings is not needed because you are grouped with a Druid."] = "",
	-- ["Blessing of Kings, with this raid configuration, is better provided by Drums of the Forgotten Kings thus allowing Blessing of Might to be used."] = "",
	-- Boss = "",
	-- ["Buffers: "] = "",
	-- ["Buffing Kings:"] = "",
	-- ["Buffing Might:"] = "",
	-- ["Cast by:"] = "",
	-- ["Click buffs to disable and enable."] = "",
	-- ["Click to toggle the RBS dashboard"] = "",
	-- ["Ctrl-Click Boss or Trash to whisper all those who need to buff."] = "",
	-- ["Ctrl-Click buffs to whisper those who need to buff."] = "",
	-- Dead = "",
	-- ["Death Knight Presence"] = "",
	-- ["Different Zone"] = "",
	-- ["Flasked or Elixired but slacking"] = "",
	-- ["Flask or two Elixirs"] = "",
	-- ["Guardian Elixir"] = "",
	-- ["Has buff: "] = "",
	-- [" has set us up a Refreshment Table"] = "",
	-- [" has set us up a Repair Bot"] = "",
	-- [" has set us up a Soul Well"] = "",
	-- ["Healer %s has died!"] = "",
	-- ["Health less than 80%"] = "",
	-- ["Hide outgoing whispers"] = "",
	-- ["Hunter Aspect"] = "",
	-- ["Hunter has no aspect at all"] = "",
	-- ["[IMMUNE]"] = "",
	-- Int = "",
	-- [" in their bags"] = "",
	-- ["Invite auto-accepted from battle.net friend %s."] = "",
	-- ["Invite auto-accepted from friend %s."] = "",
	-- ["Invite auto-accepted from guild member %s."] = "",
	-- ["Item count: "] = "",
	-- ["Low durability"] = "",
	-- ["Low durability (35% or less)"] = "",
	-- ["Mage is missing a Mage Armor"] = "",
	-- ["Mana less than 80%"] = "",
	-- ["MANY!"] = "",
	-- ["Melee DPS %s has died!"] = "",
	-- ["Missing "] = "",
	-- ["Missing a scroll"] = "",
	-- ["Missing buff: "] = "",
	-- ["Missing buffs (Boss): "] = "",
	-- ["Missing buffs (Trash): "] = "",
	-- ["Missing or not working oRA or RBS: "] = "",
	-- No = "",
	-- ["No buffs needed! (Boss)"] = "",
	-- ["No buffs needed! (Trash)"] = "",
	-- ["No Soulstone detected"] = "",
	-- ["Not Well Fed"] = "",
	-- Offline = "",
	-- ["Out of range"] = "",
	-- ["Paladin blessing"] = "",
	-- ["Paladin missing Seal"] = "",
	-- ["Player has a wrong Paladin blessing"] = "",
	-- ["Player has health less than 80%"] = "",
	-- ["Player has mana less than 80%"] = "",
	-- ["Player is AFK"] = "",
	-- ["Player is Dead"] = "",
	-- ["Player is in a different zone"] = "",
	-- ["Player is missing at least one Paladin blessing"] = "",
	-- ["Player is Offline"] = "",
	-- ["Please relog or reload UI to update the item cache."] = "",
	-- ["prepares a %s!"] = "",
	-- ["Press Escape -> Interface -> AddOns -> RaidBuffStatus for more options."] = "",
	-- Prot = "",
	-- ["Protection Paladin with no Righteous Fury"] = "",
	-- ["PVP is On"] = "",
	-- ["PVP On"] = "",
	-- ["Ranged DPS %s has died!"] = "",
	-- ["RBS Dashboard Help"] = "",
	-- ["RBS Tank List"] = "",
	-- ["Refreshment Table about to expire!"] = "",
	-- ["Remind me later"] = "",
	-- ["(Remove buff)"] = "",
	-- ["Remove this button from this dashboard in the buff options window."] = "",
	-- ["Repair Bot about to expire!"] = "",
	-- ["[RESIST]"] = "",
	-- ["Right-click to open the addons options menu"] = "",
	-- ["%s about to expire!"] = "",
	-- Scan = "",
	-- ["%s cast %s on %s"] = "",
	-- Scroll = "",
	-- Seal = "",
	-- ["Sent %d whispers to %d players"] = "",
	-- ["%s has a newer (%s) version of RBS (%s) than you (%s)"] = "",
	-- ["Shift-Click buffs to report on only that buff."] = "",
	-- ["%s is running RBS %s"] = "",
	-- ["Slackers: "] = "",
	-- ["Slacking Paladins"] = "",
	-- ["Sorry, I am queued for"] = "",
	-- ["Sorry, I am queued for a battlefield."] = "",
	-- ["Sorry, the group is now full."] = "",
	-- ["Soul Well about to expire!"] = "",
	-- Spi = "",
	-- Sta = "",
	-- Str = "",
	-- ["Tank missing Earth Shield"] = "",
	-- ["Tank missing Thorns"] = "",
	-- ["Tank %s has died!"] = "",
	-- ["Tank with "] = "",
	-- ["The above default button actions can be reconfigured."] = "",
	-- ["This is the first time RaidBuffStatus has been activated since installation or settings were reset. Would you like to visit the Buff Wizard to help you get RBS buffs configured? If you are a raid leader then you can click No as the defaults are already set up for you."] = "",
	-- ["Tol Barad"] = "",
	-- Trash = "",
	-- ["Warning: "] = "",
	-- ["Warnings: "] = "",
	-- ["Weapon buff"] = "",
	-- ["Well Fed but slacking"] = "",
	-- Wintergrasp = "",
	-- ["Wrong flask for this zone"] = "",
	-- ["Wrong Paladin blessing"] = "",
	-- ["You need to be leader or assistant to do this"] = "",
	-- ["You need to whisper the leader instead: "] = "",
}
La.Options = {
	-- Alive = "",
	-- ["Allow raiders to use flasks and elixirs from last expansion"] = "",
	-- ["Alt-left click"] = "",
	-- ["Alt-right click"] = "",
	-- ["Always hide the Boss R Trash buttons"] = "",
	-- ["Announce to raid warning when a Feast is prepared"] = "",
	-- ["Anti spam"] = "",
	-- Appearance = "",
	-- ["Auto-accept invites"] = "",
	-- ["Auto-invite whispers"] = "",
	-- ["Automatically accept invites from friends and guild members so you can go for a bio-break whilst waiting for a raid invite"] = "",
	-- ["Automatically accept invites from these"] = "",
	-- ["Automatically configures the dashboard buffs and configuration defaults for your class or raid leading role"] = "",
	-- ["Automatically invite friends and guild members who whisper to you the word 'invite'"] = "",
	-- ["Automatically invite these"] = "",
	-- ["Automatically show the dashboard when you join a battleground"] = "",
	-- ["Automatically show the dashboard when you join a party"] = "",
	-- ["Automatically show the dashboard when you join a raid"] = "",
	-- ["Automatically whisper anyone missing a Healthstone when your Soul Well expire warnings appear"] = "",
	-- ["Automatically whisper anyone missing flasks or elixirs when your Cauldron expire warnings appear"] = "",
	-- ["Automatically whisper anyone missing Well Fed when your Feast expire warnings appear"] = "",
	-- Automation = "",
	-- ["Background colour"] = "",
	-- ["Bar positioning"] = "",
	-- ["Battle.net friends"] = "",
	-- ["Border colour"] = "",
	-- ["Bosses only"] = "",
	-- Bottom = "",
	-- ["Buff button sorting"] = "",
	-- ["Buff Options scale"] = "",
	-- ["Buff those missing buff"] = "",
	-- ["Buff Wizard"] = "",
	-- Cauldron = "",
	-- ["Cauldron auto whisper"] = "",
	-- ["CC-break warnings"] = "",
	-- ["Choose either one big collection of buff checks or traditional style with Warnings, Trash and Boss buff checks"] = "",
	-- ["Choose where on the dashboard the bars appear"] = "",
	-- ["Class-specific buffs"] = "",
	-- Combat = "",
	-- ["Combat options"] = "",
	-- ["Configure how the buff buttons and status bars on the dashboard are sorted and displayed"] = "",
	-- ["Consumable options"] = "",
	-- Consumables = "",
	-- ["Core raid buffs"] = "",
	-- ["Ctrl-left click"] = "",
	-- ["Ctrl-right click"] = "",
	-- ["Danielbarron broke Sheep on The Lich King with Hand of Reckoning"] = "",
	-- ["Darinia ninjaed my target (The Lich King) with Taunt"] = "",
	-- ["Darinia taunted my mob (The Lich King) with Taunt"] = "",
	-- ["Darinia taunted my target (The Lich King) with Taunt"] = "",
	-- ["Dashboard columns"] = "",
	-- ["Dashboard mouse button actions options"] = "",
	-- ["Dashboard scale"] = "",
	-- ["Death warnings"] = "",
	-- ["Default order"] = "",
	-- ["Disable scan in combat"] = "",
	-- ["DPS mana"] = "",
	-- ["Enable/disable buff check"] = "",
	-- ["Enable tank warnings including taunts, failed taunts and mob stealing"] = "",
	-- ["Enable tank warnings including taunts, failed taunts and mob stealing only on bosses"] = "",
	-- ["Enable warning messages when players die"] = "",
	-- ["Enable warnings when Crowd Control is broken by tanks and non-tanks"] = "",
	-- ["Enable warnings when Misdirection or Tricks of the Trade is cast"] = "",
	-- ["Feast auto whisper"] = "",
	-- Feasts = "",
	-- ["Food announce"] = "",
	-- Friends = "",
	-- ["Grouping style"] = "",
	-- ["Guild members"] = "",
	-- ["Healer death"] = "",
	-- ["Healer drinking"] = "",
	-- ["Healer drinking sound"] = "",
	-- ["Healer mana"] = "",
	-- ["Healers alive"] = "",
	-- ["Healer Stormsnow has died!"] = "",
	-- ["Hide and show the buff report dashboard."] = "",
	-- ["Hide Boss R Trash"] = "",
	-- ["Hide dashboard during combat"] = "",
	-- ["Hide in combat"] = "",
	-- ["Hide the buff report dashboard."] = "",
	-- ["Highlight my buffs"] = "",
	-- ["Hightlight currently missing buffs on the dashboard for which you are responsible including self buffs and buffs which you are missing that are provided by someone else. I.e. show buffs for which you must take action"] = "",
	-- ["How MANY?"] = "",
	-- ["Ignore groups 6 to 8"] = "",
	-- ["Ignore groups 6 to 8 when reporting as these are for subs"] = "",
	-- ["[IMMUNE] Danielbarron FAILED TO TAUNT their target (The Lich King) with Hand of Reckoning"] = "",
	-- ["In range"] = "",
	-- invite = "",
	-- ["Just my buffs"] = "",
	-- ["Left click"] = "",
	-- ["Melee DPS Danielbarron has died!"] = "",
	-- ["Melee DPS death"] = "",
	-- ["Minimap icon"] = "",
	-- ["Minimum remaining buff duration in minutes. Buffs with less than this will be considered as missing.  This option only takes affect when the corresponding 'buff' button is enabled on the dashboard."] = "",
	-- ["Min remaining buff duration"] = "",
	-- ["Misdirection warnings"] = "",
	-- ["Mouse buttons"] = "",
	-- ["Move with Alt-click"] = "",
	-- ["My buffs"] = "",
	-- ["Ninja taunts"] = "",
	-- ["No healer close"] = "",
	-- None = "",
	-- ["Non-tank breaks CC"] = "",
	-- ["Non-tank Glamor broke Hex on The Lich King with Moonfire"] = "",
	-- ["NON-TANK Tanagra taunted my target (The Lich King) with Growl"] = "",
	-- ["Non-tank taunts my target"] = "",
	-- ["Number of columns to display on the dashboard"] = "",
	-- ["Old flasks and elixirs"] = "",
	-- ["One big group"] = "",
	-- ["One group down"] = "",
	-- ["Only if all have it"] = "",
	-- ["Only me"] = "",
	-- ["Only show the buffs for which your class is responsible for.  This configuration can be used like a buff-bot where one simply right clicks on the buffs to cast them"] = "",
	-- ["Only show the core class raid buffs"] = "",
	-- ["Only show when you and only you break Crowd Control so you can say 'Now I don't believe you wanted to do that did you, ehee?'"] = "",
	-- ["Only use tank list"] = "",
	-- ["Only use the tank list and ignore spec when there is a tank list for determining if someone is a tank or not"] = "",
	-- ["Options for automatically opening the dashboard and moving it"] = "",
	-- ["Options for setting the quality requirements of consumables"] = "",
	-- ["Options to do with configuring the tank list"] = "",
	-- Other = "",
	-- ["Other taunt fails"] = "",
	-- ["Play a sound"] = "",
	-- ["Play a sound when a healer dies"] = "",
	-- ["Play a sound when a healer drinks and is not full on mana"] = "",
	-- ["Play a sound when a melee DPS dies"] = "",
	-- ["Play a sound when a non-tank breaks Crowd Control"] = "",
	-- ["Play a sound when a ranged DPS dies"] = "",
	-- ["Play a sound when a tank breaks Crowd Control"] = "",
	-- ["Play a sound when a tank dies"] = "",
	-- ["Play a sound when Misdirection or Tricks of the Trade is cast"] = "",
	-- ["Play a sound when one of your taunts fails due to resist"] = "",
	-- ["Play a sound when one of your taunts fails due to the target being immune"] = "",
	-- ["Play a sound when other people's taunts to your target fail"] = "",
	-- ["Play a sound when someone else targets a mob and taunts that mob which is targeting you"] = "",
	-- ["Play a sound when someone else taunts your target"] = "",
	-- ["Play a sound when someone else taunts your target which is targeting you"] = "",
	-- ["Play a sound when someone else who is not a tank taunts your target"] = "",
	-- ["Prepend RBS::"] = "",
	-- ["Prepend RBS:: to all lines of report chat. Disable to only prepend on the first line of a report"] = "",
	-- ["Raid health"] = "",
	-- ["Raid leader"] = "",
	-- ["Raid mana"] = "",
	-- ["Raid Status Bars"] = "",
	-- ["Raid-wide buffs"] = "",
	-- ["Ranged DPS death"] = "",
	-- ["Ranged DPS Garmann has died!"] = "",
	-- ["Refreshment Table"] = "",
	-- ["Repair Bot"] = "",
	-- Reporting = "",
	-- ["Reporting options"] = "",
	-- ["Report missing to raid"] = "",
	-- ["Report to officer channel"] = "",
	-- ["Report to officers"] = "",
	-- ["Report to /raid or /party who is not buffed to the max."] = "",
	-- ["Report to raid/party"] = "",
	-- ["Report to raid/party - requires raid assistant"] = "",
	-- ["Report to self"] = "",
	-- ["Required food quality"] = "",
	-- ["Require the Alt buton to be held down to move the dashboard window"] = "",
	-- ["[RESIST] Danielbarron FAILED TO TAUNT their target (The Lich King) with Hand of Reckoning"] = "",
	-- ["[RESIST] Darinia FAILED TO TAUNT my target (The Lich King) with Taunt"] = "",
	-- ["Right click"] = "",
	-- ["Scale the Buff Options window"] = "",
	-- ["Scale the dashboard window"] = "",
	-- ["Seconds between updates"] = "",
	-- ["Select which action to take when you click with the left mouse button over a dashboard buff check"] = "",
	-- ["Select which action to take when you click with the left mouse button with Alt held down over a dashboard buff check"] = "",
	-- ["Select which action to take when you click with the left mouse button with Ctrl held down over a dashboard buff check"] = "",
	-- ["Select which action to take when you click with the left mouse button with Shift held down over a dashboard buff check"] = "",
	-- ["Select which action to take when you click with the right mouse button over a dashboard buff check"] = "",
	-- ["Select which action to take when you click with the right mouse button with Alt held down over a dashboard buff check"] = "",
	-- ["Select which action to take when you click with the right mouse button with Ctrl held down over a dashboard buff check"] = "",
	-- ["Select which action to take when you click with the right mouse button with Shift held down over a dashboard buff check"] = "",
	-- ["Select which level of food quality you require for the raiders to be considered 'Well Fed'"] = "",
	-- ["Self buffs"] = "",
	-- ["Set how many seconds between dashboard raid scan updates"] = "",
	-- ["Set N - the number of people missing a buff considered to be \"MANY\""] = "",
	-- ["Shift-left click"] = "",
	-- ["Shift-right click"] = "",
	-- ["Shorten names"] = "",
	-- ["Shorten names in the report to reduce channel spam"] = "",
	-- ["Show group number"] = "",
	-- ["Show in battleground"] = "",
	-- ["Show in party"] = "",
	-- ["Show in raid"] = "",
	-- ["Show the buff report dashboard."] = "",
	-- ["Show the group number of the person missing a party/raid buff"] = "",
	-- ["Single target buffs"] = "",
	-- ["Skin and minimap options"] = "",
	-- ["Skin and scaling"] = "",
	-- ["Skip buff checking during combat. You can manually initiate a scan by pressing Scan on the dashboard"] = "",
	-- ["%s minutes"] = "",
	-- ["Sort buff buttons by"] = "",
	-- ["Soul Well"] = "",
	-- ["Status bars to show raid, dps, tank health, mana, etc"] = "",
	-- ["Tank breaks CC"] = "",
	-- ["Tank Danielbarron has died!"] = "",
	-- ["Tank death"] = "",
	-- ["Tank health"] = "",
	-- ["Tank list"] = "",
	-- ["Tanks alive"] = "",
	-- ["Tank warnings"] = "",
	-- ["Tank warnings about taunts, failed taunts and mob stealing including accidental taunts from non-tanks"] = "",
	-- ["Taunts to my mobs"] = "",
	-- ["Taunts to my target"] = "",
	-- ["Tells you when someone in your party, raid or guild has a newer version of RBS installed"] = "",
	-- ["Tells you when someone in your party, raid or guild has RBS installed"] = "",
	-- Test = "",
	-- ["Test what the warning is like"] = "",
	-- ["The average DPS mana percent"] = "",
	-- ["The average healer mana percent"] = "",
	-- ["The average party/raid health percent"] = "",
	-- ["The average party/raid mana percent"] = "",
	-- ["The average tank health percent"] = "",
	-- ["The Buff Wizard automatically configures the dashboard buffs and configuration defaults for your class or raid leading role."] = "",
	-- ["Then sort buff buttons by"] = "",
	-- ["The percentage of healers alive in the raid"] = "",
	-- ["The percentage of people alive in the raid"] = "",
	-- ["The percentage of people dead in the raid"] = "",
	-- ["The percentage of people within 40 yards range"] = "",
	-- ["The percentage of tanks alive in the raid"] = "",
	-- ["This is the default configuration in which RBS ships out-of-the-box.  It gives you pretty much anything a raid leader would need to see on the dashboard"] = "",
	-- ["Toggle to display a minimap icon"] = "",
	-- Top = "",
	-- ["To set this option go to the addon configuration.  This button is automatically enabled when the Boss button is pressed and automatically disabled when the Trash button is pressed.  To permanently disable, choose 0 seconds as the min remaining buff duration."] = "",
	-- ["Two groups down"] = "",
	-- ["User announce"] = "",
	-- ["Version announce"] = "",
	-- ["Wait before announcing to see if others have announced first in order to reduce spam"] = "",
	-- ["Warning messages when players die"] = "",
	-- ["Warnings when Crowd Control is broken by tanks and non-tanks"] = "",
	-- ["Warnings when Misdirection or Tricks of the Trade is cast"] = "",
	-- ["Warnings when someone else targets a mob and taunts that mob which is targeting you"] = "",
	-- ["Warnings when someone else taunts your target"] = "",
	-- ["Warnings when someone else taunts your target who is not a tank"] = "",
	-- ["Warning, Trash, Boss groups"] = "",
	-- ["Warns when a non-tank breaks Crowd Control"] = "",
	-- ["Warns when a tank breaks Crowd Control"] = "",
	-- ["Warns when other people's taunts to your target fail"] = "",
	-- ["Warns when someone else taunts your target which is targeting you"] = "",
	-- ["Warns when your taunts fail due to resist"] = "",
	-- ["Warns when your taunts fail due to the target being immune"] = "",
	-- ["Warn to party"] = "",
	-- ["Warn to party when a healer dies"] = "",
	-- ["Warn to party when a melee DPS dies"] = "",
	-- ["Warn to party when a non-tank breaks Crowd Control"] = "",
	-- ["Warn to party when a ranged DPS dies"] = "",
	-- ["Warn to party when a tank breaks Crowd Control"] = "",
	-- ["Warn to party when a tank dies"] = "",
	-- ["Warn to party when one of your taunts fails due to resist"] = "",
	-- ["Warn to party when one of your taunts fails due to the target being immune"] = "",
	-- ["Warn to party when other people's taunts to your target fail"] = "",
	-- ["Warn to party when someone else targets a mob and taunts that mob which is targeting you"] = "",
	-- ["Warn to party when someone else taunts your target"] = "",
	-- ["Warn to party when someone else taunts your target which is targeting you"] = "",
	-- ["Warn to party when someone else who is not a tank taunts your target"] = "",
	-- ["Warn to raid chat"] = "",
	-- ["Warn to raid chat when a healer dies"] = "",
	-- ["Warn to raid chat when a melee DPS dies"] = "",
	-- ["Warn to raid chat when a non-tank breaks Crowd Control"] = "",
	-- ["Warn to raid chat when a ranged DPS dies"] = "",
	-- ["Warn to raid chat when a tank breaks Crowd Control"] = "",
	-- ["Warn to raid chat when a tank dies"] = "",
	-- ["Warn to raid chat when one of your taunts fails due to resist"] = "",
	-- ["Warn to raid chat when one of your taunts fails due to the target being immune"] = "",
	-- ["Warn to raid chat when other people's taunts to your target fail"] = "",
	-- ["Warn to raid chat when someone else targets a mob and taunts that mob which is targeting you"] = "",
	-- ["Warn to raid chat when someone else taunts your target"] = "",
	-- ["Warn to raid chat when someone else taunts your target which is targeting you"] = "",
	-- ["Warn to raid chat when someone else who is not a tank taunts your target"] = "",
	-- ["Warn to raid warning"] = "",
	-- ["Warn to self"] = "",
	-- ["Warn to self when a healer dies"] = "",
	-- ["Warn to self when a melee DPS dies"] = "",
	-- ["Warn to self when a non-tank breaks Crowd Control"] = "",
	-- ["Warn to self when a ranged DPS dies"] = "",
	-- ["Warn to self when a tank breaks Crowd Control"] = "",
	-- ["Warn to self when a tank dies"] = "",
	-- ["Warn to self when Misdirection or Tricks of the Trade is cast"] = "",
	-- ["Warn to self when one of your taunts fails due to resist"] = "",
	-- ["Warn to self when one of your taunts fails due to the target being immune"] = "",
	-- ["Warn to self when other people's taunts to your target fail"] = "",
	-- ["Warn to self when someone else targets a mob and taunts that mob which is targeting you"] = "",
	-- ["Warn to self when someone else taunts your target"] = "",
	-- ["Warn to self when someone else taunts your target which is targeting you"] = "",
	-- ["Warn to self when someone else who is not a tank taunts your target"] = "",
	-- ["Warn using raid warning when a healer dies"] = "",
	-- ["Warn using raid warning when a melee DPS dies"] = "",
	-- ["Warn using raid warning when a non-tank breaks Crowd Control"] = "",
	-- ["Warn using raid warning when a ranged DPS dies"] = "",
	-- ["Warn using raid warning when a tank breaks Crowd Control"] = "",
	-- ["Warn using raid warning when a tank dies"] = "",
	-- ["Warn using raid warning when one of your taunts fails due to resist"] = "",
	-- ["Warn using raid warning when one of your taunts fails due to the target being immune"] = "",
	-- ["Warn using raid warning when other people's taunts to your target fail"] = "",
	-- ["Warn using raid warning when someone else targets a mob and taunts that mob which is targeting you"] = "",
	-- ["Warn using raid warning when someone else taunts your target"] = "",
	-- ["Warn using raid warning when someone else taunts your target which is targeting you"] = "",
	-- ["Warn using raid warning when someone else who is not a tank taunts your target"] = "",
	-- ["Warn when a healer dies"] = "",
	-- ["Warn when a melee DPS dies"] = "",
	-- ["Warn when a ranged DPS dies"] = "",
	-- ["Warn when a tank dies"] = "",
	-- ["Well auto whisper"] = "",
	-- ["When at least N people are missing a raid buff say MANY instead of spamming a list"] = "",
	-- ["When many say so"] = "",
	-- ["When there are multiple people who can provide a missing buff such as Fortitude then only whisper one of them at random who is in range rather than all of them"] = "",
	-- ["When whispering and at least N people are missing a raid buff say MANY instead of spamming a list"] = "",
	-- ["Whisper buffers"] = "",
	-- ["Whisper many"] = "",
	-- ["Whisper only one"] = "",
	-- ["Your taunt immune-fails"] = "",
	-- ["Your taunt resist-fails"] = "",
}
La.RaidStatusBars = {
	-- ["Dead healers"] = "",
	-- ["Dead tanks"] = "",
	-- ["I see dead people"] = "",
	-- ["n/a"] = "",
	-- P = "",
	-- ["Pull Timer"] = "",
	-- R = "",
	-- ["Ready Check"] = "",
}
La.TalentsWindow = {
	-- Class = "",
	-- Healer = "",
	-- ["Melee DPS"] = "",
	-- Name = "",
	-- ["Ranged DPS"] = "",
	-- Refresh = "",
	-- Role = "",
	-- Spec = "",
	-- Specialisations = "",
	-- ["Talent Specialisations"] = "",
	-- Tank = "",
}
La.TankTauntWarnings = {
	-- ["NON-TANK %s taunted my boss target (%s%s%s) with %s"] = "",
	-- ["NON-TANK %s taunted my target (%s%s%s) with %s"] = "",
	-- ["%s FAILED TO NINJA my boss target (%s%s%s) with %s"] = "",
	-- ["%s FAILED TO NINJA my target (%s%s%s) with %s"] = "",
	-- ["%s FAILED TO TAUNT my boss target (%s%s%s) with %s"] = "",
	-- ["%s FAILED TO TAUNT my target (%s%s%s) with %s"] = "",
	-- ["%s FAILED TO TAUNT their boss target (%s%s%s) with %s"] = "",
	-- ["%s FAILED TO TAUNT their target (%s%s%s) with %s"] = "",
	-- ["%s ninjaed my boss target (%s%s%s) with %s"] = "",
	-- ["%s ninjaed my target (%s%s%s) with %s"] = "",
	-- ["%s taunted my boss mob (%s%s%s) with %s"] = "",
	-- ["%s taunted my boss target (%s%s%s) with %s"] = "",
	-- ["%s taunted my mob (%s%s%s) with %s"] = "",
	-- ["%s taunted my target (%s%s%s) with %s"] = "",
}

elseif locale == "ruRU" then do end
La["Announce even when you don't have assist or lead"] = "Объявлять, даже если нет ассиста или лидера."
La["Announce expiration"] = "Объявлять истечение времени" -- Needs review
La["Announcement options for raid utilities like Feasts"] = "Настройки оповещения для рейдовых инструментов таких как Feasts"
La["Announce to raid warning when a %s is prepared"] = "Объявление в рейд, когда %s подготовлено"
La["Announce to raid warning when a utility is expiring"] = "Объявлять рейду скорое исчезновение установленного предмета" -- Needs review
La["Announce without lead"] = "Объявлять, не являясь лидером."
La["Augment Banquet Tooltips"] = "Подсказка для еды, увеличивающей статы"
La["Augment Banquet Tooltips with stat bonus information"] = "Подсказка для еды, увеличивающей статы с показом информации"
La["Augment Rune"] = "Руна усиления" -- Needs review
La["Blingtron"] = "Блескотрон"
La["Blingtron about to expire!"] = "Блескотрон скоро исчезнет!"
La["Bonus"] = "Бонус"
La["Broken Link"] = "Сломанная ссылка" -- Needs review
La["casts %s"] = "Произносит заклинание %s" -- Needs review
La["Eating"] = "Прием пищи" -- Needs review
La["Expiration announcements"] = "Объявления об истечении времени" -- Needs review
La[" has set us up a Blingtron"] = " поставил Блескотрона! Ёо!"
La["has set us up a %s"] = "поставил(а) нам %s"
La["Mailbox"] = "Почтовый ящик"
La["Noodle Cart"] = "Тележка с супом"
La["Portal"] = "Портал"
La["Prefer Static Buff"] = "Предпочитать бафф с временем действия"
La["Report missing static buffs even when an equivalent passive aura is already present."] = "Показывать бафф с временем действия, даже если присутствует аналогичный аурабафф"
La["Required flask quality"] = "Требуемое качество настоев" -- Needs review
La["Right-click to target"] = "Выбрать в цель правой кнопкой"
La["Select which level of flask quality you require"] = "Выберите уровень качества настоев, который вам требуется" -- Needs review
La["sets up a %s"] = "Устанавливает %s" -- Needs review
La["Show configuration options"] = "Показать настройки"
La["Soulwell"] = "Источник душ"
La["Tooltip name coloring"] = "Цвет имени в подсказке"
La["Tooltip role icons"] = "Значки ролей в подсказке"
La["Treat eating as Well Fed"] = "Считать принимающих пищу Сытыми" -- Needs review
La["Treat players who are currently eating as Well Fed. This assumes they are eating acceptable food."] = "Считать игроков, находящихся в процессе приема пищи Сытыми. Предполагается, что они едят приемлемую еду." -- Needs review
La["Utility announcements"] = "Инструменты оповещения"
La["Warrior Stance"] = "Стойка Воина" -- Needs review
La.BuffOptionsWindow = {
	["Buff Options"] = "Опции баффов",
	["Is a buff"] = "Бафф",
	["Is a warning"] = "Предупреждение",
	["Report on Boss"] = "Отчет на Боссе",
	["Report on Trash"] = "Отчет на Монстрах",
	["Show on dashboard"] = "Показывать на табло",
	["Show/Report in combat"] = "Отчет в бою",
}
La.CrowdControlWarnings = {
	["Melee Swing"] = "Мили удар",
	["Non-tank %s broke %s on %s%s%s"] = "Не-танк %s снимает %s с %s|3-1(%s)%s",
	["Non-tank %s broke %s on %s%s%s with %s"] = "%6$s не-танка |3-1(%1$s) снимает %2$s с %3$s|3-1(%4$s)%5$s",
	["%s broke %s on %s%s%s"] = "%s снимает %s с %s|3-1(%s)%s",
	["%s broke %s on %s%s%s with %s"] = "%6$s |3-1(%1$s) снимает %2$s с %3$s|3-1(%4$s)%5$s",
}
La.Messages = {
	AFK = "AFK",
	Agil = "Лов",
	alpha = "alpha",
	["Alt-Click on a party buff will cast on someone missing that buff."] = "Alt-Клик по групповому баффу, чтобы применить его на игрока, на котором отсутствует этот бафф.",
	["Alt-Click on a self buff will renew that buff."] = "Alt-Клик по self-баффу, чтобы обновить его.",
	["Aspect Cheetah/Pack On"] = "Дух гепарда/стаи",
	["Aspect of the Cheetah or Pack is on"] = "Дух гепарда или Дух стаи",
	["Battle Elixir"] = "Боевой эликсир",
	beta = "beta",
	["Blessing of Kings is not needed because you are grouped with a Druid."] = "Благословение королей не требуется, потому что в в группе есть Друид",
	["Blessing of Kings, with this raid configuration, is better provided by Drums of the Forgotten Kings thus allowing Blessing of Might to be used."] = "Благословение королей, с этой конфигурацией рейда, будет менее приоритетной, чем Благословение Могущества, позволяя видеть Барабаны забытых королей.",
	Boss = "Босс",
	["Buffers: "] = "Бафферы: ",
	["Buffing Kings:"] = "Баффает Кинги:",
	["Buffing Might:"] = "Баффает Могущество:",
	["Cast by:"] = "Применил(а):",
	["Click buffs to disable and enable."] = "Клик по баффу для включения/выключения.",
	["Click to toggle the RBS dashboard"] = "Кликните левой кнопкой для отображения табло RBS",
	["Ctrl-Click Boss or Trash to whisper all those who need to buff."] = "Ctrl+щелчок мышью, чтобы прошептать всем, кто должен баффнуть",
	["Ctrl-Click buffs to whisper those who need to buff."] = "Ctrl-Клик по баффу, чтобы шепнуть игрокам, нуждающихся в баффе.",
	Dead = "Мертв",
	["Death Knight Presence"] = "Власть Рыцаря смерти",
	["Different Zone"] = "Другая локация",
	["Flasked or Elixired but slacking"] = "Игрок использует настой или эликсир из TBC",
	["Flask or two Elixirs"] = "Настой или два эликсира",
	["Guardian Elixir"] = "Охранный эликсир",
	["Has buff: "] = "Имеет бафф: ",
	[" has set us up a Refreshment Table"] = " ставит Стол с Яствами",
	[" has set us up a Repair Bot"] = "  создал ремонтного робота",
	[" has set us up a Soul Well"] = " создает источник душ",
	["Healer %s has died!"] = "Лекарь %s умирает!",
	["Health less than 80%"] = "Здоровье меньше, чем 80%",
	["Hide outgoing whispers"] = "Скрывать исходящие личные сообщения", -- Needs review
	["Hunter Aspect"] = "Духи охотника",
	["Hunter has no aspect at all"] = "У охотника нет духа",
	["[IMMUNE]"] = "[Невосприимчивость]",
	Int = "Инт",
	[" in their bags"] = "в их сумках",
	["Invite auto-accepted from battle.net friend %s."] = "Приглашение автоматически принято от друга по battle.net %s",
	["Invite auto-accepted from friend %s."] = "Приглашение автоматически принято от друга %s",
	["Invite auto-accepted from guild member %s."] = "Приглашение автоматически принято от члена гильдии %s",
	["Item count: "] = "Предметов:",
	["Low durability"] = "Низкая прочность",
	["Low durability (35% or less)"] = "Низкая прочность (35% или ниже)",
	["Mage is missing a Mage Armor"] = "На маге отсутствует Магический доспех",
	["Mana less than 80%"] = "Мана меньше, чем 80%",
	["MANY!"] = "МНОГИЕ!",
	["Melee DPS %s has died!"] = "Боец ближнего боя %s умирает!",
	["Missing "] = "Отсутствует ",
	["Missing a scroll"] = "Отсутствует свиток",
	["Missing buff: "] = "Отстутствует бафф: ",
	["Missing buffs (Boss): "] = "Отсутствующие баффы (Босс): ",
	["Missing buffs (Trash): "] = "Отсутствующие баффы(Треш): ",
	["Missing or not working oRA or RBS: "] = "Не работает/отсутствует аддон oRA или RBS.",
	No = "Нет",
	["No buffs needed! (Boss)"] = "Все бафы на месте! (Босс)",
	["No buffs needed! (Trash)"] = "Все бафы на месте! (Треш)",
	["No Soulstone detected"] = "Камни душ отсутствуют",
	["Not Well Fed"] = "Нет баффа от еды",
	Offline = "Вышел из сети",
	["Out of range"] = "Вне зоны действия",
	["Paladin blessing"] = "Паладинское благословение",
	["Paladin missing Seal"] = "Недостающие печати паладина света",
	["Player has a wrong Paladin blessing"] = "На игрока наложено неверное благословение",
	["Player has health less than 80%"] = "Количетво здоровья игрока меньше, чем 80%",
	["Player has mana less than 80%"] = "Количество маны игрока меньше, чем 80%",
	["Player is AFK"] = "Игрок отсутствует",
	["Player is Dead"] = "Игрок мертв",
	["Player is in a different zone"] = "Игрок находится в другой локации",
	["Player is missing at least one Paladin blessing"] = "На игроке отсутствует по крайней мере одно благословение паладина",
	["Player is Offline"] = "Игрок вышел из сети",
	["Please relog or reload UI to update the item cache."] = "Пожайлуста переавторизуйтесь или перезагрузите UI, чтобы обновить кеш предметов",
	["prepares a %s!"] = "готовит %s",
	["Press Escape -> Interface -> AddOns -> RaidBuffStatus for more options."] = "Нажмите Escape -> Interface -> AddOns -> RaidBuffStatus для просмотра опций.",
	Prot = "Защ",
	["Protection Paladin with no Righteous Fury"] = "Protection-паладин без Праведного неистовства",
	["PVP is On"] = "PVP включено",
	["PVP On"] = "PVP on",
	["Ranged DPS %s has died!"] = "Боец дальнего боя %s умирает!",
	["RBS Dashboard Help"] = "Помощь для табло RBS",
	["RBS Tank List"] = "Список танков RBS",
	["Refreshment Table about to expire!"] = "Стол с яствами скоро пропадет!",
	["Remind me later"] = "Напомнить позже",
	["(Remove buff)"] = "(Удалить бафф)",
	["Remove this button from this dashboard in the buff options window."] = "Удалите с табло эту кнопку в опциях окна.",
	["Repair Bot about to expire!"] = "Ремонтный робот скоро пропадет!",
	["[RESIST]"] = "[Сопротивление]",
	["Right-click to open the addons options menu"] = "Кликните правой кнопкой для открытия меню опций аддона",
	["%s about to expire!"] = "%s - срок истекает!",
	Scan = "Сканирование",
	["%s cast %s on %s"] = "%s применяет %s на |3-3(%s)",
	Scroll = "Свиток",
	Seal = "Печать",
	["Sent %d whispers to %d players"] = "Отправлены личные сообщения игрокам. Количество игроков - %d, сообщений - %d.", -- Needs review
	["%s has a newer (%s) version of RBS (%s) than you (%s)"] = "%s имеет более новую (%s) версию RBS (%s) чем у вас (%s)",
	["Shift-Click buffs to report on only that buff."] = "Shift-Клик по баффу для отчета по данному баффу.",
	["%s is running RBS %s"] = "%s использует RBS %s",
	["Slackers: "] = "Слакеры: ",
	["Slacking Paladins"] = "Слакающие паладины",
	["Sorry, I am queued for"] = "Извини, я стою в очереди в подземелье.",
	["Sorry, I am queued for a battlefield."] = "Извини, я стою в очереди на поле боя.",
	["Sorry, the group is now full."] = "Извините, группа заполнена.",
	["Soul Well about to expire!"] = "Источник душ скоро исчезнет!",
	Spi = "Дух",
	Sta = "Внс",
	Str = "Сила",
	["Tank missing Earth Shield"] = "На танке отсутствует Щит земли",
	["Tank missing Thorns"] = "На танке отсутствуют Корни",
	["Tank %s has died!"] = "Танк %s умирает!",
	["Tank with "] = "Танк с ",
	["The above default button actions can be reconfigured."] = "Указанные выше стандартные действия кнопок могут быть переконфигурированы.",
	["This is the first time RaidBuffStatus has been activated since installation or settings were reset. Would you like to visit the Buff Wizard to help you get RBS buffs configured? If you are a raid leader then you can click No as the defaults are already set up for you."] = "Это первый раз с момента первого запуска или сброса настроек RaidBuffStatus. Хотите посетить Мастер Баффов, чтобы он помог с настройкой баффов в RBS? Если вы рейдлидер, можете щелкнуть на Нет, так как настрйоки по-умолчанию уже установлены.",
	["Tol Barad"] = "Тол Барад",
	Trash = "Треш",
	["Warning: "] = "Предупреждения: ",
	["Warnings: "] = "Предупреждения: ",
	["Weapon buff"] = "Бафф оружия",
	["Well Fed but slacking"] = "Сыт но слакает",
	Wintergrasp = "Озеро Ледяных Оков",
	["Wrong flask for this zone"] = "Неверный настой для этой локации",
	["Wrong Paladin blessing"] = "Неверное благословение",
	["You need to be leader or assistant to do this"] = "Вы должны быть лидером или ассистентом, чтобы сделать это",
	["You need to whisper the leader instead: "] = "Вам нужно обратиться к лидеру рейда.",
}
La.Options = {
	Alive = "Живые",
	["Allow raiders to use flasks and elixirs from last expansion"] = "Позволить рейдерам использовать настои и эликсиры 80-ого уровня из WotLK",
	["Alt-left click"] = "Alt+клик левой кнопкой",
	["Alt-right click"] = "Alt+клик правой кнопкой",
	["Always hide the Boss R Trash buttons"] = "Всегда прятать кнопки Босс Р Треш.",
	["Announce to raid warning when a Feast is prepared"] = "Извещать рейд о приготовлении Рыбного пира.",
	["Anti spam"] = "Анти-спам",
	Appearance = "Внешний вид",
	["Auto-accept invites"] = "Автоматически принимать приглашение в группу",
	["Auto-invite whispers"] = "Авто-приглашение по шепоту",
	["Automatically accept invites from friends and guild members so you can go for a bio-break whilst waiting for a raid invite"] = "Автоматически принимать приглашение в группу от друзей и членов гильдии, так что вы сможете отойти от компа пока ждете приглашение в рейд",
	["Automatically accept invites from these"] = "Автоматически принимать приглашение от:",
	["Automatically configures the dashboard buffs and configuration defaults for your class or raid leading role"] = "Автоматически настраивает табло баффов и настраивает стандарты для вашего класса или роли лидера",
	["Automatically invite friends and guild members who whisper to you the word 'invite'"] = "Автоматическое приглашений друзей и членов гильдии кто шепнет \"инв\"",
	["Automatically invite these"] = "Автоматически приглашать этих",
	["Automatically show the dashboard when you join a battleground"] = "Автоматически показывать табло при попадании на поле боя",
	["Automatically show the dashboard when you join a party"] = "Автоматически показывать табло при вступлении в группу",
	["Automatically show the dashboard when you join a raid"] = "Автоматически показывать табло при вступлении в рейд",
	["Automatically whisper anyone missing a Healthstone when your Soul Well expire warnings appear"] = "Автоматически шептать игрокам, не имеющим камней здоровья, при появлении предупреждения о скором исчезании источника душ",
	["Automatically whisper anyone missing flasks or elixirs when your Cauldron expire warnings appear"] = "Автоматически шептать игрокам без фласок или эликсиров при сообщении об исчезновении Котла Войны",
	["Automatically whisper anyone missing Well Fed when your Feast expire warnings appear"] = "Автоматически шептать всем, кто не поел, о том, что Пир скоро исчезнет",
	Automation = "Автоматизация",
	["Background colour"] = "Цвет фона",
	["Bar positioning"] = "Расположение панели",
	["Battle.net friends"] = "Друзья по Battle.net ",
	["Border colour"] = "Цвет краев",
	["Bosses only"] = "Bosses only",
	Bottom = "Низ",
	["Buff button sorting"] = "Сортировка кнопок баффов",
	["Buff Options scale"] = "Размер опций баффов",
	["Buff those missing buff"] = "Баффнуть",
	["Buff Wizard"] = "Мастер баффов",
	Cauldron = "Котел Войны",
	["Cauldron auto whisper"] = "Авто-шепот о Котле Войны",
	["CC-break warnings"] = "Предупреждения о сбитии контроля",
	["Choose either one big collection of buff checks or traditional style with Warnings, Trash and Boss buff checks"] = "Выберите огромную сборку проверок баффов или классический стиль проверок с Предупреждениями, Трешем и Боссом.",
	["Choose where on the dashboard the bars appear"] = "Выбрать, в каком месте аддона появится панель",
	["Class-specific buffs"] = "Баффы определенного класса",
	Combat = "Бой",
	["Combat options"] = "Опции боя",
	["Configure how the buff buttons and status bars on the dashboard are sorted and displayed"] = "Настройка, как кнопки баффов и панель статуса будет сортироваться и отображаться в аддоне",
	["Consumable options"] = "Опции расходуемых предметов",
	Consumables = "Используемые",
	["Core raid buffs"] = "Основные баффы рейда",
	["Ctrl-left click"] = "Ctrl+клик левой кнопкой",
	["Ctrl-right click"] = "Ctrl+правый клик",
	["Danielbarron broke Sheep on The Lich King with Hand of Reckoning"] = "Даниэльбаррон сбил овцу с Короля Лича своей Дланью возмездия",
	["Darinia ninjaed my target (The Lich King) with Taunt"] = "Арабеск спер мою цель (Король Лич) с Таунтом",
	["Darinia taunted my mob (The Lich King) with Taunt"] = "Арабеск стаунтил моего моба (Король Лич) с Таунтом",
	["Darinia taunted my target (The Lich King) with Taunt"] = "Darinia спровоцировала мою цель (Lich King) Провокацией",
	["Dashboard columns"] = "Колонки табло",
	["Dashboard mouse button actions options"] = "Опции действий кнопок мыши для табло",
	["Dashboard scale"] = "Масштаб панели управления",
	["Death warnings"] = "Сообщения о смертях",
	["Default order"] = "Порядок по-умолчанию",
	["Disable scan in combat"] = "Отключить сканирование в бою",
	["DPS mana"] = "Мана DPS",
	["Enable/disable buff check"] = "Вкл/Откл проверку баффа",
	["Enable tank warnings including taunts, failed taunts and mob stealing"] = "Включить сообщения о провокациях, неудачных провокациях и краже мобов",
	["Enable tank warnings including taunts, failed taunts and mob stealing only on bosses"] = "Включить оповещения танка включая провокации, неудачные провокации и похищение существа, только на боссах",
	["Enable warning messages when players die"] = "Включить оповещение смерти игроков",
	["Enable warnings when Crowd Control is broken by tanks and non-tanks"] = "Включить предупреждения о сбитии контроля танками и не-танками",
	["Enable warnings when Misdirection or Tricks of the Trade is cast"] = "Включить оповещение о применении перенаправления или маленьких хитростей",
	["Feast auto whisper"] = "Шептать о Пире",
	Feasts = "Рыбный пир",
	["Food announce"] = "Извещение о еде",
	Friends = "Друзья",
	["Grouping style"] = "Стиль группировки",
	["Guild members"] = "Члены гильдии",
	["Healer death"] = "Смерть лекаря",
	["Healer drinking"] = "Лекарь пьет",
	["Healer drinking sound"] = "Звук пьющего лекаря.",
	["Healer mana"] = "Мана хилеров",
	["Healers alive"] = "Живые хилеры",
	["Healer Stormsnow has died!"] = "Лекарь Stormsnow умирает!",
	["Hide and show the buff report dashboard."] = "Показать/скрыть табло отчета по баффам",
	["Hide Boss R Trash"] = "Спрятать кнопки: Босс Р Треш",
	["Hide dashboard during combat"] = "Скрыть табло во время боя",
	["Hide in combat"] = "Скрыть в бою",
	["Hide the buff report dashboard."] = "Скрыть табло отчета по баффам.",
	["Highlight my buffs"] = "Подсвечивать мои баффы",
	["Hightlight currently missing buffs on the dashboard for which you are responsible including self buffs and buffs which you are missing that are provided by someone else. I.e. show buffs for which you must take action"] = "Подсвечивать на табло баффы, за которые вы отвечаете, включая self-баффы, т.е. баффы, требующие действия от вас",
	["How MANY?"] = "Насколько МНОГО?",
	["Ignore groups 6 to 8"] = "Игнорировать группы с 6 по 8",
	["Ignore groups 6 to 8 when reporting as these are for subs"] = "Игнорировать группы с 6 по 8 при отчете",
	["[IMMUNE] Danielbarron FAILED TO TAUNT their target (The Lich King) with Hand of Reckoning"] = "Лигрей ПРОВАЛИЛСЯ С ТАУНТОМ его цели (Короля Лича) с Провокацией",
	["In range"] = "В зоне действия",
	invite = "инв",
	["Just my buffs"] = "Только мои баффы",
	["Left click"] = "Клик левой кнопкой",
	["Melee DPS Danielbarron has died!"] = "Боец ближнего боя Danielbarron умирает!",
	["Melee DPS death"] = "Смерть бойца ближнего боя",
	["Minimap icon"] = "Иконка у мини-карты",
	["Minimum remaining buff duration in minutes. Buffs with less than this will be considered as missing.  This option only takes affect when the corresponding 'buff' button is enabled on the dashboard."] = "Минимальная продолжительность баффа в минутах. Баффы с продолжительностью менее установленного значения считаются отсутствующими. Эта настройка имеет силу только в том случае, если соответствующая кнопка этого баффа включена на панели.",
	["Min remaining buff duration"] = "Минимальная продолжительность баффа",
	["Misdirection warnings"] = "Оповещать о перенаправлении",
	["Mouse buttons"] = "Кнопки мыши",
	["Move with Alt-click"] = "Перемещение Alt-кликом",
	["My buffs"] = "Мои баффы",
	["Ninja taunts"] = "Ninja taunts",
	["No healer close"] = "Поблизости нет лекарей.",
	None = "Не назначено",
	["Non-tank breaks CC"] = "Не-танк сбивает контроль",
	["Non-tank Glamor broke Hex on The Lich King with Moonfire"] = "Не-танк Гламур сбил Сглаз с Короля Лича своим Лунным огнём",
	["NON-TANK Tanagra taunted my target (The Lich King) with Growl"] = "Не-танк Торыч стаунтил мою цель (Хагара) с Длань возмездия",
	["Non-tank taunts my target"] = "Провокации моей цели не-танками",
	["Number of columns to display on the dashboard"] = "Количество колонок, отображаемых на табло",
	["Old flasks and elixirs"] = "Настои и эликсиры из предыдущих патчей.",
	["One big group"] = "Одна большая группа",
	["One group down"] = "Одной группой ниже",
	["Only if all have it"] = "Только если это есть у всех",
	["Only me"] = "Только я",
	["Only show the buffs for which your class is responsible for.  This configuration can be used like a buff-bot where one simply right clicks on the buffs to cast them"] = "Показать только те баффы, которые относятся к вашему классу. В таком виде можно использовать как аддон для баффов - достаточно кликнуть правой кнопкой на нужном, чтобы бафнуть рейд.",
	["Only show the core class raid buffs"] = "Показать только основные баффы классов",
	["Only show when you and only you break Crowd Control so you can say 'Now I don't believe you wanted to do that did you, ehee?'"] = "Показывать, только если Вы и Только Вы сбили Контроль, зато Вы сможете сказать: \"Я твоя контроль мобы сбивал!\"",
	["Only use tank list"] = "Использовать только список танков",
	["Only use the tank list and ignore spec when there is a tank list for determining if someone is a tank or not"] = "Для определения танка использовать только список танков и игнорировать спек, когда список танков настроен.",
	["Options for automatically opening the dashboard and moving it"] = "Настройки автоматического открытия окна аддона и его перемещения.",
	["Options for setting the quality requirements of consumables"] = "Опции для установки требуемого качества расходуемых предметов",
	["Options to do with configuring the tank list"] = "Настройки конфигурации списка танков.",
	Other = "Другие",
	["Other taunt fails"] = "Неудачные провокации другими людьми",
	["Play a sound"] = "Проиграть звук",
	["Play a sound when a healer dies"] = "Проигрывать звук при смерти лекаря",
	["Play a sound when a healer drinks and is not full on mana"] = "Проигрывать звук, когда лекарь пьет и у него неполная мана.",
	["Play a sound when a melee DPS dies"] = "Проигрывать звук при смерти бойца ближнего боя",
	["Play a sound when a non-tank breaks Crowd Control"] = "Проигрывать звуковой сигнал, когда не-танк сбивает контроль",
	["Play a sound when a ranged DPS dies"] = "Проигрывать звук при смерти бойца дальнего боя",
	["Play a sound when a tank breaks Crowd Control"] = "Проигрывать звуковой сигнал, когда танк сбивает контроль",
	["Play a sound when a tank dies"] = "Проигрывать звук при смерти танка",
	["Play a sound when Misdirection or Tricks of the Trade is cast"] = "Проиграть звук когда применяется перенаправление или маленькие хитрости",
	["Play a sound when one of your taunts fails due to resist"] = "Предупредить звуком, если ваш таунт промазал из-за резиста",
	["Play a sound when one of your taunts fails due to the target being immune"] = "Проигрывать звук при неудаче ваших провокаций",
	["Play a sound when other people's taunts to your target fail"] = "Проигрывать звук при неудачных провокациях вашей цели другими людьми",
	["Play a sound when someone else targets a mob and taunts that mob which is targeting you"] = "Проигрывать звук при провокации другими игроками моба, целью которого являетесь вы",
	["Play a sound when someone else taunts your target"] = "Проигрывать звук при провокации вашей цели кем-либо",
	["Play a sound when someone else taunts your target which is targeting you"] = "Прогирывать звук при провокации другими игроками вашей цели, целью которой являетесь вы",
	["Play a sound when someone else who is not a tank taunts your target"] = "Проигрывать звук при провокации вашей цели кем-либо, не являющимся танком",
	["Prepend RBS::"] = "Prepend RBS:",
	["Prepend RBS:: to all lines of report chat. Disable to only prepend on the first line of a report"] = "Prepend RBS: to all lines of report chat. Disable to only prepend on the first line of a report",
	["Raid health"] = "Здоровье рейда",
	["Raid leader"] = "Лидер рейда",
	["Raid mana"] = "Мана рейда",
	["Raid Status Bars"] = "Полосы статуса рейда",
	["Raid-wide buffs"] = "Баффы на весь рейд",
	["Ranged DPS death"] = "Смерть бойца дальнего боя",
	["Ranged DPS Garmann has died!"] = "РДД Гарманн умер!",
	["Refreshment Table"] = "Стол с яствами",
	["Repair Bot"] = "Ремонтный робот",
	Reporting = "Сообщения",
	["Reporting options"] = "Опции сообщений",
	["Report missing to raid"] = "Сообщить рейду об отсутствии",
	["Report to officer channel"] = "Отчет в канал офицеров",
	["Report to officers"] = "Отчет офицерам",
	["Report to /raid or /party who is not buffed to the max."] = "Сообщить в чат рейда или группы, на ком отсутствуют нужные баффы.",
	["Report to raid/party"] = "Отчет для рейда/группы",
	["Report to raid/party - requires raid assistant"] = "Отчет для рейда/группы - требуются права ассистента",
	["Report to self"] = "Отчет для себя",
	["Required food quality"] = "Качество еды для рейдеров",
	["Require the Alt buton to be held down to move the dashboard window"] = "Требовать зажатие Alt для перемещения табло",
	["[RESIST] Danielbarron FAILED TO TAUNT their target (The Lich King) with Hand of Reckoning"] = "Danielbarron ПРОМАЗАЛ ТАУНТОМ по его цели (Король Лич) используя Длань возмездия",
	["[RESIST] Darinia FAILED TO TAUNT my target (The Lich King) with Taunt"] = "Darinia FAILED TO TAUNT my target (Lich King) with Taunt",
	["Right click"] = "Клик правой кнопкой",
	["Scale the Buff Options window"] = "Размер окошка опций баффов",
	["Scale the dashboard window"] = "Масштаб окна панели управления",
	["Seconds between updates"] = "Секунд между обновлениями",
	["Select which action to take when you click with the left mouse button over a dashboard buff check"] = "Выберите действие при клике левой кнопкой мыши по табло",
	["Select which action to take when you click with the left mouse button with Alt held down over a dashboard buff check"] = "Выберите действие при клике левой кнопкой мыши с зажатой клавишей Alt по табло",
	["Select which action to take when you click with the left mouse button with Ctrl held down over a dashboard buff check"] = "Выберите действие при клике левой кнопкой мыши с зажатой клавишей Ctrl по табло",
	["Select which action to take when you click with the left mouse button with Shift held down over a dashboard buff check"] = "Выберите действие при клике левой кнопкой мыши с зажатой клавишей Shift по табло",
	["Select which action to take when you click with the right mouse button over a dashboard buff check"] = "Выберите действие при клике правой кнопкой мыши по табло",
	["Select which action to take when you click with the right mouse button with Alt held down over a dashboard buff check"] = "Выберите действие при клике правой кнопкой мыши с зажатой клавишей Alt по табло",
	["Select which action to take when you click with the right mouse button with Ctrl held down over a dashboard buff check"] = "Выберите действие при клике правой кнопкой мыши с зажатой клавишей Ctrl по табло",
	["Select which action to take when you click with the right mouse button with Shift held down over a dashboard buff check"] = "Выберите действие при клике правой кнопкой мыши с зажатой клавишей Shift по табло",
	["Select which level of food quality you require for the raiders to be considered 'Well Fed'"] = "Выберите уровень качества еды для рейдеров",
	["Self buffs"] = "Собственные баффы",
	["Set how many seconds between dashboard raid scan updates"] = "Назначить количество секунд между сканированиями рейда",
	["Set N - the number of people missing a buff considered to be \"MANY\""] = "Назначить N - количество игроков с отсутствующим баффом, расценивающееся, как \"МНОГО\".",
	["Shift-left click"] = "Shift+клик левой кнопкой",
	["Shift-right click"] = "Shift+клик правой кнопкой",
	["Shorten names"] = "Сокращать имена",
	["Shorten names in the report to reduce channel spam"] = "Сокращать имена в отчетах, чтобы уменьшить спам в каналах",
	["Show group number"] = "Показывать номер группы",
	["Show in battleground"] = "Показывать на поле боя",
	["Show in party"] = "Показывать в группе",
	["Show in raid"] = "Показывать в рейде",
	["Show the buff report dashboard."] = "Показать табло отчета по баффам.",
	["Show the group number of the person missing a party/raid buff"] = "Показывать номер группы игрока, на котором отсутствует групповой/рейдовый бафф",
	["Single target buffs"] = "Баффы на одну цель",
	["Skin and minimap options"] = "Шкурки и опции мини-карты",
	["Skin and scaling"] = "Шкурка и размеры",
	["Skip buff checking during combat. You can manually initiate a scan by pressing Scan on the dashboard"] = "Пропустить проверку баффов в бою. Вы можете назначить проверку вручную, нажав Скан на панели.",
	["%s minutes"] = "%s минут",
	["Sort buff buttons by"] = "Сортировать кнопки баффов по",
	["Soul Well"] = "Источник душ",
	["Status bars to show raid, dps, tank health, mana, etc"] = "Полосы статуса для отображения здоровья/маны рейда/танков/хилеров/DPS",
	["Tank breaks CC"] = "Танк сбивает контроль",
	["Tank Danielbarron has died!"] = "Танк Danielbarron умирает!",
	["Tank death"] = "Смерть танка",
	["Tank health"] = "Здоровье танков",
	["Tank list"] = "Список танков",
	["Tanks alive"] = "Живые танки",
	["Tank warnings"] = "Сообщения для танков",
	["Tank warnings about taunts, failed taunts and mob stealing including accidental taunts from non-tanks"] = "Сообщения о провокациях, неудачных провокациях и краже мобов",
	["Taunts to my mobs"] = "Провокации моих мобов",
	["Taunts to my target"] = "Провокации моей цели",
	["Tells you when someone in your party, raid or guild has a newer version of RBS installed"] = "Сообщить вам если кто-нибудь из группы, рейда, или гильдии имеет более новую версию RBS",
	["Tells you when someone in your party, raid or guild has RBS installed"] = "Сказать, если кто-то в группе, рейде или гильдии имеет установленный RBS.",
	Test = "Тест",
	["Test what the warning is like"] = "Тестирование объявления",
	["The average DPS mana percent"] = "Средний процент маны DPS",
	["The average healer mana percent"] = "Средний процент маны хилеров",
	["The average party/raid health percent"] = "Средний процент здоровья участников группы/рейда",
	["The average party/raid mana percent"] = "Средний процент маны участников группы/рейда",
	["The average tank health percent"] = "Средний процент здоровья танков",
	["The Buff Wizard automatically configures the dashboard buffs and configuration defaults for your class or raid leading role."] = "Мастер баффов автоматически настраивает табло баффов и подгоняет стандарты для вашего класса или роли лидера.",
	["Then sort buff buttons by"] = "Тогда сортировать кнопки баффов по",
	["The percentage of healers alive in the raid"] = "Процент живых хилеров в рейде",
	["The percentage of people alive in the raid"] = "Процент живых участников рейда",
	["The percentage of people dead in the raid"] = "Процент людей, погибших в рейде",
	["The percentage of people within 40 yards range"] = "Процент людей, в радиусе 40 метров",
	["The percentage of tanks alive in the raid"] = "Процент живых танков в рейде",
	["This is the default configuration in which RBS ships out-of-the-box.  It gives you pretty much anything a raid leader would need to see on the dashboard"] = "Это конфигурация по умолчанию, которую RBS предоставляет \"из коробки\". Она предоставляет Вам практически все, что лидер рейда должен видеть на панели управления",
	["Toggle to display a minimap icon"] = "Показать/скрыть иконку у мини-карты",
	Top = "Верх",
	["To set this option go to the addon configuration.  This button is automatically enabled when the Boss button is pressed and automatically disabled when the Trash button is pressed.  To permanently disable, choose 0 seconds as the min remaining buff duration."] = "Чтобы изменить эту опцию, перейдите к настройкам аддона. Эта кнопка будет автоматически включена, когда нажата кнопка БОСС и автоматически выключена при нажатой кнопке ТРЕШ. Чтобы выключить навсегда, выберите 0 секунд как минимальное оставшееся время баффа.",
	["Two groups down"] = "Двумя группами ниже",
	["User announce"] = "Анонс игрокам",
	["Version announce"] = "Сообщать о версии",
	["Wait before announcing to see if others have announced first in order to reduce spam"] = "Подождать прежде чем сообщать, чтобы посмотреть не сообщит ли кто-нибудь ещё (для уменьшения спама)",
	["Warning messages when players die"] = "Оповещение смерти игроков",
	["Warnings when Crowd Control is broken by tanks and non-tanks"] = "Сообщения о снятии контроля танками и не-танками",
	["Warnings when Misdirection or Tricks of the Trade is cast"] = "Оповещать о применении перенаправления или маленьких хитростей",
	["Warnings when someone else targets a mob and taunts that mob which is targeting you"] = "Сообщение о провокации другими игроками моба, целью которого являетесь вы",
	["Warnings when someone else taunts your target"] = "Сообщение о провокации вашей цели кем-либо",
	["Warnings when someone else taunts your target who is not a tank"] = "Сообщение о провокации вашей цели кем-либо, не являющимся танком",
	["Warning, Trash, Boss groups"] = "Группы Предупреждение, Треш, Босс",
	["Warns when a non-tank breaks Crowd Control"] = "Предупреждать когда не-танк сбивает контроль",
	["Warns when a tank breaks Crowd Control"] = "Предупреждать когда танк сбивает контроль",
	["Warns when other people's taunts to your target fail"] = "Сообщение о неудачных провокациях вашей цели другими людьми",
	["Warns when someone else taunts your target which is targeting you"] = "Сообщение о провокации другими игроками вашей цели, целью которой являетесь вы",
	["Warns when your taunts fail due to resist"] = "Предупредить, если ваш таунт промазал из-за резиста",
	["Warns when your taunts fail due to the target being immune"] = "Сообщение о неудаче ваших провокаций",
	["Warn to party"] = "Сообщать группе",
	["Warn to party when a healer dies"] = "Сообщать группе, когда умирает целитель",
	["Warn to party when a melee DPS dies"] = "Сообщать группе, когда умирает мили DPS",
	["Warn to party when a non-tank breaks Crowd Control"] = "Сообщать группе о снятии контроля не-танком",
	["Warn to party when a ranged DPS dies"] = "Оповестить в группу о смерти бойца дальнего боя",
	["Warn to party when a tank breaks Crowd Control"] = "Сообщать группе о снятии контроля танком",
	["Warn to party when a tank dies"] = "Сообщать группе, когда умирает танк",
	["Warn to party when one of your taunts fails due to resist"] = "Предупреждать группу, если ваш таунт промазал",
	["Warn to party when one of your taunts fails due to the target being immune"] = "Сообщать группе о неудаче ваших провокаций",
	["Warn to party when other people's taunts to your target fail"] = "Сообщать группе о неудачных провокациях вашей цели другими людьми",
	["Warn to party when someone else targets a mob and taunts that mob which is targeting you"] = "Сообщать группе о провокации другими игроками моба, целью которого являетесь вы",
	["Warn to party when someone else taunts your target"] = "Сообщать группе о провокации вашей цели кем-либо",
	["Warn to party when someone else taunts your target which is targeting you"] = "Сообщать группе о провокации другими игроками вашей цели, целью которой являетесь вы",
	["Warn to party when someone else who is not a tank taunts your target"] = "Сообщать группе о провокации вашей цели кем-либо, не являющимся танком",
	["Warn to raid chat"] = "Сообщать в чат рейда",
	["Warn to raid chat when a healer dies"] = "Сообщать рейду, когда умирает целитель",
	["Warn to raid chat when a melee DPS dies"] = "Сообщать рейду, когда умирает боец ближнего боя.",
	["Warn to raid chat when a non-tank breaks Crowd Control"] = "Сообщать в канал рейда о снятии контроля не-танком.",
	["Warn to raid chat when a ranged DPS dies"] = "Оповестить в рейд о смерти бойца дальнего боя",
	["Warn to raid chat when a tank breaks Crowd Control"] = "Сообщать рейду о снятии контроля танком",
	["Warn to raid chat when a tank dies"] = "Сообщать рейду, когда умирает танк",
	["Warn to raid chat when one of your taunts fails due to resist"] = "Предупреждать в рейд-чат, если ваш таунт промазал из-за резиста",
	["Warn to raid chat when one of your taunts fails due to the target being immune"] = "Сообщать в чат рейда о неудачах ваших провокаций",
	["Warn to raid chat when other people's taunts to your target fail"] = "Сообщать рейду о неудачах провокации вашей цели другими людьми",
	["Warn to raid chat when someone else targets a mob and taunts that mob which is targeting you"] = "Сообщать рейду о провокации другими игроками моба, целью которого являетесь вы",
	["Warn to raid chat when someone else taunts your target"] = "Сообщать рейду о провокации вашей цели кем-либо",
	["Warn to raid chat when someone else taunts your target which is targeting you"] = "Сообщать рейду о провокации вашей цели, целью которой являетесь вы, другими людьми",
	["Warn to raid chat when someone else who is not a tank taunts your target"] = "Сообщать рейду о провокации вашей цели кем-либо, не являющимся танком",
	["Warn to raid warning"] = "Объявлять рейду",
	["Warn to self"] = "Сообщение для себя",
	["Warn to self when a healer dies"] = "Предупреждать себя, когда умирает целитель",
	["Warn to self when a melee DPS dies"] = "Предупреждения для себя о смерти бойца ближнего боя",
	["Warn to self when a non-tank breaks Crowd Control"] = "Информировать себя когда не-танк сбивает контроль",
	["Warn to self when a ranged DPS dies"] = "Оповестить себя о смерти бойца дальнего боя",
	["Warn to self when a tank breaks Crowd Control"] = "Информировать себя когда танк сбивает контроль",
	["Warn to self when a tank dies"] = "Информировать себя, когда умирает танк",
	["Warn to self when Misdirection or Tricks of the Trade is cast"] = "Сообщить себе когда применяется перенаправление или маленькие хитрости",
	["Warn to self when one of your taunts fails due to resist"] = "Предупредить себя, если ваш таунт промазал из-за резиста",
	["Warn to self when one of your taunts fails due to the target being immune"] = "Сообщение для себя о неудаче ваших провокаций",
	["Warn to self when other people's taunts to your target fail"] = "Сообщение для себя о неудачных провокациях вашей цели другими людьми",
	["Warn to self when someone else targets a mob and taunts that mob which is targeting you"] = "Сообщать для себя о провокации другими игроками моба, целью которого являетесь вы",
	["Warn to self when someone else taunts your target"] = "Сообщение для себя о провокации вашей цели кем-либо",
	["Warn to self when someone else taunts your target which is targeting you"] = "Сообщение для себя провокации другими игроками вашей цели, целью которой являетесь вы",
	["Warn to self when someone else who is not a tank taunts your target"] = "Сообщение для себя о провокации вашей цели кем-либо, не являющимся танком",
	["Warn using raid warning when a healer dies"] = "Объявлять рейду, когда умирает целитель",
	["Warn using raid warning when a melee DPS dies"] = "Объявлять рейду, когда умирает боец ближнего боя",
	["Warn using raid warning when a non-tank breaks Crowd Control"] = "Объявлять рейду о снятии контроля не-танком",
	["Warn using raid warning when a ranged DPS dies"] = "Объявлять рейду, когда умирает боец дальнего боя",
	["Warn using raid warning when a tank breaks Crowd Control"] = "Объявлять рейду о снятии контроля танком",
	["Warn using raid warning when a tank dies"] = "Объявлять рейду, когда умирает танк ",
	["Warn using raid warning when one of your taunts fails due to resist"] = "Объявлять рейду о неудаче ваших провокаций из-за сопротивление",
	["Warn using raid warning when one of your taunts fails due to the target being immune"] = "Объявлять рейду о неудаче ваших провокаций в результате невосприимчивости цели к ней",
	["Warn using raid warning when other people's taunts to your target fail"] = "Объявлять рейду о неудачных провокациях вашей цели другими людьми",
	["Warn using raid warning when someone else targets a mob and taunts that mob which is targeting you"] = "Объявлять рейду о провокации другими игроками моба, целью которого являетесь вы",
	["Warn using raid warning when someone else taunts your target"] = "Объявлять рейду о провокации вашей цели кем-либо",
	["Warn using raid warning when someone else taunts your target which is targeting you"] = "Объявлять рейду о провокации другими игроками вашей цели, целью которой являетесь вы",
	["Warn using raid warning when someone else who is not a tank taunts your target"] = "Объявлять рейду о провокации вашей цели кем-либо, не являющимся танком",
	["Warn when a healer dies"] = "Оповестить о смерти лекаря",
	["Warn when a melee DPS dies"] = "Оповестить о смерти бойца ближнего боя",
	["Warn when a ranged DPS dies"] = "Оповестить о смерти бойца дальнего боя",
	["Warn when a tank dies"] = "Оповестить о смерти танка",
	["Well auto whisper"] = "Авто-шепот про источник душ",
	["When at least N people are missing a raid buff say MANY instead of spamming a list"] = "Если по крайней мере на N игроках отсутствует рейдовый бафф, отображать МНОГО вместо перечисления всего списка",
	["When many say so"] = "Отображать \"много\"",
	["When there are multiple people who can provide a missing buff such as Fortitude then only whisper one of them at random who is in range rather than all of them"] = "Когда отсутствующий бафф могут баффнуть несколько людей, шептать случайному в радиусе баффа, а не всем",
	["When whispering and at least N people are missing a raid buff say MANY instead of spamming a list"] = "Если по крайней мере на N игроках отсутствует бафф, шептать МНОГО вместо перечисления всего списка",
	["Whisper buffers"] = "Шепнуть бафферам",
	["Whisper many"] = "Шептать \"много\"",
	["Whisper only one"] = "Шептать только одному",
	["Your taunt immune-fails"] = "Неудачи ваших провокаций",
	["Your taunt resist-fails"] = "Ваш таунт попал в невосприимчивость.",
}
La.RaidStatusBars = {
	["Dead healers"] = "Мертвые лекари",
	["Dead tanks"] = "Мертвые танки",
	["I see dead people"] = "Я вижу мёртвого игрока",
	["n/a"] = "n/a",
	P = "П", -- Needs review
	["Pull Timer"] = "Таймер пулла", -- Needs review
	R = "Г", -- Needs review
	["Ready Check"] = "Проверка готовности", -- Needs review
}
La.TalentsWindow = {
	Class = "Класс",
	Healer = "Хилер",
	["Melee DPS"] = "Мили DPS",
	Name = "Имя",
	["Ranged DPS"] = "Рендж DPS",
	Refresh = "Обновить",
	Role = "Роль",
	Spec = "Спек",
	Specialisations = "Специализации",
	["Talent Specialisations"] = "Специализация в талантах",
	Tank = "Танк",
}
La.TankTauntWarnings = {
	["NON-TANK %s taunted my boss target (%s%s%s) with %s"] = "НЕ-ТАНК %s стаунтил моего босса (%s%s%s) заклинанием %s",
	["NON-TANK %s taunted my target (%s%s%s) with %s"] = "НЕ-ТАНК %s стаунтил мою цель (%s%s%s) заклинанием %s",
	["%s FAILED TO NINJA my boss target (%s%s%s) with %s"] = "%s ПРОВАЛИЛСЯ С ТАУНТОМ босса (%s%s%s) с %s",
	["%s FAILED TO NINJA my target (%s%s%s) with %s"] = "%s НЕУДАЧНО попытался спереть мою цель (%s%s%s) используя %s",
	["%s FAILED TO TAUNT my boss target (%s%s%s) with %s"] = "%s НЕУДАЧНО СТАУНТИЛ мою цель - БОССА (%s%s%s) используя %s",
	["%s FAILED TO TAUNT my target (%s%s%s) with %s"] = "%s НЕУДАЧНО СТАУНТИЛ мою цель (%s%s%s) используя %s",
	["%s FAILED TO TAUNT their boss target (%s%s%s) with %s"] = "%s ПРОВАЛИЛСЯ С ТАУНТОМ их цели босса (%s%s%s) с %s",
	["%s FAILED TO TAUNT their target (%s%s%s) with %s"] = "%s ПРОВАЛИЛСЯ С ТАУНТОМ их цели (%s%s%s) с %s",
	["%s ninjaed my boss target (%s%s%s) with %s"] = "%s утащил босса (%s%s%s) с %s",
	["%s ninjaed my target (%s%s%s) with %s"] = "%s заагрил мою цель (%s%s%s) заклинанием %s",
	["%s taunted my boss mob (%s%s%s) with %s"] = "%s затаунтил моба босса (%s%s%s) с %s",
	["%s taunted my boss target (%s%s%s) with %s"] = "%s стаунтил мою цель (%s%s%s) заклинанием %s",
	["%s taunted my mob (%s%s%s) with %s"] = "%s стаунтил моего моба (%s%s%s) заклинанием %s",
	["%s taunted my target (%s%s%s) with %s"] = "%s стаунтил мою цель (%s%s%s) заклинанием %s",
}

elseif locale == "zhCN" then do end
La["Announce even when you don't have assist or lead"] = "当不是团队领袖或助理时通告"
La["Announce expiration"] = "通知到期" -- Needs review
La["Announcement options for raid utilities like Feasts"] = "团队效果通告选项，如：大餐"
La["Announce to raid warning when a %s is prepared"] = "当%s准备好时发出团队通告"
-- La["Announce to raid warning when a utility is expiring"] = ""
La["Announce without lead"] = "当不是团队领袖时通告"
La["Augment Banquet Tooltips"] = "大餐提示"
La["Augment Banquet Tooltips with stat bonus information"] = "大餐提示和属性加成信息。"
-- La["Augment Rune"] = ""
La["Blingtron"] = "布林顿"
La["Blingtron about to expire!"] = "布林顿要过期了！"
La["Bonus"] = "加成"
-- La["Broken Link"] = ""
-- La["casts %s"] = ""
La["Eating"] = "进食" -- Needs review
-- La["Expiration announcements"] = ""
La[" has set us up a Blingtron"] = "安放了布林顿"
La["has set us up a %s"] = "安放了一个%s"
La["Mailbox"] = "邮箱"
La["Noodle Cart"] = "汤面餐车"
La["Portal"] = "传送门"
La["Prefer Static Buff"] = "选择静止增益"
La["Report missing static buffs even when an equivalent passive aura is already present."] = "当被动光环已经存在时报告缺失静止增益来最大化饰品触发。"
-- La["Required flask quality"] = ""
La["Right-click to target"] = "右击目标"
-- La["Select which level of flask quality you require"] = ""
-- La["sets up a %s"] = ""
La["Show configuration options"] = "显示配置选项"
La["Soulwell"] = "灵魂井"
La["Tooltip name coloring"] = "提示姓名颜色"
La["Tooltip role icons"] = "提示职责图标"
-- La["Treat eating as Well Fed"] = ""
-- La["Treat players who are currently eating as Well Fed. This assumes they are eating acceptable food."] = ""
La["Utility announcements"] = "效果通告"
-- La["Warrior Stance"] = ""
La.BuffOptionsWindow = {
	["Buff Options"] = "增益选项",
	["Is a buff"] = "增益",
	["Is a warning"] = "警报",
	["Report on Boss"] = "在首领战报告",
	["Report on Trash"] = "在小怪战报告",
	["Show on dashboard"] = "在仪表板上显示",
	["Show/Report in combat"] = "在战斗中显示/报告",
}
La.CrowdControlWarnings = {
	["Melee Swing"] = "近战出错",
	["Non-tank %s broke %s on %s%s%s"] = "[非坦克]%s打破了%s位于%s%s%s！",
	["Non-tank %s broke %s on %s%s%s with %s"] = "[非坦克]%s打破了%s位于%s%s%s！技能：%s",
	["%s broke %s on %s%s%s"] = "%s打破了%s位于%s%s%s！",
	["%s broke %s on %s%s%s with %s"] = "%s打破了%s位于%s%s%s！技能：%s",
}
La.Messages = {
	AFK = "暂离",
	Agil = "敏",
	alpha = "Alpha",
	["Alt-Click on a party buff will cast on someone missing that buff."] = "Alt+点击小队增益将对缺少增益者施法。",
	["Alt-Click on a self buff will renew that buff."] = "Alt+点击自身增益刷新该增益。",
	["Aspect Cheetah/Pack On"] = "猎豹/豹群守护开启",
	["Aspect of the Cheetah or Pack is on"] = "猎豹/豹群守护开启中",
	["Battle Elixir"] = "战斗药剂",
	beta = "Beta",
	["Blessing of Kings is not needed because you are grouped with a Druid."] = "王者祝福已不需要因为队伍里有德鲁伊。",
	["Blessing of Kings, with this raid configuration, is better provided by Drums of the Forgotten Kings thus allowing Blessing of Might to be used."] = "王者祝福，在这个团队配置下，部分人已有遗忘王者战鼓因此允许使用其他的祝福。",
	Boss = "首领",
	["Buffers: "] = "增益施法者：",
	["Buffing Kings:"] = "增益王者：",
	["Buffing Might:"] = "增益大师：",
	["Cast by:"] = "施放者：",
	["Click buffs to disable and enable."] = "点击禁用或启用增益。",
	["Click to toggle the RBS dashboard"] = "点击切换 RBS 仪表板",
	["Ctrl-Click Boss or Trash to whisper all those who need to buff."] = "Ctrl+点击首领或小怪来密语全部所需的增益。",
	["Ctrl-Click buffs to whisper those who need to buff."] = "Ctrl+点击密语所需的增益。",
	Dead = "死亡",
	["Death Knight Presence"] = "死亡骑士灵气",
	["Different Zone"] = "不同区域",
	["Flasked or Elixired but slacking"] = "偷懒的药剂或合剂",
	["Flask or two Elixirs"] = "合剂或两种药剂",
	["Guardian Elixir"] = "守护药剂",
	["Has buff: "] = "拥有增益：",
	[" has set us up a Refreshment Table"] = "召唤餐桌",
	[" has set us up a Repair Bot"] = "已放置了一个修理机器人",
	[" has set us up a Soul Well"] = "放了一个灵魂之井",
	["Healer %s has died!"] = "治疗 %s 已死亡！",
	["Health less than 80%"] = "生命值少于80%",
	-- ["Hide outgoing whispers"] = "",
	["Hunter Aspect"] = "猎人守护",
	["Hunter has no aspect at all"] = "猎人根本没有光环",
	["[IMMUNE]"] = "[免疫]",
	Int = "智",
	[" in their bags"] = "位于背包",
	["Invite auto-accepted from battle.net friend %s."] = "自动接受战网好友%s邀请。",
	["Invite auto-accepted from friend %s."] = "自动接受好友%s邀请。",
	["Invite auto-accepted from guild member %s."] = "自动接受公会成员%s邀请。",
	["Item count: "] = "物品数量：",
	["Low durability"] = "低耐久度",
	["Low durability (35% or less)"] = "低耐久度（35%或更低）",
	["Mage is missing a Mage Armor"] = "法师没有法师护甲",
	["Mana less than 80%"] = "法力少于80%",
	["MANY!"] = "很多！",
	["Melee DPS %s has died!"] = "近战 DPS %s 已死亡！",
	["Missing "] = "缺失",
	["Missing a scroll"] = "缺少一个卷轴",
	["Missing buff: "] = "缺少增益：",
	["Missing buffs (Boss): "] = "缺少增益（首领）： ",
	["Missing buffs (Trash): "] = "缺少增益（小怪）：",
	["Missing or not working oRA or RBS: "] = "缺失或不工作的 oRA2 或 RBS：",
	No = "否",
	["No buffs needed! (Boss)"] = "没有需要的增益！（首领）",
	["No buffs needed! (Trash)"] = "没有需要的增益！（小怪）",
	["No Soulstone detected"] = "侦测不到灵魂石",
	["Not Well Fed"] = "没有充分进食",
	Offline = "离线",
	["Out of range"] = "超出距离",
	["Paladin blessing"] = "圣骑士祝福",
	["Paladin missing Seal"] = "神骑士缺少圣印",
	["Player has a wrong Paladin blessing"] = "玩家有错误的圣骑士祝福",
	["Player has health less than 80%"] = "玩家生命值少于80%",
	["Player has mana less than 80%"] = "玩家法力值少于80%",
	["Player is AFK"] = "玩家暂离",
	["Player is Dead"] = "玩家死亡",
	["Player is in a different zone"] = "玩家在不同区域",
	["Player is missing at least one Paladin blessing"] = "玩家缺少至少一个圣骑士祝福",
	["Player is Offline"] = "玩家离线",
	["Please relog or reload UI to update the item cache."] = "请重载用户界面来更新物品缓存。",
	["prepares a %s!"] = "准备了%s！",
	["Press Escape -> Interface -> AddOns -> RaidBuffStatus for more options."] = "按 Esc -> 界面 -> 插件 -> RaidBuffStatus 获得更多的选项",
	Prot = "保",
	["Protection Paladin with no Righteous Fury"] = "防御圣骑士没有正义之怒",
	["PVP is On"] = "PvP 已开启",
	["PVP On"] = "PvP 开启",
	["Ranged DPS %s has died!"] = "远程 DPS %s 已死亡！",
	["RBS Dashboard Help"] = "RBS 仪表板帮助",
	["RBS Tank List"] = "RBS 坦克列表",
	["Refreshment Table about to expire!"] = "餐桌快要到时间啦！",
	["Remind me later"] = "以后提醒我",
	["(Remove buff)"] = "（移除增益）",
	["Remove this button from this dashboard in the buff options window."] = "从仪表板增益选项窗口中移除该按钮。",
	["Repair Bot about to expire!"] = "修理机器人将要消失！",
	["[RESIST]"] = "[抵抗]",
	["Right-click to open the addons options menu"] = "右击打开插件选项菜单",
	["%s about to expire!"] = "%s要过期了！",
	Scan = "扫描",
	["%s cast %s on %s"] = "%s施放%s给>%s<！",
	Scroll = "卷轴",
	Seal = "圣印",
	-- ["Sent %d whispers to %d players"] = "",
	["%s has a newer (%s) version of RBS (%s) than you (%s)"] = "%s 拥有最新的 RBS 版本（%s）超过你的（%s）",
	["Shift-Click buffs to report on only that buff."] = "Shift+点击只汇报该增益。",
	["%s is running RBS %s"] = "%s正在运行RBS %s",
	["Slackers: "] = "偷懒玩家：",
	["Slacking Paladins"] = "偷懒的圣骑士",
	["Sorry, I am queued for"] = "对不起，我在排地下城",
	["Sorry, I am queued for a battlefield."] = "对不起，我在拍战场队列之中。",
	["Sorry, the group is now full."] = "对不起，队伍已满。",
	["Soul Well about to expire!"] = "灵魂之井快要到时间啦！",
	Spi = "精",
	Sta = "耐",
	Str = "力",
	["Tank missing Earth Shield"] = "坦克缺少大地之盾",
	["Tank missing Thorns"] = "坦克缺少荆棘术",
	["Tank %s has died!"] = "坦克 %s 已死亡！",
	["Tank with "] = "坦克有",
	["The above default button actions can be reconfigured."] = "以上默认按键动作可以重新配置。",
	["This is the first time RaidBuffStatus has been activated since installation or settings were reset. Would you like to visit the Buff Wizard to help you get RBS buffs configured? If you are a raid leader then you can click No as the defaults are already set up for you."] = "这是 RBS 自安装或设置重置为默认后的第一次激活。你是否想要访问增益向导来帮助你配置 RBS 增益配置？如果你是个团队领袖你可以点击否后自动为你设置一个默认值。",
	["Tol Barad"] = "托尔巴拉德",
	Trash = "小怪",
	["Warning: "] = "警报：",
	["Warnings: "] = "警报：",
	["Weapon buff"] = "武器增益",
	["Well Fed but slacking"] = "好吃懒做",
	Wintergrasp = "冬拥湖",
	["Wrong flask for this zone"] = "对应区域错误的合剂",
	["Wrong Paladin blessing"] = "错误的圣骑士祝福",
	["You need to be leader or assistant to do this"] = "你必须是团队领袖或者团队助理",
	["You need to whisper the leader instead: "] = "需要密语领袖使用：",
}
La.Options = {
	Alive = "存活",
	["Allow raiders to use flasks and elixirs from last expansion"] = "允许团队玩家使用低级合剂和药剂",
	["Alt-left click"] = "Alt+点击",
	["Alt-right click"] = "Alt+右击",
	["Always hide the Boss R Trash buttons"] = "总是隐藏首领和小怪按钮",
	["Announce to raid warning when a Feast is prepared"] = "当鱼肉大餐准备好时团队警报频道发出通告",
	["Anti spam"] = "防止刷屏",
	Appearance = "外观",
	["Auto-accept invites"] = "自动接收邀请",
	["Auto-invite whispers"] = "密语自动邀请",
	["Automatically accept invites from friends and guild members so you can go for a bio-break whilst waiting for a raid invite"] = "忙于其他事情时自动接受好友和公会成员组队邀请",
	["Automatically accept invites from these"] = "自动接受这些邀请",
	["Automatically configures the dashboard buffs and configuration defaults for your class or raid leading role"] = "为你的职业或团队首领角色自动配置增益和配置为默认",
	["Automatically invite friends and guild members who whisper to you the word 'invite'"] = "朋友和公会成员使用密语“invite”时自动邀请",
	["Automatically invite these"] = "自动邀请这些",
	["Automatically show the dashboard when you join a battleground"] = "进入战场时自动显示仪表板",
	["Automatically show the dashboard when you join a party"] = "加入一个小队时自动显示仪表板",
	["Automatically show the dashboard when you join a raid"] = "加入一个团队时自动显示仪表板",
	["Automatically whisper anyone missing a Healthstone when your Soul Well expire warnings appear"] = "当你的灵魂之井将要消失的警报出现后自动密语没有治疗石的人",
	["Automatically whisper anyone missing flasks or elixirs when your Cauldron expire warnings appear"] = "当你的药锅将要消失的警报出现后自动密语没有合剂和药剂效果的人",
	["Automatically whisper anyone missing Well Fed when your Feast expire warnings appear"] = "当你的筵席将要消失的警报出现后自动密语没有食物效果的人",
	Automation = "自动",
	["Background colour"] = "背景颜色",
	["Bar positioning"] = "条位置",
	["Battle.net friends"] = "战网好友",
	["Border colour"] = "边框颜色",
	["Bosses only"] = "只对首领",
	Bottom = "底部",
	["Buff button sorting"] = "增益按钮排序中",
	["Buff Options scale"] = "增益选项缩放",
	["Buff those missing buff"] = "施放缺失增益",
	["Buff Wizard"] = "增益向导",
	Cauldron = "药锅",
	["Cauldron auto whisper"] = "药锅自动密语",
	["CC-break warnings"] = "群体控制打断警报",
	["Choose either one big collection of buff checks or traditional style with Warnings, Trash and Boss buff checks"] = "选择其中一个大收集增益检查或传统样式的警报，小怪和首领增益检查",
	["Choose where on the dashboard the bars appear"] = "选择仪表板上条的位置",
	["Class-specific buffs"] = "职业特定增益",
	Combat = "战斗",
	["Combat options"] = "战斗选项",
	["Configure how the buff buttons and status bars on the dashboard are sorted and displayed"] = "配置仪表板上增益按钮和状态条的排序和显示方式",
	["Consumable options"] = "消耗品选项",
	Consumables = "材料",
	["Core raid buffs"] = "核心团队增益",
	["Ctrl-left click"] = "Ctrl+点击",
	["Ctrl-right click"] = "Ctrl+右击",
	["Danielbarron broke Sheep on The Lich King with Hand of Reckoning"] = "乌瑟尔打断了巫妖王的 >变羊术<！技能：清算之手",
	["Darinia ninjaed my target (The Lich King) with Taunt"] = "吉安娜抢我目标的仇恨 >巫妖王<！技能：嘲讽",
	["Darinia taunted my mob (The Lich King) with Taunt"] = "吉安娜嘲讽我的怪 >巫妖王<！技能：嘲讽",
	["Darinia taunted my target (The Lich King) with Taunt"] = "吉安娜嘲讽我的目标 >巫妖王<！技能：嘲讽",
	["Dashboard columns"] = "仪表板列数",
	["Dashboard mouse button actions options"] = "仪表板鼠标按键动作选项",
	["Dashboard scale"] = "仪表板缩放",
	["Death warnings"] = "死亡警报",
	["Default order"] = "默认顺序",
	["Disable scan in combat"] = "战斗中禁用扫描",
	["DPS mana"] = "DPS 法力值",
	["Enable/disable buff check"] = "启用/禁用增益检查",
	["Enable tank warnings including taunts, failed taunts and mob stealing"] = "启用包括嘲讽，嘲讽失败和获得仇恨的坦克警报",
	["Enable tank warnings including taunts, failed taunts and mob stealing only on bosses"] = "只对首领启用包括嘲讽，嘲讽失败和获得仇恨的坦克警报",
	["Enable warning messages when players die"] = "启用当玩家死亡时的警报信息",
	["Enable warnings when Crowd Control is broken by tanks and non-tanks"] = "启用群体控制技能被坦克和非坦克打断的警报",
	["Enable warnings when Misdirection or Tricks of the Trade is cast"] = "启用当误导或嫁祸诀窍施放时的警报",
	["Feast auto whisper"] = "筵席自动密语",
	Feasts = "筵席",
	["Food announce"] = "食物通告",
	Friends = "好友",
	["Grouping style"] = "组成样式",
	["Guild members"] = "公会成员",
	["Healer death"] = "治疗死亡",
	["Healer drinking"] = "治疗回魔中",
	["Healer drinking sound"] = "治疗回魔音效",
	["Healer mana"] = "治疗法力值",
	["Healers alive"] = "治疗存活",
	["Healer Stormsnow has died!"] = "治疗 >泰兰德< 已死亡！",
	["Hide and show the buff report dashboard."] = "隐藏/显示增益报告仪表板",
	["Hide Boss R Trash"] = "隐藏 首领和小怪",
	["Hide dashboard during combat"] = "战斗中隐藏仪表板",
	["Hide in combat"] = "战斗中隐藏",
	["Hide the buff report dashboard."] = "隐藏增益报告仪表板",
	["Highlight my buffs"] = "高亮显示我的增益",
	["Hightlight currently missing buffs on the dashboard for which you are responsible including self buffs and buffs which you are missing that are provided by someone else. I.e. show buffs for which you must take action"] = "在仪表板上高亮显示当前你负责的缺失增益，包括自己的和其他人的，换而言之就是显示那些你必须作出反应的增益",
	["How MANY?"] = "多少算很多？",
	["Ignore groups 6 to 8"] = "忽略6至8队",
	["Ignore groups 6 to 8 when reporting as these are for subs"] = "忽略6至8队的替补",
	["[IMMUNE] Danielbarron FAILED TO TAUNT their target (The Lich King) with Hand of Reckoning"] = "[免疫]乌瑟尔嘲讽目标 >巫妖王< 失败！技能：清算之手",
	["In range"] = "距离",
	invite = "invite",
	["Just my buffs"] = "仅我的增益",
	["Left click"] = "点击",
	["Melee DPS Danielbarron has died!"] = "近战 DPS >乌瑟尔< 已死亡！",
	["Melee DPS death"] = "近战 DPS 死亡",
	["Minimap icon"] = "小地图按钮",
	["Minimum remaining buff duration in minutes. Buffs with less than this will be considered as missing.  This option only takes affect when the corresponding 'buff' button is enabled on the dashboard."] = "最小持续增益持续分钟。增益小于此值将被考虑为缺失。此选项只相应的影响仪表板上已启用的'增益'按钮。",
	["Min remaining buff duration"] = "最小剩余增益持续",
	["Misdirection warnings"] = "误导警报",
	["Mouse buttons"] = "鼠标按键",
	["Move with Alt-click"] = "Alt+点击移动",
	["My buffs"] = "我的增益",
	["Ninja taunts"] = "抢仇恨嘲讽",
	["No healer close"] = "周围没有治疗",
	None = "无",
	["Non-tank breaks CC"] = "非坦克打断控制",
	["Non-tank Glamor broke Hex on The Lich King with Moonfire"] = "[非坦克]范达尔打断了巫妖王身上的 >魅惑<！技能：月火",
	["NON-TANK Tanagra taunted my target (The Lich King) with Growl"] = "[非坦克]玛法里奥嘲讽我的目标 >巫妖王<！技能：低吼",
	["Non-tank taunts my target"] = "非坦克嘲讽我的目标",
	["Number of columns to display on the dashboard"] = "在仪表板上显示列的数目",
	["Old flasks and elixirs"] = "低级合剂和药剂",
	["One big group"] = "一大组",
	["One group down"] = "一组之下",
	["Only if all have it"] = "只当全都有",
	["Only me"] = "只对我",
	["Only show the buffs for which your class is responsible for.  This configuration can be used like a buff-bot where one simply right clicks on the buffs to cast them"] = "仅显示你的职业可以施放的增益。这个配置可以用来作为一个增益机器人，可以简单的右键点击增益来施放",
	["Only show the core class raid buffs"] = "仅显示核心职业团队增益",
	["Only show when you and only you break Crowd Control so you can say 'Now I don't believe you wanted to do that did you, ehee?'"] = "当且只当你打断控制时显示所以你可以说“现在我不相信你会这样做，不是吗？”",
	["Only use tank list"] = "只使用坦克列表",
	["Only use the tank list and ignore spec when there is a tank list for determining if someone is a tank or not"] = "只当有坦克名单的时候才显示坦克列表和根据此来忽略其他人",
	["Options for automatically opening the dashboard and moving it"] = "自动打开仪表板并移动选项",
	["Options for setting the quality requirements of consumables"] = "设置消耗品质量要求的选项",
	["Options to do with configuring the tank list"] = "配置坦克列表的选项",
	Other = "其它",
	["Other taunt fails"] = "其他嘲讽失败",
	["Play a sound"] = "播放音效",
	["Play a sound when a healer dies"] = "当一个治疗死亡时播放一个音效",
	["Play a sound when a healer drinks and is not full on mana"] = "当治疗回魔并法力未满时播放音效",
	["Play a sound when a melee DPS dies"] = "当一个近战 DPS 死亡时播放一个音效",
	["Play a sound when a non-tank breaks Crowd Control"] = "当非坦克打断控制时播放音效",
	["Play a sound when a ranged DPS dies"] = "当一个远程 DPS 死亡时播放一个音效",
	["Play a sound when a tank breaks Crowd Control"] = "当坦克打断控制时播放音效",
	["Play a sound when a tank dies"] = "当一个坦克死亡时播放一个音效",
	["Play a sound when Misdirection or Tricks of the Trade is cast"] = "当误导或嫁祸诀窍施放后播放一个音效",
	["Play a sound when one of your taunts fails due to resist"] = "当你的嘲讽被抵抗时播放一个音效警报",
	["Play a sound when one of your taunts fails due to the target being immune"] = "当你嘲讽失败时播放一个音效",
	["Play a sound when other people's taunts to your target fail"] = "当别人嘲讽你的目标失败时播放音效",
	["Play a sound when someone else targets a mob and taunts that mob which is targeting you"] = "当别人点选并嘲讽一个你已获得仇恨的怪时播放音效",
	["Play a sound when someone else taunts your target"] = "当别人嘲讽你的目标时播放音效",
	["Play a sound when someone else taunts your target which is targeting you"] = "当别人嘲讽你已获得仇恨的目标时播放音效",
	["Play a sound when someone else who is not a tank taunts your target"] = "当非坦克人员嘲讽你的目标时播放音效",
	["Prepend RBS::"] = "嵌入RBS：",
	["Prepend RBS:: to all lines of report chat. Disable to only prepend on the first line of a report"] = "在每行报告中嵌入RBS：字样。用则只在报告的第一行中置入",
	["Raid health"] = "团队生命值",
	["Raid leader"] = "团队领袖",
	["Raid mana"] = "团队法力值",
	["Raid Status Bars"] = "团队状态条",
	["Raid-wide buffs"] = "大团队增益",
	["Ranged DPS death"] = "远程 DPS 死亡",
	["Ranged DPS Garmann has died!"] = "远程 DPS Garmann 已死亡！",
	["Refreshment Table"] = "餐桌",
	["Repair Bot"] = "修理机器人",
	Reporting = "报告",
	["Reporting options"] = "报告选项",
	["Report missing to raid"] = "向团队报告缺失",
	["Report to officer channel"] = "对官员频道报告",
	["Report to officers"] = "对官员报告",
	["Report to /raid or /party who is not buffed to the max."] = "报告到团队或队伍谁没有最大化之增益",
	["Report to raid/party"] = "对团队/小队报告",
	["Report to raid/party - requires raid assistant"] = "对团队/小队报告 - 需要团队助理权限",
	["Report to self"] = "对自己报告",
	["Required food quality"] = "需要食物品质",
	["Require the Alt buton to be held down to move the dashboard window"] = "需要按住 Alt 键才能移动仪表板",
	["[RESIST] Danielbarron FAILED TO TAUNT their target (The Lich King) with Hand of Reckoning"] = "[抵抗]乌瑟尔嘲讽目标 >巫妖王< 失败！技能：清算之手",
	["[RESIST] Darinia FAILED TO TAUNT my target (The Lich King) with Taunt"] = "[抵抗]吉安娜嘲讽我的目标 >巫妖王< 失败！技能：嘲讽",
	["Right click"] = "右键",
	["Scale the Buff Options window"] = "缩放增益选项窗口",
	["Scale the dashboard window"] = "缩放仪表板窗口",
	["Seconds between updates"] = "刷新间隔秒数",
	["Select which action to take when you click with the left mouse button over a dashboard buff check"] = "选择当鼠标左键点击仪表板上的增益检查时执行的动作",
	["Select which action to take when you click with the left mouse button with Alt held down over a dashboard buff check"] = "选择当按住 Alt 鼠标左键点击仪表板上的增益检查时执行的动作",
	["Select which action to take when you click with the left mouse button with Ctrl held down over a dashboard buff check"] = "选择当按住 Ctrl 鼠标左键点击仪表板上的增益检查时执行的动作",
	["Select which action to take when you click with the left mouse button with Shift held down over a dashboard buff check"] = "选择当按住 Shift 鼠标左键点击仪表板上的增益检查时执行的动作",
	["Select which action to take when you click with the right mouse button over a dashboard buff check"] = "选择当鼠标右键点击仪表板上的增益检查时执行的动作",
	["Select which action to take when you click with the right mouse button with Alt held down over a dashboard buff check"] = "选择当按住 Alt 鼠标右键点击仪表板上的增益检查时执行的动作",
	["Select which action to take when you click with the right mouse button with Ctrl held down over a dashboard buff check"] = "选择当按住 Ctrl 鼠标右键点击仪表板上的增益检查时执行的动作",
	["Select which action to take when you click with the right mouse button with Shift held down over a dashboard buff check"] = "选择当按住 Shift 鼠标右键点击仪表板上的增益检查时执行的动作",
	["Select which level of food quality you require for the raiders to be considered 'Well Fed'"] = "选择何种让团队成员“吃饱喝足”的食物等级品质",
	["Self buffs"] = "自身增益",
	["Set how many seconds between dashboard raid scan updates"] = "设置每多少秒刷新仪表板团队扫描",
	["Set N - the number of people missing a buff considered to be \"MANY\""] = "当缺失增益超过数字 N 的时候显示为“很多”",
	["Shift-left click"] = "Shift+点击",
	["Shift-right click"] = "Shift+右击",
	["Shorten names"] = "简称",
	["Shorten names in the report to reduce channel spam"] = "在报告中使用简称以减少频道堵塞",
	["Show group number"] = "显示小队数字",
	["Show in battleground"] = "在战场中显示",
	["Show in party"] = "在小队时显示",
	["Show in raid"] = "在团队时显示",
	["Show the buff report dashboard."] = "显示增益报告仪表板",
	["Show the group number of the person missing a party/raid buff"] = "在提示缺失增益成员的时候显示小队数字",
	["Single target buffs"] = "单目标增益",
	["Skin and minimap options"] = "皮肤和小地图选项",
	["Skin and scaling"] = "皮肤和缩放",
	["Skip buff checking during combat. You can manually initiate a scan by pressing Scan on the dashboard"] = "战斗中忽略增益检查。在仪表板可以手动点击扫描初始化",
	["%s minutes"] = "%s分钟",
	["Sort buff buttons by"] = "增益按钮排序为",
	["Soul Well"] = "灵魂之井",
	["Status bars to show raid, dps, tank health, mana, etc"] = "用来显示团队，DPS，坦克生命值，法力值等等的状态条",
	["Tank breaks CC"] = "坦克打断控制",
	["Tank Danielbarron has died!"] = "坦克 >乌瑟尔< 已死亡！",
	["Tank death"] = "坦克死亡",
	["Tank health"] = "坦克生命值",
	["Tank list"] = "坦克列表",
	["Tanks alive"] = "坦克存活",
	["Tank warnings"] = "坦克警报",
	["Tank warnings about taunts, failed taunts and mob stealing including accidental taunts from non-tanks"] = "关于嘲讽，嘲讽失败和包括从非坦克那里意外嘲讽而获得仇恨的警报",
	["Taunts to my mobs"] = "嘲讽我的怪",
	["Taunts to my target"] = "对我目标的嘲讽",
	["Tells you when someone in your party, raid or guild has a newer version of RBS installed"] = "当你的队伍，团队或公会中有最新版本的 RBS 时通报",
	["Tells you when someone in your party, raid or guild has RBS installed"] = "小队，团队或公会有人安装 RBS 时告知",
	Test = "测试",
	["Test what the warning is like"] = "测试警报是什么样的",
	["The average DPS mana percent"] = "DPS 平均法力值百分比",
	["The average healer mana percent"] = "治疗平均法力值百分比",
	["The average party/raid health percent"] = "小队/团队平均生命值百分比",
	["The average party/raid mana percent"] = "小队/团队平均法力值百分比",
	["The average tank health percent"] = "坦克平均生命值百分比",
	["The Buff Wizard automatically configures the dashboard buffs and configuration defaults for your class or raid leading role."] = "增益向导自动为你的职业或团队首领角色自动配置增益和配置为默认",
	["Then sort buff buttons by"] = "增益按钮排序为",
	["The percentage of healers alive in the raid"] = "团队中治疗存活百分比",
	["The percentage of people alive in the raid"] = "团队中存活人数百分比",
	["The percentage of people dead in the raid"] = "团队死亡玩家百分比",
	["The percentage of people within 40 yards range"] = "40码距离以内玩家百分比",
	["The percentage of tanks alive in the raid"] = "团队中坦克存活百分比",
	["This is the default configuration in which RBS ships out-of-the-box.  It gives you pretty much anything a raid leader would need to see on the dashboard"] = "这是 RBS 的默认配置，可以随时使用。在仪表板上可提供几乎任何一个团队领袖所需看到的东西",
	["Toggle to display a minimap icon"] = "切换是否显示小地图按钮",
	Top = "顶部",
	["To set this option go to the addon configuration.  This button is automatically enabled when the Boss button is pressed and automatically disabled when the Trash button is pressed.  To permanently disable, choose 0 seconds as the min remaining buff duration."] = "设置此选项到插件配置。当首领按钮被按下时此按钮会自动启用并当小怪按钮被按下时自动禁用。要永久禁用，选择0秒作为其最小剩余增益持续。",
	["Two groups down"] = "两组之下",
	["User announce"] = "用户通知",
	["Version announce"] = "版本通报",
	["Wait before announcing to see if others have announced first in order to reduce spam"] = "通报前先等待查看是否其他人已通报过已减少垃圾信息",
	["Warning messages when players die"] = "当玩家死亡时的警报信息",
	["Warnings when Crowd Control is broken by tanks and non-tanks"] = "当群体控制技能被坦克和非坦克打断时的警报",
	["Warnings when Misdirection or Tricks of the Trade is cast"] = "当误导或嫁祸诀窍施放时警报",
	["Warnings when someone else targets a mob and taunts that mob which is targeting you"] = "当别人点选并嘲讽一个你已获得仇恨的怪时发出警报",
	["Warnings when someone else taunts your target"] = "当别人嘲讽你的目标时发出警报",
	["Warnings when someone else taunts your target who is not a tank"] = "当非坦克人员嘲讽你的目标时发出警报",
	["Warning, Trash, Boss groups"] = "警报，小怪，首领组",
	["Warns when a non-tank breaks Crowd Control"] = "当非坦克打断控制时警报",
	["Warns when a tank breaks Crowd Control"] = "当坦克打断控制技能时发出警报",
	["Warns when other people's taunts to your target fail"] = "当别人嘲讽你的目标失败时发出警报",
	["Warns when someone else taunts your target which is targeting you"] = "当别人嘲讽你已获得仇恨的目标时发出警报",
	["Warns when your taunts fail due to resist"] = "当你的嘲讽被抵抗时警报",
	["Warns when your taunts fail due to the target being immune"] = "当你的嘲讽失败时的警报",
	["Warn to party"] = "小队警报",
	["Warn to party when a healer dies"] = "当一个治疗死亡时警报到小队频道",
	["Warn to party when a melee DPS dies"] = "当一个近战 DPS 死亡时警报到小队频道",
	["Warn to party when a non-tank breaks Crowd Control"] = "当非坦克打断控制时向小队发出警报",
	["Warn to party when a ranged DPS dies"] = "当一个远程 DPS 死亡时警报到小队频道",
	["Warn to party when a tank breaks Crowd Control"] = "当坦克打断控制时向小队发出警报",
	["Warn to party when a tank dies"] = "当一个坦克死亡时警报到小队频道",
	["Warn to party when one of your taunts fails due to resist"] = "当你的嘲讽被抵抗时警报到小队",
	["Warn to party when one of your taunts fails due to the target being immune"] = "当你嘲讽失败时向小队发出警报",
	["Warn to party when other people's taunts to your target fail"] = "当别人嘲讽你的目标失败时向队伍发出警报",
	["Warn to party when someone else targets a mob and taunts that mob which is targeting you"] = "当别人点选并嘲讽一个你已获得仇恨的怪时对小队发出警报",
	["Warn to party when someone else taunts your target"] = "当别人嘲讽你的目标时对小队发出警报",
	["Warn to party when someone else taunts your target which is targeting you"] = "当别人嘲讽你已获得仇恨的目标时向小队发出警报",
	["Warn to party when someone else who is not a tank taunts your target"] = "当非坦克人员嘲讽你的目标时向小队发出警报",
	["Warn to raid chat"] = "向团队频道发出警报",
	["Warn to raid chat when a healer dies"] = "当一个治疗死亡时警报到团队频道",
	["Warn to raid chat when a melee DPS dies"] = "当一个近战 DPS 死亡时警报到团队频道",
	["Warn to raid chat when a non-tank breaks Crowd Control"] = "当非坦克打断控制时向团队发出警报",
	["Warn to raid chat when a ranged DPS dies"] = "当一个远程 DPS 死亡时警报到团队频道",
	["Warn to raid chat when a tank breaks Crowd Control"] = "当坦克打断控制时向团队频道发出警报",
	["Warn to raid chat when a tank dies"] = "当一个坦克死亡时警报到团队警报",
	["Warn to raid chat when one of your taunts fails due to resist"] = "当你的嘲讽被抵抗时警报到团队",
	["Warn to raid chat when one of your taunts fails due to the target being immune"] = "当你的嘲讽失败时向团队频道发出警报",
	["Warn to raid chat when other people's taunts to your target fail"] = "当其他人嘲讽你的目标失败时向团队频道发出警报",
	["Warn to raid chat when someone else targets a mob and taunts that mob which is targeting you"] = "当别人点选并嘲讽一个你已获得仇恨的怪时对团队频道发出警报",
	["Warn to raid chat when someone else taunts your target"] = "当别人嘲讽你的目标失败时向团队频道发出警报",
	["Warn to raid chat when someone else taunts your target which is targeting you"] = "当别人嘲讽已经看你的目标时向团队频道发出警报",
	["Warn to raid chat when someone else who is not a tank taunts your target"] = "当非坦克嘲讽你的目标时向团队频道发出警报",
	["Warn to raid warning"] = "发出团队警报",
	["Warn to self"] = "对自己发出警告",
	["Warn to self when a healer dies"] = "当一个治疗死亡时警报自身",
	["Warn to self when a melee DPS dies"] = "当一个近战 DPS 死亡时警报自身",
	["Warn to self when a non-tank breaks Crowd Control"] = "当非坦克打断控制时警告向自己发出警报",
	["Warn to self when a ranged DPS dies"] = "当一个远程 DPS 死亡时警报自身",
	["Warn to self when a tank breaks Crowd Control"] = "当坦克打断控制时向自己发出警报",
	["Warn to self when a tank dies"] = "当一个坦克死亡时警报自身",
	["Warn to self when Misdirection or Tricks of the Trade is cast"] = "当误导或嫁祸诀窍施放时警报给自身",
	["Warn to self when one of your taunts fails due to resist"] = "当你的嘲讽被抵抗时警报给自身",
	["Warn to self when one of your taunts fails due to the target being immune"] = "当你嘲讽失败时对自己发出警报",
	["Warn to self when other people's taunts to your target fail"] = "当别人嘲讽你的目标失败时向自己发出警报",
	["Warn to self when someone else targets a mob and taunts that mob which is targeting you"] = "当别人点选并嘲讽一个你已获得仇恨的怪时向自己发出警报",
	["Warn to self when someone else taunts your target"] = "当别人嘲讽你的目标时对自己发出警报",
	["Warn to self when someone else taunts your target which is targeting you"] = "当别人嘲讽你已获得仇恨的目标时向自己发出警报",
	["Warn to self when someone else who is not a tank taunts your target"] = "当非坦克人员嘲讽你的目标时向自己发出警报",
	["Warn using raid warning when a healer dies"] = "当一个治疗死亡时通报到团队警报",
	["Warn using raid warning when a melee DPS dies"] = "当一个近战 DPS 死亡时通报到团队警报",
	["Warn using raid warning when a non-tank breaks Crowd Control"] = "当非坦克打断控制时通过团队警报频道发出警报",
	["Warn using raid warning when a ranged DPS dies"] = "当一个远程 DPS 死亡时通报到团队警报",
	["Warn using raid warning when a tank breaks Crowd Control"] = "当坦克打断控制时通过团队警报频道发出警报",
	["Warn using raid warning when a tank dies"] = "当一个坦克死亡时通报到团队警报",
	["Warn using raid warning when one of your taunts fails due to resist"] = "当你的嘲讽被抵抗时警报到团队警报",
	["Warn using raid warning when one of your taunts fails due to the target being immune"] = "当你嘲讽失败时使用团队警报",
	["Warn using raid warning when other people's taunts to your target fail"] = "当别人嘲讽你的目标失败时使用团队警报",
	["Warn using raid warning when someone else targets a mob and taunts that mob which is targeting you"] = "当别人点选并嘲讽一个你已获得仇恨的怪时使用团队警报",
	["Warn using raid warning when someone else taunts your target"] = "当别人嘲讽你的目标时使用团队警报",
	["Warn using raid warning when someone else taunts your target which is targeting you"] = "当别人嘲讽你已获得仇恨的目标时使用团队警报",
	["Warn using raid warning when someone else who is not a tank taunts your target"] = "当非坦克人员嘲讽你的目标时使用团队警报",
	["Warn when a healer dies"] = "当一个治疗死亡时警报",
	["Warn when a melee DPS dies"] = "当一个近战 DPS 死亡时警报",
	["Warn when a ranged DPS dies"] = "当一个远程 DPS 死亡时警报",
	["Warn when a tank dies"] = "当一个坦克死亡时警报",
	["Well auto whisper"] = "食物效果自动密语",
	["When at least N people are missing a raid buff say MANY instead of spamming a list"] = "当超过3个人缺失一个团队增益的时候说很多来代替繁复的列表",
	["When many say so"] = "当很多这样说",
	["When there are multiple people who can provide a missing buff such as Fortitude then only whisper one of them at random who is in range rather than all of them"] = "当多人可提供缺少增益如坚韧祷言增益时只随机密语给他们之中处于距离范围内的玩家。",
	["When whispering and at least N people are missing a raid buff say MANY instead of spamming a list"] = "当至少 N 个人缺少团队增益且为密语时，用*很多*代替产生列表",
	["Whisper buffers"] = "密语增益施法者",
	["Whisper many"] = "密语-很多",
	["Whisper only one"] = "只密语一人",
	["Your taunt immune-fails"] = "你的嘲讽失败",
	["Your taunt resist-fails"] = "你的嘲讽抵抗-失败",
}
La.RaidStatusBars = {
	["Dead healers"] = "死亡的治疗",
	["Dead tanks"] = "死亡的坦克",
	["I see dead people"] = "死亡玩家",
	["n/a"] = "无",
	-- P = "",
	-- ["Pull Timer"] = "",
	R = "R", -- Needs review
	-- ["Ready Check"] = "",
}
La.TalentsWindow = {
	Class = "职业",
	Healer = "治疗",
	["Melee DPS"] = "近战 DPS",
	Name = "名称",
	["Ranged DPS"] = "远程 DPS",
	Refresh = "刷新",
	Role = "角色",
	Spec = "特",
	Specialisations = "特效",
	["Talent Specialisations"] = "天赋特效",
	Tank = "坦克",
}
La.TankTauntWarnings = {
	["NON-TANK %s taunted my boss target (%s%s%s) with %s"] = "[非坦克]%s嘲讽我的首领目标 >%s%s%s<！技能：%s",
	["NON-TANK %s taunted my target (%s%s%s) with %s"] = "[非坦克]%s嘲讽我的目标 >%s%s%s<！技能：%s",
	["%s FAILED TO NINJA my boss target (%s%s%s) with %s"] = "%s抢仇恨我的首领目标 >%s%s%s< 失败！技能：%s",
	["%s FAILED TO NINJA my target (%s%s%s) with %s"] = "%s抢仇恨我的目标 >%s%s%s< 失败！技能：%s",
	["%s FAILED TO TAUNT my boss target (%s%s%s) with %s"] = "%s嘲讽我的首领目标 >%s%s%s< 失败！技能：%s",
	["%s FAILED TO TAUNT my target (%s%s%s) with %s"] = "%s嘲讽我的目标 >%s%s%s< 失败！技能：%s",
	["%s FAILED TO TAUNT their boss target (%s%s%s) with %s"] = "%s嘲讽首领目标 >%s%s%s< 失败！技能：%s",
	["%s FAILED TO TAUNT their target (%s%s%s) with %s"] = "%s嘲讽目标 >%s%s%s< 失败！技能：%s",
	["%s ninjaed my boss target (%s%s%s) with %s"] = "%s抢仇恨我的首领目标 >%s%s%s< 失败！技能：%s",
	["%s ninjaed my target (%s%s%s) with %s"] = "%s抢仇恨我的目标 >%s%s%s<！技能：%s",
	["%s taunted my boss mob (%s%s%s) with %s"] = "%s嘲讽我的首领小怪 >%s%s%s< 失败！技能：%s",
	["%s taunted my boss target (%s%s%s) with %s"] = "%s嘲讽我的首领目标 >%s%s%s<！技能：%s",
	["%s taunted my mob (%s%s%s) with %s"] = "%s嘲讽我的小怪 >%s%s%s< 失败！技能：%s",
	["%s taunted my target (%s%s%s) with %s"] = "%s嘲讽我的目标 >%s%s%s<！技能：%s",
}

elseif locale == "esES" then do end
-- La["Announce even when you don't have assist or lead"] = ""
-- La["Announce expiration"] = ""
-- La["Announcement options for raid utilities like Feasts"] = ""
-- La["Announce to raid warning when a %s is prepared"] = ""
-- La["Announce to raid warning when a utility is expiring"] = ""
-- La["Announce without lead"] = ""
-- La["Augment Banquet Tooltips"] = ""
-- La["Augment Banquet Tooltips with stat bonus information"] = ""
-- La["Augment Rune"] = ""
-- La["Blingtron"] = ""
-- La["Blingtron about to expire!"] = ""
-- La["Bonus"] = ""
-- La["Broken Link"] = ""
-- La["casts %s"] = ""
-- La["Eating"] = ""
-- La["Expiration announcements"] = ""
-- La[" has set us up a Blingtron"] = ""
-- La["has set us up a %s"] = ""
-- La["Mailbox"] = ""
-- La["Noodle Cart"] = ""
-- La["Portal"] = ""
-- La["Prefer Static Buff"] = ""
-- La["Report missing static buffs even when an equivalent passive aura is already present."] = ""
-- La["Required flask quality"] = ""
-- La["Right-click to target"] = ""
-- La["Select which level of flask quality you require"] = ""
-- La["sets up a %s"] = ""
-- La["Show configuration options"] = ""
-- La["Soulwell"] = ""
-- La["Tooltip name coloring"] = ""
-- La["Tooltip role icons"] = ""
-- La["Treat eating as Well Fed"] = ""
-- La["Treat players who are currently eating as Well Fed. This assumes they are eating acceptable food."] = ""
-- La["Utility announcements"] = ""
-- La["Warrior Stance"] = ""
La.BuffOptionsWindow = {
	["Buff Options"] = "Opciones Mejoras",
	["Is a buff"] = "Mejoras",
	["Is a warning"] = "Avisos",
	["Report on Boss"] = "Informar (jefe)",
	["Report on Trash"] = "Informar (Trash)",
	["Show on dashboard"] = "Mostrar en panel",
	["Show/Report in combat"] = "Mostrar/Informar en combate",
}
La.CrowdControlWarnings = {
	-- ["Melee Swing"] = "",
	["Non-tank %s broke %s on %s%s%s"] = "No tanque %s rompe %s en %s%s%s",
	["Non-tank %s broke %s on %s%s%s with %s"] = "No tanque %s rompe %s en %s%s%s con %s",
	["%s broke %s on %s%s%s"] = "%s rompe %s en %s%s%s",
	["%s broke %s on %s%s%s with %s"] = "%s rompe %s en %s%s%s con %s",
}
La.Messages = {
	AFK = "AUS",
	Agil = "Agil",
	alpha = "alfa",
	["Alt-Click on a party buff will cast on someone missing that buff."] = "Alt-clic para aplicar una mejora en el grupo",
	["Alt-Click on a self buff will renew that buff."] = "Alt-clic para renovar mejora en uno mismo",
	["Aspect Cheetah/Pack On"] = "Aspecto del guepardo/manada activo",
	["Aspect of the Cheetah or Pack is on"] = "Aspecto del guepardo o de la manada activo",
	["Battle Elixir"] = "Elixir de Batalla",
	beta = "beta",
	-- ["Blessing of Kings is not needed because you are grouped with a Druid."] = "",
	["Blessing of Kings, with this raid configuration, is better provided by Drums of the Forgotten Kings thus allowing Blessing of Might to be used."] = "Bendición de Reyes, con esta configuración de banda, es mejor ponerla con los Tambores de los Reyes Olvidados para poder usar también Bendición de Poderío a la vez.",
	Boss = "Jefe",
	["Buffers: "] = "Mejoradores: ",
	-- ["Buffing Kings:"] = "",
	-- ["Buffing Might:"] = "",
	["Cast by:"] = "Lanzado por:",
	["Click buffs to disable and enable."] = "Clic para habilitar y deshabilitar mejoras",
	["Click to toggle the RBS dashboard"] = "Clic para mostrar/ocultar la ventana del RBS",
	["Ctrl-Click Boss or Trash to whisper all those who need to buff."] = "Ctrl-Click Jefe o Trash para susurrar a todos los que necesitan un buff.",
	["Ctrl-Click buffs to whisper those who need to buff."] = "Ctrl-clic para susurrar aquellos que necesitan mejora",
	Dead = "Muerto",
	["Death Knight Presence"] = "Presencia Caballero de la Muerte",
	["Different Zone"] = "Zona diferente",
	["Flasked or Elixired but slacking"] = "Jugador usando elixir o frasco pero de bajo nivel",
	["Flask or two Elixirs"] = "Frasco o dos elixires",
	["Guardian Elixir"] = "Elixir Guardián",
	["Has buff: "] = "Tiene el beneficio",
	[" has set us up a Refreshment Table"] = "  ha creado una Mesa de Refrigerio",
	[" has set us up a Repair Bot"] = "  ha sacado un Robot de Reparación",
	[" has set us up a Soul Well"] = " ha preparado un Ritual de Almas",
	["Healer %s has died!"] = "¡Healer %s ha muerto!",
	["Health less than 80%"] = "Salud por debajo del 80%",
	-- ["Hide outgoing whispers"] = "",
	["Hunter Aspect"] = "Aspecto del cazador",
	["Hunter has no aspect at all"] = "Cazador sin Aspecto",
	["[IMMUNE]"] = "[INMUNE]",
	Int = "Int",
	-- [" in their bags"] = "",
	-- ["Invite auto-accepted from battle.net friend %s."] = "",
	-- ["Invite auto-accepted from friend %s."] = "",
	-- ["Invite auto-accepted from guild member %s."] = "",
	["Item count: "] = "Contador de objetos:",
	["Low durability"] = "Baja durabilidad",
	["Low durability (35% or less)"] = "Baja durabilidad (35% o menos)",
	["Mage is missing a Mage Armor"] = "Mago sin armadura",
	["Mana less than 80%"] = "Maná por debajo del 80%",
	["MANY!"] = "MUCHOS",
	["Melee DPS %s has died!"] = "¡%s Melee DPS ha muerto!",
	["Missing "] = "Falta",
	["Missing a scroll"] = "Falta pergamino",
	["Missing buff: "] = "Falta mejora: ",
	["Missing buffs (Boss): "] = "Faltan mejoras (Jefe)",
	["Missing buffs (Trash): "] = "Faltan mejoras (trash)",
	["Missing or not working oRA or RBS: "] = "oRA falta o no funciona:",
	No = "No",
	["No buffs needed! (Boss)"] = "No faltan mejoras! (Jefe)",
	["No buffs needed! (Trash)"] = "No faltan mejoras! (Trash)",
	["No Soulstone detected"] = "Piedra de alma no detectada",
	["Not Well Fed"] = "No está bien alimentado",
	Offline = "Offline",
	["Out of range"] = "Fuera de alcance",
	["Paladin blessing"] = "Bendición de Paladín",
	["Paladin missing Seal"] = "Paladín sin Sello",
	["Player has a wrong Paladin blessing"] = "Jugador con Bendición de Paladín errónea",
	["Player has health less than 80%"] = "Jugador tiene la salud por debajo del 80%",
	["Player has mana less than 80%"] = "Jugador tiene el maná por debajo del 80%",
	["Player is AFK"] = "Jugador AUS",
	["Player is Dead"] = "Jugador muerto",
	["Player is in a different zone"] = "Jugador en una zona diferente",
	["Player is missing at least one Paladin blessing"] = "Jugador falto de al menos una Bendición de Paladín",
	["Player is Offline"] = "Jugador Offline",
	["Please relog or reload UI to update the item cache."] = "Por favor, reloguea o recarga la IU para actualizar el item cache.",
	["prepares a %s!"] = "prepara un %s!",
	["Press Escape -> Interface -> AddOns -> RaidBuffStatus for more options."] = "Pulsar Escape -> Interfaz -> AddOns -> RaidBuffStatus para más opciones",
	Prot = "Prot",
	["Protection Paladin with no Righteous Fury"] = "Paladín de Protección sin Furia Justa",
	["PVP is On"] = "JcJ activo",
	["PVP On"] = "JcJ activo",
	["Ranged DPS %s has died!"] = "DPS distancia %s ha muerto!",
	["RBS Dashboard Help"] = "Ayuda del panel RBS",
	["RBS Tank List"] = "Lista de tanques RBS",
	["Refreshment Table about to expire!"] = "¡Ritual de Refrigerio a punto de desaparecer!",
	["Remind me later"] = "Recordármelo más tarde",
	["(Remove buff)"] = "(Quitar buff)",
	["Remove this button from this dashboard in the buff options window."] = "Quitar este botón del panel en la ventana de opciones",
	["Repair Bot about to expire!"] = "El Robot de Reparación expirará pronto",
	["[RESIST]"] = "[RESISTIDO]",
	["Right-click to open the addons options menu"] = "Clic-dcho para abrir el menú de opciones",
	-- ["%s about to expire!"] = "",
	Scan = "Escanear",
	["%s cast %s on %s"] = "%s usa %s en %s",
	Scroll = "Pergamino",
	Seal = "Sello",
	-- ["Sent %d whispers to %d players"] = "",
	["%s has a newer (%s) version of RBS (%s) than you (%s)"] = "%s tiene una nueva versión (%s) de RBS (%s) y tu tienes la (%s)",
	["Shift-Click buffs to report on only that buff."] = "Shift-clic para informar en solo esa mejora",
	-- ["%s is running RBS %s"] = "",
	["Slackers: "] = "Perezosos: ",
	["Slacking Paladins"] = "Paladines perezosos",
	-- ["Sorry, I am queued for"] = "",
	-- ["Sorry, I am queued for a battlefield."] = "",
	-- ["Sorry, the group is now full."] = "",
	["Soul Well about to expire!"] = "¡Ritual de Almas a punto de desaparecer!",
	Spi = "Esp",
	Sta = "Agu",
	Str = "Fue",
	["Tank missing Earth Shield"] = "Tanque sin Escudo de tierra",
	["Tank missing Thorns"] = "Tanque sin Espinas",
	["Tank %s has died!"] = "¡Tanque %s ha muerto!",
	["Tank with "] = "Tanque con ",
	["The above default button actions can be reconfigured."] = "Las acciones por defecto superiores pueden ser configuradas",
	["This is the first time RaidBuffStatus has been activated since installation or settings were reset. Would you like to visit the Buff Wizard to help you get RBS buffs configured? If you are a raid leader then you can click No as the defaults are already set up for you."] = "Esta es la primera vez que RaidBuffStatus ha sido activado desde la instalación o se ha reiniciar . Le gustaría visitar BuffWizard ( Beneficios  Mágico) para ayudarle a configurar RBS? Si Ud. es el Líder de Banda puede pulsar NO por estar ya configurado para Ud.", -- Needs review
	-- ["Tol Barad"] = "",
	Trash = "Trash",
	["Warning: "] = "Aviso: ",
	["Warnings: "] = "Avisos: ",
	["Weapon buff"] = "Mejora en arma",
	["Well Fed but slacking"] = "Con comida pero de bajo nivel",
	Wintergrasp = "Conquista del Invierno",
	["Wrong flask for this zone"] = "Frasco incorrecto en esta zona",
	["Wrong Paladin blessing"] = "Bendición de Paladín errónea",
	["You need to be leader or assistant to do this"] = "Necesitas ser líder o asistente para hacer esto",
	-- ["You need to whisper the leader instead: "] = "",
}
La.Options = {
	Alive = "Vivos",
	["Allow raiders to use flasks and elixirs from last expansion"] = "Permitir usar frascos y elixires de la última expansión",
	["Alt-left click"] = "Clic alt-izquierdo",
	["Alt-right click"] = "Clic alt-derecho",
	-- ["Always hide the Boss R Trash buttons"] = "",
	["Announce to raid warning when a Feast is prepared"] = "Anunciar por aviso de banda cuando sacan un Festín",
	["Anti spam"] = "Anti spam",
	Appearance = "Aspecto",
	-- ["Auto-accept invites"] = "",
	-- ["Auto-invite whispers"] = "",
	-- ["Automatically accept invites from friends and guild members so you can go for a bio-break whilst waiting for a raid invite"] = "",
	-- ["Automatically accept invites from these"] = "",
	["Automatically configures the dashboard buffs and configuration defaults for your class or raid leading role"] = "Automáticamente Configura el panel decontrol de Beneficios y los valores predeterminados de configuración para su clase o lider de banda", -- Needs review
	-- ["Automatically invite friends and guild members who whisper to you the word 'invite'"] = "",
	-- ["Automatically invite these"] = "",
	["Automatically show the dashboard when you join a battleground"] = "Mostrar automáticamente el panel cuando entras en un campo de batalla",
	["Automatically show the dashboard when you join a party"] = "Mostrar el panel automáticamente al entrar en el grupo",
	["Automatically show the dashboard when you join a raid"] = "Mostrar el panel automáticamente al entrar en la banda",
	["Automatically whisper anyone missing a Healthstone when your Soul Well expire warnings appear"] = "automáticamente susurra a cualquier que le falte Piedra de Salud cuando tu Pozo de almas expira aprecen alertas",
	-- ["Automatically whisper anyone missing flasks or elixirs when your Cauldron expire warnings appear"] = "",
	["Automatically whisper anyone missing Well Fed when your Feast expire warnings appear"] = "automáticamente susurra a cualquier que le falte Bien Alimentado cuando aparece tu alerta de Festin expira",
	-- Automation = "",
	["Background colour"] = "Color del fondo",
	-- ["Bar positioning"] = "",
	-- ["Battle.net friends"] = "",
	["Border colour"] = "Color del borde",
	["Bosses only"] = "Solo jefes",
	-- Bottom = "",
	-- ["Buff button sorting"] = "",
	["Buff Options scale"] = "Beneficios Opciones Escala", -- Needs review
	["Buff those missing buff"] = "Aplicar las mejoras que faltan",
	["Buff Wizard"] = "Asistente de Buffs",
	-- Cauldron = "",
	-- ["Cauldron auto whisper"] = "",
	["CC-break warnings"] = "Avisos de roturas de CC",
	-- ["Choose either one big collection of buff checks or traditional style with Warnings, Trash and Boss buff checks"] = "",
	-- ["Choose where on the dashboard the bars appear"] = "",
	-- ["Class-specific buffs"] = "",
	Combat = "Combate",
	["Combat options"] = "Opciones del combate",
	-- ["Configure how the buff buttons and status bars on the dashboard are sorted and displayed"] = "",
	["Consumable options"] = "Opciones de consumibles",
	-- Consumables = "",
	["Core raid buffs"] = "Beneficios de banda, Núcleo", -- Needs review
	["Ctrl-left click"] = "Clic Ctrl-izquierdo",
	["Ctrl-right click"] = "Clic Ctrl-derecho",
	["Danielbarron broke Sheep on The Lich King with Hand of Reckoning"] = "Danielbarron rompio Oveja en El Rey Exanime con Mano de Expiacion",
	["Darinia ninjaed my target (The Lich King) with Taunt"] = "Darinia ha robado mi objetivo (Lich King) con Provocación",
	["Darinia taunted my mob (The Lich King) with Taunt"] = "Darinia ha provocado a mi objetivo (Lich King) con Provocación",
	["Darinia taunted my target (The Lich King) with Taunt"] = "Darinia ha provocado a mi objetivo (Lich King) con Provocación",
	["Dashboard columns"] = "Columnas del panel",
	["Dashboard mouse button actions options"] = "Panel de opciones de acciones de los botones del ratón",
	["Dashboard scale"] = "Escala Panel de Control", -- Needs review
	["Death warnings"] = "Advertencias de muerte",
	-- ["Default order"] = "",
	["Disable scan in combat"] = "Deshabilitar escaneo en combate", -- Needs review
	["DPS mana"] = "Maná de los DPS",
	["Enable/disable buff check"] = "Habilitar/deshabilitar comprobación de mejoras",
	["Enable tank warnings including taunts, failed taunts and mob stealing"] = "Habilitar avisos te tanques incluyendo provocaciones, provocaciones falladas y robos",
	["Enable tank warnings including taunts, failed taunts and mob stealing only on bosses"] = "Habilitar avisos de tanques incluyendo provocaciones, provocaciones falladas y robos de jefes",
	["Enable warning messages when players die"] = "Activar mensaje alerta cuando un jugador muere",
	["Enable warnings when Crowd Control is broken by tanks and non-tanks"] = "Activar avisos cuando un Control de Masas es roto por tanques y no-tanques",
	["Enable warnings when Misdirection or Tricks of the Trade is cast"] = "Habilita los avisos cuando se usa Redirección o Secretos del Oficio",
	["Feast auto whisper"] = "Fiesta ( festin - food) auto susurro ",
	Feasts = "Festín",
	["Food announce"] = "Anunciar comida",
	-- Friends = "",
	-- ["Grouping style"] = "",
	-- ["Guild members"] = "",
	["Healer death"] = "Healer muerto",
	-- ["Healer drinking"] = "",
	-- ["Healer drinking sound"] = "",
	["Healer mana"] = "Maná de los curadores",
	["Healers alive"] = "Curadores vivos",
	["Healer Stormsnow has died!"] = "¡El Healer Stormsnow ha muerto!",
	["Hide and show the buff report dashboard."] = "Mostrar/ocultar el panel del informe de mejoras",
	-- ["Hide Boss R Trash"] = "",
	["Hide dashboard during combat"] = "Ocultar Panel de control en combate", -- Needs review
	["Hide in combat"] = "Ocultar en combate", -- Needs review
	["Hide the buff report dashboard."] = "Ocultar el panel del informe de mejoras",
	["Highlight my buffs"] = "Destacar mis mejoras",
	["Hightlight currently missing buffs on the dashboard for which you are responsible including self buffs and buffs which you are missing that are provided by someone else. I.e. show buffs for which you must take action"] = "Destacar en el panel las mejoras que faltan de las cuales tu eres el responsable incluyendo las propias. p.ej. muestra las mejoras que tu debes llevar a cabo",
	["How MANY?"] = "Cuantos són MUCHOS?",
	["Ignore groups 6 to 8"] = "Ignorar grupos 6 al 8",
	["Ignore groups 6 to 8 when reporting as these are for subs"] = "Ignorar grupos 6 al 8 cuando se informa siendo estos para subs",
	["[IMMUNE] Danielbarron FAILED TO TAUNT their target (The Lich King) with Hand of Reckoning"] = "[INMUNE] Danielbarron HA FALLADO la provocación de su objetivo (Lich King) con Mano de Expiación",
	["In range"] = "En rango",
	-- invite = "",
	["Just my buffs"] = "Sólo mis buffs",
	["Left click"] = "Clic izquierdo",
	["Melee DPS Danielbarron has died!"] = "DPS cuerpo a cuerpo (refriega)  \"xx\" ha muerto!",
	["Melee DPS death"] = "Melé DPS muerto",
	["Minimap icon"] = "Icono del minimapa",
	-- ["Minimum remaining buff duration in minutes. Buffs with less than this will be considered as missing.  This option only takes affect when the corresponding 'buff' button is enabled on the dashboard."] = "",
	-- ["Min remaining buff duration"] = "",
	["Misdirection warnings"] = "Advertencias de Redirección",
	["Mouse buttons"] = "Botones del ratón",
	["Move with Alt-click"] = "Mover con Alt-Click",
	-- ["My buffs"] = "",
	["Ninja taunts"] = "Robos",
	-- ["No healer close"] = "",
	None = "Ninguna",
	["Non-tank breaks CC"] = "Rompedores de CC NO-Tanques",
	["Non-tank Glamor broke Hex on The Lich King with Moonfire"] = "Los No tanques",
	["NON-TANK Tanagra taunted my target (The Lich King) with Growl"] = "El NO-TANQUE Tanagra ha provocado mi objetivo (Lich King) con Bramido",
	["Non-tank taunts my target"] = "Un no-tanque ha provacado mi objetivo",
	["Number of columns to display on the dashboard"] = "Numero de columnas a mostrar en el panel",
	["Old flasks and elixirs"] = "Antiguos Frascos y Elixires",
	-- ["One big group"] = "",
	-- ["One group down"] = "",
	["Only if all have it"] = "Sólo si todos tienen",
	["Only me"] = "Sólo yo",
	["Only show the buffs for which your class is responsible for.  This configuration can be used like a buff-bot where one simply right clicks on the buffs to cast them"] = "Mostrar sólo los Beneficios de la que su clase es responsable. Esta configuración se puede utilizar como un Mejora-bot donde uno simplemente hace clic derecho sobre los Beneficios para lanzar", -- Needs review
	["Only show the core class raid buffs"] = "Solo muestra el Núcleo Beneficios de banda de Clase", -- Needs review
	["Only show when you and only you break Crowd Control so you can say 'Now I don't believe you wanted to do that did you, ehee?'"] = [=[Solo mostrar cuando tu y solo tu has roto el control de masas , entonces puedes decir " Ahora yo no creo que tu quisieras hacer lo que tu hicieste eh?" 
is nice to traslate this hehe.]=],
	["Only use tank list"] = "Solo usar Lista de tanques",
	["Only use the tank list and ignore spec when there is a tank list for determining if someone is a tank or not"] = "Solo usar la lista de tanques e ignorar especificaciones cuando hay una lista de tanques para determinar si alguien es tanque o no",
	-- ["Options for automatically opening the dashboard and moving it"] = "",
	["Options for setting the quality requirements of consumables"] = "Opciones para establecer la calidad requerida de consumibles",
	["Options to do with configuring the tank list"] = "Opciones para configurar la lista de tanques",
	-- Other = "",
	["Other taunt fails"] = "Otros fallos en provocaciones",
	["Play a sound"] = "Hacer un sonido",
	["Play a sound when a healer dies"] = "Reproduce un sonido cuando un Healer muere",
	-- ["Play a sound when a healer drinks and is not full on mana"] = "",
	["Play a sound when a melee DPS dies"] = "Reproduce un sonido cuando un DPS melee muere",
	["Play a sound when a non-tank breaks Crowd Control"] = "Reproducir un sonido cuando un no-tanque rompe un Control de Masas",
	["Play a sound when a ranged DPS dies"] = "Activa uin sonido cuando DPS distancia muera",
	["Play a sound when a tank breaks Crowd Control"] = "Reproducir un sonido cuando un tanque rompe un Control de Masas",
	["Play a sound when a tank dies"] = "Reproduce un sonido cuando un Tanque muere",
	["Play a sound when Misdirection or Tricks of the Trade is cast"] = "Reproducir un sonido cuando se usa Redirección o Secretos del Oficio",
	["Play a sound when one of your taunts fails due to resist"] = "Reproducir un sonido cuando uno de tus taunts falla al ser resistido",
	["Play a sound when one of your taunts fails due to the target being immune"] = "Hacer un sonido cuando tu provocación falla debido a que el objetivo es inmune",
	["Play a sound when other people's taunts to your target fail"] = "Hacer un sonido cuando las provocaciones de otros fallan en tu objetivo",
	["Play a sound when someone else targets a mob and taunts that mob which is targeting you"] = "Hacer un sonido cuando alguien selecciona y provoca tu objetivo el cual te tenía a ti como blanco",
	["Play a sound when someone else taunts your target"] = "Hacer un sonido cuando alguien provoca tu objetivo",
	["Play a sound when someone else taunts your target which is targeting you"] = "Hacer un sonido cuando algien roba tu objetivo el cual te tenía a ti como blanco",
	["Play a sound when someone else who is not a tank taunts your target"] = "Hacer un sonido cuando alguien no-tanque provoca tu objetivo",
	["Prepend RBS::"] = "Anteponer RBS::",
	["Prepend RBS:: to all lines of report chat. Disable to only prepend on the first line of a report"] = "Anteponer RBS:: a todas las líneas del informe en el chat. Desabilitar para anteponer solo en la primera línea del informe",
	["Raid health"] = "Salud de la banda",
	["Raid leader"] = "Líder de banda",
	["Raid mana"] = "Maná de la banda",
	["Raid Status Bars"] = "Barras de estado de la banda",
	-- ["Raid-wide buffs"] = "",
	["Ranged DPS death"] = "DPS a distancia Muerto",
	["Ranged DPS Garmann has died!"] = "DPS distancia \"xx\" ha muerto",
	["Refreshment Table"] = "Mesa de Refrigerio",
	["Repair Bot"] = "Robot de Reparación",
	Reporting = "Informe",
	["Reporting options"] = "Opciones del informe",
	["Report missing to raid"] = "Informar lo que falta a banda",
	["Report to officer channel"] = "Informar en el canal de oficiales",
	["Report to officers"] = "Informar a oficiales",
	["Report to /raid or /party who is not buffed to the max."] = "Informar a /banda o /grupo quien no esta mejorado al máximo",
	["Report to raid/party"] = "Informar a banda/grupo",
	["Report to raid/party - requires raid assistant"] = "Informar a banda/grupo - requiere ser asistente de banda",
	["Report to self"] = "Informar a uno mismo",
	-- ["Required food quality"] = "",
	["Require the Alt buton to be held down to move the dashboard window"] = "Requiere mantener presionada tecla Alt para mover la ventana del tablero",
	["[RESIST] Danielbarron FAILED TO TAUNT their target (The Lich King) with Hand of Reckoning"] = "[RESISTIDO]Danielbarron HA FALLADO EL PROVOCAR en su objetivo (El Rey Exánime) con Mano de Expiación",
	["[RESIST] Darinia FAILED TO TAUNT my target (The Lich King) with Taunt"] = "[RESISTIDO] Darinia HA FALLADO la provocación de mi objetivo (Lich King) con Provocación",
	["Right click"] = "Clic derecho",
	["Scale the Buff Options window"] = "Escala la ventana de Opciones de Beneficios", -- Needs review
	["Scale the dashboard window"] = "Escala ventana de Panel de control", -- Needs review
	["Seconds between updates"] = "Segundos entre actualizaciones",
	["Select which action to take when you click with the left mouse button over a dashboard buff check"] = "Seleccionar que acción realizar con el clic izquierdo del ratón en el panel de comprobación de mejoras",
	["Select which action to take when you click with the left mouse button with Alt held down over a dashboard buff check"] = "Seleccionar que acción realizar con el clic alt-izquierdo del ratón en el panel de comprobación de mejoras",
	["Select which action to take when you click with the left mouse button with Ctrl held down over a dashboard buff check"] = "Seleccionar que acción realizar con el clic Ctrl-izquierdo del ratón en el panel de comprobación de mejoras",
	["Select which action to take when you click with the left mouse button with Shift held down over a dashboard buff check"] = "Seleccionar que acción realizar con el clic shift-izquierdo del ratón en el panel de comprobación de mejoras",
	["Select which action to take when you click with the right mouse button over a dashboard buff check"] = "Seleccionar que acción realizar con el clic derecho del ratón en el panel de comprobación de mejoras",
	["Select which action to take when you click with the right mouse button with Alt held down over a dashboard buff check"] = "Seleccionar que acción realizar con el clic alt-derecho del ratón en el panel de comprobación de mejoras",
	["Select which action to take when you click with the right mouse button with Ctrl held down over a dashboard buff check"] = "Seleccionar que acción realizar con el clic Ctrl-derecho del ratón en el panel de comprobación de mejoras",
	["Select which action to take when you click with the right mouse button with Shift held down over a dashboard buff check"] = "Seleccionar que acción realizar con el clic shift-derecho del ratón en el panel de comprobación de mejoras",
	-- ["Select which level of food quality you require for the raiders to be considered 'Well Fed'"] = "",
	-- ["Self buffs"] = "",
	["Set how many seconds between dashboard raid scan updates"] = "Establecer los segundos entre escaneos del panel para actualizar banda",
	["Set N - the number of people missing a buff considered to be \"MANY\""] = "Establecer N - el numero de personas sin beneficio que sera considerado \"MUCHOS\"",
	["Shift-left click"] = "Clic shift-izquierdo",
	["Shift-right click"] = "Clic shift-derecho",
	["Shorten names"] = "Acortar nombres",
	["Shorten names in the report to reduce channel spam"] = "Acortar nombres en el informe para reducir 'spam' en el canal",
	["Show group number"] = "Mostrar numero del grupo",
	["Show in battleground"] = "Mostrar en Campos de Batalla",
	["Show in party"] = "Mostrar en grupo",
	["Show in raid"] = "Mostrar en banda",
	["Show the buff report dashboard."] = "Mostrar el panel del informe de mejoras",
	["Show the group number of the person missing a party/raid buff"] = "Mostrar numero del grupo de la persona a la que le falta una mejora",
	-- ["Single target buffs"] = "",
	["Skin and minimap options"] = "Aspecto y opciones del minimapa",
	-- ["Skin and scaling"] = "",
	["Skip buff checking during combat. You can manually initiate a scan by pressing Scan on the dashboard"] = "Saltar comprobación Beneficios durante el combate. Puede iniciar manualmente un escaneo pulsando Escanear en el panel", -- Needs review
	-- ["%s minutes"] = "",
	-- ["Sort buff buttons by"] = "",
	["Soul Well"] = "Pozo de Almas",
	["Status bars to show raid, dps, tank health, mana, etc"] = "Barras de estado que muestran la banda, dps, vida del tanque, mana, etc",
	["Tank breaks CC"] = "Tanque rompe CC",
	["Tank Danielbarron has died!"] = "¡El Tanque Danielbarron ha muerto!",
	["Tank death"] = "Tanque muerto",
	["Tank health"] = "Salud de los tanques",
	["Tank list"] = "Lista de tanques",
	["Tanks alive"] = "Tanques vivos",
	["Tank warnings"] = "Avisos del tanque",
	["Tank warnings about taunts, failed taunts and mob stealing including accidental taunts from non-tanks"] = "Avisos del tanque sobre provocaciones, provocaciones falladas y robos incluyendo provocaciones accidentales de no-tanques",
	["Taunts to my mobs"] = "Provocaciones en mis objetivos",
	["Taunts to my target"] = "Provocaciones a mi objetivo",
	["Tells you when someone in your party, raid or guild has a newer version of RBS installed"] = "Te avisa cuando alguien en tu grupo, banda o hermandad tiene una versión nueva de RBS instalada",
	-- ["Tells you when someone in your party, raid or guild has RBS installed"] = "",
	Test = "Muestra",
	["Test what the warning is like"] = "Muestra como és el aviso",
	["The average DPS mana percent"] = "Promedio de maná de los DPS en porcentaje",
	["The average healer mana percent"] = "Promedio de maná de los curadores en porcentaje",
	["The average party/raid health percent"] = "Promedio de salud del grupo/banda en porcentaje",
	["The average party/raid mana percent"] = "Promedio del maná del grupo/banda en porcentaje",
	["The average tank health percent"] = "Pormedio de salud de los tanques en porcentaje",
	["The Buff Wizard automatically configures the dashboard buffs and configuration defaults for your class or raid leading role."] = "El Asistente Beneficios configura automáticamente los Beneficios del panel y los valores predeterminados de configuración para su Clase o Líder de Raid", -- Needs review
	-- ["Then sort buff buttons by"] = "",
	["The percentage of healers alive in the raid"] = "Porcentaje de curadores vivos en la banda",
	["The percentage of people alive in the raid"] = "Porcentaje de jugadores vivos en la banda",
	["The percentage of people dead in the raid"] = "El porcentaje de gente muerta en la banda",
	["The percentage of people within 40 yards range"] = "El porcentaje de gente a menos de 40 metros de rango",
	["The percentage of tanks alive in the raid"] = "Porcentaje de tanques vivos en la banda",
	["This is the default configuration in which RBS ships out-of-the-box.  It gives you pretty much anything a raid leader would need to see on the dashboard"] = "Esta es la configuración por defecto en el que RBS se distribuye fuera de la caja. Le da más o menos todo lo que un líder de banda tendría que ver en el panel de control", -- Needs review
	["Toggle to display a minimap icon"] = "Conmutar para mostrar icono del minimapa",
	-- Top = "",
	-- ["To set this option go to the addon configuration.  This button is automatically enabled when the Boss button is pressed and automatically disabled when the Trash button is pressed.  To permanently disable, choose 0 seconds as the min remaining buff duration."] = "",
	-- ["Two groups down"] = "",
	-- ["User announce"] = "",
	["Version announce"] = "Anunciar versión",
	["Wait before announcing to see if others have announced first in order to reduce spam"] = "Esperar antes de anunciar para ver si otros han anunciado antes con motivo de reducir el spam",
	["Warning messages when players die"] = "Mensages de Alerta cuando un Jugador/a muere",
	["Warnings when Crowd Control is broken by tanks and non-tanks"] = "Advertencias cuando un tanque o no-tanque rompe un Control de Masas",
	["Warnings when Misdirection or Tricks of the Trade is cast"] = "Avisar cuando se usa Redirección o Secretos del Oficio",
	["Warnings when someone else targets a mob and taunts that mob which is targeting you"] = "Avisos cuando alguien selecciona y provoca tu objetivo el cual te tenía a ti como blanco",
	["Warnings when someone else taunts your target"] = "Avisos cuando alguien provoca tu objetivo",
	["Warnings when someone else taunts your target who is not a tank"] = "Avisos cuando alguien no-tanque provoca tu objetivo",
	-- ["Warning, Trash, Boss groups"] = "",
	["Warns when a non-tank breaks Crowd Control"] = "Advierte cuando un no-tanque rompe un Control de Masas",
	["Warns when a tank breaks Crowd Control"] = "Advierte cuando un tanque rompe un Control de Masas",
	["Warns when other people's taunts to your target fail"] = "Avisar cuando las provocaciones de otros fallan en tu objetivo",
	["Warns when someone else taunts your target which is targeting you"] = "Avisar cuando algien roba tu objetivo el cual te tenía a ti como blanco",
	["Warns when your taunts fail due to resist"] = "Advierte cuando sus provocar fallan debido a resistir", -- Needs review
	["Warns when your taunts fail due to the target being immune"] = "Avisar cuando tu provocación falla debido a que el objetivo es inmune",
	["Warn to party"] = "Avisar a grupo",
	["Warn to party when a healer dies"] = "Advertir al grupo cuando un Healer muere",
	["Warn to party when a melee DPS dies"] = "Advertir al grupo cuando un DPS melee muere",
	["Warn to party when a non-tank breaks Crowd Control"] = "Avisar al grupo cuando un no-tanque rompe un Control de Masas",
	["Warn to party when a ranged DPS dies"] = "Alertar al Grupo cuando DPS a distancia muere",
	["Warn to party when a tank breaks Crowd Control"] = "Avisar al grupo cuando un tanque rompe un Control de Masas",
	["Warn to party when a tank dies"] = "Advertir al grupo cuando un Tanque muere",
	["Warn to party when one of your taunts fails due to resist"] = "Avisar al grupo cuando uno de tus taunts falla al ser resistido",
	["Warn to party when one of your taunts fails due to the target being immune"] = "Avisar a grupo cuando tu provocación falla debido a que el objetivo es inmune",
	["Warn to party when other people's taunts to your target fail"] = "Avisar a grupo cuando las provocaciones de otros fallan en tu objetivo",
	["Warn to party when someone else targets a mob and taunts that mob which is targeting you"] = "Avisar a grupo cuando alguien selecciona y provoca tu objetivo el cual te tenía a ti como blanco",
	["Warn to party when someone else taunts your target"] = "Avisar a grupo cuando alguien provoca tu objetivo",
	["Warn to party when someone else taunts your target which is targeting you"] = "Avisar a grupo cuando algien roba tu objetivo el cual te tenía a ti como blanco",
	["Warn to party when someone else who is not a tank taunts your target"] = "Avisar a grupo cuando alguien no-tanque provoca tu objetivo",
	["Warn to raid chat"] = "Avisar en el chat de banda",
	["Warn to raid chat when a healer dies"] = "Alertar en el chat de Raid cuando un Sanador muere",
	["Warn to raid chat when a melee DPS dies"] = "Alertar en el chat de Raid cuando un Dps cuerpo a cuerpo (refriega) muere",
	["Warn to raid chat when a non-tank breaks Crowd Control"] = "Alerta en chat de raid cuando un no tanque rompe el control de masas",
	["Warn to raid chat when a ranged DPS dies"] = "Advertir por el chat de banda cuando un DPS ranged muere",
	["Warn to raid chat when a tank breaks Crowd Control"] = "Avisar por el chat de banda cuando un tanque rompe un Control de Masas",
	["Warn to raid chat when a tank dies"] = "Alertar en el chat de Raid cuando un tanque muere",
	["Warn to raid chat when one of your taunts fails due to resist"] = "Avisar por el chat de raid cuando uno de tus taunts falla al ser resistido",
	["Warn to raid chat when one of your taunts fails due to the target being immune"] = "Avisar en el chat de banda cuando una de tus provocaciones falla debido a que el objetivo es inmune",
	["Warn to raid chat when other people's taunts to your target fail"] = "Avisar en el chat de banda cuando la provocacion de otro falla en tu objetivo",
	["Warn to raid chat when someone else targets a mob and taunts that mob which is targeting you"] = "Avisar en el chat de banda cuando alguien selecciona y provoca tu objetivo el cual te tenía a ti como blanco",
	["Warn to raid chat when someone else taunts your target"] = "Avisar en el chat de banda cuando algien provoca tu objetivo",
	["Warn to raid chat when someone else taunts your target which is targeting you"] = "Avisar en el chat de banda cuando alguien provoca tu objetivo el cual te tenía a ti como blanco",
	["Warn to raid chat when someone else who is not a tank taunts your target"] = "Avisar en el chat de banda cuando alguien no-tanque provoca tu objetivo",
	["Warn to raid warning"] = "Aviso a banda",
	["Warn to self"] = "Avisar a uno mismo",
	["Warn to self when a healer dies"] = "Alertarme cuando un Sanador muere",
	["Warn to self when a melee DPS dies"] = "Alertarme cuando un Dps cuerpo a cuerpo (refriega) muere",
	["Warn to self when a non-tank breaks Crowd Control"] = "Avisar a uno mismo cuando un NO_tanque rompa CC",
	["Warn to self when a ranged DPS dies"] = "Advertirme cuando un DPS ranged muere",
	["Warn to self when a tank breaks Crowd Control"] = "Avisar a uno mismo cuando un tanque rompa CC",
	["Warn to self when a tank dies"] = "Alertarme cuando tanque muere",
	["Warn to self when Misdirection or Tricks of the Trade is cast"] = "Avisarme a mi mismo cuando se usa Redirección o Secretos del Oficio",
	["Warn to self when one of your taunts fails due to resist"] = "Avisarse a uno mismo cuando uno de tus taunts falle al ser resistido",
	["Warn to self when one of your taunts fails due to the target being immune"] = "Avisar a uno mismo cuando tu provocación falla debido a que el objetivo es inmune",
	["Warn to self when other people's taunts to your target fail"] = "Avisar a uno mismo cuando las provocaciones de otros fallan en tu objetivo",
	["Warn to self when someone else targets a mob and taunts that mob which is targeting you"] = "Avisar a uno mismo cuando alguien selecciona y provoca tu objetivo el cual te tenía a ti como blanco",
	["Warn to self when someone else taunts your target"] = "Avisar a uno mismo cuando alguien provoca tu objetivo",
	["Warn to self when someone else taunts your target which is targeting you"] = "Avisar a uno mismo cuando algien roba tu objetivo el cual te tenía a ti como blanco",
	["Warn to self when someone else who is not a tank taunts your target"] = "Avisar a uno mismo cuando alguien no-tanque provoca tu objetivo",
	["Warn using raid warning when a healer dies"] = "Alertar usando Alerta de Raid cuando Sanador/a muere",
	["Warn using raid warning when a melee DPS dies"] = "Alertar usando Alerta de Raid cuando Dps Melee muere",
	["Warn using raid warning when a non-tank breaks Crowd Control"] = "Advertir usando un aviso de banda cuando un no-tanque rompe un Control de Masas",
	["Warn using raid warning when a ranged DPS dies"] = "Advertir usando un aviso de banda cuando un DPS ranged muere",
	["Warn using raid warning when a tank breaks Crowd Control"] = "Advertir usando un aviso de banda cuando un tanque rompe un Control de Masas",
	["Warn using raid warning when a tank dies"] = "Alertar usando Alerta de Raid cuando tanque muere",
	["Warn using raid warning when one of your taunts fails due to resist"] = "Avisar usando aviso de banda cuando uno de tus taunts falla al ser resistido",
	["Warn using raid warning when one of your taunts fails due to the target being immune"] = "Avisar a banda cuando tu provocación falla debido a que el objetivo es inmune",
	["Warn using raid warning when other people's taunts to your target fail"] = "Avisar a banda cuando las provocaciones de otros fallan en tu objetivo",
	["Warn using raid warning when someone else targets a mob and taunts that mob which is targeting you"] = "Avisar a banda cuando alguien selecciona y provoca tu objetivo el cual te tenía a ti como blanco",
	["Warn using raid warning when someone else taunts your target"] = "Avisar a banda cuando alguien provoca tu objetivo",
	["Warn using raid warning when someone else taunts your target which is targeting you"] = "Avisar a banda cuando algien roba tu objetivo el cual te tenía a ti como blanco",
	["Warn using raid warning when someone else who is not a tank taunts your target"] = "Avisar a banda cuando alguien no-tanque provoca tu objetivo",
	["Warn when a healer dies"] = "Advertir cuando un Healer muere",
	["Warn when a melee DPS dies"] = "Advertir cuando un DPS melee muere",
	["Warn when a ranged DPS dies"] = "Advertir cuando un DPS ranged muere",
	["Warn when a tank dies"] = "Advertir cuando un Tanque muere",
	["Well auto whisper"] = "Auto susurro de Pozo",
	["When at least N people are missing a raid buff say MANY instead of spamming a list"] = "Cuando al menos a N personas les falten mejoras decir MUCHOS en vez de 'spamear' una lista",
	["When many say so"] = "Decir cuando hay muchos",
	["When there are multiple people who can provide a missing buff such as Fortitude then only whisper one of them at random who is in range rather than all of them"] = "Cuando hay varias personas que pueden proporcionar un Beneficio que falta como Fortaleza entonces sólo susurrar uno de ellos al azar que está en rango en lugar de todos ellos", -- Needs review
	["When whispering and at least N people are missing a raid buff say MANY instead of spamming a list"] = "Al susurrar al menos N personas a las que le falta una mejora decir MUCHOS en vez de 'spamear' una lista",
	["Whisper buffers"] = "Susurrar a mejoradores",
	["Whisper many"] = "Susurrar muchos",
	["Whisper only one"] = "Susurrar solo a uno", -- Needs review
	["Your taunt immune-fails"] = "Tu provocación ha fallado - inmune",
	["Your taunt resist-fails"] = "Tu provocar es resistido-fallado",
}
La.RaidStatusBars = {
	["Dead healers"] = "Curadores muertos",
	["Dead tanks"] = "Tanques muertos",
	["I see dead people"] = "A veces veo muertos",
	["n/a"] = "n/a",
	-- P = "",
	-- ["Pull Timer"] = "",
	R = "L", -- Needs review
	-- ["Ready Check"] = "",
}
La.TalentsWindow = {
	Class = "Clase",
	Healer = "Healer",
	["Melee DPS"] = "Melé DPS",
	Name = "Nombre",
	["Ranged DPS"] = "DPS a distancia",
	Refresh = "Actualizar",
	Role = "Rol",
	Spec = "Espec",
	Specialisations = "Especialización",
	["Talent Specialisations"] = "Talentos",
	Tank = "Tanque",
}
La.TankTauntWarnings = {
	["NON-TANK %s taunted my boss target (%s%s%s) with %s"] = [=[NO-TANQUE %s Provoca mi Objetivo Jefe (%s%s%s) con %s
]=], -- Needs review
	["NON-TANK %s taunted my target (%s%s%s) with %s"] = [=[NO-TANQUE %s Provoca mi Objetivo (%s%s%s) con %s
]=], -- Needs review
	-- ["%s FAILED TO NINJA my boss target (%s%s%s) with %s"] = "",
	["%s FAILED TO NINJA my target (%s%s%s) with %s"] = "%s HA FALLADO AL NINJEARME mi objetivo (%s%s%s) con %s",
	["%s FAILED TO TAUNT my boss target (%s%s%s) with %s"] = "%s FALLO A PROVOCAR mi Boss Objetivo (%s%s%s) con %s", -- Needs review
	["%s FAILED TO TAUNT my target (%s%s%s) with %s"] = [=[%s FALLO A PROVOCAR  mi Objetivo (%s%s%s) con %s
]=], -- Needs review
	["%s FAILED TO TAUNT their boss target (%s%s%s) with %s"] = "%s HA FALLADO AL PROVOCAR al boss objetivo (%s%s%s) con %s",
	["%s FAILED TO TAUNT their target (%s%s%s) with %s"] = "%s HA FALLADO AL PROVOCAR a su objetivo (%s%s%s) con %s",
	["%s ninjaed my boss target (%s%s%s) with %s"] = "%s ha ninjeado mi boss objetivo (%s%s%s) con %s",
	["%s ninjaed my target (%s%s%s) with %s"] = "%s ha ninjeado mi objetivo (%s%s%s) con %s",
	["%s taunted my boss mob (%s%s%s) with %s"] = "%s ha provocado a mi boss objetivo (%s%s%s) con %s",
	["%s taunted my boss target (%s%s%s) with %s"] = "%s ha provocado a mi boss objetivo (%s%s%s) con %s",
	["%s taunted my mob (%s%s%s) with %s"] = "%s ha provocado a mi objetivo (%s%s%s) con %s",
	["%s taunted my target (%s%s%s) with %s"] = "%s Provoca mi objetivo (%s%s%s) con %s", -- Needs review
}

elseif locale == "zhTW" then do end
La["Announce even when you don't have assist or lead"] = "即使當你不是助理或領隊也通告"
La["Announce expiration"] = "通告過期的"
La["Announcement options for raid utilities like Feasts"] = "團隊助益通告選項如：盛宴"
La["Announce to raid warning when a %s is prepared"] = "當%s準備好時發出團隊警告"
La["Announce to raid warning when a utility is expiring"] = "當一個消耗品要過期了通告到團隊警告頻道"
La["Announce without lead"] = "不是領隊時也通告"
La["Augment Banquet Tooltips"] = "加強盛宴提示"
La["Augment Banquet Tooltips with stat bonus information"] = "盛宴加強提示屬姓加成資訊"
-- La["Augment Rune"] = ""
La["Blingtron"] = "布靈頓"
La["Blingtron about to expire!"] = "布靈頓就要消失了！"
La["Bonus"] = "加成"
La["Broken Link"] = "破損的連結"
La["casts %s"] = "施放 %s"
La["Eating"] = "進食中"
La["Expiration announcements"] = "過期通告"
La[" has set us up a Blingtron"] = "已放置了一個布靈頓"
La["has set us up a %s"] = "放置了一個%s"
La["Mailbox"] = "信箱"
La["Noodle Cart"] = "拉麵餐車"
La["Portal"] = "傳送門"
La["Prefer Static Buff"] = "偏好的靜態增益"
La["Report missing static buffs even when an equivalent passive aura is already present."] = "報告缺少的靜態增益即使當一個同等的被動光環已經存在。"
-- La["Required flask quality"] = ""
La["Right-click to target"] = "右鍵點擊目標"
-- La["Select which level of flask quality you require"] = ""
La["sets up a %s"] = "放置一個 %s"
La["Show configuration options"] = "顯示設置選項"
La["Soulwell"] = "靈魂井"
La["Tooltip name coloring"] = "提示姓名著色"
La["Tooltip role icons"] = "提示角色類型圖標"
La["Treat eating as Well Fed"] = "進食中比照充分進食處理"
La["Treat players who are currently eating as Well Fed. This assumes they are eating acceptable food."] = "進食中的玩家當作已經有充分進食增益，這是假設他們吃的是可接受的食物。"
La["Utility announcements"] = "助益通告"
La["Warrior Stance"] = "戰士姿態" -- Needs review
La.BuffOptionsWindow = {
	["Buff Options"] = "增益選項",
	["Is a buff"] = "增益",
	["Is a warning"] = "警告",
	["Report on Boss"] = "報告於首領",
	["Report on Trash"] = "報告於小怪",
	["Show on dashboard"] = "報告於設定介面",
	["Show/Report in combat"] = "在戰鬥中顯示/報告",
}
La.CrowdControlWarnings = {
	["Melee Swing"] = "近戰錯誤",
	["Non-tank %s broke %s on %s%s%s"] = "非坦克>%s<破除%s於%s%s%s",
	["Non-tank %s broke %s on %s%s%s with %s"] = "非坦克>%s<破除%s於%s%s%s使用%s",
	["%s broke %s on %s%s%s"] = ">%s<破除%s於%s%s%s",
	["%s broke %s on %s%s%s with %s"] = ">%s<破除%s於%s%s%s使用%s",
}
La.Messages = {
	AFK = "暫離",
	Agil = "敏",
	alpha = "測試版",
	["Alt-Click on a party buff will cast on someone missing that buff."] = "Alt+點擊一個隊伍增益將會施放於缺少此增益的其他人。",
	["Alt-Click on a self buff will renew that buff."] = "Alt+點擊一個自己的增益將會更新此增益。",
	["Aspect Cheetah/Pack On"] = "獵豹/豹群守護開啟",
	["Aspect of the Cheetah or Pack is on"] = "獵豹/豹群守護開啟中",
	["Battle Elixir"] = "作戰藥劑",
	beta = "試用版",
	["Blessing of Kings is not needed because you are grouped with a Druid."] = "王者祝福已不需要因為隊伍裡有德魯伊。",
	["Blessing of Kings, with this raid configuration, is better provided by Drums of the Forgotten Kings thus allowing Blessing of Might to be used."] = "王者祝福，在此團隊配置的，若少部分的人已有遺忘諸王之鼓的話則允許使用其他祝福。",
	Boss = "首領",
	["Buffers: "] = "增益者",
	["Buffing Kings:"] = "增益王者：",
	["Buffing Might:"] = "增益大師：",
	["Cast by:"] = "施放者：",
	["Click buffs to disable and enable."] = "停用或啟用點擊增益。",
	["Click to toggle the RBS dashboard"] = "點擊後切換至RBS設定介面",
	["Ctrl-Click Boss or Trash to whisper all those who need to buff."] = "Ctrl+點擊首領或小兵戰密語給增益者說誰需要增益",
	["Ctrl-Click buffs to whisper those who need to buff."] = "Ctrl+點擊增益密語給增益者說誰需要增益",
	Dead = "死亡",
	["Death Knight Presence"] = "死亡騎士在場",
	["Different Zone"] = "不同區域",
	["Flasked or Elixired but slacking"] = "沒有喝精鍊或藥劑",
	["Flask or two Elixirs"] = "精鍊或兩種藥劑",
	["Guardian Elixir"] = "守護藥劑",
	["Has buff: "] = "已有增益:",
	[" has set us up a Refreshment Table"] = " 召喚了餐點桌",
	[" has set us up a Repair Bot"] = " 召喚了修理機器人",
	[" has set us up a Soul Well"] = " 召喚了靈魂之井",
	["Healer %s has died!"] = "治療者>%s<已經死亡!",
	["Health less than 80%"] = "血量低於80%",
	-- ["Hide outgoing whispers"] = "",
	["Hunter Aspect"] = "獵人守護",
	["Hunter has no aspect at all"] = "獵人沒開守護",
	["[IMMUNE]"] = "[免疫]",
	Int = "智",
	[" in their bags"] = "位於背包",
	["Invite auto-accepted from battle.net friend %s."] = "自動接受戰網好友%s邀請。",
	["Invite auto-accepted from friend %s."] = "自動接受好友%s邀請。",
	["Invite auto-accepted from guild member %s."] = "自動接受公會成員%s邀請。",
	["Item count: "] = "物品堆疊:",
	["Low durability"] = "低耐久度",
	["Low durability (35% or less)"] = "低耐久度 (35%或更低)",
	["Mage is missing a Mage Armor"] = "法師沒有護甲術",
	["Mana less than 80%"] = "法力低於80%",
	["MANY!"] = "很多!",
	["Melee DPS %s has died!"] = "進戰DPS>%s<已經死亡!",
	["Missing "] = "缺少",
	["Missing a scroll"] = "缺少卷軸",
	["Missing buff: "] = "缺少增益:",
	["Missing buffs (Boss): "] = "缺少增益 (首領): ",
	["Missing buffs (Trash): "] = "缺少增益 (小怪): ",
	["Missing or not working oRA or RBS: "] = "缺少或沒執行oRA or RBS:",
	No = "否",
	["No buffs needed! (Boss)"] = "沒有需要的增益! (首領)",
	["No buffs needed! (Trash)"] = "沒有需要的增益! (小怪)",
	["No Soulstone detected"] = "沒檢測到靈魂石",
	["Not Well Fed"] = "沒有充分進食",
	Offline = "離線",
	["Out of range"] = "超出範圍",
	["Paladin blessing"] = "聖騎祝福",
	["Paladin missing Seal"] = "聖騎缺少聖印",
	["Player has a wrong Paladin blessing"] = "玩家有錯誤的聖騎祝福",
	["Player has health less than 80%"] = "玩家血量低於80%",
	["Player has mana less than 80%"] = "玩家法力低於80%",
	["Player is AFK"] = "玩家暫離",
	["Player is Dead"] = "玩家死亡",
	["Player is in a different zone"] = "玩家在不同區域",
	["Player is missing at least one Paladin blessing"] = "玩家至少缺少一種聖騎祝福",
	["Player is Offline"] = "玩家離線",
	["Please relog or reload UI to update the item cache."] = "請重新儲存或重新載入插件來更新物品的快取。",
	["prepares a %s!"] = "準備了%s！",
	["Press Escape -> Interface -> AddOns -> RaidBuffStatus for more options."] = "按 Esc -> 介面 -> 插件 -> RaidBuffStatus 來設定更多選項。",
	Prot = "防",
	["Protection Paladin with no Righteous Fury"] = "防騎沒開正義之怒",
	["PVP is On"] = "PVP狀態開啟",
	["PVP On"] = "PVP開啟",
	["Ranged DPS %s has died!"] = "遠程DPS>%s<已經死亡!",
	["RBS Dashboard Help"] = "RBS設定介面協助",
	["RBS Tank List"] = "RBS坦克名單",
	["Refreshment Table about to expire!"] = "餐點桌即將消失了!",
	["Remind me later"] = "以後提醒我",
	["(Remove buff)"] = "(移除增益)",
	["Remove this button from this dashboard in the buff options window."] = "在增益選項視窗中從設定介面移除此按紐",
	["Repair Bot about to expire!"] = "修理機器人即將消失了!",
	["[RESIST]"] = "[抵抗]",
	["Right-click to open the addons options menu"] = "右鍵點擊開啟插件選項選單",
	["%s about to expire!"] = "%s要過期了！",
	Scan = "掃瞄",
	["%s cast %s on %s"] = "%s施放>%s<於%s",
	Scroll = "捲軸",
	Seal = "聖印",
	-- ["Sent %d whispers to %d players"] = "",
	["%s has a newer (%s) version of RBS (%s) than you (%s)"] = "%s已有新的(%s)的RBS(%s)的版本，你的為(%s)",
	["Shift-Click buffs to report on only that buff."] = "Shift+點擊報告增益只在此增益。",
	["%s is running RBS %s"] = "%s正在執行RBS %s",
	["Slackers: "] = "懶惰者:",
	["Slacking Paladins"] = "懶惰聖騎",
	["Sorry, I am queued for"] = "對不起，我正在排隊以下副本",
	["Sorry, I am queued for a battlefield."] = "對不起，我在戰場排隊序列中。",
	["Sorry, the group is now full."] = "對不起，隊伍已滿。",
	["Soul Well about to expire!"] = "靈魂之井即將消失了!",
	Spi = "精",
	Sta = "耐",
	Str = "力",
	["Tank missing Earth Shield"] = "坦克缺少大地之盾",
	["Tank missing Thorns"] = "坦克缺少荊棘術",
	["Tank %s has died!"] = "坦克>%s<已經死亡!",
	["Tank with "] = "坦克使用 ",
	["The above default button actions can be reconfigured."] = "預設的按鍵動作是可以被重新設置的。",
	["This is the first time RaidBuffStatus has been activated since installation or settings were reset. Would you like to visit the Buff Wizard to help you get RBS buffs configured? If you are a raid leader then you can click No as the defaults are already set up for you."] = "這是第一次安裝並執行RaidBuffStatus或設定被重置。你想要訪問增益助手來幫助你獲得RBS的增益配置?如果你是個團隊隊長則你可以點擊你已經設定好的預設值為'否'。",
	["Tol Barad"] = "托巴拉德",
	Trash = "小怪",
	["Warning: "] = "警告: ",
	["Warnings: "] = "警告的: ",
	["Weapon buff"] = "武器增益",
	["Well Fed but slacking"] = "有低等級的充分進食效果",
	Wintergrasp = "冬握湖",
	["Wrong flask for this zone"] = "在該區域使用錯誤的精鍊",
	["Wrong Paladin blessing"] = "錯誤的聖騎祝福",
	["You need to be leader or assistant to do this"] = "你需要團隊隊長或團隊助理權限",
	["You need to whisper the leader instead: "] = "你需要對隊長密語：",
}
La.Options = {
	Alive = "存活",
	["Allow raiders to use flasks and elixirs from last expansion"] = "允許團隊成員使用上個資料片的精鍊和藥劑",
	["Alt-left click"] = "Alt+左鍵點擊",
	["Alt-right click"] = "Alt+右鍵點擊",
	["Always hide the Boss R Trash buttons"] = "總是隱藏首領 R 小兵按鈕",
	["Announce to raid warning when a Feast is prepared"] = "當準備好一個盛宴時提示到團隊警告中",
	["Anti spam"] = "反垃圾訊息",
	Appearance = "外觀",
	["Auto-accept invites"] = "自動接收邀請",
	["Auto-invite whispers"] = "密語自動邀請",
	["Automatically accept invites from friends and guild members so you can go for a bio-break whilst waiting for a raid invite"] = "忙於其他事情時自動接受好友和公會成員組隊邀請",
	["Automatically accept invites from these"] = "自動接受這些邀請",
	["Automatically configures the dashboard buffs and configuration defaults for your class or raid leading role"] = "自動配置設定介面上的增益及配置你的職業或團隊隊長角色為預設值",
	["Automatically invite friends and guild members who whisper to you the word 'invite'"] = "朋友和公會成員使用密語「invite」時自動邀請",
	["Automatically invite these"] = "自動邀請這些",
	["Automatically show the dashboard when you join a battleground"] = "當你加入到戰場時自動顯示設定介面",
	["Automatically show the dashboard when you join a party"] = "當你加入到隊伍時自動顯示設定介面",
	["Automatically show the dashboard when you join a raid"] = "當你加入到團隊時自動顯示設定介面",
	["Automatically whisper anyone missing a Healthstone when your Soul Well expire warnings appear"] = "當你的靈魂之井即將消失的警告出現時自動密語給沒有治療石的人",
	["Automatically whisper anyone missing flasks or elixirs when your Cauldron expire warnings appear"] = "當你的大鍋將要消失的警報出現後自動密語沒有藥瓶或藥劑效果的人",
	["Automatically whisper anyone missing Well Fed when your Feast expire warnings appear"] = "當你的盛宴即將消失的警告出現時自動密語給沒有食物效果的人",
	Automation = "自動",
	["Background colour"] = "背景著色",
	["Bar positioning"] = "條位置",
	["Battle.net friends"] = "戰網好友",
	["Border colour"] = "邊框著色",
	["Bosses only"] = "只在首領",
	Bottom = "底部",
	["Buff button sorting"] = "增益按鈕排序中",
	["Buff Options scale"] = "增益選項縮放",
	["Buff those missing buff"] = "施放缺少的增益",
	["Buff Wizard"] = "增益助手",
	Cauldron = "大鍋",
	["Cauldron auto whisper"] = "大鍋自動密語",
	["CC-break warnings"] = "破除控場警告",
	["Choose either one big collection of buff checks or traditional style with Warnings, Trash and Boss buff checks"] = "選取大集合的其中一個增益檢查或傳統樣式的警報，小怪和首領增益檢查",
	["Choose where on the dashboard the bars appear"] = "選取儀表板上條的位置",
	["Class-specific buffs"] = "職業特定增益",
	Combat = "戰鬥",
	["Combat options"] = "戰鬥選項",
	["Configure how the buff buttons and status bars on the dashboard are sorted and displayed"] = "設定儀表板上增益按鈕和狀態列的排序和顯示方式",
	["Consumable options"] = "消耗品選項",
	Consumables = "消耗品",
	["Core raid buffs"] = "團隊增益核心",
	["Ctrl-left click"] = "Ctrl+左鍵點擊",
	["Ctrl-right click"] = "Ctrl+右鍵點擊",
	["Danielbarron broke Sheep on The Lich King with Hand of Reckoning"] = ">Danielbarron<破除變羊術於巫妖王 使用清算聖禦",
	["Darinia ninjaed my target (The Lich King) with Taunt"] = "Darinia搶走我的目標(巫妖王)仇恨使用嘲諷",
	["Darinia taunted my mob (The Lich King) with Taunt"] = "Darinia嘲走我的怪(巫妖王)使用嘲諷",
	["Darinia taunted my target (The Lich King) with Taunt"] = "Darinia嘲走我的目標(巫妖王)使用嘲諷",
	["Dashboard columns"] = "設定介面列",
	["Dashboard mouse button actions options"] = "設定介面滑鼠動作按鈕選項",
	["Dashboard scale"] = "儀表板縮放",
	["Death warnings"] = "死亡警告",
	["Default order"] = "預設順序",
	["Disable scan in combat"] = "戰鬥中停用掃描",
	["DPS mana"] = "DPS法力",
	["Enable/disable buff check"] = "啟/停增益檢查",
	["Enable tank warnings including taunts, failed taunts and mob stealing"] = "啟用包含嘲諷，嘲諷失敗及搶仇恨的坦克警告",
	["Enable tank warnings including taunts, failed taunts and mob stealing only on bosses"] = "啟用只在首領包含嘲諷，嘲諷失敗及搶仇恨的坦克警告",
	["Enable warning messages when players die"] = "啟用當玩家死亡時的警告訊息",
	["Enable warnings when Crowd Control is broken by tanks and non-tanks"] = "啟用當控場技能被坦克及非坦克破除時警告",
	["Enable warnings when Misdirection or Tricks of the Trade is cast"] = "",
	["Feast auto whisper"] = "自動密語鮮魚宴",
	Feasts = "盛宴",
	["Food announce"] = "提示食物",
	Friends = "好友",
	["Grouping style"] = "組成樣式",
	["Guild members"] = "公會成員",
	["Healer death"] = "治療者死亡",
	["Healer drinking"] = "治療回魔中",
	["Healer drinking sound"] = "治療回魔音效",
	["Healer mana"] = "治療者法力",
	["Healers alive"] = "存活的治療者",
	["Healer Stormsnow has died!"] = "治療者>Stormsnow<已經死亡!",
	["Hide and show the buff report dashboard."] = "隱藏/顯示增益報告統計視窗",
	["Hide Boss R Trash"] = "隱藏首領 R 小兵",
	["Hide dashboard during combat"] = "戰鬥中隱藏設定介面",
	["Hide in combat"] = "戰鬥中隱藏",
	["Hide the buff report dashboard."] = "隱藏增益報告統計視窗",
	["Highlight my buffs"] = "高亮我的增益",
	["Hightlight currently missing buffs on the dashboard for which you are responsible including self buffs and buffs which you are missing that are provided by someone else. I.e. show buffs for which you must take action"] = "在設定介面上高亮當前你負責的缺少增益，包含自己的增益以及其他人可施放你也缺少的增益。即顯示你必須立即補上的增益",
	["How MANY?"] = "多少算很多?",
	["Ignore groups 6 to 8"] = "忽略6到8小隊",
	["Ignore groups 6 to 8 when reporting as these are for subs"] = "當報告時忽略6到8小隊因為這些為候補",
	["[IMMUNE] Danielbarron FAILED TO TAUNT their target (The Lich King) with Hand of Reckoning"] = "[免疫]Danielbarron嘲諷他們的目標失敗(巫妖王) 使用清算聖禦",
	["In range"] = "範圍內",
	invite = "邀請",
	["Just my buffs"] = "僅我的增益",
	["Left click"] = "左鍵點擊",
	["Melee DPS Danielbarron has died!"] = "進戰DPS>Danielbarron<已經死亡!",
	["Melee DPS death"] = "進戰DPS死亡",
	["Minimap icon"] = "小地圖圖示",
	["Minimum remaining buff duration in minutes. Buffs with less than this will be considered as missing.  This option only takes affect when the corresponding 'buff' button is enabled on the dashboard."] = "最小增益剩餘時間以分鐘計。增益小於此值將被考慮為無效。此選項只在儀表板上對應的'增益'按鈕已啟用時才有影響。",
	["Min remaining buff duration"] = "最小增益剩餘時間",
	["Misdirection warnings"] = "誤導警告",
	["Mouse buttons"] = "滑鼠按鍵",
	["Move with Alt-click"] = "Alt+點擊移動",
	["My buffs"] = "我的增益",
	["Ninja taunts"] = "搶仇恨嘲諷",
	["No healer close"] = "周圍沒有治療",
	None = "無",
	["Non-tank breaks CC"] = "非坦克破除控場",
	["Non-tank Glamor broke Hex on The Lich King with Moonfire"] = "非坦克>Glamor<破除妖術於巫妖王 使用月火術",
	["NON-TANK Tanagra taunted my target (The Lich King) with Growl"] = "非坦克>Tanagra<嘲走我的目標(巫妖王)使用低吼",
	["Non-tank taunts my target"] = "非坦克嘲諷我的目標",
	["Number of columns to display on the dashboard"] = "在設定介面上顯示列的數量",
	["Old flasks and elixirs"] = "舊版的精鍊和藥劑",
	["One big group"] = "一大組",
	["One group down"] = "一組之下",
	["Only if all have it"] = "只在如果全部都有了",
	["Only me"] = "只有我",
	["Only show the buffs for which your class is responsible for.  This configuration can be used like a buff-bot where one simply right clicks on the buffs to cast them"] = "只顯示那些你負責施放的增益。這些配置就好像是打地鼠一樣簡單使用滑鼠右鍵點擊你就能施放給他們了",
	["Only show the core class raid buffs"] = "只顯示基本的職業團隊增益",
	["Only show when you and only you break Crowd Control so you can say 'Now I don't believe you wanted to do that did you, ehee?'"] = "只顯示當你及只有你破除控場技能時你可以說'我真不敢相信你居然會這樣做，你瘋了嗎?'",
	["Only use tank list"] = "只使用坦克名單",
	["Only use the tank list and ignore spec when there is a tank list for determining if someone is a tank or not"] = "只使用坦克名單及忽略配置依照坦克名單來確定其他人是否為坦克",
	["Options for automatically opening the dashboard and moving it"] = "自動開啟儀表板並移動選項",
	["Options for setting the quality requirements of consumables"] = "設定消耗品品質需求選項",
	["Options to do with configuring the tank list"] = "配置坦克名單選項",
	Other = "其它",
	["Other taunt fails"] = "其他嘲諷失敗",
	["Play a sound"] = "播放音效",
	["Play a sound when a healer dies"] = "當一個治療者死亡時播放音效",
	["Play a sound when a healer drinks and is not full on mana"] = "當治療回魔並法力未滿時播放音效",
	["Play a sound when a melee DPS dies"] = "當一個進戰DPS死亡時播放音效",
	["Play a sound when a non-tank breaks Crowd Control"] = "當一個非坦克破除控場時播放音效",
	["Play a sound when a ranged DPS dies"] = "當一個遠程DPS死亡時播放音效",
	["Play a sound when a tank breaks Crowd Control"] = "當一個坦克破除控場時播放音效",
	["Play a sound when a tank dies"] = "當一個坦克死亡時播放音效",
	["Play a sound when Misdirection or Tricks of the Trade is cast"] = "當誤導或偷天換日施放時播放音效",
	["Play a sound when one of your taunts fails due to resist"] = "當你的嘲諷因為抵抗而失敗時播放音效",
	["Play a sound when one of your taunts fails due to the target being immune"] = "當你的嘲諷因為目標免疫而失敗時播放音效",
	["Play a sound when other people's taunts to your target fail"] = "當其他人嘲諷你的目標失敗時播放音效",
	["Play a sound when someone else targets a mob and taunts that mob which is targeting you"] = "當其他人設定一個怪物為目標並嘲諷，而該怪物的目標為你時播放音效",
	["Play a sound when someone else taunts your target"] = "當其他人嘲諷你的目標時播放音效",
	["Play a sound when someone else taunts your target which is targeting you"] = "當其他人嘲諷你的目標並且目標為你時播放音效",
	["Play a sound when someone else who is not a tank taunts your target"] = "當不是坦克的其他人嘲諷你的目標時播放音效",
	["Prepend RBS::"] = "前面加上RBS::",
	["Prepend RBS:: to all lines of report chat. Disable to only prepend on the first line of a report"] = "在每行報告前面加上RBS::。若停用則只在第一行報告的前面加上",
	["Raid health"] = "團隊治療者",
	["Raid leader"] = "團隊隊長",
	["Raid mana"] = "團隊法力",
	["Raid Status Bars"] = "團隊狀態條",
	["Raid-wide buffs"] = "大團隊增益",
	["Ranged DPS death"] = "遠程DPS死亡",
	["Ranged DPS Garmann has died!"] = "遠程DPS>Garmann<已經死亡!",
	["Refreshment Table"] = "餐點桌",
	["Repair Bot"] = "修理機器人",
	Reporting = "報告中",
	["Reporting options"] = "報告中選項",
	["Report missing to raid"] = "報告缺少到團隊",
	["Report to officer channel"] = "報告到幹部頻道",
	["Report to officers"] = "報告到幹部",
	["Report to /raid or /party who is not buffed to the max."] = "報告到團隊或隊伍誰沒有最大化增益",
	["Report to raid/party"] = "報告到團隊/隊伍",
	["Report to raid/party - requires raid assistant"] = "報告到團隊/隊伍 - 需要團隊助理權限",
	["Report to self"] = "報告到自己",
	["Required food quality"] = "需要食物品質",
	["Require the Alt buton to be held down to move the dashboard window"] = "需要按住Alt鍵才能移動設定介面視窗",
	["[RESIST] Danielbarron FAILED TO TAUNT their target (The Lich King) with Hand of Reckoning"] = "[抵抗]Danielbarron嘲諷他們的目標失敗(巫妖王)使用清算聖禦",
	["[RESIST] Darinia FAILED TO TAUNT my target (The Lich King) with Taunt"] = "[抵抗]Darinia嘲諷我的目標失敗(巫妖王)使用嘲諷",
	["Right click"] = "右鍵點擊",
	["Scale the Buff Options window"] = "縮放增益選項視窗",
	["Scale the dashboard window"] = "縮放儀表板視窗",
	["Seconds between updates"] = "更新間隔",
	["Select which action to take when you click with the left mouse button over a dashboard buff check"] = "當滑鼠左鍵點擊設定介面上的增益檢查時選擇執行的動作",
	["Select which action to take when you click with the left mouse button with Alt held down over a dashboard buff check"] = "當Alt+左鍵點擊設定介面上的增益檢查時選擇執行的動作",
	["Select which action to take when you click with the left mouse button with Ctrl held down over a dashboard buff check"] = "當Ctrl+左鍵點擊設定介面上的增益檢查時選擇執行的動作",
	["Select which action to take when you click with the left mouse button with Shift held down over a dashboard buff check"] = "當Shift+左鍵點擊設定介面上的增益檢查時選擇執行的動作",
	["Select which action to take when you click with the right mouse button over a dashboard buff check"] = "當滑鼠右鍵點擊設定介面上的增益檢查時選擇執行的動作",
	["Select which action to take when you click with the right mouse button with Alt held down over a dashboard buff check"] = "當Alt+右鍵點擊設定介面上的增益檢查時選擇執行的動作",
	["Select which action to take when you click with the right mouse button with Ctrl held down over a dashboard buff check"] = "當Ctrl+右鍵點擊設定介面上的增益檢查時選擇執行的動作",
	["Select which action to take when you click with the right mouse button with Shift held down over a dashboard buff check"] = "當Shift+右鍵點擊設定介面上的增益檢查時選擇執行的動作",
	["Select which level of food quality you require for the raiders to be considered 'Well Fed'"] = "選取何種讓團隊成員「充分進食」的食物等級品質",
	["Self buffs"] = "自身增益",
	["Set how many seconds between dashboard raid scan updates"] = "在設定介面上團隊掃描更新設定間隔多少秒",
	["Set N - the number of people missing a buff considered to be \"MANY\""] = "設定N - 缺少增益的人數超過這個數字時被顯示為\"很多\"。",
	["Shift-left click"] = "Shift+左鍵點擊",
	["Shift-right click"] = "Shift+右鍵點擊",
	["Shorten names"] = "簡短名稱",
	["Shorten names in the report to reduce channel spam"] = "在報告時為避免過多的垃圾訊息始用簡短名稱",
	["Show group number"] = "顯示團體成員",
	["Show in battleground"] = "戰場中顯示",
	["Show in party"] = "隊伍中顯示",
	["Show in raid"] = "團隊中顯示",
	["Show the buff report dashboard."] = "顯示增益報告統計視窗",
	["Show the group number of the person missing a party/raid buff"] = "顯示團隊成員所缺少的隊伍/團隊增益的人",
	["Single target buffs"] = "單目標增益",
	["Skin and minimap options"] = "面板及小地圖選項",
	["Skin and scaling"] = "皮膚和縮放",
	["Skip buff checking during combat. You can manually initiate a scan by pressing Scan on the dashboard"] = "戰鬥中忽略增益檢查。在儀表板可以手動點擊[掃描]以開始掃瞄。",
	["%s minutes"] = "%s分鐘",
	["Sort buff buttons by"] = "增益按鈕排序為",
	["Soul Well"] = "靈魂之井",
	["Status bars to show raid, dps, tank health, mana, etc"] = "狀態條可顯示團隊，DPS，坦克生命，法力等等",
	["Tank breaks CC"] = "坦克破除控場",
	["Tank Danielbarron has died!"] = "坦克>Danielbarron<已死亡!",
	["Tank death"] = "坦克死亡",
	["Tank health"] = "坦克生命",
	["Tank list"] = "坦克名單",
	["Tanks alive"] = "坦克存活",
	["Tank warnings"] = "坦克警告",
	["Tank warnings about taunts, failed taunts and mob stealing including accidental taunts from non-tanks"] = "坦克警告內容有嘲諷，嘲諷失敗及搶仇恨也包含從非坦克中無意嘲諷到怪",
	["Taunts to my mobs"] = "嘲諷到我的怪",
	["Taunts to my target"] = "嘲諷到我的目標",
	["Tells you when someone in your party, raid or guild has a newer version of RBS installed"] = "當你的隊伍/團隊或公會中有人安裝了新版本的RBS時告訴你",
	["Tells you when someone in your party, raid or guild has RBS installed"] = "小隊，團隊或公會有人安裝 RBS 時告知",
	Test = "測試",
	["Test what the warning is like"] = "測試警告是什麼樣子",
	["The average DPS mana percent"] = "DPS法力的平均百分比",
	["The average healer mana percent"] = "治療者法力的平均百分比",
	["The average party/raid health percent"] = "隊伍/團隊生命的平均百分比",
	["The average party/raid mana percent"] = "隊伍/團隊法力的平均百分比",
	["The average tank health percent"] = "坦克生命的平均百分比",
	["The Buff Wizard automatically configures the dashboard buffs and configuration defaults for your class or raid leading role."] = "增益助手自動配置設定介面上的增益及配置你的職業或團隊隊長角色為預設值。",
	["Then sort buff buttons by"] = "增益按鈕排序為",
	["The percentage of healers alive in the raid"] = "團隊中治療者存活的百分比",
	["The percentage of people alive in the raid"] = "團隊中所有人存活的百分比",
	["The percentage of people dead in the raid"] = "在團隊中死亡的百分比人數",
	["The percentage of people within 40 yards range"] = "在40碼範圍內的百分比人數",
	["The percentage of tanks alive in the raid"] = "團隊中坦克存活的百分比",
	["This is the default configuration in which RBS ships out-of-the-box.  It gives you pretty much anything a raid leader would need to see on the dashboard"] = "在RBS的面板中出現的所有按鈕皆為預設的配置。身為團隊隊長需要查看所有事物在設定介面上。",
	["Toggle to display a minimap icon"] = "切換顯示小地圖按鈕",
	Top = "頂部",
	["To set this option go to the addon configuration.  This button is automatically enabled when the Boss button is pressed and automatically disabled when the Trash button is pressed.  To permanently disable, choose 0 seconds as the min remaining buff duration."] = "要設定此選項請到插件設置。當首領按鈕被按下時此按鈕會自動啟用並當小怪按鈕被按下時自動禁用。要永久禁用，選取0秒作為其最小剩餘增益時間。",
	["Two groups down"] = "兩組之下",
	["User announce"] = "使用者通報",
	["Version announce"] = "版本提示",
	["Wait before announcing to see if others have announced first in order to reduce spam"] = "提示前等待看看是否有其他人已先提示避免過多的垃圾訊息",
	["Warning messages when players die"] = "當玩家死亡時顯示警告訊息",
	["Warnings when Crowd Control is broken by tanks and non-tanks"] = "當坦克及非坦克破除控場時警告",
	["Warnings when Misdirection or Tricks of the Trade is cast"] = "當誤導及偷天換日施放時警告",
	["Warnings when someone else targets a mob and taunts that mob which is targeting you"] = "當其他人的目標怪並嘲諷該怪的目標為你時警告",
	["Warnings when someone else taunts your target"] = "當其他人嘲諷你的目標時警告",
	["Warnings when someone else taunts your target who is not a tank"] = "當不是坦克的其他人嘲諷你的目標時警告",
	["Warning, Trash, Boss groups"] = "警報，小怪，首領組",
	["Warns when a non-tank breaks Crowd Control"] = "當非坦克破除控場時警告",
	["Warns when a tank breaks Crowd Control"] = "當坦克破除控場時警告",
	["Warns when other people's taunts to your target fail"] = "當其他人嘲諷你的目標失敗時警告",
	["Warns when someone else taunts your target which is targeting you"] = "當其他人嘲諷你的目標並且目標為你時警告",
	["Warns when your taunts fail due to resist"] = "當你的嘲諷因為抵抗而失敗時警告",
	["Warns when your taunts fail due to the target being immune"] = "當你的嘲諷因為目標免疫而失敗時警告",
	["Warn to party"] = "警告到隊伍",
	["Warn to party when a healer dies"] = "當一個治療者死亡時警告到隊伍",
	["Warn to party when a melee DPS dies"] = "當一個進戰DPS死亡時警告到隊伍",
	["Warn to party when a non-tank breaks Crowd Control"] = "當非坦克破除控場時警告到隊伍",
	["Warn to party when a ranged DPS dies"] = "當一個遠程DPS死亡時警告到隊伍",
	["Warn to party when a tank breaks Crowd Control"] = "當坦克破除控場時警告到隊伍",
	["Warn to party when a tank dies"] = "當一個坦克死亡時警告到隊伍",
	["Warn to party when one of your taunts fails due to resist"] = "當你的嘲諷因為抵抗而失敗時警告到隊伍",
	["Warn to party when one of your taunts fails due to the target being immune"] = "當你的嘲諷因為目標免疫而失敗時警告到隊伍",
	["Warn to party when other people's taunts to your target fail"] = "當其他人嘲諷你的目標失敗時警告到隊伍",
	["Warn to party when someone else targets a mob and taunts that mob which is targeting you"] = "當其他人的目標怪並嘲諷該怪的目標為你時警告到隊伍",
	["Warn to party when someone else taunts your target"] = "當其他人嘲諷你的目標時警告到隊伍",
	["Warn to party when someone else taunts your target which is targeting you"] = "當其他人嘲諷你的目標並且目標為你時警告到隊伍",
	["Warn to party when someone else who is not a tank taunts your target"] = "當不是坦克的其他人嘲諷你的目標時警告到隊伍",
	["Warn to raid chat"] = "警告到團隊",
	["Warn to raid chat when a healer dies"] = "當一個治療者死亡時警告到團隊",
	["Warn to raid chat when a melee DPS dies"] = "當一個進戰DPS死亡時警告到團隊",
	["Warn to raid chat when a non-tank breaks Crowd Control"] = "當非坦克破除控場時警告到團隊",
	["Warn to raid chat when a ranged DPS dies"] = "當一個遠程DPS死亡時警告到團隊",
	["Warn to raid chat when a tank breaks Crowd Control"] = "當坦克破除控場時警告到團隊",
	["Warn to raid chat when a tank dies"] = "當一個坦克死亡時警告到團隊",
	["Warn to raid chat when one of your taunts fails due to resist"] = "當你的嘲諷因為抵抗而失敗時警告到團隊",
	["Warn to raid chat when one of your taunts fails due to the target being immune"] = "當你的嘲諷因為目標免疫而失敗時警告到團隊",
	["Warn to raid chat when other people's taunts to your target fail"] = "當其他人嘲諷你的目標失敗時警告到團隊",
	["Warn to raid chat when someone else targets a mob and taunts that mob which is targeting you"] = "當其他人的目標怪並嘲諷該怪的目標為你時警告到團隊",
	["Warn to raid chat when someone else taunts your target"] = "當其他人嘲諷你的目標時警告到團隊",
	["Warn to raid chat when someone else taunts your target which is targeting you"] = "當其他人嘲諷你的目標並且目標為你時警告到團隊",
	["Warn to raid chat when someone else who is not a tank taunts your target"] = "當不是坦克的其他人嘲諷你的目標時警告到團隊",
	["Warn to raid warning"] = "警告到團隊警告",
	["Warn to self"] = "警告到自己",
	["Warn to self when a healer dies"] = "當一個治療者死亡時警告到自己",
	["Warn to self when a melee DPS dies"] = "當一個進戰DPS死亡時警告到自己",
	["Warn to self when a non-tank breaks Crowd Control"] = "當非坦克破除控場時警告到自己",
	["Warn to self when a ranged DPS dies"] = "當一個遠程DPS死亡時警告到自己",
	["Warn to self when a tank breaks Crowd Control"] = "當坦克破除控場時警告到自己",
	["Warn to self when a tank dies"] = "當一個坦克死亡時警告到自己",
	["Warn to self when Misdirection or Tricks of the Trade is cast"] = "當誤導或偷天換日施放時警告到自己",
	["Warn to self when one of your taunts fails due to resist"] = "當你的嘲諷因為抵抗而失敗時警告到自己",
	["Warn to self when one of your taunts fails due to the target being immune"] = "當你的嘲諷因為目標免疫而失敗時警告到自己",
	["Warn to self when other people's taunts to your target fail"] = "當其他人嘲諷你的目標失敗時警告到自己",
	["Warn to self when someone else targets a mob and taunts that mob which is targeting you"] = "當其他人的目標怪並嘲諷該怪的目標為你時警告到自己",
	["Warn to self when someone else taunts your target"] = "當其他人嘲諷你的目標時警告到自己",
	["Warn to self when someone else taunts your target which is targeting you"] = "當其他人嘲諷你的目標並且目標為你時警告到自己",
	["Warn to self when someone else who is not a tank taunts your target"] = "當不是坦克的其他人嘲諷你的目標時警告到自己",
	["Warn using raid warning when a healer dies"] = "當一個治療者死亡時警告並使用團隊警告",
	["Warn using raid warning when a melee DPS dies"] = "當一個進戰DPS死亡時警告並使用團隊警告",
	["Warn using raid warning when a non-tank breaks Crowd Control"] = "當非坦克破除控場時警告並使用團隊警告",
	["Warn using raid warning when a ranged DPS dies"] = "當一個遠程DPS死亡時使用團隊警告頻道警報",
	["Warn using raid warning when a tank breaks Crowd Control"] = "當坦克破除控場時警告並使用團隊警告",
	["Warn using raid warning when a tank dies"] = "當一個坦克死亡時使用團隊警告頻道警報",
	["Warn using raid warning when one of your taunts fails due to resist"] = "當你的嘲諷因為抵抗而失敗時使用團隊警告頻道警報",
	["Warn using raid warning when one of your taunts fails due to the target being immune"] = "當你的嘲諷因為目標免疫而失敗時警告並使用團隊警告",
	["Warn using raid warning when other people's taunts to your target fail"] = "當其他人嘲諷你的目標失敗時警告並使用團隊警告",
	["Warn using raid warning when someone else targets a mob and taunts that mob which is targeting you"] = "當其他人的目標怪並嘲諷該怪的目標為你時警告並使用團隊警告",
	["Warn using raid warning when someone else taunts your target"] = "當其他人嘲諷你的目標時警告並使用團隊警告",
	["Warn using raid warning when someone else taunts your target which is targeting you"] = "當其他人嘲諷你的目標並且目標為你時警告並使用團隊警告",
	["Warn using raid warning when someone else who is not a tank taunts your target"] = "當不是坦克的其他人嘲諷你的目標時警告並使用團隊警告",
	["Warn when a healer dies"] = "當一個治療者死亡時警告",
	["Warn when a melee DPS dies"] = "當一個進戰DPS死亡時警告",
	["Warn when a ranged DPS dies"] = "當一個遠程DPS死亡時警告",
	["Warn when a tank dies"] = "當一個坦克死亡時警告",
	["Well auto whisper"] = "自動密語靈魂之井",
	["When at least N people are missing a raid buff say MANY instead of spamming a list"] = "當至少N人缺少該團隊增益時說很多來取代一份清單",
	["When many say so"] = "當很多時說",
	["When there are multiple people who can provide a missing buff such as Fortitude then only whisper one of them at random who is in range rather than all of them"] = "當多人可提供缺少增益如堅韌禱言增益時，只隨機密語給他們之中處於距離範圍內的玩家。",
	["When whispering and at least N people are missing a raid buff say MANY instead of spamming a list"] = "當至少N人缺少該團隊增益並密語時說很多來取代一份清單",
	["Whisper buffers"] = "密語增益者",
	["Whisper many"] = "密語 很多",
	["Whisper only one"] = "只密語一人",
	["Your taunt immune-fails"] = "你的嘲諷失敗-免疫",
	["Your taunt resist-fails"] = "你的嘲諷失敗-抵抗",
}
La.RaidStatusBars = {
	["Dead healers"] = "治療者死亡",
	["Dead tanks"] = "坦克死亡",
	["I see dead people"] = "看見死亡人員",
	["n/a"] = "無",
	P = "開",
	["Pull Timer"] = "開怪計時器",
	R = "確",
	["Ready Check"] = "準備確認",
}
La.TalentsWindow = {
	Class = "職業",
	Healer = "治療者",
	["Melee DPS"] = "進戰DPS",
	Name = "玩家名稱",
	["Ranged DPS"] = "遠程DPS",
	Refresh = "重置",
	Role = "角色",
	Spec = "配",
	Specialisations = "配置",
	["Talent Specialisations"] = "天賦配置",
	Tank = "坦克",
}
La.TankTauntWarnings = {
	["NON-TANK %s taunted my boss target (%s%s%s) with %s"] = "[非坦克]%s嘲諷我的首領目標 >%s%s%s<！技能：%s",
	["NON-TANK %s taunted my target (%s%s%s) with %s"] = "非坦克%s嘲諷了我的目標(%s%s%s)使用%s",
	["%s FAILED TO NINJA my boss target (%s%s%s) with %s"] = "%s搶仇恨失敗於我的首領目標(%s%s%s)使用%s",
	["%s FAILED TO NINJA my target (%s%s%s) with %s"] = "%s搶仇恨失敗於我的目標(%s%s%s)使用%s",
	["%s FAILED TO TAUNT my boss target (%s%s%s) with %s"] = "%s嘲諷我的首領目標 >%s%s%s< 失敗！技能：%s",
	["%s FAILED TO TAUNT my target (%s%s%s) with %s"] = "%s嘲諷我的目標 >%s%s%s< 失敗！技能：%s",
	["%s FAILED TO TAUNT their boss target (%s%s%s) with %s"] = "%s嘲諷首領目標 >%s%s%s< 失敗！技能：%s",
	["%s FAILED TO TAUNT their target (%s%s%s) with %s"] = "%s嘲諷目標 >%s%s%s< 失敗！技能：%s",
	["%s ninjaed my boss target (%s%s%s) with %s"] = "%s搶走我的首領目標(%s%s%s)仇恨使用%s",
	["%s ninjaed my target (%s%s%s) with %s"] = "%s走我的目標(%s%s%s)仇恨使用%s",
	["%s taunted my boss mob (%s%s%s) with %s"] = "%s嘲諷我的首領怪 >%s%s%s< ！技能：%s",
	["%s taunted my boss target (%s%s%s) with %s"] = "%s嘲諷我的首領目標 >%s%s%s<！技能：%s",
	["%s taunted my mob (%s%s%s) with %s"] = "%s嘲諷我的小怪 >%s%s%s<！ 技能：%s",
	["%s taunted my target (%s%s%s) with %s"] = "%s嘲諷我的目標 >%s%s%s<！技能：%s",
}

elseif locale == "ptBR" then do end
La["Announce even when you don't have assist or lead"] = "Anúncia mesmo se você não for assistente ou líder"
La["Announce expiration"] = "Anunciar expiração"
La["Announcement options for raid utilities like Feasts"] = "Opções de anúncios para utilitários da raide como Banquetes"
La["Announce to raid warning when a %s is prepared"] = "Anúncia no alerta de raid quando um %s é preparado"
La["Announce to raid warning when a utility is expiring"] = "Anúncia no alerta de raid quando uma utilidade irá expirar"
La["Announce without lead"] = "Anúnciar sem liderança"
La["Augment Banquet Tooltips"] = "Dicas de aumento de banquetes"
La["Augment Banquet Tooltips with stat bonus information"] = "Dicas de aumento de banquetes com informação de bônus de status"
-- La["Augment Rune"] = ""
La["Blingtron"] = "Blingtron"
La["Blingtron about to expire!"] = "Blingtron está prestes a sumir!"
La["Bonus"] = "Bônus"
La["Broken Link"] = "Link Inválido"
La["casts %s"] = "conjurou %s"
La["Eating"] = "Comendo"
La["Expiration announcements"] = "Anúncios de expiração"
La[" has set us up a Blingtron"] = " colocou um Blingtron"
La["has set us up a %s"] = "colocou um %s"
La["Mailbox"] = "Caixa de Correio"
La["Noodle Cart"] = "Carrinho de Macarrão"
La["Portal"] = "Portal"
La["Prefer Static Buff"] = "Preferência por bônus estático"
La["Report missing static buffs even when an equivalent passive aura is already present."] = "Reportar bônus estáticos faltando mesmo quando uma aura passiva equivalente já está ativa."
La["Required flask quality"] = "Qualidade de frasco requerida"
La["Right-click to target"] = "Clique-Direito para fixar alvo"
La["Select which level of flask quality you require"] = "Selecione qual nivel de qualidade de frasco você requer"
La["sets up a %s"] = "colocou um %s"
La["Show configuration options"] = "Mostrar opções de configurações"
La["Soulwell"] = "Poço de Almas"
La["Tooltip name coloring"] = "Colorir nome nas dicas"
La["Tooltip role icons"] = "Icones de função nas dicas"
La["Treat eating as Well Fed"] = "Considerar comendo como Bem Alimentado"
La["Treat players who are currently eating as Well Fed. This assumes they are eating acceptable food."] = "Trata jogadores que estão ainda comendo como Bem Alimentado. Isso quer dizer que estão comendo alimento aceitável."
La["Utility announcements"] = "Anúncios de Utilidade"
La["Warrior Stance"] = "Postura do Guerrreiro"
La.BuffOptionsWindow = {
	["Buff Options"] = "Opções de bônus",
	["Is a buff"] = "Bônus",
	["Is a warning"] = "Avisos",
	["Report on Boss"] = "Reportar no chefe",
	["Report on Trash"] = "Reportar no Trash",
	["Show on dashboard"] = "Mostrar no menu",
	["Show/Report in combat"] = "Mostrar/Reportar em combate",
}
La.CrowdControlWarnings = {
	["Melee Swing"] = "Balanço Corpo a Corpo",
	["Non-tank %s broke %s on %s%s%s"] = "Não-tanquer %s quebrou %s em %s%s%s",
	["Non-tank %s broke %s on %s%s%s with %s"] = "Não-tanquer %s quebrou %s em %s%s%s com %s",
	["%s broke %s on %s%s%s"] = "%s quebrou %s em %s%s%s",
	["%s broke %s on %s%s%s with %s"] = "%s quebrou %s em %s%s%s com %s",
}
La.Messages = {
	AFK = "LDT",
	Agil = "Agil",
	alpha = "alpha",
	["Alt-Click on a party buff will cast on someone missing that buff."] = "Alt-Clique em um bônus de grupo irá lançar em alguem que ainda está sem este bônus.",
	["Alt-Click on a self buff will renew that buff."] = "Alt-Clique em um bônus seu irá renovar este bônus.",
	["Aspect Cheetah/Pack On"] = "Aspecto do Guepardo/Matilha Ativado",
	["Aspect of the Cheetah or Pack is on"] = "Aspecto do Guepardo ou Matilha está ativado",
	["Battle Elixir"] = "Elixir de Batalha",
	beta = "beta",
	["Blessing of Kings is not needed because you are grouped with a Druid."] = "Não é requerido Benção dos Reis porque você está em grupo com um Druida.",
	["Blessing of Kings, with this raid configuration, is better provided by Drums of the Forgotten Kings thus allowing Blessing of Might to be used."] = "Benção dos Reis, com esta configuração de raide, é melhor usado com Tambores dos Reis Esquecidos o que permite a Benção do Poder ser usada.",
	Boss = "Chefe",
	["Buffers: "] = "Bonificadores:",
	["Buffing Kings:"] = "Bonificando Benção dos Reis:",
	["Buffing Might:"] = "Bonificando Benção do Poder:",
	["Cast by:"] = "Usado por:",
	["Click buffs to disable and enable."] = "Clique nos bônus para desabilitar e habilitar.",
	["Click to toggle the RBS dashboard"] = "Clique para alternar a dashboard RBS",
	["Ctrl-Click Boss or Trash to whisper all those who need to buff."] = "Ctrl-Clique no Chefe ou Lixo para sussurrar todos que precisam bonificar.",
	["Ctrl-Click buffs to whisper those who need to buff."] = "Ctrl-Clique nos bônus para sussurrar aqueles que precisam bonificar.",
	Dead = "Morto",
	["Death Knight Presence"] = "Presença do Cavaleiro da Morte",
	["Different Zone"] = "Zona diferente",
	["Flasked or Elixired but slacking"] = "Usando frasco ou elixir porem de baixo nivel",
	["Flask or two Elixirs"] = "Frasco ou dois elixir",
	["Guardian Elixir"] = "Elixir do Guardião",
	["Has buff: "] = "Tem bônus:",
	[" has set us up a Refreshment Table"] = " colocou uma Mesa de Refeições",
	[" has set us up a Repair Bot"] = " colocou um Robô de Conserto",
	[" has set us up a Soul Well"] = " colocou um Poço das Almas",
	["Healer %s has died!"] = "Curador %s morreu!",
	["Health less than 80%"] = "Saúde abaixo de 80%",
	-- ["Hide outgoing whispers"] = "",
	["Hunter Aspect"] = "Aspecto do caçador",
	["Hunter has no aspect at all"] = "O caçador não possui nenhum aspecto",
	["[IMMUNE]"] = "[IMUNE]",
	Int = "Int",
	[" in their bags"] = " em suas mochilas",
	["Invite auto-accepted from battle.net friend %s."] = "Convite auto-aceitado do amigo battle.net %s.",
	["Invite auto-accepted from friend %s."] = "Convite auto-aceitado do amigo %s.",
	["Invite auto-accepted from guild member %s."] = "Convite auto-aceitado do membro de guilda %s.",
	["Item count: "] = "Contador de objetos:",
	["Low durability"] = "Pouca durabilidade",
	["Low durability (35% or less)"] = "Pouca durabilidade (35% ou menos)",
	["Mage is missing a Mage Armor"] = "O mago está sem Armadura de Mago",
	["Mana less than 80%"] = "Mana abaixo de 80%",
	["MANY!"] = "MUITOS!",
	["Melee DPS %s has died!"] = "DPS Corpo a Corpo %s morreu!",
	["Missing "] = "Faltando ",
	["Missing a scroll"] = "Faltando um pergaminho",
	["Missing buff: "] = "Bônus faltando:",
	["Missing buffs (Boss): "] = "Bônus faltando (Chefe):",
	["Missing buffs (Trash): "] = "Bônus faltando (Trash):",
	["Missing or not working oRA or RBS: "] = "Faltando ou RBS ou oRA não funcionando:",
	No = "Não",
	["No buffs needed! (Boss)"] = "Nenhum bônus faltando! (Chefe)",
	["No buffs needed! (Trash)"] = "Nenhum bônus faltando! (Trash)",
	["No Soulstone detected"] = "Nenhuma pedra da alma detectada",
	["Not Well Fed"] = "Não está Bem alimentado",
	Offline = "Desconectado",
	["Out of range"] = "Fora do alcance",
	["Paladin blessing"] = "Benção de paladino",
	["Paladin missing Seal"] = "Paladino sem Selo",
	["Player has a wrong Paladin blessing"] = "O jogador possui um benção de paladino errada",
	["Player has health less than 80%"] = "Jogador está com saúde abaixo de 80%",
	["Player has mana less than 80%"] = "Jogador está com mana abaixo de 80% ",
	["Player is AFK"] = "Jogador Ausente",
	["Player is Dead"] = "Jogador morto",
	["Player is in a different zone"] = "Jogador está em uma zona diferente",
	["Player is missing at least one Paladin blessing"] = "Jogador está faltando pelo menos uma benção de Paladino",
	["Player is Offline"] = "Jogador desconectado",
	["Please relog or reload UI to update the item cache."] = "Por favor reconecte ou recarregue a IU para atualizar o cache de itens.",
	["prepares a %s!"] = "preparou um %s!",
	["Press Escape -> Interface -> AddOns -> RaidBuffStatus for more options."] = "Pressione Esc -> Interface -> AddOns -> RaidBuffStatus para mais opções.",
	Prot = "Prot",
	["Protection Paladin with no Righteous Fury"] = "Paladino de Proteção sem Fúria Íntegra",
	["PVP is On"] = "JxJ está ligado",
	["PVP On"] = "JxJ ligado",
	["Ranged DPS %s has died!"] = "DPS de longo alcance %s morreu!",
	["RBS Dashboard Help"] = "Menu de ajuda do RBS",
	["RBS Tank List"] = "Lista de Tanquers RBS",
	["Refreshment Table about to expire!"] = "Mesa de Refeições está prestes a sumir!",
	["Remind me later"] = "Me lembre depois",
	["(Remove buff)"] = "(Remover bônus)",
	["Remove this button from this dashboard in the buff options window."] = "Remove este botão deste menu na janela de opções de bônus.",
	["Repair Bot about to expire!"] = "Robô de Conserto está prestes a sumir!",
	["[RESIST]"] = "[RESISTIU]",
	["Right-click to open the addons options menu"] = "Clique-Direito para abrir o menu de opções de addons",
	["%s about to expire!"] = "%s está prestes a sumir!",
	Scan = "Escanear",
	["%s cast %s on %s"] = "%s usou %s em %s",
	Scroll = "Pergaminho",
	Seal = "Selo",
	-- ["Sent %d whispers to %d players"] = "",
	["%s has a newer (%s) version of RBS (%s) than you (%s)"] = "%s tem uma nova (%s) versão do RBS (%s) que você (%s)",
	["Shift-Click buffs to report on only that buff."] = "Shift-Clique em um bônus para reportar somente este bônus.",
	["%s is running RBS %s"] = "%s está rodando RBS %s",
	["Slackers: "] = "Preguiçosos:",
	["Slacking Paladins"] = "Paladinos Preguiçosos",
	["Sorry, I am queued for"] = "Desculpe, Estou em fila para uma masmorra ou raide.",
	["Sorry, I am queued for a battlefield."] = "Desculpe, Estou em fila para um campo de batalha.",
	["Sorry, the group is now full."] = "Desculpe, o grupo está cheio agora.",
	["Soul Well about to expire!"] = "Poço das Almas está prestes a sumir!",
	Spi = "Espi",
	Sta = "Vig",
	Str = "For",
	["Tank missing Earth Shield"] = "Tanquers sem Escudo de Terra",
	["Tank missing Thorns"] = "Tanquers sem Espinhos",
	["Tank %s has died!"] = "Tanquer %s morreu!",
	["Tank with "] = "Tanquers com",
	["The above default button actions can be reconfigured."] = "O botão de ação padrão abaixo pode ser reconfigurado.",
	["This is the first time RaidBuffStatus has been activated since installation or settings were reset. Would you like to visit the Buff Wizard to help you get RBS buffs configured? If you are a raid leader then you can click No as the defaults are already set up for you."] = "Esta é a primeira vez que você ativou o RaidBuffStatus desde a instalação ou as configurações foram resetadas. Você gostaria de ir ao Configurador de Bônus(Buff Wizard) para ajuda-lo a configurar os RBS bônus? Se você é um lider de raide você pode clicar em Não que os padrões serão colocados para você.",
	["Tol Barad"] = "Tol Barad",
	Trash = "Trash",
	["Warning: "] = "Aviso:",
	["Warnings: "] = "Avisos:",
	["Weapon buff"] = "Bônus de arma",
	["Well Fed but slacking"] = "Bem alimentado porem preguiçoso",
	Wintergrasp = "Invérnia",
	["Wrong flask for this zone"] = "Frasco errado para esta zona",
	["Wrong Paladin blessing"] = "Benção de paladino errada",
	["You need to be leader or assistant to do this"] = "Você precisa ser lider ou assistente para fazer isso",
	["You need to whisper the leader instead: "] = "Você precisa sussurar o lider ao envés de mim.",
}
La.Options = {
	Alive = "Vivo",
	["Allow raiders to use flasks and elixirs from last expansion"] = "Permitir raiders usarem frasco e elixir nivel 80 WotLK",
	["Alt-left click"] = "Alt-clique esquerdo",
	["Alt-right click"] = "Alt-clique direito",
	["Always hide the Boss R Trash buttons"] = "Sempre esconder botões de Chefes TP? Trash",
	["Announce to raid warning when a Feast is prepared"] = "Anunciar no alerta de raide quando um Banquete for preparado",
	["Anti spam"] = "Anti spam",
	Appearance = "Aparência",
	["Auto-accept invites"] = "Auto-aceitar convites",
	["Auto-invite whispers"] = "Sussuros auto-convite",
	["Automatically accept invites from friends and guild members so you can go for a bio-break whilst waiting for a raid invite"] = "Aceitar automaticamente convites de amigos e membros de guilda então você pode fazer um pausa para ir ao banheiro quando esperando por convites de raide",
	["Automatically accept invites from these"] = "Aceitar automaticamente convites destes",
	["Automatically configures the dashboard buffs and configuration defaults for your class or raid leading role"] = "Configura automaticamente o menu de bônus e configurações padrões para sua classe ou função de lider de raide",
	["Automatically invite friends and guild members who whisper to you the word 'invite'"] = "Convidar automaticamente amigos e membros de guilda que sussurarem a palavra \"convite\" para você",
	["Automatically invite these"] = "Convidar automaticamente estes",
	["Automatically show the dashboard when you join a battleground"] = "Mostrar automaticamente o menu quando você entrar em um campo de batalha",
	["Automatically show the dashboard when you join a party"] = "Mostrar automaticamente o menu quando você entrar em um grupo",
	["Automatically show the dashboard when you join a raid"] = "Mostrar automaticamente o menu quando você entrar em um raide",
	["Automatically whisper anyone missing a Healthstone when your Soul Well expire warnings appear"] = "Sussura automaticamente alguem que está sem uma \"Pedra da Vida\" quando o aviso de expiração do Poço de Almas aparecer",
	["Automatically whisper anyone missing flasks or elixirs when your Cauldron expire warnings appear"] = "Sussura automaticamente qualquer um que esteja faltando frascos ou elixir quando a mensagem de expiração de Caldeirão aparecer",
	["Automatically whisper anyone missing Well Fed when your Feast expire warnings appear"] = "Sussura automaticamente alguem que está sem o bônus \"Bem alimentado\" quando o aviso de expiração de Banquetes aparecer",
	Automation = "Automação",
	["Background colour"] = "Cor de Fundo",
	["Bar positioning"] = "Posicionamento de barra",
	["Battle.net friends"] = "Amigos Battle.net",
	["Border colour"] = "Cor da borda",
	["Bosses only"] = "Somente Chefes",
	Bottom = "Inferior",
	["Buff button sorting"] = "Ordenando o botão de bônus",
	["Buff Options scale"] = "Tamanho de Opções de Bõnus",
	["Buff those missing buff"] = "Bonificar quem está sem o bônus",
	["Buff Wizard"] = "Configuração de Bônus",
	Cauldron = "Caldeirão",
	["Cauldron auto whisper"] = "Auto-sussuro Caldeirão",
	["CC-break warnings"] = "Aviso de quebradores de CC",
	["Choose either one big collection of buff checks or traditional style with Warnings, Trash and Boss buff checks"] = "Escolha entre uma grande coleção de checagem de bônus ou estilo tradicional com Avisos, Trash e checagem de bônus de Chefe",
	["Choose where on the dashboard the bars appear"] = "Escolha onde no menu as barras aparecem",
	["Class-specific buffs"] = "Bônus de classe-especifica",
	Combat = "Combate",
	["Combat options"] = "Opções de combate",
	["Configure how the buff buttons and status bars on the dashboard are sorted and displayed"] = "Configurar como os botões de bônus e barras de status serão ordenados e mostrados no menu",
	["Consumable options"] = "Opções de consumíveis",
	Consumables = "Consumíveis",
	["Core raid buffs"] = "Bônus do core de raide",
	["Ctrl-left click"] = "Ctrl-clique esquerdo",
	["Ctrl-right click"] = "Ctrl-clique direito",
	["Danielbarron broke Sheep on The Lich King with Hand of Reckoning"] = "Danielbarron quebrou a Transformação no Lich Rei com Ato de Bravura",
	["Darinia ninjaed my target (The Lich King) with Taunt"] = "Darinia ninjou meu alvo (Lich Rei) com Provocar",
	["Darinia taunted my mob (The Lich King) with Taunt"] = "Darinia provocou meu mob (Lich Rei) com Provocar",
	["Darinia taunted my target (The Lich King) with Taunt"] = "Darinia provocou meu alvo (Lich Rei) com Provocar",
	["Dashboard columns"] = "Colunas do Menu",
	["Dashboard mouse button actions options"] = "Opções das ações do botão do mouse no menu",
	["Dashboard scale"] = "Escala do menu",
	["Death warnings"] = "Avisos de mortes",
	["Default order"] = "Ordem padrão",
	["Disable scan in combat"] = "Desabilitar escaneamento em combate",
	["DPS mana"] = "Mana do DPS",
	["Enable/disable buff check"] = "Habilitar/desabilitar checagem de bônus",
	["Enable tank warnings including taunts, failed taunts and mob stealing"] = "Habilitar avisos de tanquers incluindo provocações, provocações falhas e roubo de mob",
	["Enable tank warnings including taunts, failed taunts and mob stealing only on bosses"] = "Habilitar avisos de tanquers incluindo provocações, provocações falhas e roubo de mob somente nos chefes",
	["Enable warning messages when players die"] = "Habilitar mensagens de aviso quando jogadores morrerem",
	["Enable warnings when Crowd Control is broken by tanks and non-tanks"] = "Habilitar avisos quando um Controle Coletivo for quebrado por tanquers e não-tanquers",
	["Enable warnings when Misdirection or Tricks of the Trade is cast"] = "Habilitar avisos quando Redirecionamentos ou Truques da Troca forem usados",
	["Feast auto whisper"] = "Auto-Sussuro de Banquetes",
	Feasts = "Banquetes",
	["Food announce"] = "Anunciar comida",
	Friends = "Amigos",
	["Grouping style"] = "Estilo de agrupamento",
	["Guild members"] = "Membros de guilda",
	["Healer death"] = "Curador morto",
	["Healer drinking"] = "Curador bebendo",
	["Healer drinking sound"] = "Som do curador bebendo",
	["Healer mana"] = "Mana do curador",
	["Healers alive"] = "Curadores vivos",
	["Healer Stormsnow has died!"] = "Curador Stormsnow morreu!",
	["Hide and show the buff report dashboard."] = "Esconder e mostrar a janela de reportagem de bônus",
	["Hide Boss R Trash"] = "Esconder Chefe TP? Trash",
	["Hide dashboard during combat"] = "Esconder menu durante combate",
	["Hide in combat"] = "Esconder em combate",
	["Hide the buff report dashboard."] = "Esconder janela de reportagem de bônus",
	["Highlight my buffs"] = "Destacar meus bônus",
	["Hightlight currently missing buffs on the dashboard for which you are responsible including self buffs and buffs which you are missing that are provided by someone else. I.e. show buffs for which you must take action"] = "Destacar os bônus perdidos atualmente no menu para qual você é responsavel incluindo bônus seus e bônus nos quais você está sem que estão send dados por algum I.e. mostrar bônus por quais você mais teve ação",
	["How MANY?"] = "Quanto é MUITO?",
	["Ignore groups 6 to 8"] = "Ignorar grupos 6 ao 8",
	["Ignore groups 6 to 8 when reporting as these are for subs"] = "Ignorar grupos 6 ao 8 quando reportando estes para subs",
	["[IMMUNE] Danielbarron FAILED TO TAUNT their target (The Lich King) with Hand of Reckoning"] = "[IMUNE] Danielbarron FALHOU AO PROVOCAR o alvo dele (Lich Rei) com Mão da Justiça",
	["In range"] = "Em distância",
	invite = "convite",
	["Just my buffs"] = "Somente meus bônus",
	["Left click"] = "Clique esquerdo",
	["Melee DPS Danielbarron has died!"] = "DPS Corpo a Corpo Danielbarron morreu!",
	["Melee DPS death"] = "DPS Corpo a Corpo morto",
	["Minimap icon"] = "Icone no mini-mapa",
	["Minimum remaining buff duration in minutes. Buffs with less than this will be considered as missing.  This option only takes affect when the corresponding 'buff' button is enabled on the dashboard."] = "Minutos minimos de duração de bônus restantes. Bônus com menos que isso são considerados como \"faltando\". Essa opção somente tem efeito quando o botão correspondendo a \"bônus\" está habilitado no menu.",
	["Min remaining buff duration"] = "Duração de bônus minima restando",
	["Misdirection warnings"] = "Avisos de Redirecionamento",
	["Mouse buttons"] = "Botões do mouse",
	["Move with Alt-click"] = "Mover com Alt-Clique",
	["My buffs"] = "Meus bônus",
	["Ninja taunts"] = "Provocações ninja",
	["No healer close"] = "Nenhum curador por perto",
	None = "Nenhum",
	["Non-tank breaks CC"] = "Quebradores de CC não-tanquers",
	["Non-tank Glamor broke Hex on The Lich King with Moonfire"] = "Não tanquer Glamor quebrou Bagata no Lich Rei com Fogo da Lua",
	["NON-TANK Tanagra taunted my target (The Lich King) with Growl"] = "NÃO-TANQUE Tanagra provocou meu alvo (Lich Rei) com Rugido",
	["Non-tank taunts my target"] = "Não-tanque provocou meu alvo",
	["Number of columns to display on the dashboard"] = "Número de colunas para mostrar no menu",
	["Old flasks and elixirs"] = "Frascos e elixir WotLK",
	["One big group"] = "Um grande grupo",
	["One group down"] = "Um grupo em baixo",
	["Only if all have it"] = "Somente se todos terem",
	["Only me"] = "Somente eu",
	["Only show the buffs for which your class is responsible for.  This configuration can be used like a buff-bot where one simply right clicks on the buffs to cast them"] = "Somente mostrar os bônus por quais sua classe são responsáveis. Esta configuração pode ser usada igual a um robô-bônus(buff-bot) onde uns simples cliques direitos no bônus os usam",
	["Only show the core class raid buffs"] = "Mostrar somente os bônus de Classe Raide Core",
	["Only show when you and only you break Crowd Control so you can say 'Now I don't believe you wanted to do that did you, ehee?'"] = "Somente mostrar quando você e somente você quebrar um CC então você pode dizer 'Agora acredito que você não queria fazer aquilo, queria hehe?'",
	["Only use tank list"] = "Usar somente lista de tanquers",
	["Only use the tank list and ignore spec when there is a tank list for determining if someone is a tank or not"] = "Usar somente a lista de tanquers e ignorar a espec de uma lista de tanquers que determinam se alguem é um tanquer ou não",
	["Options for automatically opening the dashboard and moving it"] = "Opções de abertura automatica de menu e locomoção",
	["Options for setting the quality requirements of consumables"] = "Opções para configurar a qualidade requerida dos consumíveis",
	["Options to do with configuring the tank list"] = "Opções para configurar a lista de tanquers",
	Other = "Outro",
	["Other taunt fails"] = "Outras provocações falhas",
	["Play a sound"] = "Tocar um som",
	["Play a sound when a healer dies"] = "Tocar um som quando um curador morrer",
	["Play a sound when a healer drinks and is not full on mana"] = "Tocar um som quando um curador beber e não está com mana completa",
	["Play a sound when a melee DPS dies"] = "Tocar um som quando um DPS Corpo a Corpo morrer",
	["Play a sound when a non-tank breaks Crowd Control"] = "Tocar um som quando um não-tanque quebrar CC",
	["Play a sound when a ranged DPS dies"] = "Tocar um som quando um DPS de longo alcance morrer",
	["Play a sound when a tank breaks Crowd Control"] = "Tocar um som quando um tanquer quebrar CC",
	["Play a sound when a tank dies"] = "Tocar um som quando um tanquer morrer",
	["Play a sound when Misdirection or Tricks of the Trade is cast"] = "Tocar um som quanbdo Redirecionamento ou Truques da Troca for usado",
	["Play a sound when one of your taunts fails due to resist"] = "Tocar um som quando uma de suas provocações falharem devido a resistência",
	["Play a sound when one of your taunts fails due to the target being immune"] = "Tocar um som quando um de suas provocações falharem devido do alvo ser imune",
	["Play a sound when other people's taunts to your target fail"] = "Tocar um som quando a provocação de outras pessoas falharem no seu alvo",
	["Play a sound when someone else targets a mob and taunts that mob which is targeting you"] = "Tocar um som quando alguem seleciona e provoca o mob que tinha você como alvo",
	["Play a sound when someone else taunts your target"] = "Tocar um som quando alguem provocar seu alvo",
	["Play a sound when someone else taunts your target which is targeting you"] = "Tocar um som quando as provocações de outras pessoas falharem no alvo que tinha você como alvo",
	["Play a sound when someone else who is not a tank taunts your target"] = "Tocar um som quando alguem que não é tanquer provocar seu alvo",
	["Prepend RBS::"] = "Antepor RBS::",
	["Prepend RBS:: to all lines of report chat. Disable to only prepend on the first line of a report"] = "Antepor RBS:: para todas as linhas do reporte no chat. Desabilite para somente antepor na primeira linha do reporte",
	["Raid health"] = "Saúde da raide",
	["Raid leader"] = "Lider da Raide",
	["Raid mana"] = "Mana da raide",
	["Raid Status Bars"] = "Barra de status do raide",
	["Raid-wide buffs"] = "Bônus em raid-inteira",
	["Ranged DPS death"] = "DPS de longo alcance morto",
	["Ranged DPS Garmann has died!"] = "DPS de longo alcance Garmann morreu!",
	["Refreshment Table"] = "Mesa de Refeições",
	["Repair Bot"] = "Robô de Conserto",
	Reporting = "Reportando",
	["Reporting options"] = "Opções de reportações",
	["Report missing to raid"] = "Reportar o que falta para a raide",
	["Report to officer channel"] = "Reportar no canal oficial",
	["Report to officers"] = "Reportar para oficiais",
	["Report to /raid or /party who is not buffed to the max."] = "Reportar no /raide ou /grupo quem não está bonificado no máx.",
	["Report to raid/party"] = "Reportar na raide/grupos",
	["Report to raid/party - requires raid assistant"] = "Reportar na raide/grupo - requer assistente de raide",
	["Report to self"] = "Reportar para você mesmo",
	["Required food quality"] = "Qualidade de comida requerida",
	["Require the Alt buton to be held down to move the dashboard window"] = "Requer o botão Alt pressionado para mover a janela do menu",
	["[RESIST] Danielbarron FAILED TO TAUNT their target (The Lich King) with Hand of Reckoning"] = "[RESISTIU] Danielbarron FALHOU AO PROVOCAR o alvo dele (Lich Rei) com Mão da Justiça",
	["[RESIST] Darinia FAILED TO TAUNT my target (The Lich King) with Taunt"] = "[RESISTIDO] Darinia FALHOU AO PROVOCAR meu alvo (Lich Rei) com Provocar",
	["Right click"] = "Clique direito",
	["Scale the Buff Options window"] = "Tamanho da janela de opções de bônus",
	["Scale the dashboard window"] = "Tamanho da janela do menu",
	["Seconds between updates"] = "Segundos entre atualizações",
	["Select which action to take when you click with the left mouse button over a dashboard buff check"] = "Selecione que ação tomar quando você clica com o botão esquerdo do mouse sobre o menu de checagem de bônus",
	["Select which action to take when you click with the left mouse button with Alt held down over a dashboard buff check"] = "Selecione que ação tomar quando você clica com o botão esquerdo do mouse com Alt pressionado sobre o menu de checagem de bônus",
	["Select which action to take when you click with the left mouse button with Ctrl held down over a dashboard buff check"] = "Selecione que ação tomar quando você clica com o botão esquerdo do mouse com Ctrl pressionado sobre o menu de checagem de bônus",
	["Select which action to take when you click with the left mouse button with Shift held down over a dashboard buff check"] = "Selecione que ação tomar quando você clica com o esquerdo do mouse com Shift pressionado sobre o menu de checagem de bônus",
	["Select which action to take when you click with the right mouse button over a dashboard buff check"] = "Selecione que ação tomar quando você clica com o direito do mouse no menu de checagem de bônus",
	["Select which action to take when you click with the right mouse button with Alt held down over a dashboard buff check"] = "Selecione que ação tomar quando você clica com o direito do mouse com Alt pressionado sobre o menu de checagem de bônus",
	["Select which action to take when you click with the right mouse button with Ctrl held down over a dashboard buff check"] = "Selecione que ação tomar quando você clica com o direito do mouse com Ctrl pressionado sobre o menu de checagem de bônus",
	["Select which action to take when you click with the right mouse button with Shift held down over a dashboard buff check"] = "Selecione que ação tomar quando você clica com o direito do mouse com Shift pressionado sobre o menu de checagem de bônus",
	["Select which level of food quality you require for the raiders to be considered 'Well Fed'"] = "Selecione o nivel de qualidade da comida que você requer para os raiders serem considerados \"Bem Alimentado\"",
	["Self buffs"] = "Bônus próprios",
	["Set how many seconds between dashboard raid scan updates"] = "Configurar os segundos entre escaneamento do painel para atualizar a raide",
	["Set N - the number of people missing a buff considered to be \"MANY\""] = "Configurar N - o número de pessoas com bônus faltando consideradas a serem \"MUITOS\"",
	["Shift-left click"] = "Shift-clique esquerdo",
	["Shift-right click"] = "Shift-clique direito",
	["Shorten names"] = "Encurtar nomes",
	["Shorten names in the report to reduce channel spam"] = "Encurtar nomes quando reportar para reduzir o spam no canal",
	["Show group number"] = "Mostrar número do grupo",
	["Show in battleground"] = "Mostrar em campos de batalha",
	["Show in party"] = "Mostrar em grupos",
	["Show in raid"] = "Mostrar em raides",
	["Show the buff report dashboard."] = "Mostrar o menu de reportar bônus",
	["Show the group number of the person missing a party/raid buff"] = "Mostrar o número do grupo da pessoa que está faltando um bônus de grupo/raide",
	["Single target buffs"] = "Bônus de alvo único",
	["Skin and minimap options"] = "Opções de skin e mini-mapa",
	["Skin and scaling"] = "Skin e escalas",
	["Skip buff checking during combat. You can manually initiate a scan by pressing Scan on the dashboard"] = "Pular a checagem de bônus durante combate. Você pode iniciar o escaneamento manualmente pressionando \"Escanear\" no menu",
	["%s minutes"] = "%s minutos",
	["Sort buff buttons by"] = "Ordenar botôes bônus por",
	["Soul Well"] = "Poço das Almas",
	["Status bars to show raid, dps, tank health, mana, etc"] = "Barra de status que mostram raide, dps, saúde do tanquer, mana, etc",
	["Tank breaks CC"] = "Tanquer quebrou CC",
	["Tank Danielbarron has died!"] = "Tanquer Danielbarron morreu!",
	["Tank death"] = "Tanquer morto",
	["Tank health"] = "Saúde do tanquer",
	["Tank list"] = "Lista de tanquer",
	["Tanks alive"] = "Tanquers vivos",
	["Tank warnings"] = "Avisos do tanquer",
	["Tank warnings about taunts, failed taunts and mob stealing including accidental taunts from non-tanks"] = "Avisos de provocações para tanquer,  provocações falhas e roubo de mob incluindo provocações acidentais de não-tanquers",
	["Taunts to my mobs"] = "Provocações nos meus alvos",
	["Taunts to my target"] = "Provocações no meu alvo",
	["Tells you when someone in your party, raid or guild has a newer version of RBS installed"] = "Falar para você quando alguem no grupo, raide ou guilda tiver uma versão mais recente do RBS instalada",
	["Tells you when someone in your party, raid or guild has RBS installed"] = "Fala a você quando alguem em seu grupo, raide ou guilda tem RBS instalado",
	Test = "Testar",
	["Test what the warning is like"] = "Teste como o aviso será",
	["The average DPS mana percent"] = "Porcentagem média de mana do DPS",
	["The average healer mana percent"] = "Porcentagem média da mana do curador",
	["The average party/raid health percent"] = "Porcentagem média da saúde do grupo/raide",
	["The average party/raid mana percent"] = "Porcentagem média da mana do grupo/raide",
	["The average tank health percent"] = "Porcentagem média da saúde do tanquer",
	["The Buff Wizard automatically configures the dashboard buffs and configuration defaults for your class or raid leading role."] = "A configuração de bônus (Buff Wizard) configura automaticamente o menu de bônus e configurações padrões de sua classe ou função de raide lider",
	["Then sort buff buttons by"] = "Ordenar botões de bônus por",
	["The percentage of healers alive in the raid"] = "Porcentagem média dos curadores vivos na raide",
	["The percentage of people alive in the raid"] = "Porcentagem média das pessoas vivas na raide",
	["The percentage of people dead in the raid"] = "A porcentagem de pessoas mortas na raide",
	["The percentage of people within 40 yards range"] = "A porcentagem de pessoas entre uma distância de 50 jardas. (Yards)",
	["The percentage of tanks alive in the raid"] = "Porcentagem média de tanquers vivos na raide",
	["This is the default configuration in which RBS ships out-of-the-box.  It gives you pretty much anything a raid leader would need to see on the dashboard"] = "Esta é a configuração padrão em que o RBS é instalado.  Ela lhe de tudo o bastante que um Lider de Raide precisa saber no menu",
	["Toggle to display a minimap icon"] = "Alterne para mostrar o ícone no mini-mapa",
	Top = "Topo",
	["To set this option go to the addon configuration.  This button is automatically enabled when the Boss button is pressed and automatically disabled when the Trash button is pressed.  To permanently disable, choose 0 seconds as the min remaining buff duration."] = "Para configurar essa opção vá a configuração de addon. Este botão é habilitado automaticamente quando o botão Chefe for pressionado e desabilita automaticamente quando o botão Trash for pressionado. Para desabilitar permanentemente, escolha 0 segundos como o minuto de duração de bônus restante.",
	["Two groups down"] = "Dois grupos em baixo",
	["User announce"] = "Anuncio de usuário",
	["Version announce"] = "Anúncio de Versão",
	["Wait before announcing to see if others have announced first in order to reduce spam"] = "Esperar antes de anunciar para saber se alguem não anunciou primeiro com motivo para reduzir spam",
	["Warning messages when players die"] = "Mensagens de aviso quando jogadores morrerem",
	["Warnings when Crowd Control is broken by tanks and non-tanks"] = "Avisos quando CC's são quebrados por tanquers e não-tanquers",
	["Warnings when Misdirection or Tricks of the Trade is cast"] = "Avisos quando Redirecionamentos ou Truques da Troca forem usados",
	["Warnings when someone else targets a mob and taunts that mob which is targeting you"] = "Avisos quando alguem seleciona e provoca um mob que tinha você como alvo",
	["Warnings when someone else taunts your target"] = "Avisos quando alguem provoca seu alvo",
	["Warnings when someone else taunts your target who is not a tank"] = "Avisos quando alguem provoca seu alvo que não é tanquer",
	["Warning, Trash, Boss groups"] = "Grupos de Avisos, Trash, Chefes",
	["Warns when a non-tank breaks Crowd Control"] = "Avisa quando um não-tanquer quebrar CC's",
	["Warns when a tank breaks Crowd Control"] = "Avisa quando um tanquer quebrar CC's",
	["Warns when other people's taunts to your target fail"] = "Avisa quando provocações de outras pessoas falhare no seu alvo",
	["Warns when someone else taunts your target which is targeting you"] = "Avisa quando alguem seleciona e provoca seu alvo que tinha você mesmo como alvo",
	["Warns when your taunts fail due to resist"] = "Avisa quando suas provocações falham devido a resistência",
	["Warns when your taunts fail due to the target being immune"] = "Avisar quando suas provocações falharem devido ao alvo ser imune",
	["Warn to party"] = "Avisar o grupo",
	["Warn to party when a healer dies"] = "Avisar o grupo quando um curador morrer",
	["Warn to party when a melee DPS dies"] = "Avisar o grupo quando um DPS Corpo a Corpo morrer",
	["Warn to party when a non-tank breaks Crowd Control"] = "Avisar o grupo quando um não-tanquer quebra CC",
	["Warn to party when a ranged DPS dies"] = "Avisar o grupo quando um DPS de longo alcance morre",
	["Warn to party when a tank breaks Crowd Control"] = "Avisar o grupo quando um tanquer quebra CC",
	["Warn to party when a tank dies"] = "Avisar o grupo quando um tanquer morrer",
	["Warn to party when one of your taunts fails due to resist"] = "Avisar o grupo quando uma de suas provocações falharem devido a resistência",
	["Warn to party when one of your taunts fails due to the target being immune"] = "Avisar o grupo quando uma de suas provocações falharem devido ao alvo ser imune",
	["Warn to party when other people's taunts to your target fail"] = "Avisar o grupo quando provocações de outras pessoas falharem no seu alvo",
	["Warn to party when someone else targets a mob and taunts that mob which is targeting you"] = "Avisar o grupo quando alguem seleciona e provoca um mob que é seu alvo",
	["Warn to party when someone else taunts your target"] = "Avisar o grupo quando alguem provocar seu alvo",
	["Warn to party when someone else taunts your target which is targeting you"] = "Avisar o grupo quando alguem provocar seu alvo que estava tendo você como alvo",
	["Warn to party when someone else who is not a tank taunts your target"] = "Avisar o grupo quando um não-tanquer provocar seu alvo",
	["Warn to raid chat"] = "Avisar no canal de raide",
	["Warn to raid chat when a healer dies"] = "Avisar no canal de raide quando um curador morrer",
	["Warn to raid chat when a melee DPS dies"] = "Avisar no canal de raide quando um DPS Corpo a Corpo morre",
	["Warn to raid chat when a non-tank breaks Crowd Control"] = "Avisar no canal de raide quando um não-tanquer quebrar CC",
	["Warn to raid chat when a ranged DPS dies"] = "Avisar no canal de raide quando um DPS de longo alcance morre",
	["Warn to raid chat when a tank breaks Crowd Control"] = "Avisar no canal de raide quando um tanquer quebrar CC",
	["Warn to raid chat when a tank dies"] = "Avisar no canal de raide quando um tanquer morrer",
	["Warn to raid chat when one of your taunts fails due to resist"] = "Aivsar no canal de raide quando uma de suas provocações falharem devido a resistência",
	["Warn to raid chat when one of your taunts fails due to the target being immune"] = "Avisar no canal de raide quando uma de suas provocações falharem devido o alvo ser imune",
	["Warn to raid chat when other people's taunts to your target fail"] = "Avisar no canal de raide quando provocações de outras pessoas falharem no seu alvo",
	["Warn to raid chat when someone else targets a mob and taunts that mob which is targeting you"] = "Avisar no canal de raide quando alguem selecionar e provocar um mob que tinha você como alvo",
	["Warn to raid chat when someone else taunts your target"] = "Avisar no canal de raide quando alguem provocar seu alvo",
	["Warn to raid chat when someone else taunts your target which is targeting you"] = "Avisar no canal de raide quando alguem provocar seu alvo que tinha você como alvo",
	["Warn to raid chat when someone else who is not a tank taunts your target"] = "Avisar no canal de raide quando algum não-tanquer provocar seu alvo",
	["Warn to raid warning"] = "Avisar no alerta de raide",
	["Warn to self"] = "Avisar você mesmo",
	["Warn to self when a healer dies"] = "Avisar você quando um curador morrer",
	["Warn to self when a melee DPS dies"] = "Avisar você quando um DPS Corpo a Corpo morre",
	["Warn to self when a non-tank breaks Crowd Control"] = "Avisar você mesmo quando um não-tanquer quebrar CC",
	["Warn to self when a ranged DPS dies"] = "Avisar você quando um DPS de longo alcance morre",
	["Warn to self when a tank breaks Crowd Control"] = "Avisar você mesmo quando um tanquer quebrar CC",
	["Warn to self when a tank dies"] = "Avisar você quando um tanquer morrer",
	["Warn to self when Misdirection or Tricks of the Trade is cast"] = "Avisar você quando Redirecionamento ou Truques da Troca for usado",
	["Warn to self when one of your taunts fails due to resist"] = "Avisar você quando uma de suas provocações falharem devido a resistência",
	["Warn to self when one of your taunts fails due to the target being immune"] = "Avisar você mesmo quando uma de suas provocações falharem devido o alvo ser imune",
	["Warn to self when other people's taunts to your target fail"] = "Avisar você mesmo quando as provocações de outras pessoas falharem no seu alvo",
	["Warn to self when someone else targets a mob and taunts that mob which is targeting you"] = "Avisar você mesmo quando alguem selecionar e provocar o mob que tinha você como alvo",
	["Warn to self when someone else taunts your target"] = "Avisar você mesmo quando alguem provocar seu alvo",
	["Warn to self when someone else taunts your target which is targeting you"] = "Avisar você mesmo quando alguem provocar o alvo que tinha você como alvo",
	["Warn to self when someone else who is not a tank taunts your target"] = "Avisar você mesmo quando um não-tanquer provocar seu alvo",
	["Warn using raid warning when a healer dies"] = "Avisar usando o alerta de raide quando um curador morrer",
	["Warn using raid warning when a melee DPS dies"] = "Avisar usando o alerta de raide quando um DPS Corpo a Corpo morre",
	["Warn using raid warning when a non-tank breaks Crowd Control"] = "Avisar usando o alerta de raide quando um não-tanquer quebrar CC",
	["Warn using raid warning when a ranged DPS dies"] = "Avisar usando o alerta de raide quando um DPS de longo alcance morre",
	["Warn using raid warning when a tank breaks Crowd Control"] = "Avisar usando o alerta de raide quando um tanquer quebrar CC",
	["Warn using raid warning when a tank dies"] = "Avisar usando o alerta de raide quando um tanquer morrer",
	["Warn using raid warning when one of your taunts fails due to resist"] = "Aivsar usando o alerta de raide quando uma de suas provocações falharem devido a resistência",
	["Warn using raid warning when one of your taunts fails due to the target being immune"] = "Aivsar usando o alerta de raide quando uma de suas provocações falharem devido ao alvo ser imune",
	["Warn using raid warning when other people's taunts to your target fail"] = "Avisar usando o alerta de raide quando as provocações de outras pessoas falharem no seu alvo",
	["Warn using raid warning when someone else targets a mob and taunts that mob which is targeting you"] = "Avisar usando o alerta de raide quando alguem seleciona e provoca um mob que tinha você como alvo",
	["Warn using raid warning when someone else taunts your target"] = "Avisar usando o alerta de raide quando alguem provoca seu alvo",
	["Warn using raid warning when someone else taunts your target which is targeting you"] = "Avisar usando o alerta de raide quando alguem provoca seu alvo que tinha você mesmo como alvo",
	["Warn using raid warning when someone else who is not a tank taunts your target"] = "Avisar usando o alerta de raide quando quando um não-tanquer provocar seu alvo",
	["Warn when a healer dies"] = "Avisar quando um curador morre",
	["Warn when a melee DPS dies"] = "Avisar quando um DPS Corpo a Corpo morre",
	["Warn when a ranged DPS dies"] = "Avisar quando um DPS de longo alcance morre",
	["Warn when a tank dies"] = "Avisar quando um tanquer morre",
	["Well auto whisper"] = "Auto-Sussuro de Poço",
	["When at least N people are missing a raid buff say MANY instead of spamming a list"] = "Quando no mínimo N pessoas estiverem com bônus de raide faltando dizer MUITOS ao invés de fazer uma lista de spam",
	["When many say so"] = "Quando \"muitos\" será dito",
	["When there are multiple people who can provide a missing buff such as Fortitude then only whisper one of them at random who is in range rather than all of them"] = "Quando há várias pessoas que podem providênciar um bônus faltando como Fortitude, somente sussurar um deles em aleatorio que está em uma distancia menor que os outros",
	["When whispering and at least N people are missing a raid buff say MANY instead of spamming a list"] = "Ao sussurar e no mínimo N pessoas estiverem faltando um bônus de raide dizer MUITOS ao envés de uma lista de spams",
	["Whisper buffers"] = "Sussurar bônificadores",
	["Whisper many"] = "Sussurar muitos",
	["Whisper only one"] = "Sussurar somente um",
	["Your taunt immune-fails"] = "Sua provocação falhou-imune",
	["Your taunt resist-fails"] = "Sua provocação falhou-resistiu",
}
La.RaidStatusBars = {
	["Dead healers"] = "Curadores mortos",
	["Dead tanks"] = "Tanquers mortos",
	["I see dead people"] = "Eu vejo gente morta",
	["n/a"] = "n/a",
	P = "P",
	["Pull Timer"] = "Tempo para Puxar",
	R = "TP?",
	["Ready Check"] = "Todos Prontos?",
}
La.TalentsWindow = {
	Class = "Classe",
	Healer = "Curador",
	["Melee DPS"] = "DPS Corpo a Corpo",
	Name = "Nome",
	["Ranged DPS"] = "DPS de longo alcance",
	Refresh = "Atualizar",
	Role = "Função",
	Spec = "Espec",
	Specialisations = "Especializações",
	["Talent Specialisations"] = "Especializações de talentos",
	Tank = "Tanquer",
}
La.TankTauntWarnings = {
	["NON-TANK %s taunted my boss target (%s%s%s) with %s"] = "NÃO-TANQUER %s provocou meu alvo do chefe (%s%s%s) com %s",
	["NON-TANK %s taunted my target (%s%s%s) with %s"] = "NÃO-TANQUER %s provocou meu alvo (%s%s%s) com %s",
	["%s FAILED TO NINJA my boss target (%s%s%s) with %s"] = "%s FALHOU AO NINJAR o alvo do meu chefe (%s%s%s) com %s",
	["%s FAILED TO NINJA my target (%s%s%s) with %s"] = "%s FALHOU AO NINJAR meu alvo (%s%s%s) com %s",
	["%s FAILED TO TAUNT my boss target (%s%s%s) with %s"] = "%s FALHOU AO PROVOCAR o alvo do meu chefe (%s%s%s) com %s",
	["%s FAILED TO TAUNT my target (%s%s%s) with %s"] = "%s FALHOU AO PROVOCAR meu alvo (%s%s%s) com %s",
	["%s FAILED TO TAUNT their boss target (%s%s%s) with %s"] = "%s FALHOU AO PROVOCAR o alvo do chefe (%s%s%s) com %s",
	["%s FAILED TO TAUNT their target (%s%s%s) with %s"] = "%s FALHOU AO PROVOCAR o alvo dele (%s%s%s) com %s",
	["%s ninjaed my boss target (%s%s%s) with %s"] = "%s ninjou meu alvo do chefe (%s%s%s) com %s",
	["%s ninjaed my target (%s%s%s) with %s"] = "%s ninjou meu alvo (%s%s%s) com %s",
	["%s taunted my boss mob (%s%s%s) with %s"] = "%s provocou meu mob do chefe (%s%s%s) com %s",
	["%s taunted my boss target (%s%s%s) with %s"] = "%s provocou meu alvo do chefe (%s%s%s) com %s",
	["%s taunted my mob (%s%s%s) with %s"] = "%s provocou meu mob (%s%s%s) com %s",
	["%s taunted my target (%s%s%s) with %s"] = "%s provocou meu alvo (%s%s%s) com %s",
}

elseif locale == "itIT" then do end
-- La["Announce even when you don't have assist or lead"] = ""
-- La["Announce expiration"] = ""
-- La["Announcement options for raid utilities like Feasts"] = ""
-- La["Announce to raid warning when a %s is prepared"] = ""
-- La["Announce to raid warning when a utility is expiring"] = ""
-- La["Announce without lead"] = ""
-- La["Augment Banquet Tooltips"] = ""
-- La["Augment Banquet Tooltips with stat bonus information"] = ""
-- La["Augment Rune"] = ""
-- La["Blingtron"] = ""
-- La["Blingtron about to expire!"] = ""
-- La["Bonus"] = ""
-- La["Broken Link"] = ""
-- La["casts %s"] = ""
-- La["Eating"] = ""
-- La["Expiration announcements"] = ""
-- La[" has set us up a Blingtron"] = ""
-- La["has set us up a %s"] = ""
-- La["Mailbox"] = ""
-- La["Noodle Cart"] = ""
-- La["Portal"] = ""
-- La["Prefer Static Buff"] = ""
-- La["Report missing static buffs even when an equivalent passive aura is already present."] = ""
-- La["Required flask quality"] = ""
-- La["Right-click to target"] = ""
-- La["Select which level of flask quality you require"] = ""
-- La["sets up a %s"] = ""
-- La["Show configuration options"] = ""
-- La["Soulwell"] = ""
-- La["Tooltip name coloring"] = ""
-- La["Tooltip role icons"] = ""
-- La["Treat eating as Well Fed"] = ""
-- La["Treat players who are currently eating as Well Fed. This assumes they are eating acceptable food."] = ""
-- La["Utility announcements"] = ""
-- La["Warrior Stance"] = ""
La.BuffOptionsWindow = {
	-- ["Buff Options"] = "",
	-- ["Is a buff"] = "",
	-- ["Is a warning"] = "",
	-- ["Report on Boss"] = "",
	-- ["Report on Trash"] = "",
	-- ["Show on dashboard"] = "",
	-- ["Show/Report in combat"] = "",
}
La.CrowdControlWarnings = {
	-- ["Melee Swing"] = "",
	-- ["Non-tank %s broke %s on %s%s%s"] = "",
	-- ["Non-tank %s broke %s on %s%s%s with %s"] = "",
	-- ["%s broke %s on %s%s%s"] = "",
	-- ["%s broke %s on %s%s%s with %s"] = "",
}
La.Messages = {
	-- AFK = "",
	-- Agil = "",
	-- alpha = "",
	-- ["Alt-Click on a party buff will cast on someone missing that buff."] = "",
	-- ["Alt-Click on a self buff will renew that buff."] = "",
	-- ["Aspect Cheetah/Pack On"] = "",
	-- ["Aspect of the Cheetah or Pack is on"] = "",
	-- ["Battle Elixir"] = "",
	-- beta = "",
	-- ["Blessing of Kings is not needed because you are grouped with a Druid."] = "",
	-- ["Blessing of Kings, with this raid configuration, is better provided by Drums of the Forgotten Kings thus allowing Blessing of Might to be used."] = "",
	-- Boss = "",
	-- ["Buffers: "] = "",
	-- ["Buffing Kings:"] = "",
	-- ["Buffing Might:"] = "",
	-- ["Cast by:"] = "",
	-- ["Click buffs to disable and enable."] = "",
	-- ["Click to toggle the RBS dashboard"] = "",
	-- ["Ctrl-Click Boss or Trash to whisper all those who need to buff."] = "",
	-- ["Ctrl-Click buffs to whisper those who need to buff."] = "",
	-- Dead = "",
	-- ["Death Knight Presence"] = "",
	-- ["Different Zone"] = "",
	-- ["Flasked or Elixired but slacking"] = "",
	-- ["Flask or two Elixirs"] = "",
	-- ["Guardian Elixir"] = "",
	-- ["Has buff: "] = "",
	-- [" has set us up a Refreshment Table"] = "",
	-- [" has set us up a Repair Bot"] = "",
	-- [" has set us up a Soul Well"] = "",
	-- ["Healer %s has died!"] = "",
	-- ["Health less than 80%"] = "",
	-- ["Hide outgoing whispers"] = "",
	-- ["Hunter Aspect"] = "",
	-- ["Hunter has no aspect at all"] = "",
	-- ["[IMMUNE]"] = "",
	-- Int = "",
	-- [" in their bags"] = "",
	-- ["Invite auto-accepted from battle.net friend %s."] = "",
	-- ["Invite auto-accepted from friend %s."] = "",
	-- ["Invite auto-accepted from guild member %s."] = "",
	-- ["Item count: "] = "",
	-- ["Low durability"] = "",
	-- ["Low durability (35% or less)"] = "",
	-- ["Mage is missing a Mage Armor"] = "",
	-- ["Mana less than 80%"] = "",
	-- ["MANY!"] = "",
	-- ["Melee DPS %s has died!"] = "",
	-- ["Missing "] = "",
	-- ["Missing a scroll"] = "",
	-- ["Missing buff: "] = "",
	-- ["Missing buffs (Boss): "] = "",
	-- ["Missing buffs (Trash): "] = "",
	-- ["Missing or not working oRA or RBS: "] = "",
	-- No = "",
	-- ["No buffs needed! (Boss)"] = "",
	-- ["No buffs needed! (Trash)"] = "",
	-- ["No Soulstone detected"] = "",
	-- ["Not Well Fed"] = "",
	-- Offline = "",
	-- ["Out of range"] = "",
	-- ["Paladin blessing"] = "",
	-- ["Paladin missing Seal"] = "",
	-- ["Player has a wrong Paladin blessing"] = "",
	-- ["Player has health less than 80%"] = "",
	-- ["Player has mana less than 80%"] = "",
	-- ["Player is AFK"] = "",
	-- ["Player is Dead"] = "",
	-- ["Player is in a different zone"] = "",
	-- ["Player is missing at least one Paladin blessing"] = "",
	-- ["Player is Offline"] = "",
	-- ["Please relog or reload UI to update the item cache."] = "",
	-- ["prepares a %s!"] = "",
	-- ["Press Escape -> Interface -> AddOns -> RaidBuffStatus for more options."] = "",
	-- Prot = "",
	-- ["Protection Paladin with no Righteous Fury"] = "",
	-- ["PVP is On"] = "",
	-- ["PVP On"] = "",
	-- ["Ranged DPS %s has died!"] = "",
	-- ["RBS Dashboard Help"] = "",
	-- ["RBS Tank List"] = "",
	-- ["Refreshment Table about to expire!"] = "",
	-- ["Remind me later"] = "",
	-- ["(Remove buff)"] = "",
	-- ["Remove this button from this dashboard in the buff options window."] = "",
	-- ["Repair Bot about to expire!"] = "",
	-- ["[RESIST]"] = "",
	-- ["Right-click to open the addons options menu"] = "",
	-- ["%s about to expire!"] = "",
	-- Scan = "",
	-- ["%s cast %s on %s"] = "",
	-- Scroll = "",
	-- Seal = "",
	-- ["Sent %d whispers to %d players"] = "",
	-- ["%s has a newer (%s) version of RBS (%s) than you (%s)"] = "",
	-- ["Shift-Click buffs to report on only that buff."] = "",
	-- ["%s is running RBS %s"] = "",
	-- ["Slackers: "] = "",
	-- ["Slacking Paladins"] = "",
	-- ["Sorry, I am queued for"] = "",
	-- ["Sorry, I am queued for a battlefield."] = "",
	-- ["Sorry, the group is now full."] = "",
	-- ["Soul Well about to expire!"] = "",
	-- Spi = "",
	-- Sta = "",
	-- Str = "",
	-- ["Tank missing Earth Shield"] = "",
	-- ["Tank missing Thorns"] = "",
	-- ["Tank %s has died!"] = "",
	-- ["Tank with "] = "",
	-- ["The above default button actions can be reconfigured."] = "",
	-- ["This is the first time RaidBuffStatus has been activated since installation or settings were reset. Would you like to visit the Buff Wizard to help you get RBS buffs configured? If you are a raid leader then you can click No as the defaults are already set up for you."] = "",
	-- ["Tol Barad"] = "",
	-- Trash = "",
	-- ["Warning: "] = "",
	-- ["Warnings: "] = "",
	-- ["Weapon buff"] = "",
	-- ["Well Fed but slacking"] = "",
	-- Wintergrasp = "",
	-- ["Wrong flask for this zone"] = "",
	-- ["Wrong Paladin blessing"] = "",
	-- ["You need to be leader or assistant to do this"] = "",
	-- ["You need to whisper the leader instead: "] = "",
}
La.Options = {
	-- Alive = "",
	-- ["Allow raiders to use flasks and elixirs from last expansion"] = "",
	-- ["Alt-left click"] = "",
	-- ["Alt-right click"] = "",
	-- ["Always hide the Boss R Trash buttons"] = "",
	-- ["Announce to raid warning when a Feast is prepared"] = "",
	-- ["Anti spam"] = "",
	-- Appearance = "",
	-- ["Auto-accept invites"] = "",
	-- ["Auto-invite whispers"] = "",
	-- ["Automatically accept invites from friends and guild members so you can go for a bio-break whilst waiting for a raid invite"] = "",
	-- ["Automatically accept invites from these"] = "",
	-- ["Automatically configures the dashboard buffs and configuration defaults for your class or raid leading role"] = "",
	-- ["Automatically invite friends and guild members who whisper to you the word 'invite'"] = "",
	-- ["Automatically invite these"] = "",
	-- ["Automatically show the dashboard when you join a battleground"] = "",
	-- ["Automatically show the dashboard when you join a party"] = "",
	-- ["Automatically show the dashboard when you join a raid"] = "",
	-- ["Automatically whisper anyone missing a Healthstone when your Soul Well expire warnings appear"] = "",
	-- ["Automatically whisper anyone missing flasks or elixirs when your Cauldron expire warnings appear"] = "",
	-- ["Automatically whisper anyone missing Well Fed when your Feast expire warnings appear"] = "",
	-- Automation = "",
	-- ["Background colour"] = "",
	-- ["Bar positioning"] = "",
	-- ["Battle.net friends"] = "",
	-- ["Border colour"] = "",
	-- ["Bosses only"] = "",
	-- Bottom = "",
	-- ["Buff button sorting"] = "",
	-- ["Buff Options scale"] = "",
	-- ["Buff those missing buff"] = "",
	-- ["Buff Wizard"] = "",
	-- Cauldron = "",
	-- ["Cauldron auto whisper"] = "",
	-- ["CC-break warnings"] = "",
	-- ["Choose either one big collection of buff checks or traditional style with Warnings, Trash and Boss buff checks"] = "",
	-- ["Choose where on the dashboard the bars appear"] = "",
	-- ["Class-specific buffs"] = "",
	-- Combat = "",
	-- ["Combat options"] = "",
	-- ["Configure how the buff buttons and status bars on the dashboard are sorted and displayed"] = "",
	-- ["Consumable options"] = "",
	-- Consumables = "",
	-- ["Core raid buffs"] = "",
	-- ["Ctrl-left click"] = "",
	-- ["Ctrl-right click"] = "",
	-- ["Danielbarron broke Sheep on The Lich King with Hand of Reckoning"] = "",
	-- ["Darinia ninjaed my target (The Lich King) with Taunt"] = "",
	-- ["Darinia taunted my mob (The Lich King) with Taunt"] = "",
	-- ["Darinia taunted my target (The Lich King) with Taunt"] = "",
	-- ["Dashboard columns"] = "",
	-- ["Dashboard mouse button actions options"] = "",
	-- ["Dashboard scale"] = "",
	-- ["Death warnings"] = "",
	-- ["Default order"] = "",
	-- ["Disable scan in combat"] = "",
	-- ["DPS mana"] = "",
	-- ["Enable/disable buff check"] = "",
	-- ["Enable tank warnings including taunts, failed taunts and mob stealing"] = "",
	-- ["Enable tank warnings including taunts, failed taunts and mob stealing only on bosses"] = "",
	-- ["Enable warning messages when players die"] = "",
	-- ["Enable warnings when Crowd Control is broken by tanks and non-tanks"] = "",
	-- ["Enable warnings when Misdirection or Tricks of the Trade is cast"] = "",
	-- ["Feast auto whisper"] = "",
	-- Feasts = "",
	-- ["Food announce"] = "",
	-- Friends = "",
	-- ["Grouping style"] = "",
	-- ["Guild members"] = "",
	-- ["Healer death"] = "",
	-- ["Healer drinking"] = "",
	-- ["Healer drinking sound"] = "",
	-- ["Healer mana"] = "",
	-- ["Healers alive"] = "",
	-- ["Healer Stormsnow has died!"] = "",
	-- ["Hide and show the buff report dashboard."] = "",
	-- ["Hide Boss R Trash"] = "",
	-- ["Hide dashboard during combat"] = "",
	-- ["Hide in combat"] = "",
	-- ["Hide the buff report dashboard."] = "",
	-- ["Highlight my buffs"] = "",
	-- ["Hightlight currently missing buffs on the dashboard for which you are responsible including self buffs and buffs which you are missing that are provided by someone else. I.e. show buffs for which you must take action"] = "",
	-- ["How MANY?"] = "",
	-- ["Ignore groups 6 to 8"] = "",
	-- ["Ignore groups 6 to 8 when reporting as these are for subs"] = "",
	-- ["[IMMUNE] Danielbarron FAILED TO TAUNT their target (The Lich King) with Hand of Reckoning"] = "",
	-- ["In range"] = "",
	-- invite = "",
	-- ["Just my buffs"] = "",
	-- ["Left click"] = "",
	-- ["Melee DPS Danielbarron has died!"] = "",
	-- ["Melee DPS death"] = "",
	-- ["Minimap icon"] = "",
	-- ["Minimum remaining buff duration in minutes. Buffs with less than this will be considered as missing.  This option only takes affect when the corresponding 'buff' button is enabled on the dashboard."] = "",
	-- ["Min remaining buff duration"] = "",
	-- ["Misdirection warnings"] = "",
	-- ["Mouse buttons"] = "",
	-- ["Move with Alt-click"] = "",
	-- ["My buffs"] = "",
	-- ["Ninja taunts"] = "",
	-- ["No healer close"] = "",
	-- None = "",
	-- ["Non-tank breaks CC"] = "",
	-- ["Non-tank Glamor broke Hex on The Lich King with Moonfire"] = "",
	-- ["NON-TANK Tanagra taunted my target (The Lich King) with Growl"] = "",
	-- ["Non-tank taunts my target"] = "",
	-- ["Number of columns to display on the dashboard"] = "",
	-- ["Old flasks and elixirs"] = "",
	-- ["One big group"] = "",
	-- ["One group down"] = "",
	-- ["Only if all have it"] = "",
	-- ["Only me"] = "",
	-- ["Only show the buffs for which your class is responsible for.  This configuration can be used like a buff-bot where one simply right clicks on the buffs to cast them"] = "",
	-- ["Only show the core class raid buffs"] = "",
	-- ["Only show when you and only you break Crowd Control so you can say 'Now I don't believe you wanted to do that did you, ehee?'"] = "",
	-- ["Only use tank list"] = "",
	-- ["Only use the tank list and ignore spec when there is a tank list for determining if someone is a tank or not"] = "",
	-- ["Options for automatically opening the dashboard and moving it"] = "",
	-- ["Options for setting the quality requirements of consumables"] = "",
	-- ["Options to do with configuring the tank list"] = "",
	-- Other = "",
	-- ["Other taunt fails"] = "",
	-- ["Play a sound"] = "",
	-- ["Play a sound when a healer dies"] = "",
	-- ["Play a sound when a healer drinks and is not full on mana"] = "",
	-- ["Play a sound when a melee DPS dies"] = "",
	-- ["Play a sound when a non-tank breaks Crowd Control"] = "",
	-- ["Play a sound when a ranged DPS dies"] = "",
	-- ["Play a sound when a tank breaks Crowd Control"] = "",
	-- ["Play a sound when a tank dies"] = "",
	-- ["Play a sound when Misdirection or Tricks of the Trade is cast"] = "",
	-- ["Play a sound when one of your taunts fails due to resist"] = "",
	-- ["Play a sound when one of your taunts fails due to the target being immune"] = "",
	-- ["Play a sound when other people's taunts to your target fail"] = "",
	-- ["Play a sound when someone else targets a mob and taunts that mob which is targeting you"] = "",
	-- ["Play a sound when someone else taunts your target"] = "",
	-- ["Play a sound when someone else taunts your target which is targeting you"] = "",
	-- ["Play a sound when someone else who is not a tank taunts your target"] = "",
	-- ["Prepend RBS::"] = "",
	-- ["Prepend RBS:: to all lines of report chat. Disable to only prepend on the first line of a report"] = "",
	-- ["Raid health"] = "",
	-- ["Raid leader"] = "",
	-- ["Raid mana"] = "",
	-- ["Raid Status Bars"] = "",
	-- ["Raid-wide buffs"] = "",
	-- ["Ranged DPS death"] = "",
	-- ["Ranged DPS Garmann has died!"] = "",
	-- ["Refreshment Table"] = "",
	-- ["Repair Bot"] = "",
	-- Reporting = "",
	-- ["Reporting options"] = "",
	-- ["Report missing to raid"] = "",
	-- ["Report to officer channel"] = "",
	-- ["Report to officers"] = "",
	-- ["Report to /raid or /party who is not buffed to the max."] = "",
	-- ["Report to raid/party"] = "",
	-- ["Report to raid/party - requires raid assistant"] = "",
	-- ["Report to self"] = "",
	-- ["Required food quality"] = "",
	-- ["Require the Alt buton to be held down to move the dashboard window"] = "",
	-- ["[RESIST] Danielbarron FAILED TO TAUNT their target (The Lich King) with Hand of Reckoning"] = "",
	-- ["[RESIST] Darinia FAILED TO TAUNT my target (The Lich King) with Taunt"] = "",
	-- ["Right click"] = "",
	-- ["Scale the Buff Options window"] = "",
	-- ["Scale the dashboard window"] = "",
	-- ["Seconds between updates"] = "",
	-- ["Select which action to take when you click with the left mouse button over a dashboard buff check"] = "",
	-- ["Select which action to take when you click with the left mouse button with Alt held down over a dashboard buff check"] = "",
	-- ["Select which action to take when you click with the left mouse button with Ctrl held down over a dashboard buff check"] = "",
	-- ["Select which action to take when you click with the left mouse button with Shift held down over a dashboard buff check"] = "",
	-- ["Select which action to take when you click with the right mouse button over a dashboard buff check"] = "",
	-- ["Select which action to take when you click with the right mouse button with Alt held down over a dashboard buff check"] = "",
	-- ["Select which action to take when you click with the right mouse button with Ctrl held down over a dashboard buff check"] = "",
	-- ["Select which action to take when you click with the right mouse button with Shift held down over a dashboard buff check"] = "",
	-- ["Select which level of food quality you require for the raiders to be considered 'Well Fed'"] = "",
	-- ["Self buffs"] = "",
	-- ["Set how many seconds between dashboard raid scan updates"] = "",
	-- ["Set N - the number of people missing a buff considered to be \"MANY\""] = "",
	-- ["Shift-left click"] = "",
	-- ["Shift-right click"] = "",
	-- ["Shorten names"] = "",
	-- ["Shorten names in the report to reduce channel spam"] = "",
	-- ["Show group number"] = "",
	-- ["Show in battleground"] = "",
	-- ["Show in party"] = "",
	-- ["Show in raid"] = "",
	-- ["Show the buff report dashboard."] = "",
	-- ["Show the group number of the person missing a party/raid buff"] = "",
	-- ["Single target buffs"] = "",
	-- ["Skin and minimap options"] = "",
	-- ["Skin and scaling"] = "",
	-- ["Skip buff checking during combat. You can manually initiate a scan by pressing Scan on the dashboard"] = "",
	-- ["%s minutes"] = "",
	-- ["Sort buff buttons by"] = "",
	-- ["Soul Well"] = "",
	-- ["Status bars to show raid, dps, tank health, mana, etc"] = "",
	-- ["Tank breaks CC"] = "",
	-- ["Tank Danielbarron has died!"] = "",
	-- ["Tank death"] = "",
	-- ["Tank health"] = "",
	-- ["Tank list"] = "",
	-- ["Tanks alive"] = "",
	-- ["Tank warnings"] = "",
	-- ["Tank warnings about taunts, failed taunts and mob stealing including accidental taunts from non-tanks"] = "",
	-- ["Taunts to my mobs"] = "",
	-- ["Taunts to my target"] = "",
	-- ["Tells you when someone in your party, raid or guild has a newer version of RBS installed"] = "",
	-- ["Tells you when someone in your party, raid or guild has RBS installed"] = "",
	-- Test = "",
	-- ["Test what the warning is like"] = "",
	-- ["The average DPS mana percent"] = "",
	-- ["The average healer mana percent"] = "",
	-- ["The average party/raid health percent"] = "",
	-- ["The average party/raid mana percent"] = "",
	-- ["The average tank health percent"] = "",
	-- ["The Buff Wizard automatically configures the dashboard buffs and configuration defaults for your class or raid leading role."] = "",
	-- ["Then sort buff buttons by"] = "",
	-- ["The percentage of healers alive in the raid"] = "",
	-- ["The percentage of people alive in the raid"] = "",
	-- ["The percentage of people dead in the raid"] = "",
	-- ["The percentage of people within 40 yards range"] = "",
	-- ["The percentage of tanks alive in the raid"] = "",
	-- ["This is the default configuration in which RBS ships out-of-the-box.  It gives you pretty much anything a raid leader would need to see on the dashboard"] = "",
	-- ["Toggle to display a minimap icon"] = "",
	-- Top = "",
	-- ["To set this option go to the addon configuration.  This button is automatically enabled when the Boss button is pressed and automatically disabled when the Trash button is pressed.  To permanently disable, choose 0 seconds as the min remaining buff duration."] = "",
	-- ["Two groups down"] = "",
	-- ["User announce"] = "",
	-- ["Version announce"] = "",
	-- ["Wait before announcing to see if others have announced first in order to reduce spam"] = "",
	-- ["Warning messages when players die"] = "",
	-- ["Warnings when Crowd Control is broken by tanks and non-tanks"] = "",
	-- ["Warnings when Misdirection or Tricks of the Trade is cast"] = "",
	-- ["Warnings when someone else targets a mob and taunts that mob which is targeting you"] = "",
	-- ["Warnings when someone else taunts your target"] = "",
	-- ["Warnings when someone else taunts your target who is not a tank"] = "",
	-- ["Warning, Trash, Boss groups"] = "",
	-- ["Warns when a non-tank breaks Crowd Control"] = "",
	-- ["Warns when a tank breaks Crowd Control"] = "",
	-- ["Warns when other people's taunts to your target fail"] = "",
	-- ["Warns when someone else taunts your target which is targeting you"] = "",
	-- ["Warns when your taunts fail due to resist"] = "",
	-- ["Warns when your taunts fail due to the target being immune"] = "",
	-- ["Warn to party"] = "",
	-- ["Warn to party when a healer dies"] = "",
	-- ["Warn to party when a melee DPS dies"] = "",
	-- ["Warn to party when a non-tank breaks Crowd Control"] = "",
	-- ["Warn to party when a ranged DPS dies"] = "",
	-- ["Warn to party when a tank breaks Crowd Control"] = "",
	-- ["Warn to party when a tank dies"] = "",
	-- ["Warn to party when one of your taunts fails due to resist"] = "",
	-- ["Warn to party when one of your taunts fails due to the target being immune"] = "",
	-- ["Warn to party when other people's taunts to your target fail"] = "",
	-- ["Warn to party when someone else targets a mob and taunts that mob which is targeting you"] = "",
	-- ["Warn to party when someone else taunts your target"] = "",
	-- ["Warn to party when someone else taunts your target which is targeting you"] = "",
	-- ["Warn to party when someone else who is not a tank taunts your target"] = "",
	-- ["Warn to raid chat"] = "",
	-- ["Warn to raid chat when a healer dies"] = "",
	-- ["Warn to raid chat when a melee DPS dies"] = "",
	-- ["Warn to raid chat when a non-tank breaks Crowd Control"] = "",
	-- ["Warn to raid chat when a ranged DPS dies"] = "",
	-- ["Warn to raid chat when a tank breaks Crowd Control"] = "",
	-- ["Warn to raid chat when a tank dies"] = "",
	-- ["Warn to raid chat when one of your taunts fails due to resist"] = "",
	-- ["Warn to raid chat when one of your taunts fails due to the target being immune"] = "",
	-- ["Warn to raid chat when other people's taunts to your target fail"] = "",
	-- ["Warn to raid chat when someone else targets a mob and taunts that mob which is targeting you"] = "",
	-- ["Warn to raid chat when someone else taunts your target"] = "",
	-- ["Warn to raid chat when someone else taunts your target which is targeting you"] = "",
	-- ["Warn to raid chat when someone else who is not a tank taunts your target"] = "",
	-- ["Warn to raid warning"] = "",
	-- ["Warn to self"] = "",
	-- ["Warn to self when a healer dies"] = "",
	-- ["Warn to self when a melee DPS dies"] = "",
	-- ["Warn to self when a non-tank breaks Crowd Control"] = "",
	-- ["Warn to self when a ranged DPS dies"] = "",
	-- ["Warn to self when a tank breaks Crowd Control"] = "",
	-- ["Warn to self when a tank dies"] = "",
	-- ["Warn to self when Misdirection or Tricks of the Trade is cast"] = "",
	-- ["Warn to self when one of your taunts fails due to resist"] = "",
	-- ["Warn to self when one of your taunts fails due to the target being immune"] = "",
	-- ["Warn to self when other people's taunts to your target fail"] = "",
	-- ["Warn to self when someone else targets a mob and taunts that mob which is targeting you"] = "",
	-- ["Warn to self when someone else taunts your target"] = "",
	-- ["Warn to self when someone else taunts your target which is targeting you"] = "",
	-- ["Warn to self when someone else who is not a tank taunts your target"] = "",
	-- ["Warn using raid warning when a healer dies"] = "",
	-- ["Warn using raid warning when a melee DPS dies"] = "",
	-- ["Warn using raid warning when a non-tank breaks Crowd Control"] = "",
	-- ["Warn using raid warning when a ranged DPS dies"] = "",
	-- ["Warn using raid warning when a tank breaks Crowd Control"] = "",
	-- ["Warn using raid warning when a tank dies"] = "",
	-- ["Warn using raid warning when one of your taunts fails due to resist"] = "",
	-- ["Warn using raid warning when one of your taunts fails due to the target being immune"] = "",
	-- ["Warn using raid warning when other people's taunts to your target fail"] = "",
	-- ["Warn using raid warning when someone else targets a mob and taunts that mob which is targeting you"] = "",
	-- ["Warn using raid warning when someone else taunts your target"] = "",
	-- ["Warn using raid warning when someone else taunts your target which is targeting you"] = "",
	-- ["Warn using raid warning when someone else who is not a tank taunts your target"] = "",
	-- ["Warn when a healer dies"] = "",
	-- ["Warn when a melee DPS dies"] = "",
	-- ["Warn when a ranged DPS dies"] = "",
	-- ["Warn when a tank dies"] = "",
	-- ["Well auto whisper"] = "",
	-- ["When at least N people are missing a raid buff say MANY instead of spamming a list"] = "",
	-- ["When many say so"] = "",
	-- ["When there are multiple people who can provide a missing buff such as Fortitude then only whisper one of them at random who is in range rather than all of them"] = "",
	-- ["When whispering and at least N people are missing a raid buff say MANY instead of spamming a list"] = "",
	-- ["Whisper buffers"] = "",
	-- ["Whisper many"] = "",
	-- ["Whisper only one"] = "",
	-- ["Your taunt immune-fails"] = "",
	-- ["Your taunt resist-fails"] = "",
}
La.RaidStatusBars = {
	-- ["Dead healers"] = "",
	-- ["Dead tanks"] = "",
	-- ["I see dead people"] = "",
	-- ["n/a"] = "",
	-- P = "",
	-- ["Pull Timer"] = "",
	-- R = "",
	-- ["Ready Check"] = "",
}
La.TalentsWindow = {
	-- Class = "",
	-- Healer = "",
	-- ["Melee DPS"] = "",
	-- Name = "",
	-- ["Ranged DPS"] = "",
	-- Refresh = "",
	-- Role = "",
	-- Spec = "",
	-- Specialisations = "",
	-- ["Talent Specialisations"] = "",
	-- Tank = "",
}
La.TankTauntWarnings = {
	-- ["NON-TANK %s taunted my boss target (%s%s%s) with %s"] = "",
	-- ["NON-TANK %s taunted my target (%s%s%s) with %s"] = "",
	-- ["%s FAILED TO NINJA my boss target (%s%s%s) with %s"] = "",
	-- ["%s FAILED TO NINJA my target (%s%s%s) with %s"] = "",
	-- ["%s FAILED TO TAUNT my boss target (%s%s%s) with %s"] = "",
	-- ["%s FAILED TO TAUNT my target (%s%s%s) with %s"] = "",
	-- ["%s FAILED TO TAUNT their boss target (%s%s%s) with %s"] = "",
	-- ["%s FAILED TO TAUNT their target (%s%s%s) with %s"] = "",
	-- ["%s ninjaed my boss target (%s%s%s) with %s"] = "",
	-- ["%s ninjaed my target (%s%s%s) with %s"] = "",
	-- ["%s taunted my boss mob (%s%s%s) with %s"] = "",
	-- ["%s taunted my boss target (%s%s%s) with %s"] = "",
	-- ["%s taunted my mob (%s%s%s) with %s"] = "",
	-- ["%s taunted my target (%s%s%s) with %s"] = "",
}

end

-- flatten namespaces
local function flatten(leaf, root)
  root = root or {}
  for key, val in pairs(leaf) do
    if type(val) == "table" then -- sub-table recursion
      flatten(val, root)
    elseif root[key] then
      print("ERROR: Duplicate localization key in namespace flattening: "..key)
    else
      root[key] = val
    end
  end
  return root
end
Ld = flatten(Ld)
La = flatten(La)


