local RL=RRH_FUNCTIONS
local L = RRH_L

function RL:RRH_FRAME_stop_move()
	RRH_FRAME:StopMovingOrSizing()
	local point, relativeTo,relativePoint, xOfs, yOfs = RRH_FRAME:GetPoint(1)
	RaidRollHelper.db.global.point=point
	RaidRollHelper.db.global.relativeTo=relativeTo
	RaidRollHelper.db.global.relativePoint=relativePoint
	RaidRollHelper.db.global.xOfs=xOfs
	RaidRollHelper.db.global.yOfs=yOfs
end

function RL:RRH_raid_list_update()
	C_Timer.After(1.5, function()
		local initUpdate=false
		local DBS={}
		if RRH_RAID_LIST~=nil then
			for k,v in pairs(RRH_RAID_LIST) do
				DBS[k]=v
			end
		end
		for i=1,GetNumGroupMembers(1) do
			local name,rank,subgroup,level,class,fileName,zone,online,isDead,role,isML,combatRole=GetRaidRosterInfo(i)
			if RRH_RAID_LIST[name]==nil and name~=nil and name~=RRH_PLAYER_NAME then
		--	add player
			--print('add '..name)
				RRH_RAID_LIST[name]={
					['rank']=rank,
					['subgroup']=subgroup,
					['level']=level,
					['class']=class,
					['className']=fileName,
					['zone']=zone,
					['online']=online,
					['isDead']=isDead,
					['role']=role,
					['isML']=isML,
					['combatRole']=combatRole,
					['ver']=false,
				}
				initUpdate=true
			end
			if DBS[name] then
				DBS[name]=nil
			end
		end
		if IsInRaid(LE_PARTY_CATEGORY_HOME) or IsInGroup(LE_PARTY_CATEGORY_HOME) and initUpdate then
			SendAddonMessage(RRH_PREFIX, RRH_PREFIX_COUNT..RRH_VER, 'RAID')
		end
		for k,v in pairs(DBS) do
	--	del player
		--print('del '..k)
			RRH_RAID_LIST[k]=nil
		end
	end)
end

function RL:declOfNum(number,Type)
	if not Type then print('USE RL:declOfNum(number,Type)');return 'FALSE' end
    number= type(number) == "number" and number or 0
    local cases = {[0]=3, [1]=1, [2]=2, [3]=2, [4]=2, [5]=3}
    local titles
	if Type == 'player' then
		titles = {L["игрока"], L["игроков"], L["игроков"]}
	end
    number = math.ceil(math.abs(number))
    return number..' '..titles[(math.fmod(number,100)>4 and math.fmod(number,100)<20) and 3 or cases[(math.fmod(number,10)<5)and math.fmod(number,10) or 5] ];
end

function RL:findAddon()
	local DB={['yes']={
			[RRH_VER]={
				[1]={['name']=RRH_PLAYER_NAME,['color']=RRH_CLASS_COLOR[RRH_PLAYER_CLASS]}
			}
		},['no']={}}
		for name,tab in pairs(RRH_RAID_LIST)do
			if tab.ver then
				if not DB.yes[tab.ver] then DB.yes[tab.ver]={} end
				DB.yes[tab.ver][#DB.yes[tab.ver]+1]={['name']=name,['color']=RRH_CLASS_COLOR[tab.className]}
			else
				DB.no[#DB.no+1]={['name']=name,['color']=RRH_CLASS_COLOR[tab.className]}
			end
		end
		local str=''
		local count=0
		local withOUT_RRH=''
		local form=L["Аддон Raid Roll Helper найден у %s."].."\n%s \n "..L["Игроки без аддона %u: %s"]
		for ver,names in pairs(DB.yes) do
			str=str..(ver==RRH_VER and '|cFF00FF96' or '|cFFC41F3B')..ver..'|r-'
			for i=1,#names do
				str=str..names[i].color..names[i].name..'|r, '
				count=count+1
			end
			str=string.gsub(str,', $', '\n')
		end
		for i=1,#DB.no do
			withOUT_RRH=withOUT_RRH..DB.no[i].color..DB.no[i].name..'|r, '
		end
		withOUT_RRH=string.gsub(withOUT_RRH,', $','')
		str=string.format(form,RL:declOfNum(count,'player'),str,#DB.no,withOUT_RRH)
		print(str)
end

function RL:newVerSound()
	if not RRH_VER_VERIFIED then
		PlaySound(8959, "Master")
		print(L["Ваша версия RaidRollHelper устарела."])
		RRH_VER_VERIFIED=true
	end
end

function RL:clearPrefix(str,prefix)
	if prefix==nil then
		local prefix='^%w+_'
		if string.find(str,prefix) then
			str=string.match(str,prefix)
			return str
		else
			return false
		end
	else
		local _prefix='^'..prefix
		if string.find(str,_prefix) then
			str=string.gsub(str,_prefix,'')
			return str
		else
			return false
		end
	end
	
end

function RL:serverINITroll(item,sender)
	for i=1,#RRH_ROLL_LIST do
		if RRH_ROLL_LIST[i][item] then
			if RRH_ROLL_LIST[i][item].ilvls[1]['sender']==RRH_PLAYER_NAME then
				SendAddonMessage(RRH_PREFIX, RRH_PREFIX_SETROLL..sender..'#'..item..'#'..RL:GetRoll(item), RRH_MSG_LOCATION)
			else
				return
			end
		end
	end
end

function RL:startTimer()
	RRH_TICKER:Cancel()
	RRH_TICKER = C_Timer.NewTicker(1, function() RL:rollTimer() end)
end

function RL:ifItemExist(itemLink)
	for bag=0, NUM_BAG_SLOTS do
		for slot = 1, GetContainerNumSlots(bag) do
			if GetContainerItemLink(bag,slot)==itemLink then return true end
		end
	end
	return false
end

function RL:deleteRoll(i)
	for i=i+1,#RRH_ROLL_LIST do
		RRH_ROLL_LIST[i-1]=RRH_ROLL_LIST[i]
	end
	RRH_ROLL_LIST[#RRH_ROLL_LIST]=nil
end

function RL:sendWinner(itemName)
	local i=0
	for n=1,#RRH_ROLL_LIST do
		if RRH_ROLL_LIST[n][itemName] then i=n;break end
	end
	if i==0 then return end
	
	local item=RRH_ROLL_LIST[i][itemName]
	for n=1,#item.ilvls do
		if item.roll[n] and item.ilvls[n].sender==RRH_PLAYER_NAME then
			local MSG=item.ilvls[n].Item_link..L[" победитель "]..item.roll[n].name
			print(MSG)
			--SendChatMessage(MSG, RRH_MSG_LOCATION)
			if IsInRaid(LE_PARTY_CATEGORY_HOME) or IsInGroup(LE_PARTY_CATEGORY_HOME) then
				SendChatMessage(MSG, IsInRaid(LE_PARTY_CATEGORY_HOME) and "RAID" or IsInGroup(LE_PARTY_CATEGORY_HOME) and "PARTY" or "")
			end
		end
	end
	
--	прогон ролов
--[[
	for j=1,#RRH_ROLL_LIST[i][itemName].roll do
		print(RRH_ROLL_LIST[i][itemName].roll[j].name..' | '..RRH_ROLL_LIST[i][itemName].roll[j].roll)
	end
]]
end

function RL:printRolls(item)
	for i=1,#RRH_ROLL_LIST do
		if RRH_ROLL_LIST[i][item] then
			for r=1,#RRH_ROLL_LIST[i][item].roll do
				if RRH_ROLL_LIST[i][item].roll[r].name==RRH_PLAYER_NAME then
					for j=1,#RRH_ROLL_LIST[i][item].roll do
						print('|cffffff00'..RRH_ROLL_LIST[i][item].roll[j].name..L[" выбрасывает "]..RRH_ROLL_LIST[i][item].roll[j].roll..' (1-100)|r')
					end
				end
			end
		end
	end
end

function RL:rollTimer()
	local cancel_timer=false
	local item=''
	for i=1,#RRH_ROLL_LIST do
	if cancel_timer then break end
		for k,v in pairs(RRH_ROLL_LIST[i]) do
			local arr=RRH_ROLL_LIST[i][k].ilvls
			local end_of_timer=RRH_ROLL_LIST[i][k].end_time
			for ii=1,#arr do
				if end_of_timer<GetTime() then cancel_timer=true; item=k; break; end
			end
		end
	end
	if cancel_timer then
		RL:sendWinner(item)
		RL:printRolls(item)
	end
	RL:upd_roll()
	if #RRH_ROLL_LIST==0 then RRH_TICKER:Cancel();RL:upd_roll() end
end

function RL:linkReplace(link)
	local itemName, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, itemEquipLoc, iconFileDataID, itemSellPrice, itemClassID, itemSubClassID,bindType, expacID, itemSetID, isCraftingReagent = GetItemInfo(link)
	link=string.gsub(link,'\124','|')
	link=string.gsub(link,itemName,itemLevel)
	link=string.gsub(link,'|','\124')
	return link
end

function RL:GetRoll(item)
	local function Roll(rolls)
		local roll=math.random(1,100)
		for i=1,#rolls do
			if rolls[i]==roll then
				roll=Roll(rolls)
			end
		end
		return roll
	end
	for i=1,#RRH_ROLL_LIST do
		if RRH_ROLL_LIST[i][item] then
			local rolls={}
			for r=1,#RRH_ROLL_LIST[i][item].roll do
				rolls[#rolls+1]=RRH_ROLL_LIST[i][item].roll[r].roll
			end
			return Roll(rolls)
		end
	end
end

function RL:SetLabel(label, text, relative, relPoint, Width)
	if Width==nil then Width=100 end
	if text==nil then text='' end
	
	local fs=label:CreateFontString('testfont', "OVERLAY", "GameFontNormal")
	fs:SetPoint("TOPLEFT",relative, relPoint, 0, 0)
	fs:SetWidth(100)
	fs:SetHeight(fs:GetStringHeight())
    fs:SetText(text)
		
	label:SetPoint("TOPLEFT",relative, relPoint, 0, 0)
	label:SetWidth(100)
	label:SetHeight(fs:GetStringHeight())
end

function RL:SetTexture(obj,texture)
	local tex = obj:CreateTexture()
		tex:SetTexture(texture)
		tex:SetAllPoints()
end

function RL:SetButton(button, text, relative, relPoint, Width, Height)
	if Width==nil then Width=100 end
	if Height==nil then Height=24 end
	if text==nil then text='' end
	
	button:SetText(text)
	button:SetNormalFontObject("GameFontNormal")
	if relative and relPoint then
		button:SetPoint("TOPLEFT",relative,relPoint,0,0)
	end
	button:SetWidth(Width)
	button:SetHeight(Height)
	
	local ntex = button:CreateTexture()
	ntex:SetTexture("Interface/Buttons/UI-Panel-Button-Up")
	ntex:SetTexCoord(0, 0.625, 0, 0.6875)
	ntex:SetAllPoints()	
	button:SetNormalTexture(ntex)
	
	local htex = button:CreateTexture()
	htex:SetTexture("Interface/Buttons/UI-Panel-Button-Highlight")
	htex:SetTexCoord(0, 0.625, 0, 0.6875)
	htex:SetAllPoints()
	button:SetHighlightTexture(htex)
	
	local ptex = button:CreateTexture()
	ptex:SetTexture("Interface/Buttons/UI-Panel-Button-Down")
	ptex:SetTexCoord(0, 0.625, 0, 0.6875)
	ptex:SetAllPoints()
	button:SetPushedTexture(ptex)
end

function RL:SetICO(texture)
	if texture==nil then texture=134414 end
	RRH_ICO.tex:SetTexture(texture)
	RRH_ICO.tex:SetAllPoints()
end

function RL:SetFrame(frame, Width, Height, EnableMouse, SetMovable)
	local function MoverSizer_OnMouseUp(mover)
		local frame = mover:GetParent()
		frame:StopMovingOrSizing()
		local self = frame.obj
		local status = self.status or self.localstatus
		status.width = frame:GetWidth()
		status.height = frame:GetHeight()
		status.top = frame:GetTop()
		status.left = frame:GetLeft()
	end
	local function Title_OnMouseDown(frame)
		frame:GetParent():StartMoving()
		AceGUI:ClearFocus()
	end
	
	if EnableMouse==nil then EnableMouse=false end
	if SetMovable==nil then SetMovable=false end
	if Width==nil then Width=100 end
	if Height==nil then Height=100 end
	
	local tex = frame:CreateTexture(nil, "BACKGROUND")
	tex:SetAllPoints()
	tex:SetColorTexture(0, 0, 0, 0.5)
	
	frame:SetBackdropColor(0, 0, 0, 1)
	frame:EnableMouse(EnableMouse)
	frame:SetMovable(SetMovable)
	frame:SetWidth(Width)
	frame:SetHeight(Height)
	frame:SetPoint("CENTER",UIParent,0,0)
end

function RL:dump(o)
	if type(o) == 'table' then
		local s = '{ \n'
		for k,v in pairs(o) do
		if k~=nil then
			if v==nil then v='nil' end
			if type(k) ~= 'number' then k = '"'..k..'"' end
				s = s .. '['..k..'] = ' .. RL:dump(v) .. ',\n'
			end
		end
			return s .. '} \n'
		else
			return tostring(o)
	end
end

function RL:split(inputstr, sep)
	if sep == nil then sep = "%s" end
	local t={} ; i=1
	for str in string.gmatch(inputstr, "([^"..sep.."]+)") do
		t[i] = str
		i = i + 1
	end
	return t
end

function RL:makeHash(leng)
	if leng==nil then leng=10 end
		local text = "";
		local possible = "abcdefghijklmnopqrstuvwxyzQWERTYUIOPASDFGHJKLZXCVBNM1234567890";
		for i=0,leng do
		local charAt=math.floor(math.random()*string.len(possible))
		text=text..possible:sub(charAt,charAt)
	end
		return text;
end

function RL:spairs(t, order)
		-- collect the keys
		local keys = {}
		for k in pairs(t) do keys[#keys+1] = k end

		-- if order function given, sort by it by passing the table and keys a, b,
		-- otherwise just sort the keys 
		if order then
				table.sort(keys, function(a,b) return order(t, a, b) end)
		else
				table.sort(keys)
		end

		-- return the iterator function
		local i = 0
		return function()
				i = i + 1
				if keys[i] then
						return keys[i], t[keys[i]]
				end
		end
end

function RL:comma_value(amount)
	local formatted = amount
	while true do	
		formatted, k = string.gsub(formatted, "^(-?%d+)(%d%d%d)", '%1,%2')
		if (k==0) then
			break
		end
	end
	return formatted
end

function RL:round(val, decimal)
	if (decimal) then
		return math.floor( (val * 10^decimal) + 0.5) / (10^decimal)
	else
		return math.floor(val+0.5)
	end
end

function RL:format_num(amount, decimal, prefix, neg_prefix)
	local str_amount,	formatted, famount, remain

	decimal = decimal or 2	-- default 2 decimal places
	neg_prefix = neg_prefix or "-" -- default negative sign

	famount = math.abs(round(amount,decimal))
	famount = math.floor(famount)

	remain = round(math.abs(amount) - famount, decimal)

				-- comma to separate the thousands
	formatted = comma_value(famount)

				-- attach the decimal portion
	if (decimal > 0) then
		remain = string.sub(tostring(remain),3)
		formatted = formatted .. "," .. remain ..
								string.rep("0", decimal - string.len(remain))
	end

				-- attach prefix string e.g '$' 
	formatted = (prefix or "") .. formatted 

				-- if value is negative then format accordingly
	if (amount<0) then
		if (neg_prefix=="()") then
			formatted = "("..formatted ..")"
		else
			formatted = neg_prefix .. formatted 
		end
	end

	return formatted
end

function RL:sortRoll(a)
	local arr=a
	for _=1,#arr do
		local last=10000
		for i=1,#arr do
			local _temp
			if arr[i].roll>last then
				_temp=arr[i-1]
				arr[i-1]=arr[i]
				arr[i]=_temp
			end
			last=arr[i].roll
		end
	end
return arr
end

function RL:sortilvls(a)
	local arr=a
	for _=1,#arr do
		local last=10000
		for i=1,#arr do
			local _temp
			if arr[i].ilvl>last then
				_temp=arr[i-1]
				arr[i-1]=arr[i]
				arr[i]=_temp
			end
			last=arr[i].ilvl
		end
	end
return arr
end

function RL:needListUpdate()
	RRH_NEED_LIST_TEXT='<html><body></body></html>'
	local needList=''--string.match(RRH_NEED_LIST_TEXT,"<body>(.*)</body>")
	local exist=false
	for i=1,#RRH_ROLL_LIST do
		for k,v in pairs(RRH_ROLL_LIST[i]) do
			for ii=1,#RRH_ROLL_LIST[i][k].roll do
				if RRH_ROLL_LIST[i][k].roll[ii].name==RRH_PLAYER_NAME then
					local link=RRH_ROLL_LIST[i][k].ilvls[1].Item_link
					needList=needList..'<p>'..link..' '..math.ceil(RRH_ROLL_LIST[i][k].end_time-GetTime())..'</p>'
					for iii=1,#RRH_ROLL_LIST[i][k].roll do
						needList=needList..'<p>'..RRH_ROLL_LIST[i][k].roll[iii].name..':'..RRH_ROLL_LIST[i][k].roll[iii].roll..'</p>'
					end
					exist=true
				end
			end
		end
	end
	RRH_NEED_LIST:ClearAllPoints()
	if RRH_GROUP:IsVisible() then
		RRH_NEED_LIST:SetPoint("TOPRIGHT",RRH_FRAME, "TOPRIGHT", 0, 0)
		RRH_NEED_LIST:SetWidth(RRH_FRAME:GetWidth()-RRH_GROUP:GetWidth())
	else
		RRH_NEED_LIST:SetPoint("TOPLEFT",RRH_FRAME, "TOPLEFT", 0, 0)
		RRH_NEED_LIST:SetWidth(RRH_FRAME:GetWidth())
	end
	if not RRH_GROUP:IsVisible() and not exist then
		RRH_FRAME:Hide()
	elseif not RRH_FORCE_HIDE_FRAME then
		RRH_FRAME:Show()
	end
	RRH_NEED_LIST_TEXT=RRH_NEED_LIST_TEXT:gsub(RRH_NEED_LIST_TEXT:match("<body>.*(</body>)"),needList.."%1")
	RRH_NEED_LIST:SetText(RRH_NEED_LIST_TEXT)

end
function RL:upd_roll()
	--RRH_FRAME, RRH_GROUP, RRH_ICO, RRH_ILVLS, RRH_NEEDBTN, RRH_FALSEBTN
	if #RRH_ROLL_LIST==0 then
		RRH_NEEDBTN:SetScript('OnClick', function() end)
		RRH_FALSEBTN:SetScript('OnClick', function() end)
		RRH_GROUP:Hide()
	end
	local isDel=false
	RL:needListUpdate()
	for i=1,#RRH_ROLL_LIST do
		local isShow=false
		if isDel then RL:upd_roll();break end
		for k,v in pairs(RRH_ROLL_LIST[i]) do
			--local itemName, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, itemEquipLoc, iconFileDataID, itemSellPrice, itemClassID, itemSubClassID,bindType, expacID, itemSetID, isCraftingReagent = GetItemInfo(RRH_ROLL_LIST[i][k].Item_link)
			if RRH_ROLL_LIST[i][k].end_time<GetTime()  then
				RL:deleteRoll(i);isDel=true
			else
				if RRH_ROLL_LIST[i][k].hide then break end
				if not RRH_FORCE_HIDE_FRAME then RRH_FRAME:Show();RRH_GROUP:Show() end
				local fsHeight=13
				
				RRH_TIMER_LINE.text:SetText(string.format(L["Осталось: %u сек"],math.ceil(RRH_ROLL_LIST[i][k].end_time-GetTime())))
				
				RL:SetICO(RRH_ROLL_LIST[i][k].ico)
				
				
				local ilvls=''
				local senders=''
				RRH_ROLL_LIST[i][k].ilvls=RL:sortilvls(RRH_ROLL_LIST[i][k].ilvls)
				for ii=1,#RRH_ROLL_LIST[i][k].ilvls do
					local ilvl=RRH_ROLL_LIST[i][k].ilvls[ii].ilvl
					local link=RRH_ROLL_LIST[i][k].ilvls[ii].Item_link
					local itemName, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, itemEquipLoc, iconFileDataID, itemSellPrice, itemClassID, itemSubClassID,bindType, expacID, itemSetID, isCraftingReagent = GetItemInfo(RRH_ROLL_LIST[i][k].ilvls[ii].Item_link)
					--ilvls=ilvls..RRH_ROLL_LIST[i][k].ilvls[ii].ilvl..'\n'
					ilvls=ilvls..'<h1 align="center">'..RL:linkReplace(link)..'</h1>'..'\n'
					senders=senders..RRH_ROLL_LIST[i][k].ilvls[ii].sender..'#'
				end
			--	RRH_ILVLS - 8 strings
				RRH_ILVLS:SetText('<html><body>'..ilvls..'</body></html>')
				RRH_ILVLS:SetScript('OnHyperlinkEnter',function(self,link)
					GameTooltip:SetOwner(UIParent, "ANCHOR_CURSOR")
					GameTooltip:SetHyperlink(link)
				end)
				
				RRH_NEED_LIST:SetScript('OnHyperlinkEnter',function(self,link)
					GameTooltip:SetOwner(UIParent, "ANCHOR_CURSOR")
					GameTooltip:SetHyperlink(link)
				end)
				RRH_NEED_LIST:SetScript('OnHyperlinkLeave',function() GameTooltip:Hide() end)
				RRH_ILVLS:SetScript('OnHyperlinkLeave',function() GameTooltip:Hide() end)
				RRH_FRAME:SetScript('OnEnter',function() GameTooltip:Hide() end)
				RRH_NEED_LIST:SetScript('OnEnter',function() GameTooltip:Hide() end)
				RRH_ILVLS:SetScript('OnEnter',function() GameTooltip:Hide() end)
				RRH_NEED_LIST:SetScript('OnLeave',function() GameTooltip:Hide() end)
				RRH_ICO:SetScript('OnLeave',function() GameTooltip:Hide() end)
				
				
				RRH_NEEDBTN:SetScript('OnClick', function()
					RRH_ROLL_LIST[i][k].hide=true
					SendAddonMessage(RRH_PREFIX, RRH_PREFIX_GETROLL..k, RRH_MSG_LOCATION)
					RL:upd_roll()
				end)
				RRH_FALSEBTN:SetScript('OnClick', function()
					RRH_ROLL_LIST[i][k].hide=true
					RL:upd_roll() 
				end)
				isShow=true
			end
		end
		if isShow then
			break
		else
			RRH_NEEDBTN:SetScript('OnClick', function() end)
			RRH_FALSEBTN:SetScript('OnClick', function() end)
			RRH_GROUP:Hide()
		end
		
	end
end