RRH_VER=2.5
RRH_BETA=false


RaidRollHelper = LibStub("AceAddon-3.0"):NewAddon("RaidRollHelper")
local Console = LibStub("AceConsole-3.0")
LibStub("AceEvent-3.0"):Embed(RaidRollHelper)
local AceGUI = LibStub("AceGUI-3.0")
-- roll timer
RRH_TICKER = C_Timer.NewTicker(1, function() RL:rollTimer() end)
RRH_TICKER:Cancel()

RRH_RAID_LIST={}
RRH_ROLL_LIST={}
--		SETTINGS
local L = RRH_L
local classDisplayName, class, classID= UnitClass("player");RRH_PLAYER_CLASS=class
RRH_PLAYER_NAME=GetUnitName('player', false)
RRH_FONT='Interface\\AddOns\\RaidRollHelper\\fonts\\PT_Sans_Narrow.ttf' -- RU font
local timeToRoll=60
local start_hide=true
RRH_FORCE_HIDE_FRAME=false
RRH_VER_VERIFIED=false
RRH_MSG_LOCATION="RAID"
RRH_PREFIX			='RRHelp'
RRH_PREFIX_NEWROLL	='new_'
RRH_PREFIX_GETROLL	='get_'
RRH_PREFIX_SETROLL	='set_'
RRH_PREFIX_VER		='ver_'
RRH_PREFIX_COUNT	='count_'
RRH_CLASS_COLOR={
	['WARRIOR']='|cffc79c6e',
	['PALADIN']='|cfff58cba',
	['HUNTER']='|cffabd473',
	['ROGUE']='|cfffff569',
	['PRIEST']='|cffffffff',
	['DEATHKNIGHT']='|cffc41f3b',
	['SHAMAN']='|cff0070de',
	['MAGE']='|cff3fc7eb',
	['WARLOCK']='|cff8788ee',
	['MONK']='|cff00ff96',
	['DRUID']='|cffff7d0a',
	['DEMONHUNTER']='|cffa330c9',
}
local RL=RRH_FUNCTIONS
--		/SETTINGS

function RaidRollHelper:OnEnable()
	RegisterAddonMessagePrefix(RRH_PREFIX)
	
	local rollWidth,rollHeight=250,300
	local LeftSize=100
	local RightSize=rollWidth-LeftSize
	local groupWidth,groupHeight=100,rollHeight-25
	
	local raidtest=CreateFrame("Frame",'raid_test',UIParent)
		raidtest:RegisterEvent('GROUP_ROSTER_UPDATE')
		raidtest:SetScript('OnEvent',function() RL:RRH_raid_list_update() end)
--	current version find
	local cur_ver=CreateFrame("Frame",'current_version_find',UIParent)
		cur_ver:RegisterEvent('PLAYER_ENTERING_WORLD')
		cur_ver:SetScript('OnEvent',function(event)
			if not RRH_BETA and not RRH_VER_VERIFIED then
				SendAddonMessage(RRH_PREFIX, RRH_PREFIX_VER..RRH_VER,'GUILD')
			end
			if IsInRaid(LE_PARTY_CATEGORY_HOME) or IsInGroup(LE_PARTY_CATEGORY_HOME) then
				RL:RRH_raid_list_update()
			end
		end)
	
	RRH_FRAME=CreateFrame("Frame",'RaidRollHelperFrame',UIParent)
	RL:SetFrame(RRH_FRAME,rollWidth,rollHeight,true,true)
		RRH_FRAME:SetScript("OnMouseDown", function() RRH_FRAME:StartMoving() end)
		RRH_FRAME:SetScript("OnMouseUp", function() RL:RRH_FRAME_stop_move() end)
		if RaidRollHelper.db.global.point then
			RRH_FRAME:ClearAllPoints()
			RRH_FRAME:SetPoint(
				RaidRollHelper.db.global.point,
				RaidRollHelper.db.global.relativeTo,
				RaidRollHelper.db.global.relativePoint,
				RaidRollHelper.db.global.xOfs,
				RaidRollHelper.db.global.yOfs
			)
		end

	RRH_GROUP=CreateFrame("Frame",'RaidRollHelper_group',RRH_FRAME)
		RL:SetFrame(RRH_GROUP,groupWidth,groupHeight)
		RRH_GROUP:SetPoint("TOPLEFT",0,0)
	
	RRH_TIMER_LINE=CreateFrame("Frame",'RaidRollTimerLine',RRH_GROUP)
		RRH_TIMER_LINE:SetPoint("TOPLEFT", RRH_GROUP,'TOPLEFT', 0, 0)
		RRH_TIMER_LINE:SetWidth(groupWidth)
		RRH_TIMER_LINE:SetHeight(25)
		
		RRH_TIMER_LINE.text=RRH_TIMER_LINE:CreateFontString()
		RRH_TIMER_LINE.text:SetPoint("CENTER")
		RRH_TIMER_LINE.text:SetFont(RRH_FONT, 12)
		RRH_TIMER_LINE.text:SetText(string.format(L["Осталось: %u сек"],15))
	
	RRH_ICO=CreateFrame("Frame",'RaidRollHelper_ICO',RRH_GROUP)
		RRH_ICO:SetScript("OnMouseDown", function() RRH_FRAME:StartMoving() end)
		RRH_ICO:SetScript("OnMouseUp", function() RL:RRH_FRAME_stop_move() end)
		RRH_ICO:SetPoint("TOPLEFT",RRH_TIMER_LINE,"BOTTOMLEFT",0,0)
		RRH_ICO:SetWidth(LeftSize)
		RRH_ICO:SetHeight(LeftSize)
		RRH_ICO.tex=RRH_ICO:CreateTexture()
		RL:SetICO()
		
	RRH_ILVLS=CreateFrame("SimpleHTML",'RaidRollHelper_ilvls',RRH_GROUP)
		RRH_ILVLS:SetText('<html><body><p>ilvls List</p></body></html>');
		RRH_ILVLS:SetFont(RRH_FONT, 12);
		RRH_ILVLS:SetWidth(LeftSize)
		RRH_ILVLS:SetHeight(100)
		RRH_ILVLS:SetPoint("TOPLEFT",RRH_ICO, "BOTTOMLEFT", 0, 0)
		
	RRH_NEEDBTN=CreateFrame("Button", 'RaidRollHelper_needButton',RRH_GROUP)
		RL:SetButton(RRH_NEEDBTN, L["Нужно"], RRH_ILVLS,"BOTTOMLEFT")
		
	RRH_FALSEBTN=CreateFrame("Button", 'RaidRollHelper_falseButton',RRH_GROUP)
		RL:SetButton(RRH_FALSEBTN, L["Отказаться"],RRH_NEEDBTN,"BOTTOMLEFT")
	
	RRH_NEED_LIST=CreateFrame("SimpleHTML",'RaidRollHelper_needList',RRH_FRAME)
		RRH_NEED_LIST:SetText('<html><body><p>Need List</p></body></html>');
		RRH_NEED_LIST:SetFont(RRH_FONT, 12);
		RRH_NEED_LIST:SetWidth(RightSize)
		RRH_NEED_LIST:SetHeight(groupHeight)
		RRH_NEED_LIST:SetPoint("TOPRIGHT",RRH_FRAME, "TOPRIGHT", 0, 0)
		RRH_NEED_LIST:SetScript("OnMouseDown", function() RRH_FRAME:StartMoving() end)
		RRH_NEED_LIST:SetScript("OnMouseUp", function()
			RRH_FRAME:StopMovingOrSizing()
			local point, relativeTo,relativePoint, xOfs, yOfs = RRH_FRAME:GetPoint(1)
			RaidRollHelper.db.global.point=point
			RaidRollHelper.db.global.relativeTo=relativeTo
			RaidRollHelper.db.global.relativePoint=relativePoint
			RaidRollHelper.db.global.xOfs=xOfs
			RaidRollHelper.db.global.yOfs=yOfs
		end)
	
	closeRaidRollHelper=CreateFrame("Button", 'RaidRollHelper_closeRaidRollHelper	',RRH_FRAME)
		closeRaidRollHelper:SetPoint("BOTTOM",RRH_FRAME,"BOTTOM",0,0)
		RL:SetButton(closeRaidRollHelper, L["Закрыть"])
		closeRaidRollHelper:SetWidth(rollWidth)
		closeRaidRollHelper:SetScript('OnClick', function() RRH_FRAME:Hide();RRH_FORCE_HIDE_FRAME=true end)
		
	
	local MSGincoming = CreateFrame("Frame")
		MSGincoming:RegisterEvent("CHAT_MSG_ADDON")
		MSGincoming:SetScript("OnEvent", function(self, event, ...)
			local prefix,item,channel,sender=...
			local senderFULL=sender
			sender=RL:split(sender,'-')[1]
		--	addon && addon_ver FILTER
			if prefix~=RRH_PREFIX then return end
			--print(prefix,item,channel,sender)
			
			prefix=RL:clearPrefix(item)			-- prefix new_/get_/...
			item=RL:clearPrefix(item,prefix)	-- MSG without prefix
			local itemName, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, itemEquipLoc, iconFileDataID, itemSellPrice, itemClassID, itemSubClassID,bindType, expacID, itemSetID, isCraftingReagent = GetItemInfo(item)
			local itemID=tonumber(string.match(item,'item:([0-9]+):'))
			if prefix==RRH_PREFIX_NEWROLL then
				print(string.format(L["Ролл был успешно отправлен. %s"],item))
				RRH_FORCE_HIDE_FRAME=false
				local hide=false
			--	relic FILTER
				if itemSubType==L["Реликвия артефакта"] then
					local _,_,relicType,_=C_ArtifactUI.GetRelicInfoByItemID(string.match(item,'item:(%d+)'))
					if not ITEM_CLASS_NEED["Artifact Relic"][relicType][RRH_PLAYER_CLASS] then hide=true end
			--	itemTYPE FILTER cloak/other types
				elseif not ((itemSubType==L["Тканевые"] and itemEquipLoc=='INVTYPE_CLOAK') or itemSubType==L["Разное"]) then
					if ITEM_CLASS_NEED[itemSubType] and not ITEM_CLASS_NEED[itemSubType][RRH_PLAYER_CLASS] then hide=true end
				end
			--	sender FILTER
				if sender==RRH_PLAYER_NAME then hide=true end
				
				local exist=false
				for i=1,#RRH_ROLL_LIST do
					if RRH_ROLL_LIST[i][itemName]~=nil then exist=i;break; end
				end
			--	itemSet FILTER
				if ITEM_CLASS_NEED.set[itemID] and ITEM_CLASS_NEED.set[itemID]~=RRH_PLAYER_CLASS then hide=true end
				
				if exist then
			--	if double new_roll
					for i=1,#RRH_ROLL_LIST[exist][itemName].ilvls do
						if RRH_ROLL_LIST[exist][itemName].ilvls[i].sender==sender then return end
					end
					
					RRH_ROLL_LIST[exist][itemName]['ilvls'][#RRH_ROLL_LIST[exist][itemName]['ilvls']+1]={
						['sender']=sender,['ilvl']=itemLevel,['Item_link']=item
					}
					RRH_ROLL_LIST[exist][itemName]['end_time']=GetTime()+timeToRoll
				else
					RRH_ROLL_LIST[#RRH_ROLL_LIST+1]={}
					RRH_ROLL_LIST[#RRH_ROLL_LIST][itemName]={}
					RRH_ROLL_LIST[#RRH_ROLL_LIST][itemName]['link']=item
					RRH_ROLL_LIST[#RRH_ROLL_LIST][itemName]['ico']=iconFileDataID
					RRH_ROLL_LIST[#RRH_ROLL_LIST][itemName]['roll']={
					--[[
						[1]={['name']='name1',['roll']=5},
						[2]={['name']='name2',['roll']=99},
						[3]={['name']='name3',['roll']=7},
						[4]={['name']='name4',['roll']=16}
					]]
					}
					RRH_ROLL_LIST[#RRH_ROLL_LIST][itemName]['ilvls']={
					--[[
						[1]={['sender']='n1',['ilvl']=935,['Item_link']=GetContainerItemLink(0,2)},
						[2]={['sender']='n2',['ilvl']=920,['Item_link']=GetContainerItemLink(0,3)},
						[3]={['sender']='n3',['ilvl']=955,['Item_link']=GetContainerItemLink(0,4)}
					]]
					}
					RRH_ROLL_LIST[#RRH_ROLL_LIST][itemName]['ilvls'][#RRH_ROLL_LIST[#RRH_ROLL_LIST][itemName]['ilvls']+1]={
						['sender']=sender,['ilvl']=itemLevel,['Item_link']=item
					}
					RRH_ROLL_LIST[#RRH_ROLL_LIST][itemName]['end_time']=GetTime()+timeToRoll
					RRH_ROLL_LIST[#RRH_ROLL_LIST][itemName]['hide']=hide
				end
				
				RL:startTimer()
			elseif prefix==RRH_PREFIX_SETROLL then
				local i=0
				local name,itemName,ROLL=RL:split(item,'#')[1],RL:split(item,'#')[2],tonumber(RL:split(item,'#')[3])
			--	GET i
				for n=1,#RRH_ROLL_LIST do
					if RRH_ROLL_LIST[n][itemName] then i=n;break end
				end
				if i==0 then return end
				
			--	if double roll
				local exist=false
				for n=1,#RRH_ROLL_LIST[i][itemName].roll do
					if RRH_ROLL_LIST[i][itemName].roll[n].name==name then exist=true;break; end
				end
				
				if not exist then
					RRH_ROLL_LIST[i][itemName].roll[#RRH_ROLL_LIST[i][itemName].roll+1]={['name']=name,['roll']=ROLL}
					RRH_ROLL_LIST[i][itemName].roll=RL:sortRoll(RRH_ROLL_LIST[i][itemName].roll)
				end
			elseif prefix==RRH_PREFIX_GETROLL then
				RL:serverINITroll(item,sender)
			elseif prefix==RRH_PREFIX_VER and sender~=RRH_PLAYER_NAME then
				local ver=tonumber(item)
				if RRH_VER>ver and channel~='WHISPER' and not RRH_BETA then
					SendAddonMessage(RRH_PREFIX, RRH_PREFIX_VER..RRH_VER, 'WHISPER', senderFULL)
				elseif RRH_VER<ver then
					RL:newVerSound()
				end
			elseif prefix==RRH_PREFIX_COUNT and sender~=RRH_PLAYER_NAME then
				local ver=tonumber(item)
				if channel=='WHISPER' then
					if not RRH_RAID_LIST[sender] then
						RRH_RAID_LIST[sender]={}
					end
					RRH_RAID_LIST[sender]['ver']=ver
				else
					SendAddonMessage(RRH_PREFIX, RRH_PREFIX_COUNT..RRH_VER, 'WHISPER', senderFULL)
				end
			end
		end)
	Console:RegisterChatCommand('ro', 'RaidRollHelperStart')
	Console:RegisterChatCommand('rrh', 'RaidRollHelperStart')
	
	if start_hide then
		RRH_FRAME:Hide()
	end
end


function Console:RaidRollHelperStart(str)
	if str=='' then Console:RaidRollHelperHelp();return end
	if str=='reset' then
		RaidRollHelper.db.global.point=nil
		RaidRollHelper.db.global.relativeTo=nil
		RaidRollHelper.db.global.relativePoint=nil
		RaidRollHelper.db.global.xOfs=nil
		RaidRollHelper.db.global.yOfs=nil
		RRH_FRAME:ClearAllPoints()
		RRH_FRAME:SetPoint("CENTER",UIParent,"CENTER",0,0)
		print(L["Позиция по умолчанию"])
		return
	elseif str=='find' then
	--	количество игроков с аддоном
		RL:findAddon();return
	end
	
	local itemName, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, itemEquipLoc, iconFileDataID, itemSellPrice, itemClassID, itemSubClassID,bindType, expacID, itemSetID, isCraftingReagent = GetItemInfo(str)
	
--	if item not exist in bags	
	if not RL:ifItemExist(itemLink) then print(L["Предмет не найден в сумках"]);return end
--	if not relic or armor
	if not (itemType==L["Самоцвет"] and itemSubType==L["Реликвия артефакта"]) and not itemType==L["Доспехи"] then print(L["Предмет не является доспехом или реликвией артефакта"]);return end
	
	SendAddonMessage(RRH_PREFIX, RRH_PREFIX_NEWROLL..itemLink, RRH_MSG_LOCATION)
	--/run SendAddonMessage(RRH_PREFIX, RRH_PREFIX_VER..'1', 'GUILD')
end

function RaidRollHelper:OnLoad()
	
end

function RaidRollHelper:OnInitialize()
	self.db = LibStub("AceDB-3.0"):New("RaidRollHelperDB")
end

function RaidRollHelper:OnDisable()
	
end

function Console:RaidRollHelperHelp() -- Подсказки в игре
	print("|cFFFFFFFFRaidRollHelper v_"..RRH_VER..(RRH_BETA and "(beta_v"..RRH_BETA..")" or '').."|r |cFFFF99FF(=^..^=)|r:")
	print("/|cFFFF99FFro|r find - "..L["подсчет количества игроков в рейде с аддоном Raid Roll Helper"])
	print("/|cFFFF99FFro|r reset - "..L["вернуть окно ролла в середину экрана"])
	print("/|cFFFF99FFro|r itemLink - "..L["отправить предмет на ролл"].."\n"..
			L["itemLink help"].."\n"..
			"|cFFFF99FFitemLink|r - |cffa335ee|Hitem:151311::::::::110:270::2:3:1726:1517:3528:::|h[Печать Триумвирата]|h|r")
end