# Raid-Notes

World of Warcraft Classic Addon to organize and share raid boss notes with a 4-screen navigation system.

## Description

**Raid-Notes** is a comprehensive raid organization addon for WoW Classic that helps you create, store, and share boss strategies across all raid content from Classic through Mists of Pandaria. Features an intuitive 4-screen navigation system (Expansions → Raids → Bosses → Notes), persistent note storage, quick raid shortcuts (like `/rn mc` for Molten Core), and instant strategy sharing with `/rn mc ragnaros announce`. Perfect for raid leaders and players who want organized, accessible boss notes with seamless raid chat integration.

## Features
- **4-Screen Navigation**: Expansions → Raids → Bosses → Notes
- **Complete Raid Coverage**: All raids from Classic through Mists of Pandaria
- **Persistent Notes**: SavedVariables keeps your notes between sessions
- **Multi-line Text Editor**: 255-character notes with proper text wrapping
- **Quick Access**: Raid shortcuts for instant navigation
- **Raid Chat Integration**: Announce strategies with raid warning option
- **Copy/Paste Support**: Easy text selection and copying

## Installation
1. Extract to `World of Warcraft/_classic_/Interface/AddOns/Raid-Notes/`
2. Reload UI or restart WoW
3. Use `/rn` to open the addon

## Usage

### Basic Commands
- `/rn` or `/raidnotes` - Open main expansion list
- `/rn help` - Show available shortcuts

### Quick Navigation (Raid Shortcuts)
Open directly to specific raid boss lists:

**Classic:**
- `/rn mc` - Molten Core
- `/rn bwl` - Blackwing Lair  
- `/rn zg` - Zul'Gurub
- `/rn aq20` - Ruins of Ahn'Qiraj
- `/rn aq40` - Temple of Ahn'Qiraj
- `/rn ony` - Onyxia's Lair
- `/rn naxx` - Naxxramas

**The Burning Crusade:**
- `/rn kara` - Karazhan
- `/rn gruul` - Gruul's Lair
- `/rn mag` - Magtheridon's Lair
- `/rn ssc` - Serpentshrine Cavern
- `/rn tk` - Tempest Keep
- `/rn hyjal` - Hyjal Summit
- `/rn bt` - Black Temple
- `/rn swp` - Sunwell Plateau

**Wrath of the Lich King:**
- `/rn voa` - Vault of Archavon
- `/rn os` - Obsidian Sanctum
- `/rn eoe` - Eye of Eternity
- `/rn uld` - Ulduar
- `/rn toc` - Trial of the Crusader
- `/rn icc` - Icecrown Citadel
- `/rn rs` - Ruby Sanctum

**Cataclysm:**
- `/rn bwd` - Blackwing Descent
- `/rn bot` - The Bastion of Twilight
- `/rn totfw` - Throne of the Four Winds
- `/rn bh` - Baradin Hold
- `/rn fl` - Firelands
- `/rn ds` - Dragon Soul

**Mists of Pandaria:**
- `/rn msv` - Mogu'shan Vaults
- `/rn hof` - Heart of Fear
- `/rn tes` - Terrace of Endless Spring
- `/rn tot` - Throne of Thunder
- `/rn soo` - Siege of Orgrimmar

### Advanced Commands

**Open Specific Boss Notes:**
- `/rn classic mc ragnaros` - Open Ragnaros notes directly
- `/rn tbc bt illidan` - Open Illidan notes directly
- `/rn wotlk icc lich` - Open Lich King notes directly

**Announce Boss Strategies:**
- `/rn mc ragnaros announce` - Send Ragnaros strategy to raid chat
- `/rn bwl nef ann` - Send Nefarian strategy (short form)
- `/rn aq40 cthun announce` - Send C'Thun strategy

### UI Features

**Text Editor:**
- Multi-line editing with Enter key for new lines
- 255-character limit with live counter
- Auto-save on text changes
- Click anywhere in text area to focus

**Buttons:**
- **Announce**: Send note to raid chat (`/ra`) or raid warning (`/rw`)
- **Copy**: Select all text for manual copying (Ctrl+C)
- **Raid Warning**: Checkbox to send as raid warning instead of normal raid chat

**Navigation:**
- Back buttons to return to previous screens
- Breadcrumb titles showing current location
- Clean UI with proper button spacing

## Examples

**Quick raid prep:**
```
/rn mc rag announce    # Share Ragnaros strategy
/rn mc baron announce  # Share Baron Geddon strategy
```

**Open specific notes for editing:**
```
/rn aq40 cthun         # Edit C'Thun strategy
/rn bwl chromaggus     # Edit Chromaggus strategy  
```

**Navigate to raid:**
```
/rn mc                 # Open Molten Core boss list
/rn icc                # Open Icecrown Citadel boss list
```

## Technical Details
- **Interface**: 11404 (WoW Classic)
- **SavedVariables**: RaidNotesDB (per-character storage)
- **Chat Integration**: Uses SendChatMessage API
- **UI Framework**: WoW's native CreateFrame system
