local RUF = RUF or LibStub("AceAddon-3.0"):GetAddon("RUF")
local L = LibStub("AceLocale-3.0"):GetLocale("RUF")
local LSM = LibStub("LibSharedMedia-3.0")
local _, ns = ...
local oUF = ns.oUF
local _, PlayerClass = UnitClass('player')
local ShouldEnable, pType, UnitSettingsDone
local AnchorSwaps = {
	["BOTTOM"] = "TOP",
	["BOTTOMLEFT"] = "TOPRIGHT",
	["BOTTOMRIGHT"] = "TOPLEFT",
	["CENTER"] = "CENTER",
	["LEFT"] = "RIGHT",
	["RIGHT"] = "LEFT",
	["TOP"] = "BOTTOM",
	["TOPLEFT"] = "BOTTOMRIGHT",
	["TOPRIGHT"] = "BOTTOMLEFT",
}


function RUF:PopUp(name,tv,b1v)
	StaticPopupDialogs[name] = {
		text = tv,
		button1 = b1v,
		--button2 = "No",
		OnAccept = function()
			--GreetTheWorld()
			ReloadUI()			
		end,
		timeout = 0,
		whileDead = true,
		hideOnEscape = false,
		showAlert = true,
		preferredIndex = 3,  -- avoid some UI taint, see http://www.wowace.com/announcements/how-to-avoid-some-ui-taint/
	  }
end

function RUF:OnInitialize()
	self.db = LibStub("AceDB-3.0"):New("RUFDB", RUF.Layout.cfg, true) -- Setup Saved Variables
	local LibDualSpec = LibStub('LibDualSpec-1.0')
	LibDualSpec:EnhanceDatabase(self.db, "RUF")
	
	-- Register /RUF command
	self:RegisterChatCommand("RUF", "ChatCommand")

	-- Profile Management
	self.db.RegisterCallback(self, "OnProfileChanged", "RefreshConfig")
	self.db.RegisterCallback(self, "OnProfileCopied", "RefreshConfig")
	self.db.RegisterCallback(self, "OnProfileReset", "RefreshConfig")

	-- Register Media
	LSM:Register("font", "RUF", [[Interface\Addons\RUF\Media\TGL.ttf]],LSM.LOCALE_BIT_ruRU + LSM.LOCALE_BIT_western)
	LSM:Register("statusbar", "RUF 1", [[Interface\Addons\RUF\Media\Raeli 1.tga]])
	LSM:Register("statusbar", "RUF 2", [[Interface\Addons\RUF\Media\Raeli 2.tga]])
	LSM:Register("statusbar", "RUF 3", [[Interface\Addons\RUF\Media\Raeli 3.tga]])
	LSM:Register("statusbar", "RUF 4", [[Interface\Addons\RUF\Media\Raeli 4.tga]])
	LSM:Register("statusbar", "RUF 5", [[Interface\Addons\RUF\Media\Raeli 5.tga]])
	LSM:Register("statusbar", "RUF 6", [[Interface\Addons\RUF\Media\Raeli 6.tga]])
	LSM:Register("statusbar", "Armory",[[Interface\Addons\RUF\Media\Extra\Armory.tga]])
	LSM:Register("statusbar", "Cabaret 2", [[Interface\Addons\RUF\Media\Extra\Cabaret 2.tga]]) 
	RUF.db.global.TestMode = false
	RUF.db.global.Lock = true
	if RUF.db.global.Version then
		if RUF.db.global.Version < 75 then
			RUF.db:ResetDB()
			RUF:PopUp("RUF_Upgrade","RUF |c5500DBBDRaeli's Unit Frames|r has had significant changes since that last version you have installed. \nUnfortunately, I have had to reset all settings. This shouldn't have to happen again in the future.\n\n I apologise for the inconvenience.","Ok, Reload my UI")
			StaticPopup_Show("RUF_Upgrade")
		end
	end
	RUF.db.global.Version = 75


	do -- Register Class Bar Variable Values
		if(PlayerClass == 'MONK') then
			RUF.db.char.ClassPowerID = 12
			RUF.db.char.ClassPowerType = "CHI"
			RUF.db.char.RequireSpec = SPEC_MONK_WINDWALKER
		elseif(PlayerClass == 'PALADIN') then
			RUF.db.char.ClassPowerID = 9
			RUF.db.char.ClassPowerType = "HOLY_POWER"
			RUF.db.char.RequireSpec = SPEC_PALADIN_RETRIBUTION
		elseif(PlayerClass == 'WARLOCK') then
			RUF.db.char.ClassPowerID = 7
			RUF.db.char.ClassPowerType = "SOUL_SHARDS"
		elseif(PlayerClass == 'ROGUE' or PlayerClass == 'DRUID') then
			RUF.db.char.ClassPowerID = 4
			RUF.db.char.ClassPowerType = 'COMBO_POINTS'
			if(PlayerClass == 'DRUID') then
				RUF.db.char.RequireSpell = 5221 -- Shred
			end
		elseif(PlayerClass == 'MAGE') then
			RUF.db.char.ClassPowerID = 16
			RUF.db.char.ClassPowerType = 'ARCANE_CHARGES'
			RUF.db.char.RequireSpec = SPEC_MAGE_ARCANE
		elseif(PlayerClass == 'DEATHKNIGHT') then
			RUF.db.char.ClassPowerID = 5
			RUF.db.char.ClassPowerType = 'RUNES'
		else
			RUF.db.char.ClassPowerID = nil
			RUF.db.char.ClassPowerType = nil
			RUF.db.char.RequireSpec = nil
			RUF.db.char.RequireSpell = nil
		end
	end

	
	RUF.db.global.UnitList = { -- Store Unit List in DB for easy reference.
		[1] = {
			name = "player",
			group = "",
			frame = "oUF_RUF_Player",
			order = 1,
		},
		[2] = {
			name = "pet",
			group = "",
			frame = "oUF_RUF_Pet",
			order = 2,
		},
		[3] = {
			name = "target",
			group = "",
			frame = "oUF_RUF_Target",
			order = 3,
		},
		[4] = {
			name = "targettarget",
			group = "",
			frame = "oUF_RUF_TargetTarget",
			order = 4,
		},
		[5] = {
			name = "focus",
			group = "",
			frame = "oUF_RUF_Focus",
			order = 5,
		},
		[6] = {
			name = "boss1",
			group = "boss",
			frame = "oUF_RUF_Boss1",
		},
		[7] = {
			name = "boss2",
			group = "boss",
			frame = "oUF_RUF_Boss2",
		},
		[8] = {
			name = "boss3",
			group = "boss",
			frame = "oUF_RUF_Boss3",
		},
		[9] = {
			name = "boss4",
			group = "boss",
			frame = "oUF_RUF_Boss4",
		},
		[10] = {
			name = "arena1",
			group = "arena",
			frame = "oUF_RUF_Arena1",
		},
		[11] = {
			name = "arena2",
			group = "arena",
			frame = "oUF_RUF_Arena2",
		},
		[12] = {
			name = "arena3",
			group = "arena",
			frame = "oUF_RUF_Arena3",
		},
		[13] = {
			name = "arena4",
			group = "arena",
			frame = "oUF_RUF_Arena4",
		},
		[14] = {
			name = "arena5",
			group = "arena",
			frame = "oUF_RUF_Arena5",
		},
		[15] = {
			name = "party1",
			group = "party",
			frame = "oUF_RUF_PartyUnitButton1",
		},
		[16] = {
			name = "party2",
			group = "party",
			frame = "oUF_RUF_PartyUnitButton2",
		},
		[17] = {
			name = "party3",
			group = "party",
			frame = "oUF_RUF_PartyUnitButton3",
		},
		[18] = {
			name = "party4",
			group = "party",
			frame = "oUF_RUF_PartyUnitButton4",
		},
		[19] = {
			name = "focustarget",
			group = "",
			frame = "oUF_RUF_FocusTarget",
			order = 5,
		},
		[20] = {
			name = "pettarget",
			group = "",
			frame = "oUF_RUF_PetTarget",
			order = 2,
		},
		[21] = {
			name = "bosstarget1",
			group = "bosstarget",
			frame = "oUF_RUF_BossTarget1",
		},
		[22] = {
			name = "bosstarget2",
			group = "bosstarget",
			frame = "oUF_RUF_BossTarget2",
		},
		[23] = {
			name = "bosstarget3",
			group = "bosstarget",
			frame = "oUF_RUF_Boss3Targe3",
		},
		[24] = {
			name = "bosstarget4",
			group = "bosstarget",
			frame = "oUF_RUF_Boss4Targe4",
		},
		[25] = {
			name = "arenatarget1",
			group = "arenatarget",
			frame = "oUF_RUF_ArenaTarget1",
		},
		[26] = {
			name = "arenatarget2",
			group = "arenatarget",
			frame = "oUF_RUF_ArenaTarget2",
		},
		[27] = {
			name = "arenatarget3",
			group = "arenatarget",
			frame = "oUF_RUF_ArenaTarget3",
		},
		[28] = {
			name = "arenatarget4",
			group = "arenatarget",
			frame = "oUF_RUF_ArenaTarget4",
		},
		[29] = {
			name = "arenatarget5",
			group = "arenatarget",
			frame = "oUF_RUF_ArenaTarget5",
		},
		[30] = {
			name = "partytarget1",
			group = "partytarget",
			frame = "oUF_RUF_PartyTarget1",
		},
		[31] = {
			name = "partytarget2",
			group = "partytarget",
			frame = "oUF_RUF_PartyTarget2",
		},
		[32] = {
			name = "partytarget3",
			group = "partytarget",
			frame = "oUF_RUF_PartyTarget3",
		},
		[33] = {
			name = "partytarget4",
			group = "partytarget",
			frame = "oUF_RUF_PartyTarget4",
		},
	}

	if not RUFDB.profiles["Alidie's Layout"] then
		RUFDB.profiles["Alidie's Layout"] = RUF.Layout.Alidie
	end
	if not RUFDB.profiles["Raeli's Layout"] then
		RUFDB.profiles["Raeli's Layout"] = RUF.Layout.Raeli
	end
end

local function HealthPreUpdate(element, unit)
	for i = 1,8 do
		element.__owner.colors.reaction[i][1] = RUF.db.profile.Appearance.Colors.ReactionColors[i][1]
		element.__owner.colors.reaction[i][2] = RUF.db.profile.Appearance.Colors.ReactionColors[i][2]
		element.__owner.colors.reaction[i][3] = RUF.db.profile.Appearance.Colors.ReactionColors[i][3]
	end
	element.__owner.colors.Tapping = RUF.db.profile.Appearance.Colors.MiscColors.Tapped
	element.__owner.colors.Disconnected = RUF.db.profile.Appearance.Colors.MiscColors.Disconnected
	element.__owner.colors.class.DEATHKNIGHT = RUF.db.profile.Appearance.Colors.ClassColors.DEATHKNIGHT
	element.__owner.colors.class.DEMONHUNTER = RUF.db.profile.Appearance.Colors.ClassColors.DEMONHUNTER
	element.__owner.colors.class.DRUID = RUF.db.profile.Appearance.Colors.ClassColors.DRUID
	element.__owner.colors.class.HUNTER = RUF.db.profile.Appearance.Colors.ClassColors.HUNTER
	element.__owner.colors.class.MAGE = RUF.db.profile.Appearance.Colors.ClassColors.MAGE
	element.__owner.colors.class.MONK = RUF.db.profile.Appearance.Colors.ClassColors.MONK
	element.__owner.colors.class.PALADIN = RUF.db.profile.Appearance.Colors.ClassColors.PALADIN
	element.__owner.colors.class.PRIEST = RUF.db.profile.Appearance.Colors.ClassColors.PRIEST
	element.__owner.colors.class.ROGUE = RUF.db.profile.Appearance.Colors.ClassColors.ROGUE
	element.__owner.colors.class.SHAMAN = RUF.db.profile.Appearance.Colors.ClassColors.SHAMAN
	element.__owner.colors.class.WARLOCK = RUF.db.profile.Appearance.Colors.ClassColors.WARLOCK
	element.__owner.colors.class.WARRIOR = RUF.db.profile.Appearance.Colors.ClassColors.WARRIOR
	element.__owner.colors.power.MANA = RUF.db.profile.Appearance.Colors.PowerColors[0]
	element.__owner.colors.power.RAGE = RUF.db.profile.Appearance.Colors.PowerColors[1]
	element.__owner.colors.power.FOCUS = RUF.db.profile.Appearance.Colors.PowerColors[2]
	element.__owner.colors.power.ENERGY = RUF.db.profile.Appearance.Colors.PowerColors[3]
	element.__owner.colors.power.COMBO_POINTS = RUF.db.profile.Appearance.Colors.PowerColors[4]
	element.__owner.colors.power.RUNES = RUF.db.profile.Appearance.Colors.PowerColors[5]
	element.__owner.colors.power.RUNIC_POWER = RUF.db.profile.Appearance.Colors.PowerColors[6]
	element.__owner.colors.power.SOUL_SHARDS = RUF.db.profile.Appearance.Colors.PowerColors[7]
	element.__owner.colors.power.LUNAR_POWER = RUF.db.profile.Appearance.Colors.PowerColors[8]
	element.__owner.colors.power.HOLY_POWER = RUF.db.profile.Appearance.Colors.PowerColors[9]
	element.__owner.colors.power.MAELSTROM = RUF.db.profile.Appearance.Colors.PowerColors[11]
	element.__owner.colors.power.CHI = RUF.db.profile.Appearance.Colors.PowerColors[12]
	element.__owner.colors.power.INSANITY = RUF.db.profile.Appearance.Colors.PowerColors[13]
	element.__owner.colors.power.ARCANE_CHARGES = RUF.db.profile.Appearance.Colors.PowerColors[16]
	element.__owner.colors.power.FURY = RUF.db.profile.Appearance.Colors.PowerColors[17]
	element.__owner.colors.power.PAIN = RUF.db.profile.Appearance.Colors.PowerColors[18]

	element.__owner.colors.runes[1] = RUF.db.profile.Appearance.Colors.PowerColors[50]--Blood
	element.__owner.colors.runes[2] = RUF.db.profile.Appearance.Colors.PowerColors[51]--Frost
	element.__owner.colors.runes[3] = RUF.db.profile.Appearance.Colors.PowerColors[52]--Unholy

	element.__owner.Health.colorClass = RUF.db.profile.Appearance.Bars.Health.Color.Class
	element.__owner.Health.colorDisconnected = RUF.db.profile.Appearance.Bars.Health.Color.Disconnected
	element.__owner.Health.colorSmooth = RUF.db.profile.Appearance.Bars.Health.Color.Percentage
	element.__owner.Health.smoothGradient = RUF.db.profile.Appearance.Bars.Health.Color.PercentageGradient
	element.__owner.Health.colorReaction = RUF.db.profile.Appearance.Bars.Health.Color.Reaction
	element.__owner.Health.colorTapping = RUF.db.profile.Appearance.Bars.Health.Color.Tapped
	element.__owner.Health.colorHealth = true
	element.__owner.colors.health = RUF.db.profile.Appearance.Bars.Health.Color.BaseColor
	element.__owner.Health.Smooth = RUF.db.profile.Appearance.Bars.Health.Animate
	element.__owner.colors.Tapping = RUF.db.profile.Appearance.Colors.MiscColors.Tapped
	element.__owner.colors.Disconnected = RUF.db.profile.Appearance.Colors.MiscColors.Disconnected
end

local function HealthPostUpdate(element, unit, cur, max)
	-- Background
	local r,g,b = unpack(RUF.db.profile.Appearance.Bars.Health.Background.CustomColor)
	local Multiplier = 1
	if RUF.db.profile.Appearance.Bars.Health.Background.UseBarColor then 
		r,g,b = _G[element.__owner:GetName() .. ".Health.Bar"]:GetStatusBarColor()
		Multiplier = RUF.db.profile.Appearance.Bars.Health.Background.Multiplier
	end	
	_G[element.__owner:GetName() .. ".Health.Background"]:SetVertexColor(r*Multiplier,g*Multiplier,b*Multiplier,RUF.db.profile.Appearance.Bars.Health.Background.Alpha)
	if RUF.db.profile.Appearance.Bars.Health.Color.Reaction then
		if UnitPlayerControlled(unit) and not UnitCanAttack(unit,"player") and not UnitIsPlayer(unit) then  -- If the unit is an allied pet then show as blue.
			local r,g,b = unpack(RUF.db.profile.Appearance.Colors.ReactionColors[10])
			_G[element.__owner:GetName() .. ".Health.Bar"]:SetStatusBarColor(r,g,b)		
		end
	end
end

local function SetHealth(self, unit)
	local Texture = LSM:Fetch("statusbar", RUF.db.profile.Appearance.Bars.Health.Texture)	
	local Name = self:GetName()
	local Bar = CreateFrame("StatusBar",Name..".Health.Bar",self)
	local Background = Bar:CreateTexture(Name..".Health.Background","BACKGROUND")	
	
	-- Bar
	Bar.colorClass = RUF.db.profile.Appearance.Bars.Health.Color.Class
	Bar.colorDisconnected = RUF.db.profile.Appearance.Bars.Health.Color.Disconnected
	Bar.colorSmooth = RUF.db.profile.Appearance.Bars.Health.Color.Percentage
	Bar.smoothGradient = RUF.db.profile.Appearance.Bars.Health.Color.PercentageGradient
	Bar.colorReaction = RUF.db.profile.Appearance.Bars.Health.Color.Reaction
	Bar.colorTapping = RUF.db.profile.Appearance.Bars.Health.Color.Tapped
	Bar.colorHealth = true -- BaseColor, always enabled, so if none of the other colors match, it falls back to this.
	Bar.Smooth = RUF.db.profile.Appearance.Bars.Health.Animate
	Bar:SetStatusBarTexture(Texture)
	Bar:SetAllPoints(self)
	Bar:SetFrameLevel(1)
	Bar:SetFillStyle(RUF.db.profile.unit[unit].Frame.Bars.Health.Fill)
	
	-- Background
	local r,g,b = unpack(RUF.db.profile.Appearance.Bars.Health.Background.CustomColor)
	local Multiplier = RUF.db.profile.Appearance.Bars.Health.Background.Multiplier
	Background:SetTexture(LSM:Fetch("background", "Solid"))
	Background:SetVertexColor(r*Multiplier,g*Multiplier,b*Multiplier,RUF.db.profile.Appearance.Bars.Health.Background.Alpha)
	Background:SetAllPoints(Bar)

	-- Register with oUF
	self.Health = Bar
end

local function AdditionalPowerUpdate(self, event, unit, ...)
	if unit ~= "player" then return end
	if not RUF.db.profile.unit[unit] then return end
	local element = self.AdditionalPower
	if(element.PreUpdate) then element:PreUpdate(unit) end
	local cur = UnitPower('player', 0)
	local max = UnitPowerMax('player', 0)
	element:SetMinMaxValues(0, max)
	element:SetValue(cur)
	if(element.PostUpdate) then
		return element:PostUpdate(unit, cur, max)
	end
end

local function OverrideVisibility(self, event, unit)
	self:RegisterEvent('UNIT_POWER_FREQUENT', AdditionalPowerUpdate)
	self:RegisterEvent('UNIT_MAXPOWER', AdditionalPowerUpdate)
	AdditionalPowerUpdate(self, 'Test', 'player', ADDITIONAL_POWER_BAR_NAME)
end

local function PowerPostUpdate(element, unit, cur, min, max) -- Update ShadowPriest Mana too
	if not unit then return end
	if unit == "vehicle" then return end
	if not RUF.db.profile.unit[unit] then return end
	pType = (select(2,UnitPowerType("player")))
	if RUF:GetSpec() == 1 and element.__owner:GetName() == "oUF_RUF_Player" then -- Correct Class and Player
		if RUF.db.profile.unit.player.Frame.Bars.Class.Enabled then
			RUF:UpdateElementColor(element,"Power","Power")
			RUF:UpdateElementColor(element,"Class","AdditionalPower")
			local Multiplier = RUF.db.profile.Appearance.Bars.Class.Background.Multiplier
			local r,g,b = unpack(RUF.db.profile.Appearance.Colors.PowerColors[0])
			element.__owner.AdditionalPower:SetStatusBarColor(r,g,b)
			element.__owner.AdditionalPower.bg:SetVertexColor(r*Multiplier,g*Multiplier,b*Multiplier,RUF.db.profile.Appearance.Bars.Class.Background.Alpha)			
			if pType ~= "MANA" then
				if RUF.db.profile.unit[unit].Frame.Bars.Class.Enabled then
					RUF:BarVisibility(element, "Power", true)
				else
					RUF:BarVisibility(element, "Power", false)
				end

				if RUF.db.profile.unit[unit].Frame.Bars.Power.Enabled > 0 then
					RUF:BarVisibility(element, "AdditionalPower", true)
				else
					RUF:BarVisibility(element, "AdditionalPower", false)
				end
			else
				RUF:BarVisibility(element, "Power", false)
				if RUF.db.profile.unit[unit].Frame.Bars.Power.Enabled > 0 then
					RUF:BarVisibility(element, "AdditionalPower", true)
				else
					RUF:BarVisibility(element, "AdditionalPower", false)
				end
			end
			element.__owner.AdditionalPower:ClearAllPoints()
			element.__owner.AdditionalPower:SetPoint('LEFT',0,0)
			element.__owner.AdditionalPower:SetPoint('RIGHT',0,0)
			element.__owner.Power:ClearAllPoints()
			element.__owner.Power:SetPoint('LEFT',0,0)
			element.__owner.Power:SetPoint('RIGHT',0,0)

			if RUF.db.profile.unit.player.Frame.Bars.Power.Position.Anchor ~= RUF.db.profile.unit.player.Frame.Bars.Class.Position.Anchor then
				element.__owner.AdditionalPower:SetPoint(RUF.db.profile.unit.player.Frame.Bars.Power.Position.Anchor,0,0)-- Move AdditionalPower (Mana)
				element.__owner.AdditionalPower:SetHeight(RUF.db.profile.unit.player.Frame.Bars.Power.Height)					
				element.__owner.Power:SetPoint(RUF.db.profile.unit.player.Frame.Bars.Class.Position.Anchor,0,0)-- Move Power (Insanity, Maelstrom)
				element.__owner.Power:SetHeight(RUF.db.profile.unit.player.Frame.Bars.Class.Height)
			elseif RUF.db.profile.unit.player.Frame.Bars.Power.Position.Anchor == RUF.db.profile.unit.player.Frame.Bars.Class.Position.Anchor then
				if RUF.db.profile.unit.player.Frame.Bars.Power.Position.Order == 0 then
					element.__owner.AdditionalPower:SetPoint(RUF.db.profile.unit.player.Frame.Bars.Power.Position.Anchor,0,0)-- Move AdditionalPower
					element.__owner.AdditionalPower:SetHeight(RUF.db.profile.unit.player.Frame.Bars.Power.Height)
					element.__owner.Power:SetHeight(RUF.db.profile.unit.player.Frame.Bars.Class.Height)
					if element.__owner.AdditionalPower:IsShown() then-- Move Power Offset to AdditionalPower
						if RUF.db.profile.unit.player.Frame.Bars.Power.Position.Anchor == "TOP" then-- Move down by height of the Mana bar.
							element.__owner.Power:SetPoint(RUF.db.profile.unit.player.Frame.Bars.Class.Position.Anchor,0,- RUF.db.profile.unit.player.Frame.Bars.Power.Height +1)
						else-- Move up by height of Mana bar.
							element.__owner.Power:SetPoint(RUF.db.profile.unit.player.Frame.Bars.Class.Position.Anchor,0,RUF.db.profile.unit.player.Frame.Bars.Power.Height -1)
						end
					else
						element.__owner.Power:SetPoint(RUF.db.profile.unit.player.Frame.Bars.Class.Position.Anchor,0,0)
					end
				else
					element.__owner.Power:SetPoint(RUF.db.profile.unit.player.Frame.Bars.Class.Position.Anchor,0,0)-- Move Power (Insanity, Maelstrom)
					element.__owner.Power:SetHeight(RUF.db.profile.unit.player.Frame.Bars.Class.Height)
					element.__owner.AdditionalPower:SetHeight(RUF.db.profile.unit.player.Frame.Bars.Power.Height)-- Move AdditionalPower Offset to Power
					
					if element.__owner.Power:IsShown() then-- Move AdditionalPower Offset to Power
						if RUF.db.profile.unit.player.Frame.Bars.Power.Position.Anchor == "TOP" then
							element.__owner.AdditionalPower:SetPoint(RUF.db.profile.unit.player.Frame.Bars.Power.Position.Anchor,0,-RUF.db.profile.unit.player.Frame.Bars.Class.Height +1)
						else
							element.__owner.AdditionalPower:SetPoint(RUF.db.profile.unit.player.Frame.Bars.Power.Position.Anchor,0,RUF.db.profile.unit.player.Frame.Bars.Class.Height -1)
						end
					else
						element.__owner.AdditionalPower:SetPoint(RUF.db.profile.unit.player.Frame.Bars.Power.Position.Anchor,0,0)
					end
				end
			end
		else
			if element.__owner.AdditionalPower:IsShown() then
				if RUF.db.profile.unit.player.Frame.Bars.Power.Enabled == 0 then 
					RUF:BarVisibility(element, "AdditionalPower", false)
				end
				RUF:UpdateElementColor(element,"Class","AdditionalPower")
				local Multiplier = RUF.db.profile.Appearance.Bars.Class.Background.Multiplier
				local r,g,b = unpack(RUF.db.profile.Appearance.Colors.PowerColors[0])
				element.__owner.AdditionalPower:SetStatusBarColor(r,g,b)
				element.__owner.AdditionalPower.bg:SetVertexColor(r*Multiplier,g*Multiplier,b*Multiplier,RUF.db.profile.Appearance.Bars.Class.Background.Alpha)
				element.__owner.AdditionalPower:ClearAllPoints()
				element.__owner.AdditionalPower:SetPoint('LEFT',0,0)
				element.__owner.AdditionalPower:SetPoint('RIGHT',0,0)
				element.__owner.AdditionalPower:SetPoint(RUF.db.profile.unit.player.Frame.Bars.Power.Position.Anchor,0,0)
			end
			RUF:BarVisibility(element, "Power", false)
		end
	elseif RUF:GetSpec() == 2 and element.__owner:GetName() == "oUF_RUF_Player" then
		RUF:BarVisibility(element, "AdditionalPower", false)
		local a,_,_,x,y = element.__owner.Power:GetPoint(3)
		if a ~= RUF.db.profile.unit.player.Frame.Bars.Power.Position.Anchor then
			element.__owner.Power:ClearAllPoints()
			element.__owner.Power:SetPoint('LEFT',0,0)
			element.__owner.Power:SetPoint('RIGHT',0,0)
			element.__owner.Power:SetPoint(RUF.db.profile.unit.player.Frame.Bars.Power.Position.Anchor,0,0)
			element.__owner.Power:SetHeight(RUF.db.profile.unit.player.Frame.Bars.Power.Height)
		end
		RUF:PowerShouldDisplay(element, unit, cur)
	elseif RUF:GetSpec() == 3 and element.__owner:GetName() == "oUF_RUF_Player" then -- Has Class Power but not one of the previous classes.
		RUF:PowerShouldDisplay(element, unit, cur)
		RUF:MoveBars(element, unit)
	else
		RUF:PowerShouldDisplay(element, unit, cur)
		RUF:MoveBars(element, unit)
	end

	--[[if PlayerClass == "PRIEST" or PlayerClass == "SHAMAN" or PlayerClass == "DRUID" then		
		if pType == "MANA" and element.__owner:GetName() == "oUF_RUF_Player" then 
			element.__owner.TextParent.Power.Text:UpdateTag()
			element.__owner.TextParent.Class:Hide()
		elseif RUF.db.profile.unit[unit].Frame.Text.Class.Enabled == 2 and element.__owner:GetName() == "oUF_RUF_Player"  then
			element.__owner.TextParent.Power.Text:UpdateTag()
			element.__owner.TextParent.Class:Show()
		elseif RUF.db.profile.unit[unit].Frame.Text.Class.Enabled == 1 and element.__owner:GetName() == "oUF_RUF_Player"  then
			if UnitPower(unit,0) > 0 then
				element.__owner.TextParent.Power.Text:UpdateTag()
				element.__owner.TextParent.Class:Show()
			else
				element.__owner.TextParent.Power.Text:UpdateTag()
				element.__owner.TextParent.Class:Hide()
			end
		elseif RUF.db.profile.unit[unit].Frame.Text.Class.Enabled == 0 and element.__owner:GetName() == "oUF_RUF_Player" then
			element.__owner.TextParent.Power.Text:UpdateTag()
			element.__owner.TextParent.Class:Hide()
		end
	end]]--

	local r,g,b = RUF:GetPowerColor(element, unit)
	element.__owner.Power:SetStatusBarColor(r,g,b)
	local Multiplier = RUF.db.profile.Appearance.Bars.Power.Background.Multiplier
	if RUF.db.profile.Appearance.Bars.Power.Background.UseBarColor == false then
		r,g,b = unpack(RUF.db.profile.Appearance.Bars.Power.Background.CustomColor)
	end
	element.__owner.Power.bg:SetVertexColor(r*Multiplier,g*Multiplier,b*Multiplier,RUF.db.profile.Appearance.Bars.Power.Background.Alpha)

	local FrameIndex = RUF:UnitToIndex(unit)
	RUF:UpdateHealthBackground(FrameIndex)
end	

local function SetPower(self, unit) -- Mana, Rage, Insanity, Maelstrom etc.
	local Texture = LSM:Fetch("statusbar", RUF.db.profile.Appearance.Bars.Power.Texture)	
	local Name = self:GetName()
	local Bar = CreateFrame("StatusBar",Name..".Power.Bar",self)
	local Border = CreateFrame("Frame",Name..".Power.Border",self) --/run print(oUF_RUF_Player.Power:GetParent():GetName())
	local Background = Bar:CreateTexture(Name..".Power.Background","BACKGROUND")	
	
	-- Bar
	Bar.colorClass = RUF.db.profile.Appearance.Bars.Power.Color.Class
	Bar.colorDisconnected = RUF.db.profile.Appearance.Bars.Power.Color.Disconnected
	Bar.colorSmooth = RUF.db.profile.Appearance.Bars.Power.Color.Percentage
	Bar.smoothGradient = RUF.db.profile.Appearance.Bars.Power.Color.PercentageGradient
	Bar.colorReaction = RUF.db.profile.Appearance.Bars.Power.Color.Reaction
	Bar.colorTapping = RUF.db.profile.Appearance.Bars.Power.Color.Tapped
	Bar.colorPower = RUF.db.profile.Appearance.Bars.Power.Color.PowerType
	Bar.Smooth = RUF.db.profile.Appearance.Bars.Power.Animate
	Bar:SetStatusBarTexture(Texture)
	Bar:SetFrameLevel(5)
	Bar:SetFillStyle(RUF.db.profile.unit[unit].Frame.Bars.Power.Fill)
	
	-- Bar Position
	local function SetTopBot()
		if RUF.db.profile.unit.player.Frame.Bars.Power.Position.Anchor == "TOP" then
			Bar:SetPoint('TOP',0,0)
			Bar:SetPoint('LEFT',0,0)
			Bar:SetPoint('RIGHT',0,0)
			Bar:SetHeight(RUF.db.profile.unit[unit].Frame.Bars.Power.Height)
		elseif RUF.db.profile.unit.player.Frame.Bars.Power.Position.Anchor == "BOTTOM" then
			Bar:SetPoint('BOTTOM',0,0)
			Bar:SetPoint('LEFT',0,0)
			Bar:SetPoint('RIGHT',0,0)
			Bar:SetHeight(RUF.db.profile.unit[unit].Frame.Bars.Power.Height) 		
		end
	end
	if unit == "player" and RUF.db.char.ClassPowerID then
		if RUF.db.profile.unit.player.Frame.Bars.Class.Position.Anchor == RUF.db.profile.unit.player.Frame.Bars.Power.Position.Anchor then
			if RUF.db.profile.unit.player.Frame.Bars.Power.Position.Order == 0 then
				SetTopBot()
			elseif RUF.db.profile.unit.player.Frame.Bars.Power.Position.Anchor == "TOP" then
				Bar:SetPoint('TOP',0,-RUF.db.profile.unit[unit].Frame.Bars.Class.Height)
				Bar:SetPoint('LEFT',0,0)
				Bar:SetPoint('RIGHT',0,0)
				Bar:SetHeight(RUF.db.profile.unit[unit].Frame.Bars.Power.Height)
			elseif RUF.db.profile.unit.player.Frame.Bars.Power.Position.Anchor == "BOTTOM" then
				Bar:SetPoint('BOTTOM',0,RUF.db.profile.unit[unit].Frame.Bars.Power.Height)
				Bar:SetPoint('LEFT',0,0)
				Bar:SetPoint('RIGHT',0,0)
				Bar:SetHeight(RUF.db.profile.unit[unit].Frame.Bars.Power.Height) 		
			end
		else
			SetTopBot()
		end
	else
		SetTopBot()
	end
	
	-- Border
	Border:SetAllPoints(Bar)
	Border:SetFrameLevel(7)
	Border:SetBackdrop(RUF.db.profile.Appearance.Border.Style)
	Border:SetBackdropBorderColor(0,0,0,1)
	
	-- Background
	local r,g,b = unpack(RUF.db.profile.Appearance.Bars.Power.Background.CustomColor)
	local Multiplier = RUF.db.profile.Appearance.Bars.Power.Background.Multiplier
	Background:SetTexture(LSM:Fetch("background", "Solid"))
	Background:SetVertexColor(r*Multiplier,g*Multiplier,b*Multiplier,RUF.db.profile.Appearance.Bars.Power.Background.Alpha)
	Background:SetAllPoints(Bar)
	Background.colorSmooth = false

	-- Register with oUF
	self.Power = Bar
	self.Power.border = Border
	self.Power.bg = Background	
end

local function SetAdditionalPower(self, unit) -- Mana for Shadow Priests
	local Texture = LSM:Fetch("statusbar", RUF.db.profile.Appearance.Bars.Class.Texture)	
	local Name = self:GetName()
	local Bar = CreateFrame("StatusBar",Name..".AdditionalPower.Bar",self)
	local Border = CreateFrame("Frame",Name..".AdditionalPower.Border",self) --/run print(oUF_RUF_Player.Class:GetParent():GetName())
	local Background = Bar:CreateTexture(Name..".AdditionalPower.Background","BACKGROUND")	
	
	-- Bar
	Bar.colorClass = RUF.db.profile.Appearance.Bars.Class.Color.Class
	Bar.colorDisconnected = RUF.db.profile.Appearance.Bars.Class.Color.Disconnected
	Bar.colorSmooth = RUF.db.profile.Appearance.Bars.Class.Color.Percentage
	Bar.smoothGradient = RUF.db.profile.Appearance.Bars.Class.Color.PercentageGradient
	Bar.colorReaction = RUF.db.profile.Appearance.Bars.Class.Color.Reaction
	Bar.colorTapping = RUF.db.profile.Appearance.Bars.Class.Color.Tapped
	Bar.colorPower = RUF.db.profile.Appearance.Bars.Class.Color.PowerType
	Bar.Smooth = RUF.db.profile.Appearance.Bars.Class.Animate
	Bar:SetStatusBarTexture(Texture)
	Bar:SetFrameLevel(5)
	Bar:SetFillStyle(RUF.db.profile.unit[unit].Frame.Bars.Class.Fill)
	
	-- Bar Position
	local function SetTopBot()
		if RUF.db.profile.unit.player.Frame.Bars.Class.Position.Anchor== "TOP" then
			Bar:SetPoint('TOP',0,0)
			Bar:SetPoint('LEFT',0,0)
			Bar:SetPoint('RIGHT',0,0)
			Bar:SetHeight(RUF.db.profile.unit[unit].Frame.Bars.Class.Height)
		elseif RUF.db.profile.unit.player.Frame.Bars.Class.Position.Anchor == "BOTTOM" then
			Bar:SetPoint('BOTTOM',0,0)
			Bar:SetPoint('LEFT',0,0)
			Bar:SetPoint('RIGHT',0,0)
			Bar:SetHeight(RUF.db.profile.unit[unit].Frame.Bars.Class.Height) 		
		end
	end	
	if unit == "player" and RUF.db.profile.unit.player.Frame.Bars.Power.Position.Enabled then -- Unnecessary because we only generate this on Player.
		if RUF.db.profile.unit.player.Frame.Bars.Class.Position.Anchor == RUF.db.profile.unit.player.Frame.Bars.Power.Position.Anchor then
			if RUF.db.profile.unit.player.Frame.Bars.Power.Position.Order == 1 then
				SetTopBot()
			else
		if RUF.db.profile.unit.player.Frame.Bars.Class.Position.Anchor == "TOP" then
			Bar:SetPoint('TOP',0,-RUF.db.profile.unit[unit].Frame.Bars.Class.Height)
			Bar:SetPoint('LEFT',0,0)
			Bar:SetPoint('RIGHT',0,0)
			Bar:SetHeight(RUF.db.profile.unit[unit].Frame.Bars.Class.Height)
		elseif RUF.db.profile.unit.player.Frame.Bars.Class.Position.Anchor == "BOTTOM" then
			Bar:SetPoint('BOTTOM',0,RUF.db.profile.unit[unit].Frame.Bars.Class.Height)
			Bar:SetPoint('LEFT',0,0)
			Bar:SetPoint('RIGHT',0,0)
			Bar:SetHeight(RUF.db.profile.unit[unit].Frame.Bars.Class.Height) 		
		end
			end
		else
			SetTopBot()
		end
	else
		SetTopBot()
	end
	
	-- Border
	Border:SetAllPoints(Bar)
	Border:SetFrameLevel(7)
	Border:SetBackdrop(RUF.db.profile.Appearance.Border.Style)
	Border:SetBackdropBorderColor(0,0,0,1)


	-- Background
	local r,g,b = unpack(RUF.db.profile.Appearance.Bars.Class.Background.CustomColor)
	local Multiplier = RUF.db.profile.Appearance.Bars.Class.Background.Multiplier
	Background:SetTexture(LSM:Fetch("background", "Solid"))
	Background:SetVertexColor(r*Multiplier,g*Multiplier,b*Multiplier,RUF.db.profile.Appearance.Bars.Class.Background.Alpha)
	Background:SetAllPoints(Bar)
	Background.colorSmooth = false

	-- Register with oUF
	self.AdditionalPower = Bar
	self.AdditionalPower.border = Border
	self.AdditionalPower.bg = Background

	local _, unitClass = UnitClass(unit)
	if UnitPowerMax(unit, ADDITIONAL_POWER_BAR_INDEX) ~= 0 then
		if(ALT_MANA_BAR_PAIR_DISPLAY_INFO[unitClass]) then
			local powerType = UnitPowerType(unit)
			ShouldEnable = ALT_MANA_BAR_PAIR_DISPLAY_INFO[unitClass][powerType]
		end
	end
	if not ShouldEnable then
		self.AdditionalPower:Hide()
		self.AdditionalPower.border:Hide()
		self.AdditionalPower.bg:Hide()
	end
end

local function ClassPostUpdate(element, cur, max, hasMaxChanged, powerType)
	if not _G[element.__owner:GetName() .. ".Class"]:IsShown() then return end
	local r,g,b = RUF:GetClassColor("player")
	local UnitPowerMaxAmount = UnitPowerMax("player", RUF.db.char.ClassPowerID)			
	local Multiplier = RUF.db.profile.Appearance.Bars.Class.Background.Multiplier
	local BarMult = RUF.db.profile.Appearance.Bars.Class.Color.Multiplier
	local Texture = LSM:Fetch("statusbar", RUF.db.profile.Appearance.Bars.Class.Texture)	

	if PlayerClass == "DEATHKNIGHT" then--and event == "PLAYER_TALENT_UPDATE" then -- Update Bar Colors for Death Knight Specs.
		local Spec = GetSpecialization()
		if Spec == 1 then --Blood
			r,g,b = unpack(RUF.db.profile.Appearance.Colors.PowerColors[50])
		elseif Spec == 2 then -- Frost
			r,g,b = unpack(RUF.db.profile.Appearance.Colors.PowerColors[51])
		elseif Spec == 3 then -- Unholy
			r,g,b = unpack(RUF.db.profile.Appearance.Colors.PowerColors[52])
		else
			r,g,b = unpack(RUF.db.profile.Appearance.Colors.PowerColors[RUF.db.char.ClassPowerID])
		end
	end
	for index = 1,UnitPowerMaxAmount do
		local ir = r - (r*(((-index + UnitPowerMaxAmount)*BarMult)/100))
		local ig = g - (g*(((-index + UnitPowerMaxAmount)*BarMult)/100))
		local ib = b - (b*(((-index + UnitPowerMaxAmount)*BarMult)/100))
		if RUF.db.profile.Appearance.Bars.Class.Background.UseBarColor == false then 
			br,bg,bb = unpack(RUF.db.profile.Appearance.Bars.Class.Background.CustomColor)
		else
			br,bg,bb = r,g,b
		end
		if PlayerClass == "DEATHKNIGHT" then
			element.__owner.Runes[index]:SetStatusBarTexture(Texture)
			element.__owner.Runes[index]:SetStatusBarColor(ir,ig,ib)
			element.__owner.Runes.bg[index]:SetVertexColor(br*Multiplier,bg*Multiplier,bb*Multiplier,RUF.db.profile.Appearance.Bars.Class.Background.Alpha)
		else
			element.__owner.ClassPower[index]:SetStatusBarTexture(Texture)
			element.__owner.ClassPower[index]:SetStatusBarColor(ir,ig,ib)
			element.__owner.ClassPower.bg[index]:SetVertexColor(br*Multiplier,bg*Multiplier,bb*Multiplier,RUF.db.profile.Appearance.Bars.Class.Background.Alpha)
		end
	end
end

local function UpdateClassBar(self, event)	
	if (RUF.db.char.ClassPowerID) then -- If we're a class that should show a class bar
		local UnitPowerMaxAmount = UnitPowerMax("player", RUF.db.char.ClassPowerID)
		if RUF.db.profile.unit.player.Frame.Bars.Class.Enabled == false then
			RUF:BarVisibility(self, "Class", false)	
		elseif(not RUF.db.char.RequireSpec or RUF.db.char.RequireSpec == GetSpecialization()) then -- If the class requires a specific spec, and if so, if we are that spec.
			if(not RUF.db.char.RequireSpell or IsPlayerSpell(RUF.db.char.RequireSpell)) then -- If the class requires a specific spell, druid cat form.
				RUF:BarVisibility(self, "Class", true)				
			else
				RUF:BarVisibility(self, "Class", false)	
			end
		else
			RUF:BarVisibility(self, "Class", false)	
		end
	else
		RUF:BarVisibility(self, "Class", false)
	end
	local FrameIndex = RUF:UnitToIndex(unit)
	RUF:UpdateHealthBackground(FrameIndex)
end

local function SetClassBar(self, unit)
	local ClassPowerBar = {}
	local ClassPowerBorder = {}
	local ClassPowerBG = {}
	if not RUF.db.char.ClassPowerID then return end
	local Name = self:GetName() .. ".Class"
	local UnitPowerMaxAmount = UnitPowerMax(unit, RUF.db.char.ClassPowerID)
	if RUF.db.char.ClassPowerID == 12 then
		UnitPowerMaxAmount = 6
		-- TODO: Check talent for additional bar. Hide and resize. Do same check for others.
	end

	local GroupParent = CreateFrame("Frame",Name,self)
	GroupParent:SetPoint("LEFT",self,0,0)
	GroupParent:SetPoint("RIGHT",self,0,0)
	GroupParent:SetPoint("TOP",self,0,0)
	GroupParent:SetPoint("BOTTOM",self,0,0)

	local Texture = LSM:Fetch("statusbar", RUF.db.profile.Appearance.Bars.Class.Texture)
	local r,g,b = unpack(RUF.db.profile.Appearance.Colors.PowerColors[RUF.db.char.ClassPowerID])
	if PlayerClass == "DEATHKNIGHT" then
		local spec = GetSpecialization()
		if spec == 1 then --Blood
			r,g,b = unpack(RUF.db.profile.Appearance.Colors.PowerColors[50])
		elseif spec == 2 then -- Frost
			r,g,b = unpack(RUF.db.profile.Appearance.Colors.PowerColors[51])
		elseif spec == 3 then -- Unholy
			r,g,b = unpack(RUF.db.profile.Appearance.Colors.PowerColors[52])
		else
			r,g,b = unpack(RUF.db.profile.Appearance.Colors.PowerColors[RUF.db.char.ClassPowerID])
		end
	end
	local Multiplier = RUF.db.profile.Appearance.Bars.Class.Background.Multiplier
	local Constant = RUF.db.profile.Appearance.Bars.Class.Color.Multiplier	
	
	for i = 1,UnitPowerMaxAmount do
		local FrameParent = CreateFrame("Frame",Name..i..".Parent",GroupParent)
		local Border = CreateFrame("Frame",Name..i..".Border",FrameParent)
		local Background = FrameParent:CreateTexture(Name..i..".Background","BACKGROUND")
		local Bar = CreateFrame("StatusBar",Name..i..".Bar",FrameParent)
		local Size = (RUF.db.profile.unit[unit].Frame.Size.Width + (UnitPowerMaxAmount-1)) / UnitPowerMaxAmount
		local Counter = i
		if UnitPowerMaxAmount == 4 then
			Counter = i +1
		end
		
		-- Set Bar Parent Size
		FrameParent:SetWidth(Size)
		FrameParent:SetHeight(RUF.db.profile.unit[unit].Frame.Bars.Class.Height)
		FrameParent:SetPoint('TOPLEFT', GroupParent, 'TOPLEFT', ((i - 1) * Size - ((i - 1 ) * 1)), 0)
		FrameParent:SetFrameLevel(5)
		
		-- Set Status Bar
		Bar:SetFillStyle(RUF.db.profile.unit[unit].Frame.Bars.Class.Fill)
		Bar:SetAllPoints(FrameParent)
		Bar:SetFrameLevel(6)		
		Bar:SetStatusBarTexture(Texture)
		local ir = (r*((((Counter+Constant)*6.6667)/100)))
		local ig = (g*((((Counter+Constant)*6.6667)/100)))
		local ib = (b*((((Counter+Constant)*6.6667)/100)))
		Bar:SetStatusBarColor(ir,ig,ib)
		
		-- Set Border
		Border:SetAllPoints(FrameParent)
		Border:SetFrameLevel(7)
		Border:SetBackdrop(RUF.db.profile.Appearance.Border.Style)
		Border:SetBackdropBorderColor(0,0,0,1)
		
		-- Set Background
		Background:SetAllPoints(FrameParent)		
		Background:SetTexture(LSM:Fetch("background", "Solid"))
		Background:SetVertexColor(r*Multiplier,g*Multiplier,b*Multiplier,RUF.db.profile.Appearance.Bars.Class.Background.Alpha)

		ClassPowerBar[i] = Bar
		ClassPowerBorder[i] = Border
		ClassPowerBG[i] = Background		
	end
	
	-- Register with oUF
	if PlayerClass == "DEATHKNIGHT" then
		self.Runes = ClassPowerBar
		self.Runes.border = ClassPowerBorder	
		self.Runes.bg = ClassPowerBG
		self:RegisterEvent('ACTIONBAR_UPDATE_STATE',UpdateClassBar)
		self:RegisterEvent('UNIT_POWER',UpdateClassBar)
		self:RegisterEvent('UNIT_DISPLAYPOWER',UpdateClassBar)
		self:RegisterEvent('PLAYER_ENTERING_WORLD',UpdateClassBar)
	else
		self.ClassPower = ClassPowerBar
		self.ClassPower.border = ClassPowerBorder	
		self.ClassPower.bg = ClassPowerBG
		self:RegisterEvent('PLAYER_TALENT_UPDATE',UpdateClassBar)
		self:RegisterEvent('UNIT_POWER',UpdateClassBar)
		self:RegisterEvent('UNIT_DISPLAYPOWER',UpdateClassBar)
		self:RegisterEvent('PLAYER_ENTERING_WORLD',UpdateClassBar)
	end
	UpdateClassBar(self)	
end

local function AbsorbUpdate(self, event, unit,...)
	if RUF.db.global.TestMode == true then	return	end
	if not unit then return end
	local i = RUF:UnitToIndex(unit)
	if not i then return end
	local cfgunit = RUF.db.global.UnitList[i].name

	if RUF.db.global.UnitList[i].group then -- If the unit is part of a group, use the group's settings.
		local cfgunit = RUF.db.global.UnitList[i].group
	end

	-- Update Absorb display state.
	if RUF.db.profile.unit[cfgunit].Frame.Bars.Absorb.Enabled == 0 then
		if _G[RUF.db.global.UnitList[i].frame].Absorb:IsShown() then
			_G[RUF.db.global.UnitList[i].frame].Absorb:Hide()
		end
		return
	else
		if not _G[RUF.db.global.UnitList[i].frame].Absorb:IsShown() then
			_G[RUF.db.global.UnitList[i].frame].Absorb:Show()
		end
	end



	-- Update Values
	if event == "UNIT_TARGET" then
		if unit == "player" then
			if _G[RUF.db.global.UnitList[3].frame] then
				local r,g,b,a = RUF:GetAbsorbColor(RUF.db.global.UnitList[3].name)
				local AbsorbAmount = (UnitGetTotalAbsorbs(RUF.db.global.UnitList[3].name) or 0)
				local max = (UnitHealthMax(RUF.db.global.UnitList[3].name) or 0)
				_G[RUF.db.global.UnitList[3].frame].Absorb:SetMinMaxValues(0, max)
				_G[RUF.db.global.UnitList[3].frame].Absorb:SetValue(AbsorbAmount)
				_G[RUF.db.global.UnitList[3].frame].Absorb:SetStatusBarColor(r,g,b,a)	
			end
			if _G[RUF.db.global.UnitList[4].frame] then
				local r,g,b,a = RUF:GetAbsorbColor(RUF.db.global.UnitList[4].name)
				local AbsorbAmount = (UnitGetTotalAbsorbs(RUF.db.global.UnitList[4].name) or 0)
				local max = (UnitHealthMax(RUF.db.global.UnitList[4].name) or 0)
				_G[RUF.db.global.UnitList[4].frame].Absorb:SetMinMaxValues(0, max)
				_G[RUF.db.global.UnitList[4].frame].Absorb:SetValue(AbsorbAmount)
				_G[RUF.db.global.UnitList[4].frame].Absorb:SetStatusBarColor(r,g,b,a)	
			end
		elseif unit == "target" then
			if _G[RUF.db.global.UnitList[4].frame] then
				local r,g,b,a = RUF:GetAbsorbColor(RUF.db.global.UnitList[4].name)
				local AbsorbAmount = (UnitGetTotalAbsorbs(RUF.db.global.UnitList[4].name) or 0)
				local max = (UnitHealthMax(RUF.db.global.UnitList[4].name) or 0)
				_G[RUF.db.global.UnitList[4].frame].Absorb:SetMinMaxValues(0, max)
				_G[RUF.db.global.UnitList[4].frame].Absorb:SetValue(AbsorbAmount)
				_G[RUF.db.global.UnitList[4].frame].Absorb:SetStatusBarColor(r,g,b,a)	
			end
		else
			for i = 1,#RUF.db.global.UnitList do
				if _G[RUF.db.global.UnitList[i].frame] then
					local r,g,b,a = RUF:GetAbsorbColor(RUF.db.global.UnitList[i].name)
					local AbsorbAmount = (UnitGetTotalAbsorbs(RUF.db.global.UnitList[i].name) or 0)
					local max = (UnitHealthMax(RUF.db.global.UnitList[i].name) or 0)
					_G[RUF.db.global.UnitList[i].frame].Absorb:SetMinMaxValues(0, max)
					_G[RUF.db.global.UnitList[i].frame].Absorb:SetValue(AbsorbAmount)
					_G[RUF.db.global.UnitList[i].frame].Absorb:SetStatusBarColor(r,g,b,a)					
				end
			end			
		end
	elseif event == "UNIT_ABSORB_AMOUNT_CHANGED" then
		if unit == "player" then
			if _G[RUF.db.global.UnitList[1].frame] then
				local r,g,b,a = RUF:GetAbsorbColor(RUF.db.global.UnitList[1].name)
				local AbsorbAmount = (UnitGetTotalAbsorbs(RUF.db.global.UnitList[1].name) or 0)
				local max = (UnitHealthMax(RUF.db.global.UnitList[1].name) or 0)
				_G[RUF.db.global.UnitList[1].frame].Absorb:SetMinMaxValues(0, max)
				_G[RUF.db.global.UnitList[1].frame].Absorb:SetValue(AbsorbAmount)
				_G[RUF.db.global.UnitList[1].frame].Absorb:SetStatusBarColor(r,g,b,a)	
			end
		elseif unit == "target" then
			if _G[RUF.db.global.UnitList[3].frame] then
				local r,g,b,a = RUF:GetAbsorbColor(RUF.db.global.UnitList[3].name)
				local AbsorbAmount = (UnitGetTotalAbsorbs(RUF.db.global.UnitList[3].name) or 0)
				local max = (UnitHealthMax(RUF.db.global.UnitList[3].name) or 0)
				_G[RUF.db.global.UnitList[3].frame].Absorb:SetMinMaxValues(0, max)
				_G[RUF.db.global.UnitList[3].frame].Absorb:SetValue(AbsorbAmount)
				_G[RUF.db.global.UnitList[3].frame].Absorb:SetStatusBarColor(r,g,b,a)	
			end
			if _G[RUF.db.global.UnitList[4].frame] then
				local r,g,b,a = RUF:GetAbsorbColor(RUF.db.global.UnitList[4].name)
				local AbsorbAmount = (UnitGetTotalAbsorbs(RUF.db.global.UnitList[4].name) or 0)
				local max = (UnitHealthMax(RUF.db.global.UnitList[4].name) or 0)
				_G[RUF.db.global.UnitList[4].frame].Absorb:SetMinMaxValues(0, max)
				_G[RUF.db.global.UnitList[4].frame].Absorb:SetValue(AbsorbAmount)
				_G[RUF.db.global.UnitList[4].frame].Absorb:SetStatusBarColor(r,g,b,a)	
			end
		else
			for i = 1,#RUF.db.global.UnitList do
				if _G[RUF.db.global.UnitList[i].frame] then
					local r,g,b,a = RUF:GetAbsorbColor(RUF.db.global.UnitList[i].name)
					local AbsorbAmount = (UnitGetTotalAbsorbs(RUF.db.global.UnitList[i].name) or 0)
					local max = (UnitHealthMax(RUF.db.global.UnitList[i].name) or 0)
					_G[RUF.db.global.UnitList[i].frame].Absorb:SetMinMaxValues(0, max)
					_G[RUF.db.global.UnitList[i].frame].Absorb:SetValue(AbsorbAmount)
					_G[RUF.db.global.UnitList[i].frame].Absorb:SetStatusBarColor(r,g,b,a)					
				end
			end			
		end	
	end
end

local function SetAbsorbBar(self, unit)
	local Texture = LSM:Fetch("statusbar", RUF.db.profile.Appearance.Bars.Absorb.Texture)	
	local Name = self:GetName()
	local Bar = CreateFrame("StatusBar",Name..".Absorb.Bar",self)
	local Border = CreateFrame("Frame",Name..".Absorb.Border",self)
	local Background = Border:CreateTexture(Name..".Absorb.Background","BACKGROUND")	
	 
	-- Bar
	Bar.colorClass = RUF.db.profile.Appearance.Bars.Absorb.Color.Class
	Bar.colorDisconnected = RUF.db.profile.Appearance.Bars.Absorb.Color.Disconnected
	Bar.colorSmooth = RUF.db.profile.Appearance.Bars.Absorb.Color.Percentage
	Bar.smoothGradient = RUF.db.profile.Appearance.Bars.Absorb.Color.PercentageGradient
	Bar.colorReaction = RUF.db.profile.Appearance.Bars.Absorb.Color.Reaction
	Bar.colorTapping = RUF.db.profile.Appearance.Bars.Absorb.Color.Tapped
	Bar.colorAbsorb = true -- BaseColor, always enabled, so if none of the other colors match, it falls back to this.
	Bar.Smooth = RUF.db.profile.Appearance.Bars.Absorb.Animate
	Bar:SetStatusBarTexture(Texture)
	if RUF.db.profile.Appearance.Bars.Absorb.Type == 1 then
		Bar:SetAllPoints(self)
		Border:Hide() -- Hides background too.
	end
	Bar:SetFrameLevel(2)
	Bar:SetFillStyle(RUF.db.profile.unit[unit].Frame.Bars.Absorb.Fill)
	
	local AbsorbAmount = (UnitGetTotalAbsorbs(unit))
	local r,g,b = unpack(RUF.db.profile.Appearance.Bars.Absorb.Color.BaseColor)
	local a = RUF.db.profile.Appearance.Bars.Absorb.Color.Alpha
	local min = 0
	local max = UnitHealthMax(unit)
	Bar:SetMinMaxValues(min, max)
	Bar:SetValue(AbsorbAmount)
	Bar:SetStatusBarColor(r,g,b,a)
	
	-- Border
	Border:SetAllPoints(Bar)
	Border:SetFrameLevel(7)
	Border:SetBackdrop(RUF.db.profile.Appearance.Border.Style)
	Border:SetBackdropBorderColor(0,0,0,1)
	
	-- Background
	local r,g,b = unpack(RUF.db.profile.Appearance.Bars.Absorb.Background.CustomColor)
	local Multiplier = RUF.db.profile.Appearance.Bars.Absorb.Background.Multiplier
	Background:SetTexture(LSM:Fetch("background", "Solid"))	
	Background:SetVertexColor(r*Multiplier,g*Multiplier,b*Multiplier,RUF.db.profile.Appearance.Bars.Absorb.Background.Alpha)
	Background:SetAllPoints(Bar)
	Background.colorSmooth = false

	-- Register with oUF	
	self.Absorb = Bar
	self.Absorb.border = Border
	self.Absorb.background = Background
	self:RegisterEvent('UNIT_ABSORB_AMOUNT_CHANGED',AbsorbUpdate)
	self:RegisterEvent('UNIT_TARGET',AbsorbUpdate)
	if RUF.db.profile.Appearance.Bars.Absorb.Type == 0 then
		self.Absorb:Hide()
		self.Absorb.border:Hide()
		self.Absorb.background:Hide()
	end
end

local function SetTextParent(self, unit)
	local TextParent = CreateFrame('Frame', self:GetName() .. ".TextParent", self)
	TextParent:SetFrameLevel(20)
	TextParent:SetAllPoints(self)
	local Text = TextParent:CreateFontString(self:GetName() .. ".TextParent.FrameName", 'OVERLAY', "Raeli")
	local Font = LSM:Fetch("font", "RUF")
	Text:SetFont(Font, 21, "OUTLINE")
	Text:SetText(L[unit])
	for i = 1,#RUF.db.global.UnitList do
		if RUF.db.global.UnitList[i].group == unit then
			if self:GetName() == RUF.db.global.UnitList[i].frame then
				Text:SetText(L[RUF.db.global.UnitList[i].name])
			end
		end
	end	
	Text:SetAllPoints(TextParent)
	Text:Hide()
	self.TextParent = TextParent
end

function RUF:SetTextPoints(self,unit,TextName)
	local AnchorFrame = "Frame"
	if RUF.db.profile.unit[unit].Frame.Text[TextName].Position.AnchorFrame == "Frame" then
		AnchorFrame = self:GetName()
	else
		AnchorFrame = (self:GetName()..".TextParent."..RUF.db.profile.unit[unit].Frame.Text[TextName].Position.AnchorFrame .. ".Text")
		if not _G[AnchorFrame] then
			AnchorFrame = self:GetName()
		end

	end
	local ReverseAnchor = RUF.db.profile.unit[unit].Frame.Text[TextName].Position.Anchor
	if RUF.db.profile.unit[unit].Frame.Text[TextName].Position.AnchorFrame ~= "Frame" then
		ReverseAnchor = AnchorSwaps[ReverseAnchor]
	end
	self.TextParent[TextName].Text:SetPoint(ReverseAnchor,
				  AnchorFrame,
				  RUF.db.profile.unit[unit].Frame.Text[TextName].Position.Anchor,
				  RUF.db.profile.unit[unit].Frame.Text[TextName].Position.x, 
				  RUF.db.profile.unit[unit].Frame.Text[TextName].Position.y)
end

function RUF:CreateTextArea(self, unit,TextName)
	local StringParent = CreateFrame('Frame', self:GetName() .. ".TextParent."..TextName, self.TextParent)
	StringParent:SetFrameLevel(20)
	self.TextParent[TextName] = StringParent
	local Font = ""
	Font = LSM:Fetch("font", RUF.db.profile.unit[unit].Frame.Text[TextName].Font)
	local Text = self.TextParent[TextName]:CreateFontString(self:GetName() .. ".TextParent."..TextName..".Text", 'OVERLAY')
	Text:SetFont(Font, RUF.db.profile.unit[unit].Frame.Text[TextName].Size, RUF.db.profile.unit[unit].Frame.Text[TextName].Outline)
	if not RUF.db.profile.unit[unit].Frame.Text[TextName].Shadow then RUF.db.profile.unit[unit].Frame.Text[TextName].Shadow = 0 end
	Text:SetShadowColor(0,0,0,RUF.db.profile.unit[unit].Frame.Text[TextName].Shadow)
	Text:SetShadowOffset(1, -1)
	Text:SetTextColor(1, 1, 1, 1)
	Text.overrideUnit = true
	Text.frequentUpdates = 0.5
	local AnchorPoint = RUF.db.profile.unit[unit].Frame.Text[TextName].Position.Anchor
	if AnchorPoint == "RIGHT" or AnchorPoint == "TOPRIGHT" or AnchorPoint == "BOTTOMRIGHT" then
		Text:SetJustifyH("RIGHT")
	elseif AnchorPoint == "LEFT" or AnchorPoint == "TOPLEFT" or AnchorPoint == "BOTTOMLEFT" then
		Text:SetJustifyH("LEFT")
	else
		Text:SetJustifyH("CENTER")
	end
	Text:SetWordWrap(false)
	--Text:SetWidth(RUF.db.profile.unit[unit].Frame.Text[TextName].Width)
	self.TextParent[TextName].Text = Text
	self:Tag(Text, RUF.db.profile.unit[unit].Frame.Text[TextName].Tag)
end


local function SetClassColors()
	local function customClassColors()
		if(CUSTOM_CLASS_COLORS) and RUF.db.profile.Appearance.Colors.UseClassColors then
			local function updateColors()
				for classToken, color in next, CUSTOM_CLASS_COLORS do
					RUF.db.profile.Appearance.Colors.ClassColors[classToken] = {(color.r), (color.g), (color.b)}				
				end
				for _, obj in next, oUF.objects do
					obj:UpdateAllElements('CUSTOM_CLASS_COLORS')
				end
			end
			updateColors()
			CUSTOM_CLASS_COLORS:RegisterCallback(updateColors)
			return true
		end
	end
	if(not customClassColors()) then
		local eventHandler = CreateFrame('Frame')
		eventHandler:RegisterEvent('ADDON_LOADED')
		eventHandler:SetScript('OnEvent', function(self)
			if(customClassColors()) then
				self:UnregisterEvent('ADDON_LOADED')
				self:SetScript('OnEvent', nil)
			end
		end)
	end
end

local function SetupFrames(self, unit)
	unit = unit:match('^(.-)%d+') or unit

	-- Set Colors
	SetClassColors()
	do
		self.colors.Tapping = RUF.db.profile.Appearance.Colors.MiscColors.Tapped
		self.colors.Disconnected = RUF.db.profile.Appearance.Colors.MiscColors.Disconnected
		self.colors.class.DEATHKNIGHT = RUF.db.profile.Appearance.Colors.ClassColors.DEATHKNIGHT
		self.colors.class.DEMONHUNTER = RUF.db.profile.Appearance.Colors.ClassColors.DEMONHUNTER
		self.colors.class.DRUID = RUF.db.profile.Appearance.Colors.ClassColors.DRUID
		self.colors.class.HUNTER = RUF.db.profile.Appearance.Colors.ClassColors.HUNTER
		self.colors.class.MAGE = RUF.db.profile.Appearance.Colors.ClassColors.MAGE
		self.colors.class.MONK = RUF.db.profile.Appearance.Colors.ClassColors.MONK
		self.colors.class.PALADIN = RUF.db.profile.Appearance.Colors.ClassColors.PALADIN
		self.colors.class.PRIEST = RUF.db.profile.Appearance.Colors.ClassColors.PRIEST
		self.colors.class.ROGUE = RUF.db.profile.Appearance.Colors.ClassColors.ROGUE
		self.colors.class.SHAMAN = RUF.db.profile.Appearance.Colors.ClassColors.SHAMAN
		self.colors.class.WARLOCK = RUF.db.profile.Appearance.Colors.ClassColors.WARLOCK
		self.colors.class.WARRIOR = RUF.db.profile.Appearance.Colors.ClassColors.WARRIOR	
		for i = 1,8 do
			self.colors.reaction[i][1] = RUF.db.profile.Appearance.Colors.ReactionColors[i][1]
			self.colors.reaction[i][2] = RUF.db.profile.Appearance.Colors.ReactionColors[i][2]
			self.colors.reaction[i][3] = RUF.db.profile.Appearance.Colors.ReactionColors[i][3]
		end
		self.colors.health = RUF.db.profile.Appearance.Bars.Health.Color.BaseColor
		self.colors.power.MANA = RUF.db.profile.Appearance.Colors.PowerColors[0]
		self.colors.power.RAGE = RUF.db.profile.Appearance.Colors.PowerColors[1]
		self.colors.power.FOCUS = RUF.db.profile.Appearance.Colors.PowerColors[2]
		self.colors.power.ENERGY = RUF.db.profile.Appearance.Colors.PowerColors[3]
		self.colors.power.COMBO_POINTS = RUF.db.profile.Appearance.Colors.PowerColors[4]
		self.colors.power.RUNES = RUF.db.profile.Appearance.Colors.PowerColors[5]
		self.colors.power.RUNIC_POWER = RUF.db.profile.Appearance.Colors.PowerColors[6]
		self.colors.power.SOUL_SHARDS = RUF.db.profile.Appearance.Colors.PowerColors[7]
		self.colors.power.LUNAR_POWER = RUF.db.profile.Appearance.Colors.PowerColors[8]
		self.colors.power.HOLY_POWER = RUF.db.profile.Appearance.Colors.PowerColors[9]
		self.colors.power.MAELSTROM = RUF.db.profile.Appearance.Colors.PowerColors[11]
		self.colors.power.CHI = RUF.db.profile.Appearance.Colors.PowerColors[12]
		self.colors.power.INSANITY = RUF.db.profile.Appearance.Colors.PowerColors[13]
		self.colors.power.ARCANE_CHARGES = RUF.db.profile.Appearance.Colors.PowerColors[16]
		self.colors.power.FURY = RUF.db.profile.Appearance.Colors.PowerColors[17]
		self.colors.power.PAIN = RUF.db.profile.Appearance.Colors.PowerColors[18]

		self.colors.runes[1] = RUF.db.profile.Appearance.Colors.PowerColors[50]--Blood
		self.colors.runes[2] = RUF.db.profile.Appearance.Colors.PowerColors[51]--Frost
		self.colors.runes[3] = RUF.db.profile.Appearance.Colors.PowerColors[52]--Unholy
	end

	if UnitSettingsDone ~= true then 
		RUF:UpdateUnitSettings()
		UnitSettingsDone = true
	end

	self:RegisterForClicks('AnyUp')
	self:SetScript('OnEnter', UnitFrame_OnEnter)
	self:SetScript('OnLeave', UnitFrame_OnLeave)

	-- Frame Border
	local Border = CreateFrame("Frame",self:GetName()..".Border",self)
	Border:SetAllPoints(self)
	Border:SetFrameLevel(10)
	Border:SetBackdrop(RUF.db.profile.Appearance.Border.Style)
	Border:SetBackdropBorderColor(0,0,0,1)
	self.border = Border
	self:SetHeight(RUF.db.profile.unit[unit].Frame.Size.Height)
	self:SetWidth(RUF.db.profile.unit[unit].Frame.Size.Width)
	self:SetClampedToScreen(true)

	-- Setup Bars
	SetHealth(self, unit)
	self.Health.PreUpdate = HealthPreUpdate
	self.Health.PostUpdate = HealthPostUpdate	

	SetPower(self, unit)
	self.Power.PostUpdate = PowerPostUpdate

	
	if RUF.db.profile.Appearance.Bars.Absorb.Type == 1 then -- Set Absorb Bar Type
		SetAbsorbBar(self, unit)
	elseif RUF.db.profile.Appearance.Bars.Absorb.Type == 2 then
		-- TODO: Create Separate Bar option - probably just use SetAbsorbBar and then move it.
		-- SetAbsorbBar(self, unit)
	end
	
	if (unit == 'player') then -- Setup Class Power and Additional Power for Player.
		self.Power.frequentUpdates = true
		if PlayerClass == "PRIEST" or PlayerClass == "SHAMAN" or PlayerClass == "DRUID" then
			SetAdditionalPower(self, unit)
			self.AdditionalPower.PostUpdate = PowerPostUpdate
			self.AdditionalPower.OverrideVisibility = OverrideVisibility		
		elseif RUF.db.char.ClassPowerID then	
			SetClassBar(self, unit)
			if PlayerClass == "DEATHKNIGHT" then
				self.Runes.PostUpdate = ClassPostUpdate
			else
				self.ClassPower.PostUpdate = ClassPostUpdate
			end
		end		
	end

	-- Setup Text Areas
	SetTextParent(self, unit)
	local Texts = {} 
	for k,v in pairs(RUF.db.profile.unit[unit].Frame.Text) do
		if v ~= "" then
			table.insert(Texts,k)
		end
	end
	for i = 1,#Texts do
		RUF:CreateTextArea(self,unit,Texts[i])
		if RUF.db.profile.unit[unit].Frame.Text[Texts[i]].Enabled == false then
			self.TextParent[Texts[i]]:Hide()
			self.TextParent[Texts[i]].Text:UpdateTag()
			self:Untag(Text)
			-- TODO: Unregister events.
		end
	end
	for i = 1,#Texts do
		RUF:SetTextPoints(self,unit,Texts[i])
	end

	if unit == 'targettarget' then
		self.onUpdateFrequency	= 0.25 -- TODO Option
	else
		self.onUpdateFrequency	= 1
	end

	-- Update Health Background based on displayed bars and location.
	local FrameIndex = RUF:UnitToIndex(unit)
	RUF:UpdateHealthBackground(FrameIndex)
end

function RUF:OnEnable()	
	oUF:RegisterStyle('RUF_', SetupFrames)
	oUF:Factory(function(self)
		self:SetActiveStyle('RUF_')
		self:Spawn('player'):SetPoint(
			RUF.db.profile.unit["player"].Frame.Position.AnchorFrom,
			RUF.db.profile.unit["player"].Frame.Position.AnchorFrame,
			RUF.db.profile.unit["player"].Frame.Position.AnchorTo,
			RUF.db.profile.unit["player"].Frame.Position.x,
			RUF.db.profile.unit["player"].Frame.Position.y)
		self:Spawn('pet'):SetPoint(
			RUF.db.profile.unit["pet"].Frame.Position.AnchorFrom,
			RUF.db.profile.unit["pet"].Frame.Position.AnchorFrame,
			RUF.db.profile.unit["pet"].Frame.Position.AnchorTo,
			RUF.db.profile.unit["pet"].Frame.Position.x,
			RUF.db.profile.unit["pet"].Frame.Position.y)
		self:Spawn('focus'):SetPoint(
			RUF.db.profile.unit["focus"].Frame.Position.AnchorFrom,
			RUF.db.profile.unit["focus"].Frame.Position.AnchorFrame,
			RUF.db.profile.unit["focus"].Frame.Position.AnchorTo,
			RUF.db.profile.unit["focus"].Frame.Position.x,
			RUF.db.profile.unit["focus"].Frame.Position.y)
		self:Spawn('target'):SetPoint(
			RUF.db.profile.unit["target"].Frame.Position.AnchorFrom,
			RUF.db.profile.unit["target"].Frame.Position.AnchorFrame,
			RUF.db.profile.unit["target"].Frame.Position.AnchorTo,
			RUF.db.profile.unit["target"].Frame.Position.x,
			RUF.db.profile.unit["target"].Frame.Position.y)
		self:Spawn('targettarget'):SetPoint(
			RUF.db.profile.unit["targettarget"].Frame.Position.AnchorFrom,
			RUF.db.profile.unit["targettarget"].Frame.Position.AnchorFrame,
			RUF.db.profile.unit["targettarget"].Frame.Position.AnchorTo,
			RUF.db.profile.unit["targettarget"].Frame.Position.x,
			RUF.db.profile.unit["targettarget"].Frame.Position.y)
		self:Spawn('pettarget'):SetPoint(
			RUF.db.profile.unit["pettarget"].Frame.Position.AnchorFrom,
			RUF.db.profile.unit["pettarget"].Frame.Position.AnchorFrame,
			RUF.db.profile.unit["pettarget"].Frame.Position.AnchorTo,
			RUF.db.profile.unit["pettarget"].Frame.Position.x,
			RUF.db.profile.unit["pettarget"].Frame.Position.y)
		self:Spawn('focustarget'):SetPoint(
			RUF.db.profile.unit["focustarget"].Frame.Position.AnchorFrom,
			RUF.db.profile.unit["focustarget"].Frame.Position.AnchorFrame,
			RUF.db.profile.unit["focustarget"].Frame.Position.AnchorTo,
			RUF.db.profile.unit["focustarget"].Frame.Position.x,
			RUF.db.profile.unit["focustarget"].Frame.Position.y)

		local AnchorFrom
		if RUF.db.profile.unit["party"].Frame.Position.growth == "BOTTOM" then
			AnchorFrom = "TOP"
		elseif RUF.db.profile.unit["party"].Frame.Position.growth == "TOP" then
			AnchorFrom = "BOTTOM"
		end
		local party = oUF:SpawnHeader(
			'oUF_RUF_Party', nil, 'party',
			'showSolo', false,
			'showParty', true,
			'showRaid', false,
			'showPlayer', false,
			'yOffset', RUF.db.profile.unit["party"].Frame.Position.offsety,
			'Point', AnchorFrom
		):SetPoint(
			RUF.db.profile.unit["party"].Frame.Position.AnchorFrom,
			RUF.db.profile.unit["party"].Frame.Position.AnchorFrame,
			RUF.db.profile.unit["party"].Frame.Position.AnchorTo,
			RUF.db.profile.unit["party"].Frame.Position.x,
			RUF.db.profile.unit["party"].Frame.Position.y)

		for index = 1, 4 do
			local AnchorFrom
			if RUF.db.profile.unit.boss.Frame.Position.growth == "BOTTOM" then
				AnchorFrom = "TOP"
			elseif RUF.db.profile.unit.boss.Frame.Position.growth == "TOP" then
				AnchorFrom = "BOTTOM"
			end
			local boss = self:Spawn('boss' .. index)
			--local bosstarget = self:Spawn('bosstarget' .. index)
			if(index == 1) then
				boss:SetPoint(
					RUF.db.profile.unit.boss.Frame.Position.AnchorFrom,
					RUF.db.profile.unit.boss.Frame.Position.AnchorFrame,
					RUF.db.profile.unit.boss.Frame.Position.AnchorTo,
					RUF.db.profile.unit.boss.Frame.Position.x,
					RUF.db.profile.unit.boss.Frame.Position.y)
				--[[bosstarget:SetPoint(
					RUF.db.profile.unit.bosstarget.Frame.Position.AnchorFrom,
					RUF.db.profile.unit.bosstarget.Frame.Position.AnchorFrame,
					RUF.db.profile.unit.bosstarget.Frame.Position.AnchorTo,
					RUF.db.profile.unit.bosstarget.Frame.Position.x,
					RUF.db.profile.unit.bosstarget.Frame.Position.y)]]--
			else
				boss:SetPoint(
					AnchorFrom,
					_G['oUF_RUF_Boss' .. index -1],
					RUF.db.profile.unit.boss.Frame.Position.growth,
					RUF.db.profile.unit.boss.Frame.Position.offsetx,
					RUF.db.profile.unit.boss.Frame.Position.offsety)
				--bosstarget:SetPoint('TOP', _G['oUF_RUF_BossTarget' .. index - 1], 'BOTTOM', 0, -4)
			end
		end
		for index = 1, 5 do
			local AnchorFrom
			if RUF.db.profile.unit.arena.Frame.Position.growth == "BOTTOM" then
				AnchorFrom = "TOP"
			elseif RUF.db.profile.unit.arena.Frame.Position.growth == "TOP" then
				AnchorFrom = "BOTTOM"
			end
			local arena = self:Spawn('arena' .. index)
			--local arenatarget = self:Spawn('arenatarget' .. index)
			if(index == 1) then
				arena:SetPoint(
					RUF.db.profile.unit.arena.Frame.Position.AnchorFrom,
					RUF.db.profile.unit.arena.Frame.Position.AnchorFrame,
					RUF.db.profile.unit.arena.Frame.Position.AnchorTo,
					RUF.db.profile.unit.arena.Frame.Position.x,
					RUF.db.profile.unit.arena.Frame.Position.y)
				--[[arenatarget:SetPoint(
					RUF.db.profile.unit.arenatarget.Frame.Position.AnchorFrom,
					RUF.db.profile.unit.arenatarget.Frame.Position.AnchorFrame,
					RUF.db.profile.unit.arenatarget.Frame.Position.AnchorTo,
					RUF.db.profile.unit.arenatarget.Frame.Position.x,
					RUF.db.profile.unit.arenatarget.Frame.Position.y)]]--
			else
				arena:SetPoint(
					AnchorFrom,
					_G['oUF_RUF_Arena' .. index -1],
					RUF.db.profile.unit.arena.Frame.Position.growth,
					RUF.db.profile.unit.arena.Frame.Position.offsetx,
					RUF.db.profile.unit.arena.Frame.Position.offsety)
				--arenatarget:SetPoint('TOP', _G['oUF_RUF_ArenaTarget' .. index - 1], 'BOTTOM', 0, -4)
			end
		end
	end)

	local PartyNum = GetNumGroupMembers() -1
	if PartyNum == -1 then PartyNum = 0 end
	if IsInRaid() then
		PartyNum = GetNumSubgroupMembers()
	end
	oUF_RUF_Party:SetAttribute('startingIndex', -3 + PartyNum)
	oUF_RUF_Party:Show()
	oUF_RUF_Party:SetAttribute('startingIndex', 1)
	oUF_RUF_Party:SetClampedToScreen(true)
	RegisterAttributeDriver(oUF_RUF_Party,'state-visibility',oUF_RUF_Party.visibility)


	-- Create Party Holder for dragging.
	local MoveBG = CreateFrame("Frame",oUF_RUF_Party:GetName()..".MoveBG",oUF_RUF_Party)
	MoveBG:SetAllPoints(oUF_RUF_Party)
	local Background = MoveBG:CreateTexture(oUF_RUF_Party:GetName()..".MoveBG.BG","BACKGROUND")
	Background:SetTexture(LSM:Fetch("background", "Solid"))	
	Background:SetAllPoints(MoveBG)
	Background:SetVertexColor(0,0,0,0)
	MoveBG:SetFrameStrata("BACKGROUND")

	for i = 1,#RUF.db.global.UnitList do
		if _G[RUF.db.global.UnitList[i].frame] then
			if RUF.db.profile.unit[RUF.db.global.UnitList[i].name].Enabled == false then
				_G[RUF.db.global.UnitList[i].frame]:Disable()
			elseif RUF.db.profile.unit[RUF.db.global.UnitList[i].name].Enabled == true then
				_G[RUF.db.global.UnitList[i].frame]:Enable()
			end
		end
	end
end
