local colour = {"Hearts", "Spades", "Clubs", "Diamonds"}
local cards = {"Ace", "Two", "Three", "Four", "Five", "Six", "Seven", "Eight", "Nine", "Ten", "Jack", "Queen", "King"}
local numbers = {"one ", "two ", "three ", "four ", "five ", "six ", "seven ", "eight ", "nine ", "ten ", "eleven ", "twelve ", "thirteen "}
local deck = {}
local tarot = {"The Fool", "The Magician", "The High Priestess", "The Empress", "The Emperor", "The Hierophant", "The Lovers", "The Chariot", "Strength", "The Hermit", "Wheel of Fortune", "Justice", "The Hanged Man", "Death", "Temperance", "The Devil", "The Tower", "The Star", "The Moon", "The Sun", "Judgement", "The World"}
local eightballtable = {"It is certain","It is decidedly so","Without a doubt","Yes definitely","You may rely on it","As I see it, yes","Most likely","Outlook good","Signs point to yes","Reply hazy try again","Ask again later","Better not tell you now","Cannot predict now","Concentrate and ask again","Don't count on it","My reply is no","My sources say no","Outlook not so good","Very doubtful"}
local CurrentCard = 0
local CurrentTarot = 0
local drawncards = ""
local drawn = {}
local plu = ""

local gender = UnitSex("player")
local pronouns = {{},
	{"His","his","He","he","Man","man"},
	{"Her","her","She","she","Woman","woman"}
}

local function shuffle(tbl)
  size = #tbl
  for i = size, 1, -1 do
    local rand = math.random(size)
    tbl[i], tbl[rand] = tbl[rand], tbl[i]
  end
  return tbl
end

local function shuffledeck()
	for i=1,52 do
		local mod = (i % 4) + 1
		local num = math.ceil(i/4)
		local string = cards[num].. " of "..colour[mod]
		deck[i] = string
	end
	shuffle(deck)
	CurrentCard = #deck
	PlaySound(53186)
	SendChatMessage("picks up "..pronouns[gender][2].." deck of cards and shuffles it.", "EMOTE")
end

local function drawcard(msg)
	local num = tonumber(msg)
	drawncards = ""
	drawn = {}
	plu = ""
	if not num then 
		num = 1
	elseif num > CurrentCard then
		num = CurrentCard
	end
	for i=1,num do
		drawn[i] = deck[CurrentCard]
		CurrentCard = CurrentCard - 1
	end
	if num > 1 then 
		for i=1,#drawn do
			if i > 1 then drawncards = drawn[i] .. ", ".. drawncards 
			else drawncards = drawn[i] end
		end
	else
		drawncards = drawn[1]
	end
	if num == 1 then plu = "one card" elseif num > #numbers then plu = "a lot of cards" else plu = numbers[num].."cards" end
	SendChatMessage("draws "..plu.." from "..pronouns[gender][2].." deck: "..drawncards..".","EMOTE")
end

local function eightball(question)
	local fortune = math.random(#eightballtable)
	SendChatMessage("reaches into "..pronouns[gender][2].." pocket and lifts out a magic 8-Ball. "..pronouns[gender][3].." quietly asks \""..question.."\" and then shakes it. The 8-Ball answers \""..eightballtable[fortune].."\".","EMOTE")
end

local function tarotshuffle()
	shuffle(tarot)
	CurrentTarot = #tarot
	PlaySound(53186)
	SendChatMessage("picks up "..pronouns[gender][2].." Tarot Deck and shuffles it.", "EMOTE")
end

local function tarotdraw(msg)
	local num = tonumber(msg)
	drawncards = ""
	drawn = {}
	plu = ""
	if not num then 
		num = 1
	elseif num > CurrentTarot then
		num = CurrentTarot
	end
	for i=1,num do
		drawn[i] = tarot[CurrentTarot]
		CurrentTarot = CurrentTarot - 1
	end
	if num > 1 then 
		for i=1,#drawn do
			if i > 1 then drawncards = drawn[i] .. ", ".. drawncards 
			else drawncards = drawn[i] end
		end
	else
		drawncards = drawn[1]
	end
	if num == 1 then plu = "one tarot card" elseif num > #numbers then plu = "a lot of tarot cards" else plu = numbers[num].."tarot cards" end
	SendChatMessage("draws "..plu.." from "..pronouns[gender][2].." deck: "..drawncards..".","EMOTE")
end
 
SLASH_SHUFFLE1 = '/shuffle';
function SlashCmdList.SHUFFLE(msg, editbox)
	shuffledeck()
end

SLASH_DRAW1 = '/draw';
function SlashCmdList.DRAW(msg, editbox)
	if CurrentCard == 0 then shuffledeck() drawcard(msg) else drawcard(msg) end
end

SLASH_CHECK1 = '/check';
function SlashCmdList.CHECK(msg, editbox)
	SendChatMessage("checks "..pronouns[gender][2].." deck, there are "..CurrentCard.." Cards remaining.","EMOTE")
end

SLASH_BALL1 = '/8ball';
function SlashCmdList.BALL(msg, editbox)
	eightball(msg)
end

SLASH_TSHUFFLE1 = '/tarotshuffle';
SLASH_TSHUFFLE2 = '/tshuffle';
function SlashCmdList.TSHUFFLE(msg, editbox)
	tarotshuffle()
end

SLASH_TDRAW1 = '/tarotdraw';
SLASH_TDRAW2 = '/tdraw';
function SlashCmdList.TDRAW(msg, editbox)
	if CurrentTarot == 0 then tarotshuffle() tarotdraw(msg) else tarotdraw(msg) end
end

SLASH_TCHECK1 = '/tcheck';
SLASH_TCHECK2 = '/tarotcheck';
function SlashCmdList.TCHECK(msg, editbox)
	SendChatMessage("checks "..pronouns[gender][2].." deck, there are "..CurrentTarot.." Cards remaining.","EMOTE")
end