-- TODO:
-- raidmarker löschen (wenn zugehöriger npc gelöscht wird)
-- mehrere modelframes in ein kästchen (für npc-gruppen, z.b. 5 orcs)
-- minimapicon blinken wenn neue npcs/änderungen (analog zu kalendericon)
-- animation tod abspielen, wenn lp < 1

-- Local DB info
-- CreatureDisplayInfo.ModelID = CreatureModelData.ID
-- Creature.Field7_1 = CreatureDisplayInfo.ID
-- Creature.ID == effective DisplayID
-- CreatureModelData < 10738
-- CreatureDisplayInfo < 83274

-- globals
ADJ_NUM_FRAMES = 8
ADJ_MAX_FLAG_LENGTH = 2000
ADJ_PREFIX = "HADJ"
ADJ_RESET = ">>>RESET"
ADJ_REFRESH_LENGTH = 2

Adjutant = LibStub("AceAddon-3.0"):NewAddon("Adjutant", "AceConsole-3.0", "AceComm-3.0", "AceEvent-3.0", "AceTimer-3.0", "AceSerializer-3.0")
Adjutant.Locale = LibStub("AceLocale-3.0"):GetLocale("Adjutant", true)

if not IsAddonMessagePrefixRegistered(ADJ_PREFIX) then
	RegisterAddonMessagePrefix(ADJ_PREFIX)
end

-- shortcuts to frames
Adjutant.Frame = AdjutantFrame
Adjutant.Viewer = Adjutant.Frame.Viewer
Adjutant.Viewer.Frames = { }
Adjutant.DisplayIDFrame = nil

-- minimapicon
Adjutant.MinimapIcon = LibStub("LibDBIcon-1.0")
Adjutant.MinimapIcon.Obj = LibStub("LibDataBroker-1.1"):NewDataObject("Adjutant", {
	type = "launcher",
	icon = "Interface\\Addons\\Adjutant\\Images\\adjutant-icon.blp",
	label = GetAddOnMetadata("Adjutant", "Title"),
	OnClick = function(self, button)
		if( button == "LeftButton" ) then
			if(Adjutant.Frame:IsVisible()) then 
				Adjutant:Hide()
			else
				Adjutant:Show()
			end
		end
	end,
	OnTooltipShow = function(tooltip)
		tooltip:AddLine(GetAddOnMetadata("Adjutant", "Title"))
		tooltip:AddLine("Show/hide main window", 1.0, 1.0, 1.0, true)
	end
})

function Adjutant:OnInitialize()
	Adjutant.Frame:SetMovable(true)
	Adjutant.Frame:EnableMouse(true)
	Adjutant.Frame:RegisterForDrag("LeftButton")
	Adjutant.Frame:SetScript("OnDragStart", Adjutant.Frame.StartMoving)
	Adjutant.Frame:SetScript("OnDragStop", Adjutant.Frame.StopMovingOrSizing)

	Adjutant:RegisterChatCommand("adj", "SlashHandler")
	Adjutant:RegisterChatCommand("adjutant", "SlashHandler")
	
	-- init savefile
	Adjutant.db = LibStub("AceDB-3.0"):New("AdjutantDB")
	if( Adjutant.db.global == nil ) then
		Adjutant.db.global = { }
	end
	if( Adjutant.db.global.npcs == nil ) then
		-- insert some default data
		Adjutant.db.global.npcs = {
			{
				["name"] = "Doom Bloom",
				["model"] = 51090,
				["flag"] = "Literal flower power!",
				["icon"] = "star",
				["lp"] = 100
			},
			{
				["name"] = "Vicious Gnoll",
				["model"] = 1010,
				["flag"] = "Not affiliated, associated, authorized, endorsed by, or in any way officially connected to the one and only Hogger.",
				["icon"] = "skull",
				["lp"] = 100
			},
			{
				["name"] = "Storm Drake",
				["model"] = 109766,
				["flag"] = "The stormiest of drakes.",
				["icon"] = "cross",
				["lp"] = 100
			}			
		}
	end
	if( Adjutant.db.global.minimap == nil ) then
		Adjutant.db.global.minimap = { }
	end
	
	Adjutant.MinimapIcon:Register("Adjutant", Adjutant.MinimapIcon.Obj, Adjutant.db.global.minimap)

	-- tables are anonymous
	Adjutant.NPCs = Adjutant.db.global.npcs
	
	-- initialize frames
	for i = 1, ADJ_NUM_FRAMES, 1 do
		Adjutant:AddFrame(i)
	end

	Adjutant:LoadExistingNPCs()
	
	-- communication
	Adjutant:RegisterComm(ADJ_PREFIX)
	
	Adjutant.Timer = nil
	
	Adjutant.Frame.Title:SetText(GetAddOnMetadata("Adjutant", "Title"))
	Adjutant.Frame.Description:SetText(" (v" .. GetAddOnMetadata("Adjutant", "Version") .. ") | " .. Adjutant.Locale["by"] .. " " .. GetAddOnMetadata("Adjutant", "Author"))
end

function Adjutant:OnCommReceived(prefix, message, distribution, sender)
	if(sender == UnitName("player") or prefix ~= ADJ_PREFIX) then return end
	if(message == ADJ_RESET) then
		Adjutant:RemoveAllNPCs()
		return
	end
	local succes, framenr, npcdata = Adjutant:Deserialize(message)
	if(not succes) then
		-- TODO: Ask leader to send again
		return
	end
	Adjutant:UpdateNPC(framenr, npcdata["name"], npcdata["model"], npcdata["icon"], npcdata["lp"], npcdata["flag"])
	Adjutant:ScheduleRefresh()	
end

function Adjutant:SendClientMessage(msg) 
	if( not Adjutant:IsGroupLeader("player") ) then return end
	Adjutant:SendCommMessage(ADJ_PREFIX, msg, "RAID", nil, "BULK")
end

function Adjutant:UpdateClientNPC(framenr)
	if(not Adjutant:IsGroupLeader("player") ) then return end
	if(framenr == nil or framenr < 1) then return end
	
	local msg = Adjutant:Serialize(framenr, Adjutant.NPCs[framenr])
	Adjutant:ScheduleTimer("SendClientMessage", framenr - 1, msg)
end


function Adjutant:UpdateAllClientNPC()
	Adjutant:SendClientMessage(ADJ_RESET)
	for k, v in pairs (Adjutant.NPCs) do
		Adjutant:UpdateClientNPC(k)
	end	
end

function Adjutant:IsGroupLeader(unit)
	if (not IsInGroup(unit) or UnitIsGroupLeader(unit))	then 
		return true 
	end
	return false
end

function Adjutant:Show()
	Adjutant:UpdateAll()
	AdjutantFrame:Show()
	AdjutantFrame:SetAlpha(1.0)
end

function Adjutant:Hide()
	AdjutantFrame:Hide()
end

function Adjutant:AddFrame(framenr) 
	if ( #Adjutant.Viewer.Frames >= ADJ_NUM_FRAMES or framenr > ADJ_NUM_FRAMES ) then
		return nil
	end
	local f = CreateFrame("FRAME", "AdjutantNPC" .. framenr, Adjutant.Viewer, "AdjutantNPCTemplate" .. framenr)
	f:Hide()
	table.insert(Adjutant.Viewer.Frames, f)
	return f
end

function Adjutant:GetFrame(framenr) 
	if ( framenr > #Adjutant.Viewer.Frames ) then
		return nil
	end
	return Adjutant.Viewer.Frames[framenr]
end

function Adjutant:HideFrame(framenr)
	local f = Adjutant:GetFrame(framenr)
	if(f ~= nil) then 
		f:Hide()
	end
end

function Adjutant:FindFirstEmptyFrame()
	for i = 0, #Adjutant.Viewer.Frames, 1 do
		if( Adjutant.Viewer.Frames[i] ~= nil and (Adjutant.NPCs[i] == nil or next(Adjutant.NPCs[i]) == nil)) then
			return i
		end
	end	
	return -1
end

-- command line methods
function Adjutant:CmdRemoveNPC(input)
	if (not Adjutant:IsGroupLeader("player") ) then
		Adjutant:Print("Only the leader can change NPCs.")
		return
	end
	local i = tonumber(input)
	if(i == nil) then
		Adjutant:Print("Usage: /adj remove x")
		Adjutant:Print("Example: /adj remove 4")
		return
	end
	Adjutant:RemoveNPC(i)
end
		
function Adjutant:CmdAddNPC(input) 
	if (not Adjutant:IsGroupLeader("player") ) then
		Adjutant:Print("Only the leader can change NPCs.")
		return
	end
	local attribs = { }
	local i = 0
	for att in (input .. "#"):gmatch("([^#]*)#") do 
		table.insert(attribs, att) 
		i = i + 1
	end
	if(i < 5) then
		Adjutant:Print("Usage: /adj add name#creatureid#icon#lp#flag")
		Adjutant:Print("Example: /adj add Arbeiter#383#skull#100#Ein stinknormaler Kerl.")
		return
	end
	Adjutant:AddNPC(attribs[1], attribs[2], attribs[3], tonumber(attribs[4]), attribs[5])
end

function Adjutant:CmdUpdateAllNPCs()
	if (not Adjutant:IsGroupLeader("player") ) then
		Adjutant:Print("Only the leader can change NPCs.")
		return
	end
	Adjutant:UpdateAllClientNPC()
end

function Adjutant:AddTestNPC(creatureid)
	if(creatureid == nil or tonumber(creatureid) < 1) then return end
	Adjutant:AddNPC(tonumber(creatureid), tonumber(creatureid), "skull", 100, "Lorem ipsum...")
end

function Adjutant:AddNPC(creaturename, model, icon, lp, flag)
	local framenr = Adjutant:FindFirstEmptyFrame()
	Adjutant:UpdateNPC(framenr, creaturename, model, icon, lp, flag)
	Adjutant:UpdateClientNPC(framenr)
	Adjutant:ScheduleRefresh()
end

function Adjutant:UpdateNPC(framenr, creaturename, model, icon, lp, flag)
	if( framenr < 0 or #Adjutant.Viewer.Frames < framenr ) then
		return
	end
	if (Adjutant.NPCs[framenr] == nil) then
		Adjutant.NPCs[framenr] = { }
	end
	
	local f = Adjutant.Viewer.Frames[framenr]
	f:Show()
	
	if( creaturename ~= nil and creaturename ~= "" ) then
		Adjutant.NPCs[framenr]["name"] = creaturename
		f.centerDisplay.title.text:SetText(Adjutant.NPCs[framenr]["name"])
	end
	model = tonumber(model)
	if( model ~= nil and model > 0 ) then
		Adjutant.NPCs[framenr]["model"] = model
		--f.centerDisplay.model:SetModel(Adjutant.NPCs[framenr]["model"])
		f.centerDisplay.model:SetPosition(0, 0, 0);
		f.centerDisplay.model:SetAnimation(0, 0)		
		f.centerDisplay.model:SetFacing(0.5 - (math.random(0, 10) / 10.0))
		f.centerDisplay.model:SetModelScale(1.1 - (math.random(0, 2) / 10.0))
		f.centerDisplay.model:SetCreature(Adjutant.NPCs[framenr]["model"])
		f.centerDisplay.model:RefreshUnit()
		f.centerDisplay.model:Hide()
		f.centerDisplay.model:Show()
	end
	if( icon ~= nil and icon ~= "") then
		Adjutant.NPCs[framenr]["icon"] = icon
		Adjutant:SetNPCIcon(Adjutant.NPCs[framenr]["icon"], f.icon)
	end
	lp = tonumber(lp)
	if ( lp ~= nil and lp > -1 and lp <= 100 ) then
		Adjutant.NPCs[framenr]["lp"] = lp
		f.centerDisplay.healthBar:SetValue(Adjutant.NPCs[framenr]["lp"])
	end
	if ( flag ~= nil and flag ~= "" ) then
		if(string.len(flag) > ADJ_MAX_FLAG_LENGTH) then
			flag = string.sub(flag, 0, ADJ_MAX_FLAG_LENGTH)
		end
		Adjutant.NPCs[framenr]["flag"] = flag
		local children = { f.centerDisplay, f.centerDisplay:GetChildren() };
		-- no ternary operator in lua :/
		local anchor = "ANCHOR_" .. ( framenr <= (ADJ_NUM_FRAMES / 2) and "BOTTOM" or "TOP" )
		
		for _, child in ipairs(children) do
			child:SetScript("OnEnter", function(self)
				GameTooltip:SetOwner(f, anchor)
				GameTooltip:SetText(Adjutant.NPCs[framenr]["flag"], 1.0, 1.0, 1.0, nil, true)
				GameTooltip:Show()
			end)
			child:SetScript("OnLeave", function(self)
				GameTooltip:Hide()
			end)
		end	
	end
end

function Adjutant:ScheduleRefresh()
	Adjutant:CancelTimer(Adjutant.Timer)
	Adjutant.Timer = Adjutant:ScheduleTimer("UpdateAll", ADJ_REFRESH_LENGTH)
end

function Adjutant:HideAll()
	for i = 1, ADJ_NUM_FRAMES, 1 do
		Adjutant:HideFrame(i)
	end
end

function Adjutant:UpdateAll()
	Adjutant:HideAll()
	Adjutant:LoadExistingNPCs() 
end

function Adjutant:LoadExistingNPCs() 
	for k, v in pairs (Adjutant.NPCs) do
		Adjutant:UpdateNPC(k, v["name"], v["model"], v["icon"], v["lp"], v["flag"])
	end
end

function Adjutant:RemoveAllNPCs()
	for i = 1, ADJ_NUM_FRAMES, 1 do
		table.remove(Adjutant.NPCs, i)
		Adjutant:HideFrame(i)
	end
	Adjutant:UpdateAllClientNPC()
end

function Adjutant:RemoveNPC(framenr) 
	if( framenr == nil or framenr < 0 or #Adjutant.Viewer.Frames < framenr ) then
		return
	end
	table.remove(Adjutant.NPCs, framenr)
	Adjutant:UpdateAll()
	Adjutant:UpdateAllClientNPC()
end

function Adjutant:SetNPCIcon(icon, texture) 
	texture:SetMask(nil)
	-- no switch in lua ._.
	if (icon == "skull") then 
		texture:SetTexCoord(0.75, 1.0, 0.25, 0.5)
	elseif (icon == "cross") then 
		texture:SetTexCoord(0.5, 0.75, 0.25, 0.5)
	elseif (icon == "square") then
		texture:SetTexCoord(0.25, 0.5, 0.25, 0.5)
	elseif (icon == "moon") then
		texture:SetTexCoord(0.0, 0.25, 0.25, 0.5)
	elseif (icon == "triangle") then
		texture:SetTexCoord(0.75, 1.0, 0.0, 0.25)		
	elseif (icon == "diamond") then
		texture:SetTexCoord(0.5, 0.75, 0.0, 0.25)		
	elseif (icon == "circle") then
		texture:SetTexCoord(0.25, 0.5, 0.0, 0.25)		
	elseif (icon == "star") then 
		texture:SetTexCoord(0.0, 0.25, 0.0, 0.25)		
	else
		texture:SetTexCoord(0.0, 0.25, 0.5, 0.75)		
	end
	texture:SetMask("Interface\\CharacterFrame\\TempPortraitAlphaMask")
end

function Adjutant:SlashHandler(input) 
	if (input == "show") then
		Adjutant:Show()
	elseif (input == "hide") then
		Adjutant:Hide()
	elseif (input == "update") then
		Adjutant:CmdUpdateAllNPCs()
	elseif (string.starts(input, "add")) then
		Adjutant:CmdAddNPC(string.sub(input, 5, string.len(input)))
	elseif (string.starts(input, "remove")) then
		Adjutant:CmdRemoveNPC(string.sub(input, 8, string.len(input)))		
	elseif (string.starts(input, "test")) then
		Adjutant:AddTestNPC(string.sub(input, 6, string.len(input)))
	else
		Adjutant:Print("/adj show | hide | add x | remove x | update")
	end
end

-- helper methods, because lua's completely useless
function string.starts(str, start)
   return string.sub(str, 1, string.len(start)) == start
end

