--- tokenData.lua
-- Contains equip location and useable classes from tier tokens
-- @author Potdisc
-- Create Date : 3/11/2013 10:25:13 PM
-- Update Date : 12/18/2017 (7.3.2 Build 25549)

--[===[@debug@
if LibDebug then LibDebug() end
--@end-debug@]===]

--[===[@debug@
-- This function is used for developer.
-- Export all POTENTIAL tokens. Manual modification is still required.
-- Only support Engish client
-- Note that only item type data is automatically(almost) exported.
-- Item level data need to be manually entered.
-- The format is {[itemID] = SLOT}
local tokenNames = {}
local tokenIlvls = {}

-- The params are used internally inside this function
function RCLootCouncil:ExportTokenData(nextID)
	if not nextID then 
		nextID = 1
		self:Print("Exporting the data of all potential token.\n"
			.."This command is intended to be run by the developer.\n"
			.."After exporting is done and copy and paste the data into Utils/tokenData.lua.\n"
			.."This is semi-automatic. Data (especially item level data) must be verified and modified manually later.\n"
			.."Only support English Client\n"
			.."Dont run any extra /rc exporttokendata when it is running."
			.."Commented lines in exports mean not sure and need to manually determine it.")
	end
	local LAST_ID = 250000
    for i = nextID, LAST_ID do
        local _, _, _, _, _, typeID, subTypeID = GetItemInfoInstant(i)
        if typeID == 15 and subTypeID == 0 then -- Miscellaneous, Junk
            self:ExportTokenDataSingle(i)
            return C_Timer.After(0, function() self:ExportTokenData(i + 1) end)
        end
    end
    if nextID < LAST_ID then
        return C_Timer.After(1, function() self:ExportTokenData(LAST_ID + 1) end) -- Extra delay so we don't lose data at the end.
    end

	local count = 0
	for id, name in pairs(tokenNames) do
		count = count + 1
	end
	self:Print(format("DONE. %d potential tokens total", count))
	self:Print("Copy and paste data to Util/tokenData.lua")
	self:Print("This is semi-automatic. Data must be verified and modified manually.")

	-- Hack that should only happen in developer mode.
	local frame = RCLootCouncil:GetActiveModule("history"):GetFrame()
	frame.exportFrame:Show()

	local exports ="_G.RCTokenTable = {\n"
	local sorted = {}
	for id, name in pairs(tokenNames) do
		tinsert(sorted, {id, name})
	end
	table.sort(sorted, function(a, b) return a[1] < b[1] end)
	for _, entry in ipairs(sorted) do
		local slot = ""
		local name = entry[2]
		local l = name:lower()
		if l:find("helm") or l:find("head") or l:find("crown") or l:find("circlet") then
			slot = "HeadSlot"
		elseif l:find("shoulder") or l:find("pauldron") or l:find("mantle") or l:find("spaulder") then
			slot = "ShoulderSlot"
		elseif l:find("cloak") then
			slot = "BackSlot"
		elseif l:find("breastplate") or l:find("tunic") or l:find("robe") or l:find("chest") then
			slot = "ChestSlot"
		elseif l:find("hand") or l:find("glove") or l:find("gauntlets") then
			slot = "HandsSlot"
		elseif l:find("leg") then
			slot = "LegsSlot"
		elseif l:find("badge") then
			slot = "Trinket"
		elseif l:find("essence") or l:find("regalia") or l:find("sanctification") then
			slot = "MultiSlots"
		elseif l:find("wrist") or l:find("bracer") or l:find("bindings") then
			slot = "WristSlot"
		elseif l:find("waist") or l:find("girdle") or l:find("belt") then
			slot = "WaistSlot"
		elseif l:find("feet") or l:find("sandal") or l:find("boot") or l:find("sabaton") then
			slot = "FeetSlot"
		end

		if slot == "" then
			exports = exports.."\t-- ".."["..entry[1].."] = "..format("%-11s", format("%q", slot))
					..",\t-- "..format("%s", name..",").."\n"
		else
			exports = exports.."\t["..entry[1].."] = "..format("%-14s", format("%q", slot))
					..",\t-- "..format("%s", name..",").."\n"
		end
	end
	exports = exports.."}\n\n"

	exports = exports.."-- Note: Some of item level data is manually entered."
	exports = exports.."\n_G.RCTokenIlvl = {\n"
	for _, entry in ipairs(sorted) do
		local id = entry[1]
		local name = entry[2]
		exports = exports.."\t["..id.."] = "..format("%03d", tokenIlvls[id])..",\t-- "..format("%s", name..",").."\n"
	end
	exports = exports.."}\n"
	frame.exportFrame.edit:SetText(exports)
end

function RCLootCouncil:ExportTokenDataSingle(id)
	if GetItemInfo(id) then
        local name, link, quality, ilvl, _, _, _, maxStack = GetItemInfo(id)
        if self:GetItemClassesAllowedFlag(link) ~= 0xffffffff and maxStack == 1 and quality == 4 then
            DEFAULT_CHAT_FRAME:AddMessage(id.." "..name)
            tokenNames[id] = name
            tokenIlvls[id] = ilvl
        end
    else
        return C_Timer.After(0, function() self:ExportTokenDataSingle(id) end)
    end
end
--@end-debug@]===]

-- Equip locations
_G.RCTokenTable = {
	[22349] = "ChestSlot"   ,	-- Desecrated Breastplate,
	[22350] = "ChestSlot"   ,	-- Desecrated Tunic,
	[22351] = "ChestSlot"   ,	-- Desecrated Robe,
	[22352] = "LegsSlot"    ,	-- Desecrated Legplates,
	[22353] = "HeadSlot"    ,	-- Desecrated Helmet,
	[22354] = "ShoulderSlot",	-- Desecrated Pauldrons,
	[22355] = "WristSlot"   ,	-- Desecrated Bracers,
	[22356] = "WaistSlot"   ,	-- Desecrated Waistguard,
	[22357] = "HandsSlot"   ,	-- Desecrated Gauntlets,
	[22358] = "FeetSlot"    ,	-- Desecrated Sabatons,
	[22359] = "LegsSlot"    ,	-- Desecrated Legguards,
	[22360] = "HeadSlot"    ,	-- Desecrated Headpiece,
	[22361] = "ShoulderSlot",	-- Desecrated Spaulders,
	[22362] = "WristSlot"   ,	-- Desecrated Wristguards,
	[22363] = "WaistSlot"   ,	-- Desecrated Girdle,
	[22364] = "HandsSlot"   ,	-- Desecrated Handguards,
	[22365] = "FeetSlot"    ,	-- Desecrated Boots,
	[22366] = "LegsSlot"    ,	-- Desecrated Leggings,
	[22367] = "HeadSlot"    ,	-- Desecrated Circlet,
	[22368] = "ShoulderSlot",	-- Desecrated Shoulderpads,
	[22369] = "WristSlot"   ,	-- Desecrated Bindings,
	[22370] = "WaistSlot"   ,	-- Desecrated Belt,
	[22371] = "HandsSlot"   ,	-- Desecrated Gloves,
	[22372] = "FeetSlot"    ,	-- Desecrated Sandals,
	[29753] = "ChestSlot"   ,	-- Chestguard of the Fallen Defender,
	[29754] = "ChestSlot"   ,	-- Chestguard of the Fallen Champion,
	[29755] = "ChestSlot"   ,	-- Chestguard of the Fallen Hero,
	[29756] = "HandsSlot"   ,	-- Gloves of the Fallen Hero,
	[29757] = "HandsSlot"   ,	-- Gloves of the Fallen Champion,
	[29758] = "HandsSlot"   ,	-- Gloves of the Fallen Defender,
	[29759] = "HeadSlot"    ,	-- Helm of the Fallen Hero,
	[29760] = "HeadSlot"    ,	-- Helm of the Fallen Champion,
	[29761] = "HeadSlot"    ,	-- Helm of the Fallen Defender,
	[29762] = "ShoulderSlot",	-- Pauldrons of the Fallen Hero,
	[29763] = "ShoulderSlot",	-- Pauldrons of the Fallen Champion,
	[29764] = "ShoulderSlot",	-- Pauldrons of the Fallen Defender,
	[29765] = "LegsSlot"    ,	-- Leggings of the Fallen Hero,
	[29766] = "LegsSlot"    ,	-- Leggings of the Fallen Champion,
	[29767] = "LegsSlot"    ,	-- Leggings of the Fallen Defender,
	[30236] = "ChestSlot"   ,	-- Chestguard of the Vanquished Champion,
	[30237] = "ChestSlot"   ,	-- Chestguard of the Vanquished Defender,
	[30238] = "ChestSlot"   ,	-- Chestguard of the Vanquished Hero,
	[30239] = "HandsSlot"   ,	-- Gloves of the Vanquished Champion,
	[30240] = "HandsSlot"   ,	-- Gloves of the Vanquished Defender,
	[30241] = "HandsSlot"   ,	-- Gloves of the Vanquished Hero,
	[30242] = "HeadSlot"    ,	-- Helm of the Vanquished Champion,
	[30243] = "HeadSlot"    ,	-- Helm of the Vanquished Defender,
	[30244] = "HeadSlot"    ,	-- Helm of the Vanquished Hero,
	[30245] = "LegsSlot"    ,	-- Leggings of the Vanquished Champion,
	[30246] = "LegsSlot"    ,	-- Leggings of the Vanquished Defender,
	[30247] = "LegsSlot"    ,	-- Leggings of the Vanquished Hero,
	[30248] = "ShoulderSlot",	-- Pauldrons of the Vanquished Champion,
	[30249] = "ShoulderSlot",	-- Pauldrons of the Vanquished Defender,
	[30250] = "ShoulderSlot",	-- Pauldrons of the Vanquished Hero,
	[31089] = "ChestSlot"   ,	-- Chestguard of the Forgotten Conqueror,
	[31090] = "ChestSlot"   ,	-- Chestguard of the Forgotten Vanquisher,
	[31091] = "ChestSlot"   ,	-- Chestguard of the Forgotten Protector,
	[31092] = "HandsSlot"   ,	-- Gloves of the Forgotten Conqueror,
	[31093] = "HandsSlot"   ,	-- Gloves of the Forgotten Vanquisher,
	[31094] = "HandsSlot"   ,	-- Gloves of the Forgotten Protector,
	[31095] = "HeadSlot"    ,	-- Helm of the Forgotten Protector,
	[31096] = "HeadSlot"    ,	-- Helm of the Forgotten Vanquisher,
	[31097] = "HeadSlot"    ,	-- Helm of the Forgotten Conqueror,
	[31098] = "LegsSlot"    ,	-- Leggings of the Forgotten Conqueror,
	[31099] = "LegsSlot"    ,	-- Leggings of the Forgotten Vanquisher,
	[31100] = "LegsSlot"    ,	-- Leggings of the Forgotten Protector,
	[31101] = "ShoulderSlot",	-- Pauldrons of the Forgotten Conqueror,
	[31102] = "ShoulderSlot",	-- Pauldrons of the Forgotten Vanquisher,
	[31103] = "ShoulderSlot",	-- Pauldrons of the Forgotten Protector,
	[34848] = "WristSlot"   ,	-- Bracers of the Forgotten Conqueror,
	[34851] = "WristSlot"   ,	-- Bracers of the Forgotten Protector,
	[34852] = "WristSlot"   ,	-- Bracers of the Forgotten Vanquisher,
	[34853] = "WaistSlot"   ,	-- Belt of the Forgotten Conqueror,
	[34854] = "WaistSlot"   ,	-- Belt of the Forgotten Protector,
	[34855] = "WaistSlot"   ,	-- Belt of the Forgotten Vanquisher,
	[34856] = "FeetSlot"    ,	-- Boots of the Forgotten Conqueror,
	[34857] = "FeetSlot"    ,	-- Boots of the Forgotten Protector,
	[34858] = "FeetSlot"    ,	-- Boots of the Forgotten Vanquisher,
	[40610] = "ChestSlot"   ,	-- Chestguard of the Lost Conqueror,
	[40611] = "ChestSlot"   ,	-- Chestguard of the Lost Protector,
	[40612] = "ChestSlot"   ,	-- Chestguard of the Lost Vanquisher,
	[40613] = "HandsSlot"   ,	-- Gloves of the Lost Conqueror,
	[40614] = "HandsSlot"   ,	-- Gloves of the Lost Protector,
	[40615] = "HandsSlot"   ,	-- Gloves of the Lost Vanquisher,
	[40616] = "HeadSlot"    ,	-- Helm of the Lost Conqueror,
	[40617] = "HeadSlot"    ,	-- Helm of the Lost Protector,
	[40618] = "HeadSlot"    ,	-- Helm of the Lost Vanquisher,
	[40619] = "LegsSlot"    ,	-- Leggings of the Lost Conqueror,
	[40620] = "LegsSlot"    ,	-- Leggings of the Lost Protector,
	[40621] = "LegsSlot"    ,	-- Leggings of the Lost Vanquisher,
	[40622] = "ShoulderSlot",	-- Spaulders of the Lost Conqueror,
	[40623] = "ShoulderSlot",	-- Spaulders of the Lost Protector,
	[40624] = "ShoulderSlot",	-- Spaulders of the Lost Vanquisher,
	[40625] = "ChestSlot"   ,	-- Breastplate of the Lost Conqueror,
	[40626] = "ChestSlot"   ,	-- Breastplate of the Lost Protector,
	[40627] = "ChestSlot"   ,	-- Breastplate of the Lost Vanquisher,
	[40628] = "HandsSlot"   ,	-- Gauntlets of the Lost Conqueror,
	[40629] = "HandsSlot"   ,	-- Gauntlets of the Lost Protector,
	[40630] = "HandsSlot"   ,	-- Gauntlets of the Lost Vanquisher,
	[40631] = "HeadSlot"    ,	-- Crown of the Lost Conqueror,
	[40632] = "HeadSlot"    ,	-- Crown of the Lost Protector,
	[40633] = "HeadSlot"    ,	-- Crown of the Lost Vanquisher,
	[40634] = "LegsSlot"    ,	-- Legplates of the Lost Conqueror,
	[40635] = "LegsSlot"    ,	-- Legplates of the Lost Protector,
	[40636] = "LegsSlot"    ,	-- Legplates of the Lost Vanquisher,
	[40637] = "ShoulderSlot",	-- Mantle of the Lost Conqueror,
	[40638] = "ShoulderSlot",	-- Mantle of the Lost Protector,
	[40639] = "ShoulderSlot",	-- Mantle of the Lost Vanquisher,
	[45632] = "ChestSlot"   ,	-- Breastplate of the Wayward Conqueror,
	[45633] = "ChestSlot"   ,	-- Breastplate of the Wayward Protector,
	[45634] = "ChestSlot"   ,	-- Breastplate of the Wayward Vanquisher,
	[45635] = "ChestSlot"   ,	-- Chestguard of the Wayward Conqueror,
	[45636] = "ChestSlot"   ,	-- Chestguard of the Wayward Protector,
	[45637] = "ChestSlot"   ,	-- Chestguard of the Wayward Vanquisher,
	[45638] = "HeadSlot"    ,	-- Crown of the Wayward Conqueror,
	[45639] = "HeadSlot"    ,	-- Crown of the Wayward Protector,
	[45640] = "HeadSlot"    ,	-- Crown of the Wayward Vanquisher,
	[45641] = "HandsSlot"   ,	-- Gauntlets of the Wayward Conqueror,
	[45642] = "HandsSlot"   ,	-- Gauntlets of the Wayward Protector,
	[45643] = "HandsSlot"   ,	-- Gauntlets of the Wayward Vanquisher,
	[45644] = "HandsSlot"   ,	-- Gloves of the Wayward Conqueror,
	[45645] = "HandsSlot"   ,	-- Gloves of the Wayward Protector,
	[45646] = "HandsSlot"   ,	-- Gloves of the Wayward Vanquisher,
	[45647] = "HeadSlot"    ,	-- Helm of the Wayward Conqueror,
	[45648] = "HeadSlot"    ,	-- Helm of the Wayward Protector,
	[45649] = "HeadSlot"    ,	-- Helm of the Wayward Vanquisher,
	[45650] = "LegsSlot"    ,	-- Leggings of the Wayward Conqueror,
	[45651] = "LegsSlot"    ,	-- Leggings of the Wayward Protector,
	[45652] = "LegsSlot"    ,	-- Leggings of the Wayward Vanquisher,
	[45653] = "LegsSlot"    ,	-- Legplates of the Wayward Conqueror,
	[45654] = "LegsSlot"    ,	-- Legplates of the Wayward Protector,
	[45655] = "LegsSlot"    ,	-- Legplates of the Wayward Vanquisher,
	[45656] = "ShoulderSlot",	-- Mantle of the Wayward Conqueror,
	[45657] = "ShoulderSlot",	-- Mantle of the Wayward Protector,
	[45658] = "ShoulderSlot",	-- Mantle of the Wayward Vanquisher,
	[45659] = "ShoulderSlot",	-- Spaulders of the Wayward Conqueror,
	[45660] = "ShoulderSlot",	-- Spaulders of the Wayward Protector,
	[45661] = "ShoulderSlot",	-- Spaulders of the Wayward Vanquisher,
	[47557] = "MultiSlots"  ,	-- Regalia of the Grand Conqueror,
	[47558] = "MultiSlots"  ,	-- Regalia of the Grand Protector,
	[47559] = "MultiSlots"  ,	-- Regalia of the Grand Vanquisher,
	[52025] = "MultiSlots"  ,	-- Vanquisher's Mark of Sanctification,
	[52026] = "MultiSlots"  ,	-- Protector's Mark of Sanctification,
	[52027] = "MultiSlots"  ,	-- Conqueror's Mark of Sanctification,
	[52028] = "MultiSlots"  ,	-- Vanquisher's Mark of Sanctification,
	[52029] = "MultiSlots"  ,	-- Protector's Mark of Sanctification,
	[52030] = "MultiSlots"  ,	-- Conqueror's Mark of Sanctification,
	[63682] = "HeadSlot"    ,	-- Helm of the Forlorn Vanquisher,
	[63683] = "HeadSlot"    ,	-- Helm of the Forlorn Conqueror,
	[63684] = "HeadSlot"    ,	-- Helm of the Forlorn Protector,
	[64314] = "ShoulderSlot",	-- Mantle of the Forlorn Vanquisher,
	[64315] = "ShoulderSlot",	-- Mantle of the Forlorn Conqueror,
	[64316] = "ShoulderSlot",	-- Mantle of the Forlorn Protector,
	[65000] = "HeadSlot"    ,	-- Crown of the Forlorn Protector,
	[65001] = "HeadSlot"    ,	-- Crown of the Forlorn Conqueror,
	[65002] = "HeadSlot"    ,	-- Crown of the Forlorn Vanquisher,
	[65087] = "ShoulderSlot",	-- Shoulders of the Forlorn Protector,
	[65088] = "ShoulderSlot",	-- Shoulders of the Forlorn Conqueror,
	[65089] = "ShoulderSlot",	-- Shoulders of the Forlorn Vanquisher,
	[67423] = "ChestSlot"   ,	-- Chest of the Forlorn Conqueror,
	[67424] = "ChestSlot"   ,	-- Chest of the Forlorn Protector,
	[67425] = "ChestSlot"   ,	-- Chest of the Forlorn Vanquisher,
	[67426] = "LegsSlot"    ,	-- Leggings of the Forlorn Vanquisher,
	[67427] = "LegsSlot"    ,	-- Leggings of the Forlorn Protector,
	[67428] = "LegsSlot"    ,	-- Leggings of the Forlorn Conqueror,
	[67429] = "HandsSlot"   ,	-- Gauntlets of the Forlorn Conqueror,
	[67430] = "HandsSlot"   ,	-- Gauntlets of the Forlorn Protector,
	[67431] = "HandsSlot"   ,	-- Gauntlets of the Forlorn Vanquisher,
	[71668] = "HeadSlot"    ,	-- Helm of the Fiery Vanquisher,
	[71669] = "HandsSlot"   ,	-- Gauntlets of the Fiery Vanquisher,
	[71670] = "HeadSlot"    ,	-- Crown of the Fiery Vanquisher,
	[71671] = "LegsSlot"    ,	-- Leggings of the Fiery Vanquisher,
	[71672] = "ChestSlot"   ,	-- Chest of the Fiery Vanquisher,
	[71673] = "ShoulderSlot",	-- Shoulders of the Fiery Vanquisher,
	[71674] = "ShoulderSlot",	-- Mantle of the Fiery Vanquisher,
	[71675] = "HeadSlot"    ,	-- Helm of the Fiery Conqueror,
	[71676] = "HandsSlot"   ,	-- Gauntlets of the Fiery Conqueror,
	[71677] = "HeadSlot"    ,	-- Crown of the Fiery Conqueror,
	[71678] = "LegsSlot"    ,	-- Leggings of the Fiery Conqueror,
	[71679] = "ChestSlot"   ,	-- Chest of the Fiery Conqueror,
	[71680] = "ShoulderSlot",	-- Shoulders of the Fiery Conqueror,
	[71681] = "ShoulderSlot",	-- Mantle of the Fiery Conqueror,
	[71682] = "HeadSlot"    ,	-- Helm of the Fiery Protector,
	[71683] = "HandsSlot"   ,	-- Gauntlets of the Fiery Protector,
	[71684] = "HeadSlot"    ,	-- Crown of the Fiery Protector,
	[71685] = "LegsSlot"    ,	-- Leggings of the Fiery Protector,
	[71686] = "ChestSlot"   ,	-- Chest of the Fiery Protector,
	[71687] = "ShoulderSlot",	-- Shoulders of the Fiery Protector,
	[71688] = "ShoulderSlot",	-- Mantle of the Fiery Protector,
	[78170] = "ShoulderSlot",	-- Shoulders of the Corrupted Vanquisher,
	[78171] = "LegsSlot"    ,	-- Leggings of the Corrupted Vanquisher,
	[78172] = "HeadSlot"    ,	-- Crown of the Corrupted Vanquisher,
	[78173] = "HandsSlot"   ,	-- Gauntlets of the Corrupted Vanquisher,
	[78174] = "ChestSlot"   ,	-- Chest of the Corrupted Vanquisher,
	[78175] = "ShoulderSlot",	-- Shoulders of the Corrupted Protector,
	[78176] = "LegsSlot"    ,	-- Leggings of the Corrupted Protector,
	[78177] = "HeadSlot"    ,	-- Crown of the Corrupted Protector,
	[78178] = "HandsSlot"   ,	-- Gauntlets of the Corrupted Protector,
	[78179] = "ChestSlot"   ,	-- Chest of the Corrupted Protector,
	[78180] = "ShoulderSlot",	-- Shoulders of the Corrupted Conqueror,
	[78181] = "LegsSlot"    ,	-- Leggings of the Corrupted Conqueror,
	[78182] = "HeadSlot"    ,	-- Crown of the Corrupted Conqueror,
	[78183] = "HandsSlot"   ,	-- Gauntlets of the Corrupted Conqueror,
	[78184] = "ChestSlot"   ,	-- Chest of the Corrupted Conqueror,
	[78847] = "ChestSlot"   ,	-- Chest of the Corrupted Conqueror,
	[78848] = "ChestSlot"   ,	-- Chest of the Corrupted Protector,
	[78849] = "ChestSlot"   ,	-- Chest of the Corrupted Vanquisher,
	[78850] = "HeadSlot"    ,	-- Crown of the Corrupted Conqueror,
	[78851] = "HeadSlot"    ,	-- Crown of the Corrupted Protector,
	[78852] = "HeadSlot"    ,	-- Crown of the Corrupted Vanquisher,
	[78853] = "HandsSlot"   ,	-- Gauntlets of the Corrupted Conqueror,
	[78854] = "HandsSlot"   ,	-- Gauntlets of the Corrupted Protector,
	[78855] = "HandsSlot"   ,	-- Gauntlets of the Corrupted Vanquisher,
	[78856] = "LegsSlot"    ,	-- Leggings of the Corrupted Conqueror,
	[78857] = "LegsSlot"    ,	-- Leggings of the Corrupted Protector,
	[78858] = "LegsSlot"    ,	-- Leggings of the Corrupted Vanquisher,
	[78859] = "ShoulderSlot",	-- Shoulders of the Corrupted Conqueror,
	[78860] = "ShoulderSlot",	-- Shoulders of the Corrupted Protector,
	[78861] = "ShoulderSlot",	-- Shoulders of the Corrupted Vanquisher,
	[78862] = "ChestSlot"   ,	-- Chest of the Corrupted Vanquisher,
	[78863] = "ChestSlot"   ,	-- Chest of the Corrupted Conqueror,
	[78864] = "ChestSlot"   ,	-- Chest of the Corrupted Protector,
	[78865] = "HandsSlot"   ,	-- Gauntlets of the Corrupted Vanquisher,
	[78866] = "HandsSlot"   ,	-- Gauntlets of the Corrupted Conqueror,
	[78867] = "HandsSlot"   ,	-- Gauntlets of the Corrupted Protector,
	[78868] = "HeadSlot"    ,	-- Crown of the Corrupted Vanquisher,
	[78869] = "HeadSlot"    ,	-- Crown of the Corrupted Conqueror,
	[78870] = "HeadSlot"    ,	-- Crown of the Corrupted Protector,
	[78871] = "LegsSlot"    ,	-- Leggings of the Corrupted Vanquisher,
	[78872] = "LegsSlot"    ,	-- Leggings of the Corrupted Conqueror,
	[78873] = "LegsSlot"    ,	-- Leggings of the Corrupted Protector,
	[78874] = "ShoulderSlot",	-- Shoulders of the Corrupted Vanquisher,
	[78875] = "ShoulderSlot",	-- Shoulders of the Corrupted Conqueror,
	[78876] = "ShoulderSlot",	-- Shoulders of the Corrupted Protector,
	[89234] = "HeadSlot"    ,	-- Helm of the Shadowy Vanquisher,
	[89235] = "HeadSlot"    ,	-- Helm of the Shadowy Conqueror,
	[89236] = "HeadSlot"    ,	-- Helm of the Shadowy Protector,
	[89237] = "ChestSlot"   ,	-- Chest of the Shadowy Conqueror,
	[89238] = "ChestSlot"   ,	-- Chest of the Shadowy Protector,
	[89239] = "ChestSlot"   ,	-- Chest of the Shadowy Vanquisher,
	[89240] = "HandsSlot"   ,	-- Gauntlets of the Shadowy Conqueror,
	[89241] = "HandsSlot"   ,	-- Gauntlets of the Shadowy Protector,
	[89242] = "HandsSlot"   ,	-- Gauntlets of the Shadowy Vanquisher,
	[89243] = "LegsSlot"    ,	-- Leggings of the Shadowy Conqueror,
	[89244] = "LegsSlot"    ,	-- Leggings of the Shadowy Protector,
	[89245] = "LegsSlot"    ,	-- Leggings of the Shadowy Vanquisher,
	[89246] = "ShoulderSlot",	-- Shoulders of the Shadowy Conqueror,
	[89247] = "ShoulderSlot",	-- Shoulders of the Shadowy Protector,
	[89248] = "ShoulderSlot",	-- Shoulders of the Shadowy Vanquisher,
	[89249] = "ChestSlot"   ,	-- Chest of the Shadowy Vanquisher,
	[89250] = "ChestSlot"   ,	-- Chest of the Shadowy Conqueror,
	[89251] = "ChestSlot"   ,	-- Chest of the Shadowy Protector,
	[89252] = "LegsSlot"    ,	-- Leggings of the Shadowy Vanquisher,
	[89253] = "LegsSlot"    ,	-- Leggings of the Shadowy Conqueror,
	[89254] = "LegsSlot"    ,	-- Leggings of the Shadowy Protector,
	[89255] = "HandsSlot"   ,	-- Gauntlets of the Shadowy Vanquisher,
	[89256] = "HandsSlot"   ,	-- Gauntlets of the Shadowy Conqueror,
	[89257] = "HandsSlot"   ,	-- Gauntlets of the Shadowy Protector,
	[89258] = "HeadSlot"    ,	-- Helm of the Shadowy Vanquisher,
	[89259] = "HeadSlot"    ,	-- Helm of the Shadowy Conqueror,
	[89260] = "HeadSlot"    ,	-- Helm of the Shadowy Protector,
	[89261] = "ShoulderSlot",	-- Shoulders of the Shadowy Vanquisher,
	[89262] = "ShoulderSlot",	-- Shoulders of the Shadowy Conqueror,
	[89263] = "ShoulderSlot",	-- Shoulders of the Shadowy Protector,
	[89264] = "ChestSlot"   ,	-- Chest of the Shadowy Vanquisher,
	[89265] = "ChestSlot"   ,	-- Chest of the Shadowy Conqueror,
	[89266] = "ChestSlot"   ,	-- Chest of the Shadowy Protector,
	[89267] = "LegsSlot"    ,	-- Leggings of the Shadowy Vanquisher,
	[89268] = "LegsSlot"    ,	-- Leggings of the Shadowy Conqueror,
	[89269] = "LegsSlot"    ,	-- Leggings of the Shadowy Protector,
	[89270] = "HandsSlot"   ,	-- Gauntlets of the Shadowy Vanquisher,
	[89271] = "HandsSlot"   ,	-- Gauntlets of the Shadowy Conqueror,
	[89272] = "HandsSlot"   ,	-- Gauntlets of the Shadowy Protector,
	[89273] = "HeadSlot"    ,	-- Helm of the Shadowy Vanquisher,
	[89274] = "HeadSlot"    ,	-- Helm of the Shadowy Conqueror,
	[89275] = "HeadSlot"    ,	-- Helm of the Shadowy Protector,
	[89276] = "ShoulderSlot",	-- Shoulders of the Shadowy Vanquisher,
	[89277] = "ShoulderSlot",	-- Shoulders of the Shadowy Conqueror,
	[89278] = "ShoulderSlot",	-- Shoulders of the Shadowy Protector,
	[95569] = "ChestSlot"   ,	-- Chest of the Crackling Vanquisher,
	[95570] = "HandsSlot"   ,	-- Gauntlets of the Crackling Vanquisher,
	[95571] = "HeadSlot"    ,	-- Helm of the Crackling Vanquisher,
	[95572] = "LegsSlot"    ,	-- Leggings of the Crackling Vanquisher,
	[95573] = "ShoulderSlot",	-- Shoulders of the Crackling Vanquisher,
	[95574] = "ChestSlot"   ,	-- Chest of the Crackling Conqueror,
	[95575] = "HandsSlot"   ,	-- Gauntlets of the Crackling Conqueror,
	[95576] = "LegsSlot"    ,	-- Leggings of the Crackling Conqueror,
	[95577] = "HeadSlot"    ,	-- Helm of the Crackling Conqueror,
	[95578] = "ShoulderSlot",	-- Shoulders of the Crackling Conqueror,
	[95579] = "ChestSlot"   ,	-- Chest of the Crackling Protector,
	[95580] = "HandsSlot"   ,	-- Gauntlets of the Crackling Protector,
	[95581] = "LegsSlot"    ,	-- Leggings of the Crackling Protector,
	[95582] = "HeadSlot"    ,	-- Helm of the Crackling Protector,
	[95583] = "ShoulderSlot",	-- Shoulders of the Crackling Protector,
	[95822] = "ChestSlot"   ,	-- Chest of the Crackling Vanquisher,
	[95823] = "ChestSlot"   ,	-- Chest of the Crackling Conqueror,
	[95824] = "ChestSlot"   ,	-- Chest of the Crackling Protector,
	[95855] = "HandsSlot"   ,	-- Gauntlets of the Crackling Vanquisher,
	[95856] = "HandsSlot"   ,	-- Gauntlets of the Crackling Conqueror,
	[95857] = "HandsSlot"   ,	-- Gauntlets of the Crackling Protector,
	[95879] = "HeadSlot"    ,	-- Helm of the Crackling Vanquisher,
	[95880] = "HeadSlot"    ,	-- Helm of the Crackling Conqueror,
	[95881] = "HeadSlot"    ,	-- Helm of the Crackling Protector,
	[95887] = "LegsSlot"    ,	-- Leggings of the Crackling Vanquisher,
	[95888] = "LegsSlot"    ,	-- Leggings of the Crackling Conqueror,
	[95889] = "LegsSlot"    ,	-- Leggings of the Crackling Protector,
	[95955] = "ShoulderSlot",	-- Shoulders of the Crackling Vanquisher,
	[95956] = "ShoulderSlot",	-- Shoulders of the Crackling Conqueror,
	[95957] = "ShoulderSlot",	-- Shoulders of the Crackling Protector,
	[96194] = "ChestSlot"   ,	-- Chest of the Crackling Vanquisher,
	[96195] = "ChestSlot"   ,	-- Chest of the Crackling Conqueror,
	[96196] = "ChestSlot"   ,	-- Chest of the Crackling Protector,
	[96227] = "HandsSlot"   ,	-- Gauntlets of the Crackling Vanquisher,
	[96228] = "HandsSlot"   ,	-- Gauntlets of the Crackling Conqueror,
	[96229] = "HandsSlot"   ,	-- Gauntlets of the Crackling Protector,
	[96251] = "HeadSlot"    ,	-- Helm of the Crackling Vanquisher,
	[96252] = "HeadSlot"    ,	-- Helm of the Crackling Conqueror,
	[96253] = "HeadSlot"    ,	-- Helm of the Crackling Protector,
	[96259] = "LegsSlot"    ,	-- Leggings of the Crackling Vanquisher,
	[96260] = "LegsSlot"    ,	-- Leggings of the Crackling Conqueror,
	[96261] = "LegsSlot"    ,	-- Leggings of the Crackling Protector,
	[96327] = "ShoulderSlot",	-- Shoulders of the Crackling Vanquisher,
	[96328] = "ShoulderSlot",	-- Shoulders of the Crackling Conqueror,
	[96329] = "ShoulderSlot",	-- Shoulders of the Crackling Protector,
	[96566] = "ChestSlot"   ,	-- Chest of the Crackling Vanquisher,
	[96567] = "ChestSlot"   ,	-- Chest of the Crackling Conqueror,
	[96568] = "ChestSlot"   ,	-- Chest of the Crackling Protector,
	[96599] = "HandsSlot"   ,	-- Gauntlets of the Crackling Vanquisher,
	[96600] = "HandsSlot"   ,	-- Gauntlets of the Crackling Conqueror,
	[96601] = "HandsSlot"   ,	-- Gauntlets of the Crackling Protector,
	[96623] = "HeadSlot"    ,	-- Helm of the Crackling Vanquisher,
	[96624] = "HeadSlot"    ,	-- Helm of the Crackling Conqueror,
	[96625] = "HeadSlot"    ,	-- Helm of the Crackling Protector,
	[96631] = "LegsSlot"    ,	-- Leggings of the Crackling Vanquisher,
	[96632] = "LegsSlot"    ,	-- Leggings of the Crackling Conqueror,
	[96633] = "LegsSlot"    ,	-- Leggings of the Crackling Protector,
	[96699] = "ShoulderSlot",	-- Shoulders of the Crackling Vanquisher,
	[96700] = "ShoulderSlot",	-- Shoulders of the Crackling Conqueror,
	[96701] = "ShoulderSlot",	-- Shoulders of the Crackling Protector,
	[96938] = "ChestSlot"   ,	-- Chest of the Crackling Vanquisher,
	[96939] = "ChestSlot"   ,	-- Chest of the Crackling Conqueror,
	[96940] = "ChestSlot"   ,	-- Chest of the Crackling Protector,
	[96971] = "HandsSlot"   ,	-- Gauntlets of the Crackling Vanquisher,
	[96972] = "HandsSlot"   ,	-- Gauntlets of the Crackling Conqueror,
	[96973] = "HandsSlot"   ,	-- Gauntlets of the Crackling Protector,
	[96995] = "HeadSlot"    ,	-- Helm of the Crackling Vanquisher,
	[96996] = "HeadSlot"    ,	-- Helm of the Crackling Conqueror,
	[96997] = "HeadSlot"    ,	-- Helm of the Crackling Protector,
	[97003] = "LegsSlot"    ,	-- Leggings of the Crackling Vanquisher,
	[97004] = "LegsSlot"    ,	-- Leggings of the Crackling Conqueror,
	[97005] = "LegsSlot"    ,	-- Leggings of the Crackling Protector,
	[97071] = "ShoulderSlot",	-- Shoulders of the Crackling Vanquisher,
	[97072] = "ShoulderSlot",	-- Shoulders of the Crackling Conqueror,
	[97073] = "ShoulderSlot",	-- Shoulders of the Crackling Protector,
	[99667] = "HandsSlot"   ,	-- Gauntlets of the Cursed Protector,
	[99668] = "ShoulderSlot",	-- Shoulders of the Cursed Vanquisher,
	[99669] = "ShoulderSlot",	-- Shoulders of the Cursed Conqueror,
	[99670] = "ShoulderSlot",	-- Shoulders of the Cursed Protector,
	[99671] = "HeadSlot"    ,	-- Helm of the Cursed Vanquisher,
	[99672] = "HeadSlot"    ,	-- Helm of the Cursed Conqueror,
	[99673] = "HeadSlot"    ,	-- Helm of the Cursed Protector,
	[99674] = "LegsSlot"    ,	-- Leggings of the Cursed Vanquisher,
	[99675] = "LegsSlot"    ,	-- Leggings of the Cursed Conqueror,
	[99676] = "LegsSlot"    ,	-- Leggings of the Cursed Protector,
	[99677] = "ChestSlot"   ,	-- Chest of the Cursed Vanquisher,
	[99678] = "ChestSlot"   ,	-- Chest of the Cursed Conqueror,
	[99679] = "ChestSlot"   ,	-- Chest of the Cursed Protector,
	[99680] = "HandsSlot"   ,	-- Gauntlets of the Cursed Vanquisher,
	[99681] = "HandsSlot"   ,	-- Gauntlets of the Cursed Conqueror,
	[99682] = "HandsSlot"   ,	-- Gauntlets of the Cursed Vanquisher,
	[99683] = "HeadSlot"    ,	-- Helm of the Cursed Vanquisher,
	[99684] = "LegsSlot"    ,	-- Leggings of the Cursed Vanquisher,
	[99685] = "ShoulderSlot",	-- Shoulders of the Cursed Vanquisher,
	[99686] = "ChestSlot"   ,	-- Chest of the Cursed Conqueror,
	[99687] = "HandsSlot"   ,	-- Gauntlets of the Cursed Conqueror,
	[99688] = "LegsSlot"    ,	-- Leggings of the Cursed Conqueror,
	[99689] = "HeadSlot"    ,	-- Helm of the Cursed Conqueror,
	[99690] = "ShoulderSlot",	-- Shoulders of the Cursed Conqueror,
	[99691] = "ChestSlot"   ,	-- Chest of the Cursed Protector,
	[99692] = "HandsSlot"   ,	-- Gauntlets of the Cursed Protector,
	[99693] = "LegsSlot"    ,	-- Leggings of the Cursed Protector,
	[99694] = "HeadSlot"    ,	-- Helm of the Cursed Protector,
	[99695] = "ShoulderSlot",	-- Shoulders of the Cursed Protector,
	[99696] = "ChestSlot"   ,	-- Chest of the Cursed Vanquisher,
	[99712] = "LegsSlot"    ,	-- Leggings of the Cursed Conqueror,
	[99713] = "LegsSlot"    ,	-- Leggings of the Cursed Protector,
	[99714] = "ChestSlot"   ,	-- Chest of the Cursed Vanquisher,
	[99715] = "ChestSlot"   ,	-- Chest of the Cursed Conqueror,
	[99716] = "ChestSlot"   ,	-- Chest of the Cursed Protector,
	[99717] = "ShoulderSlot",	-- Shoulders of the Cursed Vanquisher,
	[99718] = "ShoulderSlot",	-- Shoulders of the Cursed Conqueror,
	[99719] = "ShoulderSlot",	-- Shoulders of the Cursed Protector,
	[99720] = "HandsSlot"   ,	-- Gauntlets of the Cursed Vanquisher,
	[99721] = "HandsSlot"   ,	-- Gauntlets of the Cursed Conqueror,
	[99722] = "HandsSlot"   ,	-- Gauntlets of the Cursed Protector,
	[99723] = "HeadSlot"    ,	-- Helm of the Cursed Vanquisher,
	[99724] = "HeadSlot"    ,	-- Helm of the Cursed Conqueror,
	[99725] = "HeadSlot"    ,	-- Helm of the Cursed Protector,
	[99726] = "LegsSlot"    ,	-- Leggings of the Cursed Vanquisher,
	[99742] = "ChestSlot"   ,	-- Chest of the Cursed Vanquisher,
	[99743] = "ChestSlot"   ,	-- Chest of the Cursed Conqueror,
	[99744] = "ChestSlot"   ,	-- Chest of the Cursed Protector,
	[99745] = "HandsSlot"   ,	-- Gauntlets of the Cursed Vanquisher,
	[99746] = "HandsSlot"   ,	-- Gauntlets of the Cursed Conqueror,
	[99747] = "HandsSlot"   ,	-- Gauntlets of the Cursed Protector,
	[99748] = "HeadSlot"    ,	-- Helm of the Cursed Vanquisher,
	[99749] = "HeadSlot"    ,	-- Helm of the Cursed Conqueror,
	[99750] = "HeadSlot"    ,	-- Helm of the Cursed Protector,
	[99751] = "LegsSlot"    ,	-- Leggings of the Cursed Vanquisher,
	[99752] = "LegsSlot"    ,	-- Leggings of the Cursed Conqueror,
	[99753] = "LegsSlot"    ,	-- Leggings of the Cursed Protector,
	[99754] = "ShoulderSlot",	-- Shoulders of the Cursed Vanquisher,
	[99755] = "ShoulderSlot",	-- Shoulders of the Cursed Conqueror,
	[99756] = "ShoulderSlot",	-- Shoulders of the Cursed Protector,
	[105857] = "MultiSlots"  ,	-- Essence of the Cursed Protector,
	[105858] = "MultiSlots"  ,	-- Essence of the Cursed Conqueror,
	[105859] = "MultiSlots"  ,	-- Essence of the Cursed Vanquisher,
	[105860] = "MultiSlots"  ,	-- Essence of the Cursed Protector,
	[105861] = "MultiSlots"  ,	-- Essence of the Cursed Conqueror,
	[105862] = "MultiSlots"  ,	-- Essence of the Cursed Vanquisher,
	[105863] = "MultiSlots"  ,	-- Essence of the Cursed Protector,
	[105864] = "MultiSlots"  ,	-- Essence of the Cursed Conqueror,
	[105865] = "MultiSlots"  ,	-- Essence of the Cursed Vanquisher,
	[105866] = "MultiSlots"  ,	-- Essence of the Cursed Protector,
	[105867] = "MultiSlots"  ,	-- Essence of the Cursed Conqueror,
	[105868] = "MultiSlots"  ,	-- Essence of the Cursed Vanquisher,
	[119305] = "ChestSlot"   ,	-- Chest of the Iron Conqueror,
	[119306] = "HandsSlot"   ,	-- Gauntlets of the Iron Conqueror,
	[119307] = "LegsSlot"    ,	-- Leggings of the Iron Conqueror,
	[119308] = "HeadSlot"    ,	-- Helm of the Iron Conqueror,
	[119309] = "ShoulderSlot",	-- Shoulders of the Iron Conqueror,
	[119310] = "MultiSlots"  ,	-- Essence of the Iron Conqueror,
	[119311] = "HandsSlot"   ,	-- Gauntlets of the Iron Vanquisher,
	[119312] = "HeadSlot"    ,	-- Helm of the Iron Vanquisher,
	[119313] = "LegsSlot"    ,	-- Leggings of the Iron Vanquisher,
	[119314] = "ShoulderSlot",	-- Shoulders of the Iron Vanquisher,
	[119315] = "ChestSlot"   ,	-- Chest of the Iron Vanquisher,
	[119316] = "MultiSlots"  ,	-- Essence of the Iron Vanquisher,
	[119318] = "ChestSlot"   ,	-- Chest of the Iron Protector,
	[119319] = "HandsSlot"   ,	-- Gauntlets of the Iron Protector,
	[119320] = "LegsSlot"    ,	-- Leggings of the Iron Protector,
	[119321] = "HeadSlot"    ,	-- Helm of the Iron Protector,
	[119322] = "ShoulderSlot",	-- Shoulders of the Iron Protector,
	[119323] = "MultiSlots"  ,	-- Essence of the Iron Protector,
	[120206] = "MultiSlots"  ,	-- Essence of the Iron Conqueror,
	[120207] = "MultiSlots"  ,	-- Essence of the Iron Protector,
	[120208] = "MultiSlots"  ,	-- Essence of the Iron Vanquisher,
	[120209] = "MultiSlots"  ,	-- Essence of the Iron Conqueror,
	[120210] = "MultiSlots"  ,	-- Essence of the Iron Protector,
	[120211] = "MultiSlots"  ,	-- Essence of the Iron Vanquisher,
	[120212] = "ChestSlot"   ,	-- Chest of the Iron Conqueror,
	[120213] = "HandsSlot"   ,	-- Gauntlets of the Iron Conqueror,
	[120214] = "LegsSlot"    ,	-- Leggings of the Iron Conqueror,
	[120215] = "HeadSlot"    ,	-- Helm of the Iron Conqueror,
	[120216] = "ShoulderSlot",	-- Shoulders of the Iron Conqueror,
	[120217] = "HandsSlot"   ,	-- Gauntlets of the Iron Vanquisher,
	[120218] = "HeadSlot"    ,	-- Helm of the Iron Vanquisher,
	[120219] = "LegsSlot"    ,	-- Leggings of the Iron Vanquisher,
	[120220] = "ShoulderSlot",	-- Shoulders of the Iron Vanquisher,
	[120221] = "ChestSlot"   ,	-- Chest of the Iron Vanquisher,
	[120222] = "ChestSlot"   ,	-- Chest of the Iron Protector,
	[120223] = "HandsSlot"   ,	-- Gauntlets of the Iron Protector,
	[120224] = "LegsSlot"    ,	-- Leggings of the Iron Protector,
	[120225] = "HeadSlot"    ,	-- Helm of the Iron Protector,
	[120226] = "ShoulderSlot",	-- Shoulders of the Iron Protector,
	[120227] = "ChestSlot"   ,	-- Chest of the Iron Conqueror,
	[120228] = "HandsSlot"   ,	-- Gauntlets of the Iron Conqueror,
	[120229] = "LegsSlot"    ,	-- Leggings of the Iron Conqueror,
	[120230] = "HeadSlot"    ,	-- Helm of the Iron Conqueror,
	[120231] = "ShoulderSlot",	-- Shoulders of the Iron Conqueror,
	[120232] = "HandsSlot"   ,	-- Gauntlets of the Iron Vanquisher,
	[120233] = "HeadSlot"    ,	-- Helm of the Iron Vanquisher,
	[120234] = "LegsSlot"    ,	-- Leggings of the Iron Vanquisher,
	[120235] = "ShoulderSlot",	-- Shoulders of the Iron Vanquisher,
	[120236] = "ChestSlot"   ,	-- Chest of the Iron Vanquisher,
	[120237] = "ChestSlot"   ,	-- Chest of the Iron Protector,
	[120238] = "HandsSlot"   ,	-- Gauntlets of the Iron Protector,
	[120239] = "LegsSlot"    ,	-- Leggings of the Iron Protector,
	[120240] = "HeadSlot"    ,	-- Helm of the Iron Protector,
	[120241] = "ShoulderSlot",	-- Shoulders of the Iron Protector,
	[120242] = "ChestSlot"   ,	-- Chest of the Iron Conqueror,
	[120243] = "HandsSlot"   ,	-- Gauntlets of the Iron Conqueror,
	[120244] = "LegsSlot"    ,	-- Leggings of the Iron Conqueror,
	[120245] = "HeadSlot"    ,	-- Helm of the Iron Conqueror,
	[120246] = "ShoulderSlot",	-- Shoulders of the Iron Conqueror,
	[120247] = "HandsSlot"   ,	-- Gauntlets of the Iron Vanquisher,
	[120248] = "HeadSlot"    ,	-- Helm of the Iron Vanquisher,
	[120249] = "LegsSlot"    ,	-- Leggings of the Iron Vanquisher,
	[120250] = "ShoulderSlot",	-- Shoulders of the Iron Vanquisher,
	[120251] = "ChestSlot"   ,	-- Chest of the Iron Vanquisher,
	[120252] = "ChestSlot"   ,	-- Chest of the Iron Protector,
	[120253] = "HandsSlot"   ,	-- Gauntlets of the Iron Protector,
	[120254] = "LegsSlot"    ,	-- Leggings of the Iron Protector,
	[120255] = "HeadSlot"    ,	-- Helm of the Iron Protector,
	[120256] = "ShoulderSlot",	-- Shoulders of the Iron Protector,
	[120277] = "MultiSlots"  ,	-- Essence of the Iron Conqueror,
	[120278] = "MultiSlots"  ,	-- Essence of the Iron Vanquisher,
	[120279] = "MultiSlots"  ,	-- Essence of the Iron Protector,
	[120280] = "MultiSlots"  ,	-- Essence of the Iron Conqueror,
	[120281] = "MultiSlots"  ,	-- Essence of the Iron Protector,
	[120282] = "MultiSlots"  ,	-- Essence of the Iron Vanquisher,
	[120283] = "MultiSlots"  ,	-- Essence of the Iron Conqueror,
	[120284] = "MultiSlots"  ,	-- Essence of the Iron Protector,
	[120285] = "MultiSlots"  ,	-- Essence of the Iron Vanquisher,
	[127953] = "ChestSlot"   ,	-- Chest of Hellfire's Conqueror,
	[127954] = "HandsSlot"   ,	-- Gauntlets of Hellfire's Conqueror,
	[127955] = "LegsSlot"    ,	-- Leggings of Hellfire's Conqueror,
	[127956] = "HeadSlot"    ,	-- Helm of Hellfire's Conqueror,
	[127957] = "ShoulderSlot",	-- Shoulders of Hellfire's Conqueror,
	[127958] = "HandsSlot"   ,	-- Gauntlets of Hellfire's Vanquisher,
	[127959] = "HeadSlot"    ,	-- Helm of Hellfire's Vanquisher,
	[127960] = "LegsSlot"    ,	-- Leggings of Hellfire's Vanquisher,
	[127961] = "ShoulderSlot",	-- Shoulders of Hellfire's Vanquisher,
	[127962] = "ChestSlot"   ,	-- Chest of Hellfire's Vanquisher,
	[127963] = "ChestSlot"   ,	-- Chest of Hellfire's Protector,
	[127964] = "HandsSlot"   ,	-- Gauntlets of Hellfire's Protector,
	[127965] = "LegsSlot"    ,	-- Leggings of Hellfire's Protector,
	[127966] = "HeadSlot"    ,	-- Helm of Hellfire's Protector,
	[127967] = "ShoulderSlot",	-- Shoulders of Hellfire's Protector,
	[127968] = "Trinket"     ,	-- Badge of Hellfire's Vanquisher,
	[127969] = "Trinket"     ,	-- Badge of Hellfire's Conqueror,
	[127970] = "Trinket"     ,	-- Badge of Hellfire's Protector,
	[143562] = "ChestSlot"   ,	-- Chest of the Foreseen Conqueror,
	[143563] = "HandsSlot"   ,	-- Gauntlets of the Foreseen Conqueror,
	[143564] = "LegsSlot"    ,	-- Leggings of the Foreseen Conqueror,
	[143565] = "HeadSlot"    ,	-- Helm of the Foreseen Conqueror,
	[143566] = "ShoulderSlot",	-- Shoulders of the Foreseen Conqueror,
	[143567] = "HandsSlot"   ,	-- Gauntlets of the Foreseen Vanquisher,
	[143568] = "HeadSlot"    ,	-- Helm of the Foreseen Vanquisher,
	[143569] = "LegsSlot"    ,	-- Leggings of the Foreseen Vanquisher,
	[143570] = "ShoulderSlot",	-- Shoulders of the Foreseen Vanquisher,
	[143571] = "ChestSlot"   ,	-- Chest of the Foreseen Vanquisher,
	[143572] = "ChestSlot"   ,	-- Chest of the Foreseen Protector,
	[143573] = "HandsSlot"   ,	-- Gauntlets of the Foreseen Protector,
	[143574] = "LegsSlot"    ,	-- Leggings of the Foreseen Protector,
	[143575] = "HeadSlot"    ,	-- Helm of the Foreseen Protector,
	[143576] = "ShoulderSlot",	-- Shoulders of the Foreseen Protector,
	[143577] = "BackSlot"    ,	-- Cloak of the Foreseen Conqueror,
	[143578] = "BackSlot"    ,	-- Cloak of the Foreseen Vanquisher,
	[143579] = "BackSlot"    ,	-- Cloak of the Foreseen Protector,
	[147316] = "ChestSlot"   ,	-- Chest of the Foregone Vanquisher,
	[147317] = "ChestSlot"   ,	-- Chest of the Foregone Conqueror,
	[147318] = "ChestSlot"   ,	-- Chest of the Foregone Protector,
	[147319] = "HandsSlot"   ,	-- Gauntlets of the Foregone Vanquisher,
	[147320] = "HandsSlot"   ,	-- Gauntlets of the Foregone Conqueror,
	[147321] = "HandsSlot"   ,	-- Gauntlets of the Foregone Protector,
	[147322] = "HeadSlot"    ,	-- Helm of the Foregone Vanquisher,
	[147323] = "HeadSlot"    ,	-- Helm of the Foregone Conqueror,
	[147324] = "HeadSlot"    ,	-- Helm of the Foregone Protector,
	[147325] = "LegsSlot"    ,	-- Leggings of the Foregone Vanquisher,
	[147326] = "LegsSlot"    ,	-- Leggings of the Foregone Conqueror,
	[147327] = "LegsSlot"    ,	-- Leggings of the Foregone Protector,
	[147328] = "ShoulderSlot",	-- Shoulders of the Foregone Vanquisher,
	[147329] = "ShoulderSlot",	-- Shoulders of the Foregone Conqueror,
	[147330] = "ShoulderSlot",	-- Shoulders of the Foregone Protector,
	[147331] = "BackSlot"    ,	-- Cloak of the Foregone Vanquisher,
	[147332] = "BackSlot"    ,	-- Cloak of the Foregone Conqueror,
	[147333] = "BackSlot"    ,	-- Cloak of the Foregone Protector,
	[152515] = "BackSlot"    ,	-- Cloak of the Antoran Protector,
	[152516] = "BackSlot"    ,	-- Cloak of the Antoran Conqueror,
	[152517] = "BackSlot"    ,	-- Cloak of the Antoran Vanquisher,
	[152518] = "ChestSlot"   ,	-- Chest of the Antoran Vanquisher,
	[152519] = "ChestSlot"   ,	-- Chest of the Antoran Conqueror,
	[152520] = "ChestSlot"   ,	-- Chest of the Antoran Protector,
	[152521] = "HandsSlot"   ,	-- Gauntlets of the Antoran Vanquisher,
	[152522] = "HandsSlot"   ,	-- Gauntlets of the Antoran Conqueror,
	[152523] = "HandsSlot"   ,	-- Gauntlets of the Antoran Protector,
	[152524] = "HeadSlot"    ,	-- Helm of the Antoran Vanquisher,
	[152525] = "HeadSlot"    ,	-- Helm of the Antoran Conqueror,
	[152526] = "HeadSlot"    ,	-- Helm of the Antoran Protector,
	[152527] = "LegsSlot"    ,	-- Leggings of the Antoran Vanquisher,
	[152528] = "LegsSlot"    ,	-- Leggings of the Antoran Conqueror,
	[152529] = "LegsSlot"    ,	-- Leggings of the Antoran Protector,
	[152530] = "ShoulderSlot",	-- Shoulders of the Antoran Vanquisher,
	[152531] = "ShoulderSlot",	-- Shoulders of the Antoran Conqueror,
	[152532] = "ShoulderSlot",	-- Shoulders of the Antoran Protector,
}

-- The base item level for the token on normal difficulty
-- Note: Some of item level data is manually entered.
-- Data in LibGearPoints-1.2.lua in EPGP addon helps a lot.
_G.RCTokenIlvl = {

	-- Tier 3 Naxxramas (No longer obtainable)
	[22349] = 92,	-- Desecrated Breastplate,
	[22350] = 92,	-- Desecrated Tunic,
	[22351] = 92,	-- Desecrated Robe,
	[22352] = 88,	-- Desecrated Legplates,
	[22353] = 88,	-- Desecrated Helmet,
	[22354] = 86,	-- Desecrated Pauldrons,
	[22355] = 88,	-- Desecrated Bracers,
	[22356] = 88,	-- Desecrated Waistguard,
	[22357] = 88,	-- Desecrated Gauntlets,
	[22358] = 86,	-- Desecrated Sabatons,
	[22359] = 88,	-- Desecrated Legguards,
	[22360] = 88,	-- Desecrated Headpiece,
	[22361] = 86,	-- Desecrated Spaulders,
	[22362] = 88,	-- Desecrated Wristguards,
	[22363] = 88,	-- Desecrated Girdle,
	[22364] = 88,	-- Desecrated Handguards,
	[22365] = 86,	-- Desecrated Boots,
	[22366] = 88,	-- Desecrated Leggings,
	[22367] = 88,	-- Desecrated Circlet,
	[22368] = 86,	-- Desecrated Shoulderpads,
	[22369] = 88,	-- Desecrated Bindings,
	[22370] = 88,	-- Desecrated Belt,
	[22371] = 88,	-- Desecrated Gloves,
	[22372] = 86,	-- Desecrated Sandals,

	-- Tier 4
	[29753] = 120,	-- Chestguard of the Fallen Defender,
	[29754] = 120,	-- Chestguard of the Fallen Champion,
	[29755] = 120,	-- Chestguard of the Fallen Hero,
	[29756] = 120,	-- Gloves of the Fallen Hero,
	[29757] = 120,	-- Gloves of the Fallen Champion,
	[29758] = 120,	-- Gloves of the Fallen Defender,
	[29759] = 120,	-- Helm of the Fallen Hero,
	[29760] = 120,	-- Helm of the Fallen Champion,
	[29761] = 120,	-- Helm of the Fallen Defender,
	[29762] = 120,	-- Pauldrons of the Fallen Hero,
	[29763] = 120,	-- Pauldrons of the Fallen Champion,
	[29764] = 120,	-- Pauldrons of the Fallen Defender,
	[29765] = 120,	-- Leggings of the Fallen Hero,
	[29766] = 120,	-- Leggings of the Fallen Champion,
	[29767] = 120,	-- Leggings of the Fallen Defender,

	-- Tier 5
	[30236] = 133,	-- Chestguard of the Vanquished Champion,
	[30237] = 133,	-- Chestguard of the Vanquished Defender,
	[30238] = 133,	-- Chestguard of the Vanquished Hero,
	[30239] = 133,	-- Gloves of the Vanquished Champion,
	[30240] = 133,	-- Gloves of the Vanquished Defender,
	[30241] = 133,	-- Gloves of the Vanquished Hero,
	[30242] = 133,	-- Helm of the Vanquished Champion,
	[30243] = 133,	-- Helm of the Vanquished Defender,
	[30244] = 133,	-- Helm of the Vanquished Hero,
	[30245] = 133,	-- Leggings of the Vanquished Champion,
	[30246] = 133,	-- Leggings of the Vanquished Defender,
	[30247] = 133,	-- Leggings of the Vanquished Hero,
	[30248] = 133,	-- Pauldrons of the Vanquished Champion,
	[30249] = 133,	-- Pauldrons of the Vanquished Defender,
	[30250] = 133,	-- Pauldrons of the Vanquished Hero,

	-- Tier 6
	[31089] = 146,	-- Chestguard of the Forgotten Conqueror,
	[31090] = 146,	-- Chestguard of the Forgotten Vanquisher,
	[31091] = 146,	-- Chestguard of the Forgotten Protector,
	[31092] = 146,	-- Gloves of the Forgotten Conqueror,
	[31093] = 146,	-- Gloves of the Forgotten Vanquisher,
	[31094] = 146,	-- Gloves of the Forgotten Protector,
	[31095] = 146,	-- Helm of the Forgotten Protector,
	[31096] = 146,	-- Helm of the Forgotten Vanquisher,
	[31097] = 146,	-- Helm of the Forgotten Conqueror,
	[31098] = 146,	-- Leggings of the Forgotten Conqueror,
	[31099] = 146,	-- Leggings of the Forgotten Vanquisher,
	[31100] = 146,	-- Leggings of the Forgotten Protector,
	[31101] = 146,	-- Pauldrons of the Forgotten Conqueror,
	[31102] = 146,	-- Pauldrons of the Forgotten Vanquisher,
	[31103] = 146,	-- Pauldrons of the Forgotten Protector,
	[34848] = 154,	-- Bracers of the Forgotten Conqueror,
	[34851] = 154,	-- Bracers of the Forgotten Protector,
	[34852] = 154,	-- Bracers of the Forgotten Vanquisher,
	[34853] = 154,	-- Belt of the Forgotten Conqueror,
	[34854] = 154,	-- Belt of the Forgotten Protector,
	[34855] = 154,	-- Belt of the Forgotten Vanquisher,
	[34856] = 154,	-- Boots of the Forgotten Conqueror,
	[34857] = 154,	-- Boots of the Forgotten Protector,
	[34858] = 154,	-- Boots of the Forgotten Vanquisher,

	-- Tier 7
	[40610] = 200,	-- Chestguard of the Lost Conqueror,
	[40611] = 200,	-- Chestguard of the Lost Protector,
	[40612] = 200,	-- Chestguard of the Lost Vanquisher,
	[40613] = 200,	-- Gloves of the Lost Conqueror,
	[40614] = 200,	-- Gloves of the Lost Protector,
	[40615] = 200,	-- Gloves of the Lost Vanquisher,
	[40616] = 200,	-- Helm of the Lost Conqueror,
	[40617] = 200,	-- Helm of the Lost Protector,
	[40618] = 200,	-- Helm of the Lost Vanquisher,
	[40619] = 200,	-- Leggings of the Lost Conqueror,
	[40620] = 200,	-- Leggings of the Lost Protector,
	[40621] = 200,	-- Leggings of the Lost Vanquisher,
	[40622] = 200,	-- Spaulders of the Lost Conqueror,
	[40623] = 200,	-- Spaulders of the Lost Protector,
	[40624] = 200,	-- Spaulders of the Lost Vanquisher,
	[40625] = 213,	-- Breastplate of the Lost Conqueror,
	[40626] = 213,	-- Breastplate of the Lost Protector,
	[40627] = 213,	-- Breastplate of the Lost Vanquisher,
	[40628] = 213,	-- Gauntlets of the Lost Conqueror,
	[40629] = 213,	-- Gauntlets of the Lost Protector,
	[40630] = 213,	-- Gauntlets of the Lost Vanquisher,
	[40631] = 213,	-- Crown of the Lost Conqueror,
	[40632] = 213,	-- Crown of the Lost Protector,
	[40633] = 213,	-- Crown of the Lost Vanquisher,
	[40634] = 213,	-- Legplates of the Lost Conqueror,
	[40635] = 213,	-- Legplates of the Lost Protector,
	[40636] = 213,	-- Legplates of the Lost Vanquisher,
	[40637] = 213,	-- Mantle of the Lost Conqueror,
	[40638] = 213,	-- Mantle of the Lost Protector,
	[40639] = 213,	-- Mantle of the Lost Vanquisher,

	-- Tier 8
	[45632] = 226,	-- Breastplate of the Wayward Conqueror,
	[45633] = 226,	-- Breastplate of the Wayward Protector,
	[45634] = 226,	-- Breastplate of the Wayward Vanquisher,
	[45635] = 219,	-- Chestguard of the Wayward Conqueror,
	[45636] = 219,	-- Chestguard of the Wayward Protector,
	[45637] = 219,	-- Chestguard of the Wayward Vanquisher,
	[45638] = 226,	-- Crown of the Wayward Conqueror,
	[45639] = 226,	-- Crown of the Wayward Protector,
	[45640] = 226,	-- Crown of the Wayward Vanquisher,
	[45641] = 226,	-- Gauntlets of the Wayward Conqueror,
	[45642] = 226,	-- Gauntlets of the Wayward Protector,
	[45643] = 226,	-- Gauntlets of the Wayward Vanquisher,
	[45644] = 219,	-- Gloves of the Wayward Conqueror,
	[45645] = 219,	-- Gloves of the Wayward Protector,
	[45646] = 219,	-- Gloves of the Wayward Vanquisher,
	[45647] = 219,	-- Helm of the Wayward Conqueror,
	[45648] = 219,	-- Helm of the Wayward Protector,
	[45649] = 219,	-- Helm of the Wayward Vanquisher,
	[45650] = 219,	-- Leggings of the Wayward Conqueror,
	[45651] = 219,	-- Leggings of the Wayward Protector,
	[45652] = 219,	-- Leggings of the Wayward Vanquisher,
	[45653] = 226,	-- Legplates of the Wayward Conqueror,
	[45654] = 226,	-- Legplates of the Wayward Protector,
	[45655] = 226,	-- Legplates of the Wayward Vanquisher,
	[45656] = 226,	-- Mantle of the Wayward Conqueror,
	[45657] = 226,	-- Mantle of the Wayward Protector,
	[45658] = 226,	-- Mantle of the Wayward Vanquisher,
	[45659] = 219,	-- Spaulders of the Wayward Conqueror,
	[45660] = 219,	-- Spaulders of the Wayward Protector,
	[45661] = 219,	-- Spaulders of the Wayward Vanquisher,

	-- Tier 9
	[47557] = 258,	-- Regalia of the Grand Conqueror,
	[47558] = 258,	-- Regalia of the Grand Protector,
	[47559] = 258,	-- Regalia of the Grand Vanquisher,

	-- Tier 10
	[52025] = 264,	-- Vanquisher's Mark of Sanctification,
	[52026] = 264,	-- Protector's Mark of Sanctification,
	[52027] = 264,	-- Conqueror's Mark of Sanctification,
	[52028] = 277,	-- Vanquisher's Mark of Sanctification,
	[52029] = 277,	-- Protector's Mark of Sanctification,
	[52030] = 277,	-- Conqueror's Mark of Sanctification,

	-- Tier 11
	[63682] = 359,	-- Helm of the Forlorn Vanquisher,
	[63683] = 359,	-- Helm of the Forlorn Conqueror,
	[63684] = 359,	-- Helm of the Forlorn Protector,
	[64314] = 359,	-- Mantle of the Forlorn Vanquisher,
	[64315] = 359,	-- Mantle of the Forlorn Conqueror,
	[64316] = 359,	-- Mantle of the Forlorn Protector,
	[65000] = 372,	-- Crown of the Forlorn Protector,
	[65001] = 372,	-- Crown of the Forlorn Conqueror,
	[65002] = 372,	-- Crown of the Forlorn Vanquisher,
	[65087] = 372,	-- Shoulders of the Forlorn Protector,
	[65088] = 372,	-- Shoulders of the Forlorn Conqueror,
	[65089] = 372,	-- Shoulders of the Forlorn Vanquisher,
	[67423] = 372,	-- Chest of the Forlorn Conqueror,
	[67424] = 372,	-- Chest of the Forlorn Protector,
	[67425] = 372,	-- Chest of the Forlorn Vanquisher,
	[67426] = 372,	-- Leggings of the Forlorn Vanquisher,
	[67427] = 372,	-- Leggings of the Forlorn Protector,
	[67428] = 372,	-- Leggings of the Forlorn Conqueror,
	[67429] = 372,	-- Gauntlets of the Forlorn Conqueror,
	[67430] = 372,	-- Gauntlets of the Forlorn Protector,
	[67431] = 372,	-- Gauntlets of the Forlorn Vanquisher,

--[[ Comment out because the 4th return of GetItemInfo() matches the real ilvl	
	-- Tier 12 - 16
	[71668] = 378,	-- Helm of the Fiery Vanquisher,
	[71669] = 391,	-- Gauntlets of the Fiery Vanquisher,
	[71670] = 391,	-- Crown of the Fiery Vanquisher,
	[71671] = 391,	-- Leggings of the Fiery Vanquisher,
	[71672] = 391,	-- Chest of the Fiery Vanquisher,
	[71673] = 391,	-- Shoulders of the Fiery Vanquisher,
	[71674] = 378,	-- Mantle of the Fiery Vanquisher,
	[71675] = 378,	-- Helm of the Fiery Conqueror,
	[71676] = 391,	-- Gauntlets of the Fiery Conqueror,
	[71677] = 391,	-- Crown of the Fiery Conqueror,
	[71678] = 391,	-- Leggings of the Fiery Conqueror,
	[71679] = 391,	-- Chest of the Fiery Conqueror,
	[71680] = 391,	-- Shoulders of the Fiery Conqueror,
	[71681] = 378,	-- Mantle of the Fiery Conqueror,
	[71682] = 378,	-- Helm of the Fiery Protector,
	[71683] = 391,	-- Gauntlets of the Fiery Protector,
	[71684] = 391,	-- Crown of the Fiery Protector,
	[71685] = 391,	-- Leggings of the Fiery Protector,
	[71686] = 391,	-- Chest of the Fiery Protector,
	[71687] = 391,	-- Shoulders of the Fiery Protector,
	[71688] = 378,	-- Mantle of the Fiery Protector,
	[78170] = 397,	-- Shoulders of the Corrupted Vanquisher,
	[78171] = 397,	-- Leggings of the Corrupted Vanquisher,
	[78172] = 397,	-- Crown of the Corrupted Vanquisher,
	[78173] = 397,	-- Gauntlets of the Corrupted Vanquisher,
	[78174] = 397,	-- Chest of the Corrupted Vanquisher,
	[78175] = 397,	-- Shoulders of the Corrupted Protector,
	[78176] = 397,	-- Leggings of the Corrupted Protector,
	[78177] = 397,	-- Crown of the Corrupted Protector,
	[78178] = 397,	-- Gauntlets of the Corrupted Protector,
	[78179] = 397,	-- Chest of the Corrupted Protector,
	[78180] = 397,	-- Shoulders of the Corrupted Conqueror,
	[78181] = 397,	-- Leggings of the Corrupted Conqueror,
	[78182] = 397,	-- Crown of the Corrupted Conqueror,
	[78183] = 397,	-- Gauntlets of the Corrupted Conqueror,
	[78184] = 397,	-- Chest of the Corrupted Conqueror,
	[78847] = 410,	-- Chest of the Corrupted Conqueror,
	[78848] = 410,	-- Chest of the Corrupted Protector,
	[78849] = 410,	-- Chest of the Corrupted Vanquisher,
	[78850] = 410,	-- Crown of the Corrupted Conqueror,
	[78851] = 410,	-- Crown of the Corrupted Protector,
	[78852] = 410,	-- Crown of the Corrupted Vanquisher,
	[78853] = 410,	-- Gauntlets of the Corrupted Conqueror,
	[78854] = 410,	-- Gauntlets of the Corrupted Protector,
	[78855] = 410,	-- Gauntlets of the Corrupted Vanquisher,
	[78856] = 410,	-- Leggings of the Corrupted Conqueror,
	[78857] = 410,	-- Leggings of the Corrupted Protector,
	[78858] = 410,	-- Leggings of the Corrupted Vanquisher,
	[78859] = 410,	-- Shoulders of the Corrupted Conqueror,
	[78860] = 410,	-- Shoulders of the Corrupted Protector,
	[78861] = 410,	-- Shoulders of the Corrupted Vanquisher,
	[78862] = 384,	-- Chest of the Corrupted Vanquisher,
	[78863] = 384,	-- Chest of the Corrupted Conqueror,
	[78864] = 384,	-- Chest of the Corrupted Protector,
	[78865] = 384,	-- Gauntlets of the Corrupted Vanquisher,
	[78866] = 384,	-- Gauntlets of the Corrupted Conqueror,
	[78867] = 384,	-- Gauntlets of the Corrupted Protector,
	[78868] = 384,	-- Crown of the Corrupted Vanquisher,
	[78869] = 384,	-- Crown of the Corrupted Conqueror,
	[78870] = 384,	-- Crown of the Corrupted Protector,
	[78871] = 384,	-- Leggings of the Corrupted Vanquisher,
	[78872] = 384,	-- Leggings of the Corrupted Conqueror,
	[78873] = 384,	-- Leggings of the Corrupted Protector,
	[78874] = 384,	-- Shoulders of the Corrupted Vanquisher,
	[78875] = 384,	-- Shoulders of the Corrupted Conqueror,
	[78876] = 384,	-- Shoulders of the Corrupted Protector,
	[89234] = 496,	-- Helm of the Shadowy Vanquisher,
	[89235] = 496,	-- Helm of the Shadowy Conqueror,
	[89236] = 496,	-- Helm of the Shadowy Protector,
	[89237] = 496,	-- Chest of the Shadowy Conqueror,
	[89238] = 496,	-- Chest of the Shadowy Protector,
	[89239] = 496,	-- Chest of the Shadowy Vanquisher,
	[89240] = 496,	-- Gauntlets of the Shadowy Conqueror,
	[89241] = 496,	-- Gauntlets of the Shadowy Protector,
	[89242] = 496,	-- Gauntlets of the Shadowy Vanquisher,
	[89243] = 496,	-- Leggings of the Shadowy Conqueror,
	[89244] = 496,	-- Leggings of the Shadowy Protector,
	[89245] = 496,	-- Leggings of the Shadowy Vanquisher,
	[89246] = 496,	-- Shoulders of the Shadowy Conqueror,
	[89247] = 496,	-- Shoulders of the Shadowy Protector,
	[89248] = 496,	-- Shoulders of the Shadowy Vanquisher,
	[89249] = 509,	-- Chest of the Shadowy Vanquisher,
	[89250] = 509,	-- Chest of the Shadowy Conqueror,
	[89251] = 509,	-- Chest of the Shadowy Protector,
	[89252] = 509,	-- Leggings of the Shadowy Vanquisher,
	[89253] = 509,	-- Leggings of the Shadowy Conqueror,
	[89254] = 509,	-- Leggings of the Shadowy Protector,
	[89255] = 509,	-- Gauntlets of the Shadowy Vanquisher,
	[89256] = 509,	-- Gauntlets of the Shadowy Conqueror,
	[89257] = 509,	-- Gauntlets of the Shadowy Protector,
	[89258] = 509,	-- Helm of the Shadowy Vanquisher,
	[89259] = 509,	-- Helm of the Shadowy Conqueror,
	[89260] = 509,	-- Helm of the Shadowy Protector,
	[89261] = 509,	-- Shoulders of the Shadowy Vanquisher,
	[89262] = 509,	-- Shoulders of the Shadowy Conqueror,
	[89263] = 509,	-- Shoulders of the Shadowy Protector,
	[89264] = 483,	-- Chest of the Shadowy Vanquisher,
	[89265] = 483,	-- Chest of the Shadowy Conqueror,
	[89266] = 483,	-- Chest of the Shadowy Protector,
	[89267] = 483,	-- Leggings of the Shadowy Vanquisher,
	[89268] = 483,	-- Leggings of the Shadowy Conqueror,
	[89269] = 483,	-- Leggings of the Shadowy Protector,
	[89270] = 483,	-- Gauntlets of the Shadowy Vanquisher,
	[89271] = 483,	-- Gauntlets of the Shadowy Conqueror,
	[89272] = 483,	-- Gauntlets of the Shadowy Protector,
	[89273] = 483,	-- Helm of the Shadowy Vanquisher,
	[89274] = 483,	-- Helm of the Shadowy Conqueror,
	[89275] = 483,	-- Helm of the Shadowy Protector,
	[89276] = 483,	-- Shoulders of the Shadowy Vanquisher,
	[89277] = 483,	-- Shoulders of the Shadowy Conqueror,
	[89278] = 483,	-- Shoulders of the Shadowy Protector,
	[95569] = 522,	-- Chest of the Crackling Vanquisher,
	[95570] = 522,	-- Gauntlets of the Crackling Vanquisher,
	[95571] = 522,	-- Helm of the Crackling Vanquisher,
	[95572] = 522,	-- Leggings of the Crackling Vanquisher,
	[95573] = 522,	-- Shoulders of the Crackling Vanquisher,
	[95574] = 522,	-- Chest of the Crackling Conqueror,
	[95575] = 522,	-- Gauntlets of the Crackling Conqueror,
	[95576] = 522,	-- Leggings of the Crackling Conqueror,
	[95577] = 522,	-- Helm of the Crackling Conqueror,
	[95578] = 522,	-- Shoulders of the Crackling Conqueror,
	[95579] = 522,	-- Chest of the Crackling Protector,
	[95580] = 522,	-- Gauntlets of the Crackling Protector,
	[95581] = 522,	-- Leggings of the Crackling Protector,
	[95582] = 522,	-- Helm of the Crackling Protector,
	[95583] = 522,	-- Shoulders of the Crackling Protector,
	[95822] = 502,	-- Chest of the Crackling Vanquisher,
	[95823] = 502,	-- Chest of the Crackling Conqueror,
	[95824] = 502,	-- Chest of the Crackling Protector,
	[95855] = 502,	-- Gauntlets of the Crackling Vanquisher,
	[95856] = 502,	-- Gauntlets of the Crackling Conqueror,
	[95857] = 502,	-- Gauntlets of the Crackling Protector,
	[95879] = 502,	-- Helm of the Crackling Vanquisher,
	[95880] = 502,	-- Helm of the Crackling Conqueror,
	[95881] = 502,	-- Helm of the Crackling Protector,
	[95887] = 502,	-- Leggings of the Crackling Vanquisher,
	[95888] = 502,	-- Leggings of the Crackling Conqueror,
	[95889] = 502,	-- Leggings of the Crackling Protector,
	[95955] = 502,	-- Shoulders of the Crackling Vanquisher,
	[95956] = 502,	-- Shoulders of the Crackling Conqueror,
	[95957] = 502,	-- Shoulders of the Crackling Protector,
	[96194] = 528,	-- Chest of the Crackling Vanquisher,
	[96195] = 528,	-- Chest of the Crackling Conqueror,
	[96196] = 528,	-- Chest of the Crackling Protector,
	[96227] = 528,	-- Gauntlets of the Crackling Vanquisher,
	[96228] = 528,	-- Gauntlets of the Crackling Conqueror,
	[96229] = 528,	-- Gauntlets of the Crackling Protector,
	[96251] = 528,	-- Helm of the Crackling Vanquisher,
	[96252] = 528,	-- Helm of the Crackling Conqueror,
	[96253] = 528,	-- Helm of the Crackling Protector,
	[96259] = 528,	-- Leggings of the Crackling Vanquisher,
	[96260] = 528,	-- Leggings of the Crackling Conqueror,
	[96261] = 528,	-- Leggings of the Crackling Protector,
	[96327] = 528,	-- Shoulders of the Crackling Vanquisher,
	[96328] = 528,	-- Shoulders of the Crackling Conqueror,
	[96329] = 528,	-- Shoulders of the Crackling Protector,
	[96566] = 535,	-- Chest of the Crackling Vanquisher,
	[96567] = 535,	-- Chest of the Crackling Conqueror,
	[96568] = 535,	-- Chest of the Crackling Protector,
	[96599] = 535,	-- Gauntlets of the Crackling Vanquisher,
	[96600] = 535,	-- Gauntlets of the Crackling Conqueror,
	[96601] = 535,	-- Gauntlets of the Crackling Protector,
	[96623] = 535,	-- Helm of the Crackling Vanquisher,
	[96624] = 535,	-- Helm of the Crackling Conqueror,
	[96625] = 535,	-- Helm of the Crackling Protector,
	[96631] = 535,	-- Leggings of the Crackling Vanquisher,
	[96632] = 535,	-- Leggings of the Crackling Conqueror,
	[96633] = 535,	-- Leggings of the Crackling Protector,
	[96699] = 535,	-- Shoulders of the Crackling Vanquisher,
	[96700] = 535,	-- Shoulders of the Crackling Conqueror,
	[96701] = 535,	-- Shoulders of the Crackling Protector,
	[96938] = 541,	-- Chest of the Crackling Vanquisher,
	[96939] = 541,	-- Chest of the Crackling Conqueror,
	[96940] = 541,	-- Chest of the Crackling Protector,
	[96971] = 541,	-- Gauntlets of the Crackling Vanquisher,
	[96972] = 541,	-- Gauntlets of the Crackling Conqueror,
	[96973] = 541,	-- Gauntlets of the Crackling Protector,
	[96995] = 541,	-- Helm of the Crackling Vanquisher,
	[96996] = 541,	-- Helm of the Crackling Conqueror,
	[96997] = 541,	-- Helm of the Crackling Protector,
	[97003] = 541,	-- Leggings of the Crackling Vanquisher,
	[97004] = 541,	-- Leggings of the Crackling Conqueror,
	[97005] = 541,	-- Leggings of the Crackling Protector,
	[97071] = 541,	-- Shoulders of the Crackling Vanquisher,
	[97072] = 541,	-- Shoulders of the Crackling Conqueror,
	[97073] = 541,	-- Shoulders of the Crackling Protector,
	[99667] = 528,	-- Gauntlets of the Cursed Protector,
	[99668] = 528,	-- Shoulders of the Cursed Vanquisher,
	[99669] = 528,	-- Shoulders of the Cursed Conqueror,
	[99670] = 528,	-- Shoulders of the Cursed Protector,
	[99671] = 528,	-- Helm of the Cursed Vanquisher,
	[99672] = 528,	-- Helm of the Cursed Conqueror,
	[99673] = 528,	-- Helm of the Cursed Protector,
	[99674] = 528,	-- Leggings of the Cursed Vanquisher,
	[99675] = 528,	-- Leggings of the Cursed Conqueror,
	[99676] = 528,	-- Leggings of the Cursed Protector,
	[99677] = 528,	-- Chest of the Cursed Vanquisher,
	[99678] = 528,	-- Chest of the Cursed Conqueror,
	[99679] = 528,	-- Chest of the Cursed Protector,
	[99680] = 528,	-- Gauntlets of the Cursed Vanquisher,
	[99681] = 528,	-- Gauntlets of the Cursed Conqueror,
	[99682] = 553,	-- Gauntlets of the Cursed Vanquisher,
	[99683] = 553,	-- Helm of the Cursed Vanquisher,
	[99684] = 553,	-- Leggings of the Cursed Vanquisher,
	[99685] = 553,	-- Shoulders of the Cursed Vanquisher,
	[99686] = 553,	-- Chest of the Cursed Conqueror,
	[99687] = 553,	-- Gauntlets of the Cursed Conqueror,
	[99688] = 553,	-- Leggings of the Cursed Conqueror,
	[99689] = 553,	-- Helm of the Cursed Conqueror,
	[99690] = 553,	-- Shoulders of the Cursed Conqueror,
	[99691] = 553,	-- Chest of the Cursed Protector,
	[99692] = 553,	-- Gauntlets of the Cursed Protector,
	[99693] = 553,	-- Leggings of the Cursed Protector,
	[99694] = 553,	-- Helm of the Cursed Protector,
	[99695] = 553,	-- Shoulders of the Cursed Protector,
	[99696] = 553,	-- Chest of the Cursed Vanquisher,
	[99712] = 566,	-- Leggings of the Cursed Conqueror,
	[99713] = 566,	-- Leggings of the Cursed Protector,
	[99714] = 566,	-- Chest of the Cursed Vanquisher,
	[99715] = 566,	-- Chest of the Cursed Conqueror,
	[99716] = 566,	-- Chest of the Cursed Protector,
	[99717] = 566,	-- Shoulders of the Cursed Vanquisher,
	[99718] = 566,	-- Shoulders of the Cursed Conqueror,
	[99719] = 566,	-- Shoulders of the Cursed Protector,
	[99720] = 566,	-- Gauntlets of the Cursed Vanquisher,
	[99721] = 566,	-- Gauntlets of the Cursed Conqueror,
	[99722] = 566,	-- Gauntlets of the Cursed Protector,
	[99723] = 566,	-- Helm of the Cursed Vanquisher,
	[99724] = 566,	-- Helm of the Cursed Conqueror,
	[99725] = 566,	-- Helm of the Cursed Protector,
	[99726] = 566,	-- Leggings of the Cursed Vanquisher,
	[99742] = 540,	-- Chest of the Cursed Vanquisher,
	[99743] = 540,	-- Chest of the Cursed Conqueror,
	[99744] = 540,	-- Chest of the Cursed Protector,
	[99745] = 540,	-- Gauntlets of the Cursed Vanquisher,
	[99746] = 540,	-- Gauntlets of the Cursed Conqueror,
	[99747] = 540,	-- Gauntlets of the Cursed Protector,
	[99748] = 540,	-- Helm of the Cursed Vanquisher,
	[99749] = 540,	-- Helm of the Cursed Conqueror,
	[99750] = 540,	-- Helm of the Cursed Protector,
	[99751] = 540,	-- Leggings of the Cursed Vanquisher,
	[99752] = 540,	-- Leggings of the Cursed Conqueror,
	[99753] = 540,	-- Leggings of the Cursed Protector,
	[99754] = 540,	-- Shoulders of the Cursed Vanquisher,
	[99755] = 540,	-- Shoulders of the Cursed Conqueror,
	[99756] = 540,	-- Shoulders of the Cursed Protector,
	[105857] = 553,	-- Essence of the Cursed Protector,
	[105858] = 553,	-- Essence of the Cursed Conqueror,
	[105859] = 553,	-- Essence of the Cursed Vanquisher,
	[105860] = 528,	-- Essence of the Cursed Protector,
	[105861] = 528,	-- Essence of the Cursed Conqueror,
	[105862] = 528,	-- Essence of the Cursed Vanquisher,
	[105863] = 540,	-- Essence of the Cursed Protector,
	[105864] = 540,	-- Essence of the Cursed Conqueror,
	[105865] = 540,	-- Essence of the Cursed Vanquisher,
	[105866] = 566,	-- Essence of the Cursed Protector,
	[105867] = 566,	-- Essence of the Cursed Conqueror,
	[105868] = 566,	-- Essence of the Cursed Vanquisher,
--]]

	-- Tier 17 Blackrock Foundry
	-- Since then, token bonus id determines whether +0, +15, +30 ilvl
	-- Essence is commented out because that's the exception.
	[119305] = 670,	-- Chest of the Iron Conqueror,
	[119306] = 670,	-- Gauntlets of the Iron Conqueror,
	[119307] = 670,	-- Leggings of the Iron Conqueror,
	[119308] = 670,	-- Helm of the Iron Conqueror,
	[119309] = 670,	-- Shoulders of the Iron Conqueror,
	--[119310] = 670,	-- Essence of the Iron Conqueror,
	[119311] = 670,	-- Gauntlets of the Iron Vanquisher,
	[119312] = 670,	-- Helm of the Iron Vanquisher,
	[119313] = 670,	-- Leggings of the Iron Vanquisher,
	[119314] = 670,	-- Shoulders of the Iron Vanquisher,
	[119315] = 670,	-- Chest of the Iron Vanquisher,
	--[119316] = 670,	-- Essence of the Iron Vanquisher,
	[119318] = 670,	-- Chest of the Iron Protector,
	[119319] = 670,	-- Gauntlets of the Iron Protector,
	[119320] = 670,	-- Leggings of the Iron Protector,
	[119321] = 670,	-- Helm of the Iron Protector,
	[119322] = 670,	-- Shoulders of the Iron Protector,
	--[119323] = 670,	-- Essence of the Iron Protector,
	--[120206] = 685,	-- Essence of the Iron Conqueror,
	--[120207] = 685,	-- Essence of the Iron Protector,
	--[120208] = 685,	-- Essence of the Iron Vanquisher,
	--[120209] = 700,	-- Essence of the Iron Conqueror,
	--[120210] = 700,	-- Essence of the Iron Protector,
	--[120211] = 700,	-- Essence of the Iron Vanquisher,
	[120212] = 670,	-- Chest of the Iron Conqueror,
	[120213] = 670,	-- Gauntlets of the Iron Conqueror,
	[120214] = 670,	-- Leggings of the Iron Conqueror,
	[120215] = 670,	-- Helm of the Iron Conqueror,
	[120216] = 670,	-- Shoulders of the Iron Conqueror,
	[120217] = 670,	-- Gauntlets of the Iron Vanquisher,
	[120218] = 670,	-- Helm of the Iron Vanquisher,
	[120219] = 670,	-- Leggings of the Iron Vanquisher,
	[120220] = 670,	-- Shoulders of the Iron Vanquisher,
	[120221] = 670,	-- Chest of the Iron Vanquisher,
	[120222] = 670,	-- Chest of the Iron Protector,
	[120223] = 670,	-- Gauntlets of the Iron Protector,
	[120224] = 670,	-- Leggings of the Iron Protector,
	[120225] = 670,	-- Helm of the Iron Protector,
	[120226] = 670,	-- Shoulders of the Iron Protector,
	[120227] = 670,	-- Chest of the Iron Conqueror,
	[120228] = 670,	-- Gauntlets of the Iron Conqueror,
	[120229] = 670,	-- Leggings of the Iron Conqueror,
	[120230] = 670,	-- Helm of the Iron Conqueror,
	[120231] = 670,	-- Shoulders of the Iron Conqueror,
	[120232] = 670,	-- Gauntlets of the Iron Vanquisher,
	[120233] = 670,	-- Helm of the Iron Vanquisher,
	[120234] = 670,	-- Leggings of the Iron Vanquisher,
	[120235] = 670,	-- Shoulders of the Iron Vanquisher,
	[120236] = 670,	-- Chest of the Iron Vanquisher,
	[120237] = 670,	-- Chest of the Iron Protector,
	[120238] = 670,	-- Gauntlets of the Iron Protector,
	[120239] = 670,	-- Leggings of the Iron Protector,
	[120240] = 670,	-- Helm of the Iron Protector,
	[120241] = 670,	-- Shoulders of the Iron Protector,
	[120242] = 670,	-- Chest of the Iron Conqueror,
	[120243] = 670,	-- Gauntlets of the Iron Conqueror,
	[120244] = 670,	-- Leggings of the Iron Conqueror,
	[120245] = 670,	-- Helm of the Iron Conqueror,
	[120246] = 670,	-- Shoulders of the Iron Conqueror,
	[120247] = 670,	-- Gauntlets of the Iron Vanquisher,
	[120248] = 670,	-- Helm of the Iron Vanquisher,
	[120249] = 670,	-- Leggings of the Iron Vanquisher,
	[120250] = 670,	-- Shoulders of the Iron Vanquisher,
	[120251] = 670,	-- Chest of the Iron Vanquisher,
	[120252] = 670,	-- Chest of the Iron Protector,
	[120253] = 670,	-- Gauntlets of the Iron Protector,
	[120254] = 670,	-- Leggings of the Iron Protector,
	[120255] = 670,	-- Helm of the Iron Protector,
	[120256] = 670,	-- Shoulders of the Iron Protector,
	--[120277] = 670,	-- Essence of the Iron Conqueror,
	--[120278] = 670,	-- Essence of the Iron Vanquisher,
	--[120279] = 670,	-- Essence of the Iron Protector,
	--[120280] = 685,	-- Essence of the Iron Conqueror,
	--[120281] = 685,	-- Essence of the Iron Protector,
	--[120282] = 685,	-- Essence of the Iron Vanquisher,
	--[120283] = 700,	-- Essence of the Iron Conqueror,
	--[120284] = 700,	-- Essence of the Iron Protector,
	--[120285] = 700,	-- Essence of the Iron Vanquisher,

	-- Tier 18 Hellfire Citadel
	[127953] = 695,	-- Chest of Hellfire's Conqueror,
	[127954] = 695,	-- Gauntlets of Hellfire's Conqueror,
	[127955] = 695,	-- Leggings of Hellfire's Conqueror,
	[127956] = 695,	-- Helm of Hellfire's Conqueror,
	[127957] = 695,	-- Shoulders of Hellfire's Conqueror,
	[127958] = 695,	-- Gauntlets of Hellfire's Vanquisher,
	[127959] = 695,	-- Helm of Hellfire's Vanquisher,
	[127960] = 695,	-- Leggings of Hellfire's Vanquisher,
	[127961] = 695,	-- Shoulders of Hellfire's Vanquisher,
	[127962] = 695,	-- Chest of Hellfire's Vanquisher,
	[127963] = 695,	-- Chest of Hellfire's Protector,
	[127964] = 695,	-- Gauntlets of Hellfire's Protector,
	[127965] = 695,	-- Leggings of Hellfire's Protector,
	[127966] = 695,	-- Helm of Hellfire's Protector,
	[127967] = 695,	-- Shoulders of Hellfire's Protector,
	[127968] = 695,	-- Badge of Hellfire's Vanquisher,
	[127969] = 695,	-- Badge of Hellfire's Conqueror,
	[127970] = 695,	-- Badge of Hellfire's Protector,

	-- Tier 19 The Nighthold
	[143562] = 875,	-- Chest of the Foreseen Conqueror,
	[143563] = 875,	-- Gauntlets of the Foreseen Conqueror,
	[143564] = 875,	-- Leggings of the Foreseen Conqueror,
	[143565] = 875,	-- Helm of the Foreseen Conqueror,
	[143566] = 875,	-- Shoulders of the Foreseen Conqueror,
	[143567] = 875,	-- Gauntlets of the Foreseen Vanquisher,
	[143568] = 875,	-- Helm of the Foreseen Vanquisher,
	[143569] = 875,	-- Leggings of the Foreseen Vanquisher,
	[143570] = 875,	-- Shoulders of the Foreseen Vanquisher,
	[143571] = 875,	-- Chest of the Foreseen Vanquisher,
	[143572] = 875,	-- Chest of the Foreseen Protector,
	[143573] = 875,	-- Gauntlets of the Foreseen Protector,
	[143574] = 875,	-- Leggings of the Foreseen Protector,
	[143575] = 875,	-- Helm of the Foreseen Protector,
	[143576] = 875,	-- Shoulders of the Foreseen Protector,
	[143577] = 875,	-- Cloak of the Foreseen Conqueror,
	[143578] = 875,	-- Cloak of the Foreseen Vanquisher,
	[143579] = 875,	-- Cloak of the Foreseen Protector,

	-- Tier 20 Tomb of Sargeras
	[147316] = 900,	-- Chest of the Foregone Vanquisher,
	[147317] = 900,	-- Chest of the Foregone Conqueror,
	[147318] = 900,	-- Chest of the Foregone Protector,
	[147319] = 900,	-- Gauntlets of the Foregone Vanquisher,
	[147320] = 900,	-- Gauntlets of the Foregone Conqueror,
	[147321] = 900,	-- Gauntlets of the Foregone Protector,
	[147322] = 900,	-- Helm of the Foregone Vanquisher,
	[147323] = 900,	-- Helm of the Foregone Conqueror,
	[147324] = 900,	-- Helm of the Foregone Protector,
	[147325] = 900,	-- Leggings of the Foregone Vanquisher,
	[147326] = 900,	-- Leggings of the Foregone Conqueror,
	[147327] = 900,	-- Leggings of the Foregone Protector,
	[147328] = 900,	-- Shoulders of the Foregone Vanquisher,
	[147329] = 900,	-- Shoulders of the Foregone Conqueror,
	[147330] = 900,	-- Shoulders of the Foregone Protector,
	[147331] = 900,	-- Cloak of the Foregone Vanquisher,
	[147332] = 900,	-- Cloak of the Foregone Conqueror,
	[147333] = 900,	-- Cloak of the Foregone Protector,

	-- Tier 21 Antorus, the Burning Throne
	[152515] = 930,	-- Cloak of the Antoran Protector,
	[152516] = 930,	-- Cloak of the Antoran Conqueror,
	[152517] = 930,	-- Cloak of the Antoran Vanquisher,
	[152518] = 930,	-- Chest of the Antoran Vanquisher,
	[152519] = 930,	-- Chest of the Antoran Conqueror,
	[152520] = 930,	-- Chest of the Antoran Protector,
	[152521] = 930,	-- Gauntlets of the Antoran Vanquisher,
	[152522] = 930,	-- Gauntlets of the Antoran Conqueror,
	[152523] = 930,	-- Gauntlets of the Antoran Protector,
	[152524] = 930,	-- Helm of the Antoran Vanquisher,
	[152525] = 930,	-- Helm of the Antoran Conqueror,
	[152526] = 930,	-- Helm of the Antoran Protector,
	[152527] = 930,	-- Leggings of the Antoran Vanquisher,
	[152528] = 930,	-- Leggings of the Antoran Conqueror,
	[152529] = 930,	-- Leggings of the Antoran Protector,
	[152530] = 930,	-- Shoulders of the Antoran Vanquisher,
	[152531] = 930,	-- Shoulders of the Antoran Conqueror,
	[152532] = 930,	-- Shoulders of the Antoran Protector,
}

-- DEPRECATED. This data is generated by RC:GetItemClassesAllowedFlag() now.
-- Only Use this table in RC:PrepareLootTable for backward compatibility purpose.
-- Classes that can use the token
_G.RCTokenClasses = {
	--[xxxxxx] = {classes that can use the token},

	-- TIER 21 Antorus, the Burning Throne
	[152515] = {"WARRIOR", "HUNTER", "SHAMAN", "MONK"},
	[152516] = {"PALADIN", "PRIEST", "WARLOCK", "DEMONHUNTER"},
	[152517] = {"ROGUE", "DEATHKNIGHT", "MAGE", "DRUID"},

	[152518] = {"ROGUE", "DEATHKNIGHT", "MAGE", "DRUID"},
	[152519] = {"PALADIN", "PRIEST", "WARLOCK", "DEMONHUNTER"},
	[152520] = {"WARRIOR", "HUNTER", "SHAMAN", "MONK"},

	[152521] = {"ROGUE", "DEATHKNIGHT", "MAGE", "DRUID"},
	[152522] = {"PALADIN", "PRIEST", "WARLOCK", "DEMONHUNTER"},
	[152523] = {"WARRIOR", "HUNTER", "SHAMAN", "MONK"},

	[152524] = {"ROGUE", "DEATHKNIGHT", "MAGE", "DRUID"},
	[152525] = {"PALADIN", "PRIEST", "WARLOCK", "DEMONHUNTER"},
	[152526] = {"WARRIOR", "HUNTER", "SHAMAN", "MONK"},

	[152527] = {"ROGUE", "DEATHKNIGHT", "MAGE", "DRUID"},
	[152528] = {"PALADIN", "PRIEST", "WARLOCK", "DEMONHUNTER"},
	[152529] = {"WARRIOR", "HUNTER", "SHAMAN", "MONK"},

	[152530] = {"ROGUE", "DEATHKNIGHT", "MAGE", "DRUID"},
	[152531] = {"PALADIN", "PRIEST", "WARLOCK", "DEMONHUNTER"},
	[152532] = {"WARRIOR", "HUNTER", "SHAMAN", "MONK"},

	-- TIER 20 Tomb of Sargeras
	[147316] = {"ROGUE", "DEATHKNIGHT", "MAGE", "DRUID"},
	[147317] = {"PALADIN", "PRIEST", "WARLOCK", "DEMONHUNTER"},
	[147318] = {"WARRIOR", "HUNTER", "SHAMAN", "MONK"},

	[147319] = {"ROGUE", "DEATHKNIGHT", "MAGE", "DRUID"},
	[147320] = {"PALADIN", "PRIEST", "WARLOCK", "DEMONHUNTER"},
	[147321] = {"WARRIOR", "HUNTER", "SHAMAN", "MONK"},

	[147322] = {"ROGUE", "DEATHKNIGHT", "MAGE", "DRUID"},
	[147323] = {"PALADIN", "PRIEST", "WARLOCK", "DEMONHUNTER"},
	[147324] = {"WARRIOR", "HUNTER", "SHAMAN", "MONK"},

	[147325] = {"ROGUE", "DEATHKNIGHT", "MAGE", "DRUID"},
	[147326] = {"PALADIN", "PRIEST", "WARLOCK", "DEMONHUNTER"},
	[147327] = {"WARRIOR", "HUNTER", "SHAMAN", "MONK"},

	[147328] = {"ROGUE", "DEATHKNIGHT", "MAGE", "DRUID"},
	[147329] = {"PALADIN", "PRIEST", "WARLOCK", "DEMONHUNTER"},
	[147330] = {"WARRIOR", "HUNTER", "SHAMAN", "MONK"},

	[147331] = {"ROGUE", "DEATHKNIGHT", "MAGE", "DRUID"},
	[147332] = {"PALADIN", "PRIEST", "WARLOCK", "DEMONHUNTER"},
	[147333] = {"WARRIOR", "HUNTER", "SHAMAN", "MONK"},

	-- TIER 19 The Nighthold
	[143562] = {"PALADIN", "PRIEST", "WARLOCK", "DEMONHUNTER"},
	[143572] = {"WARRIOR", "HUNTER", "SHAMAN", "MONK"},
	[143571] = {"ROGUE", "DEATHKNIGHT", "MAGE", "DRUID"},

	[143577] = {"PALADIN", "PRIEST", "WARLOCK", "DEMONHUNTER"},
	[143579] = {"WARRIOR", "HUNTER", "SHAMAN", "MONK"},
	[143578] = {"ROGUE", "DEATHKNIGHT", "MAGE", "DRUID"},

	[143563] = {"PALADIN", "PRIEST", "WARLOCK", "DEMONHUNTER"},
	[143573] = {"WARRIOR", "HUNTER", "SHAMAN", "MONK"},
	[143567] = {"ROGUE", "DEATHKNIGHT", "MAGE", "DRUID"},

	[143565] = {"PALADIN", "PRIEST", "WARLOCK", "DEMONHUNTER"},
	[143575] = {"WARRIOR", "HUNTER", "SHAMAN", "MONK"},
	[143568] = {"ROGUE", "DEATHKNIGHT", "MAGE", "DRUID"},

	[143564] = {"PALADIN", "PRIEST", "WARLOCK", "DEMONHUNTER"},
	[143574] = {"WARRIOR", "HUNTER", "SHAMAN", "MONK"},
	[143569] = {"ROGUE", "DEATHKNIGHT", "MAGE", "DRUID"},

	[143566] = {"PALADIN", "PRIEST", "WARLOCK", "DEMONHUNTER"},
	[143576] = {"WARRIOR", "HUNTER", "SHAMAN", "MONK"},
	[143570] = {"ROGUE", "DEATHKNIGHT", "MAGE", "DRUID"},

	-- TIER 18	Hellfire Citadel
	[127953] = {"PALADIN", "PRIEST", "WARLOCK", "DEMONHUNTER"},
	[127962] = {"ROGUE", "DEATHKNIGHT", "MAGE", "DRUID"},
	[127963] = {"WARRIOR", "HUNTER", "SHAMAN", "MONK"},

	[127955] = {"PALADIN", "PRIEST", "WARLOCK", "DEMONHUNTER"},
	[127960] = {"ROGUE", "DEATHKNIGHT", "MAGE", "DRUID"},
	[127965] = {"WARRIOR", "HUNTER", "SHAMAN", "MONK"},

	[127956] = {"PALADIN", "PRIEST", "WARLOCK", "DEMONHUNTER"},
	[127959] = {"ROGUE", "DEATHKNIGHT", "MAGE", "DRUID"},
	[127966] = {"WARRIOR", "HUNTER", "SHAMAN", "MONK"},

	[127957] = {"PALADIN", "PRIEST", "WARLOCK", "DEMONHUNTER"},
	[127961] = {"ROGUE", "DEATHKNIGHT", "MAGE", "DRUID"},
	[127967] = {"WARRIOR", "HUNTER", "SHAMAN", "MONK"},

	[127954] = {"PALADIN", "PRIEST", "WARLOCK", "DEMONHUNTER"},
	[127958] = {"ROGUE", "DEATHKNIGHT", "MAGE", "DRUID"},
	[127964] = {"WARRIOR", "HUNTER", "SHAMAN", "MONK"},

	[127968] = {"ROGUE", "DEATHKNIGHT", "MAGE", "DRUID"},
	[127969] = {"PALADIN", "PRIEST", "WARLOCK", "DEMONHUNTER"},
	[127970] = {"WARRIOR", "HUNTER", "SHAMAN", "MONK"},
}
