local enabled
local spec = {}
local icons = {}
local classes = {}
local f = CreateFrame("Frame")
local frames_to_update = {}
local apply_alpha
local in_bg
local _G = _G
local mouse_look = false
local UnitUsingVehicle = UnitUsingVehicle
local GetUnitName = GetUnitName
local GetBattlefieldScore = GetBattlefieldScore
local GetNumBattlefieldScores = GetNumBattlefieldScores
local RequestBattlefieldScoreData = RequestBattlefieldScoreData
local UnitInRange = UnitInRange


for classID=1,MAX_CLASSES do
	local _,classTag = GetClassInfoByID(classID)
	local numTabs = GetNumSpecializationsForClassID(classID)
	classes[classTag] = {}
	for i=1,numTabs do
		local _,spec_name,_,spec_icon = GetSpecializationInfoForClassID(classID,i)
		classes[classTag][spec_name] = spec_icon
	end
end

local function fix_alpha(frame)
	if not enabled then return end
	if in_bg and frame.displayedUnit then
		local inRange,checkedRange = UnitInRange(frame.displayedUnit)
		if checkedRange and not inRange then
			if apply_alpha then
				frame:SetAlpha(0.25)
			else
				frame:SetAlpha(1)
			end
		else
			frame:SetAlpha(1)
		end
	end
end

local function fix_right_click(raid_frame_index)
	local function fix_one_frame(frame)
		if mouse_look then
			frame:RegisterForClicks("AnyDown","AnyUp")
			frame:SetAttribute("*type2","macro")
			frame:SetAttribute("macrotext2","/run MouselookStart()")
		else
			frame:SetAttribute("macrotext2",nil)
			frame:SetAttribute("*type2","menu")
			frame:RegisterForClicks("LeftButtonDown","RightButtonUp");
		end
	end
	local frame = _G["CompactRaidFrame"..raid_frame_index]
	if frame then
		fix_one_frame(frame)
		for i=1,3 do
			fix_one_frame(_G["CompactRaidFrame"..raid_frame_index.."Buff"..i])
			fix_one_frame(_G["CompactRaidFrame"..raid_frame_index.."Debuff"..i])
		end
		fix_one_frame(_G["CompactRaidFrame"..raid_frame_index.."CenterStatusIcon"])
	end
end

hooksecurefunc("CompactUnitFrame_UpdateInRange",fix_alpha)

hooksecurefunc("CompactUnitFrame_UpdateName",function(frame)
	if frame and not frame:IsForbidden() then
		local frame_name = frame:GetName()
		if frame_name and frame_name:match("^CompactRaidFrame%d") and frame.unit and frame.name then
			local unit_name = GetUnitName(frame.unit,true)
			if unit_name then
				frame.name:SetText(unit_name:match("[^-]+"))
				if not frames_to_update[frame] then
					frames_to_update[frame] = true
				end
			end
		end
	end
end)

f:SetScript("OnEvent",function(self,event,...)
	if event=="PLAYER_ENTERING_WORLD" then
		wipe(icons)
		wipe(spec)
		mouse_look = false
		local _,_,_,_,_,_,_,instanceMapID = GetInstanceInfo()
		local in_instance,instance_type = IsInInstance()
		if instance_type=="pvp" then
			in_bg = true
			local bg_time = GetBattlefieldInstanceRunTime()/1000
			if bg_time>120 then
				mouse_look = true
			else
				C_Timer.After(120-bg_time,function()
					if not InCombatLockdown() then
						mouse_look = true
						for i=1,40 do
							fix_right_click(i)
						end
					end
				end)
			end
		else
			in_bg = false
		end
		apply_alpha = in_instance or instanceMapID==1191 or IsInActiveWorldPVP()
	elseif event=="GROUP_ROSTER_UPDATE" then
		if GetNumGroupMembers()<=10 then
			enabled = true
		else
			enabled = false
		end
		if not InCombatLockdown() then
			if not IsInGroup() then
				wipe(icons)
				wipe(spec)
			end
			for k,v in pairs(frames_to_update) do
				if not k:IsShown() then
					frames_to_update[k] = nil
				end
			end
			for i=1,40 do
				fix_right_click(i)
			end
		end
	elseif event=="PLAYER_REGEN_ENABLED" then
		for i=1,40 do
			fix_right_click(i)
		end
	end
end)
f:RegisterEvent("PLAYER_ENTERING_WORLD")
f:RegisterEvent("GROUP_ROSTER_UPDATE")
f:RegisterEvent("PLAYER_REGEN_ENABLED")

f:SetScript("OnUpdate",function(self,elapsed)
	self.timer = self.timer and self.timer+elapsed or 0
	if self.timer>0.5 then
		self.timer = 0
		RequestBattlefieldScoreData()
		for index=1,GetNumBattlefieldScores() do
			local name,_,_,_,_,faction,_,_,classToken,_,_,_,_,_,_,talentSpec = GetBattlefieldScore(index)
			if classToken then
				icons[name] = classes[classToken][talentSpec]
				spec[name] = talentSpec
			end
		end
		for k,v in pairs(frames_to_update) do
			if not k:IsShown() then
				frames_to_update[k] = nil
			else
				fix_alpha(k)
				local texture = icons[GetUnitName(k.unit,true)]
				if texture and k.roleIcon then
					if not UnitUsingVehicle(k.unit) then
						k.roleIcon:SetTexture(texture)
					else
						k.roleIcon:SetTexture("Interface\\Icons\\trade_engineering")
					end
					k.roleIcon:SetTexCoord(0,1,0,1)
					k.roleIcon:SetSize(16,16)
					k.roleIcon:Show()
				end
			end
		end
	end
end)

hooksecurefunc(GameTooltip,"SetUnit",function(self,unit)
	if unit then
		local f = GetMouseFocus()
		if f then
		local name = f:GetName()
			if name and name:match("^CompactRaidFrame%d") then
				local unit_name = GetUnitName(unit,true)
				if unit_name then
					local spec_name = spec[unit_name]
					if spec_name then
						GameTooltip:AddLine(spec_name,1,1,1)
						GameTooltip:Show()
					end
				end
			end
		end
	end
end)