
-- BigDebuffs by Jordon

LoadAddOn("Blizzard_CompactRaidFrames")

-- Debuffs to make bigger, higher numbers take precedence regardless of duration
local dispel_type_list = {"DRUID","MAGE","MONK","PALADIN","PRIEST","SHAMAN"}
dispel_type_list["DRUID"] = {["Curse"] = true, ["Poison"] = true}
dispel_type_list["MAGE"] = {["Curse"] = true}
dispel_type_list["MONK"] = {["Disease"] = true, ["Poison"] = true}
dispel_type_list["PALADIN"] = {["Disease"] = true, ["Poison"] = true}
dispel_type_list["PRIEST"] = {["Disease"] = true}
dispel_type_list["SHAMAN"] = {["Curse"] = true}


local DispelList = {
	[33786]  = 90, -- Cyclone
	[605]    = 70, -- Dominate Mind (Mind Control)
	[88611]  = 60, -- Smoke Bomb --was 76577
	[44572]  = 50, -- Deep Freeze
	[163505] = 30, -- Rake
	[115001] = 30, -- Remorseless Winter
	[108194] = 30, -- Asphyxiate
	[91800]  = 30, -- Gnaw
	[91797]  = 30, -- Monstrous Blow
	[5211]   = 30, -- Mighty Bash
	[22570]  = 30, -- Maim
	[99]     = 30, -- Disorienting Roar
	[24394]  = 30, -- Intimidation
	[119392] = 30, -- Charging Ox Wave
	[119381] = 30, -- Leg Sweep
	[179057] = 30, -- Chaos Nova
	[226943] = 30, -- Mind Bomb
	[120086] = 30, -- Fists of Fury
	[115078] = 30, -- Paralysis
	[5246]   = 30, -- Initmidating Shout
	[6770]   = 30, -- Sap
	[408]    = 30, -- Kidney Shot
	[2094]   = 30, -- Blind
	[1833]   = 30, -- Cheap Shot
	[1776]   = 30, -- Gouge
	[77505]  = 30, -- Earthquake
	[22703]  = 30, -- Infernal Awakening
	[132168] = 30, -- Shockwave
	[107570] = 30, -- Storm Bolt
	[20549]  = 30, -- War Stomp
	[107079] = 30, -- Quaking Palm
	[111397] = 30, -- Blood Horror
	[47476]  = 20, -- Strangulate
	[19386]  = 20, -- Wyvern Sting
	[3355]   = 20, -- Freezing Trap
	[117526] = 20, -- Binding Shot
	[118]    = 20, -- Polymorph
	[61305]  = 20, -- Polymorph Black Cat
	[28272]  = 20, -- Polymorph Pig
	[61721]  = 20, -- Polymorph Rabbit
	[61780]  = 20, -- Polymorph Turkey
	[28271]  = 20, -- Polymorph Turtle
	[82691]  = 20, -- Ring of Frost
	[31661]  = 20, -- Dragon's Breath
	[102051] = 20, -- Frostjaw
	[853]    = 20, -- Hammer of Justice
	[105593] = 20, -- Fist of Justice
	[217832] = 20, -- Imprison
	[10326]  = 20, -- Turn Evil
	[20066]  = 20, -- Repentance
	[119072] = 20, -- Holy Wrath
	[31935]  = 20, -- Avengers Shield
	[105421] = 20, -- Blinding Light
	[8122]   = 20, -- Psychic Scream
	[9484]   = 20, -- Shackle Undead
	[15487]  = 20, -- Silence
	[31117]  = 20, -- Unstable Affliction (Silence)
	[64044]  = 20, -- Psychic Horror
	[131556] = 20, -- Sin and Punishment
	[51514]  = 20, -- Hex
	[118905] = 20, -- Static Charge (Capacitor Totem)
	[118699] = 20, -- Fear
	[130616] = 20, -- Fear (Glyph of Fear)
	[5484]   = 20, -- Howl of Terror
	[30283]  = 20, -- Shadowfury
	[6358]   = 20, -- Seduction
	[115268] = 20, -- Mesmerize
	[6789]   = 20, -- Mortal Coil
	[710]    = 20, -- Banish
	[129597] = 20, -- Arcane Torrent
	[122]    = 20, -- Frost Nova
	[33395]  = 20, -- Freeze (Water Elemental)
	[339]    = 20, -- Entangling Roots
	[102359] = 20, -- Mass Entanglement
	[63685]  = 20, -- Frozen Power
	[64695]  = 20, -- Earthgrab Totem
	[2944]   = 10, -- Devouring Plague
	[78675]  = 10, -- Solar Beam
	[114866] = 10, -- Soul Reaper
	[130736] = 10, -- Soul Reaper
	[130735] = 10, -- Soul Reaper
}

local MAX_BIG_DEBUFFS = 2

-- Make sure we always see these debuffs, but don't make them bigger
local PriorityDebuffs = {
	30108, -- Unstable Affliction
	34914, -- Vampiric Touch
	770,   -- Faerie Fire
}

-- Show these when a big debuff is displayed
local AdditionalDebuffs = {
	--76577, -- Smoke Bomb
	30108, -- Unstable Affliction
	34914, -- Vampiric Touch
}

local BigDebuffs = CreateFrame("Frame")
BigDebuffs:SetScript("OnEvent", function(self, event, ...) self[event](self, ...) end)

local function AddBigDebuffs(frame)
	if not frame or frame:IsForbidden() or not frame.displayedUnit or not UnitIsPlayer(frame.displayedUnit) then return end
	local baseSize = frame:GetHeight() * 0.6
	frame.BigDebuffs = frame.BigDebuffs or {}
	for i = 1, MAX_BIG_DEBUFFS do
		local big = frame.BigDebuffs[i] or CreateFrame("Button", nil, frame, "CompactDebuffTemplate")
		big:ClearAllPoints()
		big.baseSize = baseSize
		if i > 1 then
			big:SetPoint("BOTTOMLEFT", frame.BigDebuffs[i-1], "BOTTOMRIGHT", 0, 0)
		else
			big:SetPoint("BOTTOMLEFT", frame, "BOTTOMLEFT", 2, 2)
		end
		big.cooldown:SetDrawEdge(false)
		big:SetFrameStrata("MEDIUM")
		frame.BigDebuffs[i] = big
	end
	return true
end

local pending = {}

hooksecurefunc("CompactUnitFrame_UpdateAll", function(frame)
	if InCombatLockdown() then
		if not pending[frame] then pending[frame] = true end
	else
		AddBigDebuffs(frame)
	end
end)

BigDebuffs:RegisterEvent("PLAYER_REGEN_ENABLED")
function BigDebuffs:PLAYER_REGEN_ENABLED()
	for frame,_ in pairs(pending) do
		AddBigDebuffs(frame)
		pending[frame] = nil
	end
end

local function IsPriorityDebuff(id)
	for i = 1, #PriorityDebuffs do
		if id == PriorityDebuffs[i] then
			return true
		end
	end
end

local function HideBigDebuffs(frame)
	if not frame.BigDebuffs then return end
	for i = 1, MAX_BIG_DEBUFFS do
		frame.BigDebuffs[i]:Hide()
	end
end

hooksecurefunc("CompactUnitFrame_HideAllDebuffs", HideBigDebuffs)

local player_class

local function ShowBigDebuffs(frame)
	if not frame.BigDebuffs then return end

	player_class = player_class or select(2,UnitClass("player"))
	
	if not UnitIsPlayer(frame.displayedUnit) then
		return
	end	

	HideBigDebuffs(frame)

	local offset, duration, priority, debuff = 1, 0, 0
	for i = 1, 40 do
		local _,_,_,_,dispel_type,_, time, _,_,_, id = UnitDebuff(frame.displayedUnit, i)
		if id then
			local p = DispelList[id]
			if frame.debuffFrames and p and p >= priority and (dispel_type=="Magic" or (dispel_type_list[player_class] and dispel_type_list[player_class][dispel_type]) or not frame.optionTable.displayOnlyDispellableDebuffs) then
				local now = GetTime()
				if not time or time - now > duration then
					duration = time - now
					debuff = i
					priority = p
				end
			end
		end
		
	end

	if debuff then

		CompactUnitFrame_HideAllDebuffs(frame)

		for i = 1, 40 do
			local id = select(11, UnitDebuff(frame.displayedUnit, i))
			if id then
				for j = 1, #AdditionalDebuffs do
					if id == AdditionalDebuffs[j] then
						CompactUnitFrame_UtilSetDebuff(frame.BigDebuffs[offset], frame.displayedUnit, i, nil, false, false)
						frame.BigDebuffs[offset].cooldown:SetSwipeColor(0, 0, 0, 0.7)
						offset = offset + 1
						break
					end
				end
			end
			if offset == MAX_BIG_DEBUFFS then
				break
			end
		end

		CompactUnitFrame_UtilSetDebuff(frame.BigDebuffs[offset], frame.displayedUnit, debuff, nil, false, false)
		frame.BigDebuffs[offset].cooldown:SetSwipeColor(0, 0, 0, 0.7)
	end

end

-- We need to copy the entire function to avoid taint
hooksecurefunc("CompactUnitFrame_UpdateDebuffs", function(frame)
	if ( not frame.optionTable.displayDebuffs ) then
		CompactUnitFrame_HideAllDebuffs(frame);
		return;
	end
	
	local index = 1;
	local frameNum = 1;
	local filter = nil;
	local maxDebuffs = frame.maxDebuffs;
	--Show both Boss buffs & debuffs in the debuff location
	--First, we go through all the debuffs looking for any boss flagged ones.
	while ( frameNum <= maxDebuffs ) do
		local debuffName = UnitDebuff(frame.displayedUnit, index, filter);
		if ( debuffName ) then
			if ( CompactUnitFrame_UtilIsBossAura(frame.displayedUnit, index, filter, false) ) then
				local debuffFrame = frame.debuffFrames[frameNum];
				CompactUnitFrame_UtilSetDebuff(debuffFrame, frame.displayedUnit, index, filter, true, false);
				frameNum = frameNum + 1;
				--Boss debuffs are about twice as big as normal debuffs, so display one less.
				local bossDebuffScale = (debuffFrame.baseSize + BOSS_DEBUFF_SIZE_INCREASE)/debuffFrame.baseSize
				maxDebuffs = maxDebuffs - (bossDebuffScale - 1);
			end
		else
			break;
		end
		index = index + 1;
	end
	--Then we go through all the buffs looking for any boss flagged ones.
	index = 1;
	while ( frameNum <= maxDebuffs ) do
		local debuffName = UnitBuff(frame.displayedUnit, index, filter);
		if ( debuffName ) then
			if ( CompactUnitFrame_UtilIsBossAura(frame.displayedUnit, index, filter, true) ) then
				local debuffFrame = frame.debuffFrames[frameNum];
				CompactUnitFrame_UtilSetDebuff(debuffFrame, frame.displayedUnit, index, filter, true, true);
				frameNum = frameNum + 1;
				--Boss debuffs are about twice as big as normal debuffs, so display one less.
				local bossDebuffScale = (debuffFrame.baseSize + BOSS_DEBUFF_SIZE_INCREASE)/debuffFrame.baseSize
				maxDebuffs = maxDebuffs - (bossDebuffScale - 1);
			end
		else
			break;
		end
		index = index + 1;
	end
	
	--Now we go through the debuffs with a priority (e.g. Weakened Soul and Forbearance)
	index = 1;
	while ( frameNum <= maxDebuffs ) do
		local debuffName, _,_,_,_,_,_,_,_,_, id = UnitDebuff(frame.displayedUnit, index, filter);
		if ( debuffName ) then
			if ( CompactUnitFrame_UtilIsPriorityDebuff(frame.displayedUnit, index, filter) or IsPriorityDebuff(id)) then
				local debuffFrame = frame.debuffFrames[frameNum];
				CompactUnitFrame_UtilSetDebuff(debuffFrame, frame.displayedUnit, index, filter, false, false);
				frameNum = frameNum + 1;
			end
		else
			break;
		end
		index = index + 1;
	end
	
	if ( frame.optionTable.displayOnlyDispellableDebuffs ) then
		filter = "RAID";
	end
	
	index = 1;
	--Now, we display all normal debuffs.
	if ( frame.optionTable.displayNonBossDebuffs ) then
	while ( frameNum <= maxDebuffs ) do
		local debuffName, _,_,_,_,_,_,_,_,_, id = UnitDebuff(frame.displayedUnit, index, filter);
		if ( debuffName ) then
			if ( CompactUnitFrame_UtilShouldDisplayDebuff(frame.displayedUnit, index, filter) and not CompactUnitFrame_UtilIsBossAura(frame.displayedUnit, index, filter, false) and
				not CompactUnitFrame_UtilIsPriorityDebuff(frame.displayedUnit, index, filter) and not IsPriorityDebuff(id)) then
				local debuffFrame = frame.debuffFrames[frameNum];
				CompactUnitFrame_UtilSetDebuff(debuffFrame, frame.displayedUnit, index, filter, false, false);
				frameNum = frameNum + 1;
			end
		else
			break;
		end
		index = index + 1;
	end
	end
	
	for i=frameNum, frame.maxDebuffs do
		local debuffFrame = frame.debuffFrames[i];
		debuffFrame:Hide();
	end

	ShowBigDebuffs(frame)
end)
