-- QuestLookup - Released during BFA
-- Uses the QuestID from places like WowHead to see if you have completed it.

local QuestLookup, QuestData = ...

QuestLookup = LibStub("AceAddon-3.0"):NewAddon("QuestLookup", "AceConsole-3.0", "AceEvent-3.0")

local fQuestName = ""
local fQuestId = ""
local fQuestFound = ""
local optionsFrame = ""

local MyMinimap = {
        type = "launcher",
        text = "QuestLookup",
        icon = "Interface\\Addons\\QuestLookup\\Icons\\Toby",
        OnClick = function( f, button )
                    --if button == "RightButton" then 
                      LibStub("AceConfigDialog-3.0"):Open("QuestLookup") 
                    --end
                    GameTooltip:Hide()
                  end,
        OnTooltipShow = function( mt )
                          mt:AddDoubleLine( "QuestLookup", Minimap.text )
                          mt:AddLine( "|cFFFFFFFFClick to open the the QuestLookup interface.|r" )
                        end,
} 

function QuestLookup:GetOptions()
  local options = {
    name = "QuestLookup",
    handler = QuestLookup,
    type = 'group',
    args = {
	    intro = {
		    order = 1,
			  type = "description",
			  name = "QuestLookup will determine if you have completed a quest. "
					.. "Enter some part of the quest name and the results will be displayed in the chat window.",
		  },
      qc = {
        order = 2,
        type = "input",
        name = "QuestId",
        desc = "Search to see if you have completed a quest.",
        usage = "Enter the specific ID for the quest to lookup.",
        get = "GetQuestId",
        set = "SetQuestId",
      },
      qn = {
        order = 3,
        type = "input",
        name = "QuestName",
        desc = "Search to see if you have completed a quest.",
        usage = "Enter some part of the quest name to begin.",
        get = "GetQuestName",
        set = "SetQuestName",
        width = "double",
      },
      qf = {
        order = 4,
        type = "input",
        name = "Quest Found",
        desc = "A list of the quests matching your input.",
        usage = "List of quests and completion status.",
        get = "GetQuestFound",
        set = "SetQuestFound",
        width = "full",
        multiline = 10,
      },
      cl = {
        order = 5,
        type = "execute",
        name = "Clear",
        desc = "Clear the quest entries.  It is Recommended  to 'clear' entries between each query.",
        func = "ClearVars",
      },
      mm = {    order = 6,
        type = "toggle",
        name = "Hide Minimap Icon",
        desc = "If checked, the minimap icon will be hidden.",
        get = 'GetOption',
        set = 'SetOption',
      },
    },
  }
  return options
end

-- Found this on the internet and after a couple of mods it works ok.  
-- Line gets too long to view in chat
function QuestLookup:print_table(node)
    -- to make output beautiful
    local function tab(amt)
        local str = ""
        for i=1,amt do
            str = str .. "\t"
        end
        return str
    end

    local cache, stack, output = {},{},{}
    local depth = 1
    local output_str = "{\n"

    while true do
        local size = 0
        for k,v in pairs(node) do
            size = size + 1
        end

        local cur_index = 1
        for k,v in pairs(node) do
            if (cache[node] == nil) or (cur_index >= cache[node]) then

                if (string.find(output_str,"}",output_str:len())) then
                    output_str = output_str .. ",\n"
                elseif not (string.find(output_str,"\n",output_str:len())) then
                    output_str = output_str .. "\n"
                end

                -- This is necessary for working with HUGE tables otherwise we run out of memory using concat on huge strings
                table.insert(output,output_str)
                output_str = ""

                local key
                if (type(k) == "number" or type(k) == "boolean") then
                    key = "["..tostring(k).."]"
                else
                    key = "['"..tostring(k).."']"
                end

                if (type(v) == "number" or type(v) == "boolean") then
                    output_str = output_str .. tab(depth) .. key .. " = "..tostring(v)
                    print(k,v)
                elseif (type(v) == "table") then
                    output_str = output_str .. tab(depth) .. key .. " = {\n"
                    table.insert(stack,node)
                    table.insert(stack,v)
                    cache[node] = cur_index+1
                    break
                else
                    output_str = output_str .. tab(depth) .. key .. " = '"..tostring(v).."'"
                end

                if (cur_index == size) then
                    output_str = output_str .. "\n" .. tab(depth-1) .. "}"
                else
                    output_str = output_str .. ","
                end
            else
                -- close the table
                if (cur_index == size) then
                    output_str = output_str .. "\n" .. tab(depth-1) .. "}"
                end
            end

            cur_index = cur_index + 1
        end

        if (size == 0) then
            output_str = output_str .. "\n" .. tab(depth-1) .. "}"
        end

        if (#stack > 0) then
            node = stack[#stack]
            stack[#stack] = nil
            depth = cache[node] == nil and depth + 1 or depth - 1
        else
            break
        end
    end

    -- This is necessary for working with HUGE tables otherwise we run out of memory using concat on huge strings
    table.insert(output,output_str)
    output_str = table.concat(output)

  -- print(output_str)
end

function QuestLookup:dump(obj) 
  if type(obj) == 'table' then
    local s = '{'
    for k,v in pairs(obj) do
      if type(k) == 'number' then k = '"'..k..'"' end
      s = s .. '['..k..'] = ' .. QuestLookup:dump(v) .. ','
    end
    return s .. '}'
  else
    return tostring(obj)
  end
end
  
function QuestLookup:SetOption( info, input)
    self.DB.profile.minimap.hide = input
    LibStub("LibDBIcon-1.0"):Refresh( "QuestLookup", self.DB.profile.minimap )
end
  
function QuestLookup:GetOption( info)
    return self.DB.profile.minimap.hide            
end

function QuestLookup:ClearVars(info)
    fQuestName = ""
    fQuestId = ""
    fQuestFound = ""
end

function QuestLookup:AssignQuestName(idValue)
    for key, value in pairs(QuestData.quest_table1) do
        if key == idValue then
            fQuestName = value
	        return
        end
    end
    for key, value in pairs(QuestData.quest_table2) do
        if key == idValue then
            fQuestName = value
	        return
        end
    end
    for key, value in pairs(QuestData.quest_table3) do
        if key == idValue then
            fQuestName = value
	        return
        end
    end
    for key, value in pairs(QuestData.quest_table4) do
        if key == idValue then
            fQuestName = value
	        return
        end
    end
    for key, value in pairs(QuestData.quest_table5) do
        if key == idValue then
            fQuestName = value
	        return
        end
    end
    for key, value in pairs(QuestData.quest_table6) do
        if key == idValue then
            fQuestName = value
	        return
        end
    end
    for key, value in pairs(QuestData.quest_table7) do
        if key == idValue then
            fQuestName = value
	        return
        end
    end
end

function QuestLookup:GetQuestFound(info)
    return fQuestFound
end

function QuestLookup:SetQuestFound(info, newValue)
    fQuestFound = ""
end

function QuestLookup:GetQuestName(info)
    return fQuestName
end

function QuestLookup:SetQuestName(info, newValue)
    fQuestName = ""

    -- 1 thru 10000
    for key, value in pairs(QuestData.quest_table1) do
        if (string.find(string.lower(value), string.lower(newValue))) then
            fQuestName = value
            QuestLookup:SetQuestId(info,key)
        end
    end
    -- 10001 thru 20000
    for key, value in pairs(QuestData.quest_table2) do
        if (string.find(string.lower(value), string.lower(newValue))) then
            fQuestName = value
            QuestLookup:SetQuestId(info,key)
        end
    end
    -- 20001 thru 30000
    for key, value in pairs(QuestData.quest_table3) do
        if (string.find(string.lower(value), string.lower(newValue))) then
            fQuestName = value
            QuestLookup:SetQuestId(info,key)
        end
    end
    -- 30001 thru 40000
    for key, value in pairs(QuestData.quest_table4) do
        if (string.find(string.lower(value), string.lower(newValue))) then
            fQuestName = value
            QuestLookup:SetQuestId(info,key)
        end
    end
    -- 40001 thru 50000
    for key, value in pairs(QuestData.quest_table5) do
        if (string.find(string.lower(value), string.lower(newValue))) then
            fQuestName = value
            QuestLookup:SetQuestId(info,key)
        end
    end
    -- 50001 thru 60000
    for key, value in pairs(QuestData.quest_table6) do
        if (string.find(string.lower(value), string.lower(newValue))) then
            fQuestName = value
            QuestLookup:SetQuestId(info,key)
        end
    end
    -- 60001 thru 70000
    for key, value in pairs(QuestData.quest_table7) do
        if (string.find(string.lower(value), string.lower(newValue))) then
            fQuestName = value
            QuestLookup:SetQuestId(info,key)
        end
    end
end

function QuestLookup:GetQuestId(info)
    return fQuestId
end

function QuestLookup:SetQuestId(info, newValue)
    fQuestId = newValue
    QuestLookup:AssignQuestName(newValue)
    isCompleted = IsQuestFlaggedCompleted(newValue)
    if isCompleted then
        fQuestFound = fQuestFound .. "|cFF00FF00 You have completed quest " ..
                      fQuestId .. ":" .. fQuestName .. "|r\n"
    else
        fQuestFound = fQuestFound .. "|cFFFF0000 You have not done quest " ..
                      fQuestId .. ":" .. fQuestName .. "|r\n"
    end
end

function QuestLookup:GetDefaults()
  local defaults = {
    profile = {
      minimap = { 
        hide = true,
      }
    },
  }  
  return defaults
end

-- Not using 
function QuestLookup:TotalRefresh()
    LibStub("LibDBIcon-1.0"):Refresh( "QuestLookup", self.DB.profile.minimap )    
end

function QuestLookup:OnInitialize()
    -- Called when the addon is loaded
    self.DB = LibStub( "AceDB-3.0" ):New( "QuestLookupDB", self:GetDefaults() )  

    self.Options = QuestLookup:GetOptions()

    --self.Options.args = LibStub( "AceDBOptions-3.0" ):GetOptionsTable( self.Options )    
    --local LDS = LibStub( "LibDualSpec-1.0" )
    --LDS:EnhanceDatabase( self.DB, "QuestLookup" )
    --LDS:EnhanceOptions( self.Options.args, self.DB )
    
    --self.DB.RegisterCallback( self, "OnProfileChanged", "TotalRefresh" )
    --self.DB.RegisterCallback( self, "OnProfileCopied", "TotalRefresh" )
    --self.DB.RegisterCallback( self, "OnProfileReset", "TotalRefresh" )
    
    --_G.onInitStart = self.DB.profile.enabled
    
    LibStub("AceConfig-3.0"):RegisterOptionsTable("QuestLookup", self.Options, {"ql"})
    LibStub("AceConfigDialog-3.0"):SetDefaultSize("QuestLookup", 640, 400)
    optionsFrame = LibStub("AceConfigDialog-3.0"):AddToBlizOptions("QuestLookup", "QuestLookup")
    self:RegisterChatCommand("ql", function() LibStub("AceConfigDialog-3.0"):Open("QuestLookup") end)
    
    LibStub("LibDataBroker-1.1"):NewDataObject("QuestLookup", MyMinimap);
    LibStub("LibDBIcon-1.0"):Register("QuestLookup", MyMinimap, self.DB);
    
    --local LDB = LibStub( "LibDataBroker-1.1", true )
    --local LDBIcon = LDB and LibStub( "LibDBIcon-1.0", true )
    
    --if LDB then
    --  Minimap = LDB:NewDataObject( "QuestLookup", MyMinimap )
        
      --function Minimap:RefreshDataText()
        --local p = QuestLookup.DB.profile
        --local m = p.toggles.mode.value
        --local color = "FFFFD100"
            
        --self.text = format( "|c%s%s|r %sCD|r %sInt|r %sPot|r",
        --                      color,
        --                      m == "single" and "ST" or ( m == "aoe" and "AOE" or ( m == "dual" and "Dual" or ( m == "reactive" and "rAOE" or "Auto" ) ) ),
        --                      p.toggles.cooldowns.value and "|cFF00FF00" or "|cFFFF0000",
        --                      p.toggles.interrupts.value and "|cFF00FF00" or "|cFFFF0000",
        --                      p.toggles.potions.value  and "|cFF00FF00" or "|cFFFF0000" )
      --end
        
      --Minimap:RefreshDataText()        
        
    --  if LDBIcon then
    --    LDBIcon:Register( "QuestLookup", MyMinimap, self.DB.profile.mm )
    --  end
    --end
end

function QuestLookup:ChatCommand(input)
   if not input or input:trim() == "" then
       InterfaceOptionsFrame_OpenToCategory(optionsFrame)
   else     
        LibStub("AceConfigCmd-3.0"):HandleCommand("ql", input)
   end
end

function QuestLookup:OnEnable()
    -- Called when the addon is enabled
    if self.DB.profile.minimap.hide == true then
      self:Print("QuestLookup enabled.  Minimap Icon is hidden.")
    else
      self:Print("QuestLookup enabled.  Minimap Icon is shown.")
    end
    LibStub("LibDBIcon-1.0"):Refresh( "QuestLookup", self.DB.profile.minimap )
end

function QuestLookup:OnDisable()
    -- Called when the addon is disabled
    self:Print("QuestLookup disabled.")
end
