-- ------------------------------------------------------------------------- --
-- Project: Quest Intern module for Executive Assistant 
-- Author:  VincentSDSH				
-- Localization.Lua for English
-- ------------------------------------------------------------------------- --
local AddonName = ...
local L = LibStub('AceLocale-3.0'):NewLocale(AddonName, 'enUS', true)

L.parent_AddonName = "Executive_Assistant"
L.appName = 'Executive Assistant - Quest Intern'
L.parent_appName = 'Executive Assistant'
L.StatusField_appName = 'Executive Assistant'
L.subSectionName = 'Quest Intern'
L.module = 'module'
L.appName_short = 'Intern: Quest'
L.authorName = 'VincentSDSH'
L.statusText = '%s (v%s) by %s  %s: %s'

L.module_optionsTag1 = "iquest_Options"
L.module_optionsHelp1 = "iquest_Help"

L.NewlyAddedQuests = "New Quests"

L.versionData = "Module version %s updated to WoW version %s by %s"
L.mainOpts_intro = "%s is a module for %s that discovers repeatable quests, lets you choose which to make Tasks for, and will auto-complete them when turned in.\n\nCommand Line Options: %s"
L.slashCommand = "/iQuest"

L.qi_mainPanel = "Options Panel"
L.qi_repeatable = "Repeatable"
L.qi_questhub = "Quest Hub"
L.qi_normal = "Here Be Dragons" 
L.mainOpts_text1 = "\nThe Blizzard Quest model is rather varied (and not always friendly) so a couple of approaches are needed to cover the bases for the user. In broad strokes there are Normal (Once-And-Done) Quests and Repeatable Quests. The former is pretty straight-forward but the latter has a few variants: Daily, Weekly, Account-Wide Daily, Turn-In Only, and Hubs (different quest givers and different quests available from one day to the next).\n\n"..
"For the sake of clarity, %s will lump them into three basic categories which are discussed on their own child-tab as each is handled with slight variations on a theme.\n\n"..
"%s: Static / Stand-Alone Daily or Weekly Repeatable Quest that one may go and do with confidence as the Quest is available every time.\n\n"..
"%s: Dynamic Daily or Weekly Repeatable Quest (e.g., A and B today, C and D tomorrow, etc) in an area or of a type (e.g., Blingtron) \n\n"..
"%s: Normal Quests. You'd need to be (like the Author, who uses this function) a bit daft to use this so why not go all the way and be capital-D Daft."

L.QuestTools_Label = " Quest Tools"
L.QuestTools_Name = "Quest Tools"
L.NewQuestTargetOverride_name = "Create New Quests Here"
L.NewQuestTargetOverride_desc = "New Quest Target Override"

L.mainOpts_text2 = "%s Discovers Quest as you Accept/Turn-In. For Repeatable Quests a Quest Entry is created in the Quest Intern Configuration Tab in a Group called 'New Quests' by default. At its most basic, Quest Intern acts as a Task Manager: Creating, Deleting, Checking and Unchecking Tasks linked to Quest. As with %s, it's only the beginning.\n\n"..
"%s: Creates a Normal Group, used for organization. As with %s, these may be nested and reorganized at will, and the names may contain Color Code and other Escape Code markup (see Colorizing Names in the Executive Assistant Help and Information section).\n\n"..
"%s: %s\n\n"..
"%s: Reorganization Mode Toggle. Allows Groups and Tasks to be 'Picked Up', 'Put Down', and otherwise moved about.\n\n"..
"%s: Automatically creates an %s Quest-Linked Task when a New Repeatable Quest is detected.\n\n"..
"%s: Toggles Per-Character use of this utterly insane feature for Normal Quests. See the %s tab for explanation.\n\n"..
"%s: Deletes All Completed Here-Be-Dragons!-related Executive Assistant Tasks\n\n"..
("\124T%s:%d:%d:1:0\124t"):format(([[Interface\Addons\%s\icons\QuestIntern_appIcon]]):format(AddonName), 16, 16).." %s: Default Target Group for Newly Discovered Quests. This may be overridden within the Group's properties (%s).\n\n"..
("\124T%s:%d:%d:1:0\124t"):format(([[Interface\Addons\%s\icons\QuestIntern_Tools]]):format(AddonName), 16, 16).." %s: Discover Quest IDs, Manually make Quest Entries, and Create Quest Hub Groups.\n\n"..
("\124T%s:%d:%d:1:0\124t"):format(([[Interface\Addons\%s\icons\QuestIntern_Group]]):format(AddonName), 16, 16).." Icon for Groups\n\n"..
("\124T%s:%d:%d:1:0\124t"):format(([[Interface\Addons\%s\icons\QuestIntern_tgtGroup]]):format(AddonName), 16, 16).." Icon for New Quest Target Override Groups\n\n"..
("\124T%s:%d:%d:1:0\124t"):format(([[Interface\Addons\%s\icons\QuestIntern_hubUsed]]):format(AddonName), 16, 16).." Icon for Quest Hub Groups Being Tracked\n\n"..
("\124T%s:%d:%d:1:0\124t"):format(([[Interface\Addons\%s\icons\QuestIntern_hubNotUsed]]):format(AddonName), 16, 16).." Icon for Quest Hub Groups Not Being Tracked\n\n"

L.QuestsAndTools_Label = "Quests and Tools"
L.QuestAccept = "Accepting a Quest"
L.QuestTurnIn = "Turning In"
L.QuestTurnInOnly = "Turn-In Only"
L.QuestOrphans = "Orphans"
L.How_1 = "How"
L.How_2 = "Learns..."
L.QuestsAndTools1 = "%s learns Quests as you encounter them. This may be problematic for some but it removes a dependency on mined game data and reduces basic maintenance. (And never leaves you waiting-for-the-author when new game content becomes available)\n\n"..
"%s %s %s\n\n"..
"%s: Predominately, Repeatable Quests follow the Accept/Do/Turn-In path and %s can pick up the needed data about them.\n\n"..
"%s: %s will also try to pick up a Repeatable Quest when turned in. This is crucial because some quests are Turn-In Only (see below) however if you complete a Accept/Do/Turn-In path Quest that %s isn't familiar with, it will get a bit confused. You can update the Orphan (see below) or delete the Quest Entry and let it be acquired the next time you accept the quest.\n\n"..
"%s: Because Blizzard likes to screw with addon authors -- I can think of no other reason -- some quests are Turn-In Only (e.g., Blingtron). This, in-and-of-itself isn't a problem but getting such relevant information like the Quest's Name is only obtainable with a Quest Log Index...which you only have if the Quest is in your Log...which only happens if you Accepted the Quest...which you don't...*grab more aspirin*\n\n"..
"THANKFULLY we can grab the Quest ID but we can't do a lot with it without a Datamining site (e.g., Wowhead, etc) which the user may utilize but the addon can't. What %s does do is create an Orphan Quest Entry (see below).\n\n"..
"%s: Orphan Quest Entries happen when %s is unable to obtain a Quest Name so it supplies a generic one and the Quest ID. If you realize it at the time, you can simply edit the Quest Entry and supply the name, otherwise, you can use the Quest ID at a Datamining site (e.g., Wowhead, etc) to obtain the name."


L.repeatableQuest_Label = "Repeatable Quests"
L.repeatableQuest_Help1 = "Repeatable Quests are Static / Stand-Alone Daily or Weekly Repeatable Quest that are always available each reset period and aren't tied to any other quest -- Blingtron 4000, for example, is a specific Quest and Quest Giver but shares a completion with Blingtron 5000, so they are covered in Quest Hubs.\n\n"..
"Normal Working is hands-off. Pick up a Quest, do it, Turn it in and the Quest-Linked Task in %s is automatically marked completed for you. And will be reset as any Daily or Weekly Task Type would be, readying you for the next time the Quest is available.\n\n"..
"The Quest Entry itself...\n\n"..
"When %s is enabled, the icon will show ".. ("\124T%s:%d:%d:1:0\124t"):format(([[Interface\Addons\%s\icons\QuestIntern_used]]):format(AddonName), 16, 16).." otherwise it will show "..("\124T%s:%d:%d:1:0\124t"):format(([[Interface\Addons\%s\icons\QuestIntern_notused]]):format(AddonName), 16, 16)..".\n\n"..
"%s: Toggles Tracking the Quest in %s. Tracking Enabled creates the Quest-Linked Task, Tracking Disabled will Delete the Task.\n\n"..
"You may also simply delete the Task in %s and %s will register your desire to no longer Track that Quest.\n\n"..
"%s: Rename the Group (Escape Codes may be used, see Colorizing Names in the %s Help)\n\n"..
"%s: Task Types are displayed but not resettable as this is determined by the Quest.\n\n"..
"%s: This should be provided in-game but it's not 100%% reliable."


L.QuestEntry_UnableToCreate = "Unable to create Quest Entry due to Missing Information"
L.QuestEntry_CreateQuestEntry = "Create Quest Entry"

L.questhub_CreateQuestHub = "Create Quest Hub"

L.QuestHub_HUB = "[HUB]"
L.QuestHub_HowTheyWork = "How they work"
L.QuestHub_HowToBuildThem = "How to build them"
L.QuestHub_Label = "Quest Hub"
L.QuestHub_Help1 = "A Quest Hub is a location with numerous Quests and Blizzard has expanded the concept by creating Repeatable Quest Quest Hubs who's available Quests vary from day to day. This is a great concept; it lets you do Repeatable Quests in an area, supporting a story line, while staving off the boredom of doing the very same quest day after day.\n\n"..
"Yet, because the Quests vary from day to day, you can't effectively put a particular Quest on your agenda but rather the area itself. %s uses a special type of group, a %s, to address this.\n\n"..
"A %s Group creates a Task in %s that is automatically marked Completed when all its Child Quests are marked Complete in %s. Their operation is different from stand-alone so let's look at how they work, then explain how they are constructed and used.\n\n"..
"%s: An Uncompleted %s-Linked Task is displayed for all characters you have configured it for. When a Quest of that %s is Accepted, a Task for that Quest is automatically created. Accept another and a Task for that Quest is created. Turning In each Quest will automatically Complete its Linked Task. When ALL of the Accepted %s Tasks have been Completed, the %s Task itself is completed, showing that you've completed that %s for the Day (or Week).\n\n"..
"Once the %s is Complete, if you Accept another Quest from the %s, it will be marked Uncomplete. When you Complete that Quest, the %s will again be marked Complete.\n\n"..
"The same will be true if you Abandon it: The %s will be marked Complete and the Quest-Linked Task will be Deleted.\n\n"..
"At the next Daily or Weekly reset (%s listens for %s Resets) the Automatically Created %s Quest-Linked Tasks will be automatically deleted (at each Character's Login) and the slate is clean.\n\n"..
"Quest-Linked Tasks created from %s Quests are Default-Disabled/Logged-In-Char-Enabled so the %s is usable by a\n\n"..
"Moving a Quest INTO or OUT OF a %s will cause a deletion of Executive Assistant Quest-Linked Tasks. This will change the context of the Quest Entry so any completions will be lost during the move.\n\n"..
"%s: a %s in the "..("\124T%s:%d:%d:1:0\124t"):format(([[Interface\Addons\%s\icons\QuestIntern_Tools]]):format(AddonName), 16, 16).." %s page. A %s and %s are available for ease-of-differentiation and may be edited or deleted as you choose, these will be prefixed into %s Names and %s Child Quest Names. Enter a name for the %s and press %s.\n\n"..
"Quests can be added in two ways: Reorganization (pick up some existing Quests and drop them in) or set the %s as the new Default Destination for New Quests (by enabling %s) and collecting new Repeatable Quests from the Quest Hub area.\n\n"..
"Nota Bene: %s may be placed inside other Groups but %s."
L.questhub_nochildgroups = "cannot have Groups placed inside them"

L.hubPrefix_name = "Quest Hub Prefix"
L.hubPrefix_desc = "Prefix for Quest Hub Quest Intern Group and Executive Assistant Task.\n\nThe Prefixes are intended to help differentiate these Task Types from Stand-Alone Repeatable Quest Tasks the method, format, or usage is left up to the user.\n\nThe Prefix may be altered or deleted in this field or in the subsequent Item in Quest Intern."
L.hubChildPrefix_name = "Quest Prefix"
L.hubChildPrefix_desc = "Prefix for Quest Hub Child Quests in Quest Intern and  Executive Assistant\n\nThe Prefixes are intended to help differentiate these Task Types from Stand-Alone Repeatable Quest Tasks the method, format, or usage is left up to the user.\n\nThe Prefix may be altered or deleted in this field or in the subsequent Item in Quest Intern."

L.HereBeDragons_Help1 = "This feature was never intended to exist; it's a by-product of proof-of-concept testing. It's insane. You shouldn't use it. The author uses it for leveling characters because he's Daft -- not the regular daft, mind you, capital-D Daft.\n\n"..
"Ah well, you've read this far so I might as well explain it...\n\n"..
"This feature passes through Normal Quests into %s.\n\n"..
"It auto-create a %s group for itself in %s then maintain a light-weight QuestID-to-TaskID index, so that %s can complete the Task for you, but that's all it retains. It adds Tasks when you accept a quest, Deletes them when you abandon, and checks them off when you complete them.\n\n"..
"That's it.\n\n"..
"The author uses it for tracking completed quests in a leveling area so no quests are accidentally missed. The %s group is then deleted (after saving the go-to-new-area Tasks) letting %s recreate it when the next Normal Quest is accepted.\n\n"..
"When the feature is unchecked, the QuestID-to-TaskID index is purged."


L.QuestTools_Intro = "While the vast majority of quests will work just fine, Blizzard doesn't always even pretend to play fair when it comes to quest handling. Below are several tools to help you out when, like Blingtron, they make you work for it. (An automatic setup for the Blingtron 4K/5K Daily Quests is included)\n\n"..
"For Turn-In-Only Quests like Blingtron, getting the quest data isn't possible (QuestLogIndex is needed and it's never in your Quest Log) so these will appear as an Orphan w/ a QuestID. You can use wowhead.com (http://www.wowhead.com/quest=<insert QuestID here>) or similar to convert the QuestID into a name if you don't catch it right away and just rename it in Quest Intern and use the button to update %s if you have Tasks automatically created. Even this catch isn't 100%%, as with the quest tags.\n\n"..
"For the full workaround, you can turn on Show Quest IDs, which will give you the Quest ID when Accepted/Turned-In/Abandoned. From there you can enter the QuestID, Name, and Type and manually create a Quest entry.\n\n"..
"In-line colorization is compatible with %s: Color Codes (e.g., |cffffffff|cff|cffff0066<hex color code>|cffdeb887) may be used but the escape char ( |cffffffff| |cffdeb887) should be replaced with '|cffffffff//|cffdeb887' (e.g., |cffffffff//cff|cffff0066<hex colorcode>|cff00ffaa<text>|cffffffff//r|cffdeb887). This lets you create your own tags and still see the color codes in edit fields. An example: Quest Hub Group names prepend the optional string (//cffff0066[HUB]//r) when created -- which you may find useful in Executive Assistant. Both the Quest Hub Prefix and Quest Hub Child Quest Prefix are editable below."

L.ColorizingNames_Help = "Colorizing Names Help"
L.dragonsAreSlainITellYa = "Dragons Slain! Slain, I tell you!"
L.Delete_SafetyMeasureMessage = "Press Shift to Delete. This is a safety precaution against accidental deletion."
L.blizzyOpts_blurb = "%s Configuration Dialogs can be reached with the '%s' button below. They can alternatively be reached from the DataBroker / Minimap Button, Task Window, or Command Line (/ea config).\n\n'%s' is self-explanatory.\n"
L.blizzyOpts_buttonName_config = "Open Configuration"
L.blizzyOpts_buttonName_help = "Open Help"

L.clickmap_QUEST_INTERN_name = "|cffff9966Cfg|r: Quest Intern"
L.clickmap_QUEST_INTERN_desc = "Opens Quest Intern configuration page"
L.QuestTarget_GroupName = "Quest Intern (New)"

L.QuestID = "Quest ID"
L.ExecAssistID = "ExecAssist ID"

L.AddonConfiguration = "Addon Configuration"
L.HelpAndInformation = "Help and Information" 

L.ManualQuestEntry = "Manual Quest Entry"
L.ToolsOptions = "Tools"
L.DefaultNewGroupName = "Default New Group Name"
L.newGroupName_name = "Add New Group: Group Name"
L.newGroupName_desc = "Enter the name of the new group and press the 'okay' button to create a new task group.\n\nFor Escape Codes / Color Coding, use // for | (see Colorizing Names in the Executive Assistant Help and Information section)"
L.GroupColor_config_name = "Group Name Color"
L.GroupColor_config_desc = "Only applies to this config panel to make finding child-groups easier."
L.reorg_Moving = "Moving "
L.reorg_group = "Group: "
L.reorg_task = "Task: "
L.reorg_ReorgTitle = "Reorganize Groups and Tasks"
L.reorg_PickUp = "Pick Up"
L.reorg_PickUp_desc = "Pick Up this object to move to another group"
L.reorg_PutDown = "Put Down"
L.reorg_PutDown_desc = "Put Down the moving object into this group"
L.reorg_PutInRoot = "Put In Root"
L.reorg_PutInRoot_desc = "Move the Group to the Root"

L.Reorganization_desc = "Reorganization Mode: Allows moving of Tasks and Groups"
L.Reorganization_HelpLabel = "Reorganization"
L.Reorganization_ControlName = "Reorganize"
L.Reorg_ReorgMode = "Reorganization Mode"
L.Reorg_GroupTaskConfigMode = "Group and Task Configuration Mode"
L.Reorg_GA = "Group Actions"
L.Reorg_TA = "Quest Actions"
L.GroupOptions = "Group Options"
L.groupactions = "Group Actions"
L.UP_moveGroup = "Moves Group Up in the Display Order\n\nHold SHIFT to move to the Top"
L.DOWN_moveGroup = "Moves Group Down in the Display Order\n\nHold SHIFT to move to the Bottom"
L.deleteGroup_name = "Delete Group"
L.deleteGroup_desc = "Removes the selected Group. SHIFT key must be pressed."
L.addGroup_name ="Add Group"
L.addGroup_desc ="Adds a New Group a the Bottom of the Group"
L.groupName_rename_name = "Rename Group"
L.groupName_rename_desc = "Rename the group by entering a new one.\n\nFor Escape Codes / Color Coding, use // for | (see Colorizing Names in the Executive Assistant Help and Information section)"
L.taskactions = "Quest Actions"
L.UP_moveTask = "Moves Quest Up in the Display Order\n\nHold SHIFT to move to the Top"
L.DOWN_moveTask = "Moves Quest Down in the Display Order\n\nHold SHIFT to move to the Bottom"
L.task_deleteTask_name = "Delete"
L.task_deleteTask_desc = "Removes the selected Quest. SHIFT key must be pressed."
L.taskName_name = "Rename Quest"
L.taskName_desc = "Enter new Name for Quest\n\nFor Escape Codes / Color Coding, use // for | (see Colorizing Names in the Executive Assistant Help and Information section)"
L.enter_taskName = "Enter Quest Name"
L.task_AcctWide_name = "Account Wide Task"
L.task_AcctWide_desc = "Make the Task Account-Wide (e.g., Blingtron). When one char completes the Task, it will show completed for all characters."
L.QuestOptionsHeader = "Quest Options"

L.eaTgtGroup_Dragons = "Here Be Dragons"
L.QuestTarget_GroupName_Dragons = "Here Be Dragons!"

L.Dragons_OUT = "Dragons be slain. Slain I tell you! (And internal tracking has been cleared)"
L.Dragons_IN = "Eek! Dragons!! Eeeeeeeek!! (And now keeping track of new Normal Quests)"
L.Dragons_name = "Here Be Dragons"
L.Dragons_desc = "\nDO NOT USE unless you are as daft as the author.\n\nThis will cause EVERY Quest to be created as a Task, regardless (but only Repeating Quests will appear on the left).\n\nThe author uses this while leveling in an area to create a 'quest history' which is purged when leaving an area by deleting the Quest Intern Target Group in Executive Assistant proper, since it will auto-create.\n\nDO NOT BE LIKE THE AUTHOR.\n\nSAVE YOURSELF WHILE YOU CAN!"
L.AutoAdd_name = "Auto-Track New Repeatable Quests"
L.AutoAdd_desc = "Automatically Track New Repeatable Quests In Executive Assistant"
L.OrphanQuest_prefix = "Orphaned Quest ("
L.OrphanQuest_suffix = ")"

L.TrackInExecAssist_name = "Track and AutoComplete in Executive Assistant"
L.TrackInExecAssist_desc = "Toggle Track and AutoComplete in Executive Assistant"
L.TrackQuestHubinExecAssist_name = "Track Quest Hub in Executive Assistant"
L.TrackQuestHubinExecAssist_desc = "Toggle Track Quest Hub in Executive Assistant"

L.Blingtron = "Blingtron"
L.Blingtron4K = "Blingtron 4000"
L.Blingtron5K = "Blingtron 5000"
L.Blingtron6K = "Blingtron 6000"
L.BlingtronRemake_button = "Remake Blingtron"
L.BlingtronRemake_desc = "\nRemakes the Blingtron Quest Hub Group if you accidentally delete it.\n\nClean up any vestiges of the old groups, in both Executive Assistant and Quest Intern or things can get a bit weird."
L.toggleHelp_name = "Show Intro Help"
L.toggleHelp_desc = "Show Introduction / Help Text"
L.showQuestID_name = "Show Quest IDs"
L.showQuestID_desc = "Show Quest IDs for Add, Complete, and Remove Events"

L.resetType_name = "Task Type"
L.resetType_desc = "Select the Type of Task this is (see the Help for explanations)\n\nEnabled Modules and Interns may add Task Types; if a Task is marked as using one of these and the Module or Intern is disabled, the Task Type will be 'Missing Module'"

L.lessDragons_name = "Slay Dragons!"
L.lessDragons_desc = "Deletes All Completed Here-Be-Dragons!-related Executive Assistant Tasks"
