-- ------------------------------------------------------------------------- --
-- Project: Quest Intern module for Executive Assistant 
-- Author:  VincentSDSH				
-- ------------------------------------------------------------------------- --
local AddonName = ...
local debug = function(...) exQM.LEA_debug(exQM, ...) end
local L   = LibStub("AceLocale-3.0"):GetLocale(AddonName)
local exL = LibStub("AceLocale-3.0"):GetLocale(L.parent_AddonName)
local QuestIntern_Controls -- dynamically created, pruned, and maintained so it's made context-local but it still needs to be self.[*] aware so it's loaded in regOptions
local GROUP_IDENTIFIER, TASK_IDENTIFIER = "g", "t"
local MOVE_UP, MOVE_DOWN = "UP", "DOWN"
	-- Initialize Options: reg opt tables & add to blizz opts
local function simpleTcopy(tOri) local tNew = {} if tOri then for i=1,#tOri do tNew[i]=tOri[i] end end return tNew end 

function exQM:regOptions()
	local sdbg, sdbc = self.db.global, self.db.char

	local function mkHeader(hdrName, numOrder, label) -- Give Me Similar Headers Or Give Me Death ----
		return { 
							order = true and numOrder or 0, 
							type = "description", 
							fontSize = "large",
							name = function()
								-- :doUpdateStatusField() placed /here/ is a full-on cheat to update the status field when tabs change
								--   Not the worst kludge/cheat I've done in the past few decades but there really seems no way to 
								--   trap cleanly the opt-table change in the standard Ace library. And this /is/ simple and clean...
								ExecAssist:doUpdateStatusField( label or hdrName ) -- , nil (not native)
								return hdrName:cf("fuglyYellow").."\n"
							end
					 }
	end

	-- module controls (see :getControls_OptionTable() for injection)
	QuestIntern_Controls = { -- Add Control Elements to the safetable in loadGroups_toOptionsTable or the pruner WILL EAT THEM
	  type = "group", 
		order = 900,
	 	name = L.subSectionName:cf("grass"),
		args = {
			header = mkHeader(L.subSectionName),
			intro = {
				order = 1,
				type = "description",
				fontSize = "medium",
				name = (L.mainOpts_intro):format(
							L.appName:cf("EAtan", "cream"),
							L.parent_appName:cf("EAtan", "cream"),
							L.slashCommand:cf("afternoon", "cream")
				),
			},			
			addGroup_Group = {
				type = "group",
				name = "",
				desc = "",
				inline = true,
				order = 90,
				args = {		
		      newGroupName = {
		      	name = L.newGroupName_name,
		      	desc = L.newGroupName_desc,
		      	type = "input",
		      	width= "double", 
		      	order = 10,
		      	get = function() return nil end, -- want it to remain blank
		      	set = function(i, v) 
		      		v=v:gsub("//", "|")
							local groupID = self:AddGroup(v) -- NB: THIS add will always be in the .garden, nil will default it to .garden
							self:loadGroups_toOptionsTable()
		      	end,
		      },
					GroupColor = {
				    order = 20,
				    type = "color",
				    name = L.GroupColor_config_name,
				    desc = L.GroupColor_config_desc,
				    get = function()
				        local col = sdbg.Options.cfg_groupColor
				        return col.r, col.g, col.b
				    end,
				    set = function(info, r, g, b)
				        local col = sdbg.Options.cfg_groupColor
				        col.r = r or 0
				        col.g = g or 0
				        col.b = b or 0
				        self:loadGroups_toOptionsTable() -- refresh and pick up colors
				    end,
				  },		      
					Reorg = {
					  name = L.Reorganization_ControlName ,
					  desc = L.Reorganization_desc,
					  type = "toggle",
					  order = 22,
						get = function() return exQM.isReorging end,
						set = function(i, v)    
							exQM.isReorging = v; 
							self:loadGroups_toOptionsTable(); 
							if not v then 
								exQM.reorgObjectName = nil; 
								exQM.reorgObjectID = nil;
								self:loadGroups_toOptionsTable() -- Ugly but needed to clear the moving-text. Gotta be a better way.
							end 
						end,
					},	
					autoAdd_toExecAssist = {
						order = 125, 
						type = "toggle", 
						width = "double",
						name = L.AutoAdd_name, 
						desc = L.AutoAdd_desc,
						get = function(info) return sdbc.autoAdd_toExecAssist end,
						set = function(info, value) sdbc.autoAdd_toExecAssist = value end,
					},	
					glutton_for_punishment = {
						order = 130, 
						type = "toggle", 
						name = L.Dragons_name, 
						desc = L.Dragons_desc,
						get = function(info) return sdbc.autoAdd_ALL_toExecAssist end,
						set = function(info, value) 
							sdbc.autoAdd_ALL_toExecAssist = value; 
							if value==true then 
								self:alert(L.Dragons_IN) -- sane as it gets @ 4:26am
							else 
								sdbc.HereBeDragons = {} -- Nope, no more dragons. Dragons all gone. Not even chocolate dragons. User will have to clean up any remaining unwanted Tasks.
								self:alert(L.Dragons_OUT)
							end 
						end,
					},	

					less_punishment = {
						order = 131, 
						type = "execute", 
						name = L.lessDragons_name,
						desc = L.lessDragons_desc,
			      disabled  = function() return not sdbc.autoAdd_ALL_toExecAssist end,
						func = function()				
							if IsShiftKeyDown() then
								for questID, taskID in pairs(sdbc.HereBeDragons) do
									if self:getChecked(taskID) then -- if checked, complete, nix
										self:Delete_Task(taskID)
										sdbc.HereBeDragons[questID] = nil
									end
								end
								self:alert(L.dragonsAreSlainITellYa)
							else
								self:alert(L.Delete_SafetyMeasureMessage)
							end	
						end,	
					},	
				},				
			},
		}		
	} 

	-- Options Tables 
	blizzy_Opts = {
		--hdr = {order=0, type="header", name="<header name>"}, 
		type = "group",
		order = 10,
		name = self:mkLink(self.icons.defaultLDBIcon, 22).." "..L.appName,
		args = {
			introspacer = { order = 4, type = "description", name = "  "}, 
			intro = {
				order = 5,
				type = "description",
				fontSize = "medium",
				name = (L.mainOpts_intro):format(
							L.appName:cf("EAtan", "cream"),
							L.parent_appName:cf("EAtan", "cream"),
							L.slashCommand:cf("cyan", "cream")
				),
			},		
			quickDirections = {
				type = "group",
				order = 10,
				name = "  ",
				inline = true,
				args = {			
					intro1 = {
						order = 1,
						type = "description",
						fontSize = "medium",
						name = (L.blizzyOpts_blurb):format(
							L.appName:cf("EAtan", "cream"),
							L.blizzyOpts_buttonName_config:cf("cyan", "cream"),
							L.blizzyOpts_buttonName_help:cf("cyan", "cream")
						),
					},
					configure = {
					  type = "execute",
					  name = (L.blizzyOpts_buttonName_config):cf("white"),
					  order = 50,
						func = function() self:doLoadConfig(); GameTooltip:Hide(); InterfaceOptionsFrameCancel:Click(); end, 
					},							
					help = {
					  type = "execute",
					  name = (L.blizzyOpts_buttonName_help):cf("white"),
					  order = 60,
						func = function() self:doLoadHelp(); GameTooltip:Hide(); InterfaceOptionsFrameCancel:Click(); end, 
					},							
				}							
			},

			verionData = {
				order = 20,
				type = "description",
				fontSize = "medium",
				name = ((L.versionData):cf("cream")):format(GetAddOnMetadata(AddonName, 'Version'):cf("grass", "cream"), self.wowVer:cf("grass", "cream"), L.authorName:cf("EAtan")),
			},

		},
	}
	-- Register Blizzy Options Tables, associate with ExecAssist's panel
	local RegOpts = LibStub("AceConfigRegistry-3.0")
	RegOpts:RegisterOptionsTable(AddonName, blizzy_Opts)	--------- Blizzy Opts -
	self.Dialog:AddToBlizOptions(AddonName, L.subSectionName,  LibStub("AceLocale-3.0"):GetLocale("Executive_Assistant").appName)
end 
function exQM:intern_getOptionsPanel()
	return L.module_optionsTag1, QuestIntern_Controls
end
function exQM:intern_getExtendedHelp()
	local iquest_Help_OptTable = {
				type = "group",
				name = ("%s: %s"):format( L.module:cf("white", "cyan"), L.subSectionName),
				order=900, 
				args = {
					hdr = {order=0, type="header", name= L.subSectionName}, 
					intro = { order = 1, type = "description", fontSize = "medium",
						name = (L.mainOpts_intro):format( L.appName:cf("EAtan", "cream"), L.parent_appName:cf("EAtan", "cream"), L.slashCommand:cf("afternoon", "cream") )
					},
					
					text1 = { order = 10, type = "description", fontSize = "medium",
						name = (L.mainOpts_text1):cf("cream"):format(
							L.appName:cf("EAtan", "cream"),
							L.qi_repeatable:cf("sky", "cream"),
							L.qi_questhub:cf("sky", "cream"),
							L.qi_normal:cf("sky", "cream")
						)
					},
					hdr2 = {order=20, type="header", name= L.qi_mainPanel}, 
					text2 = { order = 30, type = "description", fontSize = "medium",
						name = (L.mainOpts_text2):cf("cream"):format(
							L.subSectionName:cf("EAtan", "cream"),
							L.parent_appName:cf("EAtan", "cream"),
							L.newGroupName_name:cf("sky", "cream"),
							L.parent_appName:cf("EAtan", "cream"),

							L.GroupColor_config_name:cf("sky", "cream"),
							L.GroupColor_config_desc,
							L.Reorganization_ControlName:cf("sky", "cream"),
							L.AutoAdd_name:cf("sky", "cream"),
							L.parent_appName:cf("EAtan", "cream"),
							L.Dragons_name:cf("sky", "cream"),
							L.Dragons_name:cf("sky", "cream"),
							L.lessDragons_name:cf("sky", "cream"),
							L.NewlyAddedQuests:cf("grass", "cream"),
							L.NewQuestTargetOverride_name:cf("sunshine", "cream"),
							L.QuestTools_Name:cf("grass", "cream")
						)
					},

					child1 = {
						order = 50,
						type = "group",
						name = L.QuestsAndTools_Label,
						args = {
							hdr = {order=0, type="header", name=L.QuestsAndTools_Label},
							intro = {
								order=1,
								type = "description",
								fontSize = "medium",
								name = L.QuestsAndTools1:cf("cream"):format(
									L.appName:cf("EAtan", "cream"),
									L.How_1:cf("white", "EAtan"),
									L.subSectionName,
									L.How_2:cf("white", "cream"),
									L.QuestAccept:cf("sky", "cream"),
									L.subSectionName :cf("EAtan", "cream"),
									L.QuestTurnIn:cf("sky", "cream"),
									L.subSectionName:cf("EAtan", "cream"), 
									L.subSectionName:cf("EAtan", "cream"), 
									L.QuestTurnInOnly:cf("sky", "cream"),
									L.subSectionName:cf("EAtan", "cream"), 
									L.QuestOrphans:cf("sky", "cream"),
									L.subSectionName:cf("EAtan", "cream")							
								),
							}
						}
					},
					child2 = {
						order = 60,
						type = "group",
						name = L.repeatableQuest_Label,
						args = {
							hdr = {order=0, type="header", name=L.repeatableQuest_Label},
							intro = {
								order=1,
								type = "description",
								fontSize = "medium",
								name = L.repeatableQuest_Help1:cf("cream"):format(
									L.parent_appName:cf("EAtan", "cream"),
									L.TrackInExecAssist_name:cf("grass", "cream"),
									L.TrackInExecAssist_name:cf("grass", "cream"),
									L.parent_appName:cf("EAtan", "cream"),
									L.parent_appName:cf("EAtan", "cream"),
									L.subSectionName:cf("EAtan", "cream"),
									L.taskName_name:cf("sky", "cream"),
									L.parent_appName:cf("EAtan", "cream"),
									L.resetType_name:cf("sky", "cream"), 
									L.task_AcctWide_name:cf("sky", "cream")
								),

							}
						}
					},			
					child3 = {
						order = 70,
						type = "group",
						name = L.qi_questhub,
						args = {
							hdr = {order=0, type="header", name=L.qi_questhub},
							intro = {
								order=1,
								type = "description",
								fontSize = "medium",
								name = L.QuestHub_Help1:cf("cream"):format(
									L.subSectionName:cf("EAtan", "cream"),
									L.QuestHub_Label:cf("grass", "cream"),
									L.QuestHub_Label:cf("grass", "cream"),
									L.parent_appName:cf("EAtan", "cream"),
									L.parent_appName:cf("EAtan", "cream"),
									L.QuestHub_HowTheyWork:cf("white", "cream"),
									L.QuestHub_Label:cf("grass", "cream"),
									L.QuestHub_Label:cf("grass", "cream"),
									L.QuestHub_Label:cf("grass", "cream"),
									L.QuestHub_Label:cf("grass", "cream"),
									L.QuestHub_Label:cf("grass", "cream"),
									L.QuestHub_Label:cf("grass", "cream"),
									L.QuestHub_Label:cf("grass", "cream"),
									L.QuestHub_Label:cf("grass", "cream"),
									L.QuestHub_Label:cf("grass", "cream"),
									L.QuestHub_Label:cf("grass", "cream"),
									L.QuestHub_Label:cf("grass", "cream"),
									L.QuestHub_Label:cf("grass", "cream"),
									L.QuestHub_Label:cf("grass", "cream"),
									L.QuestHub_Label:cf("grass", "cream"),
									L.QuestHub_Label:cf("grass", "cream"),
									L.QuestHub_HowToBuildThem:cf("white", "cream"),
									L.QuestHub_Label:cf("grass", "cream"),
									L.QuestTools_Name:cf("sky", "cream"),
									L.hubPrefix_name:cf("cyan", "cream"),
									L.hubChildPrefix_name:cf("cyan", "cream"),
									L.QuestHub_Label:cf("grass", "cream"),
									L.QuestHub_Label:cf("grass", "cream"),
									L.QuestHub_Label:cf("grass", "cream"),
									L.questhub_CreateQuestHub:cf("sunshine", "cream"),
									L.QuestHub_Label:cf("grass", "cream"),
									L.NewQuestTargetOverride_name:cf("cyan", "cream"),
									L.QuestHub_Label:cf("grass", "cream"),									
									L.questhub_nochildgroups:cf("sky", "cream")

								),
							}
						}
					},
					child4 = {
						order = 80,
						type = "group",
						name = L.qi_normal,
						args = {
							hdr = {order=0, type="header", name=L.qi_normal},
							intro = {
								order=1,
								type = "description",
								fontSize = "medium",
								name = L.HereBeDragons_Help1:cf("cream"):format(
									L.parent_appName:cf("EAtan", "cream"),
									L.qi_normal:cf("cyan", "cream"),
									L.parent_appName:cf("EAtan", "cream"),
									L.subSectionName:cf("EAtan", "cream"),
									L.qi_normal:cf("cyan", "cream")
								),
							}
						}
					},

					
				}                   			
			}		
	return L.module_optionsHelp1, iquest_Help_OptTable
end
function exQM:intern_getInjectedControls(hTask)
	--[[ Injector Notes  -----------------------------------------------------
	 Accessing vars is a PITA; they have to derive ExecAssist context
	 	NB: this can possibly diminish what a module can accomplish
	
	 local hTask = ExecAssist.db.global.groupStem.agg[ info[ #info-n ] ]	
	 ...where n is the # of controls offsetting form the taskID root
	 Handy checker: for n = 1,#info do print(tostring(n)..": "..info[n]) end
	-- -------------------------------------------------------------------- -- 
	 To Inject controls individually (or a series of groups) use:
	local tcontrols = {
    	hdr200 = {order=720, type="header", name="<control name>"}, 
    	hdr300 = {order=730, type="header", name="<control name>"}, 
    	group400={type="group", name="<group name>", order=740, inline=true,
    		args = {}
    	}
	}
	-- -------------------------------------------------------------------- -- 
	 To ALTER EXISTING CONTROLS simply over-write their key name; this can
	 hide, disable, or change existing controls as needed
	-- -------------------------------------------------------------------- -- 
	 To Inject nothing, return nil 
	--]] ---------------------------------------------------------------------
	local ResetTypes = ExecAssist.taskTypes_Index -- ExecAssist.optValues.ResetTypes
	local controls={
		resetType= {
			name = L.resetType_name,
			desc = L.resetType_desc,
			type="select",
			order = 110,
			disabled = true,
			values = ResetTypes, -- ExecAssist.optValues.ResetTypes,
			get = function(info) 
				local resetType = hTask.resetType 
				for i=1, #ResetTypes do if ResetTypes[i] == resetType then return i end end
			end,
			set = function(info, v) end, 
		},			
	}
	
	return controls
end
  -- -------------------------------------------------------  :regOpts -- 

  -- Sanity Functions
local function getUniqueElementID(eType) 
	local function mkNewID(eType) return eType..tostring(math.random(999999)) end; 
	
	local aggStem = exQM.db.global.groupStem.agg; 
	local eID = mkNewID(eType); 
	while aggStem[eID] do eID = mkNewID end; 
	
	return eID		
end
local function hardPrune_InternControls(Genealogy)
	-- Does a hard-prune of the TACM OptTable for removing groups and tasks (or anything in the 'Genealogy' table passed)
	local G, pos = Genealogy, QuestIntern_Controls.args
	for i = 1, #G do
		if i==#G then
			pos[G[i].id] = nil
		else
			pos = pos[G[i].id].args
		end
	end
	return pos
end
function exQM:semiSmart_regrow(Genealogy)
	-- Prunes part of the optTable and regrows it (move up/down/etc, anything sibling related that isn't properly updated)
	-- Doesn't work in the Garden b/c of nil-parentage

	local pos = hardPrune_InternControls(Genealogy)
	local G = simpleTcopy(Genealogy)
	local optOrder = G[#G].oo
	local groupID = table.remove(G, #G).id  -- Have to take out the last gene b/c it's passed to AddSingleGroup to be 'combined'

	pos[ groupID ] = self:AddSingleGroup(groupID, optOrder, G )	
end

	-- Reorganize Funcs
function exQM:reorg_PickUp(hElement_move) 
		-- Store object Vital Operational Data
	exQM.reorgObjectID = hElement_move.id; 
	if self:isGroup(hElement_move.id) then
		exQM.reorgObjectName = (L.reorg_group):cf("white")..hElement_move.listName:cf("cream")
	else
		exQM.reorgObjectName = (L.reorg_task):cf("white")..hElement_move.taskName:cf("cream") 
	end

		-- Ug, horribly bruit force; the control doesn't refresh with other data change...have to rebuild all elements to have it diplay. blech.
	self:loadGroups_toOptionsTable()
end 
function exQM:reorg_SetDown(hGroup)
	local agg = self.db.global.groupStem.agg
	local hReorgItem         = agg[exQM.reorgObjectID]
	local hFormerParentGroup = agg[hReorgItem.p]
	
		-- Wipe Element Hook Storage
	exQM.reorgObjectID   = nil  					
	exQM.reorgObjectName = nil

	if hFormerParentGroup.id ~= hGroup.id then  -- if adding back to the same parent, we just need to clear the reorg objectid
			-- Unadoption:  Remove object from former parent Display Order
		for i=1,#hFormerParentGroup.DO do if hFormerParentGroup.DO[i] == hReorgItem.id then table.remove(hFormerParentGroup.DO, i) end end	

			-- Adoption
		table.insert(hGroup.DO, hReorgItem.id) 		-- Add to New Parent Display Order
		hReorgItem.p = hGroup.id               		-- Reassign Reorged Item's Parent
				
		if self:isTask(hReorgItem.id) then
			-- Tasks change their behavior type when moved into/out-of Quest Hubs; they must abandon their old life...
			if hFormerParentGroup.isHub then
				self:purgeHubData_ofQuestID(hReorgItem, hFormerParentGroup)	
			end
			-- ...and take on the new one
			if hGroup.isHub then -- only Tasks can be PutDown in a Quest Hub
				-- remove stand-alone Tracking
				if hReorgItem.ExecAssist_ID then self:Quest_TrackInExecAssist(hReorgItem, false) end
			
				if GetQuestLogIndexByID(hReorgItem.questID) > 0 then -- if we have the quest in the log, re-express it
					self:promptHubBehavior_forNewQuest(hReorgItem, hGroup)
				end				
			else
				-- if coming from a hubGroup, all data has been removed, so treat it like a 'new quest' re auto-add
				if hFormerParentGroup.isHub and self.db.char.autoAdd_toExecAssist then
					if GetQuestLogIndexByID(hReorgItem.questID) then -- if we have the quest in the log, re-express it
						self:Quest_TrackInExecAssist(hReorgItem, true)
					end
				end
				-- Moving from one stand-alone Group to another stand-alone Group shouldn't modify anything other than the Quest Entry location data
			end
		end
		
			-- Ug, horribly bruit force; should use smart-pruner/-regrower
		self:loadGroups_toOptionsTable()		
	end
end
	-- Move Func
function exQM:moveElement(hElement, direction)   -- MOVE_UP, MOVE_DOWN (works for Tasks and Groups)
	local DO = self.db.global.groupStem.agg[hElement.p].DO
	local tmp
	
	if IsShiftKeyDown() then -- move to TOP or BOTTOM
		for i=1,#DO do
			if DO[i] == hElement.id then
				table.remove(DO, i)
				break;
			end
		end

		if direction==MOVE_UP then 				table.insert(DO, 1, hElement.id)
		elseif direction==MOVE_DOWN then  table.insert(DO, hElement.id) -- bottom
		else alert("Bad Shift+Move Parameter: "..tostring(direction).." (developer must need more sleep or coffee or both)")
		end
	else
		for i=1,#DO do
			if DO[i] == hElement.id then
				if direction==MOVE_UP then        tmp = DO[i-1]; DO[i-1] = DO[i]			
				elseif direction==MOVE_DOWN then  tmp = DO[i+1]; DO[i+1] = DO[i]			
				else alert("Bad Move Parameter: "..tostring(direction).." (developer must need more sleep or coffee or both)")
				end
				DO[i] = tmp
				break;
			end
		end
	end

end
 	-- Add Funcs	
function exQM:AddGroup(groupName, hParent) -- hParent = handle group creating the child Group
	local groupStem = self.db.global.groupStem
	local groupID = getUniqueElementID(GROUP_IDENTIFIER)
	if not hParent then hParent = groupStem.agg["garden"] end

	-- Add Default Group
	local hGroup = self:rCopyTable(self.prototype.Group)
	groupStem.agg[groupID] = hGroup
	hGroup.listName = groupName or L.DefaultNewGroupName
	hGroup.p = hParent.id
	hGroup.id = groupID
	
	-- Insert in proper Display Order
	table.insert(hParent.DO, groupID) -- adds the group to the bottom... 

	-- Update GroupMaintenance var
	self:loadGroups_toOptionsTable()
		
	return groupID
end
function exQM:AddTask(hGroup, positioning_taskID, suppressRefresh_cmdline)
	if type(hGroup) == "string" then hGroup = self.db.global.groupStem.agg[hGroup] end

	local taskID = getUniqueElementID(TASK_IDENTIFIER) 
	local hTask = self:rCopyTable(self.prototype.Task)
	self.db.global.groupStem.agg[taskID] = hTask
	
	hTask.p = hGroup.id
	hTask.id = taskID
	
--	if not hGroup then hGroup = self.db.global.groupStem.agg[groupID] end

	if positioning_taskID then for i=1,#hGroup.DO do if hGroup.DO[i] == positioning_taskID then table.insert(hGroup.DO, i+1, taskID) end end
	else table.insert(hGroup.DO, taskID) -- adds to display order bottom
	end
	
	
	return hTask
end
function exQM:addQuestTask(questName, questID, questType)
	local sdbg = self.db.global
	local hGroup = sdbg.groupStem.agg[sdbg.NewQuestTargetOverride or sdbg.NewQuestHomeID]
	local hTask = exQM:AddTask(true and hGroup or sdbg.NewQuestHomeID, nil, true)

	if hTask then	
		hTask.taskName  = questName
		hTask.questID   = questID
		hTask.resetType = questType

		self:semiSmart_regrow(sdbg.groupStem.agg[ hGroup.id ].G) -- add to options table	
		return hTask, hGroup
	end
end

	-- Delete Funcs
function exQM:DeleteGroup(hGroup, Genealogy, noDOupdate, trashBin) -- remove all associated flags in charStem
	-- noDOupdate is used when deleting child groups to keep them from pruning themselves from parent DOs
	local sdbg = self.db.global
	local groupStem = sdbg.groupStem
	local aggStem = groupStem.agg
	local DO = hGroup.DO

	local parentDO = aggStem[hGroup.p].DO
	if not trashBin then trashBin = {} end
	table.insert(trashBin, hGroup.id)

		-- check cmdLine Target
	if sdbg.NewQuestTargetOverride == hGroup.id then sdbg.NewQuestTargetOverride = nil end
	
		-- process the display order, 
	for i=1,#DO do
		if self:isGroup(DO[i]) then 
			self:DeleteGroup(aggStem[DO[i]], nil, true, trashBin) 
		end -- run recursively, no G, suppress Parent Update, send the garbage pail

		table.insert(trashBin, DO[i]) -- for cleaning charStem/acctwideStem 
		aggStem[DO[i]] = nil					-- Bedtime for Bonzo
	end

	local groupID = hGroup.id		-- suicide note 
	aggStem[hGroup.id] = nil 		-- good buy cruel world

	if not noDOupdate	then
		-- remove from parent
		for i=1,#parentDO do if parentDO[i] == groupID then table.remove(parentDO, i); break; end end
			
		-- Remove group from active OptTable
		hardPrune_InternControls(Genealogy)

		-- Garbage Collection: clean groups and task fragments from charStem and acctwideStem
		self:GarbageCollection(trashBin)
		
	end	
	
end
function exQM:DeleteTask(hTask, Genealogy)  -- remove all associated flags in charStem
	local groupStem = self.db.global.groupStem
	local aggStem, tinder = groupStem.agg, groupStem.tinder
	local hGroup = aggStem[hTask.p]
	local taskID, groupID = hTask.id, hTask.p -- store so we can nix hTask

	-- Remove group from Display Order
	for i=1,#hGroup.DO do if hGroup.DO[i] == taskID then table.remove(hGroup.DO, i) end end

  local p = simpleTcopy(Genealogy)
  table.insert(p, {["id"] = hTask.id, ["oo"] = 0}) -- put the chicken on the chopping block
 	hardPrune_InternControls(p)  

	-- clean out charStem and aggStem
	self:GarbageCollection({hTask.id})

	-- Remove Group from db and Options Table 
	tinder[hTask.questID] = nil -- nuke
	aggStem[hTask.id]     = nil -- nuke	
end
	-- Garbage Collection
function exQM:GarbageCollection(trashBin)
	local sdbg = self.db.global
	local charStem_base, AWagg = sdbg.charStem, sdbg.acctwideStem.agg
	
	-- empty out charStem agglomerations	
	for charName, charStem in pairs(charStem_base) do
		for i=1,#trashBin do 
			if charStem.agg[trashBin[i]] then charStem.agg[trashBin[i]] = nil end
		end
	end
	
	-- Cleanup Fragmental Data
	for i=1,#trashBin do 	
		-- empty out account wide agglomeration
		if AWagg[trashBin[i]] then AWagg[trashBin[i]] = nil end
		
		-- empty out Collapse Map
		-- NOTE: Moved to :pushCollapseMap() and processes current character only. 
		-- 	CM garbage is a storage problem and isn't looked up by the dataBuilder
		--  Pruning it out is kind to the .sv file and memory but it's a small amount of data so chucking it out at login 
		--  is sufficient and it rechecks all IDs; doing it here forces GC on /all/ characters, traversing the .sv.char...
		-- Opting for 'ease of maintenance' over 'optimization'
	end

end	
-- ------------------------------------------------------------------------------------ --
function exQM:purgeHubData_ofQuestID(hTask, hGroup)
	if hGroup.TrackQuestHub then
		-- Removing Quest Entry so All Quest-Linked Tasks have to go...							
		for char, hubData in pairs(hGroup.hubDataFor) do
			if hubData and hubData[hTask.questID] then self:Quest_TrackInExecAssist(hTask, false, hubData) end								
		end
	end
	self:assessHub(hGroup)
end
function exQM:promptHubBehavior_forNewQuest(hTask, hGroup)
	if hGroup.TrackQuestHub then
		hGroup.hubIsActiveFor[ self:getCurrentUser() ] = true
		if not hGroup.hubDataFor[ self:getCurrentUser() ] then hGroup.hubDataFor[ self:getCurrentUser() ] = {} end
		local hubData = hGroup.hubDataFor[ self:getCurrentUser() ]
		self:Quest_TrackInExecAssist(hTask, true, hubData) -- hTask, beginTracking, hubData (quest hub)
		self:setChecked( hGroup.hubID_show, false )
	end		
end
function exQM:TargetIsInLineage(hGroup)
	local agg, hpGroup = self.db.global.groupStem.agg, {}
	while hpGroup.id ~= "garden" do
		hpGroup = agg[ hGroup.p ] 
		if hpGroup.id == exQM.reorgObjectID then return true
		else hGroup = hpGroup
		end	
	end	
end
function exQM:ExecAssist_tgtGroup(tgtType)
	local groupStem = self.db.global.groupStem
	
	local tgtGroupID_key, tgtGroup_name
	
	if tgtType == L.eaTgtGroup_Dragons then
		tgtGroupID_key = "ExecAssistTargetGroup_HereBeDragons"
		tgtGroup_name = L.QuestTarget_GroupName_Dragons
	else
		tgtGroupID_key = "ExecAssistTargetGroup"	
		tgtGroup_name = L.QuestTarget_GroupName
	end
	
	local function mk_tgtGroup() groupStem[tgtGroupID_key] = self:Create_Group(nil, tgtGroup_name)	end	
	
	if groupStem[tgtGroupID_key] then if not self:getHandle(groupStem[tgtGroupID_key]) then mk_tgtGroup() end	-- create it	
	else mk_tgtGroup() -- create it	
	end
	
	return groupStem[tgtGroupID_key]
end
function exQM:Quest_TrackInExecAssist(hTask, isTracking, hubData, ExecAssist_AlreadyDeleted)
	local groupStem = self.db.global.groupStem
	local phonebook = groupStem.phonebook
	if isTracking then
		local setDefault, setChar
		if hubData then setDefault = false; setChar = 2; end

		local ea_taskID, ea_groupID = self:Create_Task( exQM:ExecAssist_tgtGroup(), (hubData and groupStem.hubStyle.hubChildPrefix or "")..hTask.taskName,  hTask.resetType)
		self:Edit_Task(ea_taskID, nil, nil, setDefault, setChar, hTask.isAcctWide) -- hideDays, forUser=defaultCurrent]
		phonebook[ea_taskID] = hTask.id

		if hubData then
			hubData[hTask.questID] = ea_taskID
		else
			hTask.ExecAssist_ID = ea_taskID -- remember			
			hTask.inExecAssist = true;
		end

	else
		if hubData then
			if hubData[hTask.questID] then
				phonebook[hTask.questID] = nil
				if not ExecAssist_AlreadyDeleted then self:Delete_Task(hubData[hTask.questID]) end -- hubData reactors create a loop otherwise
				hubData[hTask.questID] = nil
			end
		else		
			if hTask.ExecAssist_ID then self:Delete_Task(hTask.ExecAssist_ID) end
				-- Obviated; the deleteHandler takes care of this as it respond to the Delete_Task()
				-- phonebook[hTask.ExecAssist_ID] = nil
				-- hTask.ExecAssist_ID = nil
				-- hTask.inExecAssist = nil;	
		end
	end
end

function exQM:loadGroups_toOptionsTable()
	-- debug("exQM:loadGroups_toOptionsTable() Called")
	local sdbc, sdbg = self.db.char, self.db.global
	local hubStyle = sdbg.groupStem.hubStyle
	local garden = sdbg.groupStem.agg["garden"].DO -- NB: Garden is /always/ a group, if the user wants a simple list then can make 1 group w/ hide the group in the display
	local optOrder = 0
	-- Prune Options Table of Task Groups so they aren't duplicated or lingering after removal. 
	-- 		Not exactly best-practice but there doesn't seem to be any other way but using hammers, bloody immature frameworks
		local safetable = {["header"] = true, ["intro"]=true, ["addGroup_Group"]=true, ["ShowQuestIDs"] = true, ["HandleSpecialQuests"] = true, ["prefooter"]=true, ["footer"]=true}
	for k,v in pairs(QuestIntern_Controls.args) do if not safetable[k] then QuestIntern_Controls.args[k] = nil end end
	
	-- Reload from garden
	for i=1, #garden do
		local Genealogy = {}
		local groupID = garden[i]
		optOrder = optOrder+10
		QuestIntern_Controls.args[ groupID ] = self:AddSingleGroup(groupID, optOrder, Genealogy )
	end

	-- Special Handling Group (nb: this is regrown b/c there's a possibility of dynamic control use)
	local manualQuest = {
		["questName"] = nil,
		["questID"]   = nil,
		["resetType"] = 1,		
	}
	local QuestHub = {["questName"] = nil	}
	QuestIntern_Controls.args["ToolsGroup"] = {
		type = "group",
		icon = self.icons.tool,
		name = (L.QuestTools_Label):cf("sky", false), 
		desc = "",		
		order = 999999, -- b/c even though the docs say -1=absolute bottom, it doesn't always place it there.
		args = {		
			header = {name = ("Quest Tools"):cf("fuglyYellow"), order = 0, type = "description", fontSize = "large"},				
			intro = {
				order = 10, hidden = not sdbg.ShowToolIntro,
				type = "description", fontSize = "medium",
				name = "\n"..(L.QuestTools_Intro):cf("cream"):format(L.parent_appName:cf("EAtan", "cream"), L.parent_appName:cf("EAtan", "cream") ),
			},
			help = { 
			  type = "execute",
			  width="double",
			  name = (L.ColorizingNames_Help):cf("white"),
			  order = 11, hidden = not sdbg.ShowToolIntro,
				func = function() ExecAssist:doLoadHelp("ColorCodes"); GameTooltip:Hide(); end, 
			},							
			remkBlingtron = { 
			  type = "execute",
			  name = (L.BlingtronRemake_button):cf("white"),
			  desc = L.BlingtronRemake_desc,
			  order = 12, hidden = not sdbg.ShowToolIntro,
				func = function() self:mkBlingtronQuestHub(); self:loadGroups_toOptionsTable() end, 
			},	

			header2 = {order=90, type="header", name=L.ToolsOptions},
			toggleHelp = {
				order = 100, 
				type = "toggle", 
				--width="double",
				name = L.toggleHelp_name, 
				desc = L.toggleHelp_desc,
				get = function(info) return sdbg.ShowToolIntro end,
				set = function(info, value) sdbg.ShowToolIntro = value; GameTooltip:Hide(); self:loadGroups_toOptionsTable() end,
			},	
			ShowQuestIDs = {
				order = 110, 
				type = "toggle", 
				name = L.showQuestID_name, 
				desc = L.showQuestID_desc,
				get = function(info) return sdbc.ShowQuestIDs end,
				set = function(info, value) sdbc.ShowQuestIDs = value end,
			},	
			header3 = {order=190, type="header", name=L.ManualQuestEntry},
			taskName = {
		  	name = L.enter_taskName,
		  	desc = "",
		  	type = "input",
		  	width="double",
		  	order = 200,
		  	get = function() return manualQuest.questName and manualQuest.questName:gsub("|", "//") or nil end,
		  	set = function(i, v) manualQuest.questName = v:gsub("//", "|") end,
			},
			questID = {
		  	name = "QuestID",
		  	desc = "",
		  	type = "input",
		  	order = 210,
		  	get = function() return manualQuest.questID end,
		  	set = function(i, v) 
		  		if tonumber(v) then manualQuest.questID = v 
		  		else manualQuest.questID = nil; self:alert("Quest IDs are numbers") 
		  		end 
		  	end,
			},			
			resetType= {
				name = L.resetType_name,
				desc = L.resetType_desc,
				type="select",
				order = 230,
				values = {exL.DailyAutomatic, exL.WeeklyAutomatic},
				get = function(info) return manualQuest.resetType or 1 end,
				set = function(info, v) manualQuest.resetType=v end, 
			},
 			CreateQuestTracker = {
			  type = "execute",
			  width="full",
			  name = L.QuestEntry_CreateQuestEntry:cf("white"),
			  order = 250,
				func = function() 
						if (manualQuest.questName and manualQuest.questName ~= "") and manualQuest.questID and manualQuest.resetType then
							self:addQuestTask(
								manualQuest.questName, 
								manualQuest.questID, 
								manualQuest.resetType==1 and exL.DailyAutomatic or exL.WeeklyAutomatic
							) 
							self:loadGroups_toOptionsTable()
						else
							self:alert(L.QuestEntry_UnableToCreate)
						end
				end, 
			},					

			header4 = {order=300, type="header", name="Quest Hub"},

			hubPrefix = {
		  	name = L.hubPrefix_name,
		  	desc = L.hubPrefix_desc,
		  	type = "input",
		  	order = 305,
		  	get = function() return hubStyle.hubPrefix:gsub("|", "//") or nil end,
		  	set = function(i, v) hubStyle.hubPrefix = v:gsub("//", "|") end,
			},
			hubChildPrefix = {
		  	name = L.hubChildPrefix_name,
		  	desc = L.hubChildPrefix_desc,
		  	type = "input",
		  	order = 310,
		  	get = function() return hubStyle.hubChildPrefix:gsub("|", "//") or nil end,
		  	set = function(i, v) hubStyle.hubChildPrefix = v:gsub("//", "|") end,
			},

			HubName = {
		  	name = "Quest Hub Name",
		  	desc = "",
		  	type = "input",
		  	width="double",
		  	order = 320,
		  	get = function() return QuestHub.questName and QuestHub.questName:gsub("|", "//") or nil end,
		  	set = function(i, v) QuestHub.questName = v:gsub("//", "|") end,
			},
 			CreateQuestHub = {
			  type = "execute",
			  width="full",
			  name = L.questhub_CreateQuestHub:cf("white"),
			  order = 330,
				func = function() 
					if (QuestHub.questName and QuestHub.questName ~= "") then
						local groupID = self:AddGroup(hubStyle.hubPrefix..QuestHub.questName) -- garden
						if groupID then
							local hGroup = self.db.global.groupStem.agg[groupID]
							hGroup.isHub = true
							hGroup.resetType = exL.DailyAutomatic -- default
							hGroup.hubIsActiveFor = {}
							hGroup.hubDataFor = {}
							self:loadGroups_toOptionsTable()
						end
					else
						self:alert("Unable to create Quest Hub due to Missing Information")
					end
				end, 
			},	

		},
	}

end

function exQM:AddSingleGroup(groupID, optOrder, Genealogy)
	local sdbg = self.db.global
	local ttStem = sdbg.tooltip
	local G = simpleTcopy(Genealogy)  
	local hGroup = sdbg.groupStem.agg[groupID]
	table.insert(G, {["id"] = groupID, ["oo"] = optOrder})
  hGroup.G = G 
	return  {
		type = "group", 

		icon = function() if self.db.global.NewQuestHomeID == groupID then 
						return self.icons.defaultLDBIcon 
					 elseif sdbg.NewQuestTargetOverride == groupID then
					 	return self.icons.tgtgroup
					 else 
					 	return self.icons.group 
					 end 
		end,
		name = (hGroup.isHub and (hGroup.TrackQuestHub and self:mkLink(self.icons.hubGroup_Used, 12) or self:mkLink(self.icons.hubGroup_NotUsed, 12)).." " or "")..hGroup.listName:cfc(self:tbl_pcColorToHex(sdbg.Options.cfg_groupColor)),
	 	order = optOrder,
		args = self:loadTasks_toGroup_inOptionsTable( groupID, G, optOrder, gpGroup_optOrder )
	}	
end

function exQM:loadTasks_toGroup_inOptionsTable(groupID, Genealogy)
	local hGroup = self.db.global.groupStem.agg[groupID]
	local sdbc = self.db.char
	local sdbg = self.db.global

	-- Add Group Options
	local T = {
		whoami = {
			hidden=not exQM.db.sv.debug,
			order=0,
			width="full",
			fontSize = "large",
			name="GroupID: "..hGroup.p.." / GroupID: "..hGroup.id,
			type="description",
		},	

		-- group 0
		hdr0 = {order=3, type="header", hidden = not self.isReorging, name=L.reorg_ReorgTitle}, 
		ReorgNameDisplay = {
			order = 10,
			type = "description",
			hidden = not exQM.reorgObjectName,
			fontSize = "medium",
			name = ("%s: %s"):cf("cream"):format( 
				(L.reorg_Moving):cf("grass", "cream"),
				(true and exQM.reorgObjectName or ""):cf("grass", "cream")
			),
		},				  
		reorg_PickUpObject = {
			name = L.reorg_PickUp,
		  desc = L.reorg_PickUp_desc,
		  type = "execute",
		  hidden = not exQM.isReorging,
		  disabled  = function() end,
		  order = 20,
		  width="half",
			func = function() self:reorg_PickUp(hGroup) end,				
		},
		reorg_PutDownObject = {
			name = L.reorg_PutDown,
		  desc = L.reorg_PutDown_desc,
		  type = "execute",
			hidden = function () return (not exQM.isReorging) or (not exQM.reorgObjectID) end,
		  disabled  = function() return exQM.reorgObjectID==hGroup.id or self:TargetIsInLineage(hGroup) or (hGroup.isHub and self:isGroup(exQM.reorgObjectID)) end,
		  order = 30,
		  width="normal",
			func = function() 
				self:reorg_SetDown(hGroup) 
				if hGroup.isHub then self:assessHub(hGroup) end
			end,
		},
		reorg_PutInRoot = {
			name = L.reorg_PutInRoot,
		  desc = L.reorg_PutInRoot_desc,
		  type = "execute",
			hidden = function(info) return (not exQM.isReorging) or (not exQM.reorgObjectID) or ( exQM.reorgObjectID ~= info[#info-1])  end,
		  disabled  = function() if hGroup.p == "garden" then return true end end,
		  order = 40,
		  width="normal",
			func = function() self:reorg_SetDown(exQM.db.global.groupStem.agg["garden"]) end,				
		},		
		    	
		hdr1 = {order=50, type="header", hidden = self.isReorging, name=L.groupactions}, 
		UP_moveGroup = {
			name = "^^^",
		  desc = L.UP_moveGroup,
		  type = "execute",
		  hidden = exQM.isReorging,
		  disabled  = function() 
		  	local DO = self.db.global.groupStem.agg[hGroup.p].DO
				if DO[1] == groupID then return true end 
		  end,
		  order = 55,
		  width="half",
			func = function() 
				self:moveElement(hGroup, MOVE_UP)
		
				local p = simpleTcopy(Genealogy)
				if #p >= 2 then 
					table.remove(p, #p)
					self:semiSmart_regrow(p)			
				else -- When moving the Garden, we have to move everything anyway & 'garden' isn't a 'real' tree element
					-- ideally it'd just be swapping order= but, alas...						
					self:loadGroups_toOptionsTable()							
				end
			 end,
		},
		DOWN_moveGroup = {
			name = "vvv",
		  desc = L.DOWN_moveGroup,
		  type = "execute",
		  hidden = exQM.isReorging,
		  disabled  = function() 
		  	local DO = self.db.global.groupStem.agg[hGroup.p].DO
			  if DO[#DO] == groupID then return true end 
		  end,
		  order = 60,
		  width="half",
			func = function() 
				self:moveElement(hGroup, MOVE_DOWN) 
			
				local p = simpleTcopy(Genealogy)
				if #p >= 2 then 
					table.remove(p, #p) 
					self:semiSmart_regrow(p)					
				else -- When moving the Garden, we have to move everything anyway & 'garden' isn't a 'real' tree element
					self:loadGroups_toOptionsTable()							
				end
		
			end,
		},
		deleteGroup = {
		  name = L.deleteGroup_name,
		  desc = L.deleteGroup_desc,
		  type = "execute",
		  hidden = exQM.isReorging,
		  disabled = sdbg.NewQuestHomeID == hGroup.id and true or false,
		  order = 65,
			func = function() 
				if IsShiftKeyDown() then
					self:DeleteGroup(hGroup, Genealogy) 
					
				else
					self:alert(L.Delete_SafetyMeasureMessage)
				end						
			end,
		},		
		addGroup = {
			name = L.addGroup_name,
		  desc = L.addGroup_desc,
		  width="normal",
		  type = "execute",
		  hidden = exQM.isReorging,
		  order= 70,
			func = function(INFO) 
				local groupID = self:AddGroup(nil, hGroup) 

				local t = {}
				for n = 1, #Genealogy do table.insert(t, Genealogy[n].id) end
				table.insert(t, 1, L.module_optionsTag1)
				table.insert(t, groupID)
				self.Dialog:SelectGroup(ExecAssist.opts.f_reg, unpack(t) )	
			end,
		},

		-- line 1
    hdr_ExecAssist = {order=80, type="header", hidden = not hGroup.isHub, name=L.parent_appName}, 
		TrackQuestHubinExecAssist = {
		  name = L.TrackQuestHubinExecAssist_name,
		  desc = L.TrackQuestHubinExecAssist_desc,
		  type = "toggle",
		  width="full",
		  hidden = not hGroup.isHub,
		  order = 85,
			get = function() return hGroup.TrackQuestHub end,
			set = function(i, v) 
				local groupStem = self.db.global.groupStem
				local agg, phonebook = groupStem.agg, groupStem.phonebook
				hGroup.TrackQuestHub = v

				if v then
					table.insert( sdbg.groupStem.hubs, hGroup.id) -- to catch any Reset pulses from ExecAssist
					local ea_groupID
					hGroup.hubID_show, ea_groupID = self:Create_Task( exQM:ExecAssist_tgtGroup(), hGroup.listName, hGroup.resetType)
					self:Edit_Task(hGroup.hubID_show, nil, nil, nil, nil, hGroup.isAcctWide	)
					phonebook[hGroup.hubID_show] = hGroup.id
					
					-- see if any quests are in the Log and part of this Group; make EA Tasks if so
					local questLogIndex
					for n=1,#hGroup.DO do
						hTask = agg[ hGroup.DO[n] ]
						questLogIndex = GetQuestLogIndexByID(hTask.questID)
						if questLogIndex > 0 then
							self:promptHubBehavior_forNewQuest(hTask, hGroup)
						end
					end

				else
					-- Does not cleanup .hubs; worst that happens from a DailyReset pulse is some extra (harmless) purge calls
					self:assessHub(hGroup)
				end
				
				self:semiSmart_regrow(Genealogy) 
			end,
		},	
		QuestHubAcctWide = {
		  name = L.task_AcctWide_name,
		  desc = L.task_AcctWide_desc,
		  hidden = not hGroup.isHub,
		  type = "toggle",
		  order = 95,
			get = function() return hGroup.isAcctWide end,
			set = function(i, v) hGroup.isAcctWide = v end,
		},
		QuestHubResetType= {
			name = exL.resetType_name,
			desc = exL.resetType_desc,
			type="select",
		  hidden = not hGroup.isHub,
			order = 90,
			values = {exL.DailyAutomatic, exL.WeeklyAutomatic},
			get = function() return hGroup.resetType == exL.DailyAutomatic and 1 or 2 end,
			set = function(info, v) 
				if v==1 then hGroup.resetType = exL.DailyAutomatic 
				else hGroup.resetType = exL.WeeklyAutomatic 
				end
			end, 
		},
		debug_forceAssess= {
      hidden = not exQM.db.sv.debug or not hGroup.isHub,
    	name = "debug_forceAssess", type = "execute", order = 905, width="double",
			func = function() self:assessHub(hGroup) end,
    },		
				
		-- group 2
		hdr2 = {order=204, type="header", name="Group Options"}, 
		spacer1 = {order = 219,type = "description", width="full", name = " "},			
		groupName = {
		 	name = L.groupName_rename_name,
		 	desc = L.groupName_rename_desc,
		 	type = "input",
		 	width="full",
		 	order = 220,
		 	get = function() return hGroup.listName:gsub("|", "//") end,
		 	set = function(i, v) hGroup.listName = v:gsub("//", "|"); self:semiSmart_regrow(Genealogy) end, 
		},
	
		NewQuestTargetOverride = {
		  name = L.NewQuestTargetOverride_name,
		  desc = L.NewQuestTargetOverride_desc,
		  type = "toggle",
		  width="double",
		  order = 214,
		  hidden = groupID == sdbg.NewQuestHomeID,
			get = function() return groupID == sdbg.NewQuestTargetOverride end,			
			set = function(i, v)
				if v then 
					sdbg.NewQuestTargetOverride = groupID 
				else
					sdbg.NewQuestTargetOverride = nil 
				end
			end,
		},
	}

	local groupDO = self.db.global.groupStem.agg[groupID].DO -- group Handle	
	for i=1, #groupDO do 
		if self:isGroup(groupDO[i]) then -- send back to do the group thing
			T[groupDO[i]] = self:AddSingleGroup(groupDO[i], i, Genealogy)
		else -- do the task thing
			T[groupDO[i]] = self:AddSingleTask(groupDO[i], i, Genealogy)
		end		
	end

	return T
end

function exQM:AddSingleTask(taskID, optOrder, Genealogy, pGroup_optOrder)
	local sdbc  = self.db.char
	local groupStem = self.db.global.groupStem
	local hTask = groupStem.agg[taskID]

	return {
		icon = function() 
			local hGroup = groupStem.agg[ hTask.p ]
			if hGroup.isHub then
				if hGroup.TrackQuestHub then
					local hubData = hGroup.hubDataFor[ self:getCurrentUser() ]
					return (hubData and hubData[hTask.questID]) and self.icons.used or self.icons.notused 
				else
					return self.icons.notused
				end
			else
				return hTask.inExecAssist and self.icons.used or self.icons.notused
			end		
		end,
		type = "group", 
		name = function() return hTask.taskName end, 
		order = optOrder,
		args = {
			whoami = {
				hidden=not exQM.db.sv.debug,
				order=0,
				width="full",
				fontSize = "large",
				name="GroupID: "..hTask.p.." / TaskID: "..taskID,
				type="description",
			},	

			-- line 0
    	hdr_top = {order=1, type="header", hidden = groupStem.agg[hTask.p].isHub, name=L.parent_appName}, 
			TrackInExecAssist = {
			  name = L.TrackInExecAssist_name,
			  desc = L.TrackInExecAssist_desc,
			  type = "toggle",
			  hidden = groupStem.agg[hTask.p].isHub,
			  width="full",
			  order = 2,
				get = function() return hTask.inExecAssist end,
				set = function(i, v)    
					self:Quest_TrackInExecAssist(hTask, v)
					self:semiSmart_regrow(Genealogy) 
				end,
			},	
			
			-- line 1
    	hdr0 = {order=3, type="header", hidden = not exQM.isReorging, name=L.reorg_ReorgTitle}, 
			ReorgNameDisplay = {
				order = 4,
				type = "description",
				hidden = not exQM.reorgObjectName,
				fontSize = "medium",
				name = ("%s: %s"):cf("cream"):format( 
					(L.reorg_Moving):cf("grass", "cream"),
					(true and exQM.reorgObjectName or ""):cf("grass", "cream")							
				),
			},					  	    
			reorg_PickUpObject = {
	    	name = L.reorg_PickUp,
	      desc = L.reorg_PickUp_desc,
	      type = "execute",
	      hidden = not exQM.isReorging,
	      disabled  = function() end,
	      order = 5,
	      width="half",
				func = function() self:reorg_PickUp(hTask) end,				
	    },

    	hdr1 = {order=8, type="header", hidden = exQM.isReorging, name=L.taskactions}, 
			UpdateExecAssist = {
	    	name = "Update ExecAssist",
	      desc = "Update Task in Executive Assistant",
	      disabled = not hTask.inExecAssist, 
	      type = "execute",
				-- width="double",
	      order = 9,
				func = function()
					self:Edit_Task(hTask.ExecAssist_ID, hTask.taskName, nil, nil, nil, hTask.isAcctWide)
				end,
	    },

			UP_moveTask = {
	    	name = "^^^",
	      desc = L.UP_moveTask,
	      type = "execute",
	      hidden = exQM.isReorging,
	      disabled  = function()
	      	local DO = self.db.global.groupStem.agg[hTask.p].DO
	      	if DO[1] == taskID then return true end
	      end,
	      order = 10,
	      width="half",
				func = function() self:moveElement(hTask, MOVE_UP); self:semiSmart_regrow(Genealogy)	end,				
	    },
			DOWN_moveTask = {
	    	name = "vvv",
	      desc = L.DOWN_moveTask,
	      type = "execute",
	      hidden = exQM.isReorging,
	      disabled  = function() 
	      	local DO = self.db.global.groupStem.agg[hTask.p].DO
	      	if DO[#DO] == taskID then return true end
	      end,
	      order = 20,
	      width="half",
				func = function() self:moveElement(hTask, MOVE_DOWN); self:semiSmart_regrow(Genealogy)	end,
	    },
			deleteTask = {
	    	name = L.task_deleteTask_name,
	      desc = L.task_deleteTask_desc,
	      width="half",
	      type = "execute",
	      hidden = exQM.isReorging,
	      order = 40,
				func = function()
					if IsShiftKeyDown() then
						-- cleanup ExecAssist Tasks
						local hGroup = groupStem.agg[ hTask.p ]
						if hGroup.isHub then
							self:purgeHubData_ofQuestID(hTask, hGroup)
						else
							if hTask.ExecAssist_ID then self:Delete_Task(hTask.ExecAssist_ID) end						
						end

						self:DeleteTask(hTask, Genealogy) -- remove Quest Entry from Quest Intern
					else
						self:alert(L.Delete_SafetyMeasureMessage)
					end
				end,
	    },

	    -- line 2
    	hdr2 = {order=89, type="header", name=L.QuestOptionsHeader}, 
			taskName = {
		  	name = L.taskName_name,
		  	desc = L.taskName_desc,
		  	type = "input",
		  	width="full",
		  	order = 100,
		  	get = function() return hTask.taskName:gsub("|", "//") end,
		  	set = function(i, v) hTask.taskName = v:gsub("//", "|") end,
			},
			resetType= {
				name = L.resetType_name,
				desc = L.resetType_desc,
				type="select",
				order = 110,
				disabled = true,
				values = ExecAssist.taskTypes_Index, -- ExecAssist.optValues.ResetTypes,
				get = function(info) 
					local ResetTypes = ExecAssist.taskTypes_Index
					for i=1, #ResetTypes do 
						if ResetTypes[i] == hTask.resetType then 
							return i 
						end 
					end

				end,
				set = function(info, v) end, 
			},
			AcctWide = {
			  name = L.task_AcctWide_name,
			  desc = L.task_AcctWide_desc,
			  type = "toggle",
			  order = 120,
				get = function() return hTask.isAcctWide end,
				set = function(i, v) hTask.isAcctWide = v end, 
			},

			spacer_qid = {order = 900,type = "description", width="full", name = " "},			
			questid = {
				order=901,
				type="description",
				name=("%s: %s"):format(
					L.QuestID:cf("EAtan", "white"),
					tostring(hTask.questID):cf("cream") -- questIDs are numbers
				),
			},	
			ea_taskID = {
				order=902,
				type="description",
				hidden = not hTask.inExecAssist,
				name=("%s: %s"):format(
					L.ExecAssistID:cf("EAtan", "white"),
					(true and hTask.ExecAssist_ID or "uh oh..."):cf("cream")
				),
			},		
			debug_forceComplete	= {
	      hidden = not exQM.db.sv.debug,
	    	name = "debug_forceComplete", type = "execute", order = 905, width="double",
				func = function() self:Quest_TurnedIn("DEBUG_FAUX_TURN_IN", hTask.questID) end,
	    },
		},
	}	

end
